/**
*
* name          dynatest - test the dynamic link function of OS/2
* author        Ralph Yozzo
*
* usage         dynatest
*
* compiler      ET
*
* command
* used to       et e
* compile
*
* description   This program shows the usage of OS/2 dynamic linkage.
*     2.3.8.1  Dynamic Linking
*     Dynamic linking is the delayed binding of application program external
*     references to subroutines.  There are two forms of dynamic linking --
*     load time and run time.
*
*     In load time dynamic linking, a program calls a dynamically linked
*     routine just as it would any external routine.  When the program is
*     assembled or compiled, a standard external reference is generated.  At
*     link time, the programmer specifies one or more libraries which
*     contain routines to satisfy external references.  External routines to
*     be dynamically linked contain special definition records in the
*     library.  A definition record tells the linker that the routine in
*     question is to be dynamically linked and provides the linker with a
*     dynamic link module name and entry name.  The module name is the name
*     of a special executable file with the filename extension of .DLL which
*     contains dynamic link entry points.  The linker stores module
*     name/entry name pairs describing the dynamic link routines in the
*     executable file created for the program.  When the calling program is
*     run, OS/2 loads the dynamic link routines from the modules specified
*     and links the calling program to the called routines.  (os/2 technical
*     reference)
*
**/
defc dynatest=
   result=dynalink('DOSCALLS',      /* dynamic link library name       */
                   '#50',           /* ordinal value for DOSBEEP       */
                   \255\0\255\0)    /* stack string                    */

   call getkey()                    /*                                 */

   string='hello'                   /* input string                    */

   result=dynalink('VIOCALLS',      /* dynamic link library name       */
                   'VIOWRTTTY',     /* Video Input Output WRiTe TeleTYpe */
                   selector(string)|| /* string selector               */
                   offset(string)|| /* string offset                   */
                   atoi(length(string))|| /* length of string          */
                   atoi(0))         /* Vio Handle */


   call getkey()
   string =  '?????'                /* result buffer                   */
   result=dynalink('DOSCALLS',      /* dynamic link library name       */
                   '#127',          /* ordinal value for DOSMEMAVAIL   */
                   selector(string)|| /* string selector               */
                   offset(string))    /* string offset                 */
   sayerror 'memavail = ' string 'itoa(hex) = ' itoa(string,16)
   call getkey()
   sayerror 'memavail = ' string 'memavail(hex) = ' hex_to_string(string)
   call getkey()

/*********************************************************************/
/* Do not do the following as it will cause a protection violation.  */
/* The number of parameters placed on the stack is wrong.            */
/*********************************************************************/
;  string =  '?????'
;  result=dynalink('DOSCALLS',
;                  '#127',
;                  selector(string)||
;                  offset(string)||
;                  atoi(0))       /* WRONG!  Too many parameters stacked */
;  sayerror 'memavail = ' string 'memavail(hex) = ' hex_to_string(string)

   string =  atoi(80) || substr('',1,80)  /* create input strings for  */
   stringlen = substr('',1,4)             /* DOSQCURDIR                */
   result=dynalink('DOSCALLS',
                   '#71',
                   atoi(0)||               /* Drive number - 1=A, etc */
                   selector(string)||      /* Directory path buffer */
                   offset(string)||
                   selector(stringlen)||   /* Directory path buffer length */
                   offset(stringlen))
   sayerror  'len = ' hex_to_string(stringlen) 'current dir = ' string

defc dynaparm=
   parse value arg(1) with module procedure stack
   result=dynalink(module,procedure,stack)

defc atoitest=
   sayerror 'atoi = ' hex_to_string(atoi(arg(1)))

defc atoltest=
   sayerror 'atol = ' hex_to_string(atol(arg(1)))

defc seltest=
   universal dynalinkvariable
   sayerror 'selector = ' hex_to_string(selector(dynalinkvariable))

defc offtest=
   universal dynalinkvariable
   sayerror 'offset = ' hex_to_string(offset(dynalinkvariable))


defproc hex_to_string(string)
   line = ''
   for i = 1 to length(string)
      line= line || hex(substr(string,i,1)) || ' '
   endfor
   return line

defc itoause=
   sayerror 'itoa = ' itoa(atoi(arg(1)),10)

defc ltoause=
   sayerror 'ltoa = ' ltoa(atol(arg(1)),10)

defc itoatest=
   sayerror 'itoa = ' itoa(arg(1),10)

defc ltoatest=
   sayerror 'ltoa = ' ltoa(arg(1),10)

defproc beep(pitch,duration)
   result=dynalink('DOSCALLS',      /* dynamic link library name       */
                   '#50',           /* ordinal value for DOSBEEP       */
                   atoi(pitch)||    /* Hertz (25H-7FFFH) */
                   atoi(duration))  /* Length of sound  in ms */

defc beeptest=
   parse value arg(1) with pitch duration
   call beep(pitch,duration)

defc testcolor
   sayerror 'color_mode()='color_mode()'.'

-- Returns 1 if color, 0 if mono.
defproc color_mode()
   if machine()='OS2PROTECT' then
      ModeData=atoi(12)||'tCccrrhhvv'  /* data structure, length first    */
      result=dynalink('VIOCALLS',            /* dynamic link library name */
                      'VIOGETMODE',          /* Get display mode          */
                      selector(ModeData) ||  /* string selector           */
                      offset(ModeData)   ||  /* string offset             */
                      atoi(0))               /* Vio Handle                */
      -- Bit 1 is 1 if color.
      type = itoa(substr(ModeData,3,1),10)  -- single-byte number
      if 2*(type%2) = type then
         return 0
      endif
      return 1
   else
      result=int86x(16,15*256,0)
      parse value result with ax .
      al = ax // 256
      if al=0 or al=2 or al=7 then
         return 0
      endif
      return 1
   endif

defc windowtest=
   parse value arg(1) with writerow writecolumn string
   sayerror 'rc=' window(string,writerow,writecolumn,0,0,0,0)

defproc window(string,writerow,writecolumn,row,column,width,depth)
   return dynalink('VIOCALLS',            /* dynamic link library name */
                   'VIOWRTCHARSTR',       /* video input/output call   */
                   selector(string)   ||  /* string selector           */
                   offset(string)     ||  /* string offset             */
                   atoi(length(string)) ||/* length of string          */
                   atoi(writerow)     ||  /* write at row position     */
                   atoi(writecolumn)  ||  /* write at col position     */
                   atoi(0))               /* reserved                  */

defc windowattr=
   parse value arg(1) with writerow writecolumn attribute string
   sayerror 'rc=' windowattr(string,writerow,writecolumn,0,0,0,0,attribute) rc

defc dynamic=
   parse value arg(1) with attribute writerow
   if attribute = '' then
      attribute = 79
   endif
   if writerow = '' then
      writerow  = 1
   endif
   swriterow=writerow
   call windowattr('  Creating a program which calls a dynamic link routine   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  TEST.ASM                                                ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ŀ                      Ŀ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('extern RUNIT:far                      extern RUNIT:far',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('     .              ͻ     Ĵ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('     .                OS/2            Ŀ   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                > Assembler >   Code       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  call RUNIT                             ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                    ͼ       Ŀ   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('     .                                   Data       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('     .                                     ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                      ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                      ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call getkey()
   writerow=swriterow

   call windowattr('                                                         ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  OS2SUBS.LIB                                            ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ŀ                                       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('SORT    0089       ͻ                      ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ĵ      OS/2                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('DISPLAY 3710   > Linker    <ͼ         ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ĵ                                      ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('RUNIT   0123       ͼ                       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ĵ                                       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('ADM     8778                                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                            V                             ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call getkey()
   writerow=swriterow

   call windowattr('                     Ŀ                   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                     EXE Header                         ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                     Ĵ                   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr(' DLR=                Ĵ                   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr(' Dynamic Link        DLROS2SUBS0123                   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr(' Reference Record    Ĵ                   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                       Ŀ                      ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                        Code                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                             ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                       Ŀ                      ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                        Data                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                             ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                        ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                        ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call getkey()
   writerow=swriterow

   call windowattr('   Running a dynamic-link program                          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  TEST.EXE                               OS2SUBS.DLL       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ŀ                       Ŀ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('EXE Header                             EXE Header      ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ĵ                       Ĵ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ĵ                        OS2SUB_code    ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('DLROS2SUBS0123                         Ŀ    ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('Ĵ                         SORT        ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  Ŀ   ͻ       ͵  Ĵ    ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('   TestCode                          RUNIT       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                            Ĵ    ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  Ŀ                          DISPLAY     ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('   TestData        V       V           Ĵ    ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('        ͻ         ADM         ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                     OS/2                  ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('    Loader             Ŀ ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                         OS2SUB_data ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                     ͼ          ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                        ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                           V                               ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call getkey()
   writerow=swriterow

   call windowattr('Memory                                                     ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('ͻ ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  Ŀ                             OS2SUB_code  ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr(' ڴ Test_code Ŀ          Ŀ   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                             SORT       ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr(' Ŀ                            Ĵ   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  Test_data                   >RUNIT      ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                               Ĵ   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('  Ŀ                          DISPLAY    ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('   OS2SUB_data  <                        Ĵ   ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('   ĴADM        ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                               ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('ͼ ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1
   call windowattr('                                                           ',writerow,5,0,0,0,0,attribute);writerow=writerow+1

defproc windowattr(string,writerow,writecolumn,row,column,width,depth,attribute)
   attr=atoi(attribute)
   return dynalink('VIOCALLS',            /* dynamic link library name */
                   'VIOWRTCHARSTRATT',    /* video input/output call   */
                   selector(string)   ||  /* string selector           */
                   offset(string)     ||  /* string offset             */
                   atoi(length(string)) ||/* length of string          */
                   atoi(writerow)     ||  /* write at row position     */
                   atoi(writecolumn)  ||  /* write at col position     */
                   selector(attr)     ||  /* attribute to replicate    */
                   offset(attr)       ||  /*                           */
                   atoi(0))               /* reserved                  */
defc lentest=
   string='hello'                   /* input string                    */
   sayerror 'dynalink:'||
          dynalink('VIOCALL'\0,     /* dynamic link library name       */
                   'VIOWRTTTY',     /* Video Input Output WRiTe TeleTYpe */
                   selector(string)|| /* string selector               */
                   offset(string)|| /* string offset                   */
                   atoi(length(string))|| /* length of string          */
                   atoi(0))         /* Vio Handle */

defc rytime=
   datetime='12345678901234567890'
   call dynalink('DOSCALLS',      /* dynamic link library name       */
                 '#33',           /* ordinal value for DOSGETDATETIME*/
                 selector(datetime)|| /* string selector               */
                 offset(datetime))  /* string offset                   */
   call messageNwait('datetime <' datetime '>')
   call messageNwait('datetime <' hex_to_string(datetime) '>')
   call messageNwait('datetime <' dec_to_string(datetime) '>')
   string =  dec_to_string(datetime)
   call messageNwait('string <' string '>')
   parse value string with hour minute second hundred day month year0 year1 .
   call messageNwait('time:' hour||':'||minute||':'||second||'.'|| hundred ||
                     ' date: 'day ||'/'|| month ||'/'||year0 + 256*year1)

