; Customization information:  Any of the following customization constants can
; be overridden by including the appropriate definition after a CONST statement
; in your MYCNF.E.  The addenda filename and dictionary filename were formerly
; overridden by a file EOS2LCUS.E.  We no longer support that.
;
; Example of customization:  include the following lines in your MYCNF.E
; (with the ';' deleted from the beginning of each line).
;
;    const                               -- Customizations for EOS2LEX:
;       ALTERNATIVE_approach = 1         -- Don't automatically display list.
;       my_ADDENDA_FILENAME= 'c:\doc\margoli.adf'     -- I keep these in my
;       my_DICTIONARY_FILENAME= 'c:\doc\us.dct'       -- c:\doc directory.
;
; Can load more than one dictionary:
;       my_DICTIONARY_FILENAME= 'c:\doc\us.dct c:\doc\legal.dct c:\doc\medical.dct'


compile if not defined(SMALL)  -- If SMALL not defined, then being separately
   include    'COLORS.E'       -- compiled, so we must include COLORS.E, and
 define INCLUDING_FILE = 'EOS2LEX.E'
   tryinclude 'MYCNF.E'        -- the user's configuration customizations.
 compile if not defined(SITE_CONFIG)
    const SITE_CONFIG = 'SITECNF.E'
 compile endif
 compile if SITE_CONFIG
    tryinclude SITE_CONFIG
 compile endif
 compile if not defined(NLS_LANGUAGE)
   const NLS_LANGUAGE = 'ENGLISH'
 compile endif
include NLS_LANGUAGE'.e'
compile endif

const
compile if not defined(DISPLAY_box)
DISPLAY_box                  = 1        /* If the synonym entries should be */
compile endif                           /* displayed in a box this variable */
                                        /* should be 1 Otherwise, we will   */
                                        /* use sayat to display the         */
                                        /* synonyms.                        */

compile if not defined(RESPECT_case_for_addenda)
RESPECT_case_for_addenda     = 0        /* If addenda entries are to be     */
compile endif                           /* placed in the addenda without    */
                                        /* modifying their case, then       */
                                        /* this variable should be 1        */
                                        /* Otherwise, it should be 0        */

compile if not defined(SCREEN_MOVEMENT_minimization)
SCREEN_MOVEMENT_minimization = 1        /* To avoid a lot of screen         */
compile endif                           /* movement during spell checking   */
                                        /* set this constant to 1.          */
                                        /* If screen movement during spell  */
                                        /* checking is desired then clear   */
                                        /* this constant to 0.              */

compile if not defined(ALTERNATIVE_approach)
ALTERNATIVE_approach = 0                /* Setting this constant to 1       */
compile endif                           /* allows one to bypass the         */
                                        /* list of alternatives.            */
                                        /* The errant word is highlighted   */
                                        /* and we would press               */
                                        /* Esc   - to bypass the list       */
                                        /* Space - to display the list      */
                                        /* When this is 0 the list is       */
                                        /* automatically displayed.         */


;  EOS2LEX.E                                    by Ralph Yozzo.
;       Return Code information for documentation purposes
;                 /* Function Successful */
;       LXRFGOOD = 0000 , /* Good Return Code                               */
;       LXRFCORR = 0001 , /* Input Word to Spell Aid Correctly Spelled      */
;       LXRFAIDS = 0002 , /* Aid was for Base Form of Word                  */
;       LXRFHDCS = 0003 , /* Hyphenation/Dehyphenation Changed Spelling     */
;       LXRFPBFL = 0004 , /* Passback Full                                  */
;       LXRFUPDC = 0005 , /* Updateable Dictionary Created                  */
;       LXRFBASE = 0006 , /* Word has Multiple Bases                        */
;
;                 /* Function Unsuccessful */
;
;       LXRFNFND = 0100 , /* Word Not Found                                 */
;       LXRFNDAT = 0101 , /* No Data Available                              */
;       LXRFNAID = 0102 , /* No Aid Available                               */
;       LXRFIWCN = 0103 , /* Invalid Word Construction                      */
;       LXRFTMDC = 0104 , /* Too Many Dictionaries Open                     */
;       LXRFNUDC = 0105 , /* Dictionary is Not Updateable                   */
;       LXRFUDCF = 0106 , /* Updateable Dictionary Full                     */
;       LXRFDDUP = 0107 , /* Duplicate Dictionary                           */
;       LXRFDNAM = 0108 , /* Invalid Dictionary Name                        */
;       LXRFIDCT = 0109 , /* Bad Dictionary                                 */
;
;               /* Control Block or Parameter Error */
;
;       LXRFINIT = 0200 , /* PC LEXAM Not Initialized                       */
;       LXRFIFCN = 0201 , /* Invalid Function                               */
;       LXRFITOK = 0202 , /* Invalid Token in Dictionary List               */
;       LXRFIWRD = 0203 , /* Invalid Word                                   */
;       LXRFIFLG = 0204 , /* Illegal Input Flag Combination                 */
;       LXRFPARM = 0205 , /* Missing or Illegal Value in Parameter Area     */
;       LXRFPTSM = 0206 , /* Passback Too Small                             */
;       LXRFNFNM = 0207 , /* Filename Not Allowed for Updateable Dictionary */
;       LXRFNDCT = 0208 , /* Illegal Number of Dictionaries                 */
;       LXRFBUSY = 0209 , /* PC LEXAM Busy                                  */
;
;                 /* System Error */
;
;       LXRFMERR = 0400 , /* Memory Allocation Error                        */
;       LXRFNFIL = 0401 , /* File Not Found                                 */
;       LXRFNPTH = 0402 , /* Path Not Found                                 */
;       LXRFFOPN = 0403 , /* File Open Failed                               */
;       LXRFFACC = 0404 , /* File Access Denied                             */
;       LXRFFSHR = 0405 , /* File Sharing Violation                         */
;       LXRFFGEN = 0406   /* General File I/O Error                         */

const
                  /* Function Successful */
        LXRFGOOD = 0000   /* Good Return Code                               */

                  /* Function Unsuccessful */
        LXRFNFND = 0100   /* Word Not Found                                 */

                /* Control Block or Parameter Error */
        LXRFINIT = 0200   /* PC LEXAM Not Initialized                       */
        LXRFIFCN = 0201   /* Invalid Function                               */

CONST
   NOTFOUND='## Not found'


definit
   universal  addenda_has_been_modified
   universal  flexam_initialized
   universal  flexam_is_in_a_bad_state
   universal  list_bak_color,list_bar_color
   universal  ADDENDA_FILENAME
   universal  DICTIONARY_FILENAME

   if flexam_initialized /== '' then return; endif
compile if defined(my_ADDENDA_FILENAME)
   ADDENDA_FILENAME= my_ADDENDA_FILENAME
compile else
   ADDENDA_FILENAME= 'c:\lexam\lexam.adl'
compile endif
compile if defined(my_DICTIONARY_FILENAME)
   DICTIONARY_FILENAME= my_DICTIONARY_FILENAME
compile else
   DICTIONARY_FILENAME= 'c:\lexam\us.dct'
compile endif
   addenda_has_been_modified=0
   flexam_initialized=0
   flexam_is_in_a_bad_state=0
   list_bar_color = BLACK+CYANB
   list_bak_color = CYAN +BLACKB

/* spell word at cursor position */
def a_f9=
   call load_lexam()
   call rypbegin_word()
   call spellword(1) -- jbl:  one word only
   call may_be_save_addenda()

/* start spell checking at beginning of current line */
defc proof
   oldstate = command_state()
   call load_lexam()
   call proof2()
   call may_be_save_addenda()
   if oldstate then cursor_command endif




/*  Check the word at the cursor position removing punction characters. */
/*  It is assumed that the cursor is positioned at the beginning of the */
/*  word */
defproc spellword(one_word_only)
   universal list_bar_color
   getline line
   if line<>'' then
      i=.col
      l=pos(' ',line,.col)
      if l=0 then
         l=length(line)+1
         if l<i then l=i endif
      endif
      wrd=strip(substr(line,i,l-i))
      result = lexam('Verification',wrd)
;     call messageNwait('LEXAM: Verification result<'result'>') /* rey */
      if result and wrd<>'' then
         call strippunct(wrd,l,i)      /* strip punctuation and try again */
;        call messageNwait('spellword: i='i)
         .col=.col+i-1
         result = lexam('Verification',wrd)
;        call messageNwait('LEXAM: Verification result<'result'>') /* rey */
      endif
      if result and wrd<>'' then
         oldwordlen=length(wrd)
;        call messageNwait('y' .cursory 'x' .cursorx        'length(wrd) 'length(wrd) )
         parse value lexam('SPelling Aid',wrd) with . result /* rey */
         if rc>=LXRFINIT then
;            messageNwait('LEXAM: SPelling Aid error rc:'rc) /* rey */
         else
COMPILE IF ALTERNATIVE_approach = 1
            -- jbl tg:  if checking one word only, give the list straight away.
            if not one_word_only then
               refresh /* ALTERNATIVE approach */
               sayat '', .cursory, .cursorx, list_bar_color,length(wrd) /* ALTERNATIVE approach */
               -- jbl tg:  Change the prompt when you're ready for the user to
               -- do something so he'll know when the chg is done.
               sayerror EOS2LEX_PROMPT1__MSG
               k=getkey()
               if k=esc then
                  return 0
               elseif k=F10 or k=F3 then
                  return ''
               endif
            endif
COMPILE ENDIF
            newword=liststring(result,wrd)
            if newword=10 then
               return('')
            endif
            if substr(newword,1,length(NO_MATCH__MSG))=NO_MATCH__MSG then
               return('')
            endif
            if newword<>'' then
;              messageNwait('newword='newword' line=<'line'> l='l)
               replaceline substr(line,1,.col-1)||newword||substr(line,l)
               return(length(newword)-oldwordlen)
            endif
         endif
      else
         -- jbl tg:  "correctly" message is useful only if checking one word.
         if one_word_only then
            sayerror SPELLED_OK__MSG
         endif
      endif
   endif
   return(0)

defproc liststring(string,spellword)
   universal  addenda_has_been_modified
   universal  list_bak_color,list_bar_color

   cursordata
   getfileid fileid
   newwindow 'e /w /n';deleteline
   sayerror 1  /* get rid of new file message */
   longestwidth=0
   if string<>NOTFOUND and string<>'' then
      while string<>'' do
         parse value string with wrd string
         if length(wrd)>longestwidth then longestwidth=length(wrd) endif
         insertline LEXICAL_ESCAPE_embedded_control(wrd),.last+1
      endwhile
   else
      line=NO_MATCH__MSG spellword
      longestwidth=length(line)
      insertline line,1
   endif
   svcol=fileid.col; svcx=fileid.cursorx
   fileid.col=svcol+max(9,longestwidth+1); fileid.col=svcol  -- ensure word is on screen
   boxx=fileid.cursorx; boxy=fileid.cursory+1

   -- Minor bug fix:  This was:
   --     y=boxy + .last +2 - (fileid.windowy+fileid.windowheight)
   --   That caused the box to be too short when the starting cursor position
   --   was near the bottom of the screen in odd windowstyles.   jbl
   y=boxy + .last +2 - fileid.windowheight

   if y>0 then
      oldline=fileid.line;fileid.cursory=max(fileid.cursory-y,1);fileid.line=oldline
      boxy=fileid.cursory+1
   endif
   x=boxx+longestwidth+2-(fileid.windowx+fileid.windowwidth)
   if x>0 then
      boxx=boxx-x
   endif
   display 0   -- turn off refresh so that don't see === Top === in list.
   call sizelist(boxx,boxy,longestwidth+2,.last+2)
   -- jbl:  "Quit" is confusing.  "Go on" is better.  E3Spell uses "Skip".
   sayerror EOS2LEX_PROMPT2__MSG

   .cursory=1; 1

   -- Turn off cursor so it looks better.
   call lex_cursoroff()
   -- Use sayat's instead of mark/unmark.  Preserves user's mark.
   boxx = .boxx+1

   -- A better way to adjust for messy mode or odd windowstyles.
   -- The same adjustment used in sizelist().
   boxy = boxy+fileid.windowy-1

   lng = max(longestwidth,8)  -- min box is 10; means min inside length is 8.
   display 1   -- restore refresh to display list
   refresh
   sayat '', boxy+.line, boxx, list_bar_color,lng
   display 0   -- turn off refresh in getkey()
   if .last > .windowheight then
      sayat '('MORE__MSG')', boxy+.boxheight-1, boxx+(lng-length(MORE__MSG)-2)%2, .boxcolor, length(MORE__MSG)+2
   endif
   loop
      k=getkey()
      ku=upcase(k)
      ocy = .cursory
      if k==up then
         if .line<>1 then
            sayat '', boxy+.cursory, boxx, list_bak_color,lng
            up
            if .cursory=ocy then display 1; refresh; display 0; endif
            sayat '', boxy+.cursory, boxx, list_bar_color,lng
         endif
         iterate
      endif
      if k==down then
         if .line<>.last then
            sayat '', boxy+.cursory, boxx, list_bak_color,lng
            down
            if .cursory=ocy then display 1; refresh; display 0; endif
            sayat '', boxy+.cursory, boxx, list_bar_color,lng
         endif
         iterate
      endif
      if k==enter or ku=='R' then
         getline line
         deletewindow
         sayerror 0
         -- Don't replace with the 'No match' string.
         if line=NO_MATCH__MSG spellword then line='' endif
      elseif k==f8  then
         getline line
         deletewindow
         -- Don't replace with the 'No match' string.
         if line <> NO_MATCH__MSG spellword then
            call GLOBAL_change_errant_word(spellword,line)
         endif
         sayerror 0
         line = ''
      elseif k==f9 or k==f4 or ku=='A' then
         call AMU_addenda_addition_processing(spellword)
         deletewindow
         sayerror 0
         line = ''
      elseif k==f5 or ku=='T' then
         call AMU_temp_addenda_addition_processing(spellword)
         deletewindow
         sayerror 0
         line = ''
      elseif k==f3 or k==f10 or ku=='C' then
         deletewindow
         sayerror 0
         line = '10'
      elseif k==esc or ku=='N' then
         deletewindow
         sayerror 0
         line = ''
      else -- other key
         iterate
      endif
      leave
   endloop
   call prestore_pos(.line svcol svcx .cursory)
   display 1
   insert_toggle; insert_toggle          -- Restore cursor
   return line

defproc sizelist(x,y,w,h)     /* create a pop-up window */
   universal list_bak_color

   /* note: x and y are assumed to be window-relative positions */
   /* the following changes them to screen-relative    */
   call sizepopup(x+.windowx-2, y+.windowy-1,w,h,1)
   .windowcolor = list_bak_color

defproc proof2
   universal  list_bak_color,list_bar_color
   script_file_type = AMU_script_verification()
   tex_file_type = (filetype() = 'TEX')

   /* position at beginning of first word */
   getline line
   cursordata ;.col=1;if substr(line,1,1)==' 'then tabword endif

   -- If there's a line-marked area in the current file, proof only in there.
   firstline=.line ; lastline=.last
   if marktype()='LINE' then  /* if no mark, default to entire file */
      getfileid curfileid
      getmark fl,ll,fc,lc,markfileid
      if markfileid = curfileid then
         firstline=fl; lastline=ll
      endif
   endif

   for zz= firstline to lastline
      if testkey()/=='' then
         sayerror EXIT_SPELL__MSG
         loop
            k=getkey()
            if upcase(k)=YES_CHAR or k==f10 then
               sayerror 0
               return(0)
            elseif k=esc or upcase(k)=NO_CHAR then
               leave
            endif
         endloop
         sayerror 0
      endif
COMPILE IF SCREEN_MOVEMENT_minimization = 1
      sayerror 'lexam:' THINKING__MSG
      display 0  /* SCREEN_MOVEMENT_minimization */
COMPILE ENDIF
      zz
      getline line
--    sayerror 'checking 'line -- Put this back in if you like progress report.
      loop
         l=pos(' ',line,.col)
         if not l then
            l=length(line)+1
            if l<=.col then
               .col=1
               leave
            endif
         endif
         wrd=substr(line,.col,l-.col)
;        messageNwait('proof: h1 wrd=<'wrd'>  .col='.col)
         result = lexam('Verification',wrd)
;        call messageNwait('LEXAM: Verification result<'result'>') /* rey */
;        call messageNwait('wrd='substr(line,.col,l-.col))
         if result and wrd<>'' then
            if script_file_type and
            (pos(substr(wrd,1,1),':&.') or substr(line,max(.col-1,1),1)=':') then
               /* ignore script tags */
               result=0           /* correction found by Emmett Hayes */
               if substr(wrd,1,1)=':' then
                  newl=pos('.',line,.col)
                  if newl then
                     l=newl
                  endif
               endif
            elseif tex_file_type & pos('\', wrd) then
               result=0
            else
               call strippunct(wrd,l,i)   /* strip punctuation and try again */
;              messageNwait('proof: wrd=<'wrd'>  l='l'  i='i)
               .col=.col+i-1
               result = lexam('Verification',wrd)
;              call messageNwait('LEXAM: Verification result<'result'>') /* rey */
            endif
         endif
         if result and wrd<>'' then
            result = lexam('Verification',wrd)
;           call messageNwait('LEXAM: Verification result<'result'>') /* rey */
            if result and wrd <> '' then
               -- jbl:  This message is only distracting now.
               -- sayerror 'creating list of possible spellings for 'wrd
               display 1  /* SCREEN_MOVEMENT_minimization */
               t=spellword(0) -- jbl:  not one word only
               if t=='' then
                  return(0)
               endif
               l=l+ t
               getline line
            endif
         endif
;        messageNwait('loop: l='l)
         .col=l+1
      endloop
   endfor
   display 1  /* SCREEN_MOVEMENT_minimization */
   sayerror DONE__MSG


defproc strippunct(var wrd,var l,var i)
   -- Make this a variable, not a constant. to save space.
   punctuation ='~!@#$%^&*()_+|`1234567890-=\{}[]:";''<>?,./'
   /* strip leading and trailing punctuation and try again*/
   i=verify(wrd,punctuation)
;  messageNwait('strippunct: wrd=<'wrd'> i='i' l='l)
   if i>0 then
      l=l-length(wrd)
      wrd=substr(wrd,i)
      j=verify(wrd,punctuation,'m')
      if j then
         wrd=substr(wrd,1,j-1)
      else
         j=length(wrd)+1
      endif
      l=l+j+i-2
;     messageNwait('strippunct: wrd=<'wrd'>  l='l'  j='j' i='i)
   else
      i=length(wrd)+1
   endif

defproc may_be_save_addenda
   universal  addenda_has_been_modified
   universal  AMU_addenda_file_identification
   universal  ADDENDA_FILENAME

   if addenda_has_been_modified then
      sayerror 'saving addenda 'ADDENDA_FILENAME
      if AMU_addenda_file_identification<>''  then
       getfileid AMU_current_file_identification
       activatefile AMU_addenda_file_identification
       's'
       activatefile AMU_current_file_identification
      endif
      addenda_has_been_modified=0
      sayerror 0
   endif

/*
   Return Values documented above

lexam('Initialize')
lexam('Terminate')
lexam('PIckup Dictionary',dictionary_name)
lexam('DRop Dictionary',dictionary_name)
lexam('SEt Addenda Language Type',addenda_type)
lexam('Add to Transient Addenda',addenda_name)
lexam('Read from Transient Addenda',addenda_name)
lexam('Verification',word)
lexam('SPelling Aid',word)
lexam('Hyphenation',word)
lexam('DEhyphenation',word)
lexam('SYnonym',word)
lexam('GRAMmar Aid',word)
lexam('GRADe level',word)
lexam('PArt-of-speech',word)
*/

defproc lexam_is_available()
   result = lexam('Initialize')
;call messageNwait('Initialize:' result)
   if result=LXRFGOOD or result=LXRFIFCN  then
      return(1)
   else
      return(0)
   endif

defc proofword,verify =
   call load_lexam()
   call rypbegin_word()
   call spellword(1) -- jbl tg: one word only
   call may_be_save_addenda()

defc syn =
   call load_lexam()
   call pbegin_word()
   call synonym()

defproc synonym()
   getline line
   if line<>'' then
      i=.col
      l=pos(' ',line,.col)
      if l=0 then
         l=length(line)+1
         if l<i then l=i endif
      endif
      wrd=strip(substr(line,i,l-i))
      oldwordlen=length(wrd)
;     call messageNwait('LEXAM: SYnonym wrd<'wrd'>') /* rey */
      result=lexam('Verification',wrd)
;     call messageNwait('LEXAM: Verification result<'result'>') /* rey */
      if(result <> LXRFGOOD) then
         sayerror NO_SYN__MSG '<'wrd'>'
         return('')
      endif
      parse value lexam('SYnonym',wrd) with . result /* rey */
      x=result
      if result='' then
         sayerror NO_SYN__MSG '<'wrd'>'
         return('')
      endif
;     call messageNwait('LEXAM: SYnonym result<'result'>') /* rey */
;     call messageNwait('LEXAM: rc<'rc'>') /* rey */
COMPILE IF DISPLAY_box = 1
      newword=liststring(result,wrd)
COMPILE ELSE
      newword=DISPLAY_list(result)
COMPILE ENDIF
      if newword=10 then
         return('')
      endif
      if newword<>'' then
;        messageNwait('newword='newword' line=<'line'> l='l)
         replaceline substr(line,1,.col-1)||newword||substr(line,l)
         return(length(newword)-oldwordlen)
      endif
   endif

/* list synonyms for a word at the cursor position */
def s_f9 =
   call load_lexam()
   call pbegin_word()
   call synonym()

defproc load_lexam
   universal flexam_initialized
   universal flexam_is_in_a_bad_state
   universal  ADDENDA_FILENAME
   universal  DICTIONARY_FILENAME
   if flexam_is_in_a_bad_state then
      call messageNwait('LEXAM: ' BAD_DICT__MSG)
      stop
   endif
   if not flexam_initialized then
      flexam_initialized=1                /* perform initialization once */
      if not lexam_is_available() then
         messageNwait('LEXAM: ' INIT_ERROR__MSG)
      endif
      dictlist=DICTIONARY_FILENAME
      do while dictlist <> ''
         parse value dictlist with dictionary dictlist
         result=lexam('PIckup Dictionary', dictionary)
         if result & (result<>107) then  --107=dup. dict. - OK if it's already loaded.
            call messageNwait('LEXAM: ' BAD_DICT__MSG'  RC =' result)
            flexam_is_in_a_bad_state=1
            stop
         endif
      enddo
      call lexam('ADDEnda pickup Dictionary',ADDENDA_FILENAME)
      call AMU_addenda_processing()
   endif


defproc rypbegin_word
   getline line
   punctuation =' ~!@#$%^&*()_+|`1234567890-=\{}[]:";''<>?,./'
   location=.col
   while not verify(substr(line,.col,1),punctuation,'m') and location do
      location=location-1
      .col=location
   endwhile
   .col=location+1

; Addenda support commands
;defc AMU_addenda_pickup
;   universal  ADDENDA_FILENAME
;   call lexam('ADDEnda pickup Dictionary',ADDENDA_FILENAME)

;defc AMU_addenda_addition
;   call lexam('ADDItion to Transient Addenda',arg(1))

defproc AMU_addenda_processing
   universal AMU_addenda_file_identification
   universal  ADDENDA_FILENAME
   getfileid AMU_current_file_identification
   'e /h /q 'ADDENDA_FILENAME
   if not rc or rc = -282 then  -- sayerror('New file')
      getfileid AMU_addenda_file_identification
   else
      AMU_addenda_file_identification =''
      sayerror BAD_ADDENDA__MSG ADDENDA_FILENAME 'rc=' rc
      stop
   endif
   activatefile AMU_current_file_identification
   if AMU_addenda_file_identification <>'' then
      for i = 1 to AMU_addenda_file_identification.last
         getline line,i,AMU_addenda_file_identification
         do while line <> ''
            parse value line with wrd line
COMPILE IF RESPECT_case_for_addenda
            call lexam('ADDItion to Transient Addenda',wrd)
COMPILE ELSE
            call lexam('ADDItion to Transient Addenda',lowcase(wrd))
COMPILE ENDIF
         enddo
      endfor
   endif

defproc AMU_addenda_addition_processing(AMU_addenda_entry)
   universal  addenda_has_been_modified
   universal AMU_addenda_file_identification
   addenda_has_been_modified=1
COMPILE IF RESPECT_case_for_addenda = 0
   AMU_addenda_entry=lowcase(AMU_addenda_entry)
COMPILE ENDIF
   call lexam('ADDItion to Transient Addenda',AMU_addenda_entry)
   insertline AMU_addenda_entry,AMU_addenda_file_identification.last+1,AMU_addenda_file_identification

defproc AMU_temp_addenda_addition_processing(AMU_addenda_entry)
COMPILE IF RESPECT_case_for_addenda = 0
   AMU_addenda_entry=lowcase(AMU_addenda_entry)
COMPILE ENDIF
   call lexam('ADDItion to Transient Addenda',AMU_addenda_entry)

; The following is a script file type verification algorithm
; suggested by Larry Margolis. (Thanks, Larry)
defproc AMU_script_verification()
   ext=filetype()
compile if defined(my_SCRIPT_FILE_TYPE)
   return ext='SCR' or ext='SCT' or ext='SCRIPT' or ext='IPF' or ext=my_SCRIPT_FILE_TYPE
compile else
   return ext='SCR' or ext='SCT' or ext='SCRIPT' or ext='IPF'
compile endif

-- Turn cursor off.  Taken from LAM's MAILMENU.E, simplified for OS/2 only.
defproc lex_cursoroff
   string=atoi(0) || atoi(1) || atoi(1) || atoi(-1)
   call dynalink('VIOCALLS',        /* dynamic link library name          */
                 'VIOSETCURTYPE',   /* Video Input Output SET CURsor TYPE */
                 selector(string)|| /* string selector                    */
                 offset(string)||   /* string offset                      */
                 atoi(0))           /* Vio Handle                         */

defproc GLOBAL_change_errant_word(spellword,line)
;call messageNwait('message: c /'spellword'/'line'/*') */
   GLOBAL_saveline   = .line
   GLOBAL_savecolumn = .col
   'c /'spellword'/'line'/*'
   GLOBAL_saveline
   .col              = GLOBAL_savecolumn

defproc LEXICAL_ESCAPE_embedded_control(wrd)
   LEXICAL_ESCAPE_position =pos(\255,wrd)
   if LEXICAL_ESCAPE_position then
;     call messageNwait('LEXICAL_ESCAPE_position' LEXICAL_ESCAPE_position)
      return overlay(' ',wrd,LEXICAL_ESCAPE_position)
   endif
   return wrd

;defc lex_bad
;   universal  flexam_is_in_a_bad_state
;   flexam_is_in_a_bad_state=arg(1)

defproc DISPLAY_list(result)
   universal list_bar_color
   i=1
   while result<>'' do
      parse value result with word0 word1 word2 word3 word4 result
      result0 = word0 word1 word2 word3 word4
      sayat result0,i,1,list_bar_color,length(result0)
      display 0
      i=i+1
   endwhile
   k=getkey()
   executekey k
   display 1
   return 10

