/**********************************************************************/
/* Register the CWMailFile class                                      */
/**********************************************************************/

signal on Halt /* handle [Ctrl][C] */

say 'This program registers the CWMailFileClass' /* report */
say 'Press [Enter] to continue or [Ctrl][C],[Enter] to abort' /* report */
parse pull

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' /* Q&D way to load the REXX utils lib */
call SysLoadFuncs  /* Q&D way to load the REXX utils lib */

ClassDLL=directory()||'\rexxmail.dll' /* where to find the DLL */

if (sysregisterobjectclass('CWMailFile',ClassDLL)) then /* if we can register the class */
do
 say 'The CWMailFile class has been registered.' /* report success */
end
else /* if we cannot register the class */
do
 say 'Error while registering the CWMailFile class.' /* report failure */
end

say 'Press [Enter] to quit' /* report */
parse pull /* wait for [Enter] */

call Halt /* that's all, folks! */

/**********************************************************************/
Halt:  /* quits */
/**********************************************************************/

exit /* and quit */
