/*****************************************************************************/
/* FA Partners                                                               */
/* Copyright (c) FA PArtners 1997                                            */
/*---------------------------------------------------------------------------*/
/* File        :                                                             */
/* Description :                                                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-09-15  | Created                                 | FB                */
/* 199X-XX-XX  |                                         |                   */
/*---------------------------------------------------------------------------*/
/* Compile     :                                                             */
/*****************************************************************************/

#include <fstream.h>
#include "..\convert\bandit_convert.hpp"



//***************************************************************************
// BANConvert::convert
// Input parameters :
// Select the convert method, and writes the name of the files.
// Returncodes :
//***************************************************************************

Boolean BANConvert::convert()
{
  cout << (_fromWysiwyg ? "Converting from WYSIWYG to oneliners\n"
                       : "Converting from oneliners to WYSIWYG\n")
       << "Source : " << _sourceName << '\n'
       << "Target : " << _targetName << endl;

  return (_fromWysiwyg ? this->convertWysiwyg() : this->convertOneliners());
}
//***************************************************************************
// BANConvert::convertWysiwig
// Input parameters :
// The converts a wysiwyg file to oneliners.
// Returncodes :
//***************************************************************************

Boolean BANConvert::convertWysiwyg()
{
  ifstream in  (_sourceName);
  ofstream out (_targetName);

  IString  outString;
  Boolean  firstLine(true);

  while (in.good() && out.good()) {
    IString inString = IString::lineFrom(in);
    if (inString != IString() && ((firstLine && !inString.isDigits()) || !firstLine))
      outString += inString + _newline;
    if (inString == IString()) {
      out << outString.subString(1, outString.lastIndexOf(_newline)-1) << endl;
      outString = IString();
    }
    firstLine = false;
  }
  if (out.good())
    out << outString.subString(1, outString.lastIndexOf(_newline)-1);

  out.close();
  in.close();
  return true;
}


//***************************************************************************
// BANConvert::convertOneliners
// Input parameters :
// The converts a oneliner file to wysiwyg.
// Returncodes :
//***************************************************************************

Boolean BANConvert::convertOneliners()
{
  ifstream in  (_sourceName);
  ofstream out (_targetName);

  Boolean  firstLine(true);

  while (out.good() && in.good()) {
    IString string(IString::lineFrom(in));
    if (!firstLine) out << endl << endl;
    if ((firstLine && !string.isDigits()) || !firstLine)
      out << string.change(_newline, "\n");
    firstLine = false;
  }
  out.close();
  in.close();

  return true;
}
