//****************************************************************************
// File    : LOANNTBK.HPP
// Version : 0.01
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// IBM Internal Use Only 
// Copyright (c) IBM Corp. 1996          
// Developed by Nordic Business Fulfillment - Solutions Centre
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Purpose : 
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ 
// Vers     Date       Author    Comment                                  
// ----  ----------  ----------  ---------------------------------------------
// 0.01  1996-04-09  ALEXANDR    Created
//****************************************************************************

//* Conditional inclusion ****************************************************
#ifndef _LOANNTBK_HPP_                                  
#define _LOANNTBK_HPP_

//* Include headers **********************************************************
#include <iframe.hpp>
#include <icmdhdr.hpp>

#include "loandata.hpp"

//* Forward declarations *****************************************************
class LOANDataCnrObject;
class IResourceLibrary;
class ITitle;
class INotebook;
class IMultiCellCanvas;
class ISetCanvas;
class IComboBox;
class INumericSpinButton;
class IPushButton;
class IMultiLineEdit;

//****************************************************************************
// Class : LOANNotebook  
//
//****************************************************************************
class LOANNotebook : public IFrameWindow
                   , public ICommandHandler
{
  //* Public declarations ****************************************************
  public:
    //* Public enumerations **************************************************
    enum Mode {New, Open};

    //* Constuctor ***********************************************************
    LOANNotebook(LOANDataCnrObject* object,
                 Mode               mode  );

    //* Destructor ***********************************************************
    virtual ~LOANNotebook() {}

    //* Notifier identifiers *************************************************
    static INotificationId Layouted;

    //* Public functions *****************************************************
    long layout();


    //* Accessor functions ***************************************************
    Boolean        isLayouted() const {return _isLayouted;}

  //* Protected declarations *************************************************
  protected:
    virtual Boolean command      (ICommandEvent& cmdEvt);
    virtual Boolean systemCommand(ICommandEvent& cmdEvt);

  //* Private declarations ***************************************************
  private:
    //* Private data members *************************************************
    LOANDataCnrObject*  pObject        ;
    Mode                _mode          ;
                                       
    Boolean             _isLayouted    ;
    Boolean             _isHostActive  ;
                                       
    IResourceLibrary&   resLib         ;

    ITitle*             pTitle         ;

    INotebook*          pNotebook      ;

    IFrameWindow*       pSettingsFrame ;
    IFrameWindow*       pReportFrame   ;

    IMultiCellCanvas*   pSettingsCanvas;    

    ISetCanvas*         pscCountry     ;
    ISetCanvas*         pscPeriod      ;
    ISetCanvas*         pscSession     ;

    IComboBox*          pcbCountry     ;
    INumericSpinButton* pnsbYear       ;
    INumericSpinButton* pnsbMonth      ; 
    IComboBox*          pcbSession     ; 

    IMultiLineEdit*     pmleReport     ;

    IMultiCellCanvas*   buttonsCanvas  ;
    IPushButton*        ppbFetch       ;
    IPushButton*        ppbInvoice     ;
    IPushButton*        ppbConfirm     ;
    IPushButton*        ppbAuthorize   ;
    IPushButton*        ppbCancel      ;
    IPushButton*        ppbClose       ;
    IPushButton*        ppbHelp        ;

    //* Private member functions *********************************************
    long              layoutDetails ();
    IMultiCellCanvas* layoutSettings(IWindow* parentAndOwner);
    IMultiCellCanvas* layoutReport  (IWindow* parentAndOwner);
    IMultiCellCanvas* layoutButtons (IWindow* parentAndOwner);

    void handleFetch    ();
    void handleInvoice  ();
    void handleConfirm  ();
    void handleAuthorize();

    void enableControlsForFetch(Boolean enable);
    void enableControlsForHost (Boolean enable);

    void layoutFetched  ();             

    void    fillReportPages  ();
    IString addHeaderToReport();
    IString addRowToReport   (LOANDataRowPtr& dataRow);
    IString addTotalsToReport(unsigned long lines,
                              unsigned long count,
                              double amortization,
                              double interest    ,
                              double amount      );

    IString country     ();
    IString parameters  ();
    IString session     ();

    void setOpenTitle   ();

    void fillSession(IComboBox* pcbSession);

    IString formatDouble(double source, int length, 
                         int decimals = 2, char tsep = '.', char dsep = ',');

}; /* End LOANNotebook */

#endif /* _LOANNTBK_HPP_ */
