/*****************************************************************************/
/* IBM Internal Use Only                                                     */
/* Copyright (c) IBM Corp 1997                                               */
/*---------------------------------------------------------------------------*/
/* File        :                                                             */
/* Contains    :                                                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-08-13  | Created                                 | FB                */
/* 1997-11-05  | Inspacted for Win32 comp.               | FB                */
/*****************************************************************************/

#ifndef _TAG_INI_HPP_
#define _TAG_INI_HPP_

#include <istring.hpp>
#include <iprofile.hpp>

class TAGUserIni
{
  private:
  //* Privat members.     ****************************************************
  IProfile         _profile;
  IString          _tagfiles;
  IString          _manualTag;
  IString          _xMailer;
  IString          _xNews;
  IString          _newline;
  IString          _defaultTagfile;
  IString          _name;
  IString          _key;
  IString          _anonymousName;
  IString          _anonymousEmail;
  Boolean          _wysiwyg;
  Boolean          _sequential;
  Boolean          _defaultSelection;
  Boolean          _removeXMailer;
  Boolean          _removeXNews;
  Boolean          _registered;
  Boolean          _advertise;
  Boolean          _windowList;
  Boolean          _noReplace;
  long             _pause;
  long             _previousSelection;
  //* Prvate functions *****************************************************
  //* Protected ***********************************************************
  //* Public declarations ****************************************************
  public:
    //* Constuctor ***********************************************************
    TAGUserIni(const IString& exename);
    //* Destructor ***********************************************************
    virtual ~TAGUserIni();
    //* Public functions *****************************************************
    IString&        tagfiles()                {return _tagfiles;}
    const IString&  manualTag()         const {return _manualTag;}
    const IString&  xMailer()           const {return _xMailer;}
    const IString&  xNews  ()           const {return _xNews;}
    const IString&  newline()           const {return _newline;}
    const IString&  defaultTagfile()    const {return _defaultTagfile;}
    const IString&  registeredName()    const {return _name;}
    const IString&  registeredKey()     const {return _key;}
    const IString&  anonymousName()     const {return _anonymousName;}
    const IString&  anonymousEmail()    const {return _anonymousEmail;}
    long            pause()             const {return _pause;}
    long            selection()         const {return _previousSelection;}
    Boolean         wysiwyg()           const {return _wysiwyg;}
    Boolean         sequential()        const {return _sequential;}
    Boolean         isDefault()         const {return _defaultSelection;}
    Boolean         removeXMailer()     const {return _removeXMailer;}
    Boolean         removeXNews()       const {return _removeXNews;}
    Boolean         advertise()         const {return _advertise;}
    Boolean         windowList()        const {return _windowList;}
    Boolean         noReplace()         const {return _noReplace;}
    Boolean         registered()        const;
    const IProfile& profile()        const {return _profile;}
    TAGUserIni&     tagfiles  (const IString& aString)     {_tagfiles      = aString; return *this;}
    TAGUserIni&     manualTag (const IString& aString)     {_manualTag     = aString; return *this;}
    TAGUserIni&     xMailer   (const IString& aString)     {_xMailer       = aString; return *this;}
    TAGUserIni&     xNews     (const IString& aString)     {_xNews         = aString; return *this;}
    TAGUserIni&     newline   (const IString& aString)     {_newline       = aString; return *this;}
    TAGUserIni&     registeredName(const IString& aString) {_name          = aString; return *this;}
    TAGUserIni&     registeredKey(const IString& aString)  {_key           = aString; return *this;}
    TAGUserIni&     anonymousName(const IString& aString)  {_anonymousName = aString; return *this;}
    TAGUserIni&     anonymousEmail(const IString& aString) {_anonymousEmail= aString; return *this;}
    TAGUserIni&     pause     (const long     aValue )     {_pause         = aValue ; return *this;}
    TAGUserIni&     selection (const long     aValue )     {_previousSelection= aValue ; return *this;}
    TAGUserIni&     wysiwyg   (const Boolean  aBool  )     {_wysiwyg       = aBool  ; return *this;}
    TAGUserIni&     sequential(const Boolean  aBool  )     {_sequential    = aBool  ; return *this;}
    TAGUserIni&     advertise (const Boolean  aBool  )     {_advertise     = aBool  ; return *this;}
    TAGUserIni&     windowList(const Boolean  aBool  )     {_windowList    = aBool  ; return *this;}
    TAGUserIni&     noReplace (const Boolean  aBool  )     {_noReplace     = aBool  ; return *this;}
    TAGUserIni&     defaultTagfile(const IString& aString) {_defaultTagfile= aString; return *this;}
    TAGUserIni&     removeDefault()                        {_defaultSelection = false; return *this;}
    TAGUserIni&     setDefault()                           {_defaultSelection = true; return *this;}
    TAGUserIni&     removeXMailer(Boolean removeXMailer)   {_removeXMailer    = removeXMailer; return *this;}
    TAGUserIni&     removeXNews  (Boolean removeXNews  )   {_removeXNews      = removeXNews  ; return *this;}
    Boolean         save();
};

#endif
