/* Re-index a PMMail 1.92 folder v0.2 */
/* Author: Kovacs Istvan <kofa@math.bme.hu> */

/*trace intermediates*/

parse arg addresses
if addresses='' then
do
  say 'Usage: pmmidx your_address(es)'
  exit
end

/* Load REXX utility functions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Get data of message files */
rc=SysFileTree('*.msg',messages,'FT')

/* status values */
read=1
sent=3

/* Month names */
months='JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC'

to_txt='To: '
from_txt='From: '
date_txt='Date: '
subject_txt='Subject: '
content_type_txt='Content-Type: '

/* Backup old folder.bag */
'@del folder.bak 2>nul'
'@ren folder.bag folder.bak'

signal on error name error

/* Loop through message files */
do i=1 to messages.0
  /* Set default values - mainly for debugging */
  to_email='(null)'
  to_fullname='(null)'
  from_email='(null)'
  from_fullname='(null)'
  subject='(null)'
  parse value word(messages.i,1) with yy '/' m_m '/' dd '/' hh '/' mm
  msgdate=yy'-'m_m'-'dd
  msgtime=hh':'mm':00'
  attachments=0
  msgstatus=read
  /* Calculate size in kB */
  msglen=trunc(word(messages.i,2)/1024+0.5)
  filename=filespec('n',word(messages.i,4))

  /* Read and process the header */
  do until l=''
    l=linein(filename)
    if pos(to_txt,l)=1 then
    do
      call process_to
      iterate
    end
    if pos(from_txt,l)=1 then
    do
      call process_from
      iterate
    end
    if pos(date_txt,l)=1 then
    do
      call process_date
      iterate
    end
    if pos(subject_txt,l)=1 then
    do
      call process_subject
      iterate
    end
    
    if pos(content_type_txt,l)=1 then
      call process_attachments
  end

  /* Close file */
  rc=lineout(filename)

/* Assemble a line of FOLDER.BAG Structure:
STAUSATTACHMENTYY-MM-DDHH:MM:SSSUBJECTTO_EMIALTO_FULLNAMEFROM_EMAILFROM_FULLNAMEFILENAME.MSG
*/
  rc=lineout('folder.bag',msgstatus''attachments''msgdate''msgtime''subject''to_email''to_fullname''from_email''from_fullname''msglen'K'filename'')
end
rc=lineout('folder.bag')
exit

process_to:
/* Try to figure out to_email and to_fullname */

  /* Extract addressee data */
  parse var l to_txt addr

  /* Look for email address */
  /* If it's the first word, the rest is the full name, and vice versa */
  if pos('@',word(addr,1))\=0 then
  do
    to_email=word(addr,1)
    /* If full name is present, use it, otherwise use email address as full name */
    if words(addr)>1 then        
      to_fullname=substr(addr,wordindex(addr,2))
    else
      to_fullname=to_email
  end
  else
  do
    to_email=word(addr,words(addr))
    to_fullname=left(addr,max(length(addr)-length(to_email)-1,1))
  end
  to_email=stripstring(to_email)
  to_fullname=stripstring(to_fullname)
return

process_from:
/* Try to figure out from_email and from_fullname
   No comments, same method as in process_to */

  parse var l from_txt addr
  if pos('@',word(addr,1))\=0 then
  do
    from_email=word(addr,1)
    if words(addr)>1 then 
      from_fullname=substr(addr,wordindex(addr,2))
    else
      from_fullname=from_email
  end
  else
  do
    from_email=word(addr,words(addr))
    from_fullname=left(addr,max(length(addr)-length(from_email)-1,1))
  end
  from_email=stripstring(from_email)
  from_fullname=stripstring(from_fullname)

  /* If sender address is one of the addresses supplied, mark message as sent */
  do j=1 to words(addresses)
    if word(addresses,j)=from_email then
    do
      msgstatus=sent
      return
    end
  end
return

process_subject:
/* Extract subject info */

  if words(l)>1 then
    parse value space(l) with subject_txt subject
  else
    subject='(null)'
return

process_date:
/* Get the date in YY-MM-DD and time in HH:MM:SS format */

  /* If name of day is missing, don't try to parse it */
  if datatype(word(l,2),'n') then
    parse var l 'Date:' dd monthname yyyy hh ':' mm ':' ss rest
  else
    /* We've got the name of the day */
    parse var l date_txt dayname ',' dd monthname yyyy hh ':' mm ':' ss rest

  /* Format things, add leading zero, if needed */
  yy=right(yyyy//100,2,'0')
  m_m=right(wordpos(translate(monthname),months),2,'0')
  dd=right(dd,2,'0')
  hh=right(hh,2,'0')
  mm=right(mm,2,'0')
  ss=right(ss,2,'0')
  msgdate=yy'-'m_m'-'dd
  msgtime=hh':'mm':'ss
return

process_attachments:
/* If content type is multipart, mark message as one having attachments */
  if pos('multipart',l)\=0 then
    attachments=1
return

stripstring: procedure
/* Strip different kinds of begin-end markers */
  parse arg s
  markers='"<>()'
  do i=1 to length(markers)
    if left(s,1)=substr(markers,i,1) then
      s=substr(s,2)
    else if right(s,1)=substr(markers,i,1) then
      s=left(s,length(s)-1)
  end
return s

error:
  say 'Error while processing' filename
