/* RBLcheck.cmd v2.3 */
/* Part of RBLcheck */
/* Copyright (C) 2004,2005 Jeroen Besse */
/**/
signal ON ERROR NAME verderhier;
signal ON FAILURE NAME verderhier;
signal ON HALT NAME verderhier;
signal ON NOVALUE NAME verderhier;
signal ON SYNTAX NAME verderhier;
signal ON NOTREADY NAME verderhier;
/**/
Version="2.3"
Profile="default"
parse arg parameters
parse arg parameters
do until parameters= ""
  lparameter= left(parameters, 1)
  if pos(lparameter, '-/"')> 0 then
  do
    if lparameter= '"' then
    do
      tweede= pos('"', parameters, 2)
      Mail= strip(left(parameters,tweede))
      parameters= strip(substr(parameters, tweede+1))
    end
    else
    do
      parse var parameters parameter parameters
      if pos("P:", translate(parameter))= 2 then
        Profile= substr(parameter,4)
    end
  end
  else
  do
    parse var parameters Mail parameters
  end
end
Mail = strip(Mail,'B','"')
parse version rxver1 rxver2 rxver3 rxver4 rxver5
parse source os invocation scriptfile
inifile= left(scriptfile, length(scriptfile)-3)'ini'
scriptpath= left(scriptfile, lastpos("\",scriptfile));
Log= 'c:\RBLcheck.log'
LogLevel= 2
ConLevel= 4
TriggerLevel= 10
RBLnames= ''
RBLs= ''
SkipIPs= ''
HitIPs= ''
SkipLastHops= 0
HaltAtTrigger= 0
VersionStamp= 1
LookupTimeout= 30
ReturnCode= 0
Xheaders= 0
ReportInSubject= 0
IDt= time('L')
ID= date('S')''substr(IDt,1,2)''substr(IDt,4,2)''substr(IDt,7,2)''substr(IDt,10,2)
CodeToReturn= 0

/* phase 01: read ini file */
Phase= "01"
ThisProfile= 1
call linein inifile,1,0
do while lines(inifile)
  iniline= linein(inifile)
  if left(iniline, 1)="[" then
  do
    if iniline= "["Profile"]" then
      ThisProfile= 1
    else
      ThisProfile= 0
  end
  if ThisProfile= 1 then
  do
    iniline= space(translate(iniline,' ','	'))
    parse var iniline iniword1 iniword2 iniword3 iniword4 iniword5
    iniwordt= translate(iniword1)
    select
      when iniwordt= 'LOGFILE' then
        Log= iniword2
      when iniwordt= 'LOGLEVEL' then
        LogLevel= iniword2
      when iniwordt= 'TRIGGERLEVEL' then
        TriggerLevel= iniword2
      when iniwordt= 'RBL' then
      do
        RBLs= RBLs' 'iniword2' 'iniword3' 'iniword4
        RBLnames= RBLnames' 'iniword2
      end
      when iniwordt= 'SKIPIP' then
        SkipIPs= SkipIPs' 'iniword2
      when iniwordt= 'HITIP' then
        HitIPs= HitIPs' ('iniword2' 'iniword3' 'iniword4')'
      when iniwordt= 'SKIPLASTHOPS' then
        SkipLastHops= iniword2
      when iniwordt= 'HALTATTRIGGER' then
        HaltAtTrigger= iniword2
      when iniwordt= 'VERSIONSTAMP' then
        VersionStamp= iniword2
      when iniwordt= 'CONLEVEL' then
        ConLevel= iniword2
      when iniwordt= 'LOOKUPTIMEOUT' then
        LookupTimeout= iniword2
      when iniwordt= 'RETURNCODE' then
        ReturnCode= iniword2
      when iniwordt= 'XHEADERS' then
        Xheaders= iniword2
      when iniwordt= 'REPORTINSUBJECT' then
        ReportInSubject= iniword2
      otherwise
        nop
    end /* select */
  end
end  
call stream inifile,'c','close'
RBLs= space(RBLs)
RBLnames= space(RBLnames)
SkipIPs= space(SkipIPs)
HitIPs= space(HitIPs)

call WriteLog 1,'--- RBLcheck started, version 'Version', loglevel 'LogLevel
call WriteLog 3,'Profile: 'Profile
call WriteLog 3,'ConLevel: 'ConLevel
call WriteLog 4,'OS: 'os
call WriteLog 4,'Invocation: 'invocation
call WriteLog 4,'Script: 'scriptfile
call WriteLog 4,'REXX: 'rxver1 rxver2 rxver3 rxver4 rxver5
call WriteLog 4,'Arg: 'Mail
call WriteLog 4,'Ini: 'inifile
call WriteLog 3,'TriggerLevel: 'TriggerLevel
call WriteLog 3,'RBLs: 'RBLnames
if words(SkipIPs)>1 then
  call WriteLog 3,'SkipIP: 'SkipIPs
else
  call WriteLog 3,'SkipIP: none'
if words(HitIPs)>1 then
  call WriteLog 3,'HitIP: 'HitIPs
else
  call WriteLog 3,'HitIP: none'
call WriteLog 3,'SkipLastHops: 'SkipLastHops
call WriteLog 3,'HaltAtTrigger: 'HaltAtTrigger
call WriteLog 3,'VersionStamp: 'VersionStamp
call WriteLog 3,'LookupTimeout: 'LookupTimeout
call WriteLog 3,'ReturnCode: 'ReturnCode
call WriteLog 3,'Xheaders: 'Xheaders
call WriteLog 3,'ReportInSubject: 'ReportInSubject

HitIPs= space(translate(HitIPs, '  ', '()'))

if words(Mail)<1 then
do
  call WriteLog 1,"No Arg: don't know what mail to check... exiting."
  call WriteLog 1,'--- RBLcheck finished'
  exit
end

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

rc= RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
call WriteLog 4,'RxFuncAdd: 'rc
rc= SockLoadFuncs()
call WriteLog 4,'SockLoadFuncs: 'rc

/* phase 02: read mail headers into memory, extract IP addresses */
Phase= "02"
IPaddresses= ''
maiq= rxqueue('Create')
oldq= rxqueue('set',maiq)
head= 0
FullLine= ''
call WriteLog 4,'Read headers...'
do while lines(Mail) & (head= 0)
  line= linein(Mail)
  if words(line)= 0 then
  do
    head= 1
    IPaddresses= IPaddresses' 'InterpretLine(FullLine)
  end
  else
  do
    firstchar= left(line,1)
    if verify(firstchar,' 	','M')= 0 then
    do
      if \(pos('X-RBLCHECK',translate(line))= 1) then
        queue line
      /* previous (folded) header now complete... check it */
      FullLine= space(translate(FullLine,' ','	'))
      if words(FullLine)> 0 then
        IPaddresses= IPaddresses' 'InterpretLine(FullLine)
      FullLine= line
    end
    else
    do
      /* unfolding header */
      FullLine= FullLine' 'line
      queue line
    end
  end
end
IPaddresses= space(IPaddresses)

if head= 0 then
do
  call WriteLog 1,"No blank line between headers and message body (RFC822)... exiting."
  call WriteLog 1,'--- RBLcheck finished'
  exit
end

if VersionStamp= 1 then
do
  if Xheaders= 0 then
    queue 'X-RBLcheck-version: 'Version' (see http://rblcheck.besse.nl/)'
  else
    queue 'X-RBLcheck: v'Version' (see http://rblcheck.besse.nl/)'
end

/* phase 03: check IP addresses */
Phase= "03"
rblscore= 0
rblhit= 0
DNSq= rxqueue('Create')
DNSa= rxqueue('Create')
qRBL= 0
do while words(IPaddresses)> 0
  RBLrun= RBLs
  parse var IPaddresses IPaddress IPaddresses
  if pos(IPaddress, HitIPs)> 0 then
  do
    parse var HitIPs HitLinks IPaddress HitRechts
    qName= subword(HitLinks, words(HitLinks))
    qWeight= subword(HitRechts, 1)
    if Xheaders= 0 then
      queue 'X-RBLcheck-hits: 'IPaddress' found locally at 'qName' (score: 'qWeight')'
    else
      queue 'X-RBLcheck: RBLcheck-local-hit-at-'qName IPaddress
    call Writelog 2,'Hit: 'IPaddress' found locally at 'qName' (score: 'qWeight')'
    rblscore= rblscore+ qWeight
    rblhit= 1
    if HaltAtTrigger= 1 then
      if rblscore >= TriggerLevel then
      do
        qRBL= 0
        RBLrun= ""
        IPaddresses= ""
      end
  end
  else
    call Writelog 3,IPaddress' not found locally.'

  do while words(RBLrun)> 0
    parse var RBLrun qName qDNS qWeight RBLrun
    dummy= rxqueue('set',DNSq)
    queue IPaddress qName qDNS qWeight
    dummy= rxqueue('set',maiq)
    qRBL= qRBL+ 1
  end  
end

/* launch RBL lookups */
if qRBL> 0 then
do
  call WriteLog 4,"Invoking "scriptpath"RBLqDNS.cmd " DNSq DNSa
/*  "start /c /b /min "scriptpath"RBLqDNS.cmd " DNSq DNSa */
  "@detach "scriptpath"RBLqDNS.cmd " DNSq DNSa
end

/* get RBL lookup results */
TimeoutTeller= LookupTimeout
do while qRBL> 0
  dummy= rxqueue('set',DNSa)
  AnswerAvailable= queued()
  qContinue= AnswerAvailable
  do while qContinue < 1
    call SysSleep 1 /* wait for incoming result */
    TimeoutTeller= TimeoutTeller- 1
    if TimeoutTeller <  1 then
    do
      qContinue= 1
    end
    else
    do
      AnswerAvailable= queued()
      qContinue= AnswerAvailable
    end
  end
  if AnswerAvailable > 0 then
  do
    parse pull IPaddress qName qDNS qWeight rDNS
    dummy= rxqueue('set',maiq)
    qRBL= qRBL- 1
    if left(rDNS, 5)= "ERROR" then
    do
      call Writelog 3,IPaddress' not found at 'qName' ('rDNS')'
    end
    else
    do
      if left(rDNS,8)= "NEGATIVE" then
      do
        call Writelog 3,IPaddress' not found at 'qName' (negative)'
      end
      else
      do
        if left(rDNS,4)<> "127." then
          call Writelog 3,IPaddress' not found at 'qName' (negative)'
        else
        do
          if Xheaders= 0 then
            queue 'X-RBLcheck-hits: 'IPaddress' found at 'qName' (score: 'qWeight')'
          else
            queue 'X-RBLcheck: RBLcheck-hit-at-'qName IPaddress
          call Writelog 2,'Hit: 'IPaddress' found at 'qName': 'rDNS' (score: 'qWeight')'
          rblscore= rblscore+ qWeight
          rblhit= 1
          if HaltAtTrigger= 1 then
            if rblscore >= TriggerLevel then
              qRBL= 0
        end
      end
    end
  end
  else
  do
    call Writelog 2,'Timeout on DNS lookup while still waiting for 'qRBL' answers.'
    qRBL= 0
  end
end
call rxqueue 'Delete',DNSq
call rxqueue 'Delete',DNSa
dummy= rxqueue('set',maiq)

/* phase 04: add RBLcheck headers to headers in memory */
Phase= "04"
InsSubject= ''
if rblhit= 0 then
  do
    if Xheaders= 0 then
      queue 'X-RBLcheck: negative'
    else
      queue 'X-RBLcheck: RBLcheck-no-hits'
    call WriteLog 1,'RBLcheck negative: no hits.'
  end
else
do
  if Xheaders= 0 then
    queue 'X-RBLcheck: positive'
  else
    queue 'X-RBLcheck: RBLcheck-some-hits'
  call WriteLog 1,'RBLcheck positive: some hits.'
  if ReturnCode= 2 then
    CodeToReturn= 1
  if ReturnCode= 3 then
    CodeToReturn= rblscore
  if HaltAtTrigger= 0 then
  do
    if Xheaders= 0 then
      queue 'X-RBLcheck-score: 'rblscore
    else
      queue 'X-RBLcheck: RBLcheck-score 'rblscore
    call WriteLog 2,'Final score: 'rblscore
  end
  if rblscore < TriggerLevel then
  do
    InsSubject= '*** SPAM? ('rblscore') *** '
    if Xheaders= 0 then
      queue 'X-RBLcheck-trigger-reached: false'
    else
      queue 'X-RBLcheck: RBLcheck-trigger-not-reached'
  end
  else
  do
    InsSubject= '*** SPAM! ('rblscore') *** '
    if Xheaders= 0 then
      queue 'X-RBLcheck-trigger-reached: true'
    else
      queue 'X-RBLcheck: RBLcheck-trigger-reached'
    call WriteLog 1,'Trigger reached.'
    if ReturnCode= 1 then
      CodeToReturn= 1
    if ReturnCode= 2 then
      CodeToReturn= 2
  end
end
queue

/* phase 05: read message body into memory */
Phase= "05"
call WriteLog 4,'Read body ('chars(Mail)' bytes)...'
mailbody= charin(Mail,,chars(Mail))
call stream Mail,'c','close'

/* phase 06: write back mail headers */
Phase= "06"
call WriteLog 4,'Write headers...'
line='bla'
call lineout Mail,,1
do while words(line)> 0
  parse pull line
  if ReportInSubject then
  do
    if pos('SUBJECT:', translate(line))= 1 then
    do
      line= left(line,8)' 'InsSubject''substr(line,10)
    end
  end
  call lineout Mail,line
end

/* phase 07: write back mail body */
Phase= "07"
call WriteLog 4,'Write body...'
call charout Mail,mailbody
call lineout Mail

call rxqueue 'Delete',maiq
call rxqueue 'Set',oldq

call WriteLog 4,'CodeToReturn: 'CodeToReturn
call WriteLog 1,'--- RBLcheck finished'

exit trunc(CodeToReturn)


/* subroutines */
WriteLog:
if LogLevel>= arg(1) then
do
/*  call lineout Log,date('S')' 'time()' 'arg(2) */
  lLine= time('L')
  lLine= substr(lLine,1,2)':'substr(lLine,4,2)':'substr(lLine,7,2)'.'substr(lLine,10,2)
  lLine= ID' 'lLine' 'Phase''copies(' ',arg(1))''arg(2)
  call lineout Log, lLine
  call lineout Log
end
if ConLevel>= arg(1) then
  say date('S')' 'time()''copies(' ',arg(1))''arg(2)
return

InterpretLine:
mline= arg(1)
hitaddress= ''
uline= translate(mline)
firstword= word(uline,1)
select
  when firstword= 'SUBJECT:' then
    call WriteLog 1,mline
  when firstword= 'FROM:' then
    call WriteLog 2,mline
  when firstword= 'TO:' then
    call WriteLog 3,mline
  when firstword= 'RECEIVED:' then
  do
    IPaddress= 0
    /* first, see if it's according to RFC */
    /* check only the from part */
    parse var uline dummy ' FROM ' line1
    parse var line1 line2 ' BY ' dummy
    parse var line2 line3 ' VIA ' dummy
    parse var line3 line4 ' WITH ' dummy
    parse var line4 line5 ' ID ' dummy
    parse var line5 line6 ' FOR ' dummy
    parse var line6 linef ';' dummy
    linef= space(translate(linef, '  ', '()'))
    woord= ""
    do while words(linef)> 0
      parse var linef woord linef
    end
    if woord= "" then
      woord= " "
    if (left(woord,1)= '[') & (right(woord,1)= ']') then
      woord= space(translate(woord, '  ', '[]'))
    else
      woord= 'notIPaddress'
    if verify(woord,'1234567890.')= 0 then
    do
      parse var woord byte1 '.' byte2 '.' byte3 '.' byte4
      if (datatype(byte1,'W'))&(datatype(byte2,'W'))&(datatype(byte3,'W'))&(datatype(byte4,'W')) then
        if (byte1<256)&(byte2<256)&(byte3<256)&(byte4<256) then
          IPaddress= space(woord)
    end

    /* if nothing found, just check the whole line */
    if IPaddress= 0 then
    do
      linef= space(translate(uline, '  ', '[]'))
      linef= space(translate(linef, '  ', '()'))
      do while words(linef)> 0
        parse var linef woord linef
        if verify(woord,'1234567890.')= 0 then
        do
          parse var woord byte1 '.' byte2 '.' byte3 '.' byte4
          if (datatype(byte1,'W'))&(datatype(byte2,'W'))&(datatype(byte3,'W'))&(datatype(byte4,'W')) then
            if (byte1<256)&(byte2<256)&(byte3<256)&(byte4<256) then
            do
              IPaddress= space(woord)
/*
              linef= ''
*/
            end
        end
      end
    end

    if \(IPaddress= 0) then
    do
      if SkipLastHops> 0 then
      do
        call WriteLog 3,'Received from: 'IPaddress', skipping this hop.'
        SkipLastHops= SkipLastHops- 1
      end
      else
      do
        parse var IPaddress byte1 '.' byte2 '.' byte3 '.' byte4
        select
          when byte1< 1 then
            call WriteLog 4,'Received from: 'IPaddress', skipping, class A reserved range.'
          when byte1= 10 then
            call WriteLog 4,'Received from: 'IPaddress', skipping, private class A range.'
          when byte1= 127 then
            call WriteLog 4,'Received from: 'IPaddress', skipping, loopback range.'
          when (byte1= 172) & (byte2> 15) & (byte2< 32) then
            call WriteLog 4,'Received from: 'IPaddress', skipping, private class B range.'
          when (byte1= 192) & (byte2= 168) then
            call WriteLog 4,'Received from: 'IPaddress', skipping, private class C range.'
          when (byte1> 223) & (byte1< 240) then
            call WriteLog 4,'Received from: 'IPaddress', skipping, class D multicast range.'
          when byte1> 239 then
            call WriteLog 4,'Received from: 'IPaddress', skipping, class E reserved range.'
          when pos(IPaddress, SkipIPs)> 0 then
            call WriteLog 3,'Received from: 'IPaddress', skipping as requested in .ini.'
          when pos(IPaddress, IPaddresses)> 0 then
            call WriteLog 4,'Received from: 'IPaddress', skipping, already queued for testing.'
          otherwise
          do
            hitaddress= IPaddress
            call WriteLog 3,'Received from: 'IPaddress', queued for testing.'
          end
        end /* select */
      end
    end
  end
  otherwise
    nop
end /* select */
return hitaddress

verderhier:
call Writelog 1,'--- Error on line 'SIGL'! Aborting.'
exit
