/* YEPuMAX - Trim Yep URL Log to the most recent X number of entries
 
 - please edit the line below to reflect the path/filename of your Log,
   or specify filename on command line. I.E. YEPuMAX url.log >my-new.log
 - please edit the variable below for the default maximum number of URLs
   to keep, or specify as -second- command line parameter.
   I.E. YEPuMAX url.log 50
 - The Url Log will be backed up and then overwritten with the new Url Log.   
   
*/

UrlLog = 'd:\tm\url.log'
UrlLogBackup = 'd:\tm\url.bak'
Keep = 100


/* don't touch theses */
BetweenRecords = 1;
UrlNum = 0
URLS. = ''
All. = ''
Records = 0

Parse arg ln cKeep
if (ln \= '') then UrlLog = ln
if (cKeep > 0) then Keep = cKeep

ret = stream(UrlLog,'c','open read')
if ret <> 'READY:' then do
    say 'Can not open URL Log "'UrlLog'" to read.'
    exit
end

say 'Keeping only the 'keep' most recent urls in 'UrlLog'...'

/* suck in urls to stem -- with dupe elimination */
do while lines(UrlLog)<>0
    ln = linein(UrlLog)
    if (ln \= '') & (BetweenRecords = 1) then do
        BetweenRecords = 0;        
        RecordLines = 0
        Duplicate = 0
        Records = Records + 1
    end
    
    if (ln \= '') & (BetweenRecords = 0) & (duplicate = 0) then do
        RecordLines = RecordLines + 1
        Arecord.RecordLines = ln
        if SubStr(ln,1,4) == 'URL:' then do
            do x = 1 to UrlNum 
                if URLS.x = ln then Duplicate = 1
            end
            if Duplicate = 0 then do
                UrlNum = UrlNum + 1
                URLS.UrlNum = ln
            end            
        end
    end
    
    if (ln == '') & (BetweenRecords = 0) then do
        betweenRecords = 1;
        if Duplicate = 0 then do
            All.UrlNum.0 = RecordLines
            do x = 1 to RecordLines 
                All.UrlNum.x = Arecord.x
            end
        end
    end    
end
ret = stream(UrlLog,'c','close')

/* backup, delete, and output */
'@copy '||UrlLog||' '||UrlLogBackUp||' >nul'
'@del '||UrlLog||' >nul'

/* output */
ret = stream(UrlLog,'c','open write');
if ret = 'READY:' then do

    StartUrl = UrlNum - Keep + 1
    if StartUrl < 1 then StartUrl = 1
    if StartUrl > 0 then do
        do x = StartUrl to UrlNum
            do y = 1 to All.x.0
                ret = lineout(urlLog, All.x.y)
            end
            ret = lineout(urlLog, '')
        end
    end

end
else do
     say 'Warning: could not update '||UrlLog||'! Restoring backup.'
     '@copy '||UrlLogBackup||' '||UrlLog||' >nul'
     if rc = 0 then say 'Backup restored successfully.'
     else say UrlLogBackUp||' could not be restored! You better look into it.'
end

say 'Done processing 'UrlNum' Urls. ('keep' kept, 'StartUrl - 1' old urls trimmed)'

