// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1998.
// ---------------------------------------------------------------------------
//  About Dialog Box for M88
// ---------------------------------------------------------------------------
//  $Id: about.cpp,v 1.18 1999/07/22 15:57:28 cisc Exp $

#include "headers.h"
#include "resource.h"
#include "about.h"

// ---------------------------------------------------------------------------
//  \z/
//
#ifdef __OS2__
static M88About *about;
M88About::M88About()
{
    about = this;
}
#else
M88About::M88About()
{
    dlgproc.SetDestination(DlgProcGate, this);
}
#endif

// ---------------------------------------------------------------------------
//  _CAO\
//
#ifdef __OS2__
void M88About::Show(HWND hwndparent)
{
DosEnterCritSec();
    WinDlgBox( HWND_DESKTOP, hwndparent, DlgProcGate, NULLHANDLE, IDD_ABOUT, NULL );
DosExitCritSec();
}
#else
void M88About::Show(HINSTANCE hinst, HWND hwndparent)
{
    DialogBox(hinst, MAKEINTRESOURCE(IDD_ABOUT),
                hwndparent, DLGPROC((void*) dlgproc));
}
#endif

// ---------------------------------------------------------------------------
//  _CAO
//
#ifdef __OS2__
MRESULT M88About::DlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    char buf[256];

    switch (msg)
    {
        case WM_INITDLG:
            sprintf(buf, "M88 for Win32 (rel 2.10)\n"
                      "PC-8801 series emulator.\n"
                      "Copyright (C) cisc 1998, 1999.\n" );

            WinSetDlgItemText(hwnd, IDC_ABOUT_TEXT, buf);

            WinSetDlgItemText(hwnd, IDC_ABOUT_BOX, abouttext);

//            WinSetFocus(GetDlgItem(hwnd, DID_OK)); @@@
            return 0;

        case WM_COMMAND:
            switch( COMMANDMSG(&msg)->cmd )
            {
                case DID_OK:
                case DID_CANCEL:
                    WinDismissDlg( hwnd, TRUE );
                    return 0;
            }
            break;
    }
    return WinDefDlgProc( hwnd, msg, mp1, mp2 );
}

static MRESULT EXPENTRY M88About::DlgProcGate(HWND hwnd, ULONG m, MPARAM w, MPARAM l)
{
    return about->DlgProc(hwnd, m, w, l);
}
#else
BOOL M88About::DlgProc(HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
    char buf[256];

    switch (msg)
    {
    case WM_INITDIALOG:
        wsprintf(buf, "M88 for Win32 (rel 2.10)\n"
                      "PC-8801 series emulator.\n"
                      "Copyright (C) cisc 1998, 1999.\n" );

        SetDlgItemText(hdlg, IDC_ABOUT_TEXT, buf);

        SetDlgItemText(hdlg, IDC_ABOUT_BOX, abouttext);

        SetFocus(GetDlgItem(hdlg, IDOK));
        return 0;

    case WM_COMMAND:
        if (IDOK == LOWORD(wp))
        {
            EndDialog(hdlg, true);
            break;
        }
        return true;

    case WM_CLOSE:
        EndDialog(hdlg, false);
        return true;

    default:
        return false;
    }
    return false;
}

BOOL _cdecl M88About::DlgProcGate
(M88About* about, HWND hwnd, UINT m, WPARAM w, LPARAM l)
{
    return about->DlgProc(hwnd, m, w, l);
}
#endif

// ---------------------------------------------------------------------------
//  about p̃eLXg
//
const char M88About::abouttext[] =
    "build date:"__DATE__"\r\n"
    "\r\n"
    "zEv]EoO񍐂Ȃǂ M88 ̃y[W\r\n"
    "http://www.remus.dti.ne.jp/~cisc/m88/\r\n"
    "ւǂD\r\n"
    "\r\n"
    "FM jbg̍쐬ɂẮC\r\n"
    "BV fm.c QlɂĂ܂D\r\n"
    "\r\n"
    "N80 [h arearea ̃R[hɎĂ܂B\r\n"
    ;

