// ---------------------------------------------------------------------------
//  M88 - PC8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  DirectDraw ɂEChEʕ`
// ---------------------------------------------------------------------------
//  $Id: drawddw.h,v 1.1 1999/04/06 06:14:08 cisc Exp $

#if !defined(win32_drawddw_h)
#define win32_drawddw_h

#include "WinDraw.h"

// ---------------------------------------------------------------------------

class WinDrawDDW : public WinDrawSub
{
public:
    WinDrawDDW();
    ~WinDrawDDW();

    bool Init(HWND hwnd);
    void Resize(uint width, uint height);
    bool Cleanup();

    void SetPalette(PALETTEENTRY* pal);
    void QueryNewPalette();
    void DrawScreen(int top, int bottom, bool refresh);
    bool Lock(uint8** pimage, int* pbpl);
    bool Unlock();

private:
    bool CreateDDPalette();
    bool CreateDD2();
    bool CreateDDS();
    bool RestoreSurface();
    HWND hwnd;

#ifdef __OS2__
    static void Convert8bpp(void* dest, const uint8* src, RECTL* rect, int pitch);
#else
    static void Convert8bpp(void* dest, const uint8* src, RECT* rect, int pitch);
#endif

#ifdef __OS2__
#else
    LPDIRECTDRAW2 ddraw;
    LPDIRECTDRAWPALETTE ddpal;

    LPDIRECTDRAWSURFACE ddsscrn;
    LPDIRECTDRAWCLIPPER ddcscrn;

    LPDIRECTDRAWSURFACE ddswork;
#endif

    uint8* image;
    int bpl;
    uint32 redmask;
    uint32 greenmask;
    uint32 bluemask;
    uint8 redshift;
    uint8 greenshift;
    uint8 blueshift;
    bool scrnhaspal;
    bool palchanged;

    PALETTEENTRY palentry[256];
};

#endif // !defined(win32_drawddw_h)
