/*
   Script to Create PMNapster Objects
   By: Ricardo Mayrink - 01/02/2001

*/

/* Loading REXXUTIL Functions */
ok = RxFuncAdd( 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs' )
ok = SysLoadFuncs()


/* PMNapster Directory */
PMNDir = Directory()

/* Getting OS/2 version */
OS2Ver = SysOS2Ver()
say "OS/2 Version: "OS2Ver

/* Create PMNapster Folder Object in: */
if OS2Ver > 2.30 then
  Folder = '<WP_PROGRAMSFOLDER>'
else
  Folder = '<WP_DESKTOP>'

say "Creating PMNapster Folder..."

/* Create PMNapster Folder */
rc = SysCreateObject( 'WPFolder', "PMNapster for OS/2", Folder,,
  'OBJECTID=<NAPSTEROS2FOLDER>;'||,
  'NOPRINT=YES;'||,
  'ICONVIEW=NONGRID,NORMAL;'||,
  'TREEVIEW=LINES,NORMAL;'||,
  'DETAILSVIEW=MINI;'||,
  'ICONFONT=8.Helv;'||,
  'DETAILSFONT=8.Helv;'||,
  'TREEFONT=8.Helv;'||,
  'ALWAYSSORT=YES;',,
  'UPDATE' )

Say "Creating PMNapster Objects..."

/* Create PMNapster Objects */
assoc = "ASSOCFILTER=*.MP3"
call SysCreateObject "WPProgram", "ID3 TAG Editor", "<NAPSTEROS2FOLDER>","OBJECTID=<ID3Editor>;EXENAME="PMNDir"\EditID3.exe;STARTUPDIR=" || PMNDir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"assoc, "F"
call SysSetObjectData "<ID3Editor>", "Title=ID3 TAG Editor"
assoc = ''
call SysCreateObject "WPProgram", "PMNapster 3 - Debug", "<NAPSTEROS2FOLDER>","OBJECTID=<NAPSTEROS2DBG>;EXENAME="PMNDir"\napster.exe;STARTUPDIR=" || PMNDir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;PARAMETERS=debug;", "U"
call SysSetObjectData "<NAPSTEROS2DBG>", "Title=PMNapster 3 - Debug"
call SysCreateObject "WPProgram", "PMNapster 3", "<NAPSTEROS2FOLDER>","OBJECTID=<NAPSTEROS2OBJ>;EXENAME="PMNDir"\napster.exe;STARTUPDIR=" || PMNDir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;", "U"
call SysSetObjectData "<NAPSTEROS2OBJ>", "Title=PMNapster 3"
call SysCreateObject "WPProgram", "Read me", "<NAPSTEROS2FOLDER>","EXENAME=E.exe;STARTUPDIR=" || instpath || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;PARAMETERS=readme.txt;", "U"
call SysCreateObject "WPProgram", "PMNapster History", "<NAPSTEROS2FOLDER>","EXENAME=E.exe;STARTUPDIR=" || instpath || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;PARAMETERS=history.txt;", "U"
call SysCreateObject "WPProgram", "PMNapster Homepage", "<NAPSTEROS2FOLDER>","EXENAME=netscape.exe;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;PARAMETERS=" || "http://www.os2world.com/pmnapster", "U"

ok = SysINI('User', 'Napster2', 'INSTALL',  PMNDir)

Return 0

