#include "filehandler.h"

FileHandler::FileHandler()
{
    file = new QFile();
}

FileHandler::~FileHandler()
{
    delete file;
}

QString FileHandler::cutFilePath(const QString& path)
{
    QString tmpFileName;

    // windows 7 extrawurst
    tmpFileName = path.right(
            path.size() - path.lastIndexOf('\\') - 1 );

    if( path.count() == tmpFileName.count() )
        tmpFileName = path.right(
                path.size() - path.lastIndexOf('/') - 1 );

    return tmpFileName;
}

void FileHandler::setFileList(QStringList fileList)
{
    reset();

    fileNames = fileList;
}

QStringList& FileHandler::getFileList()
{
    return fileNames;
}

qint64 FileHandler::getTotalFileSize()
{
    qint64 size = 0;

    for( int i = 0; i < fileNames.count(); i++ )
    {
        QFile tmpFile(fileNames[i]);

        size += tmpFile.size();
    }

    return size;
}

QFile* FileHandler::getNextFile()
{
    if( fileNames.count() > 0 )
    {
        file->setFileName(fileNames[0]);
        fileNames.removeAt(0);

        return file;
    }

    return NULL;
}

QString& FileHandler::getAbsolutePath()
{
    return absolutePath;
}

QStringList& FileHandler::getFolders(const QString& path)
{
    absolutePath = path;

    reset();
    recursiveDirectory(path);

    return folderNames;
}

QStringList& FileHandler::getFiles(const QString& path)
{
    absolutePath = path;

    reset();
    recursiveFile(path);

    return fileNames;
}

QStringList& FileHandler::getFoldersFiles(const QString& path)
{
    absolutePath = path;

    reset();
    recursiveFile(path);

    folderFileNames = folderNames + fileNames;

    return folderFileNames;
}

void FileHandler::recursiveDirectory(const QString& path)
{
    QDir dir(path);

    foreach( QString tmpFolder, dir.entryList(QDir::AllDirs | QDir::NoDotAndDotDot) )
        folderNames.append( "/" + tmpFolder );

    for( int i = 0; i < folderNames.count(); i++ )
    {
        dir.setPath( path + folderNames[i] );

        foreach( QString tmpFolder, dir.entryList(QDir::AllDirs | QDir::NoDotAndDotDot) )
            folderNames.append( folderNames[i] + "/" + tmpFolder );
    }
}

void FileHandler::recursiveFile(const QString& path)
{
    recursiveDirectory(path);

    QDir dir(path);

    foreach( QString tmpFile, dir.entryList(QDir::Files | QDir::NoDotAndDotDot) )
        fileNames.append( "/" + tmpFile );

    foreach(QString tmpFolder, folderNames)
    {
        dir.setPath( path + tmpFolder );

        foreach( QString tmpFile, dir.entryList(QDir::Files | QDir::NoDotAndDotDot) )
            fileNames.append( tmpFolder + "/" + tmpFile );
    }
}

void FileHandler::reset()
{
    fileNames.clear();
    folderNames.clear();
    folderFileNames.clear();
}
