#include "mainwindow.h"
#include "ui_mainwindow.h"

//#ifdef Q_OS_WIN
//    #include <windows.h>
//    #include <shellapi.h>
//#endif

MainWindow::MainWindow(SimpleNetwork *simpleNetwork, QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::MainWindow),
        cWin(new ConnWindow),
        sNet(simpleNetwork),
        oWin(new OptionWindow),
        iWin(new InfoWindow),
        mWin(new MessageWindow),
        file(new QFile)
{
    ui->setupUi(this);
    translate();

    loadPlugin();

    //moves the window to the center of the screen
    this->move( (QApplication::desktop()->width() / 2) - (this->width() / 2)-230,
                (QApplication::desktop()->height() / 2) - (this->height() / 2) );

    blinkTimer.start(1000);

    //creates signal slot connections
    signalSlots();

    //window basics
    this->setFixedWidth(550);

    //shows connectors IP-Adress
    this->setWindowTitle( tr("QtCumber - Connected to: %1").arg(sNet->getPeerAddress()) );
    ui->statusBar->showMessage( tr("Click on the browse button (folder icon) or drag and drop to upload a file!") );

    QDir dlDir( qApp->applicationDirPath() );
    dlDir.cdUp();
    if( !dlDir.cd("downloads") )
    {
        dlDir.mkdir("downloads");
        dlDir.cd("downloads");
    }

    QSettings settings(tr("%1/save.ini").arg(qApp->applicationDirPath()),QSettings::IniFormat);
    QString tmp = settings.value("filesavepath", dlDir.path()).toString();

    if( !QFile::exists(tmp) )
    {
        settings.setValue( "filesavepath", dlDir.path() );
        tmp = dlDir.path();
    }

    sNet->setFileSavePath(tmp);
}

void MainWindow::translate()
{
    ui->retranslateUi(this);
}

MainWindow::~MainWindow()
{
    delete ui;
    delete cWin;
    delete oWin;
    delete iWin;
    delete mWin;
    delete sNet;
}
//------------------------------------------------------------------------
void MainWindow::signalSlots()
{

    connect(sNet,SIGNAL(emitConnectionClosed()),
            this,SLOT(disconnected()));

    connect(sNet,SIGNAL(emitDataReceived(int,QByteArray)),
            this,SLOT(dataReceived(int,QByteArray)));

    connect(sNet,SIGNAL(emitFileReceived(int)),
            this,SLOT(fileReceived(int)));

    connect(mWin,SIGNAL(emitCustomPath(QString)),
            this,SLOT(customPath(QString)));

    connect(mWin,SIGNAL(emitDefaultPath()),
            this,SLOT(defaultPath()));

    connect(oWin,SIGNAL(emitOptionAccept(QString)),
            this,SLOT(optionAccept(QString)));

    connect(sNet,SIGNAL(emitFileProgressIn(int,qint64,qint64)),
            this,SLOT(fileProgressIn(int,qint64,qint64)));

    connect(sNet,SIGNAL(emitFileProgressOut(int,qint64,qint64)),
            this,SLOT(fileProgressOut(int,qint64,qint64)));

    connect(sNet,SIGNAL(emitDownSpeed(int)),
            this,SLOT(downSpeed(int)));

    connect(sNet,SIGNAL(emitUpSpeed(int)),
            this,SLOT(upSpeed(int)));

    connect(mWin,SIGNAL(emitRequestDecline()),
            this,SLOT(requestDecline()));

    connect( sNet, SIGNAL(emitTransmitTerminated(int)),
             this, SLOT(transmitTerminated(int)) );

    connect( &blinkTimer, SIGNAL(timeout()),
             this, SLOT(blinker()) );
}
//------------------------------------------------------------------------
void MainWindow::request(QByteArray data)
{
    // ### read file attributes
    QStringList dataList;
    QDataStream out(&data,QIODevice::ReadWrite);
    out >> dataList;

    totalFileSizeIn = dataList.at(2).toDouble();

    mWin->setData(dataList.at(0), dataList.at(1).toDouble(), dataList.at(2).toDouble(), dataList.at(3));

    if( dataList.at(0).count() > 46 )
        ui->l_rec_filename->setText( dataList.at(0).left(42) + "..." +
                                     dataList.at(0).right(dataList.at(0).count() - dataList.at(0).lastIndexOf('.')) );
    else
        ui->l_rec_filename->setText( dataList.at(0) );

    out >> fileNames;
    // ###########################

    ui->pbar_rece_total->setFormat("%v/%m");
    ui->pbar_rece_total->setMaximum( fileNames.count() + 1 );
    ui->pbar_rece_total->setValue(0);

    // opens the MessageWindow
    mWin->show();
}
//------------------------------------------------------------------------
void MainWindow::transmit()
{
    // transmits the selected file
    sNet->transmitFile( 1, file->fileName() );

    ui->pb_browse->setIcon( QIcon(":/Icons/Icons/Folder-icon.png") );
    ui->pb_browse->setProperty("pending", false);
    ui->gbox_browse->setEnabled(false);
    ui->pb_trans_cancel->setEnabled(true);
    ui->pbar_trans_current->setMaximum(100);
    ui->pbar_trans_current->setValue(0);
    ui->pbar_trans_total->setFormat("%v/%m");
    ui->pbar_trans_total->setMaximum(fHandler.getFileList().count() + 1);
    ui->pbar_trans_total->setValue(0);

    ui->statusBar->showMessage( tr("%1: Transfer has been started").arg(QTime::currentTime().toString()) );
}
//------------------------------------------------------------------------
void MainWindow::declineRequest()
{
    // resets the labels
    ui->pb_browse->setIcon( QIcon(":/Icons/Icons/Folder-icon.png") );
    ui->pb_browse->setProperty("pending", false);
    ui->l_trans_filename->clear();

    ui->statusBar->showMessage( tr("%1: Request has been declined!").arg(QTime::currentTime().toString()) );
}
//------------------------------------------------------------------------
void MainWindow::cancelBrowse()
{
    // cancels the request
    mWin->close();

    ui->l_rec_filename->clear();
    ui->pbar_rece_total->setValue(0);
    ui->pbar_rece_total->setFormat("?/?");

    ui->statusBar->showMessage( tr("%1: Request has been canceled!").arg(QTime::currentTime().toString()) );
}
//------------------------------------------------------------------------
void MainWindow::successfullTransmit()
{
    if( !fHandler.getFileList().isEmpty() )
    {
        file = fHandler.getNextFile();
        totalFileSizeOut = ui->l_trans_mbleft_total->text().remove(" Gb").toDouble() * 1024;

        QString tmpFileName = FileHandler::cutFilePath( file->fileName() );

        if( tmpFileName.count() > 46 )
            ui->l_trans_filename->setText( tmpFileName.left(42) + "..." +
                                           tmpFileName.right(tmpFileName.count() - tmpFileName.lastIndexOf('.')) );
        else
            ui->l_trans_filename->setText( tmpFileName );

        ui->pbar_trans_total->setValue( ui->pbar_trans_total->maximum() - fHandler.getFileList().count() - 1 );

        sNet->transmitFile( 1, file->fileName() );

        return;
    }

    // set labels
    ui->l_trans_mbleft_total->setText("Finished");
    ui->l_trans_mbleft_current->setText("Finished");
    ui->l_trans_filename->setText("successfully finished");
    ui->pbar_trans_total->setValue( ui->pbar_trans_total->maximum() );
    ui->l_trans_speed->setText("0 kb/s");
    ui->gbox_browse->setEnabled(true);
    ui->pb_trans_cancel->setDisabled(true);
    ui->statusBar->showMessage( tr("%1: Transfer successfully finished!").arg(QTime::currentTime().toString()) );
}
//------------------------------------------------------------------------
void MainWindow::receivedFile()
{
    sNet->transmitData(7,0); // 7: successfully transmitted

    if( !fileNames.isEmpty() )
    {
        ui->pbar_rece_total->setValue( ui->pbar_rece_total->maximum() - fileNames.count() );
        totalFileSizeIn = ui->l_rece_mbleft_total->text().remove(" Gb").toDouble() * 1000;


        QString tmpFileName = FileHandler::cutFilePath(fileNames[0]);

        if( tmpFileName.count() > 46 )
            ui->l_rec_filename->setText( tmpFileName.left(42) + "..." +
                                         tmpFileName.right(tmpFileName.count() - tmpFileName.lastIndexOf('.')) );
        else
            ui->l_rec_filename->setText( tmpFileName );


        fileNames.removeAt(0);

        return;
    }

    // set labels
    ui->l_rece_mbleft_total->setText("Finished");
    ui->l_rece_mbleft_current->setText("Finished");
    ui->l_rec_filename->setText("successfully finished");
    ui->l_rec_speed->setText("0 kb/s");
    ui->pbar_rece_current->setMaximum(100);
    ui->pbar_rece_current->setValue(100);
    ui->pbar_rece_total->setValue( ui->pbar_rece_total->maximum() );
    ui->pb_res_cancel->setDisabled(true);
    ui->statusBar->showMessage( tr("%1: Transfer successfully finished!").arg(QTime::currentTime().toString()) );
}
//------------------------------------------------------------------------
void MainWindow::resetReceiveTransfer()
{
    sNet->resetReceiveTransfer(1);

    ui->l_rec_filename->clear();
    ui->pb_res_cancel->setDisabled(true);
    ui->pbar_rece_current->setMaximum(100);
    ui->pbar_rece_current->setValue(0);
    ui->pbar_rece_total->setValue(0);
    ui->pbar_rece_total->setFormat("?/?");
    ui->l_rece_mbleft_total->setText("0 Gb");
    ui->l_rece_mbleft_current->setText("0 Mb");
    ui->l_rec_speed->setText("0 kb/s");

    ui->statusBar->showMessage( tr("%1: Transfer has been canceled").arg(QTime::currentTime().toString()) );
}

//------------------------------------------------------------------------
bool MainWindow::loadPlugin()
{
    QDir pluginsDir( qApp->applicationDirPath() );
    pluginsDir.cd("../plugins");

    foreach (QString fileName, pluginsDir.entryList(QDir::Files))
    {
        QPluginLoader pluginLoader(pluginsDir.absoluteFilePath(fileName));
        QObject *plugin = pluginLoader.instance();

        if (plugin)
        {
            PlugInterface *tmpPlug = qobject_cast<PlugInterface *>(plugin);

            if (tmpPlug)
            {
                plugInterface.append( tmpPlug );
                plugInterface.last()->setBlink(false);

                QIcon icon = plugInterface.last()->addPlugIn(sNet);

                plugInButton.append(new QPushButton);
                plugInButton.last()->setObjectName( plugInterface.last()->pName() );

                connect( plugInButton.last(), SIGNAL(clicked()),
                         this, SLOT(executePlugIn()) );

                plugInButton.last()->setCheckable(true);
                plugInButton.last()->setFixedSize(58, 58);
                plugInButton.last()->setIconSize( QSize(48, 48) );
                plugInButton.last()->setIcon(icon);

                ui->vl_plugInButtons->addWidget( plugInButton.last() );

                return true;
            }
        }
    }

    return false;
}

/*************************************************************************
========================[ SLOTS ]=========================================
*************************************************************************/

void MainWindow::disconnected()
{
    QMessageBox::information( 0, tr("Disconected"), tr("The session has been disconnected") );

    // restarts the programm on a disconnect
    QProcess::startDetached( "\"" + QApplication::applicationFilePath() + "\"" );
    exit(0);
}
//------------------------------------------------------------------------
void MainWindow::dataReceived(int id, QByteArray data)
{
    // controlles the communication with IDs
    switch(id)
    {
    case 5:
        request(data);
        break;
    case 6:
        transmit();
        break;
    case 7:
        successfullTransmit();
        break;
    case 8:
        declineRequest();
        break;
    case 9:
        cancelBrowse();
        break;
    case 20:
        resetReceiveTransfer();
        break;
    case 21:
        on_pb_trans_cancel_clicked();
        break;
    }
}
//------------------------------------------------------------------------
void MainWindow::fileReceived(int id)
{
    // switch to received file according to id
    switch(id)
    {
    case 1:
        receivedFile();
        break;
    }
}
//------------------------------------------------------------------------
void MainWindow::transmitTerminated(const int ID)
{
    switch (ID)
    {
    case 1:

        sNet->transmitData(20, 0); // 20: reset receive transfer

        ui->l_trans_filename->clear();
        ui->pb_trans_cancel->setDisabled(true);
        ui->gbox_browse->setEnabled(true);
        ui->pbar_trans_current->setMaximum(100);
        ui->pbar_trans_current->setValue(0);
        ui->pbar_trans_total->setValue(0);
        ui->pbar_trans_total->setFormat("?/?");
        ui->l_trans_speed->setText("0 kb/s");
        ui->l_trans_mbleft_total->setText("0 Gb");
        ui->l_trans_mbleft_current->setText("0 Mb");

        ui->statusBar->showMessage( tr("%1: Transfer has been canceled").arg(QTime::currentTime().toString()) );

        break;
    }
}

void MainWindow::customPath(QString savePath)
{
    ui->pb_res_cancel->setEnabled(true);
    ui->pbar_rece_current->setMaximum(100);
    ui->pbar_rece_current->setValue(0);

    // sets the custom path for incoming data
    sNet->setFileSavePath(savePath);

    sNet->transmitData(6,0); // 6: transmit

    ui->statusBar->showMessage( tr("%1: Transfer has been started").arg(QTime::currentTime().toString()) );
}
//------------------------------------------------------------------------
void MainWindow::defaultPath()
{
    ui->pb_res_cancel->setEnabled(true);
    ui->pbar_rece_current->setMaximum(100);
    ui->pbar_rece_current->setValue(0);

    sNet->transmitData(6,0); // 6: transmit

    ui->statusBar->showMessage( tr("%1: Transfer has been started").arg(QTime::currentTime().toString()) );
}
//------------------------------------------------------------------------
void MainWindow::optionAccept(QString path)
{
    translate();
    iWin->translate();
    oWin->translate();
    iWin->translate();
    mWin->translate();

    //set the default path
    sNet->setFileSavePath(path);
}
//------------------------------------------------------------------------
void MainWindow::fileProgressIn(int id,qint64 progress,qint64 max)
{
    ui->l_rece_mbleft_current->setText( tr("%1 Mb")
                                        .arg( (float)max / 1048576 - (float)progress / 1048576, 0, 10, 1, 0) );
    ui->l_rece_mbleft_total->setText( tr("%1 Gb")
                                      .arg( (totalFileSizeIn - (float)progress / 1048576) / 1000, 0, 10, 2, 0) );

    //show the progress for incoming data
    if(max >= 1024)
    {
        max /= 1024;
        progress /= 1024;
    }

    switch(id)
    {
    case 1:
        ui->pbar_rece_current->setMaximum(max);
        ui->pbar_rece_current->setValue(progress);
    }
}
//------------------------------------------------------------------------
void MainWindow::fileProgressOut(int id,qint64 progress,qint64 max)
{
    ui->l_trans_mbleft_current->setText( tr("%1 Mb")
                                         .arg( (float)max / 1048576 - (float)progress / 1048576, 0, 10, 1, 0) );
    ui->l_trans_mbleft_total->setText( tr("%1 Gb")
                                       .arg( (totalFileSizeOut - (float)progress / 1048576) / 1000, 0, 10, 2, 0) );

    //show the progress for outgoing data
    if(max >= 1024)
    {
        max /= 1024;
        progress /= 1024;
    }

    switch(id)
    {
    case 1:
        ui->pbar_trans_current->setMaximum(max);
        ui->pbar_trans_current->setValue(progress);
    }
}
//------------------------------------------------------------------------
void MainWindow::downSpeed(int speed)
{
    // shows the speed of incoming data and converts to kb,MB
    if( ui->pbar_rece_current->value() > 1 &&
        ui->pbar_rece_current->value() != ui->pbar_rece_current->maximum() )
    {
        if( speed > 1048576 )
        {
            ui->l_rec_speed->setText( tr("%1 mb/s")
                                      .arg((float)speed / 1048576, 0, 10, 1, 0) );
        }

        else
        {
            ui->l_rec_speed->setText( tr("%1 kb/s")
                                      .arg((float)speed / 1024, 0, 10, 1, 0) );
        }
    }
}
//------------------------------------------------------------------------
void MainWindow::upSpeed(int speed)
{
    // shows the speed of outgoing data and converts to kb,MB
    if( ui->pbar_trans_current->value() > 1 &&
        ui->pbar_trans_current->value() != ui->pbar_trans_current->maximum() )
    {
        if( speed > 1048576 )
        {
            ui->l_trans_speed->setText( tr("%1 mb/s")
                                        .arg((float)speed / 1048576, 0, 10, 1, 0) );
        }

        else
        {
            ui->l_trans_speed->setText( tr("%1 kb/s")
                                        .arg((float)speed / 1024, 0, 10, 1, 0) );
        }
    }
}
//------------------------------------------------------------------------
void MainWindow::requestDecline()
{
    sNet->transmitData(8,0); // 8: decline the request
    ui->l_rec_filename->clear();
    ui->pbar_rece_total->setValue(0);
    ui->pbar_rece_total->setFormat("?/?");

    ui->statusBar->showMessage( tr("%1: You have declined the request!").arg(QTime::currentTime().toString()) );
}
//----------------- DISCONNECT ------------------------------------------------
void MainWindow::on_pb_disconnect_clicked()
{
    if( QMessageBox::warning( 0, tr("Disconnect"), tr("Do you really want to disconnect?"),
                              QMessageBox::Yes|QMessageBox::No, QMessageBox::No ) == QMessageBox::No )
        return;

    if( ui->pb_res_cancel->isEnabled() )
        on_pb_res_cancel_clicked();
    if( ui->pb_trans_cancel->isEnabled() )
        on_pb_trans_cancel_clicked();

    //restart the programm on disconnect clicked
    QProcess::startDetached( "\"" + QApplication::applicationFilePath() + "\"" );
    exit(0);
}
//----------------- OPEN - CLOSE - PLUGINLIST ---------------------------------
//void MainWindow::on_pb_open_clicked()
//{
//    // opens the plugin-list
//    this->setFixedWidth(578);
//    this->move(this->x()-45,this->y());
//    ui->pb_open->hide();
//}
//void MainWindow::on_pb_close_clicked()
//{
//    // closes the plugin-list
//    this->setFixedWidth(488);
//    this->move(this->x()+45,this->y());
//    ui->pb_open->show();
//}
//----------------- OPEN - OPTION WINDOW --------------------------------------
void MainWindow::on_pb_options_clicked()
{
    oWin->open();                   //shows the OptionWindow
}
//----------------- OPEN - INFO WINDOW ----------------------------------------
void MainWindow::on_pb_about_clicked()
{
    iWin->open();                   //shows the OptionWindow
}
//----------------- EXIT ------------------------------------------------------
void MainWindow::on_pb_exit_clicked()
{
    if( QMessageBox::warning( 0, tr("Exit"), tr("Do you really want to exit the application?"),
                              QMessageBox::Yes|QMessageBox::No, QMessageBox::No ) == QMessageBox::No )
        return;

    if( ui->pb_res_cancel->isEnabled() )
        on_pb_res_cancel_clicked();
    if( ui->pb_trans_cancel->isEnabled() )
        on_pb_trans_cancel_clicked();

    exit(0);
}
//----------------- FILE BROWSE - REQUEST ------------------------------------------------------
void MainWindow::on_pb_browse_clicked()
{
    // if no file is pending -> browse
    if( !ui->pb_browse->property("pending").toBool() )
    {
        fHandler.setFileList( QFileDialog::getOpenFileNames( 0, "Select File(s)", QDir::homePath()) );

        if( fHandler.getFileList().isEmpty() )
            return;

        totalFileSizeOut = (float)fHandler.getTotalFileSize() / 1048576;
        file = fHandler.getNextFile();

        // determine filename
        QString tmpFileName = FileHandler::cutFilePath( file->fileName() );

        // shortening the string
        if( tmpFileName.count() > 46 )
            ui->l_trans_filename->setText( tmpFileName.left(42) + "..." +
                                           tmpFileName.right(tmpFileName.count() - tmpFileName.lastIndexOf('.')) );
        else
            ui->l_trans_filename->setText( tmpFileName );


        QStringList tmpFileNames;
        foreach( QString tmp, fHandler.getFileList() )
            tmpFileNames.append( FileHandler::cutFilePath(tmp) );

        // ### sends file attributes
        QStringList dataList;
        dataList.clear();
        dataList.append(tmpFileName);
        dataList.append( tr("%1").arg(fHandler.getFileList().count() + 1) );
        dataList.append( tr("%1").arg((float)(fHandler.getTotalFileSize() + file->size()) / 1048576, 0, 10, 1, 0) );
        dataList.append("file");

        QByteArray arr;
        QDataStream in(&arr, QIODevice::WriteOnly);
        in << dataList;
        in << tmpFileNames;

        sNet->transmitData(5,arr); // 5: request
        // #############################

        ui->pb_browse->setIcon( QIcon(":/Icons/Icons/Cute-Ball-Stop-icon.png") );
        ui->pb_browse->setProperty("pending", true);

        ui->statusBar->showMessage( tr("%1: You have sent a file transfer request").arg(QTime::currentTime().toString()) );
    }

    // if filetransfer is pending -> cancel
    else
    {
        sNet->transmitData(9,0); // 9: cancel pending file

        ui->pb_browse->setIcon( QIcon(":/Icons/Icons/Folder-icon.png") );
        ui->pb_browse->setProperty("pending", false);
        ui->l_trans_filename->clear();

        ui->statusBar->showMessage( tr("%1: You have canceled the request").arg(QTime::currentTime().toString()) );
    }
}
//------------------------------------------------------------------------
void MainWindow::executePlugIn()
{
    QPushButton *tmpButton = (QPushButton*)QObject::sender();

    // open plugin
    if( tmpButton->isChecked() )
    {
        // takes the fitted plugin
        for( int i = 0; i < plugInterface.count(); i++ )
        {
            if( tmpButton->objectName() == plugInterface[i]->pName() )
            {
                currentPluginWidget = plugInterface[i]->executePlugIn();
                tmpButton->setStyleSheet("");
                plugInterface[0]->setBlink(false);
            }
        }

        ui->vl_plugin->addWidget(currentPluginWidget);
        currentPluginWidget->setVisible(1);

        this->setFixedWidth(900);
        this->move(this->x()-161,this->y());
    }

    // close plugin
    else
    {
        ui->vl_plugin->removeWidget(currentPluginWidget);
        currentPluginWidget->setVisible(0);

        // takes the fitted plugin
        for( int i = 0; i < plugInterface.count(); i++ )
        {
            if( tmpButton->objectName() == plugInterface[i]->pName() )
            {
                tmpButton->setStyleSheet("");
                plugInterface[0]->setBlink(false);
            }
        }

        this->setFixedWidth(550);
        this->move(this->x()+161,this->y());
    }
}

void MainWindow::on_pb_trans_cancel_clicked()
{
    // if the function is not called by the button
    if( QObject::sender()->objectName() == "pb_trans_cancel" )
    {
        int req = QMessageBox::question(0, tr("Interrupt"), tr("Do you want to interrupt the transfer?\n"
                                                               "You can continue the transfer to a later time."),
                                        QMessageBox::Yes, QMessageBox::No);

        if( req == QMessageBox::No )
            return;
    }

    sNet->abortFileTransfer(1);

    ui->pb_trans_cancel->setDisabled(true);
}

void MainWindow::on_pb_res_cancel_clicked()
{
    // if the function is not called by the button
    if( QObject::sender()->objectName() == "pb_res_cancel" )
    {
        int req = QMessageBox::question(0, tr("Interrupt"), tr("Do you want to interrupt the transfer?\n"
                                                               "You can continue the transfer to a later time."),
                                        QMessageBox::Yes, QMessageBox::No);

        if( req == QMessageBox::No )
            return;
    }

    sNet->transmitData(21, 0);

    ui->pb_res_cancel->setDisabled(true);
}

void MainWindow::blinker()
{
    for( int i = 0; i < plugInterface.count(); i++ )
    {
        if( !plugInButton[i]->isChecked() )
        {
            if( plugInterface[i]->getBlink() )
                plugInButton[i]->setStyleSheet("background-color: rgb(255, 170, 0)");
        }
    }
}

void MainWindow::dragEnterEvent(QDragEnterEvent *e)
{
#ifdef Q_OS_WIN
    const int LEN = 3;
#else
    const int LEN = 2;
#endif

    if( !ui->pb_browse->isEnabled() )
    {
        e->ignore();

        return;
    }

    const QMimeData *mime = e->mimeData();

    QList<QUrl> urlList = mime->urls();

    for( int i = 0; i < urlList.count(); i++ )
    {
        QFile tmpFile( urlList[i].toString(QUrl::RemoveScheme).remove(0,LEN) );

        if( !tmpFile.open(QIODevice::ReadOnly) )
        {
            tmpFile.close();
            e->ignore();

            return;
        }

        tmpFile.close();
    }

    e->accept();
}

void MainWindow::dropEvent(QDropEvent *e)
{
#ifdef Q_OS_WIN
    const int LEN = 3;
#else
    const int LEN = 2;
#endif

    const QMimeData *mime = e->mimeData();

    QList<QUrl> urlList = mime->urls();
    QStringList fileNames;

    for( int i = 0; i < urlList.count(); i++ )
        fileNames << urlList[i].toString(QUrl::RemoveScheme).remove(0,LEN);

    fHandler.setFileList( fileNames );

    if( fHandler.getFileList().isEmpty() )
        return;

    totalFileSizeOut = (float)fHandler.getTotalFileSize() / 1048576;
    file = fHandler.getNextFile();

    // determine filename
    QString tmpFileName = FileHandler::cutFilePath( file->fileName() );

    // shortening the string
    if( tmpFileName.count() > 46 )
        ui->l_trans_filename->setText( tmpFileName.left(42) + "..." +
                                       tmpFileName.right(tmpFileName.count() - tmpFileName.lastIndexOf('.')) );
    else
        ui->l_trans_filename->setText( tmpFileName );


    QStringList tmpFileNames;
    foreach( QString tmp, fHandler.getFileList() )
        tmpFileNames.append( FileHandler::cutFilePath(tmp) );

    // ### sends file attributes
    QStringList dataList;
    dataList.clear();
    dataList.append(tmpFileName);
    dataList.append( tr("%1").arg(fHandler.getFileList().count() + 1) );
    dataList.append( tr("%1").arg((float)(fHandler.getTotalFileSize() + file->size()) / 1048576, 0, 10, 1, 0) );
    dataList.append("file");

    QByteArray arr;
    QDataStream in(&arr, QIODevice::WriteOnly);
    in << dataList;
    in << tmpFileNames;

    sNet->transmitData(5,arr); // 5: request
    // #############################

    ui->pb_browse->setIcon( QIcon(":/Icons/Icons/Cute-Ball-Stop-icon.png") );
    ui->pb_browse->setProperty("pending", true);

    ui->statusBar->showMessage( tr("%1: You have sent a file transfer request").arg(QTime::currentTime().toString()) );

    e->accept();
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    on_pb_exit_clicked();
}
