#define MSG(x) (nls_strings[x])

#define MAX_NLS_STRINGS   1000

extern char  *nls_strings[MAX_NLS_STRINGS];
extern int   bpc;

int nls_init (char *system_libpath, char *user_libpath);

/* ----------------------------------------------------------------------*/
/*                              Strings                                  */
/* ----------------------------------------------------------------------*/

#define M_JAN 0
#define M_FEB 1
#define M_MAR 2
#define M_APR 3
#define M_MAY 4
#define M_JUN 5
#define M_JUL 6
#define M_AUG 7
#define M_SEP 8
#define M_OCT 9
#define M_NOV 10
#define M_DEC 11

#define M_HBAR         20
#define M_VBAR         21
#define M_CROSS        22
#define M_FILL1        23
#define M_FILL2        24
#define M_FILL3        25
#define M_FILL4        26
#define M_LU           27
#define M_RU           28
#define M_LD           29
#define M_RD           30
#define M_LT           31
#define M_RT           32
#define M_UT           33
#define M_DT           34
#define M_PLACEHOLDER  35
#define M_MARKSIGN     36

/* bookmarks */
#define M_CANTOPENBOOKMARKS1  101
#define M_CANTOPENBOOKMARKS2  102
#define M_CANTOPENBOOKMARKS3  103
#define M_NO_BOOKMARKS  104
#define M_EMPTY_BOOKMARKSLIST  105
#define M_DELETE_BOOKMARK  106
#define M_INSERT_BOOKMARK1  107
#define M_INSERT_BOOKMARK2  108
#define M_INSERT_BOOKMARK3  109
#define M_CURRENT_BOOKMARKS  110
#define M_BOOKMARKS_CHANGED  111
#define M_BAD_BOOKMARK_ENTRY 112
#define M_DEFAULT_BMK_FOLDER 113
#define M_BOOKMARK_FORMAT 114
#define M_ENTER_DESC 115
#define M_FOLDER_TITLE 116
#define M_DELETE_BOOKMARK1 117
#define M_NAME_FOLDER 118
#define M_DELETE_NONEMPTY_FOLDER 119
#define M_ENTER_FOLDER_TITLE 120
#define M_SELECT_FOLDER 121
#define M_ALREADY_BOOKMARKED 122
#define M_BOOKMARK_NICKNAME 123
#define M_SELECT_BOOKMARK 124

/* Prompts ---------------------------------------------- */
#define M_USETAB  201
#define M_CHOOSEDRIVE  202
#define M_SELECT_DIRECTORY  203
#define M_ENTER_VERBATIM_COMMAND  204
#define M_MKDIR_ENTER_NAME  205
#define M_ENTER_FIREWALL_USERID  206
#define M_ENTER_FIREWALL_PASSWORD  207
#define M_ENTER_USERID  208
#define M_ENTER_PASSWORD  209
#define M_ENTER_HOSTNAME  210
#define M_ENTER_DIRECTORY  211
#define M_ENTER_SELECT_FILTER  212
#define M_RENAME_LOCAL_FILE  213
#define M_ENTER_LOCAL_DIRECTORY  214
#define M_ENTER_SEARCHSTRING  215
#define M_ENTER_FILENAME_SAVE  216
#define M_ENTER_RETRIEVE_AS  217
#define M_ENTER_LISTING_FILENAME  218
#define M_ENTER_NEWNAME  219
#define M_ENTER_UPLOAD_AS  220
#define M_FILE_TO_DOWNLOAD 221
#define M_EDIT1 222
#define M_EDIT2 223
#define M_EDIT3 224
#define M_SITE_EDIT1 225
#define M_SITE_EDIT2 226
#define M_SITE_EDIT3 227
#define M_SITE_EDIT4 228
#define M_SITE_EDIT5 229
#define M_SITE_EDIT6 230
#define M_CONFIRM_COMMAND 231
#define M_USETAB2 232
#define M_ENTER_LISTNAME 233
#define M_PASS_ENTER_KEYPHRASE1 234
#define M_PASS_ENTER_KEYPHRASE2 235

/* scripting */
#define M_SCRIPT_BADCOMMAND      250
#define M_SCRIPT_BADARGS         251
#define M_SCRIPT_ERROR           252
#define M_SCRIPT_CANT_OPEN       253
#define M_SCRIPT_RUNNING         254
#define M_SCRIPT_INVALID_VAR     255
#define M_SCRIPT_CANT_OPEN_LOG   256

/* Pseudo-responses ---------------------------------------- */
#define M_RESP_CANNOT_RESOLVE  301
#define M_RESP_LOOKING_UP  302
#define M_RESP_TRYING_IP  303
#define M_RESP_FOUND  304
#define M_RESP_NO_SOCKET  305
#define M_RESP_FAILED_TO_CONNECT  306
#define M_RESP_CONNECTED  307
#define M_RESP_CLOSING  308
#define M_RESP_LOGIN  309
#define M_RESP_TRANSFER_DONE  310
#define M_RESP_INIT_DONE  311
#define M_RESP_RETRYING  312
#define M_RESP_RETRY_ABORTED  313
#define M_RESP_TRANSFER_CANCELLED 314
#define M_RESP_TRANSFER_ERROR  315
#define M_RESP_REGET_ISNT_SUPPORTED  316
#define M_RESP_BIND_FAILED 317
#define M_RESP_GETSOCKNAME_FAILED 318
#define M_RESP_LISTEN_FAILED 319
#define M_RESP_CANNOT_CONNECT 320
#define M_RESP_CONNECTION_NOT_ESTABLISHED 321
#define M_RESP_TRANSFER_SKIPPED 322
#define M_RESP_CONNECTING 323
#define M_RESP_CANT_OPEN 324
#define M_RESP_CANT_CREATE_DIRECTORY 325
#define M_RESP_F9_FOR_MENU 326
#define M_RESP_CONNECTING2 327
#define M_RESP_ACCEPTING 328
#define M_RESP_ACCEPTED 329

/* Questions ----------------------------------------------- */
#define M_TOO_BIG_FOR_INTVIEWER  401
#define M_REALLY_OVERWRITE  402
#define M_OVERWRITE_RENAME_CANCEL  403
#define M_OVERWRITE_RENAME_CANCEL2  404
#define M_OVERWRITE_RENAME_CANCEL3  405
#define M_REALLY_REGET  406
#define M_REGET_RENAME_CANCEL  407
#define M_REGET_RENAME_CANCEL2  408
#define M_REALLY_TRANSFER_TO  409
#define M_REALLY_DELETE  410
#define M_REALLY_SAVE_BOOKMARK  411
#define M_REALLY_EXIT  412
#define M_REALLY_LOGOFF  413
#define M_REALLY_TRANSFER_FROM  414
#define M_REALLY_TRANSFER_FROM_ALLDIRS  415
#define M_REREAD_REMOTE_DIR 416
#define M_LOGOFF_MARKED 417
#define M_KEEP_TREE_INTACT 418
#define M_KEEP_TREE2 419
#define M_OVERWRITE_RENAME_CANCEL4  420
#define M_REGET_RENAME_CANCEL5  421
#define M_WALK_TREE 422
#define M_LOAD_DESCRIPTIONS 423
#define M_DESC_DOWNLOAD_OPTIONS 424
#define M_SAVE_HISTORY 425
#define M_HIST_DELETE_DIR 426
#define M_HIST_DELETE_SITE 427
#define M_WGET_DOWNLOAD_ONE 428
#define M_WGET_DOWNLOAD_MANY 429
#define M_HIST_CONT_SEARCH 430
#define M_DISCONNECT 431
#define M_UPLOAD_EDITED 432
#define M_TR_OVERWRITE 433
#define M_TR_RESUME 434
#define M_TR_SKIP 435
#define M_TR_CANCEL 436
#define M_TR_QUESTION 437
#define M_DELETE_FILES 438
#define M_NOT_EMPTY 439
#define M_ACCESSRIGHTS1 440
#define M_ACCESSRIGHTS2 441

/* Miscellaneous text strings -------------------------- */
//#define M_NFTP_USAGE  501
#define M_WELCOME  502
#define M_DISCONNECTING  503
#define M_EOF_MARK  504
#define M_WRONG_REGCODE  505
#define M_RUNNING_UNREGISTERED  506
#define M_CCLINES  507
#define M_BINARY  508
#define M_ASCII  509
#define M_TRANSFER_COMPLETED  510
#define M_HELP_ESC_TO_EXIT  511
#define M_STATUS  512
#define M_STATUS_BIN  513
#define M_STATUS_ASC  514
#define M_BYTES_RECEIVED  515
#define M_BYTES_REMAIN  516
#define M_CANT_DELETE  517
#define M_YES  518
#define M_NO  519
#define M_OK  520
#define M_CANNOT_OPEN  521
#define M_FILE_SAVED  522
#define M_LISTING_HEADER  523
#define M_LISTING_FOOTER  524
#define M_RENAME_FAILED  525
#define M_QUICK_SEARCH  526
#define M_LISTING_SAVED  527
#define M_CONNECTION_OK 528
#define M_MARKED_STATISTICS 529
#define M_KEYNAMES_WELCOME 530
#define M_NO_TEXT 531
#define M_NO_MARKED_FILES 532
#define M_HAVENT_BEEN_CONNECTED 533
#define M_DIRECTORY_LISTING 534
#define M_INFORMATION1 535
#define M_INFORMATION2 536
#define M_HIST_HEADER1 537
#define M_HIST_HEADER2 538
#define M_SELECT_HISTORY 539
#define M_USAGE0 540
#define M_USAGE1 541
#define M_USAGE2 542
#define M_USAGE3 543
#define M_USAGE4 544
#define M_USAGE5 545
#define M_CANCEL 546
#define M_DIR_SIGN 547
#define M_LINK_SIGN 548
#define M_SEARCH_FORWARD 549
#define M_SEARCH_BACKWARDS 550
#define M_CANT_FIND 551
#define M_SELECT_LANGUAGE 552
#define M_REGISTRATION_NAME 553
#define M_REGISTRATION_CODE 554
#define M_THANKS 555
#define M_TOO_LARGE 556
#define M_FONT_DESC 557
#define M_SELECT_FONT 558
#define M_STALLED 559
#define M_WAIT 560
#define M_UNREGISTERED 561
#define M_PRESS_ENTER 562
#define M_PAUSED 563
#define M_SQRP 564
#define M_DEL_UNMATCHED 565
#define M_SYNC1 566
#define M_SYNC2 567
#define M_SYNC3 568
#define M_PASS_UNSUPPORTED 569
#define M_PASSWORDS 570
#define M_PASS_SAVE 571
#define M_PASS_DELETE 572
#define M_REGISTERED 573
#define M_UNREGISTERED2 574
#define M_NEEDBF 575
#define M_ALL 576

/* Errors ---------------------------------------- */
#define M_UNKNOWN_OS  601
#define M_UNREGISTERED_TRANSFER  602
#define M_INI_BUILD_FAILED  603
#define M_EMAIL_NOT_SET  604
#define M_CONNECTION_LOST  605
#define M_NO_PASV_NOFIREWALLING  606
#define M_NO_PASV  607
#define M_CANT_CREATE_SEM  608
#define M_PROXY_ISNT_SPECIFIED 610
#define M_INCORRECT_FIREWALL 611
#define M_CANT_ACCESS_DRIVE 612
#define M_DIRECTORY_DOESNT_EXIST 613
#define M_CANT_CREATE_DIRECTORY 614
#define M_CANT_LOGIN 615
#define M_FILE_NOT_FOUND 616
#define M_TRANSFER_FAILED 617
#define M_CANNOT_RENAME 618
#define M_CANT_OPEN_FOR_WRITING 619
#define M_UNKNOWN_SERVER_OS 621
#define M_CANT_READ_FILE 622
#define M_CANT_GUESS_CURDIR 623
#define M_CANT_WRITE_LOGFILE 624
#define M_CANT_OPEN_FOR_READING 625
#define M_LARGE_INDEX_FILE 626
#define M_WRONG_KEYNAME  628
#define M_KEYDEF_ERRORS  629
#define M_CANT_USE_DIR_AS_INDEX_FILE 630
#define M_NO_EMAIL_ADDRESS 631
#define M_GUESSED_EMAIL 632
#define M_CANT_GUESS_EMAIL 633
#define M_ERROR_READING_HISTORY 634
#define M_EMPTY_HISTORY 635
#define M_HISTORY_NICKNAME 636
#define M_PASSWORDED_WGET 637
#define M_UNSUPPORTED 638
#define M_HTTP_PROXY 639
#define M_NO_FIREWALLING 640
#define M_PASS_INVALID 641
#define M_DISK_FULL 642
#define M_ENABLE_PASSWORDS 643
#define M_PASS_INCORRECT 644
#define M_NO_CHMOD 645
#define M_WRONG_RIGHTS 646
    
/* Transient messages ----------------------------------- */
#define M_SENDING_VERBATIM_COMMAND  701
//#define M_PARSING_UNIX  702
//#define M_PARSING_IBMOS2  703
#define M_MKDIR_CREATING  704
#define M_GOING_ROOT  705
#define M_GOING_UP  706
#define M_CHANGING_DIR  707
#define M_SENDING_NOOP  708
#define M_QUERYING_DIR  709
#define M_RETRIEVING_FILELIST  710
//#define M_PARSING_NEOLOGIC  711
#define M_CHANGING_DIRECTORY 712
//#define M_PARSING_OLD_NT 713
#define M_STARTING_TRANSFER 714
#define M_PARSING_LISTING 715
#define M_PROCESSING_HISTORY1 716
#define M_PROCESSING_HISTORY2 717
#define M_READING_HISTORY_FILE 718
#define M_WRITING_HISTORY_FILE 719
#define M_ENUMERATING_FONTS 720
#define M_DELETING 721

/* INI file processing */
#define M_FATAL_LOADING_NFTP_INI  751
#define M_INI_UNREADABLE 752
#define M_INI_CONFIG_VERSION 753
#define M_INI_CANT_FIND_NFTP_I 754
#define M_INI_UPDATE 755
#define M_INI_UPDATING 756
#define M_INI_CANT_OPEN_READ 757
#define M_INI_WRONG_ENTRY 758
#define M_INI_CANT_RENAME 759
#define M_INI_BACKUP 760
#define M_INI_CANT_OPEN_WRITE 761
#define M_INI_UPDATING_ENTRY 762
#define M_INI_FINISHED 763

/* help screens */
#define M_HLP_MAIN               800
#define M_HLP_LINEIN             801
#define M_HLP_CC                 802
//#define M_HLP_BMRK               803
//#define M_HLP_TRANSF             804
#define M_HLP_DIR_RAW            805
//#define M_HLP_DIR_PARSED         806
//#define M_HLP_DIR_DESC           807
#define M_HLP_VIEWER             808
#define M_HLP_LOCAL_PARSED       809
#define M_HLP_SHORT              810
#define M_HLP_BOOKMARK1          811
#define M_HLP_BOOKMARK2          812
#define M_HLP_UNDEFINED          813
#define M_HLP_HISTORY            814
//#define M_HLP_CHOOSEBOX          815
#define M_HLP_USING_MENU         816
#define M_HLP_SITE_EDIT          817
#define M_HLP_FTPSEARCH          818
#define M_HLP_FTPSEARCH2         819
#define M_HLP_PASSWORDS          820

/* window title */
#define M_DOWNLOADING 901
#define M_UPLOADING 902
#define M_NOT_CONNECTED 903
#define M_CONNECTING 904
#define M_DOWNLOADING1 905
#define M_UPLOADING1 906
#define M_QUERYING 907

/* Transfer progress */
#define M_TOTAL                  930
#define M_TRANSFERRED            931
#define M_SKIPPED                932
#define M_LEFT                   933
#define M_INACT                  934
#define M_BYTESSEC               935
#define M_DOWNLOAD               936
#define M_UPLOAD                 937
#define M_COMMUNICATING          938
#define M_PERCENTAGE1            939
#define M_PERCENTAGE2            940

/* FTP Search */
#define M_FTPS_RECEIVING  950
#define M_FTPS_NO_HITS 951
#define M_FTPS_SERVERS 952
#define M_FTPS_ADD_SERVER 953
#define M_FTPS_DELETE 954
#define M_FTPS_SENDING_REQUEST 955
#define M_FTPS_SEARCHRES 956
#define M_FTPS_NEED_ARGS 957
#define M_FTPS_SEARCH1 958
#define M_FTPS_SEARCH2 959
#define M_FTPS_SEARCH3 960
#define M_FTPS_SEARCH4 961
#define M_FTPS_SEARCH5 962
#define M_FTPS_SEARCH6 963
#define M_FTPS_SEARCH7 964
#define M_FTPS_SEARCH8 965
#define M_FTPS_SEARCH9 966
#define M_FTPS_SEARCH10 967
#define M_FTPS_DOWNLOAD 968
#define M_FTPS_RECEIVING2  969
#define M_FTPS_NO_HITS2 970
#define M_FTPS_NORES 971

