:userdoc.
:title.
:docprof  toc=123456 .
:h1 id='PANEL_HELP' res=2910.Getting Started.
:i1.Getting Started
:hp2.Getting started with DrawIt for OS/2 Warp.
:ehp2.
DrawIt is a vector oriented drawing tool written for OS/2 Warp. This chapter
gives an overview of the functionallity found in this drawing package.
:hp2.Overview
:ehp2.
In DrawIt all shapes are handled the same. For instance both a circle and square
can have different filling patterns. In this help text the different shapes are
named objects. All objects can be moved and sized when they are 
:link reftype=hd res=3400.selected
:elink.. 
:hp2.Drawing.
:ehp2.
Select from the toolbar at the left side of the window the desired shape. For
instance a circle. Move the mouse to the white drawing area. You will see that
the mouse pointer holds a small circle showing you that the program is ready for
drawing circles. Click the left mouse button and move the mouse while holding
down the button. When the mouse button is released the circle appears in its
final size. The program is now ready for the next  circle. Or when you need
another shape you simply click on another button in the toolpalette. Each button
in the toolpalette is discussed further in this chapter.
:hp2.Actions on objects.
:ehp2.
Objects can be deleted, copied, sized, moved etc. All actions can be done on one
or multiple objects at the time. Only one object is deleted when just one object
is selected and the delete key is pressed. When multiple selections are done and
the delete key is pressed, multiple objects are deleted at once.
:hp2.Deletion.
:ehp2.
When an object is selected or multiple objects are selected the object(s) can be
deleted by pressing the 
:hp2.<Delete> :ehp2.
key.
:hp2.Copying.
:ehp2.
You can make a copy of one or more objects by holding down the 
:hp2.<Ctrl> :ehp2.
key while moving the objects. Be sure you first press the 
:hp2.<Ctrl> :ehp2.
key and than start dragging the object(s). After you have released the
mousebutton you release the 
:hp2.<Ctrl> :ehp2.
key.
.br
:hp2.Stretching.
:ehp2.
When the mouse cursor is moved over the handles of the selected object the
cursor changes in a double arrow. If this is the case, the object can be
stretched by holding down the left mouse button and drag the mouse. If the mouse
button is released the object will appear in it's new size. 
:hp2.Filling patterns.
:ehp2.
All objects (except images) can be filled with different patterns. The following
image shows some of the possible filling patters which can be used. Besides
these patterns the program supports two complex filling methods, namely 
:hp2.gradient :ehp2.
and 
:hp2.fountain :ehp2.
fill.
.br
:artwork  align=left name='..\help\filling.bmp'.
:hp2.Colors:ehp2.
.
.br
:link reftype=hd res=3200.Click here for details on colors. 
:elink.
The color of wherein an object appears after it is drawn depends on the color
choosen in the colorpalette at the bottom of the program window. The color of an
object can be changed after it is drawn. This can be done when the program is in
select mode. Use  
:artwork  runin name='F:\DEVELOP\DLG\RESOURCE\SELECT.BMP'. this button. Select
the object which needs color changes and click on the desired color in the
colorpalette. The color of the object changes only when there is a filling
pattern set for the selected object. A hollow object does not react when
changing the filling color. So first change the filling pattern by pressing the
right mousebutton above the selected object. Select a solid filling pattern and
try again the color change. The outline color can also be changed by selecting
the color in the colorpalette with the right mouse button. Or by setting the
coloring mode in the popupmenu on interior or outline. When set to outline the
color changes with the left mousebutton. When none of the colors in the palette
meets your requirement, you can simply change it by double clicking on the color
you want to change. This will bring up a dialog which ables you to remix the
color. The color of an object can also be changed via the OS/2 color palette. 
:hp2.Other properties.
:ehp2.
.br
Other properties can be changed by double clicking on the object. 
:hp2.<Shift>
:ehp2.
.br
Ellipse and Square objects will be drawn as circle or as symetric square when
the <Shift> key is pressed while drawing is done. 
.br
.br
:hp2.Multiselection 
:ehp2.
If dragging is done in the drawing area (Moving the mouse while holding down the
left button)  a selection square appears. When an object is inside this square
it shows directly it's selection boxes. Releasing the mouse causes the square to
disappear. When objects are selected they stay selected.
.br
:lm margin=5.
:hp2.Changing the font :ehp2.
off all selected text objects, by dragging a font from the OS/2 font palette on
the drawing area. 
.br
:hp2.Changing the colors :ehp2.
of the selected objects by dragging a color from the OS/2 color palette over the
selection area. 
.br
:hp2.Copying :ehp2.
the selected objects by holding down the <Ctrl> key while moving the selection
square with the mouse. 
.br
:hp2.Moving :ehp2.
by draging the selection square to the position you want. 
.br
:hp2.Deleting :ehp2.
by pressing the <Delete> key on the keyboard. 
.br
:hp2.Filling pattern :ehp2.
can be changed via the popupmenu or the options menu etc. 
:lm margin=1.
.br
:hp2.Popupmenu's  
:ehp2.
.br
The program has two popupmenu's. Click with the right mousebutton on the drawing
area to bring up a popupmenu. When a bitmap image is selected the program shows
the imagemenu as popupmenu. When nothing or an other object is selected the
program will show a subset of the optionmenu as popupmenu. The popupmenu's
enables you to quickly change the attributes of a multi or single selection. Or
you can set the program attributes for the objects to be drawn.  When an object
is selected, check marks in front of the menu items show the current settings of
the selected object. When no object is selected the check marks show the
application settings. When multiple objects or a group is selected, no check 
marks are shown.
.br
:artwork  align=left name='..\resource\select.bmp'.
:hp2.Selectbutton.
:ehp2.
.br
The selectbutton switches the application into select mode. The <ESC> key can
also be used for this purpose. After having this button press you can start
making 
:link reftype=hd res=3400.selections 
:elink.
.br
:artwork  align=left name='..\resource\text.bmp'.
:hp2.Text.
:ehp2.
With this button you start the text input of the program. The cursor start
blinking in the upper right corner. To position the cursor and start a new text
object just click with the mouse at the place where you would like to start the
text. The cursor will be replaced at that point. You can type in any character
from the keyboard and use the backspace key for deletion of mistakes. To stop
editting or text input use the <ESC> key or the upper mode button with the
selection arrow. If the current font in the textobject does not meet your
requirements you simply drag another font over the textobject. The textobject
will imidiately show itself with the new font. The size is not taken from the
OS/2 font palette. When you move the mouse cursor above the text object and you
click once with the left mouse button you select the text. On each corner there
will be little squares also named handles. If you now click on the text and keep
the left mouse button pressed and start moving, it (DRAGGING) the handles will
move with the cursor. When the mouse button it released the text will be redrawn
at the new place. When you double click on the text a dialog comes up which
enables you to change the text properties. 
.br
:artwork  align=left name='..\resource\circle.bmp'.
With this button you can start the creation of ellipses. Click with mouse in the
drawing area and move while holding down the button. When the mouse button is
released the ellipse is drawn in its final state. If the <Shift> key is pressed
while the ellipse is drawn, the shape will stay exacly circular. Also have a
look in the objects menu there is an option for partial arcs! The radius of the
partial arc is defined by the amound of moving in the X-direction while drawing
is done. While the part of the pie will grow when the mouse moves in the
Y-direction. 
.br
:artwork  align=left name='..\resource\square.bmp'.
:hp2.Square
:ehp2.
With this button you can start the creation of  squares The filling pattern can
be set in the options menu. There are 16 different patterns available. As with
the ellipses you can hold down the <Shift> key, while drawing, to keep the
apsect ratio exacly square. 
.br
:artwork  align=left name='..\resource\line.bmp'.
:hp2.Simple lines
:ehp2.
With this button you can start the creation of straight lines. A line starts at
the point you click with the mouse. By holding down the mouse button while
moving the mouse the line increases in size. Releasing the mouse sets the end
point of the line. When the program is in select mode (by pressing the select
button or the <ESC> key on the keyboard) the line position and size can be
changed by selecting the line. Moving is done by clicking in the square area
occupied by the line, and moving the mouse while holding down the left mouse
button. Size and direction can be changed by clicking on one of the available
handles and moving the mouse while holding down the button. Important, in the
option menu you can specify 16 different line types!! 
.br
Also have a look in the objects menu, there is an SPECIAL LINE option which
ables you to creat a collection of lines in one go. 
.br
1. Select the special lines option in the object menu. 
.br
2. Click with the mouse in the drawing area and hold down the mouse button. 
.br
3. Move the mouse in a circular shape for instance. 
.br
4. Look!! 
.br
:artwork  align=left name='..\resource\trian.bmp'.
:hp2.Regular polypoints.
:ehp2.
This button ables you to create regular polypoints. It will bring up a small
dialog window which appears in the upper rightcorner of the application. With
this dialog you can define the number of points in the figure. This figure is of
the same class as the polyline. Besides the normal stretch functionality it is
possible to change the shape. When the number of points is set to its max value
then the shape gets circular. This can be used to create 
:link reftype=hd res=5100.balloon text 
:elink.
.br
:artwork  align=left name='..\resource\fill.bmp'.
:hp2.Color palette.
:ehp2.
This button starts for you the OS/2 color palette. Now you can change the colors
of all objects (except images), just by dragging over the selected color. Only
the objects in the current 
:link reftype=hd res=3800.layer 
:elink.are affected. 
.br
:artwork  align=left name='..\resource\font.bmp'.
Starts up the OS/2 font dialog and enables you to change the font of drawit by
draging the selected font over the drawing area. Also fonts can be changed of
text objects by dragging the the selected font over an selected font. 
:artwork  align=left name='..\resource\layer.bmp'.
:hp2.Layers.
:ehp2.
Starts up a dialog which shows you which objects are on the current layer. This
program supports 10 different layer. Layer 1 is the bottom layer while layer 10
is the top layer. Only objects in the active or current layer can be selected
with the mouse. To avoid you get lost, you can run in this dialog through the
layers and see which objects are on which particular layer. Double click on a
circle, square etc to change the layer of the particular object. 
.br
:artwork  align=left name='..\resource\splhit.bmp'.
:hp2.Reshape.
:ehp2.
When a polyline,polyfillet, regular polypoint, regular polystar or a circle is
selected this button can be used to show the handles on the linejoins. When the
above mentioned object is in this state the handles can be used to change the
form. 
:ol.
:li.Select the above named object. 
:li.Press on the above mentioned button.
:li.Click in one of the open selection boxes and hold down the mousebutton. 
:li.Move the mouse. 
:li.Release the mouse button. 
:li.And look! 
:eol.
.br
.br
:artwork  align=left name='..\resource\objch.bmp'.
:hp2.Change.
:ehp2.
.br
Use this button to put one object in front of another object. Example&colon. 
:ol.
:li.Draw two squares (preferibly filled with different colors). Square 1
overlayes square 2. 
:li.Press <ESC> key or the select button.
:li.Press the <Shift> key and click with the mouse on s
:li.quare 1 and after that on square 2. Release the <Shift> key. Both squares
should show their selection boxes. 
:li.Click on the button. 
:li.Result, square 2 overlaps square 1. 
.br
:eol.
.br
.br
.br
:artwork  align=left name='..\resource\zoom.bmp'.
:hp2.Zoom.
:ehp2.
.br
This button allows you to see the form in two zoom modes. By default the form
has excact the size as in the real world. When this button is pressed it toggles
between the default and half the size. See for zooming also the view menu. The
zoom submenu allows many different zoom factors.
.br
:artwork  align=left name='..\resource\rotate.bmp'.
:hp2.Rotate.
:ehp2.
.br
When a object is selected this button can be used to 
:link reftype=hd res=4800.rotate 
:elink.the object. 
.*--------------------------------------------------------------*\ 
.*  Help menu About command help panel 
.*      res = PANEL_HELPABOUT 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_HELPABOUT' res=2960.About.
:i1.About
:hp2.DrawIt for OS/2 Version 2.9 :ehp2.
[end of 1998 ]. 
:artwork  align=left name='..\resource\drlogo.bmp'.
.br
.br
Thank you for choosing DrawIt for OS/2 Warp.
New features and changes in 2.9
:ol.
:li.Lines, polylines and splines can have 11 different arrows etc. The line ends
support almost all ends needed for drawing an UML diagram.
:li.Ctrl-I breaks the string input and creates a new text object at the current
cursor position. This makes it easy to write one line of text with each word
having its own color.
:li.Image clippath. You can now simply cut out a part of an image with a
polyline or spline. 
:link reftype=hd res=2920.Click here for more details.
:elink.
:li.An image can be displayed in different modes. 
:link reftype=hd res=2920.Click here for more details.
:elink.
:li.The submenus used to set the different attributes are reflecting the current
settings of the selected objects with check marks. If there is no object
selected the check marks show the application settings. When multiple objects
are selected no check marks are shown.
:eol.
:hp2.!! READ !!  New features and changes in 2.8 !! 
:ehp2.
:sl compact.
:li.
:hp2.2.8 Changes and fixes in this version:ehp2.
:
:ol.
:li.Partial arc is removed from the object menu.
:li.When a color is dropped on a non filled object, the object gets a solid
filling pattern to reflect the dropped color.
:li.Font dialog centered and cannot get behind the application.
:li.Restore palette in the image menu. Can be used on palette based images.
:li.Splines which are not closed can be filled. An invisible line from the
starting to the end point closes the spline. This enables the filling patterns
to be used even on non closed splines.
:li.When an image is dropped on the drawing surface, the image is displayed at
the position where the mousebutton was released.
:li.Sometimes the program could not reload the drawing, specially when an image
(bitmap) was included in the file. This is solved in this version. This means
that the file format is slightly changed, but still the 2.7 format can be
loaded. Saved files cannot be reloaded in version 2.7 when a bitmap file is
include.
:li.Drawing of circles is completely changed. Press the circle button to find
out. Double clicking on the circle gives a property dialog, here you can edit
all kinds of settings of the circle.
:li.Changing an attribute with the popupmenu changes only the attribute of the
selected object or when no object is selected it sets the default for the 
objects to be created.
:li.The status line shows the font of the selected text including the point
size. A point is 1/72 of an inch.
:li.Print preview shows the drawing with the correct aspect ratio.
:li.When the checkbox in the print preview is checked the drawing is directly
shown without any fill pattern.
:li.Printing has been modified. The drawing is now printed with the correct
aspect ratio.
:li.Exporting a drawing to a bitmap image could result in a black square when
the drawing contained a bitmap image. This problem is solved.
:li.Printing of fat lines did not work in the previous version. 
:li.DrawIt has its own implementation for the font palette as well as for the
color palette. This means that when DrawIt is closed the palette(s) will get
closed too.
:li.The selected form size can be set as the program default. DrawIt therefore
creates a file named DRAWIT.INI in the OS/2 directory on your system. If there
are any problems with starting DrawIt, you should delete this file. DrawIt than
starts up with its default value's.
:li.To support a more precise way of selecting an object, DrawIt now supports
selection on the outline instead of the complete object area. By default the old
behaviour is used. In the options menu you can select "on object outline" for
the new behaviour. 
:link reftype=hd res=3400.Click here for more information on selecting an
object.
:elink.
:li.DrawIt can load JPEG files.
:li.The color palette of an image can be copied to another palette based image. 
:link reftype=hd res=2920.See image chapter
:elink..
:eol.
:li.
:hp2.2.7 Changes:
:ehp2.
:li.Drawit accepts files on the commandline.
:li.example: 
:hp1.drawit drawing.met <return>
:ehp1.
:li.starts drawit and loads directly the metafile.
:li.When a filename is defined without extention drawit tries to load the file 
as a .JSP file. Also bitmap files are accepted on the commandline.
:li.Drawing Window was sometimes not correctly placed after sizing the main
window
:li.The menubarfont and the status window font are changed to 8.helv to get more
space.
:li.An info area is added telling what the program does in the background. Image
loading/saving
:li.and printing.
:li.
:hp2.2.6A Changes:
:ehp2.
:li.Online help is upgraded.
:li.Draft printing.
:li.New colorbar at bottom of window.
:li.Coordinates were not displaying the right
:li.size and possition.
:li.Exporting wide lines to bitmap files are corrected as well as the text
shadow.
:li.Price is made very low, see registration chapter. 
:li.The internal fileformat (.JSP) is changed. But the old 2.4 files can still
be loaded. Once saved in 2.5 they cannot be used in 2.4 anymore. Drawings made
with version 2.3 cannot be loaded!. Export them as bitmap or metafile to use
them in this version. 
:li.Zooming from 25% of the page size up till 300%. 
:li.Gradient fill is corrected for all graphics boards. The program dithers the
color when needed. 
:li.Fountain fill option is added, see popupmenu. 
:esl.
.br
:hp2.Known problems and limitations. 
:ehp2.
:sl compact.
:li.Single groups can be rotated. Groups with groups in it cannot be rotated
yet. 
:li.On standard VGA the text object is incorrect inversed. 
:li.Some VGA graphics boards do not properly invert. So when text is moved or
size this can give akward look. Press Ctrl+R to refresh the screen. This is only
happening when the standard VGA driver is used. 
:li.On Warp 4.0, dialog windows can appear behind the application. The system
looks as if it hangs. Press the <ESC> key and retry the operation. The problem
seems to be solved when OS/2 Fixpack 7 is installed.
:esl.
See 
:link reftype=hd res=2910.Getting started 
:elink.for an overview of the program. 
.br
If there are problems, comments or wishes please send an e-mail to compuserve id
101322,3665. 
For those who are connected to other internet providers the e-mail address is: 
101322.3665@compuserve.com
.br
Jasper de Keijzer. 
.br
:link reftype=hd res=4400.Click here for details on registration. 
:elink.
:nt.
:color fc='Red' bc='default'.The programmer of this program shall not be liable
for any damages arising out of your use of this program. 
:color fc='Default' bc='Default'.
:ent.
.br
.*--------------------------------------------------------------*\ 
.*  Help menu New command help panel 
.*      res = PANEL_HELPHELPFORHELP 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_HELPHELPFORHELP' res=2920.Images
:i1.Images
:p.Via the filemenu or via drag and drop, you can import bitmap images of the
following formats&colon. 
:ol.
:li.PCX - A file format of Zsoft Corp (c). 
:li.GIF - A file format of Compuserve Inc. 
:li.BMP - OS/2 1.x, 2.x and MS Windows 3.0.
:li.TIFF- A file format of HP and Microsoft.
:li.XBM - A X Window bitmap format.
:li.TARGA - Truevision.
:li.PIC - Lotus 123 chart file format. 
:link reftype=hd res=5000.Click here for details
:elink..
:li.JPEG  - Independent JPEG Group. Only reading.
:eol.
.br
.br
In the menu are the actions which can be done on the selected image. Double
clicking on the selected image will show the details of the image. Not shown but
avalailable via the keyboard are the following options&colon. 
.br
.br
:hp2.Brightness.
:ehp2.
To increase the brightness of the selected bitmap image, press the b or B on the
keyboard. It is not possible to decrease the brightness. Hence if the result is
not what you expected you have to reload the original image from disk. Or when
it is a palette based image you can use the restore option in the popup menu.
.br
:hp2.Inverting:ehp2.
.
Via the I or i on the keyboard it is possible to invert the selected image. 
:hp2.Copy. :ehp2.
See the colors submenu. With this option you can copy the color palette of a
palette based image to the internal clipboard of DrawIt. When selecting another
palette based image, the palette can be pasted.
:hp2.Paste. :ehp2.
See the colors submenu. For pasting a palette from the internal clipboard into
the selected image.
.br
Further it is recommended to try out all image menu options to get an idea what
is possible and not. 
.br
:hp2.Menu options&colon. 
:ehp2.
.br
:hp2.Details 
:ehp2.
.br
This menu option brings up the a dialog window showing the some details of the
selected image. Here you can change the layer of the image. 
.br
:hp2.Flip Image 
:ehp2.
.br
This option makes it possible to mirror the image over the x-axis or the y-axis.
.br
:hp2.Color Rotation 
:ehp2.
.br
hioption can be activated via the image menu or tumeric plus '+' (up) and minus
'-' (down) keys. Color rotation is nothing more than adding a value to all
entries in the colorpalette of the selected image. To check the results. 
:ol.
:li.Load a bitmap image.
:li.Select the image by clicking on the image with the left mouse button. 
:li. Press the minus key on the numeric keyboard or use the image menu. 
:li. Check the results. 
:eol.
:hp2.Crop selected image:ehp2.
.
.br
.br
.br
Crop the selected image. If you need only a part of the loaded image it is
possible to cut out a part. Choose the option and click with the mouse at the
upper left point in the image e.g the point where you want to start the cut out.
Drag with the mouse, (moving while holding down the left mouse button) over the
image and now you see a square appearing. This square shows the cut out at the
moment you release the mouse button. If you release to mouse button immediately
by accident the picture get a minimum size of 5 pixels. This avoids disappearing
of the image. 
:hp2.Restore.
:ehp2.
Aspect ratio. Restore the picture aspect ratio after it has been sized.
Size: Restore the original size on the screen.
Palette: Restores the original palette of the selected image. The image must
have a palette for this menu option.
.br
:hp2.Convert to Black and White. 
:ehp2.
.br
Converts the color image to a black anf white image. 
.br
:hp2.Make circular.
:ehp2.
.br
Shows the image in a circular frame. 
.br
:hp2.Make square.
:ehp2.
.br
Shows the image in a square frame which is the default. 
:hp2.Clippath.
:ehp2.
You can cut out a part of an image with a polyline or spline. Simply draw a
polyline on top of an image. Press the <ESC> key or the arrow button. Select the
image and  the polyline. Both objects should be selected. Use now the 
:hp2.Set Clippath :ehp2.
menu option to set the clippath or press the right mousebutton while the pointer
is above the image. The latter brings up a small popup menu to set the clippath
in the image. 
Important is that the bounding rectangle of the spline or polyline should fit
the bounding rectangle of the image, else nothing happens. An image supports one
single clippath at the time.
:hp2.Remove clippath:ehp2.
.
When an image is selected with a clippath this option makes it possible to
remove the clippath from the image.
:hp2.Display method.
:ehp2.
This submenu makes it possible to define how the image should be put on the 
drawing surface. The options makes it possible to make an image transparent for
instance. In most options there is something like a 
:hp1.source :ehp1.
and 
:hp1.destination:ehp1.
. The source is the image and the destination is the drawing surface. So when
you for instance draw a filled circle with an image on top, you give the image a
transparent look by setting the display method to 
:hp1.Source AND Destination. :ehp1.
Another good exercise is to set an image on top of another image and change the
display method of the top image to see the impact of each method. The submenu
marks the current display method of the selected image.
The following list shows the technical impact of the different display modes.
DST=Destination. SRC=Source. PAT=Pattern.
:ol.
:li.Source copy. Copy the bitmap image over the target. Target will be overlayed
with the image.
:li.Source paint. For each pixel in the image an OR operation will be done with
the underlaying pixel.
:li.Source and. For each pixel in the image an AND operation will be done with
the underlaying pixel.
:li.Source invert. As option 2 and 3 but an XOR operation will be used.
:li.Source erase. Source AND not Destination. 
:li.Not Source copy. NOT source.
:li.Not Source Erase. NOT (SRC) AND NOT (DST).
:li.Merge copy. SRC AND PAT.
:li.Merge paint. NOT (SRC) or DST.
:li.Pattern copy. PAT.
:li.Pattern paint. NOT (SRC) or PAT or DST.
:li.Pattern invert. DST XOR PAT.
:li.Destination invert. NOT DST.
:li.Zero. 0.
:li.One. 1.
:eol.
:hp2.Save selected Image as. 
:ehp2.
.br
.br
This option makes it possible to save the selected bitmap image in one of the
supported formats. The image will be saved with the same size as it is on
screen. Hence this gives the possibily to change the original size of bitmaps. 
.br
.br
:hp2.Filling patterns.
:ehp2.
When the image is selected the filling pattern of the image can be changed in 
the attribute menu. If you give the image a haftoned filling pattern and the 
color white you get a misty picture. Solid or gradient filling is not supported.
.br
:nt.
A circular shape is not reflected in the saved bitmap image.
:ent.
.br
Hint try the popupmenu (which can be activated with the right mouse button) when
the image is selected.
.*--------------------------------------------------------------*\ 
.*  Adding text. 
.*      res = ? 
.*--------------------------------------------------------------*/ 
:h1 id='2970' res=2970.Text.
:i1.Text
:hp2.Text.
:ehp2.
:p.When a text is entered each time the mouse is clicked on a new start position
the program creates a new text object. Also after pressing the enter key. These
objects can be moved and resized etc. Also you can double click on them to
change it's attributes. Changing the font of a text object can be done by
dragging the appropriate font from the OS/2 system font palette and drop it, by
releasing the mouse, above the text object. Only the font type is reflected not
the size. Also when holding down the control key while moving a text object the
program will make a copy. 
:p.
.br
:hp2.Menu options&colon. 
:ehp2.
.br
:hp2.Font 
:ehp2.
.br
This menu option brings the standard fontdialog of OS/2 up. and enables you to
set the font used byt the program. This action can also be done via the font
palette, by dragging the appropriate font on the drawing area. 
.br
:hp2.Selected text. 
:ehp2.
.br
This option brings up the dialog which enables you to fine tune the text. Giving
it shadow or making outline text. This dialog can also be activated via a double
click with the left mouse button on the selected text. Here is an example how
text can look with different shadow types, also outline text is shown in this
example. 
:artwork  align=left name='..\help\fontx.bmp'.
.br
:link reftype=hd res=4300.Click here for details on circular text.
:elink.
.br
:hp2.Char Box. 
:ehp2.
.br
This option make the character box square and takes the highest value. So when
the X-value is bigger than the Y-value the X-value will be used to make the font
square. 
.br
:hp2.Flip. 
:ehp2.
.br
This option makes it possible to flip the text horizontal or vertical. 
Horizontal sets the text upside down. 
:hp2.Selected text.
:ehp2.
This option starts up a dialog for setting different attributes of the selected
text.
:hp2.Edit text <Ctrl T>.
:ehp2.
Select this option if you want to edit the selected text. Or press the <Ctrl>
key plus the T.
:hp2.Circular.
:ehp2.
Starts up a dialog where in you can define the circular shape of the selected
text.
:link reftype=hd res=4300.Click here for details on circular text.
:elink.
:hp2.Charbox 1:1.
:ehp2.
Makes the character box square. The program uses the average character width to
make the character box square.
:hp2.Flip.
:ehp2.
Flip text horizontal, mirrors the text. While flipping the text vertical set the
text upside down.
.br
The following example shows text what is rotated. 
:link reftype=hd res=4800.Click here for details on rotation. 
:elink.
:artwork  align=left name='..\help\exmpl.bmp'.
:hp2.Break text input Ctrl-I
:ehp2.
With this menu option of key combination a new text object can be started at the
current cursor position. This can be very handy when for instance the next word
must be written in a different color but should be at the same baseline. Or it
is even possible to change the font.
For example you can set italic on just after selecting the menu item.
.br
.*--------------------------------------------------------------*\ 
.*  Help on text dialog 
.*      res = PANEL_HELPABOUT 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_TEXTOBJECT' res=3000.Text object dialog
:p.This dialog window enables you to change the attributes of the selected text.
:p.
:p.The following attributes can be changed.
:p.
:hp2.Size:ehp2.
.
:p.The spin buttons can be used the change the point size of the selected text.
:p.
:hp2.Layer:ehp2.
.
:p.Changing the 
:link reftype=hd res=3800.layer 
:elink.where upon the text is. 
:p.With the spinbutton you can transfer the text to a different layer within the
drawing. Layer 1 is the bottom layer while layer number 10 is the top layer. You
can change the overall layer by using the layer button. 
:p.
:hp2.Shade.
:ehp2.
:p.With the two spin buttons the size of the shade can be set.  The color
palette in the dialog can be used to set the shading color.
:p.
:p.
:hp2.Shear:ehp2.
. 
:p.This spin buttons enables you to change the shear of the text.
:p.
:artwork  align=left name='F:\develop\dlg\help\shear.BMP'.
.*--------------------------------------------------------------*\ 
.*  Indexhelp Changing the colors 
.*      res = 3200 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_CHANGINGCOLORS' res=3200.Changing colors
:i1.Changing colors
:artwork  align=left name='..\resource\fill.bmp'.
.br
:hp2.Changing colors.
:ehp2.
At the bottom of the screen there are 42 different pre defined colors which can
be use to change the color of the selected object or of the object to be
created.
:hp2.<Left Mouse Button>
:ehp2.
Changes the filling color.
:hp2.<Right Mouse Button>
:ehp2.
Changes the outline color.
:hp2.<Double click left button>
:ehp2.
Double click with the mouse button on the color you want to change. This will
bring up a dialog window which enables you to remix the initial color,by
changing primary colors red,green and blue. The program does not work with a
palette and it supports therefore true color. So changing the palette will not
affect any drawing previously made. This small color palette defines the initial
color for objects when they are drawn. Later the color of the objects can be
changed by selecting the object and then clicking on the appropriate color. Also
draging the required color from the system color palette on an object is
supported. The OS/2 system palette can be activated via the buttons with the
picture as is shown on top of this screen. To change the background color you
must activate the system colorpalette and drag the appropriate color on the
drawing area. 
.br
In the lower left corner of the application is a box showing the current color
setting. It shows the 
:hp2.interior color :ehp2.
setting and the 
:hp2.outline color :ehp2.
setting. 
.br
To change the colors of more than one object at the time, you have to make a
multiple 
:link reftype=hd res=3400.selection 
:elink.
.br
:ol compact.
:li. Make a multiple selection. 
:li. Click on the a color in the program color palette at the bottom of the 
Also dropping a color from the OS/2 color palette is supported. 
:li. All selected objects will show their new color and are unselected. 
:eol.
Dependant on the option set in the options menu, the outline color or the
interior color will change. 
When an object does not have a filling pattern and a new color is dropped, it
will automatically get the solid filling pattern.
.br
.br
:hp2.Find color :ehp2.
This option allows you find a color with the mouse. 
.br
:ol compact.
:li.Select the 
:hp2.Find color :ehp2.
menu option. 
:li.Click with the mouse in the drawing area on the color you like to have in
the pallete. 
:li.The program will make the color you clicked on, the current filling color.
And the selected color in the palette will change to this color. 
:eol.
.*--------------------------------------------------------------*\ 
.*  Indexhelp Changing the active layer 
.*      res = 3300 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_CHANGINGLAYER' res=3300.Changing layer
:i1.Changing layer
:artwork  align=left name='..\resource\layer.bmp'.
.br
Changing the layer can be done via the layer dialog which is activated with the
layer button, as shown above. The dialog shows you the objects on the selected
layer and thus enables you to find objects back which are not on the current
layer. The program supports 10 different layers. The default layer, this is the
initial layer after the program is started, is 1. The first layer is the far
most layer. For example, to be sure that the half toned circles are on top of
the halftoned (half toned means transparant colored) triangles we put the 
circles in layer 2 and the trangles in layer 1. 
:artwork  align=left name='..\help\layerx.bmp'.
.br
More about 
:link reftype=hd res=3800.layer
:elink. 
.*--------------------------------------------------------------*\ 
.*  Indexhelp Selecting objects 
.*      res = 3400 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_MOVINGOBJECTS' res=3400.Selecting objects
:i1.Selecting objects
:artwork  align=left name='..\resource\select.bmp'.
.br
:hp2.Selecting objects.
:ehp2.
By pressing the selectbutton with the above shown image the program comes into
selectmode. This can also be acomplished by pressing the <Esc> key on the
keyboard. 
.br
If you have drawn some objects like circles, squares etc you can stop with the
creation of new objects by pressing the selectbutton. If you now click on an
object the program will show arround the object it's selection handles. The
program has made a single selection. 
:artwork  align=left name='..\help\handlx.bmp'.
.br
When an object is selected it can be moved with the mouse. 
:ol compact.
:li.Click with the mouse (use left mouse button) on the object you want to move
and hold down the mouse button. 
:li.Move the mouse. 
:li.The outline of the object will move with the mouse pointer until the mouse
button is released. 
:eol.
The size of the selected object can be changed in the following way. 
.br
:ol compact.
:li.Move the mouse pointer above on of the selection handles. The shape of the
mouse pointer will change if you move over the handle. 
:li.If the shape of the mouse pointer shows two arrows press the mouse button
and start moving the mouse. 
:li.When the mouse is released the object is drawn in it's final size. 
:eol.
.br
:hp2.Multiple Selections :ehp2.
You can select more than on object at a time in  two different ways. 
.br
:ol compact.
:li.Click with the mouse outside an object and hold down the mouse button. 
:li.Start moving the mouse. The program draws a selectionbox. All objects which
fall in the selection box will show their selection handles. 
:li.Release the mouse button. 
:li.The program has made a multiple selection. 
:eol.
.br
:hp2.Multiple Selection (Second method) 
:ehp2.
:ol compact.
:li.Press the <Shift> key and hold it down. 
:li.Click with the mouse on an object and on a second,third etc object. 
:li.Release the <Shift> key. 
:li.The program has made a multiple selection. 
:eol.
.br
Moving multiple objects works the same as for single objects. 
Important, the way of selecting an object depends on the option choosen in the
options menu. DrawIt supports two different ways.
:ol.
:li.The selection can be done by clicking in the object or the object its area.
:li.The selection can only be done by clicking on the line of the object. This
is means that the selection is more precise and makes it easier to draw complex
figures on one single layer.
:eol.
.*--------------------------------------------------------------*\ 
.*  Indexhelp Additional objects 
.*      res = 3500 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_ADDINGOBJECTS' res=3500.Additional objects
:hp2.Additional objects.
:ehp2.
Objects can be added by clicking on one of the buttons, but there are more
objects. These additional objects can be found in the menu "Objects". 
.br
.br
:hp2.Regular polystar 
:ehp2.
.br
When choosing this menu option the program will popup a small dialog window
enabling you to define the number of points used in the star. The following
example is created with the maximum number of points. 
:artwork  align=left name='..\help\regstar.bmp'.
The form of the figure can be changed with the following button. 
.br
:artwork  align=left name='..\resource\splhit.bmp'.
See for details 
:link reftype=hd res=2910.Getting started. 
:elink.
.br
.br
.br
:hp2.Special lines. 
:ehp2.
.br
Click with the mouse at the point you like to start, move the mouse while
holding down the button a little to the right and make a circular movement with
mouse. Release the mouse. 
:artwork  align=left name='..\help\speclinx.bmp'.
.br
:hp2.Freestyle lines.
:ehp2.
There are two option 
:hp2.Fine :ehp2.
and 
:hp2.normal:ehp2.
. When you choose fine than the program sets every 0.25 of a second a point when
you move the mouse and hold down the left button. You can still draw normal poly
lines by just clicking at the positions where you want to have a point added.
But holding down the mouse and moving it causes the creation of a freestyle
line. When choosing normal the program set each 0.5 of second a point. 
.br
:nt.
to use the cursor keys instead of the mouse, when an object needs to be adjusted
for just one unit
:ent.
.*--------------------------------------------------------------*\ 
.*  Indexhelp Aligning objects 
.*      res = 3600 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_ALIGNEOBJECTS' res=3600.Align objects
:hp2.Aligning objects.
:ehp2.
DrawIt supports six different alignment options. 
.br
The first selected object functions as the reference point. When you want to
allign objects, start the multiple 
:link reftype=hd res=3400.selection 
:elink.on the object which you want to use as the reference point. 
.br
Examples of non aligned objects. 
:artwork  align=left name='..\help\align1.bmp'.
.br
Example of horizontal aligned object. 
:artwork  align=left name='..\help\alignh.bmp'.
:h1 id='PANEL_POLYLINES' res=3700.Polylines
:i1.Polylines
:hp2.Polylines.
:ehp2.
:artwork  align=left name='..\resource\spline.bmp'.
.br
:hp2.Deleting :ehp2.
(while drawing )
.br
While drawing a polyline the last line can be deleted by pressing the 
:hp2.minus key :ehp2.
on the numeric keypad. 
:hp2.Closing the polyline.
:ehp2.
.br
When the 
:hp2.Enter :ehp2.
key is pressed during the creation of the spline than the spline will be closed.
The spline can also be closed by clicking in the starting point. The starting
point is marked with a solid box.
.br
:hp2.Changing attributes.
:ehp2.
After you have switched to selectmode e.g you pressed the 
:hp2.<Esc> :ehp2.
key or the select button, you can move and resize the polyline. If the polyline
is selected you can easily change the color by clicking on the appropriate color
in the colorpalette at the bottom of the application, or you can drop a color
from the OS/2 colorpalette on the polyline. If you double click with the left
mouse button on the polyline you get a dialog which enables you to transport the
figure to a different 
:link reftype=hd res=3800.layer 
:elink.via the spinbutton. Further more two radio buttons enables you to set the
spline in it's default or closed state. Try the different settings to see what
happens.
:hp2.Reshaping the polyline.
:ehp2.
When the polyline is drawn on the screen and the program is switched into select
mode the polyline can be sized move and its shape can be editted. For the latter
you have to select the polygon (it shows the four black boxes) and press the
button as shown here. 
:artwork  align=left name='..\resource\splhit.bmp'.
For example if you create a regular polystar with 12 points the polystar will
show on each point an open square when this button is pressed. 
:artwork  align=left name='..\help\poly1.bmp'.
Each individual vertex can be moved by clicking in one of the small boxes and
drag the mouse (keep left button pressed ). When the mouse button is released
the the polygon is redrawn in its new shape. The selected vertex will appear as
a small solid box. When now the 
:hp2.<delete> :ehp2.
key is pressed , this vertex will be deleted. Also when pressing the 
:hp2.<Ctrl> :ehp2.
key and clicking on one of the lines of the polygon a point will be inserted. 
.br
.*--------------------------------------------------------------*\ 
.*  Help on layer dialog 
.*      res = PANEL_LAYERDIALOG 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_LAYERDIALOG' res=3800.Layer dialog
:artwork  align=left name='..\resource\layer.bmp'.
:hp2.Changing the layer.
:ehp2.
To be able to set explicitly one object on the other, the program supports
layering. You can draw your objects on 10 different layers. Layer one is the 
faremost layer. To change the current layer you click on the button with the
above shown picture. Layers which are not active or the default can be
'froozen'. This means you cannot select the objects which are on the other layer
than the current.
:color fc='Red' bc='default'.By default the objects on the other layers cannot
be selected, so an export of the selected area as metafile or bitmap will only
contain the active layer!!
:color fc='Default' bc='Default'.But if you unselect the checkbox in the layer
dialog which 'unfreezes' the other layers than all objects can be selected and
so an export of the selection will contain all objects within that area. 
:nt.
Double click on a selected object to move the object to another layer. 
:ent.
.*--------------------------------------------------------------*\ 
.*  Help on gradient fill 
.*      res = PANEL_GRADIENT 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_GRADIENT' res=3900.Gradient fill
:i1.Gradient fill
:hp2.Gradient fill.
:ehp2.
:artwork  align=left name='..\help\hgradien.bmp'.
The color sheme we used is derived from the color wheel of OS/2. If you go
within OS/2 to system setup and start up one of the color palette's you can see
the colorwheel when you double click on one of the fixed colors. The outer part
of the circle is used by drawit. So if you define a range of 360 degrees and a
starting point at zero, you see that you start in red and end in purple. So you
run around the a virtual colorwheel within drawit. The precision of the color
gradient will increase when smaller ranges are used. 
:ol.
:li.Go in the options menu to gradient, which will bringup the color gradient
dialog.
:li. Define a range and starting point to define the required gradient.
:li. Define the starting point of the gradient, this can be &colon. bottom, top,
left and right.
:li. Define the color saturation which lies between 10% and 100%. 
:li.Click on the O.K. button.
:eol.
.br
.br
Be sure that the filling menu is checked on Gradient fill. 
.br
Now every object which is drawn will be filled with the gradient you choose. 
.br
When the program is in select mode objects can get gradient fill by selecting
the object and setting the fillingpattern in the filling menu to gradient fill.
Even if the option is checked you must activate it to change the selected object
it's filling pattern! 
.br
:hp2.Suppress gradientfill. 
:ehp2.
.br
This menu option causes the program to suppress the gradient fill during drawing
on the screen. This can be handy since drawing performance increase especially
when gradient filled parts are on top of other gradient filled parts which needs
a lot of ajustments and thus causes many repaints. The gradient fill will always
be printed this option only influences the appearance on the screen. 
.br
:artwork  align=left name='..\help\txtgrad.bmp'.
.br
.*--------------------------------------------------------------*\ 
.*  Help on grouping 
.*      res = PANEL_GROUP 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_GROUP' res=4000.Group and UnGroup
:i1.Group and UnGroup
Group 
.br
Grouping objects makes it possible to treat a collection of objects if it is
one. Creating a group needs the following steps&colon. 
:ol.
:li.Set the program in selectmode by pressing the select button 
:artwork  runin name='F:\develop\dlg\RESOURCE\SELECT.BMP'.
:li.Select more than one object by moving the mouse while holding down the left
mouse button. The program draws a selectionbox.
:li.If all wanted objects like circles,sqaures and other groups are within the
selectbox, select in the Edit menu the Group option. 
:li.Click on the group in the drawing area and see what happens..... 
:eol.
.br
.br
.br
UnGroup. 
:ol.
:li.Select the group which must be ungrouped.
:li.Select in the Edit menu the UnGroup option.
:li.Try to select one of the individual objects and look.... 
:eol.
.br
.br
:nt.
Since Goups within groups are supported it can be the case that there are still
groups left. The program UnGroups one level at a time.
:ent.
.br
More detials&colon. 
.br
Since  Only a single group can be rotated. group can consist of objects with d
ifferent colors and filling patterns, it is not possible to change the color of
the individual items in a group. If one item must be recolored or put on a
different layer, you have to ungroup first before actions can be done on one of
the elements in the group. A group can also 
:hp2.not :ehp2.
be transported to a different layer. 
Only a single group can be rotated. When a group contains other groups the
rotation is not possible.
.*--------------------------------------------------------------*\ 
.*  Help on clipboard 
.*      res = PANEL_CLIPBOARD 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_CLIPBOARD' res=4100.Clipboard
:i1.Clipboard
:artwork  align=left name='..\help\clip.bmp'.
.br
The clipboard functions in the edit menu only supports bitmap and metafile
objects. 
.br
Copy&colon. 
.br
1. Set the program in selectmode. 
.br
2. Select the image which you want to copy to the clipboard. 
.br
3. Select the copy function in the edit menu or press the key's Ctrl+Insert. 
.br
Paste&colon. 
.br
1. Set the program in select mode. 
.br
2. Select the Paste option in the edit menu or press the key's Shif+Insert. 
.*--------------------------------------------------------------*\ 
.*  Help on Drag and Drop 
.*      res = PANEL_DRAGDROP 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_DRAGDROP' res=4200.DragDrop
:i1.DragDrop
As you have seen with normal objects like circles, squares, text etc, you can
change the color by dropping a color from the OS/2 color pallete directly on it.
Also a color change on multiple objects can be done when the objects are in a
multiselection box. Of course you can do this also with the normal program 
pallete which lives at the bottom of the DrawIt window. 
.br
1. Draw a circle. 
.br
2. Press the select button. 
:artwork  align=left name='..\resource\select.bmp'.
.br
3. Press the colorpallete button. 
:artwork  align=left name='..\resource\fill.bmp'.
.br
4. Drag a color to the circle object and release the mouse button. 
.br
.br
Also the font can be changed of a text object or of all selected text objects
within a multiselect, just by dropping a font from the OS/2 font pallete on it. 
.br
1. Type some text like Hello World. 
.br
2. Press the select button. 
:artwork  align=left name='..\resource\select.bmp'.
3. Press the font pallete button. 
:artwork  align=left name='..\resource\font.bmp'.
4. Drag a font from the font pallete on the text and see what happens. 
.br
.br
:hp2.Picture dropping. :ehp2.
.br
You can also drop directly from the filemanager or from the famous Explorer (WWW
browser) or any other program which supports drag and drop, pictures on DrawIt.
If the picture format is supported, DrawIt will show you directly the picture! 
.*--------------------------------------------------------------*\ 
.*  Help on circular text 
.*      res = PANEL_CIRCULARTEXT 
.*--------------------------------------------------------------*/ 
:h1 id='PANEL_CIRCULARTEXT' res=4300.CircularText
:hp2.Circular text.
:ehp2.
When you have selected a text object, the Circular option in the text menu is 
enabled. With this option you can startup the dialog which enables you to set
the text to circular. 
.br
You can set the circular attribute of the selected text on or off with the
checkbox. Standard the text starts at 180 degrees ( at nine o clock ) and ends
at 180 degrees since the sweep angle is 360 degrees, which means a full circle. 
.br
The starting angle can be changed with the most left slider. By changing the
slider position the start angle of the text will be changed. The result can be 
seen in the window at the right of the dialog. The second slider enables you to
define the sweep angle of the text. 
.br
As an example we can make circular text which describes half of the circle at
the top. 
:ol.
:li.Set the first slider which defines the start angle on 180.
:li.Set the second slider which defines the sweep angle to 180 degrees.
:li.Switch the check box on. It shows a v mark when it is on.
:li.Press the OK button.
:eol.
.br
:hp2.Example 1.
:ehp2.
.br
:artwork  align=left name='..\help\circular.bmp'.
.br
:hp2.Example 2 
:ehp2.
:artwork  align=left name='..\help\circtxt.bmp'.
:h1 id='PANEL_REGISTRATION' res=4400.Registration
:i1.Registration
:artwork  align=left name='..\help\register.bmp'.
.br
The advantage of registration is that all options in the program will work. 
.br
The price of this program is&colon. 
.br
America $25. 
.br
Holland f50,= 
The price is excluding handling costs. The handling costs depends on the way of
registration.
.br
.br
To register a version you can choose one of the following options. 
:hp2.Online resistration at Compuserve.
:ehp2.
Register the sofware via SWREG on compuserve. GO SWREG and follow the
instructions of the online software registration of Compuserve. When the
registration is recieved the software will be send to you via compuserve within
a week time. 
:hp2.Registration at BMT Micro:ehp2.
.
:artwork  align=left name='F:\DEVELOP\DLG\HELP\bmtmicro.bmp'.
Check at http://www.bmtmicro.com. 
:hp2.Send a check.
:ehp2.
Send an American Express travellers check. And a letter with your address or
your compuserve id. 
If you live in europe you can send an Eurocheck. Please specify the money in
dutch guilders. 
:hp2.Money transfer for dutch users.
:ehp2.
Dutch users can transfer money to the Postbank. Here are the details 
J. de Keijzer. 
Caro van Eyckstraat 48. 
1507 SG Zaandam. 
Giro 6586943. 
Last but not the least option, send an international money order to: 
J. de Keijzer. 
Caro van Eyckstraat 48 
1507 SG Zaandam. 
The Netherlands. 
:nt.
Please send all your comments on this program to compuserve id 101322,3665 
:ent.
.br
If you want to register this program via the post in 2000 than it is a good idea
to verify via email if the address is still correct. The last version will 
always be in the OS2SHARE directory on compuserve or at the internet side of BMT
Micro. If there is a change in address or anything else, updates will always be
put on compuserve and at BMT Micro. 
.*--------------------------------------------------------------*\ 
.* Help for printer setup 
.*      res = PANEL_QUERYPRINT 
.* ----------------------------------------------------------------- 
:h1 id='PANEL_QUERYPRINT' res=4500.Help for Printing options
:p.Select from the listbox the printer you want to use for printing. 
:p.Use the 
:hp2.Job properties...:ehp2.
pushbutton to start a dialog from which you can control your printing
configuration. 
.*--------------------------------------------------------------*\ 
.* Help for export selection to PCX,GIF,TIF and TGA... 
.*      res = PANEL_EXPORTSEL2BMP 
.* ----------------------------------------------------------------- 
:h1 id='PANEL_EXPORTSEL2BMP' res=4600.Export selection
:hp2.Export selection / Export selected Image:ehp2.
.br
In this dialog you can select the format to use when the image is written to
disk. The question of course is why all those different formats?? The reason is
that you may want to use the exported image in another application. When you use
this dialog to export a selection of figures it is possible to save it in all
number of colors. Except in the GIF format. This format does not support true
color. When you use this dialog to save the selected image the number of colors
in the selected image determines the number of colors you can select for export.
.br
Example, the 256 color version is supported by PC Paintbrush. 
.br
When the whole drawing is exported as bitmap image, both spinbuttons are filled
in with the bitmap size. The initial size in the fields are such that the aspect
ratio of the drawing is preserved. 
:nt.
True color images take a lot of diskspace.
:ent.
.*------------------------------------------------------------------ 
.* Help for keyboard 
.*      res = PANEL_KEYBOARD 
.* ----------------------------------------------------------------- 
:h1 id='PANEL_KEYBOARD' res=4700.Keyboard
:i1.Keyboard
:artwork  align=left name='..\help\keyb.bmp'.
.br
:hp2.<Ctrl> + B 
:ehp2.
.br
Bring up the file dialog for loading a bitmap. 
.br
.br
:hp2.<Ctrl> + M 
:ehp2.
.br
Bring up the file dialog for loading an OS/2 Metafile. 
.br
.br
:hp2.<Ctrl> + S 
:ehp2.
.br
Save current drawing. 
.br
.br
:hp2.<Ctrl> + T 
:ehp2.
.br
When a text object is selected an editbox will come up to enable to change the
text of the text object. 
.br
.br
:hp2.<Ctrl> + O 
:ehp2.
.br
Open a new file. 
:hp2.<Ctrl> + I
:ehp2.
When you are typing in some text you can press this key combination to start a
new text object. This is an addition to the <ENTER> key which also causes the
creation of a new text object when the program is in text input mode. 
.br
.br
:hp2.<Shift> 
:ehp2.
.br
:ol compact.
:li.Used for making multiple selections in conjunction with the left mouse
button. 
:li.To preserve the aspect ratio when drawing a circle or a square. 
:eol.
.br
:hp2.<Ctrl> 
:ehp2.
.br
Use this key together with the left mouse button to make a copy of the current
selected object (Not for images and metafiles). 
.br
.br
:hp2.B 
:ehp2.
.br
When an image is selected this causes the incrementation of the brightness. 
.br
.br
:hp2.I 
:ehp2.
.br
Inverts the selected image. 
.br
.br
:hp2.<Delete> 
:ehp2.
.br
Delete the current selected object(s). 
.br
.br
:hp2.+ 
:ehp2.
.br
Plus key on the num keypad is used for color rotation in the selected image.
Increments color values. The minus key on the num keypad is used for color
rotation in the selected image. Decrements color values. 
.br
.br
:hp2.Cursor keys 
:ehp2.
.br
Move the selected object with one unit. 
.*--------------------------------------------------------------*\ 
.* Help for object rotation 
.*      res = PANEL_ROTATION 
.* ----------------------------------------------------------------- 
:h1 id='PANEL_ROTATION' res=4800.Rotation
:i1.Rotation
:artwork  align=left name='..\resource\rotate.bmp'.
.br
Select the object you want to rotate and press the button with the picture as
shown above this text. The program will show a small dialog window in the 
upperright corner telling you how many degrees the object is rotated and the
interval to snap on while you are rotating the object. The selected object will
show its rotation center as a small circle and a rotation handle at the right
side of the object. 
:artwork  align=left name='..\help\rotex.bmp'.
.br
Click with the mouse on the rotation handle and start moving the mouse while
holding down the mouse button. The figure will rotate around the center handle.
Release the mouse button to fix the object. 
.br
Move the rotation centre when the object needs to be rotated around another
point. Click on the rotation centre and move the mouse while holding down the
button. Try to rotate the object again and see the result. 
.br
.br
:hp2.An example:ehp2.
:artwork  align=left name='..\help\rotey.bmp'.
Draw a circle with a small circle on the right hand side of the big one. Select
the small circle and press the rotation button. The small circle shows it's
rotation handle and it rotation centre. Click on the rotation centre and move
the mouse to the center of the big circle. Release the mouse to set the rotation
centre. Set the snap on degrees on 45 degrees. Press the Ctrl key and rotate the
small circle around the big circle. Each time the small circle jumps to its new
location (45 degrees further) release the mouse button. Keep the Ctrl key
pressed and rotate the new circle again. After the eightth circle is drawn,
release the mouse button. 
.br
:hp2.Example 2:ehp2.
.br
The following figure shows text which is rotated around a circle. The snap on
degrees was set on 45. 
:artwork  align=left name='..\help\rotez.bmp'.
.br
:hp2.Example 3:ehp2.
.br
:artwork  align=left name='..\help\bloem.bmp'.
:h1 id='PANEL_FORMSIZE' res=4900.Formsize
:i1.Formsize
:artwork  align=left name='..\help\form.bmp'.
:hp2.Formsize.
:ehp2.
This dialog allows you to change the formsize where you draw on. It does not
represent the forms which are supported by your printer. If you choose a certain
formsize be sure that your printer supports this form. When there is a mismatch
between the formsize on the screen and the printer the drawing will look
different when printed. This dialog allows you to setup the program in such a
way that the printout will get an almost identical look when it is printed on
your printer. When the drawing is saved to disk the forminfo is saved with the
drawing. Loading the drawing will adjust the formsize on the screen when
necessary If the file is inserted in an existing drawing, the first loaded
drawing determines the size of the form. The program will give a warning when
there is a mismatch. 
:table frame=box rules=both cols='15 15 15'.
:row.
:c.
Form name 
:c.
Inch 
:c.
Centimeter 
:row.
:c.
A4 
:c.
8&dot.27 &asterisk. 11&dot.79 
:c.
21&comma.00 &asterisk. 29&comma.96 
:row.
:c.
Letter 
:c.
8&dot.5 &asterisk. 11 
:c.
21&comma.59 &asterisk. 27&comma.94 
:row.
:c.
Legal 
:c.
8&dot.5 &asterisk. 14 
:c.
21&comma.59 &asterisk. 35&comma.56 
:row.
:c.
Executive 
:c.
7&dot.25 &asterisk. 10&dot.5 
:c.
18&comma.42 &asterisk. 26&comma.67 
:row.
:c.
C5 envelope 
:c.
6&dot.38 &asterisk. 9&dot.01 
:c.
16&comma.20 &asterisk. 22&comma.89 
:row.
:c.
DL envelope 
:c.
4&dot.33 &asterisk. 8&dot.66 
:c.
11&comma.00 &asterisk. 22&comma.00 
:row.
:c.
COM&dash.10 evelope 
:c.
4&dot.12 &asterisk. 9&dot.50 
:c.
10&comma.47 &asterisk. 24&comma.13 
:row.
:c.
Monarch envelope 
:c.
3&dot.87 &asterisk. 7&dot.50 
:c.
9&comma.84 &asterisk. 19&comma.05 
:etable.
.*--------------------------------------------------------------*\ 
.* Help for object rotation 
.*      res = PANEL_FORMSIZE 
.* ----------------------------------------------------------------- 
:h1 id='PANEL_PICFILE' res=5000.Lotus 123 Picfile.
:hp2.Lotus 123 Picfile.
:ehp2.
DrawIt supports the loading of Lotus 123 chart files. This file format is used
until Lotus 123 3.0. But the modern versions of Lotus 123 are still able to save
the chart in the old format. 
.br
The fonts can be changed for both the header text and the regular text in the
chart. The line type can be changed for all type of charts. The filling pattern
does not change the filling of a pie chart. 
.br
:nt.
Lotus is a trademark of Lotus Development Corp. 
:ent.
.*--------------------------------------------------------------*\ 
.* Help for balloon text 
.*      res = 
.* ----------------------------------------------------------------- 
:h1 id='PANEL_BALLOON' res=5100.Balloon text example.
:artwork  align=left name='..\resource\trian.bmp'.
:hp2.Balloon text example.
:ehp2.
Use the above shown button to start the creation of a poly point. Set the number
of points in the small window at its maximum value. Now when you start drawing
you see that the shape is circular. Press the ESC key or the select button. 
:artwork  align=left name='..\resource\splhit.bmp'.
Select the circle and press the above shown button. Now all the points are 
visible. Drag one point away and have a look! 
.br
:artwork  align=left name='..\help\balloon.bmp'.
:h1 id='PANEL_CIRCLE' res=5200 tutorial='Help on circles'.Circle Objects
:i1.Circles
:artwork  align=left name='F:\develop\dlg\help\cirobj.bmp'.
With this dialog window you can edit the selected circle. 
The following properties of the circle can be edited.
:ol.
:li.The layer where upon the circle is drawn.
:li.The sweep angle. The minimum sweep angle is five degrees the maximum is 360.
Zero degrees is at the right of the circle (3 o'clock) and runs counter 
clockwise.
:li.The starting angle defines where the arc is started. 
:li.The close circle check box makes is possible to close the circle with a
closing line. Even when the circle is not visible closed, it gets closed by an
invisible line. The latter enables the filling of the circle part.
:li.If the circle is not equally sized in the x and y direction the dialog shows
and extra check box to make the circle perfect round. The title bar shows that
the circle is 'distorted' when the option is available. When the circle is in
both directions equally sized the checkbox is not shown
:eol.
The figure where this chapter start with is drawn in the following way.
:ol.
:li.Draw a quarter of a closed circle.
:li.Double click on the circle and make it perfect round by checking the last
check box in the dialog. 
:li.Close the dialog by clicking on the OK button.
:li.Make four copies of the slice by pressing the <Ctrl> key and dragging a copy
of the original.
:li.Double click on one of the slices and make is start 90 degrees further than
the first, and so on.
:li.Move them together, and make a multi selection. Start the popupmenu by
clicking the right mouse button and select a color patter.
:li.Recolor the slices one by one.
:eol.
Another example:
:artwork  align=left name='F:\develop\dlg\help\SUN.BMP'.
The above shown sun is made as follows:
:ol.
:li.Draw a circle.
:li.Copy the circle and double click on the copied circle.
:li.Change the sweep angle to about 15.
:li.Place the circle segment against the full arc.
:li.Press the rotation buttons and place the rotation center in the middle of
the full arc.
:li.Press the Ctrl key and rotate the partial arc 15 degrees. Repeat this.
:eol.
When you use line ends on a circle, arrows etc, the arrows are only displayed
when it is an open circle with a sweep angle less than 350 degrees.
:h1 id='colorpal' res=5300.Color paletteDrawIt Color Palette.
:artwork  align=left name='..\resource\fill.bmp'.
Use the Color Palette to change the color of an object in DrawIt (for example,
the color of a circle). When the object does not have a filling pattern, it will
automatically get a solid filling. Be sure the object lives on the active layer.
For details on colors: 
:link reftype=hd res=3200.click here.
:elink.
:h1 id='FontPal' res=5400.Font paletteDrawIt Font Palette.
:artwork  align=left name='F:\develop\dlg\RESOURCE\FONT.BMP'.
You can drag a font sample from a sample  field and drop it on any text object
in DrawIt.  The font of that text changes to the font in the selected sample
field. 
Select Edit font so you can add, delete, 
and edit font samples. You can also 
double-click on the Font Palette window 
to display the Edit font window.   
For more details check the help of the system Font Palette.
:h1 id='ChangColor' res=5500.Changing colorsUse the 
:hp2.Color Palette :ehp2.
to change the color an object in DrawIt.
To change the color of an object in DrawIt, drag the desired color from the
Color Palette to the object you want to color. For example, you can drag blue to
on object and green to another. Be sure the object is on the active layer in 
DrawIt or all objects are accessible.
:note.You can only use this palette in conjunction with DrawIt.
:h1 id='ID_ARROWS' res=5600 global.Line ends
:i1.Clipboard
:artwork  align=left name='F:\drw29\help\arrows.BMP'.
In this dialog window you can define how a line starts and ends. The size of the
arrows can be defined with the spin button at the right side of the window. In
the preview you can see what the final result looks like.
:hp2.How to use:ehp2.
.
You can start the dialog by using or the popup menu item 
:hp2.Line ends :ehp2.
or the 
:hp2.Attribute :ehp2.
pull down menu. If you are making a diagram than the best thing you can do is to
leave the dialog window up and running. Each time you need another end or start
you click on the appropriate picture. This can be done while creating lines. 
The arrows or line ends get the same color as the line color. To change the 
color of the line simply click with the right mouse button on one of the colors
in the color palette.
:hp2.How to change the line ends of an existing line:ehp2.
.
:ol.
:li.Select the line ends menu item. The dialog for changing the line ends will
be started.
:li.Select the desired line ends.
:li.Select the line which needs the new line ends.
:li.Select the line ends menu item again.
:eol.
When multiple lines are selected than the selection of the line ends menu item
will change the line ends of all selected lines.
:note.Line ends can also be used on polylines, circles and splines
:i1.Line ends
.
:euserdoc.