#define INCL_WIN
#define INCL_GPI
#include <os2.h>

#define SPL_SPLINE 0x0004

static unsigned long arrow1[]=
{
0x000000e0,0x000000d1,0x00000114,0x0000008b,0x00000113,
0x0000008b,0x000000f5,0x0000008b,0x000000f5,0x0000008b,
0x000000f4,0x0000007f,0x000000f2,0x00000074,0x000000ef,
0x00000068,0x000000e2,0x00000044,0x000000df,0x0000003a,
0x000000d7,0x0000002b,0x000000ce,0x0000001e,0x000000c2,
0x00000010,0x000000b4,0x00000008,0x000000a5,0x00000003,
0x00000095,0x00000000,0x0000008a,0x00000005,0x0000007a,
0x00000010,0x00000066,0x00000022,0x00000054,0x0000003e,
0x00000049,0x0000005c,0x00000041,0x00000077,0x0000003c,
0x0000009c,0x00000039,0x000000d2,0x00000038,0x000000d3,
0x00000000,0x000000d2,0x00000001,0x000000d1,0x00000003,
0x000000ab,0x00000008,0x00000088,0x0000000f,0x0000006d,
0x00000014,0x00000059,0x0000001a,0x00000048,0x00000022,
0x00000036,0x0000002d,0x00000023,0x00000039,0x00000016,
0x00000046,0x0000000d,0x00000055,0x00000003,0x0000005b,
0x00000002,0x0000005b,0x00000002,0x00000095,0x00000002,
0x00000095,0x00000002,0x00000088,0x00000007,0x0000007e,
0x0000000f,0x0000007e,0x0000000f,0x00000093,0x0000001e,
0x00000095,0x00000024,0x000000a4,0x00000039,0x000000ad,
0x0000004e,0x000000b7,0x00000065,0x000000bd,0x0000007e,
0x000000bf,0x0000008d,0x000000bf,0x0000008d,0x000000a2,
0x0000008d,0x000000a2,0x0000008d
};

static unsigned long arrow2[]=
{
0x000000d1,0x00000000,0x00000100,0x00000056,0x00000100,
0x00000056,0x000000e7,0x00000056,0x000000e7,0x00000056,
0x000000e5,0x00000070,0x000000e0,0x00000088,0x000000db,
0x0000009f,0x000000d4,0x000000b2,0x000000cc,0x000000c8,
0x000000c4,0x000000da,0x000000b8,0x000000ea,0x000000af,
0x000000f7,0x000000a1,0x000000ff,0x00000099,0x00000101,
0x00000091,0x00000101,0x0000005a,0x00000101,0x00000059,
0x00000102,0x00000048,0x000000fc,0x00000034,0x000000e2,
0x00000021,0x000000c0,0x00000019,0x000000ad,0x00000012,
0x00000096,0x0000000b,0x00000075,0x00000005,0x0000005b,
0x00000002,0x00000032,0x00000001,0x00000015,0x00000000,
0x00000001,0x00000000,0x00000001,0x00000036,0x00000001,
0x00000036,0x00000001,0x00000039,0x0000002c,0x0000003d,
0x00000061,0x00000043,0x00000086,0x0000004b,0x000000a9,
0x00000058,0x000000c9,0x00000068,0x000000e5,0x00000076,
0x000000f7,0x00000076,0x000000f7,0x00000070,0x000000fc,
0x00000063,0x000000ff,0x00000057,0x00000101,0x00000057,
0x00000101,0x0000006e,0x000000fd,0x00000075,0x000000f7,
0x0000007f,0x000000f0,0x00000090,0x000000d2,0x0000009a,
0x000000b9,0x000000a5,0x00000099,0x000000aa,0x0000007f,
0x000000ae,0x00000067,0x000000b1,0x00000056,0x000000b1,
0x00000056,0x00000099,0x00000056,0x00000099,0x00000056
};


static unsigned long arrow3[]=
{
0x00000000,0x000000c2,0x0000007c,0x000000c2,0x0000007c,
0x00000079,0x0000009e,0x00000079,0x0000009e,0x00000093,
0x000000bf,0x00000062,0x0000009e,0x00000035,0x0000009e,
0x0000004a,0x0000007c,0x0000004a,0x0000007c,0x00000000,
0x00000000,0x00000000
};

static unsigned long arrow4[]=
{
0x00000000,0x00000041,0x000000b3,0x00000041,0x000000b3,
0x00000057,0x000000f3,0x0000002e,0x000000b4,0x00000000,
0x000000b3,0x00000018,0x00000000,0x00000018
};

static unsigned long arrow5[]=
{
0x00000038,0x0000003f,0x000000de,0x00000040,0x000000de,
0x00000057,0x00000117,0x0000002c,0x000000de,0x00000001,
0x000000de,0x00000017,0x00000037,0x00000017,0x00000037,
0x00000000,0x00000000,0x0000002c,0x00000038,0x00000056
};

static unsigned long arrow6[]=
{
0x00000059,0x00000088,0x00000059,0x000000b5,0x00000043,
0x000000b5,0x0000006f,0x000000e4,0x0000009e,0x000000b3,
0x00000085,0x000000b3,0x00000085,0x00000088,0x000000b5,
0x00000088,0x000000b5,0x0000009f,0x000000e2,0x00000072,
0x000000b5,0x00000043,0x000000b5,0x0000005b,0x00000086,
0x0000005b,0x00000086,0x0000002e,0x0000009d,0x0000002e,
0x0000006f,0x00000000,0x00000041,0x0000002f,0x00000059,
0x0000002f,0x00000059,0x0000005b,0x0000002c,0x0000005b,
0x0000002c,0x00000046,0x00000000,0x00000072,0x0000002d,
0x0000009f,0x0000002d,0x00000088
};
static unsigned long arrow7[]=
{
0x0000005f,0x00000127,0x0000011e,0x00000127,0x0000011e,
0x000000ba,0x0000014e,0x000000ba,0x0000014e,0x000000e0,
0x00000180,0x00000093,0x0000014f,0x0000004a,0x0000014f,
0x0000006f,0x0000011e,0x0000006f,0x0000011e,0x00000000,
0x00000062,0x00000000,0x00000062,0x00000070,0x00000032,
0x00000070,0x00000032,0x0000004a,0x00000000,0x00000094,
0x00000033,0x000000e0,0x00000033,0x000000b9,0x0000005f,
0x000000b8
};

static unsigned long arrow8[]=
{
0x000000b6,0x00000045,0x00000089,0x00000045,0x00000089,
0x00000072,0x0000009f,0x00000072,0x00000072,0x0000009e,
0x00000047,0x00000071,0x0000005d,0x00000071,0x0000005d,
0x00000044,0x0000002f,0x00000044,0x0000002f,0x0000005c,
0x00000000,0x0000002e,0x00000031,0x00000000,0x00000031,
0x00000019,0x000000b6,0x00000018,0x000000b6,0x00000001,
0x000000e3,0x0000002e,0x000000b6,0x0000005b,0x000000b6,
0x00000045
};

static unsigned long arrow9[]=
{
0x00000000,0x00000000,0x000000c3,0x00000000,0x000000c3,
0x0000008b,0x000000e1,0x0000008b,0x000000a1,0x000000d1,
0x00000061,0x0000008a,0x00000080,0x0000008a,0x00000080,
0x00000045,0x00000000,0x00000045
};

static unsigned long arrow10[]=
{
0x00000000,0x00000048,0x0000009c,0x00000048,0x000000d0,
0x00000026,0x0000009c,0x00000000,0x00000000,0x00000000,
0x00000037,0x00000025
};


static unsigned long arrow11[]=
{
0x000000cd,0x00000023,0x00000089,0x00000000,0x00000089,
0x00000000,0x00000089,0x00000000,0x00000089,0x00000014,
0x00000089,0x00000014,0x00000070,0x00000015,0x00000047,
0x0000001d,0x00000025,0x00000029,0x00000010,0x00000038,
0x00000008,0x00000043,0x00000000,0x0000004c,0x00000000,
0x0000004c,0x00000000,0x0000007a,0x00000000,0x0000007a,
0x00000009,0x0000008a,0x0000001c,0x0000009a,0x00000032,
0x000000a4,0x0000004a,0x000000ac,0x00000060,0x000000b2,
0x00000085,0x000000b5,0x000000aa,0x000000ba,0x000000ce,
0x000000b9,0x000000ce,0x000000b9,0x000000ce,0x00000096,
0x000000ce,0x00000096,0x000000af,0x00000094,0x00000088,
0x00000093,0x00000068,0x0000008d,0x00000048,0x00000085,
0x0000002f,0x0000007b,0x0000001a,0x00000073,0x00000010,
0x0000006a,0x0000000a,0x00000064,0x0000000a,0x00000064,
0x00000003,0x0000006d,0x00000002,0x0000007d,0x00000002,
0x0000007d,0x00000003,0x0000006e,0x0000000a,0x00000064,
0x0000001b,0x00000058,0x00000032,0x0000004e,0x00000055,
0x00000043,0x00000076,0x0000003f,0x00000089,0x0000003b,
0x00000089,0x0000003b,0x00000089,0x0000004e,0x00000089,
0x0000004e
};

static unsigned long arrow12[]=
{
0x00000000,0x00000024,0x00000049,0x00000000,0x00000049,
0x00000000,0x00000049,0x00000013,0x00000049,0x00000013,
0x00000067,0x00000016,0x00000080,0x0000001d,0x0000009e,
0x00000024,0x000000b9,0x00000031,0x000000c9,0x0000003e,
0x000000d5,0x0000004d,0x000000d8,0x00000053,0x000000d8,
0x00000053,0x000000d8,0x00000085,0x000000d8,0x00000085,
0x000000d1,0x00000093,0x000000bc,0x000000a5,0x0000009e,
0x000000b4,0x0000007e,0x000000be,0x00000064,0x000000c2,
0x0000004c,0x000000c6,0x00000033,0x000000c9,0x0000001b,
0x000000ca,0x00000000,0x000000ca,0x00000000,0x000000ca,
0x00000000,0x000000a0,0x00000000,0x000000a0,0x0000001b,
0x000000a0,0x00000042,0x0000009c,0x0000006d,0x00000097,
0x0000008d,0x00000090,0x000000ab,0x00000085,0x000000cd,
0x0000006f,0x000000d4,0x0000005f,0x000000d7,0x00000058,
0x000000d7,0x00000058,0x000000d3,0x00000065,0x000000cc,
0x0000006e,0x000000cd,0x0000006c,0x000000bb,0x0000005f,
0x000000a5,0x00000054,0x00000089,0x0000004b,0x00000072,
0x00000045,0x00000061,0x00000041,0x00000048,0x0000003f,
0x00000048,0x0000003f,0x00000048,0x00000053,0x00000048,
0x00000053,0x00000001,0x00000023
};

struct
{
    unsigned long *pPoints;
    int iSize;
    int iType;
} figure[]= { { arrow1, sizeof(arrow1),SPL_SPLINE },
              { arrow2, sizeof(arrow2),SPL_SPLINE },
              { arrow3, sizeof(arrow3),0 },
              { arrow4, sizeof(arrow4),0 },
              { arrow5, sizeof(arrow5),0 },
              { arrow6, sizeof(arrow6),0 },
              { arrow7, sizeof(arrow7),0 },
              { arrow8, sizeof(arrow8),0 },
              { arrow9, sizeof(arrow9),0 },
              { arrow10,sizeof(arrow10),0},
              { arrow11,sizeof(arrow11),SPL_SPLINE},
              { arrow12,sizeof(arrow12),SPL_SPLINE}
            };

static int xFigures = sizeof(figure) / sizeof(figure[0]);

/*-----------------------------------------------[ public ]------------------*/
/* name         getFigure                                                    */
/*                                                                           */
/* description  Returns a figure with the given number iFigure.              */
/*                                                                           */
/* parameters   long lFigure- figure number coming from a menu option.[ IN ] */
/*              unsigned long * ulSize - size in bytes of the figure [ OUT ] */
/*                                                                           */
/* returns      unsigned long * - pointer to the polypoints.                 */
/*---------------------------------------------------------------------------*/
unsigned long * getFigure(long lFigure, unsigned long *ulSize, int *iType)
{
   *ulSize = 0;

   if (lFigure > xFigures )
       return NULL;

   *ulSize = figure[lFigure].iSize;
   *iType  = figure[lFigure].iType;
   return figure[lFigure].pPoints;
}
