UNIT MkBMP;

{ Copyright (C) 1994-1996, Thomas G. Lane.
  This code contributed by James Arthur Boucher.

  This file contains routines to write output images in Microsoft "BMP"
  format (MS Windows 3.x and OS/2 1.x flavors).
  Either 8-bit colormapped or 24-bit full-color format can be written.
  No compression is supported. }

INTERFACE

{$I jconfig.inc}

USES
  jinclude,
  jmorecfg,
  jpeglib,
  jerror,
//  RdColMap,
  jdeferr,
  jdapimin,
  jdapistd,
  jdatasrc,
//  jdmarker,
  jdmaster,
  cdjpeg,
  math,OS2Def,OS2BASE,Os2PmApi,SysUtils,classes,
  minglib,mingutil;

CONST
    MaxArrayNum=1024*1024*32;
    AllocMemSize=1024*1024*3+5120;

TYPE
    GraphicAttr=(jpg,png,bmp);

    BMPArray=ARRAY[0..MaxArrayNum*3] OF BYTE;
    PalettRecord=RECORD
        CASE INTEGER OF
        0:(Palett:ARRAY[0..1023] OF BYTE);
        1:(qArray:ARRAY[0..255,0..3] OF BYTE);
    END;

    BitmapRecord=RECORD
       cbSize:LONGINT;
       sCx,sCy:INTEGER;
       bmpCx,bmpCy: INTEGER;
       CASE INTEGER OF
         1:( InfoHeader2:BitmapInfoHeader2;
             PalAry:PalettRecord;
             rg:BMPArray;
             );
         0:(Info2:BitmapInfo2;);
    END;
    pBitmapRecord=^BitmapRecord;

    JpegViewClass=CLASS
        OrgWidth    :INTEGER;
        Ganmma      :extended;
        GraphAttr   :GraphicAttr;
        cinfo       :jpeg_decompress_struct;
        dest_mgr    :djpeg_dest_ptr;
        jerr        : jpeg_error_mgr;
        FileName    :String;
        pBMPBody    :pBitmapRecord;
        AGanmma:PalettRecord;
        constructor Create;virtual;
        PROCEDURE MakeGanmmaPalette;
        PROCEDURE ReAlloc(px,py:INTEGER);
        PROCEDURE SetupHeader(px,py:INTEGER);
        PROCEDURE SetupGrayHeader(px,py:INTEGER);
        PROCEDURE SetupData(VAR rg:BMPArray);
        PROCEDURE JpegFileLoad;
    END;
    tMingBMPObject=CLASS(tMingObject)
        px,py:INTEGER;
        pBMP:pBitmapRecord;
        yOffset:INTEGER;
        AGanmma:PalettRecord;
        constructor Create(pB:pBitmapRecord);
        PROCEDURE UserSetPixProc(x,y:LONGINT;c:tcolor);OverRide;
    END;
    tMingBMPEncode=CLASS(tMingEncode)
        px,py:INTEGER;
        pBMP:pBitmapRecord;
        yOffset:INTEGER;
        PROCEDURE SetBMPPointer(pB:pBitmapRecord);
        FUNCTION  MGetPix (x,y:LONGINT):tcolor;OverRide;
    END;

    MingViewClass=CLASS(JpegViewClass)
        m:tMingBMPObject;
        e:tMingBMPEncode;
        constructor Create;OverRide;
        PROCEDURE MingFileLoad;
        PROCEDURE SetPngPalette;
        PROCEDURE PingFileSave(st:string);
        FUNCTION WriteBitmap(FN:String):BOOLEAN;
    END;

FUNCTION GetBMPSize(x,y:INTEGER):INTEGER;


IMPLEMENTATION

FUNCTION GetBMPSize(x,y:INTEGER):INTEGER;
BEGIN
    result:=x*y*3+SizeOf(bitmapInfoHeader2)+2048+5000;
END;

TYPE
    bmp_dest_ptr = ^bmp_dest_struct;
    bmp_dest_struct = RECORD
        pub : djpeg_dest_struct;{ public fields }

        whole_image : jvirt_sarray_ptr; { needed to reverse row order }
        data_width : JDIMENSION;{ JSAMPLEs per row }
        row_width : JDIMENSION; { physical width of one row in the BMP file }
        pad_bytes : int;        { number of padding bytes needed per row }
        cur_output_row : JDIMENSION;    { next row# to write to virtual array }
    END;


constructor JpegViewClass.create;
BEGIN
    Ganmma:=1;
    GetMem(pBMPBody,AllocMemSize);
    pBMPBody.cbSize:=AllocMemSize;
    FillChar(pBMPBody^,AllocMemSize,0);
    MakeGanmmaPalette;
END;
PROCEDURE JpegViewClass.ReAlloc(px,py:INTEGER);
VAR
    TargetSize:LONGINT;
BEGIN
    TargetSize:=GetBMPSize(px,py);
    IF TargetSize>pBMPBody^.cbSize THEN BEGIN
        ReAllocMem(pBMPBody,TargetSize);
        pBMPBody^.cbSize:=TargetSize;
    END;
END;

PROCEDURE JpegViewClass.SetupHeader(px,py:INTEGER);
BEGIN
    ReAlloc(px,py);
    FillChar(pBMPBody^.bmpCx,sizeof(BitmapInfoHeader2)+16,0);
    WITH pBMPBody^.InfoHeader2 DO BEGIN
        cbFix:=sizeof( BITMAPINFOHEADER2 );
        cx:=pX;
        cy:=pY;
        cPlanes:=1;
        cBitCount:=24;
        cbImage:=(px*py)*3;
        cclrused:=0;
        cclrImportant:=0;
    END;
    pBMPBody^.bmpCx:=px;
    pBMPBody^.bmpCy:=py;
END;

PROCEDURE JpegViewClass.MakeGanmmaPalette;
VAR
    i:INTEGER;
    r:extended;
    gv:INTEGER;
BEGIN
    IF Ganmma>2.2 THEN Ganmma:=2.2;
    IF Ganmma<0 THEN Ganmma:=0;
    FOR i:=0 TO 255 DO BEGIN
        IF i=0 THEN
            r:=0
        ELSE BEGIN
            r:=i/255;
            r:=Power(r,(1/Ganmma))*255;
        END;
        IF r>255 THEN r:=255;
        gv:=round(r);
        AGanmma.Palett[i*4  ]:= gv;
        AGanmma.Palett[i*4+1]:= gv;
        AGanmma.Palett[i*4+2]:= gv;
        AGanmma.Palett[i*4+3]:= gv;
    END;
    pBMPBody^.PalAry:=AGanmma;
END;

PROCEDURE JpegViewClass.SetupGrayHeader(px,py:INTEGER);
VAR
    i:INTEGER;
BEGIN
    ReAlloc(px,py);
    FillChar(pBMPBody^.bmpCx,sizeof(BitmapInfoHeader2)+16,0);
    WITH pBMPBody^.InfoHeader2 DO BEGIN
        cbFix:=sizeof( BITMAPINFOHEADER2 );
        cx:=pX;
        cy:=pY;
        cPlanes:=1;
        cBitCount:=8;
        cbImage:=(px*py);
        cclrused:=0;
        cclrImportant:=0;
    END;
    pBMPBody^.PalAry:=AGanmma;

    pBMPBody^.bmpCx:=px;
    pBMPBody^.bmpCy:=py;
END;

PROCEDURE JpegViewClass.SetupData(VAR rg:BMPArray);
BEGIN
    pBMPBody^.rg:=rg;
END;


PROCEDURE JpegViewClass.JpegFileLoad;
VAR
  {$ifdef PROGRESS_REPORT}
    progress : cdjpeg_progress_mgr;
  {$endif}
    num_scanlines : JDIMENSION;
    input_file:TFileStream;
    name:String;
    dest : bmp_dest_ptr;
    PROCEDURE JpegInit;
    VAR
      row_width : JDIMENSION;
    VAR
      progress : cd_progress_ptr;
    BEGIN
        dest := bmp_dest_ptr(cinfo.mem^.alloc_small (j_common_ptr(@cinfo),
                                                     JPOOL_IMAGE,
                                                     SIZEOF(bmp_dest_struct)));
        jpeg_calc_output_dimensions(@cinfo);

        row_width := cinfo.output_width * cinfo.output_components;
        dest^.data_width := row_width;
        WHILE ((row_width AND 3) <> 0) DO Inc(row_width);
        dest^.row_width := row_width;
        dest^.pad_bytes := int (row_width - dest^.data_width);

        dest^.whole_image:=cinfo.mem^.request_virt_sarray(j_common_ptr(@cinfo),
                                                          JPOOL_IMAGE,
                                                          FALSE,
                                                          row_width,
                                                          cinfo.output_height,
                                                          JDIMENSION (1));
        dest^.cur_output_row := 0;
        IF (cinfo.progress <> NIL) THEN BEGIN
            progress := cd_progress_ptr (cinfo.progress);
            Inc(progress^.total_extra_passes);
        END;

        dest^.pub.buffer := cinfo.mem^.alloc_sarray(j_common_ptr(@cinfo),
                                                    JPOOL_IMAGE,
                                                    row_width,
                                                    JDIMENSION (1));
        dest^.pub.buffer_height := 1;
        dest_mgr:= djpeg_dest_ptr(dest);
    END;(**JpegInit**)

    PROCEDURE put_gray_rows ;

    { This version is for grayscale OR quantized color output }
    VAR
      dest : bmp_dest_ptr;
      image_ptr : JSAMPARRAY;
      {register} inptr, outptr : JSAMPLE_PTR;
      {register} col : JDIMENSION;
      pad : int;
    BEGIN
      dest := bmp_dest_ptr (dest_mgr);

      { Access next row in virtual array }
        image_ptr := cinfo.mem^.access_virt_sarray( j_common_ptr(@cinfo),
                                                    dest^.whole_image,
                                                    dest^.cur_output_row,
                                                    JDIMENSION (1),
                                                    TRUE);
      Inc(dest^.cur_output_row);

      { Transfer data. }
      inptr := JSAMPLE_PTR(dest^.pub.buffer^[0]);
      outptr := JSAMPLE_PTR(image_ptr^[0]);
      FOR col := pred(cinfo.output_width) downto 0 DO
      BEGIN
        outptr^ := inptr^;  { can omit GETJSAMPLE() safely }
        Inc(outptr);
        Inc(inptr);
      END;

      { Zero out the pad bytes. }
      pad := dest^.pad_bytes;
      WHILE (pad > 0) DO
      BEGIN
        Dec(pad);
        outptr^ := 0;
        Inc(outptr);
      END;
    END;

    PROCEDURE put_jpeg_pixel_rows;
    VAR
        image_ptr : JSAMPARRAY;
        {register} inptr : JSAMPLE_PTR;
                   outptr : BGRptr;
        {register} col : JDIMENSION;
        pad : int;
    BEGIN
        dest := bmp_dest_ptr (dest_mgr);
        image_ptr := cinfo.mem^.access_virt_sarray( j_common_ptr(@cinfo),
                                                    dest^.whole_image,
                                                    dest^.cur_output_row,
                                                    JDIMENSION (1),
                                                    TRUE);
        Inc(dest^.cur_output_row);
        inptr := JSAMPLE_PTR(dest^.pub.buffer^[0]);
        outptr := BGRptr(image_ptr^[0]);
        FOR col := pred(cinfo.output_width) downto 0 DO BEGIN
            outptr^.r := AGanmma.qArray[inptr^,0];
            Inc(inptr);
            outptr^.g := AGanmma.qArray[inptr^,1];
            Inc(inptr);
            outptr^.b := AGanmma.qArray[inptr^,2];
            Inc(inptr);

            Inc(outptr);
        END;
        pad := dest^.pad_bytes;
        WHILE (pad > 0) DO BEGIN
            Dec(pad);
            JSAMPLE_PTR(outptr)^ := 0;
            Inc(JSAMPLE_PTR(outptr));
        END;
    END;(**put_jpeg_pixel_rows**)

    PROCEDURE JpegToBitmap;
    VAR
        image_ptr : JSAMPARRAY;
        row,base:LONGINT;
    BEGIN
        dest := bmp_dest_ptr(dest_mgr );
        IF (cinfo.out_color_space = JCS_RGB) THEN BEGIN
            OrgWidth:=cinfo.output_width;
            cinfo.output_width:=(cinfo.output_width+3) div 4 *4;
            SetupHeader(cinfo.output_width,cinfo.output_height);
        END
        ELSE
            SetupGrayHeader(cinfo.output_width,cinfo.output_height);
        base:=0;
        FOR row := cinfo.output_height downto 1 DO BEGIN
            image_ptr := cinfo.mem^.access_virt_sarray(j_common_ptr(@cinfo),
                                                        dest^.whole_image,
                                                        row-1,
                                                        JDIMENSION(1),
                                                        FALSE);

            Move(JSAMPLE_PTR(image_ptr^[0])^,
                 pBMPBody^.rg[base],
                 dest^.row_width);
            Inc(base,(dest^.row_width+3) div 4 *4);
        END;
    END;(**JpegToBitmap**)

VAR
    Attr:INTEGER;
BEGIN
    GraphAttr:=JPG;
    dest_mgr := NIL;
    cinfo.err := jpeg_std_error(jerr);
    jpeg_create_decompress(@cinfo);
    jerr.first_addon_message := JMSG_FIRSTADDONCODE;
    jerr.last_addon_message := JMSG_LASTADDONCODE;
  {$ifdef NEED_SIGNAL_CATCHER}
    enable_signal_catcher(j_common_ptr (@cinfo));
  {$endif}

    name:=FileName;
    IF FileExists(name) =FALSE THEN HALT(EXIT_FAILURE);
    input_file:=TFileStream.Create(name,fmOpenRead);

  {$ifdef PROGRESS_REPORT}
    start_progress_monitor(j_common_ptr (@cinfo), @progress);
  {$endif}

    jpeg_stdio_src(@cinfo, @input_file);

    {void} jpeg_read_header(@cinfo, TRUE);


    { Open the input file. }
    JpegInit;

    {void} jpeg_start_decompress(@cinfo);

    IF (cinfo.out_color_space = JCS_RGB) THEN BEGIN
        WHILE (cinfo.output_scanline < cinfo.output_height) DO BEGIN
            num_scanlines := jpeg_read_scanlines(@cinfo, dest_mgr^.buffer,
                                                  dest_mgr^.buffer_height);
            put_jpeg_pixel_rows ;
        END;
    END
    ELSE BEGIN
        WHILE (cinfo.output_scanline < cinfo.output_height) DO BEGIN
            num_scanlines := jpeg_read_scanlines(@cinfo, dest_mgr^.buffer,
                                                  dest_mgr^.buffer_height);
            put_gray_rows ;
        END;
    END;

  {$ifdef PROGRESS_REPORT}
    progress.pub.completed_passes := progress.pub.total_passes;
  {$endif}

    JpegToBitmap;
    {void} jpeg_finish_decompress(@cinfo);
    jpeg_destroy_decompress(@cinfo);
    input_file.Free;
END;

constructor tMingBMPObject.Create(pB:pBitmapRecord);
BEGIN
    pBMP:=pB;
END;

PROCEDURE tMingBMPObject.usersetpixproc(x,y:LONGINT;c:tcolor);
BEGIN
    pBMP^.RG[yOffset-(y*px)*3+x*3+0]:=AGanmma.qArray[c.blue,0];
    pBMP^.RG[yOffset-(y*px)*3+x*3+1]:=AGanmma.qArray[c.Green,1];
    pBMP^.RG[yOffset-(y*px)*3+x*3+2]:=AGanmma.qArray[c.Red,2];
END;

PROCEDURE tMingBMPEncode.SetBMPPointer(pB:pBitmapRecord);
BEGIN
    pBMP:=pB;
    px:=pBMP^.bmpCx;
    py:=pBMP^.bmpCy;
    yOffset:=px*py*3;
END;

FUNCTION  tMingBMPEncode.MGetPix (x,y:LONGINT):tcolor;
VAR
    suffix:INTEGER;
BEGIN
    suffix:=yOffset-(y*px-x)*3;
    result.blue:=   pBMP^.rg[Suffix  ];
    result.Green:=  pBMP^.rg[Suffix+1];
    result.Red:=    pBMP^.rg[Suffix+2];
END;

constructor MingViewClass.Create;
BEGIN
    inherited Create;
    m:=tMingBMPObject.Create(pBMPBody);
    e:=tMingBMPEncode.Create;
    SetPngPalette;
END;

PROCEDURE MingViewClass.SetPngPalette;
BEGIN
    m.AGanmma:=AGanmma;
END;



PROCEDURE MingViewClass.MingFileLoad;
VAR
    name:String;
    attr:INTEGER;
BEGIN
    GraphAttr:=PNG;

    name:=FileName;
    Attr:=FileGetAttr(name);
    IF Attr AND faReadOnly>0 THEN FileSetAttr(name,Attr - faReadOnly);
    m.OpenSession (Name);
    m.mingchunk:=m.GetFirstChunk;
    WHILE m.mingchunk.chunktype<>mingchunk_pinghead DO BEGIN
        m.skipchunkdata(m.mingchunk);
        m.mingchunk:=m.getnextchunk(m.mingchunk);
    END;
    m.getchunkdata(m.mingchunk,m.mingchunkdata);
    OrgWidth:=m.mingchunkdata.pinghead.width;
    m.px:=((m.mingchunkdata.pinghead.width+3)div 4 )*4;
    m.py:=m.mingchunkdata.pinghead.height;
    m.yOffset:=m.px*m.py*3;
    SetupHeader(m.px,m.py);
    m.pBMP:=pBMPBody;

    m.initpingload(m.mingchunkdata);
    WHILE NOT(m.pingloadfinished) DO
        m.pingload;
    m.finishpingload;
    m.CloseSession;
END;


PROCEDURE MingViewClass.PingFileSave(st:string);
VAR
   iHDR:tMingChunkData;
BEGIN
    e.SetBMPPointer(pBMPBody);
    e.OpenSession (st,MingType_Ping);
    iHDR.chunktype:=mingchunk_pinghead;
    WITH iHDR.pinghead DO BEGIN
        width:=e.pBMP^.bmpCx;
        height:=e.pBMP^.bmpCy;
        compressiontype:=0;
        filterType:=0;
        interlaceType:=0;
        colortype:=mingchunk_pinghead_rgbimage;
        bitdepth:=8;
    END;
    e.InitPingEncode(iHDR);
    WHILE NOT(e.PiNGEncodeFinished) DO
        e.EncodePing;
    e.finishpingEncode;
    e.CloseSession;
END;

FUNCTION MingViewClass.WriteBitmap(FN:string):BOOLEAN;
VAR
    B:File;
    BMPSize:INTEGER;
    BFINFO2:BitmapFileHeader2;
    size:INTEGER;
BEGIN
    BFInfo2.usType:=BFT_BMAP;
    BFInfo2.cbSize:=SizeOf(BitmapFileHeader2);
    BFInfo2.Offbits:=SizeOf(BitmapFileHeader2);
    BFInfo2.xHotSpot:=0;
    BFInfo2.yHotSpot:=0;
    BFInfo2.bmp2:=pBMPBody^.Infoheader2;
    size:=SizeOf(BitmapFileHeader2);
    Assign(B,FN);rewrite(B,1);
    BMPSize:=(pBMPBody^.bmpCx*pBMPBody^.bmpCy)*3;
    IF pBMPBody^.cbSize>BMPSize THEN  BEGIN
        BlockWrite(B,BFInfo2,SizeOf(BitmapFileHeader2));
//        BlockWrite(B,pBMPBody^.PalAry,1023);
        BlockWrite(B,pBMPBody^.rg,BMPSize);
    END;
    Close(b);
END;


BEGIN
END.

///$Log: MKBMP.PAS $
///Revision 5.3  2007/07/07 15:20:21  Average
///BMP̃TCY߂֐ǉ
///
///Revision 5.2  2007/07/04 16:14:36  Average
///΂΂ƕς?
///
///Revision 5.3  2007/07/04 16:12:06  Average
///p[^̃Z[u/[hꍞ݂͂߂
///
///Revision 5.2  2007/07/04 16:02:43  Average
///Ƃ肠ARender&Save悤
///
///Revision 5.1  2007/07/04 12:44:23  Average
///ӂڂASYȂĂڂ
///
///Revision 4.4  2007/06/26 14:45:58  Average
///c̐m߂
///
///Revision 4.3  2007/06/26 14:03:08  Average
/// ꉞWeby[W\ł悤
///
///Revision 4.2  2007/06/25 15:49:58  Average
///Ƃ肠makeroudȂ̉{͑vɂȂ܂B
///ꂩWeby[W̍\z
///
///Revision 4.1  2007/06/25 12:37:11  Average
/// WebAo
///
///Revision 3.5  2007/06/23 14:30:59  Average
///hbv̋}V
///
///Revision 3.4  2007/06/21 15:23:37  Average
///Ƃ肠k肭悤
///
///Revision 3.3  2007/06/20 13:41:21  Average
///TCYOt@N^
///
///Revision 3.2  2007/06/19 14:23:47  Average
///PNGt@C݂̏\
///
///Revision 3.1  2007/06/17 12:40:01  Average
///e̕FXɕύXo悤
///so[W(ύX͂)
///
///Revision 2.0  2007/06/13 16:06:57  Average
///BMPǂݍ݃[`폜
///
///Revision 1.3  2007/06/12 15:22:03  Average
///Ƃ肠_CAOoB
///
///Revision 1.2  2007/06/09 19:01:04  Average
///Ƃ肠bmp4̔{łȂ̏ǉ
///
///Revision 1.1  2007/06/06 15:39:17  Average
///Initial revision
///
///Revision 1.56  2007/06/02 22:34:21  Average
///PNGɂpbg
///
///Revision 1.55  2007/06/02 21:49:17  Average
///K}l̐ݒMă_CAOƏCB
///
///Revision 1.54  2006/12/16 15:29:36  Average
///K}ϊ̃_CAO
///
///Revision 1.53  2006/12/09 06:13:19  Average
///*** empty log message ***
///
///Revision 1.52  2006/12/04 12:40:30  Average
///RgXgݒSɔ
///
///Revision 1.51  2006/12/04 12:37:03  Average
///IvV̌`ςāAK}l̐lw\
///
///Revision 1.50  2006/11/09 12:27:54  Average
///\啪ς
///@\͑OƕςȂEEE
///
///Revision 1.3  2006/11/09 12:08:28  Average
///*** empty log message ***
///
///Revision 1.2  2006/11/08 11:12:16  Average
///^C}[ԊuԈႦĂ܂
///
///Revision 1.2  2006/11/07 16:03:08  Average
///ꉞ[hI[̏ꍇAȂ悤
///
///Revision 1.1  2006/11/04 05:34:48  Average
///*** empty log message ***
///
///Revision 0.11  2006/10/30 13:06:59  Average
///hbv𐬌
///
///Revision 0.10  2006/10/21 14:55:01  Average
///*** empty log message ***
///
///Revision 0.11  2006/10/17 16:08:43  Average
///MkBMP̒vIȃ~XC
///
///Revision 0.10  2006/10/13 16:43:07  Average
///`኱ς
///
///Revision 0.9  2006/10/07 14:56:00  Average
///*** empty log message ***
///
///Revision 1.100  2006/10/06 13:16:50  Average
///*** empty log message ***
///
///Revision 1.99  2006/09/16 17:35:44  Average
/// Ƃ肠zŒ肵ăXP[oOC
///
///Revision 1.10  2006/08/19 15:31:04  Average
///FrameTCYɂ낦IvV
///
///Revision 1.9  2006/07/02 15:44:35  Average
///Ɠ܂
///
///Revision 1.8  2006/07/02 15:37:30  Average
///炵퐬
///
///Revision 1.7  2006/07/01 16:39:01  Average
///Ƃ肠babann
///Pt@CłIbP[
///
///Revision 1.5  2006/06/27 17:57:16  Average
///Iɗ̈m
///
///Revision 1.4  2006/06/26 17:13:56  Average
///ƃ\[Xς
///
///Revision 1.3  2006/06/26 17:01:19  Average
///ŐV(1998N)pasjpeggꍇ
///
///Revision 1.2  2006/06/26 15:30:51  Average
///Ƃ肠ŐVŁB߂oKH
///
///Revision 1.1  2005/09/11 16:57:57  Average
///Initial revision
///
///Revision 1.1  2002/05/09 14:49:24  Average
///Initial revision
//////
