/* Install Text2Img - GUI-frontend to Daniel Hellerstein's gif_text
*/

nok = RxFuncAdd("SysLoadFuncs",  "RexxUtil", "SysLoadFuncs") ;rc = SysLoadFuncs();

TxIPath = directory();

say "Install to "TxIPath"? (Y/N)";

if Translate( SysGetKey('NoEcho') ) = "Y" then NOP;
else;do
   say "No installation";
   exit;
end;

if(0) then
  "unzip Text2Img";

ok = SysFileTree("Text2Img.exe","files.","F");
if files.0 = 1 then NOP;
else;do
   say "Text2Img.exe missing - installation abandoned";
   exit;
end;

/* --------------------------------------  */
/* Create Text2Img folder on WPS-desktop:  */
/* --------------------------------------  */

FolderID = "<Text2Img Objects>";

ok = SysCreateObject(   "WPFolder",             ,
                        "Text2Img",             ,
                        "<WP_DESKTOP>",         ,
                        "OBJECTID="FolderID";ICONFILE="TxIPath"\Folder1.ico",  ,
                        "Replace"               ,
                    );

if ok then
   say "Folder-object successfully created";
else;
   say "Error creating Folder-object: Code="ok;

/* --------------------------------------  */
/* Create Text2Img program-object:         */
/* --------------------------------------  */

ok = SysCreateObject(   "WpProgram",                                             ,
                        "Text2Img"||"0D0A"x||"Make Pretty Images from any Text", ,
                        FolderID,                                                ,
                        "EXENAME="TxIPath"\Text2Img.exe;ICONFILE="TxIPath"\Program.ico;"||       ,
                        "STARTUPDIR="TxIPath"\",                        ,
                        "Replace"                                       ,
                    );

if ok then
   say "Program-object successfully created";
else;
   say "Error creating program-object: Code="ok;

TXI_INI = "Text2Img.ini";

/* --------------------------------------  */
/* Initialize Text2Img.INI:                */
/* --------------------------------------  */
ok = SysINI( TXI_INI, "Settings", "GifTPath", TxIPath );
ok = SysINI( TXI_INI, "Settings", "GBMPath",  TxIPath );
ok = SysINI( TXI_INI, "Settings", "BackPath", "backs" );
ok = SysINI( TXI_INI, "Settings", "FontPath", "fonts" );
ok = SysINI( TXI_INI, "Settings", "SlidPath", "slides" );

/* --------------------------------------  */
/* Link to CDMagic, if present:            */
/* --------------------------------------  */

CDM_INI = SysSearchPath("PATH", "CDMagic.ini");

if CDM_INI = "" then do;
   say "Text2Img installation successfully completed (1)";
   exit;
end;

ok = SysINI( CDM_INI, "PlaylstCtrl", TxIPath );

say "Text2Img installation successfully completed (2)";

exit;
