#include "common.h"

char common_whitespace[] = " \t\r\n";

/* this function was one of the first 'real' things I wrote in C, so
 * please be kind... someday I'll rewrite it, but it works for now
 */
void tag_parse(tap *handlers, char *tags, void *pass)
{
	char *s_start, *s_pass, *s_end, *s_close, *s_space, *s_empty, *s_name_end, *s_contents, *s_name, *s_closetag, *s_tmp;
	char *curr = tags;
	int enufbuff, empty;
	pair *attrs;
	tag *thistag;

	if(tags == NULL || handlers == NULL)
		return;

	DBUG("Analyzing string for tags","");

	while(strlen(curr) > 0)
	{
		s_start = strstr(curr,"<");
		s_end = strstr(curr,">");
		s_space = strstr(curr," ");
		s_empty = strstr(curr,"/>");

		if(curr[0] != '<') /* some extra characters in front */
		{
			if(s_start == NULL) /* only characters left */
			{
				s_pass = strdup(curr);
				curr += strlen(curr);
			}else{
				s_pass = subpstr(curr,s_start);
				curr = s_start;
			}
			if((handlers->whitespace > 0 || strspn(s_pass,common_whitespace) < strlen(s_pass)) && handlers->h_char != NULL)
			{
				s_tmp = tag_descape(s_pass);
				(*(handlers->h_char))(s_tmp,pass);
				free(s_tmp);
			}
			free(s_pass);
			continue;
		}

		if(s_end == NULL) /* There has to be an closing '>', bail out! */
			break;

		empty = 0;
		attrs = NULL;

		s_name_end = s_end;
		if(s_empty != NULL && s_empty < s_name_end)
		{
			s_name_end = s_empty;
			empty = 1;
		}
		if(s_space != NULL && s_space < s_name_end)
		{
			s_tmp = subpstr(s_space + 1, s_name_end);
			s_name_end = s_space;
			attrs = str2pair(s_tmp);
			free(s_tmp);
		}

		if((curr + 1) >= s_name_end) /* Bad data, no name, bail out! */
		{
			free_pair(attrs);
			break;
		}

		s_name = subpstr(curr + 1,s_name_end);
		enufbuff = strlen(s_name) + 5;

		if(!empty)
		{
			s_closetag = malloc(enufbuff);
			*s_closetag = '\0';
			strcat(s_closetag,"</");
			strcat(s_closetag,s_name);
			strcat(s_closetag,">");
			s_close = strstr(curr,s_closetag);
			if(s_close == NULL) /* No closing tag, bail out! */
			{
				free_pair(attrs);
				free(s_closetag);
				free(s_name);
				break;
			}
			s_contents = subpstr(s_end + 1,s_close);
			curr = s_close + strlen(s_closetag);
			free(s_closetag);
		}
		else
		{
			curr = s_end + 1;
			s_contents = malloc(1);
			*s_contents = '\0';
		}
		thistag = tag_new(s_name, attrs, s_contents, 0);
		(*(handlers->h_tag))(thistag,pass);
		free_tag(thistag);
	}

	return;
}

tag *tag_new(char *name, pair *attributes, char *contents, int new)
{
	tag *t;

	t = malloc(sizeof(tag));
	if(new)
	{
		if(name == NULL)
			t->name = NULL;
		else
			t->name = strdup(name);

		if(attributes == NULL)
			t->attributes = NULL;
		else
			t->attributes = pair_dup(attributes);

		if(contents == NULL)
			t->contents = NULL;
		else
			t->contents = strdup(contents);

	}else{
		t->name = name;
		t->attributes = attributes;
		t->contents = contents;
	}

	return t;
}

/*
 * These next two functions, well, there HAS to be a better way of doing this, so please clue me in :)
 * I TRIED to make them a little smarter so they'd ignore it if they didn't have to replace anything...
 */

char *tag_escape(char *s)
{
	char *str1, *str2, *str3, *str4, *ret;

	if(s == NULL)
		return NULL;

	if(	strstr(s,"&") != NULL ||
		strstr(s,"'") != NULL ||
		strstr(s,"\"") != NULL ||
		strstr(s,"<") != NULL ||
		strstr(s,">") != NULL)
	{
		str1 = strrepl(s,"&","&amp;");
		str2 = strrepl(str1,"'","&apos;");
		str3 = strrepl(str2,"\"","&quot;");
		str4 = strrepl(str3,"<","&lt;");
		ret = strrepl(str4,">","&gt;");
		free(str1);
		free(str2);
		free(str3);
		free(str4);
	}else{
		ret = strdup(s);
	}
	return ret;
}

char *tag_descape(char *s)
{
	char *str1, *str2, *str3, *str4, *ret;

	if(s == NULL)
		return NULL;

	if(	strstr(s,"&gt;") != NULL ||
		strstr(s,"&lt;") != NULL ||
		strstr(s,"&quot;") != NULL ||
		strstr(s,"&apos;") != NULL ||
		strstr(s,"&amp;") != NULL)
	{
		str1 = strrepl(s,"&gt;",">");
		str2 = strrepl(str1,"&lt;","<");
		str3 = strrepl(str2,"&quot;","\"");
		str4 = strrepl(str3,"&apos;","'");
		ret = strrepl(str4,"&amp;","&");
		free(str1);
		free(str2);
		free(str3);
		free(str4);
	}else{
		ret = strdup(s);
	}
	return ret;
}

char *tag2str(tag *t, int escape)
{
	char *ret;
	pair *p;

	if(t != NULL && t->name != NULL)
	{
		ret = strgrow(NULL,"<",0,0);
		ret = strgrow(ret,t->name,1,0);
		p = t->attributes;
		while(p != NULL)
		{
			if(p->key != NULL && p->val != NULL)
			{
				ret = strgrow(ret," ",1,0);
				ret = strgrow(ret,p->key,1,0);
				ret = strgrow(ret,"='",1,0);
				ret = strgrow(ret,p->val,1,0);
				ret = strgrow(ret,"'",1,0);
			}
			p = p->next;
		}
		if(t->contents != NULL)
		{
			ret = strgrow(ret,">",1,0);
			if(escape == 1)
				ret = strgrow(ret,tag_escape(t->contents),1,1);
			else
				ret = strgrow(ret,strdup(t->contents),1,1);
			ret = strgrow(ret,"</",1,0);
			ret = strgrow(ret,t->name,1,0);
			ret = strgrow(ret,">",1,0);
		}else{
			ret = strgrow(ret,"/>",1,0);
		}
	}else{
		ret = malloc(1);
		*ret = '\0';
	}
	return ret;
}

void free_tag(tag *del)
{
	free_pair(del->attributes);
	free(del->name);
	free(del->contents);
	free(del);
}

/*********************************************************
 *
 *	Common string routines used in tsp
 *
 *********************************************************/

char *substr(char *s, char *start, char *end)
{
	char *ret, *sp, *ep;

	sp = strstr(s,start);
	ep = strstr(s,end);
	if(sp == NULL || ep == NULL)
		return NULL;

	sp += strlen(start);
	ret = subpstr(sp,ep);

	return ret;
}

char *subpstr(char *s, char *end)
{
	char *sub;
	int len;

	len = (int)end - (int)s;
	sub = malloc(len + 1);
	if(len > 0)
		strncpy(sub,s,len);
	sub[len] = '\0';

	return sub;
}

int strstrcount(char *s, char *sub)
{
	int i = 0;
	char *curr = s;

	curr = strstr(curr,sub);
	while(curr != NULL)
	{
		i++;
		curr++;
		curr = strstr(curr,sub);
	}

	return i;
}

char *strrepl(char *s, char *old, char *new)
{
	int i;
	char *ret, *lastcurr, *subs;
	char *curr = s;
	i = strstrcount(s,old);
	ret = malloc(strlen(s) + 1 + ((strlen(new) - strlen(old)) * i) );
	ret[0] = '\0';

	if(strstr(s,old) == NULL)
	{
		strcpy(ret,s);
		return ret;
	}

	while(1)
	{
		lastcurr = curr;
		curr = strstr(curr,old);
		if(curr == NULL)
		{
			strcat(ret,lastcurr);
			break;
		}
		else
		{
			subs = subpstr(lastcurr,curr);
			strcat(ret,subs);
			strcat(ret,new);
			free(subs);
			curr += strlen(old);
		}
	}
	return ret;
}

char *strgrow(char *old, char *new, int old_free, int new_free)
{
	char *ret = old;
	int i,ol,nl,left;

	if(new == NULL)
		return ret;

	nl = strlen(new) + 1;
	if(old != NULL)
	{
		ol = strlen(old);
	}else{
		ol = 0;
	}
	left = 100 - (ol % 100);
	if(left < nl || old == NULL)
	{
		i = (((ol + nl)/100)*100) + 100;
		ret = malloc(i);
		ret[0] = '\0';
		if(old != NULL)
			strcpy(ret,old);
		if(old_free)
			free(old);
	}

	strcat(ret,new);
	if(new_free)
		free(new);
	return ret;
}


