/*******************************************************************
*                                                                  *
*  void eval_arg (default_NP, max_NP, NP, trace_flag)              *
*                                                                  *
*  Get values for number of processors and set trace_flag          *
*                                                                  *
*   setenv NP 10                                                   *
*   setenv TRACE on | 1 | ON                                       *
*                                                                  *
*  command line arguments have highest priority                    *
*                                                                  *
*******************************************************************/

#include <stdlib.h>      /* getenv */

void eval_arg (default_NP, max_NP, NP, trace_flag)
int default_NP, max_NP, *NP, *trace_flag;

{ char *argument, *getarg_ ();
  char argval[10];
  int iargc_ (), narg;
  int i, j;

  /* defaults */
  *NP = default_NP;
  *trace_flag = 0;  /* default start without trace */

  argument = getenv ("NP");
  if (argument != ((char *)0) )
     {  /* printf ("eval environment variable NP = %s\n", argument); */
        sscanf (argument, "%d", NP);
     }

  argument = getenv ("TRACE");
  if (argument != ((char *)0) )
     {  /* printf ("eval environment variable TRACE = %s\n", argument); */
        if (strcmp(argument,"1") == 0)
           *trace_flag = 1;
         else if (strcmp(argument,"on") == 0)
           *trace_flag = 1;
         else if (strcmp(argument,"ON") == 0)
           *trace_flag = 1;
        printf ("trace_flag = %d\n", *trace_flag);
     }

  narg = iargc_ ();
  for (i=1;i<=narg;i++)
      { 
#ifdef ALLIANT
        argument = getarg_ (&i);
        printf ("arg[%d] = %s\n", i, argument);
        if (strcmp (argument, "-t") == 0)
           *trace_flag = 1;
          else if (strcmp (argument, "-n") == 0)
           *trace_flag = 0;
          else
           sscanf (argument, "%d", NP);
#else
        getarg_ (&i, argval);
        printf ("arg[%d] = %s\n", i, argval);
        if (strcmp (argval, "-t") == 0)
           *trace_flag = 1;
          else if (strcmp (argval, "-n") == 0)
           *trace_flag = 0;
          else
           sscanf (argval, "%d", NP);
#endif
      }

  /* Enter number of processes */

  while (*NP == 0)
   { printf ("Please enter number of processes : \n");
     scanf ("%d",NP);
     if ((*NP > max_NP) || (*NP < 1))
       { printf ("Illegal Number of Processes (only %d - %d)\n", 1, max_NP);
         *NP = 0;
       }
   }

  if (*trace_flag == 1)
     printf ("starting %d processes with trace\n", *NP);
    else
     printf ("starting %d processes\n", *NP);

}  /* eval_arg */
