/* makealbum.cmd,v 1.16 1999-08-25 21:27:55-04 rl Exp */

/*************************************************************************
 *                                                                       *
 * makealbum.cmd                                                         *
 * 1999-07-25, Rolf Lochbhler                                           *
 *                                                                       *
 * Uses functions of the RexxUtil.dll library                            *
 *                                                                       *
 *************************************************************************/

/* Some global constants */
TRUE = 1
FALSE = 0
YES = 1
NO = 0
OFF = 0
ON = 1

/* Some more global constants and default settings */
PROGRAM = 'MakeAlbum'
PROGRAM_CALL = translate( PROGRAM, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' )
AUTHOR = 'Rolf Lochbhler'
EMAIL = 'rolf@together.net'
REVISION = '1.16'
parse value date('sorted') with yyyy =5 mm =7 dd
NOW = yyyy'-'mm'-'dd time('normal')
MAIN = 'album'   /* Should be 1..8 characters */
MAIN_STEM = MAIN
START = 'start'
START_STEM = START
CONTENTS = 'contents'   /* Should be 1..8 characters */
CONTENTS_STEM = CONTENTS
FORCE = FALSE
SUB_DIRS = FALSE
EXTENSION = '.html'
TITLE = ''
START_DIR = directory()
CALL_DIR = directory()

/* Return values */
RET_OK = 0
RET_HELP = 1
RET_ERROR = 2
RET_ABORT = 3

/* Get command line arguments */
parse arg args
if args = '' then
  do
  call help
  exit RET_HELP
  end
uargs = translate( args )

/* Command line options? */
nomore = FALSE
do until nomore = TRUE
  dummy = translate( word(args,1) )
  if (dummy = '-D') | (dummy = '/D') then
    do
    parse var args . START_DIR args
    START_DIR = complete( START_DIR )
    if START_DIR <> directory(START_DIR) then
      do
      say '*Error* Cannot change to 'START_DIR
      exit RET_ERROR
      end
    end
  else if (dummy = '-F') | (dummy = '/F') then
    do
    FORCE = TRUE
    parse var args . args
    end
  else if (dummy = '-H') | (dummy = '/H') then
    do
    call help
    call directory CALL_DIR
    exit RET_HELP
    end
  else if (dummy = '-HTM') | (dummy = '/HTM') then
    do
    EXTENSION = '.htm'
    parse var args . args
    end
  else if (dummy = '-S') | (dummy = '/S') then
    do
    SUB_DIRS = TRUE
    parse var args . args
    end
  else if (dummy = '-T') | (dummy = '/T') then
    do
    if pos('"',args) > 0 then
      parse var args . '"' TITLE '"' args
    else
      parse var args . TITLE args
    TITLE = convchar( TITLE )
    end
  else
    nomore = TRUE
end

/* Some more global variables */
MAIN = MAIN || EXTENSION
CONTENTS = CONTENTS || EXTENSION
START = START || EXTENSION

/* Title and file templates */
FILE.0 = words( args )
if FILE.0 > 0 then
  do i = 1 to FILE.0
    FILE.i = word( args, i )
  end
else
  do
  say "*Error* Don't understand command line arguments [Enter]"
  pull .
  call help
  call directory CALL_DIR
  exit RET_ERROR
  end

/* Feedback */
dummy = ''
do i = 1 to FILE.0
  dummy = dummy FILE.i
end
if SUB_DIRS = TRUE then
  if TITLE = '' then
    say 'Create albums for files'dummy' in 'START_DIR' and all subdirectories, using directory names as titles [YES|no]'
  else
    say 'Create albums for files'dummy' in 'START_DIR' and all subdirectories, using same title "'TITLE'" for all albums [YES|no]'
else
  if TITLE = '' then
    say 'Create albums for files'dummy' in 'START_DIR', using directory name as title [YES|no]'
  else
    say 'Create albums for files'dummy' in 'START_DIR', using title "'TITLE'" [YES|no]'
pull answer
if substr(answer,1,1) = 'N' then
  do
  call directory CALL_DIR
  exit RET_ABORT
  end

/* Create albums in specified directories, starting in current one */
call loop

/* Create start file if necessary */
if SUB_DIRS = TRUE then
  do

  if '' = stream(START,'command','query exists') then
    call stream START, 'command', 'open write'
  else
    do
    if FORCE = TRUE then
      do
      call sysfiledelete START
      call stream START, 'command', 'open write'
      end
    else
      do
      say '*Error* File' START ' exists in 'START_DIR', please move or delete this file first, or use /f command line option to overwrite [Enter]'
      pull .
      call directory CALL_DIR
      exit RET_ERROR
      end
    end

  call lineout START, '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">'
  call lineout START, '<HTML>'
  call lineout START, '<HEAD>'
  if TITLE = '' then
    call lineout START, '<TITLE>'dirname'</TITLE>'
  else
    call lineout START, '<TITLE>'TITLE'</TITLE>'
  call lineout START, '<!-- Created 'NOW' by' PROGRAM REVISION',' convchar(AUTHOR) '<'EMAIL'> -->'
  call lineout START, '</HEAD>'
  call lineout START, '<BODY BGCOLOR="#000000" TEXT="#eeeeee" LINK="#00cccc" VLINK="#00cccc">'
  call lineout START, '<FONT FACE="Helv,Helvetica Bold,MS Sans Serif,Arial Bold">'
  call lineout START, '<P>'
  call lineout START, '<CENTER>'
  call lineout START, '<TABLE BORDER=0 CELLPADDING=5 CELLSPACING=0>'
  call lineout START, '<TR>'
  call lineout START, '<TD ALIGN="CENTER" BGCOLOR="#666666">Photo<BR>Albums</TD>'
  call lineout START, '<TD ALIGN="left">'
  call lineout START, '<UL>'

  LEVEL = 0
  call links

  call lineout START, '</UL>'
  call lineout START, '<TD>'
  call lineout START, '</TR>'
  call lineout START, '</TABLE>'
  call lineout START, '</CENTER>'
  call lineout START, '</P>'
  call lineout START, '</FONT>'
  call lineout START, '</BODY>'
  call lineout START, '</HTML>'
  call stream START, 'command', 'close'

  end

call directory CALL_DIR
exit RET_OK


/*************************************************************************
 *                                                                       *
 * loop()                                                                *
 * Traverse directories                                                  *
 *                                                                       *
 *************************************************************************/
loop : procedure expose ,
  AUTHOR CALL_DIR CONTENTS EMAIL EXTENSION FALSE FILE. FORCE MAIN NOW ,
  PROGRAM RET_ERROR RET_OK REVISION SUB_DIRS TITLE TRUE

  curdir = directory()

  /* Search for files */
  foundone = FALSE
  do i = 1 to FILE.0 
    call sysfiletree FILE.i, 'F.'i, 'fo'
    if 0 = F.i.0 then
      say '*Note* No 'FILE.i' in 'curdir
    else
      foundone = TRUE
  end

  if SUB_DIRS = FALSE then
    do

    if foundone = TRUE then
      do

      /* Create album in this directory */
      call makefiles
      return

      end
    else
      do

      /* Cannot create album in specified directory */
      say '*Error* Files not found, check command line arguments [Enter]'
      pull .
      call help
      call directory CALL_DIR
      exit RET_ERROR

      end

    end
  else
    do

    /* Create album in this directory if possible */
    if foundone = TRUE then
      call makefiles

    /* Go through all subdirectories */
    call sysfiletree '*', subdir, 'do'
    if subdir.0 > 0 then
      do i = 1 to subdir.0
        call directory subdir.i
        call loop
        call directory '..'
      end

    end   /* end else */

  return
  
  
/*************************************************************************
 *                                                                       *
 * makefiles()                                                           *
 * Create actual files                                                   *
 *                                                                       *
 *************************************************************************/
makefiles : procedure expose ,
  AUTHOR CONTENTS EMAIL EXTENSION F. FALSE FORCE FILE. MAIN NOW PROGRAM ,
  RET_ERROR RET_OK REVISION TITLE TRUE

  curdir = filespec( 'name', directory() )
  dirname = filespec( 'name', curdir )

  /* Create <frameset> file */
  if '' = stream(MAIN,'command','query exists') then
    call stream MAIN, 'command', 'open write'
  else
    do
    if FORCE = TRUE then
      do
      call sysfiledelete MAIN
      call stream MAIN, 'command', 'open write'
      end
    else
      do
      say '*Error* File' MAIN ' exists in 'curdir', please move or delete this file first, or use /f command line option to overwrite [Enter]'
      pull .
      end
    end
  
  /* Create contents file */
  if '' = stream(CONTENTS,'command','query exists') then
    call stream CONTENTS, 'command', 'open write'
  else
    do
    if FORCE = TRUE then
      do
      call sysfiledelete CONTENTS
      call stream CONTENTS, 'command', 'open write'
      end
    else
      do
      say '*Error* File' CONTENTS 'exists in 'curdir', please move or delete this file first, or use /f command line option to overwrite [Enter]'
      pull .
      end
    end
  
  /* Create album pages */
  do i = 1 to FILE.0
    do j = 1 to F.i.0
  
      /* Some file name operations */
      n = lastpos( '.', F.i.j )
      h.i.j = substr( F.i.j, 1, n - 1 )
      h.i.j = h.i.j || EXTENSION
      m = lastpos( '\', h.i.j )
      n = lastpos( '.', h.i.j )
      stem.i.j = substr( h.i.j, m+1, n-m-1 )
      shorth.i.j = substr( h.i.j, m + 1 )
      m = lastpos( '\', F.i.j )
      shortf.i.j = substr( F.i.j, m + 1 )
  
      if '' = stream(h.i.j,'command','query exists') then
        call stream h.i.j, 'command', 'open write'
      else
        do
        if FORCE = TRUE then
          do
          call sysfiledelete h.i.j
          call stream h.i.j, 'command', 'open write'
          end
        else
          do
          say '*Error* File' shorth.i.j 'exists in 'curdir', please move or delete this file first, or use /f command line option to overwrite [Enter]'
          pull .
          end
        end
  
    end
  end
  
  /* Write <frameset> and close it */
  call lineout MAIN, '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Frameset//EN" "http://www.w3.org/TR/REC-html40/frameset.dtd">'
  call lineout MAIN, '<HTML>'
  call lineout MAIN, '<HEAD>'
  if TITLE = '' then
    call lineout MAIN, '<TITLE>'dirname'</TITLE>'
  else
    call lineout MAIN, '<TITLE>'TITLE'</TITLE>'
  call lineout MAIN, '<!-- Created 'NOW' by' PROGRAM REVISION',' convchar(AUTHOR) '<'EMAIL'> -->'
  call lineout MAIN, '</HEAD>'
  call lineout MAIN, '<FRAMESET COLS="19%,81%">'
  call lineout MAIN, '  <FRAME NAME="contents" SRC="'CONTENTS'">'
  call lineout MAIN, '  <FRAME NAME="page" SRC="'shorth.1.1'">'
  call lineout MAIN, '</FRAMESET>'
  call lineout MAIN, '</HTML>'
  call stream MAIN, 'command', 'close'
  
  /* Write index file and close it */
  call lineout CONTENTS, '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">'
  call lineout CONTENTS, '<HTML>'
  call lineout CONTENTS, '<HEAD>'
  if TITLE = '' then
    call lineout CONTENTS, '<TITLE>'dirname'</TITLE>'
  else
    call lineout CONTENTS, '<TITLE>'TITLE'</TITLE>'
  call lineout CONTENTS, '<!-- Created 'NOW' by' PROGRAM REVISION',' convchar(AUTHOR) '<'EMAIL'> -->'
  call lineout CONTENTS, '</HEAD>'
  call lineout CONTENTS, '<BODY BGCOLOR="#000000" TEXT="#eeeeee" LINK="#00cccc" VLINK="#00cccc">'
  call lineout CONTENTS, '<FONT FACE="Helv,Helvetica Bold,MS Sans Serif,Arial Bold">'
  call lineout CONTENTS, '<P>'
  do i = 1 to FILE.0
    do j = 1 to F.i.0
      /* No-frames browsers should ignore the target="..." */
      call lineout CONTENTS, '<A TARGET="page" HREF="'shorth.i.j'">' || convchar(stem.i.j) || '</A>'
      call lineout CONTENTS, '<BR>'
    end
  end
  call lineout CONTENTS, '</P>'
  call lineout CONTENTS, '</FONT>'
  call lineout CONTENTS, '</BODY>'
  call lineout CONTENTS, '</HTML>'
  call stream CONTENTS, 'command', 'close'
  
  /* Write album pages and close them */
  do i = 1 to FILE.0
    do j = 1 to F.i.0
      call lineout h.i.j, '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">'
      call lineout h.i.j, '<HTML>'
      call lineout h.i.j, '<HEAD>'
      if TITLE = '' then
        call lineout h.i.j, '<TITLE>'dirname'</TITLE>'
      else
        call lineout h.i.j, '<TITLE>'TITLE'</TITLE>'
      call lineout h.i.j, '<!-- Created 'NOW' by' PROGRAM REVISION',' convchar(AUTHOR) '<'EMAIL'> -->'
      call lineout h.i.j, '</HEAD>'
      call lineout h.i.j, '<BODY BGCOLOR="#000000" TEXT="#eeeeee" LINK="#00cccc" VLINK="#00cccc">'
      call lineout h.i.j, '<FONT FACE="Helv,Helvetica Bold,MS Sans Serif,Arial Bold">'
      call lineout h.i.j, '<P>'
      call lineout h.i.j, '<IMG SRC="'shortf.i.j'">'
      call lineout h.i.j, '</P>'
      call lineout h.i.j, '</FONT>'
      call lineout h.i.j, '</BODY>'
      call lineout h.i.j, '</HTML>'
      call stream h.i.j, 'command', 'close'
    end
  end
  
  return


/*************************************************************************
 *                                                                       *
 * convchar()                                                            *
 * Convert characters for HTML                                           *
 *                                                                       *
 *************************************************************************/
convchar : procedure

  parse arg r

  chars = '<>&' || xrange( '80'x, 'ff'x )

  i = 1
  s = ''
  do until i = 0

    i = verify( r, chars, 'match' )

    if i > 0 then
      do

      if i > 1 then
        do
        parse var r t =(i) c +1 r
        s = s || t
        end
      else
        parse var r c +1 r

      select
        when c = '<' then s = s'&lt;'
        when c = '>' then s = s'&gt;'
        when c = '&' then s = s'&amp;'
        when c = '' then s = s'&Ccedil;'
        when c = '' then s = s'&uuml;'
        when c = '' then s = s'&eacute;'
        when c = '' then s = s'&acirc;'
        when c = '' then s = s'&auml;'
        when c = '' then s = s'&agrave;'
        when c = '' then s = s'&aring;'
        when c = '' then s = s'&ccedil;'
        when c = '' then s = s'&ecirc;'
        when c = '' then s = s'&euml;'
        when c = '' then s = s'&egrave;'
        when c = '' then s = s'&iuml;'
        when c = '' then s = s'&icirc;'
        when c = '' then s = s'&igrave;'
        when c = '' then s = s'&Auml;'
        when c = '' then s = s'&Aring;'
        when c = '' then s = s'&Eacute;'
        when c = '' then s = s'&aelig;'
        when c = '' then s = s'&AElig;'
        when c = '' then s = s'&ocirc;'
        when c = '' then s = s'&ouml;'
        when c = '' then s = s'&ograve;'
        when c = '' then s = s'&ucirc;'
        when c = '' then s = s'&ugrave;'
        when c = '' then s = s'&yuml;'
        when c = '' then s = s'&Ouml;'
        when c = '' then s = s'&Uuml;'
        when c = '' then s = s'&oslash;'
        when c = '' then s = s'&pound;'
        when c = '' then s = s'&Oslash;'
        when c = '' then s = s'&times;'
        when c = '' then s = s''          /* Assume ISO 8859-1 */
        when c = '' then s = s'&aacute;'
        when c = '' then s = s'&iacute;'
        when c = '' then s = s'&oacute;'
        when c = '' then s = s'&uacute;'
        when c = '' then s = s'&ntilde;'
        when c = '' then s = s'&Ntilde;'
        when c = '' then s = s'&ordf;'
        when c = '' then s = s'&ordm;'
        when c = '' then s = s'&iquest;'
        when c = '' then s = s'&reg;'
        when c = '' then s = s'&not;'
        when c = '' then s = s'&frac12;'
        when c = '' then s = s'&frac14;'
        when c = '' then s = s'&iexcl;'
        when c = '' then s = s'&laquo;'
        when c = '' then s = s'&raquo;'
        when c = '' then s = s'&Aacute;'
        when c = '' then s = s'&Acirc;'
        when c = '' then s = s'&Agrave;'
        when c = '' then s = s'&copy;'
        when c = '' then s = s'&cent;'
        when c = '' then s = s'&yen;'
        when c = '' then s = s'&atilde;'
        when c = '' then s = s'&Atilde;'
        when c = '' then s = s'&curren;'
        when c = '' then s = s'&eth;'
        when c = '' then s = s'&ETH;'
        when c = '' then s = s'&Ecirc;'
        when c = '' then s = s'&Euml;'
        when c = '' then s = s'&Egrave;'
        when c = '' then s = s''          /* Assume ISO 8859-1 */
        when c = '' then s = s'&Iacute;'
        when c = '' then s = s'&Icirc;'
        when c = '' then s = s'&Iuml;'
        when c = '' then s = s'&brvbar;'
        when c = '' then s = s'&Igrave;'
        when c = '' then s = s'&Oacute;'
        when c = '' then s = s'&szlig;'
        when c = '' then s = s'&Ocirc;'
        when c = '' then s = s'&Ograve;'
        when c = '' then s = s'&otilde;'
        when c = '' then s = s'&Otilde;'
        when c = '' then s = s'&micro;'
        when c = '' then s = s'&thorn;'
        when c = '' then s = s'&THORN;'
        when c = '' then s = s'&Uacute;'
        when c = '' then s = s'&Ucirc;'
        when c = '' then s = s'&Ugrave;'
        when c = '' then s = s'&yacute;'
        when c = '' then s = s'&Yacute;'
        when c = '' then s = s'&macr;'
        when c = '' then s = s'&acute;'
        when c = '' then s = s''          /* Assume ISO 8859-1 */
        when c = '' then s = s'&plusmn;'
        when c = '' then s = s'&para;'
        when c = '' then s = s'&sect;'
        when c = '' then s = s'&divide;'
        when c = '' then s = s'&cedil;'
        when c = '' then s = s'&deg;'
        when c = '' then s = s'&uml;'
        when c = '' then s = s'&middot;'
        when c = '' then s = s'&sup1;'
        when c = '' then s = s'&sup3;'
        when c = '' then s = s'&sup2;'
        otherwise s = s || c
      end

      end

  end

  s = s || r

  return s


/*************************************************************************
 *                                                                       *
 * help()                                                                *
 * Print help screen                                                     *
 *                                                                       *
 *************************************************************************/
help : procedure expose AUTHOR CONTENTS_STEM EMAIL MAIN_STEM REVISION ,
  PROGRAM PROGRAM_CALL START_STEM

  say PROGRAM REVISION',' AUTHOR '<'EMAIL'>'
  say 'Purpose: '
  say '  Generate an online album of picture files. View the album by loading the'
  say '  file' MAIN_STEM'.htm(l) into a web browser that knows how to deal with frames,'
  say '  or load the file' CONTENTS_STEM".htm(l) if you prefer a no-frames web browser."
  say '  Load 'START_STEM'.htm(l) in top-level directory if more than one album has'
  say '  been created with /s switch, see below.'
  say 'Usage:'
  say '  'PROGRAM_CALL' [/h] [/f] [/htm] [/s] [/d Dir] [/t Title] Files'
  say 'Parameters:'
  say '  /f      Force file generation, overwrite old files [Default: keep them]'
  say '  /h      Print help screen, then abort'
  say '  /htm    Use .htm extension [Default: .html]'
  say '  /s      Traverse subdirectories [Default: only current directory]'
  say '  Dir     Start directory [Default: current directory]'
  say '  Title   Title of the photo album. If more than one word, enclose them'
  say '          in double quotes. [Default: directory name]'
  say '  Files   List of file templates. Separate templates by a single space'
  say '          character. Use * and ? as wildcards.'
  say 'Examples:'
  say '  'PROGRAM_CALL' /t "'"Vacation 1999"'" 0000000?.jpg *.gif'
  say '  'PROGRAM_CALL' /s *.jpg'

  return


/************************************************************************* 
 *                                                                       * 
 * complete()                                                            * 
 * Complete directory/file name, substitute ellipses, etc.               * 
 *                                                                       * 
 *************************************************************************/
complete : procedure

  parse arg d

  d = strip( d, 'both' )
  d = strip( d, 'both', '"' )

  if d = '' then
    dn = directory()
  
  else if d = '.' then
    dn = directory()
  
  else if d = '..' then
    do
    curdir = directory()
    call directory '..'
    dn = directory()
    call directory curdir
    end
  
  else if substr(d,1,1) = '\' then
    do

    /* Here: '\any\dir\name' (absolute path, but missing 'drive:') */

    drive = filespec( 'drive', directory() )
    dn = drive || d

    end
  
  else if 0 = pos(':',d) then
    do

    /* Here: 'any\dir\name' (relative path) */

    dir = directory()
    if length(dir) <> lastpos('\',dir) then
      dn = dir'\'d
    else
      dn = dir || d

    end
  else if (length(d) = 2) & (2 = pos(':',d)) then

    /* Here: '?:' (drive) */

    dn = d'\'

  else
    dn = d

  return dn


/************************************************************************* 
 *                                                                       * 
 * count()                                                               * 
 * Return the number of times a character occurs in a string             * 
 *                                                                       * 
 *************************************************************************/
count : procedure

  parse arg c, s

  n = 0
  i = 0
  do until i = 0
    i = pos( c, s, i+1 )
    if i > 0 then
      n = n + 1
  end

  return n


/************************************************************************* 
 *                                                                       * 
 * links()                                                               * 
 * Create links to MAIN files in subdirectories                          * 
 *                                                                       * 
 *************************************************************************/
links : procedure expose FALSE LEVEL MAIN START START_DIR TRUE

  /* Create links to MAIN file in this directory, if there is a MAIN file in this directory */

  call sysfiletree MAIN, 'f', 'fo'
  if f.0 > 0 then
    do
    do i = 1 to f.0
      link = substr( f.i, length(START_DIR) + 2 )
      link = translate( link, '/', '\' )
      text = filespec( 'name', directory() )
      call lineout START, '<LI TYPE="circle"><A TARGET="_blank" HREF="'link'">' || convchar(text) || '</A></LI>'
    end
    if LEVEL = 0 then
      do
      call lineout START, '<HR>'
      end
    end
  else
    if LEVEL > 0 then
      do
      text = filespec( 'name', directory() )
      call lineout START, '<LI TYPE="circle">'text'</LI>'
      end


  /* Go into subdirectories */

  call sysfiletree '*', 'd', 'do'
  if d.0 > 0 then
    do
    if LEVEL > 0 then
      call lineout START, '<UL>'
    do i = 1 to d.0
      call directory d.i
      LEVEL = LEVEL + 1
      call links
      call directory '..'
      LEVEL = LEVEL - 1
      if (LEVEL = 0) & (i < d.0) then
        call lineout START, '<HR>'
    end
    if LEVEl > 0 then
      call lineout START, '</UL>'
    end

  return


