/*
 *   part of this code is origined from
 *   GOGO-no-coda
 *
 *   Copyright(C) 2001,2002,2003 gogo-developer
 */

#ifndef THREAD_H_
#define THREAD_H_

/* vbgz[ˑ */

typedef void* (*gogo_thread_func)(void *); 

/*
 *	}`XbhɑΉꍇ́A
 *	̃vbgz[ɍ킹Ĉȉ̌^Ɗ֐܂̓}Npӂ邱
 *
 *	vbgz[ˑ̌^ 
 *
 *	gogo_thread	Xbhi[^
 *	gogo_mutex	~[ebNXi[^
 *  gogo_semaphore Z}tHi[^
 *
 *	vbgz[ˑ̊֐܂̓}N 
 *	int Ԃ֐͐I 0 ԂAُIŔ 0 ԂƁB
 *
 *	Xbh֌W̏B̃Xbh֌W֐gOɈxĂ΂B
 *	int gogo_initialize_thread_unit(void)
 *
 *	Xbh֌W̏IBxĂ΂BĂ񂾌ÃXbh֐QĂł͂ȂB
 *	int gogo_finalize_thread_unit(void)
 *
 *	Xbh𐶐B
 *	int gogo_create_thread(gogo_thread* pthread, gogo_thread_func func, void *data)
 *
 *	Xbh̏I҂B
 *	int gogo_join_thread(gogo_thread* pthread)
 *
 *	XbhjBjOɏI҂ƁB
 *	int gogo_destroy_thread(gogo_thread* pthread)
 *
 *	~[ebNX𐶐B
 *	ċA~[ebNXǂ̓vbgz[ˑȂ̂ŁAċAǂɈˑȂ悤ɎgƁB
 *	int gogo_create_mutex(gogo_mutex* pmutex)
 *
 *	~[ebNXjB
 *	int gogo_destroy_mutex(gogo_mutex* pmutex)
 *
 *	~[ebNXlBlł܂ŉiɑ҂B
 *	int gogo_lock_mutex(gogo_mutex* pmutex)
 *
 *	~[ebNXB
 *	int gogo_unlock_mutex(gogo_mutex* pmutex)
 *
 *	Z}tH𐶐B
 *	l02lZ}tHB
 *  int gogo_create_semaphore(gogo_semaphore* pSemaphore)
 *
 *	Z}tHjB
 *  int gogo_destroy_semaphore(gogo_semaphore* pSemaphore)
 *
 *	Z}tHlBlł܂ŉiɑ҂B
 *  int gogo_lock_semaphore(gogo_semaphore* pSemaphore)
 *
 *	Z}tHB
 *  int gogo_unlock_semaphore(gogo_semaphore* pSemaphore)
 *
 *	Z}tHlBlł܂ timeout ~b҂B
 *  lł 0 ԂBG[܂ timeout A0ԂB
 *  int gogo_trylocktimeout_semaphore(gogo_semaphore* pSemaphore, int timeout)
 *
 *	̃XbhɎs^B
 *  void gogo_yield_thread()						
 *
 *	CPU ̐ *pCPUs ɁAXbh *pTHREADs ɕԂB
 *	킩Ȃꍇ͗K1ɂ邱ƁB
 *	int gogo_get_cpu_count(int *pCPUs, int *pTHREADs)
 *
 *	Xbh[Jf[^\̂ɒuϐ΁A
 *	L萔 GOGO_THREAD_VARIABLES ɒ`ĂB
 *
 */

#define	MT_ENCODER

#if		defined(USE_WINTHREAD)
#  include	"../win/thread_win.h"
#elif	defined(USE_PTHREAD)
#  include	"../pthread/thread_pthread.h"
#elif defined(USE_BTHREAD)
#  include	"../be/thread_be.h"
#elif defined(USE_OS2THREAD)
#  include	"../os2/thread_os2.h"
#elif defined(USE_RFORK)
#  include	"../rfork/thread_rfork.h"
#else
#  undef	MT_ENCODER
#  define	ST_ENCODER
#  define	gogo_get_cpu_count(pCPU,pTHREADs) ((*(pCPU)=1),(*(pTHREADs)=1),0)
#endif

typedef unsigned int uint32;

/**
 * vbgz[ˑ[Jϐ
 */
typedef struct gogo_thread_data_s {
/* vbgz[ˑ[Jϐ */
	float	mfbuf[2][4][576];	/* ->FFT, ->PFB */

  /* variables for newmdct.c */
        float	(*sb[4])[18][SBLIMIT];
        float	sb_sample[3][2][18][SBLIMIT];  /* PFB -> MDCT */

        float	xr[2][2][576];         /* MDCT -> Non-Linear Quantization  */
	uint32	xr_sign[2][2][576];

        float	xrpow[2][2][576];      /* Non-Linear Quantization -> Iteration Loop */
	float	work_xrpow[576]; //, save_xrpow[576], best_xrpow[576];	/* quantize.c */
        float	xrpow_sum[2][2];
        float	xrpow_max[2][2];

	int	l3_enc[2][2][576];
	III_scalefac_t	scalefac[2][2];

	int	ath_over[2][2];		/* calc_xmin() -> calc_noise() */
	III_psy_xmin	l3_xmin[2][2];	/* calc_xmin() -> calc_noise() */

	/* fft and energy calculation    */
        float	wsamp_L[2 /*granule*/][2 /*channel*/][BLKSIZE];     /* fft() -> L3psycho_anal() */
        float	wsamp_S[2 /*granule*/][2 /*channel*/][3][BLKSIZE_s];/* fft() -> L3psycho_anal() */
/* BLKSIZE=1024, BLKSIZE_s = 256 => max(BLKSIZE,BLKSIZE_s*3) = 1024 */
//		float	psywork[BLKSIZE*4];		/* wsampl_{L,S} 4(energyƋpق悢?) */
		float	psywork[576*2*4*4];		/* FFTłwork(576*2*4*4*4byte)ƂĎg */
		                                /* dȂȂ quantize.c  distort łpĎg */
        float	energy[HBLKSIZE*4];              /* ̈4{ɂFFTɂ܂Ƃ߂ď\ */
        float	energy_s[3][HBLKSIZE_s*4];       /* ̈4{ɂFFTɂ܂Ƃ߂ď\ */

	/* psycho acoustics */
	float	tot_ener[4];	/* private copy of RW.tot_ener */
	III_side_info_t	l3_side;

/* vbgz[ˑXbh[Jϐ */
#ifdef GOGO_THREAD_VARIABLES
	GOGO_THREAD_VARIABLES;
#endif

/* ACg֌WȂ̂͂牺 */
	struct gogo_thread_data_s	*next;
	void	*unaligned;
	int	tid;

	int	padding;		  /* padding for the current frame? */
	int	mode_ext;

	int	bitrate_index;
	int	ResvSize;

	// WMP6.4Ή̂ ancillary  part2_3_length ǉĂ̂
	// ̒ǉrbg
	int additional_part2_3_length[2 /*granule*/][2 /*channel*/]; 

#ifdef	MT_ENCODER
	int	exit_status;
	gogo_thread	thread;
	gogo_mutex	*critical_region;
#endif
} gogo_thread_data;	// <- gogo2encodeframe_arg_t

#endif // THREAD_H_

