<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
	Public (index) page
-->

<xsl:template match="ui/index">
  <div class="main-area-page">
    <xsl:apply-templates select="channel" mode="play"/>
    <xsl:apply-templates select="channels"/>
  </div>
</xsl:template>

<xsl:template match="index/channels">
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/winamp-playlist"/>
        <xsl:with-param name="hint" select="$lang/buttons/winamp-playlist/@hint"/>
        <xsl:with-param name="link">/listen.pls</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/administrator"/>
        <xsl:with-param name="hint" select="$lang/buttons/administrator/@hint"/>
        <xsl:with-param name="link">/ui/properties</xsl:with-param>
      </xsl:call-template>
    </span>
  </div>

  <div class="part-title"><xsl:value-of select="$lang/labels/channels"/></div>

  <xsl:call-template name="page-list">
    <xsl:with-param name="selected"><xsl:value-of select="@page"/></xsl:with-param>
    <xsl:with-param name="total"><xsl:value-of select="@pages"/></xsl:with-param>
    <xsl:with-param name="get-arg"></xsl:with-param>
  </xsl:call-template>

  <div class="part-content" style="padding: 0 2em;">
    <xsl:apply-templates select="channel" mode="index"/>
  </div>
</xsl:template>

<xsl:template match="channel" mode="index">
  <div>
    <div>
      <a name="{mp}"></a>
      <xsl:value-of select="@n"/>.
      <a href="?page={../@page}&amp;mp={mp}" onclick="return locLoad();"
         style="margin-right: 1em; font-size: 14pt;">
        <xsl:value-of select="mp"/>
      </a>
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/listen"/>
        <xsl:with-param name="hint" select="$lang/buttons/listen/@hint"/>
        <xsl:with-param name="link">/<xsl:value-of select="mp"/>.m3u</xsl:with-param>
      </xsl:call-template>
      <span class="value">
        <xsl:choose>
          <xsl:when test="name">
            <xsl:value-of select="name"/>
          </xsl:when>
          <xsl:when test="description">
            <xsl:value-of select="description"/>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </span>
      <span class="value" style="font-size: 10pt;">
        <xsl:choose>
          <xsl:when test="@content-type='application/ogg'">OGG</xsl:when>
          <xsl:when test="@content-type='audio/mpeg'">MP3</xsl:when>
          <xsl:when test="@content-type">
            <xsl:value-of select="@content-type"/>
          </xsl:when>
        </xsl:choose>
        <xsl:if test="bitrate">
          <xsl:text> </xsl:text>
          <nobr>
            <xsl:value-of select="bitrate"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="$lang/labels/kbit-sec"/>
          </nobr>
        </xsl:if>
      </span>
    </div>
    <div style="margin: 0.3em 0 1em 1em;">
      <div>
        <xsl:if test="genre">
          <nobr>
            <span class="value-title"><xsl:value-of select="$lang/labels/prop-genre"/>:</span>
            <span class="value"><xsl:value-of select="genre"/></span>
          </nobr>
        </xsl:if>
        <xsl:if test="url">
          <nobr>
            <span class="value-title"><xsl:value-of select="$lang/labels/url"/>:</span>
            <span class="value"><xsl:value-of select="url"/></span>
          </nobr>
        </xsl:if>
      </div>
      <xsl:if test="metadata">
        <div>
          <span class="value-title" style="margin-right: 0.5em;">
            <xsl:call-template name="time-format">
              <xsl:with-param name="time" select="metadata/@timestamp"/>
            </xsl:call-template>
          </span>
          <span class="value">
            <xsl:value-of select="metadata"/>
          </span>
        </div>
      </xsl:if>
    </div>
  </div>
</xsl:template>

<!--
	Channel's detail (listen channel)
-->

<xsl:template match="channel" mode="play">
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/list"/>
        <xsl:with-param name="hint" select="$lang/buttons/list/@hint"/>
        <xsl:with-param name="link">/ui/index?page=<xsl:value-of select="@page"/>#<xsl:value-of select="mp"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/refresh"/>
        <xsl:with-param name="hint" select="$lang/buttons/refresh/@hint"/>
        <xsl:with-param name="link">/ui/index?mp=<xsl:value-of select="mp"/></xsl:with-param>
      </xsl:call-template>
    </span>
  </div>

  <table cellpadding="0" cellspacing="0" border="0" class="part-content">
    <tr>
      <td class="control-title"><xsl:value-of select="$lang/labels/mount-point"/></td>
      <td class="control"><xsl:value-of select="mp"/></td>
    </tr>
    <xsl:if test="source-ip">
      <tr>
        <td class="control-title"><xsl:value-of select="$lang/labels/source"/></td>
        <td class="control"><xsl:value-of select="source-ip"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="name">
      <tr>
        <td class="control-title"><xsl:value-of select="$lang/labels/channel-name"/></td>
        <td class="control"><xsl:value-of select="name"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="url">
      <tr>
        <td class="control-title"><xsl:value-of select="$lang/labels/url"/></td>
        <td class="control"><xsl:value-of select="url"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="genre">
      <tr>
        <td class="control-title"><xsl:value-of select="$lang/labels/genre"/></td>
        <td class="control"><xsl:value-of select="genre"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="description">
      <tr>
        <td class="control-title"><xsl:value-of select="$lang/labels/description"/></td>
        <td class="control"><xsl:value-of select="description"/></td>
      </tr>
    </xsl:if>
    <xsl:if test="bitrate">
      <tr>
        <td class="control-title"><xsl:value-of select="$lang/labels/bitrate"/></td>
        <td class="control">
          <xsl:choose>
            <xsl:when test="@content-type='application/ogg'">OGG / </xsl:when>
            <xsl:when test="@content-type='audio/mpeg'">MP3 / </xsl:when>
            <xsl:when test="@content-type">
              <xsl:value-of select="@content-type"/>
              <xsl:text> </xsl:text>
            </xsl:when>
          </xsl:choose>
          <xsl:value-of select="bitrate"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="$lang/labels/kbit-sec"/>
        </td>
      </tr>
    </xsl:if>
  </table>

  <div class="part-content">
    <xsl:if test="@deny-clients-num">
      <span class="control-title">
        <span class="error">
          <xsl:value-of select="$lang/comments/deny-clients-num"/>
        </span>
      </span>
    </xsl:if>
    <xsl:if test="@deny-acl">
      <span class="control-title">
        <span class="error">
          <xsl:value-of select="$lang/comments/deny-acl"/>
        </span>
      </span>
    </xsl:if>
  </div>

  <div class="part-title"><xsl:value-of select="$lang/labels/metadata"/></div>
  <table cellpadding="0" cellspacing="0" border="0" class="part-content">
    <xsl:apply-templates select="metadata" mode="play"/>
  </table>

  <xsl:if test="not(@deny-clients-num or @deny-acl)">
    <audio autoplay="autoplay">
      <source src="/{mp}">
        <xsl:attribute name="type">
          <xsl:choose>
            <xsl:when test="@content-type='application/ogg'">audio/ogg; codecs=vorbis</xsl:when>
            <xsl:otherwise><xsl:value-of select="@content-type"/></xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
      </source>
      Your browser have no support tag &lt;audio&gt;.
    </audio>
  </xsl:if>
</xsl:template>

<xsl:template match="channel/metadata" mode="play">
  <tr>
    <td>
      <span class="control-title">
        <xsl:call-template name="time-format">
          <xsl:with-param name="time" select="@timestamp"/>
        </xsl:call-template>
      </span>
    </td>
    <td class="control">
      <xsl:value-of select="."/>
    </td>
  </tr>
</xsl:template>

</xsl:stylesheet>
