<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="logon">
  <center style="height: 100%;">
    <div class="main-area-page">

      <div class="part-content" style="text-align: left;">
        <span class="control-title">
          <xsl:call-template name="btn">
            <xsl:with-param name="caption" select="$lang/buttons/begin"/>
            <xsl:with-param name="link">/ui/index</xsl:with-param>
          </xsl:call-template>
        </span>
      </div>

      <center>
      <table cellpadding="0" cellspacing="0" border="0" class="logon">
        <form enctype="multipart/form-data" method="post">
          <tr class="first-line">
            <td class="control-title">
              <xsl:value-of select="$lang/labels/user-name"/>
            </td>
            <td class="control">
              <input type="text" class="text" name="name" autofocus="1"/>
            </td>
          </tr>
          <tr>
            <td class="control-title">
              <xsl:value-of select="$lang/labels/password"/>
            </td>
            <td class="control">
              <input type="password" class="text" name="password"/>
            </td>
          </tr>
          <tr>
            <td colspan="2" class="reason">
              <xsl:choose>
                <xsl:when test="@reason='timeout'">
                  <xsl:value-of select="$lang/labels/logon-timeout"/>
                </xsl:when>
                <xsl:when test="@reason='fail'">
                  <xsl:value-of select="$lang/labels/logon-denied"/>
                </xsl:when>
                <xsl:when test="@reason='under control'">
                  <xsl:value-of select="$lang/labels/logon-undctrl"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text> </xsl:text>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr class="last-line">
            <td colspan="2">
              <input type="submit" name="logon-submit" value="{$lang/buttons/logon}"/>
            </td>
          </tr>
        </form>
      </table>
      </center>
    </div>
  </center>
</xsl:template>

</xsl:stylesheet>
