<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--
	List of tuners
-->

<xsl:template match="ui/tuners">
  <xsl:apply-templates select="list"/>
  <xsl:apply-templates select="tuner"/>
</xsl:template>

<xsl:template match="tuners/list">
  <div class="part-content">
    <div class="control-title">
      <xsl:value-of select="$lang/comments/tuners"/>
    </div>
  </div>
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/new"/>
        <xsl:with-param name="hint" select="$lang/buttons/new/@hint"/>
        <xsl:with-param name="link">?id=new</xsl:with-param>
      </xsl:call-template>
    </span>
  </div>
  <table cellpadding="0" cellspacing="0" border="0" class="obj-list">
    <thead>
      <tr>
        <th> </th>
        <th> </th>
        <th> </th>
        <th><xsl:value-of select="$lang/labels/pattern"/></th>
        <th><xsl:value-of select="$lang/labels/properties"/></th>
      </tr>
    </thead>
    <tbody>
      <xsl:apply-templates select="tuner"/>
    </tbody>
  </table>
</xsl:template>

<xsl:template match="list/tuner">
  <tr>
    <td class="btn" style="width: 2em; color: #02163E;">
      <a name="tuner-{@id-tuner}"></a>
      <xsl:choose>
        <xsl:when test="@check">
          <form action="#tuner-{@id-tuner}" method="get" onsubmit="return locLoad();">
            <input type="hidden" name="id" value="{@id-tuner}"/>
            <input type="text" class="text" name="pos" style="width: 2em;"
                   value="{position()}" autofocus="1"/>
          </form>
        </xsl:when>
        <xsl:otherwise>
          <a href="?check={@id-tuner}#tuner-{@id-tuner}" onclick="return locLoad();">
            <xsl:value-of select="position()"/>.
          </a>
        </xsl:otherwise>
      </xsl:choose>

    </td>
    <td class="btn" style="padding-left: 0;">
      <xsl:choose>
        <xsl:when test="@check">
          <xsl:call-template name="delete-btn">
            <xsl:with-param name="link">?id=<xsl:value-of select="@id-tuner"/>&amp;del=1</xsl:with-param>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="delete-btn">
            <xsl:with-param name="link">?check=<xsl:value-of select="@id-tuner"/>#tuner-<xsl:value-of select="@id-tuner"/></xsl:with-param>
            <xsl:with-param name="check">1</xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/edit"/>
        <xsl:with-param name="hint" select="$lang/buttons/edit/@hint"/>
        <xsl:with-param name="link">?id=<xsl:value-of select="@id-tuner"/></xsl:with-param>
      </xsl:call-template>
    </td>
    <td>
      <xsl:value-of select="pattern"/>
    </td>
    <td>
      <xsl:if test="max-clients and not(max-clients='0')">
        <span class="value-title">
          <xsl:value-of select="$lang/labels/prop-max-clients"/>:
        </span>
        <span class="value"><xsl:value-of select="max-clients"/>,</span>
      </xsl:if>
      <span class="value-title">
        <xsl:value-of select="$lang/labels/prop-keep-alive"/>:
      </span>
      <span class="value">
        <xsl:value-of select="keep-alive"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$lang/labels/sec"/>,
      </span>
      <span class="value-title">
        <xsl:value-of select="$lang/labels/prop-buffer"/>:
      </span>
      <span class="value">
        <xsl:value-of select="buffer"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$lang/labels/kb"/>,
      </span>
      <span class="value-title">
        <xsl:value-of select="$lang/labels/prop-client-offs"/>:
      </span>
      <span class="value">
        <xsl:value-of select="offset"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$lang/labels/kb"/>
      </span>
    </td>
  </tr>
</xsl:template>

<!--
	Tuner's detail
-->

<xsl:template match="tuners/tuner">
  <div class="part-content">
    <span class="control-title">
      <xsl:call-template name="btn">
        <xsl:with-param name="caption" select="$lang/buttons/list"/>
        <xsl:with-param name="hint" select="$lang/buttons/list/@hint"/>
        <xsl:with-param name="link">/ui/tuners#tuner-<xsl:value-of select="@id-tuner"/></xsl:with-param>
      </xsl:call-template>
    </span>
  </div>

  <form enctype="multipart/form-data" method="post"
        onsubmit="return locLoad();">
    <table cellpadding="0" cellspacing="0" border="0" class="part-content">
      <tr>
        <td class="control-title">
          <span>
            <xsl:if test="pattern/@error">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/edit-pattern"/>
          </span>
        </td>
        <td class="control">
          <input type="text" class="text" name="pattern" value="{pattern}"/>
        </td>
        <td class="UM">
          (<xsl:value-of select="$lang/comments/pattern"/>)
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <span>
            <xsl:if test="password/@error">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/password"/>
          </span>
        </td>
        <td class="control">
          <input type="text" class="text" name="password" value="{password}"/>
        </td>
        <td class="UM">
          (<xsl:value-of select="$lang/comments/tuner-password"/>)
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <span>
            <xsl:if test="max-clients/@error">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/edit-max-clients"/>
          </span>
        </td>
        <td class="control">
          <input type="text" class="text" name="maxClients" value="{max-clients}"/>
        </td>
        <td class="UM">
          (<xsl:value-of select="$lang/comments/max-clients"/>)
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <span>
            <xsl:if test="keep-alive/@error">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/edit-keep-alive"/>
          </span>
        </td>
        <td class="control">
          <input type="text" class="text" name="keepAlive" value="{keep-alive}"/>
        </td>
        <td class="UM">
          <xsl:value-of select="$lang/labels/sec"/>
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <span>
            <xsl:if test="buffer/@error">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/edit-buffer"/>
          </span>
        </td>
        <td class="control">
          <input type="text" class="text" name="buffer" value="{buffer}"/>
        </td>
        <td class="UM">
          <xsl:value-of select="$lang/labels/kb"/>
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <span>
            <xsl:if test="buffer/@error">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/edit-client-offs"/>
          </span>
        </td>
        <td class="control">
          <input type="text" class="text" name="offset" value="{offset}"/>
        </td>
        <td class="UM">
          <xsl:value-of select="$lang/labels/kb"/>
        </td>
      </tr>
      <tr>
        <td colspan="2" class="control-title">
          <div class="part-title">
            <xsl:value-of select="$lang/labels/metadata-cp"/>
          </div>
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <span style="padding-left: 1em;">
            <xsl:if test="source-cp/@error">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/source-cp"/>
          </span>
        </td>
        <td class="control">
          <input type="text" class="text" name="sourceCP" maxlength="40" value="{source-cp}"/>
        </td>
      </tr>
      <tr>
        <td class="control-title">
          <span style="padding-left: 1em;">
            <xsl:if test="clients-cp/@error">
              <xsl:attribute name="class">error</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="$lang/labels/client-cp"/>
          </span>
        </td>
        <td class="control">
          <input type="text" class="text" name="clientsCP" maxlength="40" value="{clients-cp}"/>
        </td>
      </tr>
    </table>

    <div class="part-title">
      <xsl:value-of select="$lang/labels/source-acl"/>
    </div>
    <div class="part-content">
      <xsl:apply-templates select="acl[@type='sources']"/>
    </div>
    <div class="part-title">
      <xsl:value-of select="$lang/labels/client-acl"/>
    </div>
    <div class="part-content">
      <xsl:apply-templates select="acl[@type='clients']"/>
    </div>
    <div class="part-content">
      <div style="text-align: center;">
        <input type="submit" name="submitTunerEdit" value="{$lang/buttons/submit}"/>
      </div>
    </div>
  </form>
</xsl:template>

</xsl:stylesheet>
