/* $Id: dataStruct.h,v 1.22 1998/03/13 20:05:34 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

#ifndef DATA_STRUCT_H
#define DATA_STRUCT_H

#include "momusys.h"

#ifndef QUANT_H
#include "quant.h"
#endif /*QUANT_H*/



#define DATA        Short

#define MAXLEV      12
#define NCOLOR      3

#define SINGLE_Q    1
#define MULTIPLE_Q  2
#define BILEVEL_Q   3

/* zero tree symbols - if changed please change MapTypeToText variable */
#define IZ       0  /* Isolated Zero */
#define VAL      1  /* Value */
#define ZTR      2  /* Zero-Tree Root */
#define VZTR     3  /* Valued Zero-Tree Root */
#define ZTR_D    4  /* Parent has type of ZTR, VZTR, or ZTR_D (not coded) */
#define VLEAF    5  /* Leaf coefficient with non-zero value (not coded) */
#define ZLEAF    6  /* Leaf coefficient with zero value (not coded) */
#define UNTYPED  7  /* so far only for clearing of ZTR_Ds */

#define MAXDECOMPLEV 10
#define INF_RES       1024


#define MONO 1

#define FULLSIZE 1
#define PROGRESSIVE 0
#define MASK_VAL (0xff)

#define SKIP_NONE        0 /* Not in skip mode */
#define SKIP_TNYC        1 /* Skip mode - Type Not Yet Coded */
#define SKIP_ZTR         2 /* Skip mode - previous type coded was ZTR */
#define SKIP_IZ          3 /* Skip mode - previous type coded was IZ */

/* QValArithModel field types - if changed please change mapArithModelToText
   variable */
#define ACM_NONE  0 /* When there's no value to code */
#define ACM_SKIP  1
#define ACM_ROOT  2
#define ACM_VALZ  3
#define ACM_VALNZ 4
#define ACM_RESID 5 /* should have one for each set of coeffs arising in 
		       different initial spatial layers */
#define ACM_DC    6

typedef struct 
{
  /* not updated */
  DATA           wvt_coeff;        /* Original value in encoding.*/
  DATA           rec_coeff;        /* Reconstructed value in decoding 
				      Put here for comparing with originals
				      at decoder. Reconstructed values can
				      be put in original when memory is an
				      issue and we don't want stats to be
				      computed at decoder. */

  /* updated by quantization */
  DATA           quantized_value; /* quantized value                    */
  quantState     qState;          /* state of quantizer for coefficient */

  /* updated by marking */
  UChar          state;          /* state of coefficient                   */
  UChar          type;           /* MZTE tree types: ZTR, IZ, VZTR, or VAL */
  UChar          skip;  /* Skip coding of coefficient value (not type)     */

  /* updated by Shipeng */
  UChar          mask;

} COEFFINFO;


typedef struct {
  Int   num_ZTR;
  Int   num_VZTR;
  Int   num_VAL;
} STATINFO;


typedef struct  {
  Int    height;
  Int    width;
  UChar  *mask;
  void   *data; 
} PICTURE;

typedef struct {
   Short         quant;
   UChar        allzero;
   Int          root_max;   /* three maximum values for AC magnitude coding */
   Int          valz_max;
   Int          valnz_max;
   Int          residual_max;
   STATINFO     stat;
} SNR_IMAGE;

typedef struct {
   SNR_IMAGE  snr_image; 
} SNR_LAYER;

typedef struct {
   Short         height;
   Short         width;
   Short         SNR_scalability_levels;
   COEFFINFO    **coeffinfo;
   SNR_LAYER    SNRlayer;
} SPATIAL_LAYER;


typedef struct snr_param {
   Int SNR_scalability_levels;
   Int *Quant;
} SNR_PARAM;


typedef struct wvt_codec 
{
  Int   bit_depth; /* number bits per pixel (spatial) */
  Int   colors;    /* number of color components: 0 = mono, 3=yuv */
  Int   color_format;  /* 4:4:4, 4:2:2, or 4:2:0 ???? */
  Int   sa_dwt;
  PICTURE         *Image; /* spatial source */
  PICTURE         *SegImage; /* spatial source */
  
  Int             wvtType;      /* Type of filter */
  Int             wvtDecompLev; 

  Int             mean[NCOLOR]; /* mean of wvt coeffs in DC band ???? */
  Int             Qdc[NCOLOR];  
  Int             offset_dc;
  Int             max_dc; /* max quantized DC coeff - pre-shifting */
  Int             dcWidth, dcHeight;
  
  Int             width, height; 
  Int             spatial_scalability_levels;
  UChar   quantization_type;
  UChar   scan_order;
  UChar   SNR_start_code_enable;
  SPATIAL_LAYER   SPlayer[NCOLOR];
  
  SNR_PARAM       *Qinfo[NCOLOR];
  
  Int             target_spatial_levels;
  Int             target_snr_levels;
  Int             target_bitrate;
  Int             deringWindowSize;
  Int             deringThreshold;
  
  Int             origin_x;
  Int             origin_y;
  Int             real_width;
  Int             real_height;

  /*-----------------------*/
  Int curSpatialLev;
  Int curSNRLev;
  Int curColor;
  
  Int             acm_order;         /* 0 - zoro order, 1 - mix order */
  Int             acm_max_freq_chg;  /* 0 - default, 1 - used defined */
  Int             *acm_maxf;         /* array of user defined maximum freqs */
} WVT_CODEC;


/*-----------   VTC parameter -------------------*/


typedef struct sol_parameters {
  Int            id;
  Int            bit_depth;
  Int            colors;
  Int            sa_dwt;
  PICTURE       *Image;
  PICTURE       *SegImage;
  Char          *ImagePath;
  Char          *SegPath;
  Int            wvtType;
  Int            wvtDecompLev;
  Int            QdcY;
  Int            QdcUV;
  Int            spatial_scalability_levels;
  Int            quantization_type;
  Int            SNR_start_code_enable;
  SNR_PARAM     *SPlayer[NCOLOR];
  UChar         *buffer;
  Int            target_bitrate;
  Int            target_spatial_levels;
  Int            target_snr_levels;
  Int            deringWindowSize;
  Int            deringThreshold;
  /* for shape coding */
  Int            alphaTH;
  Int            change_CR_disable;
  Int            STO_const_alpha;
  UChar          STO_const_alpha_value;
  Int            singleBitFile;
  Char          *bitFile;
  Char          *bitFileAC;

  Int             acm_order;         /* 0 - zoro order, 1 - mix order */
  Int             acm_max_freq_chg;  /* 0 - default, 1 - used defined */
  Int             *acm_maxf;         /* array of user defined maximum freqs */
} SOL_PARAMETERS;



/*-----------   VTC parameter for decoder -------------------*/


typedef struct sol_parameters_dec {
  Int            bit_depth;
  Int            colors;
  Int            sa_dwt;
  PICTURE       *SegImage;
  Char          *SegPath;
  Int            width;
  Int            height;
  Int            wvtType;
  Int            wvtDecompLev;
  Int            target_bitrate;
  Int            target_spatial_levels;
  Int            target_snr_levels;
  Int            deringWindowSize;
  Int            deringThreshold;
  Int            singleBitFile;
  Char          *bitFile;
  Char          *bitFileAC;

  Int             acm_order;         /* 0 - zoro order, 1 - mix order */
  Int             acm_max_freq_chg;  /* 0 - default, 1 - used defined */
  Int             *acm_maxf;         /* array of user defined maximum freqs */

} SOL_PARAMETERS_DEC;

#endif /*DATA_STRUCT_H*/

