/* $Id: quant.h,v 1.8 1998/03/06 15:40:21 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/


#ifndef QUANT_H
#define QUANT_H

/*
  State data structure for single-step quantizer and inverse quantizer.
  The internals here don't need to be used directly.

  residualValue - In quantization it's the difference between the beginning
    of the quantization level and the actual value being quantized. If not
    in the dead zone then an absolute difference is used.
    In inverse quantization it's the beginning of the last quantization level.
    Beginning of dead zone defined as 0.

  partitionType - Bit field. Bit 0 is fromReduced. Bit 1 is fromDeadZone.

     fromReduced - It is set to 1 if the quantization level in the last step 
       was reduced size (one less than the specified value by statePrevQ). It 
       is set to 0 if the quantization level of last step was the full size, 
       statePrevQ.

     fromDeadZone - It is set to 1 if the last step's quantization level was 
       the dead zone around zero (level 0). Set to 0 otherwise.
*/
typedef struct
{
  int residualValue;
  unsigned char partitionType;
}
  quantState;


/*----- Quantizer function prototypes -----*/

#include "quant.p"

#endif /*QUANT_H*/
