/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Ulrike Pestel (TUH / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Fernando Jaureguizar (UPM / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *
 * File:        vm_midproc.c
 *
 * Author:      Ulrike Pestel-Schiller
 * Created:     21.05.97
 *
 * Description: Midprocessor
 *
 * Notes:       
 *
 * Modified:    
 *      09.03.98 Fernando Jaureguizar: New formating. Deleted error_flag
 *               parameter in UpsampleTexture()
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include <assert.h>

#include "momusys.h"
#include "mom_access.h"
#include "mom_structs.h"
#include "vm_common_defs.h"
#include "mom_image.h"
#include "vm_midproc.h"

/***********************************************************CommentBegin******
 *
 * -- Midproc -- Midprocessor in the case of scalability
 *
 * Author :
 *      pestel@tnt.uni-hannover.de
 *
 * Created :
 *      21.05.97    
 *
 * Purpose :
 *      Builds the block Midprocessor of VM
 *
 * Arguments in :
 *      Vop   *rec_vop,    pointer to Vop of reconstructed image BASE Layer
 *      
 * Arguments in/out :
 *
 *
 * Arguments out :
 *      Vop   *rec_vop_int, pointer to Vop of reconstructed interpolated image
 *
 * Return values :
 *      none
 *
 * Side effects :
 *      Allocates memory to interpolated image
 *
 * Description :
 *
 *
 * See also :
 *
 *
 * Modified :
 *     30.07.97 F. Jaureguizar: added the all_255 alpha_uv mask for the
 *              upsampled vop. (SpSc)
 *
 ***********************************************************CommentEnd********/

Vop*
Midproc(
   Vop   *vop,
   Vol   *layer
   )
{
  Vop   *up_vop=NULL;

  /* VOP for upsampled reconstructed base layer allocated*/


  up_vop=AllocVop(GetVopWidth(vop)*2, GetVopHeight(vop)*2);

  UpsampleTexture(GetVopY(vop), GetVopY(up_vop), layer);
  UpsampleTexture(GetVopU(vop), GetVopU(up_vop), layer);
  UpsampleTexture(GetVopV(vop), GetVopV(up_vop), layer);
  SetConstantImage(GetVopA(up_vop), 255); /* only rectangular VOPS */
  SetConstantImage(GetVopAuv(up_vop), 255); /* only rectangular VOPS *//*SpSc*/

return(up_vop);
}

/********************************CommentBegin**************************
 *
 * -- UpsampleTexture -- Upsamples an image to double size
 *
 * Author :
 *      Per Thorell (ETX)
 *
 * Created :
 *      25.07.96
 *
 * Description :
 *      Upsamples an image to double size
 *
 * Arguments in :
 *      Image  *small_image,  
 *
 * Arguments in/out :    
 *
 *
 * Arguments out :
 *      Image  *big_image
 *
 * Return values :
 *      none 
 *
 * Side effects :
 *      Modifies output arguments
 *
 * See also : 
 *
 * Modified :
 *      30.11.97 Takefumi Nagumo(SONY): add Vol *layer 
 *
 *********************************CommentEnd***************************/

/* Upsampling Filter Module for MoMuSys CD software */

Void
UpsampleTexture(
   Image   *small_image,  
   Image   *big_image,
   Vol     *layer
   )

{
  Int    x, y, y1, y2, x1, x2;

  SInt   *pict;
  SInt   *pict_dist;

  Int    width, height;
  Int    width_dist, height_dist;

/*1197-3 SONY */  
  Int vertical_sampling_factor_m = GetVolHorSampM(layer);
  Int vertical_sampling_factor_n = GetVolHorSampN(layer);
  Int horizontal_sampling_factor_m = GetVolVerSampM(layer);
  Int horizontal_sampling_factor_n = GetVolVerSampN(layer);
/*1197-3 SONY */  
  Int phase = 0;
  
  Int *pict_vert;

  width  = (Int)GetImageSizeX (small_image);
  height = (Int)GetImageSizeY (small_image); 

  width_dist  = (Int)GetImageSizeX (big_image);
  height_dist = (Int)GetImageSizeY (big_image); 

  assert(height_dist == 2*height);
  assert(width_dist == 2*width);

  pict = (SInt *) GetImageData(small_image); 
  pict_dist = (SInt *) GetImageData(big_image); 

  pict_vert = (Int *) malloc (sizeof(int)*width*height_dist);


  for(x=0;x< width; x++)
    for(y=0;y< height_dist; y++)
      {
      y1 = (y*vertical_sampling_factor_m )/vertical_sampling_factor_n;
      if(y1 < height - 1)
        y2 = y1+1;
      else
        y2 = y1;
      phase = (16*((y*vertical_sampling_factor_m)%
                   vertical_sampling_factor_n) + vertical_sampling_factor_n/2
                   /*for rounding*/)
               /vertical_sampling_factor_n;
      *(pict_vert+y*width+x) = (int)(16-phase)*(*(pict+y1*width+x))
                                 + phase *(*(pict+y2*width+x));
      }
  
  for(y=0;y< height_dist; y++)
    for(x=0;x< width_dist; x++)
      {
      x1 = (x*horizontal_sampling_factor_m )/horizontal_sampling_factor_n;
      if(x1 < width - 1)
        x2 = x1+1;
      else
        x2 = x1;

      /*Warning*/
      /* no rounding */
      phase = (16*((x*horizontal_sampling_factor_m)%
               horizontal_sampling_factor_n) + horizontal_sampling_factor_n/2
               /*for rounding*/)
              /horizontal_sampling_factor_n;
      *(pict_dist+y*width_dist+x)
        =(unsigned char)(((16-phase)*(*(pict_vert+y*width+x1))
          +phase *(*(pict_vert+y*width+x2)) +128 )>>8 );
      }
  free(pict_vert);
}
