/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.sourceforge.dvb.projectx.audio.AudioFormatAAC;
import net.sourceforge.dvb.projectx.audio.AudioFormatAC3;
import net.sourceforge.dvb.projectx.audio.AudioFormatDTS;
import net.sourceforge.dvb.projectx.audio.AudioFormatLPCM;
import net.sourceforge.dvb.projectx.audio.AudioFormatMPA;
import net.sourceforge.dvb.projectx.audio.AudioFormatWAV;
import net.sourceforge.dvb.projectx.common.Common;

public class AudioFormat {
    private AudioFormat impl = null;
    private boolean INTEL;
    private int ID;
    private int Layer;
    private int Protection_bit;
    private int Private_bit;
    private int Bitrate;
    private int Sampling_frequency;
    private int Padding_bit;
    private int Mode;
    private int Mode_extension;
    private int Copyright;
    private int Original;
    private int Channel;
    private int Emphasis;
    private int Size;
    private int Size_base;
    private double Time_length;
    private int nID;
    private int nLayer;
    private int nProtection_bit;
    private int nPrivate_bit;
    private int nBitrate;
    private int nSampling_frequency;
    private int nPadding_bit;
    private int nMode;
    private int nMode_extension;
    private int nCopyright;
    private int nOriginal;
    private int nChannel;
    private int nEmphasis;
    private int nSize;
    private int nSize_base;
    private double nTime_length;
    private int lID;
    private int lLayer;
    private int lProtection_bit;
    private int lPrivate_bit;
    private int lBitrate;
    private int lSampling_frequency;
    private int lPadding_bit;
    private int lMode;
    private int lMode_extension;
    private int lCopyright;
    private int lOriginal;
    private int lChannel;
    private int lEmphasis;
    private int lSize;
    private int lSize_base;
    private double lTime_length;

    public AudioFormat() {
        this.init();
    }

    public AudioFormat(int n) {
        this.setNewType(n);
    }

    public AudioFormat(byte[] byArray) {
    }

    public int compareHeader() {
        return this.impl == null ? 0 : this.impl.compareHeader();
    }

    public byte[][] convertFrame(byte[] byArray, int n) {
        if (this.impl == null) {
            return new byte[][]{byArray, new byte[0]};
        }
        return this.impl.convertFrame(byArray, n);
    }

    public String decodeAncillaryData(byte[] byArray, double d) {
        return this.impl == null ? null : this.impl.decodeAncillaryData(byArray, d);
    }

    public String displayHeader() {
        return this.impl == null ? "" : this.impl.displayHeader();
    }

    public byte[] editFrame(byte[] byArray, int n) {
        return this.impl == null ? byArray : this.impl.editFrame(byArray, n);
    }

    public long fillRiffHeader(String string) {
        long l = 0L;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            int n = (int)randomAccessFile.length() - 8;
            randomAccessFile.seek(3L);
            if (!this.isINTEL()) {
                randomAccessFile.write(88);
            }
            randomAccessFile.seek(4L);
            randomAccessFile.writeInt(this.littleEndian(n, 4));
            randomAccessFile.seek(16L);
            randomAccessFile.writeInt(this.littleEndian(16, 4));
            randomAccessFile.writeShort(this.littleEndian(1, 2));
            randomAccessFile.writeShort((short)this.littleEndian(this.lChannel, 2));
            randomAccessFile.writeInt(this.littleEndian(this.lSampling_frequency, 4));
            randomAccessFile.writeInt(this.littleEndian(this.lBitrate / 8, 4));
            randomAccessFile.writeShort((short)this.littleEndian(this.lMode, 2));
            randomAccessFile.writeShort((short)this.littleEndian(this.lSize, 2));
            randomAccessFile.seek(40L);
            randomAccessFile.writeInt(this.littleEndian(n - 36, 4));
            randomAccessFile.close();
            l = 8000L * (long)(n - 36) / (long)this.lBitrate;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return l;
    }

    public void fillStdRiffHeader(String string, long l) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            int n = (int)randomAccessFile.length() - 8;
            int n2 = 1411200;
            randomAccessFile.seek(4L);
            randomAccessFile.writeInt(this.littleEndian(n, 4, true));
            randomAccessFile.seek(16L);
            randomAccessFile.writeInt(this.littleEndian(16, 4, true));
            randomAccessFile.writeShort(this.littleEndian(1, 2, true));
            randomAccessFile.writeShort((short)this.littleEndian(2, 2, true));
            randomAccessFile.writeInt(this.littleEndian(44100, 4, true));
            randomAccessFile.writeInt(this.littleEndian(n2 / 8, 4, true));
            randomAccessFile.writeShort((short)this.littleEndian(4, 2, true));
            randomAccessFile.writeShort((short)this.littleEndian(16, 2, true));
            randomAccessFile.seek(40L);
            randomAccessFile.writeInt(this.littleEndian(n - 36, 4, true));
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public int getBitrate() {
        return this.impl == null ? this.Bitrate : this.impl.getBitrate();
    }

    public int getBits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[0] >>> 3;
        int n3 = (0xFF & byArray[n2]) << 24 | (0xFF & byArray[n2 + 1]) << 16 | (0xFF & byArray[n2 + 2]) << 8 | 0xFF & byArray[n2 + 3];
        n3 <<= nArray[0] & 7;
        nArray[0] = nArray[0] + n;
        return n3 >>>= 32 - n;
    }

    public int getChannel() {
        return this.impl == null ? this.Channel : this.impl.getChannel();
    }

    public int getCopyright() {
        return this.impl == null ? this.Copyright : this.impl.getCopyright();
    }

    public int getEmphasis() {
        return this.impl == null ? this.Emphasis : this.impl.getEmphasis();
    }

    public byte[] getExtraWaveHeader(int n, boolean bl) {
        return this.impl == null ? new byte[]{} : this.impl.getExtraWaveHeader(n, bl);
    }

    public double getFrameTimeLength() {
        return this.impl == null ? this.Time_length : this.impl.getFrameTimeLength();
    }

    public int getID() {
        return this.impl == null ? this.ID : this.impl.getID();
    }

    public int getLastBitrate() {
        return this.impl == null ? this.lBitrate : this.impl.getLastBitrate();
    }

    public int getLastChannel() {
        return this.impl == null ? this.lChannel : this.impl.getLastChannel();
    }

    public int getLastCopyright() {
        return this.impl == null ? this.lCopyright : this.impl.getLastCopyright();
    }

    public int getLastEmphasis() {
        return this.impl == null ? this.lEmphasis : this.impl.getLastEmphasis();
    }

    public double getLastFrameTimeLength() {
        return this.impl == null ? this.lTime_length : this.impl.getLastFrameTimeLength();
    }

    public int getLastID() {
        return this.impl == null ? this.lID : this.impl.getLastID();
    }

    public int getLastLayer() {
        return this.impl == null ? this.lLayer : this.impl.getLastLayer();
    }

    public int getLastMode() {
        return this.impl == null ? this.lMode : this.impl.getLastMode();
    }

    public int getLastModeExtension() {
        return this.impl == null ? this.lMode_extension : this.impl.getLastModeExtension();
    }

    public int getLastOriginal() {
        return this.impl == null ? this.lOriginal : this.impl.getLastOriginal();
    }

    public int getLastPaddingBit() {
        return this.impl == null ? this.lPadding_bit : this.impl.getLastPaddingBit();
    }

    public int getLastPrivateBit() {
        return this.impl == null ? this.lPrivate_bit : this.impl.getLastPrivateBit();
    }

    public int getLastProtectionBit() {
        return this.impl == null ? this.lProtection_bit : this.impl.getLastProtectionBit();
    }

    public int getLastSamplingFrequency() {
        return this.impl == null ? this.lSampling_frequency : this.impl.getLastSamplingFrequency();
    }

    public int getLastSize() {
        return this.impl == null ? this.lSize : this.impl.getLastSize();
    }

    public int getLastSizeBase() {
        return this.impl == null ? this.lSize_base : this.impl.getLastSizeBase();
    }

    public int getLayer() {
        return this.impl == null ? this.Layer : this.impl.getLayer();
    }

    public int getMode() {
        return this.impl == null ? this.Mode : this.impl.getMode();
    }

    public int getModeExtension() {
        return this.impl == null ? this.Mode_extension : this.impl.getModeExtension();
    }

    public int getNextBitrate() {
        return this.impl == null ? this.nBitrate : this.impl.getNextBitrate();
    }

    public int getNextChannel() {
        return this.impl == null ? this.nChannel : this.impl.getNextChannel();
    }

    public int getNextCopyright() {
        return this.impl == null ? this.nCopyright : this.impl.getNextCopyright();
    }

    public int getNextEmphasis() {
        return this.impl == null ? this.nEmphasis : this.impl.getNextEmphasis();
    }

    public double getNextFrameTimeLength() {
        return this.impl == null ? this.nTime_length : this.impl.getNextFrameTimeLength();
    }

    public int getNextID() {
        return this.impl == null ? this.nID : this.impl.getNextID();
    }

    public int getNextLayer() {
        return this.impl == null ? this.nLayer : this.impl.getNextLayer();
    }

    public int getNextMode() {
        return this.impl == null ? this.nMode : this.impl.getNextMode();
    }

    public int getNextModeExtension() {
        return this.impl == null ? this.nMode_extension : this.impl.getNextModeExtension();
    }

    public int getNextOriginal() {
        return this.impl == null ? this.nOriginal : this.impl.getNextOriginal();
    }

    public int getNextPaddingBit() {
        return this.impl == null ? this.nPadding_bit : this.impl.getNextPaddingBit();
    }

    public int getNextPrivateBit() {
        return this.impl == null ? this.nPrivate_bit : this.impl.getNextPrivateBit();
    }

    public int getNextProtectionBit() {
        return this.impl == null ? this.nProtection_bit : this.impl.getNextProtectionBit();
    }

    public int getNextSamplingFrequency() {
        return this.impl == null ? this.nSampling_frequency : this.impl.getNextSamplingFrequency();
    }

    public int getNextSize() {
        return this.impl == null ? this.nSize : this.impl.getNextSize();
    }

    public int getNextSizeBase() {
        return this.impl == null ? this.nSize_base : this.impl.getNextSizeBase();
    }

    public int getOriginal() {
        return this.impl == null ? this.Original : this.impl.getOriginal();
    }

    public int getPaddingBit() {
        return this.impl == null ? this.Padding_bit : this.impl.getPaddingBit();
    }

    public int getPrivateBit() {
        return this.impl == null ? this.Private_bit : this.impl.getPrivateBit();
    }

    public int getProtectionBit() {
        return this.impl == null ? this.Protection_bit : this.impl.getProtectionBit();
    }

    public byte[] getRiffHeader() {
        byte[] byArray = new byte[44];
        byArray[0] = 82;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 70;
        byArray[8] = 87;
        byArray[9] = 65;
        byArray[10] = 86;
        byArray[11] = 69;
        byArray[12] = 102;
        byArray[13] = 109;
        byArray[14] = 116;
        byArray[15] = 32;
        byArray[36] = 100;
        byArray[37] = 97;
        byArray[38] = 116;
        byArray[39] = 97;
        return byArray;
    }

    public int getSamplingFrequency() {
        return this.impl == null ? this.Sampling_frequency : this.impl.getSamplingFrequency();
    }

    public int getSize() {
        return this.impl == null ? this.Size : this.impl.getSize();
    }

    public int getSizeBase() {
        return this.impl == null ? this.Size_base : this.impl.getSizeBase();
    }

    public int getValue(byte[] byArray, int n, int n2, boolean bl) {
        return this.littleEndian(byArray, n, n2, bl);
    }

    public void init() {
        this.setINTEL(false);
        this.setID(0);
        this.setLayer(0);
        this.setProtectionBit(0);
        this.setPrivateBit(0);
        this.setBitrate(0);
        this.setSamplingFrequency(0);
        this.setPaddingBit(0);
        this.setPrivateBit(0);
        this.setMode(0);
        this.setModeExtension(0);
        this.setCopyright(0);
        this.setOriginal(0);
        this.setChannel(0);
        this.setEmphasis(0);
        this.setSize(0);
        this.setSizeBase(0);
        this.setFrameTimeLength(0.0);
    }

    public void initExtraWaveHeader(boolean bl, boolean bl2, boolean bl3) {
        if (this.impl != null) {
            this.impl.initExtraWaveHeader(bl, bl2, bl3);
        }
    }

    public boolean isINTEL() {
        return this.impl == null ? this.INTEL : this.impl.isINTEL();
    }

    public int littleEndian(int n, int n2) {
        return this.littleEndian(n, n2, this.isINTEL());
    }

    public int littleEndian(int n, int n2, boolean bl) {
        if (!bl) {
            return n;
        }
        if (n2 == 4) {
            return 0xFF & n >>> 24 | (0xFF & n >>> 16) << 8 | (0xFF & n >>> 8) << 16 | (0xFF & n) << 24;
        }
        return 0xFF & n >>> 8 | (0xFF & n) << 8;
    }

    public int littleEndian(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 |= bl ? (0xFF & byArray[n + n4]) << n4 * 8 : (0xFF & byArray[n + n4]) << (n2 - 1 - n4) * 8;
            ++n4;
        }
        return n3;
    }

    public int parseHeader(byte[] byArray, int n) {
        return this.impl == null ? 0 : this.impl.parseHeader(byArray, n);
    }

    public int parseHeader(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.impl != null) {
            int n4 = 0;
            while (n4 < n2) {
                n3 = this.parseHeader(byArray, n + n4);
                if (n3 < 0) {
                    // empty if block
                }
                ++n4;
            }
        }
        return n3;
    }

    public int parseNextHeader(byte[] byArray, int n) {
        return this.impl == null ? 0 : this.impl.parseNextHeader(byArray, n);
    }

    public void parseRiffData(byte[] byArray, int n) {
        if (this.impl != null) {
            this.impl.parseRiffData(byArray, n);
        }
    }

    public void removeCRC(byte[] byArray, boolean bl) {
        if (this.impl != null) {
            this.impl.removeCRC(byArray, bl);
        }
    }

    public String saveAndDisplayHeader() {
        this.saveHeader();
        return this.displayHeader();
    }

    public void saveHeader() {
        this.setLastID(this.getID());
        this.setLastLayer(this.getLayer());
        this.setLastProtectionBit(this.getProtectionBit());
        this.setLastPrivateBit(this.getPrivateBit());
        this.setLastBitrate(this.getBitrate());
        this.setLastSamplingFrequency(this.getSamplingFrequency());
        this.setLastPaddingBit(this.getPaddingBit());
        this.setLastPrivateBit(this.getPrivateBit());
        this.setLastMode(this.getMode());
        this.setLastModeExtension(this.getModeExtension());
        this.setLastCopyright(this.getCopyright());
        this.setLastOriginal(this.getOriginal());
        this.setLastChannel(this.getChannel());
        this.setLastEmphasis(this.getEmphasis());
        this.setLastSize(this.getSize());
        this.setLastSizeBase(this.getSizeBase());
        this.setLastFrameTimeLength(this.getFrameTimeLength());
    }

    public void setAncillaryDataDecoder(boolean bl, boolean bl2) {
        if (this.impl != null) {
            this.impl.setAncillaryDataDecoder(bl, bl2);
        }
    }

    public void setBitrate(int n) {
        if (this.impl != null) {
            this.impl.setBitrate(n);
        }
        this.Bitrate = n;
    }

    public void setChannel(int n) {
        if (this.impl != null) {
            this.impl.setChannel(n);
        }
        this.Channel = n;
    }

    public void setCopyright(int n) {
        if (this.impl != null) {
            this.impl.setCopyright(n);
        }
        this.Copyright = n;
    }

    public void setEmphasis(int n) {
        if (this.impl != null) {
            this.impl.setEmphasis(n);
        }
        this.Emphasis = n;
    }

    public void setExtraWaveData(int[] nArray, int n) {
        if (this.impl != null) {
            this.impl.setExtraWaveData(nArray, n);
        }
    }

    public void setExtraWaveLength(long l, long l2, int n) {
        if (this.impl != null) {
            this.impl.setExtraWaveLength(l, l2, n);
        }
    }

    public void setFrameTimeLength(double d) {
        if (this.impl != null) {
            this.impl.setFrameTimeLength(d);
        }
        this.Time_length = d;
    }

    public void setID(int n) {
        if (this.impl != null) {
            this.impl.setID(n);
        }
        this.ID = n;
    }

    public void setINTEL(boolean bl) {
        if (this.impl != null) {
            this.impl.setINTEL(bl);
        }
        this.INTEL = bl;
    }

    public void setLastBitrate(int n) {
        if (this.impl != null) {
            this.impl.setLastBitrate(n);
        }
        this.lBitrate = n;
    }

    public void setLastChannel(int n) {
        if (this.impl != null) {
            this.impl.setLastChannel(n);
        }
        this.lChannel = n;
    }

    public void setLastCopyright(int n) {
        if (this.impl != null) {
            this.impl.setLastCopyright(n);
        }
        this.lCopyright = n;
    }

    public void setLastEmphasis(int n) {
        if (this.impl != null) {
            this.impl.setLastEmphasis(n);
        }
        this.lEmphasis = n;
    }

    public void setLastFrameTimeLength(double d) {
        if (this.impl != null) {
            this.impl.setLastFrameTimeLength(d);
        }
        this.lTime_length = d;
    }

    public void setLastID(int n) {
        if (this.impl != null) {
            this.impl.setLastID(n);
        }
        this.lID = n;
    }

    public void setLastLayer(int n) {
        if (this.impl != null) {
            this.impl.setLastLayer(n);
        }
        this.lLayer = n;
    }

    public void setLastMode(int n) {
        if (this.impl != null) {
            this.impl.setLastMode(n);
        }
        this.lMode = n;
    }

    public void setLastModeExtension(int n) {
        if (this.impl != null) {
            this.impl.setLastModeExtension(n);
        }
        this.lMode_extension = n;
    }

    public void setLastOriginal(int n) {
        if (this.impl != null) {
            this.impl.setLastOriginal(n);
        }
        this.lOriginal = n;
    }

    public void setLastPaddingBit(int n) {
        if (this.impl != null) {
            this.impl.setLastPaddingBit(n);
        }
        this.lPadding_bit = n;
    }

    public void setLastPrivateBit(int n) {
        if (this.impl != null) {
            this.impl.setLastPrivateBit(n);
        }
        this.lPrivate_bit = n;
    }

    public void setLastProtectionBit(int n) {
        if (this.impl != null) {
            this.impl.setLastProtectionBit(n);
        }
        this.lProtection_bit = n;
    }

    public void setLastSamplingFrequency(int n) {
        if (this.impl != null) {
            this.impl.setLastSamplingFrequency(n);
        }
        this.lSampling_frequency = n;
    }

    public void setLastSize(int n) {
        if (this.impl != null) {
            this.impl.setLastSize(n);
        }
        this.lSize = n;
    }

    public void setLastSizeBase(int n) {
        if (this.impl != null) {
            this.impl.setLastSizeBase(n);
        }
        this.lSize_base = n;
    }

    public void setLayer(int n) {
        if (this.impl != null) {
            this.impl.setLayer(n);
        }
        this.Layer = n;
    }

    public void setMode(int n) {
        if (this.impl != null) {
            this.impl.setMode(n);
        }
        this.Mode = n;
    }

    public void setModeExtension(int n) {
        if (this.impl != null) {
            this.impl.setModeExtension(n);
        }
        this.Mode_extension = n;
    }

    public void setNewType(int n) {
        switch (n) {
            case 6: {
                this.impl = new AudioFormatDTS();
                break;
            }
            case 0: {
                this.impl = new AudioFormatAC3();
                break;
            }
            case 4: {
                this.impl = new AudioFormatLPCM();
                break;
            }
            case 7: {
                this.impl = new AudioFormatWAV();
                break;
            }
            case 2: {
                this.impl = new AudioFormatMPA();
                break;
            }
            case 8: {
                this.impl = new AudioFormatAAC();
                break;
            }
        }
    }

    public void setNextBitrate(int n) {
        if (this.impl != null) {
            this.impl.setNextBitrate(n);
        }
        this.nBitrate = n;
    }

    public void setNextChannel(int n) {
        if (this.impl != null) {
            this.impl.setNextChannel(n);
        }
        this.nChannel = n;
    }

    public void setNextCopyright(int n) {
        if (this.impl != null) {
            this.impl.setNextCopyright(n);
        }
        this.nCopyright = n;
    }

    public void setNextEmphasis(int n) {
        if (this.impl != null) {
            this.impl.setNextEmphasis(n);
        }
        this.nEmphasis = n;
    }

    public void setNextFrameTimeLength(double d) {
        if (this.impl != null) {
            this.impl.setNextFrameTimeLength(d);
        }
        this.nTime_length = d;
    }

    public void setNextID(int n) {
        if (this.impl != null) {
            this.impl.setNextID(n);
        }
        this.nID = n;
    }

    public void setNextLayer(int n) {
        if (this.impl != null) {
            this.impl.setNextLayer(n);
        }
        this.nLayer = n;
    }

    public void setNextMode(int n) {
        if (this.impl != null) {
            this.impl.setNextMode(n);
        }
        this.nMode = n;
    }

    public void setNextModeExtension(int n) {
        if (this.impl != null) {
            this.impl.setNextModeExtension(n);
        }
        this.nMode_extension = n;
    }

    public void setNextOriginal(int n) {
        if (this.impl != null) {
            this.impl.setNextOriginal(n);
        }
        this.nOriginal = n;
    }

    public void setNextPaddingBit(int n) {
        if (this.impl != null) {
            this.impl.setNextPaddingBit(n);
        }
        this.nPadding_bit = n;
    }

    public void setNextPrivateBit(int n) {
        if (this.impl != null) {
            this.impl.setNextPrivateBit(n);
        }
        this.nPrivate_bit = n;
    }

    public void setNextProtectionBit(int n) {
        if (this.impl != null) {
            this.impl.setNextProtectionBit(n);
        }
        this.nProtection_bit = n;
    }

    public void setNextSamplingFrequency(int n) {
        if (this.impl != null) {
            this.impl.setNextSamplingFrequency(n);
        }
        this.nSampling_frequency = n;
    }

    public void setNextSize(int n) {
        if (this.impl != null) {
            this.impl.setNextSize(n);
        }
        this.nSize = n;
    }

    public void setNextSizeBase(int n) {
        if (this.impl != null) {
            this.impl.setNextSizeBase(n);
        }
        this.nSize_base = n;
    }

    public void setOriginal(int n) {
        if (this.impl != null) {
            this.impl.setOriginal(n);
        }
        this.Original = n;
    }

    public void setPaddingBit(int n) {
        if (this.impl != null) {
            this.impl.setPaddingBit(n);
        }
        this.Padding_bit = n;
    }

    public void setPrivateBit(int n) {
        if (this.impl != null) {
            this.impl.setPrivateBit(n);
        }
        this.Private_bit = n;
    }

    public void setProtectionBit(int n) {
        if (this.impl != null) {
            this.impl.setProtectionBit(n);
        }
        this.Protection_bit = n;
    }

    public void setSamplingFrequency(int n) {
        if (this.impl != null) {
            this.impl.setSamplingFrequency(n);
        }
        this.Sampling_frequency = n;
    }

    public void setSize(int n) {
        if (this.impl != null) {
            this.impl.setSize(n);
        }
        this.Size = n;
    }

    public void setSizeBase(int n) {
        if (this.impl != null) {
            this.setSizeBase(n);
        }
        this.Size_base = n;
    }

    public void setValue(byte[] byArray, int n, int n2, boolean bl, int n3) {
        int n4 = 0;
        while (bl && n4 < n2) {
            byArray[n4 + n] = (byte)(0xFF & n3 >>> n4 * 8);
            ++n4;
        }
        int n5 = 0;
        int n6 = n2 - 1;
        while (!bl && n5 < n2) {
            byArray[n5 + n] = (byte)(0xFF & n3 >>> n6 * 8);
            ++n5;
            --n6;
        }
    }

    public int validateCRC(byte[] byArray, int n, int n2) {
        return this.impl == null ? 0 : this.impl.validateCRC(byArray, n, n2);
    }
}

