/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.common.Settings;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class JobCollection {
    private List cut_points = null;
    private List chapter_points = null;
    private List input_files = null;
    private List predefined_IDs = null;
    private String output_directory = null;
    private String output_name = null;
    private String normalLog = null;
    private String file_separator = System.getProperty("file.separator");
    private String line_separator = System.getProperty("line.separator");
    private boolean debug = false;
    private boolean progress_status = false;
    private int primaryInputFileSegments = 0;
    private int action_type = -1;
    private PrintStream logging;
    private JobProcessing job_processing;
    private Hashtable cut_images;
    private Settings settings;

    private JobCollection() {
    }

    public JobCollection(String string) {
        this.cut_points = new ArrayList();
        this.chapter_points = new ArrayList();
        this.input_files = new ArrayList();
        this.predefined_IDs = new ArrayList();
        this.init(string, "", this.action_type);
    }

    public JobCollection(String string, String string2, int n, List list, List list2, List list3, List list4) {
        this.cut_points = this.copyListElements(list);
        this.chapter_points = this.copyListElements(list2);
        this.input_files = this.copyListElements(list3);
        this.predefined_IDs = this.copyListElements(list4);
        this.init(string, string2, n);
    }

    public boolean DebugMode() {
        return this.debug;
    }

    public void addChapterpoint(int n, Object object) {
        this.chapter_points.add(n, object);
    }

    public void addChapterpoint(Object object) {
        if (!this.chapter_points.contains(object)) {
            this.chapter_points.add(object);
        }
    }

    public void addChapterpoint(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.addChapterpoint(objectArray[n]);
            ++n;
        }
    }

    public void addCutpoint(int n, Object object) {
        this.cut_points.add(n, object);
    }

    public void addCutpoint(Object object) {
        if (!this.cut_points.contains(object)) {
            this.cut_points.add(object);
        }
    }

    public void addCutpoint(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.addCutpoint(objectArray[n]);
            ++n;
        }
    }

    public void addInputFile(int n, Object object) {
        if (this.isActive()) {
            return;
        }
        if (n < 0) {
            n = this.input_files.size();
        }
        XInputFile xInputFile = ((XInputFile)object).getNewInstance();
        xInputFile.setFileID(Common.getNewFileID());
        this.input_files.add(n, xInputFile);
        this.determinePrimaryFileSegments();
    }

    public void addInputFile(Object object) {
        this.addInputFile(-1, object);
    }

    public void addInputFile(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.addInputFile(objectArray[n]);
            ++n;
        }
    }

    public void addPID(Object object) {
        if (!this.predefined_IDs.contains(object)) {
            this.predefined_IDs.add(object);
        }
    }

    public void addPID(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.addPID(objectArray[n]);
            ++n;
        }
    }

    public String checkOutputDirectory() {
        String string = this.output_directory;
        if (string == null || string.length() == 0 || string.startsWith("[res]")) {
            if (this.input_files.size() == 0) {
                return "";
            }
            string = new File(this.input_files.get(0).toString()).getParent();
        }
        if (this.checkWriteAccess(string)) {
            this.output_directory = string;
            return null;
        }
        return string;
    }

    private boolean checkWriteAccess(String string) {
        try {
            File file = new File(string);
            String string2 = String.valueOf(string) + this.getFileSeparator() + "~$pjx$.tmp";
            if (string == null || !file.exists()) {
                return false;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
            randomAccessFile.close();
            new File(string2).delete();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void clearChapterpoints() {
        this.chapter_points.clear();
    }

    public void clearCutpoints() {
        this.cut_points.clear();
    }

    public void clearPIDs() {
        this.predefined_IDs.clear();
    }

    public void closeDebugLogStream() {
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog)) {
            return;
        }
        if (this.logging != null) {
            this.logging.flush();
            this.logging.close();
        }
        this.debug = false;
    }

    public void closeNormalLogStream(String string) {
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_NormalLog)) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.normalLog));
            printWriter.print(string);
            printWriter.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    private List copyListElements(List list) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < list.size()) {
            arrayList.add(list.get(n));
            ++n;
        }
        return arrayList;
    }

    public void determinePrimaryFileSegments() {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.getInputFilesCount();
        while (n2 < n5) {
            XInputFile xInputFile = (XInputFile)this.getInputFile(n2);
            if (xInputFile.getStreamInfo() == null) {
                Common.getScanClass().getStreamInfo(xInputFile);
            }
            if (!bl) {
                n4 = xInputFile.getStreamInfo().getStreamType();
                switch (n4) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (n3 != -1 && n3 != n4) {
                            bl = true;
                            break;
                        }
                        n3 = n4;
                        ++n;
                    }
                }
            }
            ++n2;
        }
        this.setPrimaryInputFileSegments(n);
    }

    public void finishProcessing() {
        this.progress_status = false;
        if (this.job_processing != null) {
            this.job_processing.finishProcessing();
            this.setOutputDirectory(this.job_processing.getSavedOutputDirectory());
        }
        this.job_processing = null;
    }

    public int getActionType() {
        return this.action_type;
    }

    public long getAllSizes() {
        long l = 0L;
        int n = 0;
        int n2 = this.getInputFilesCount();
        while (n < n2) {
            l += ((XInputFile)this.getInputFile(n)).length();
            ++n;
        }
        return l / 0x100000L;
    }

    public int getChapterpointCount() {
        return this.chapter_points.size();
    }

    public List getChapterpointList() {
        return this.chapter_points;
    }

    public Object[] getChapterpoints() {
        return this.chapter_points.toArray();
    }

    public Object[][] getCollectionAsTable() {
        int n = this.getInputFilesCount();
        Object[][] objectArray = new Object[n > 10 ? n : 10][12];
        int n2 = 0;
        while (n2 < n) {
            XInputFile xInputFile = (XInputFile)this.getInputFile(n2);
            objectArray[n2][0] = xInputFile.getFileID();
            objectArray[n2][1] = xInputFile.getStreamInfo().getFileSourceBase();
            objectArray[n2][2] = n2 < this.getPrimaryInputFileSegments() ? new Integer(n2) : new Integer(-n2);
            objectArray[n2][3] = xInputFile.getName();
            objectArray[n2][4] = xInputFile.getParent().length() > 0 ? xInputFile.getParent() : xInputFile.toString().substring(0, xInputFile.toString().indexOf(xInputFile.getName()));
            objectArray[n2][5] = String.valueOf(String.valueOf(xInputFile.length() / 0x100000L)) + " MB";
            objectArray[n2][6] = Common.formatTime_3(xInputFile.lastModified());
            objectArray[n2][7] = new Integer(xInputFile.getStreamInfo().getVideoStreams().length);
            objectArray[n2][8] = new Integer(xInputFile.getStreamInfo().getAudioStreams().length);
            objectArray[n2][9] = new Integer(xInputFile.getStreamInfo().getTeletextStreams().length);
            objectArray[n2][10] = new Integer(xInputFile.getStreamInfo().getSubpictureStreams().length);
            objectArray[n2][11] = xInputFile.getStreamInfo().getFileType();
            ++n2;
        }
        return objectArray;
    }

    public int[] getCutImage(Object object) {
        if (object != null && this.cut_images.containsKey(object)) {
            return (int[])this.cut_images.get(object);
        }
        return null;
    }

    public int getCutpointCount() {
        return this.cut_points.size();
    }

    public List getCutpointList() {
        return this.cut_points;
    }

    public Object[] getCutpoints() {
        return this.cut_points.toArray();
    }

    public String getFileSeparator() {
        return this.file_separator;
    }

    public String getFirstFileBase() {
        return String.valueOf(this.getOutputDirectory()) + this.getFirstFileName();
    }

    public long getFirstFileDate() {
        return ((XInputFile)this.getInputFiles()[0]).lastModified();
    }

    public String getFirstFileName() {
        String string = new File(this.getInputFiles()[0].toString()).getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public Object getInputFile(int n) {
        return this.input_files.get(n);
    }

    public Object[] getInputFiles() {
        return this.input_files.toArray();
    }

    public List getInputFilesAsList() {
        return this.input_files;
    }

    public int getInputFilesCount() {
        return this.input_files.size();
    }

    public JobProcessing getJobProcessing() {
        return this.job_processing;
    }

    public JobCollection getNewInstance() {
        return new JobCollection(this.output_directory, this.output_name, this.action_type, this.cut_points, this.chapter_points, this.input_files, this.predefined_IDs);
    }

    public String getOutputDirectory() {
        return this.output_directory;
    }

    public String getOutputName() {
        return this.output_name;
    }

    public String getOutputName(String string) {
        if (this.output_name.length() > 0) {
            return this.getOutputName();
        }
        return string;
    }

    public String getOutputNameParent(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return String.valueOf(this.getOutputDirectory()) + this.getFileSeparator() + string;
        }
        return String.valueOf(this.getOutputDirectory()) + this.getFileSeparator() + string.substring(0, n);
    }

    public int getPIDCount() {
        return this.predefined_IDs.size();
    }

    public Object[] getPIDs() {
        return this.predefined_IDs.toArray();
    }

    public int[] getPIDsAsInteger() {
        int n = this.predefined_IDs == null ? 0 : this.predefined_IDs.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Integer.parseInt(this.predefined_IDs.get(n2).toString().substring(2), 16);
            ++n2;
        }
        return nArray;
    }

    public int getPrimaryInputFileSegments() {
        return this.primaryInputFileSegments;
    }

    public int getSecondaryInputFileSegments() {
        return this.getInputFilesCount() - this.getPrimaryInputFileSegments();
    }

    public Settings getSettings() {
        if (this.settings == null) {
            return Common.getSettings();
        }
        return this.settings;
    }

    public String getShortSummary() {
        String string = this.isActive() ? Resource.getString("JobCollection.InProgress") : Resource.getString("JobCollection.Idle");
        string = String.valueOf(string) + this.line_separator;
        string = String.valueOf(string) + Resource.getString("JobCollection.Action") + " " + (this.getActionType() < 0 ? Resource.getString("JobCollection.unspecified") : Keys.ITEMS_ConversionMode[this.getActionType()].toString());
        string = String.valueOf(string) + this.line_separator;
        string = String.valueOf(string) + Resource.getString("JobCollection.PrimaryFileSegments") + " " + this.getPrimaryInputFileSegments();
        string = String.valueOf(string) + this.line_separator;
        string = String.valueOf(string) + Resource.getString("JobCollection.SecondaryFiles") + " " + this.getSecondaryInputFileSegments();
        string = String.valueOf(string) + this.line_separator;
        string = String.valueOf(string) + Resource.getString("JobCollection.Cutpoints") + " " + this.getCutpointCount();
        string = String.valueOf(string) + this.line_separator;
        string = String.valueOf(string) + Resource.getString("JobCollection.Chapters") + " " + this.getChapterpointCount();
        string = String.valueOf(string) + this.line_separator;
        string = String.valueOf(string) + Resource.getString("JobCollection.PidSelection") + " " + this.getPIDCount();
        string = String.valueOf(string) + this.line_separator;
        string = String.valueOf(string) + Resource.getString("JobCollection.OwnSettings") + " " + (this.settings != null ? Resource.getString("General.Yes") : Resource.getString("General.No"));
        string = String.valueOf(string) + this.line_separator;
        string = String.valueOf(string) + Resource.getString("JobCollection.AllSize") + " " + this.getAllSizes() + "MB";
        return string;
    }

    public boolean hasSettings() {
        return this.settings != null;
    }

    private void init(String string, String string2, int n) {
        this.setOutputDirectory(string);
        this.setOutputName(string2);
        this.normalLog = "";
        this.action_type = n;
        this.cut_images = new Hashtable();
    }

    public boolean isActive() {
        return this.progress_status;
    }

    public Object removeChapterpoint(int n) {
        if (n < 0 || n >= this.chapter_points.size()) {
            return null;
        }
        Object e = this.chapter_points.remove(n);
        return e;
    }

    public int[] removeCutImage(Object object) {
        if (this.cut_images.containsKey(object)) {
            return (int[])this.cut_images.remove(object);
        }
        return null;
    }

    public Object removeCutpoint(int n) {
        if (n < 0 || n >= this.cut_points.size()) {
            return null;
        }
        Object e = this.cut_points.remove(n);
        this.removeCutImage(e);
        return e;
    }

    public Object removeInputFile(int n) {
        if (this.isActive()) {
            return null;
        }
        if (n < 0 || n >= this.getInputFilesCount()) {
            return null;
        }
        Object e = this.input_files.remove(n);
        this.determinePrimaryFileSegments();
        return e;
    }

    public Object[] removeInputFile(int[] nArray) {
        if (this.isActive()) {
            return null;
        }
        Object[] objectArray = new Object[nArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            objectArray[n] = this.removeInputFile(nArray[n]);
            --n;
        }
        return objectArray;
    }

    public void removePID(Object object) {
        int n = this.predefined_IDs.indexOf(object);
        if (n < 0) {
            return;
        }
        this.predefined_IDs.remove(n);
    }

    public void removePID(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.removePID(objectArray[n]);
            ++n;
        }
    }

    public void setActionType(int n) {
        this.action_type = n;
    }

    public void setCutImage(String string, int[] nArray) {
        this.cut_images.put(string, nArray);
    }

    private void setDebugLogStream(String string) {
        try {
            this.logging = new PrintStream(new FileOutputStream(string));
            System.setOut(this.logging);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void setLogFiles() {
        String string = this.getOutputName(this.getFirstFileName());
        if (Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog)) {
            this.debug = true;
            this.setDebugLogStream(String.valueOf(this.getOutputDirectory()) + this.getFileSeparator() + string + "_biglog.txt");
        }
        if (Common.getSettings().getBooleanProperty(Keys.KEY_NormalLog)) {
            this.normalLog = Common.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createVdrIndex) && Common.getSettings().getIntProperty(Keys.KEY_ConversionMode) == 1 ? String.valueOf(this.getOutputDirectory()) + this.getFileSeparator() + "summary.vdr" : String.valueOf(this.getOutputDirectory()) + this.getFileSeparator() + string + "_log.txt";
        }
    }

    public void setOutputDirectory(String string) {
        this.output_directory = string.endsWith(this.getFileSeparator()) ? string.substring(0, string.length() - 1) : string;
    }

    public void setOutputName(String string) {
        this.output_name = string;
    }

    public void setPrimaryInputFileSegments(int n) {
        this.primaryInputFileSegments = n;
    }

    public void setSettings(Settings settings) {
        if (this.isActive()) {
            return;
        }
        if (settings == null) {
            this.settings = null;
            return;
        }
        this.settings = new Settings();
        try {
            this.settings.loadProperties(new ByteArrayInputStream(settings.storeProperties()));
        }
        catch (IOException iOException) {
            this.settings = null;
            Common.setExceptionMessage(iOException);
        }
    }

    public void startProcessing(boolean bl) {
        this.progress_status = true;
        this.job_processing = new JobProcessing(this, bl, this.getOutputDirectory());
    }
}

