/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class ScanView
extends JPanel {
    private final int Top = 20;
    private final int Bottom = 184;
    private int[] image_data;
    private int width = 160;
    private int height = 90;
    private boolean matchingPoint = false;
    private boolean cut_top = true;
    private boolean cut_bottom = false;
    private boolean cut_match = false;
    private String string_bottom = "Next:";
    private String string_top = "Prev:";
    private String string_matchingpoint = "";
    private String[] string_in_out = new String[]{" -IN- ", " -OUT- "};
    private Image image_top;
    private Image image_bottom;
    private MemoryImageSource source_top;
    private MemoryImageSource source_bottom;
    private final Color BackgroundColor;
    private final Color RedColor;
    private final Font font;

    public ScanView() {
        this.image_data = new int[this.width * this.height];
        this.source_top = new MemoryImageSource(this.width, this.height, this.image_data, 0, this.width);
        this.source_top.setAnimated(true);
        this.image_top = this.createImage(this.source_top);
        this.source_bottom = new MemoryImageSource(this.width, this.height, this.image_data, 0, this.width);
        this.source_bottom.setAnimated(true);
        this.image_bottom = this.createImage(this.source_bottom);
        this.BackgroundColor = new Color(0, 35, 110);
        this.RedColor = new Color(255, 100, 100);
        this.font = new Font("Tahoma", 0, 14);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildScanViewPanel(), "South");
        this.setBackground(Color.black);
        this.setVisible(true);
    }

    protected JPanel buildScanViewPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JSlider jSlider = new JSlider();
        jSlider.setMaximum(100);
        jSlider.setMajorTickSpacing(10);
        jSlider.setMinorTickSpacing(1);
        jSlider.setPaintTicks(true);
        jSlider.setValue(50);
        jPanel.add((Component)jSlider, "South");
        return jPanel;
    }

    public void clearView(int n) {
        Arrays.fill(this.image_data, -11513776);
        this.updateView(n);
    }

    public void clearViews() {
        this.matchingPoint = false;
        this.clearView(20);
        this.clearView(184);
    }

    public int getBottom() {
        return 184;
    }

    public int getTop() {
        return 20;
    }

    public void paint2(Graphics graphics) {
        graphics.setColor(this.BackgroundColor);
        graphics.fillRect(0, 0, 900, 90);
    }

    public void setImage(int[] nArray, Object[] objectArray, int n, int n2) {
        if (nArray == null) {
            this.clearView(n2);
            return;
        }
        System.arraycopy(nArray, 0, this.image_data, 0, nArray.length);
        this.updateView(n2, objectArray, n);
    }

    public void setMatchingPoint(boolean bl, Object[] objectArray, int n) {
        this.matchingPoint = bl;
        this.string_matchingpoint = this.matchingPoint ? "This: #" + n + " @ " + objectArray[n] + this.string_in_out[n & 1] : "";
        this.cut_match = (n & 1) == 0;
    }

    public void updateView(int n) {
        this.updateView(n, null, -1);
    }

    public void updateView(int n, Object[] objectArray, int n2) {
        if (n < 100) {
            this.source_top.newPixels();
            this.string_top = "Prev: " + (objectArray != null ? "#" + n2 + " @ " + objectArray[n2] + this.string_in_out[n2 & 1] : "= Collection Begin");
            this.cut_top = objectArray != null ? (n2 & 1) == 0 : (!this.matchingPoint ? this.cut_bottom ^ true : false);
        } else {
            this.source_bottom.newPixels();
            this.string_bottom = "Next: " + (objectArray != null ? "#" + n2 + " @ " + objectArray[n2] + this.string_in_out[n2 & 1] : "= Collection End");
            this.cut_bottom = objectArray != null ? (n2 & 1) == 0 : false;
        }
        this.repaint();
    }
}

