/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.dvb.projectx.subtitle.Bitmap;

public class BMP {
    private static final byte[] defaultHeader;
    private static Hashtable bmps;

    static {
        byte[] byArray = new byte[54];
        byArray[0] = 66;
        byArray[1] = 77;
        byArray[10] = 54;
        byArray[14] = 40;
        byArray[26] = 1;
        byArray[28] = 24;
        byArray[38] = -120;
        byArray[39] = 11;
        byArray[42] = -120;
        byArray[43] = 11;
        defaultHeader = byArray;
        bmps = new Hashtable();
    }

    private BMP() {
    }

    public static void buildBMP_24bit(String string, String string2) throws IOException {
        int n;
        Bitmap bitmap = (Bitmap)bmps.get(string2);
        if (bitmap == null) {
            return;
        }
        int n2 = bitmap.getWidth();
        int n3 = 3 * n2 * (n = bitmap.getHeight()) + n * (n2 & 3);
        if (n3 == 0) {
            return;
        }
        int[] nArray = bitmap.getPixel();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(String.valueOf(string) + ".bmp"), 65535);
        byte[] byArray = new byte[defaultHeader.length];
        System.arraycopy(defaultHeader, 0, byArray, 0, defaultHeader.length);
        byte[] byArray2 = new byte[3];
        BMP.littleEndian(byArray, 2, 54 + n3);
        BMP.littleEndian(byArray, 18, n2);
        BMP.littleEndian(byArray, 22, n);
        BMP.littleEndian(byArray, 34, n3);
        bufferedOutputStream.write(byArray);
        int n4 = n - 1;
        while (n4 >= 0) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < 3) {
                    byArray2[n6] = (byte)(nArray[n5 + n4 * n2] >> n6 * 8 & 0xFF);
                    ++n6;
                }
                bufferedOutputStream.write(byArray2);
                ++n5;
            }
            bufferedOutputStream.write(new byte[n2 & 3]);
            --n4;
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    public static String buildBMP_palettized(String string, String string2, ArrayList arrayList, int n) throws IOException {
        return BMP.buildBMP_palettized(string, (Bitmap)bmps.get(string2), arrayList, n);
    }

    public static String buildBMP_palettized(String string, Bitmap bitmap, ArrayList arrayList, int n) throws IOException {
        int n2;
        if (bitmap == null) {
            return "";
        }
        n = 256;
        int n3 = bitmap.getWidth();
        int n4 = n * 4 + n3 * (n2 = bitmap.getHeight()) + n2 * (n3 & 3);
        if (n4 == 0) {
            return "";
        }
        string = String.valueOf(string) + ".bmp";
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 65535);
        byte[] byArray = new byte[defaultHeader.length];
        System.arraycopy(defaultHeader, 0, byArray, 0, defaultHeader.length);
        boolean bl = false;
        byArray[28] = n == 256 ? 8 : 4;
        BMP.littleEndian(byArray, 2, 54 + n4);
        BMP.littleEndian(byArray, 10, 54 + n * 4);
        BMP.littleEndian(byArray, 18, n3);
        BMP.littleEndian(byArray, 22, n2);
        BMP.littleEndian(byArray, 34, n4);
        bufferedOutputStream.write(byArray);
        Object[] objectArray = arrayList.toArray();
        byte[] byArray2 = new byte[4];
        int n5 = 0;
        while (n5 < n) {
            if (n5 < objectArray.length) {
                int n6 = 0xFFFFFF & Integer.parseInt(objectArray[n5].toString());
                int n7 = 0;
                while (n7 < 3) {
                    byArray2[n7] = (byte)(0xFF & n6 >> (n7 << 3));
                    ++n7;
                }
            }
            bufferedOutputStream.write(byArray2);
            ++n5;
        }
        objectArray = null;
        int[] nArray = bitmap.getPixel();
        int n8 = n2 - 1;
        while (n8 >= 0) {
            int n9 = 0;
            boolean bl2 = false;
            while (n9 < n3) {
                bufferedOutputStream.write(0xFF & BMP.getColorIndex(nArray[n9 + n8 * n3], arrayList));
                ++n9;
            }
            bufferedOutputStream.write(new byte[n3 & 3]);
            --n8;
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return string;
    }

    public static void clear() {
        bmps.clear();
    }

    public static Bitmap getBitmap(int n) {
        return (Bitmap)bmps.get(String.valueOf(n));
    }

    private static int getColorIndex(int n, ArrayList arrayList) {
        String string = String.valueOf(n);
        int n2 = arrayList.indexOf(string);
        if (n2 != -1) {
            return n2;
        }
        return arrayList.size() - 1;
    }

    public static String getContents() {
        return bmps.toString();
    }

    public static Enumeration getKeys() {
        return bmps.keys();
    }

    public static boolean isEmpty() {
        return bmps.isEmpty();
    }

    private static void littleEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            byArray[n + n3] = (byte)(n2 >> n3 * 8 & 0xFF);
            ++n3;
        }
    }

    public static void savePixels(Bitmap bitmap) {
        bmps.put(String.valueOf(bitmap.getId()), bitmap);
    }

    public static String write_ColorTable(String string, ArrayList arrayList, int n) throws IOException {
        Object[] objectArray = arrayList.toArray();
        byte[] byArray = new byte[4];
        string = String.valueOf(string) + ".spf";
        n = 256;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 65535);
        int n2 = 0;
        while (n2 < n) {
            if (n2 < objectArray.length) {
                int n3 = 0xFFFFFF & Integer.parseInt(objectArray[n2].toString());
                int n4 = 0;
                while (n4 < 3) {
                    byArray[n4] = (byte)(0xFF & n3 >> (n4 << 3));
                    ++n4;
                }
            }
            bufferedOutputStream.write(byArray);
            ++n2;
        }
        objectArray = null;
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        return string;
    }
}

