/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.parser.RegexFTPFileEntryParserImpl;

public class VMSFTPEntryParser
extends RegexFTPFileEntryParserImpl {
    private static final String MONTHS = "(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)";
    private static final String REGEX = "(.*;[0-9]+)\\s*(\\d+)/\\d+\\s*(\\d{1,2})-(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)-([0-9]{4})\\s*((?:[01]\\d)|(?:2[0-3])):([012345]\\d):([012345]\\d)\\s*\\[(([0-9$A-Za-z_]+)|([0-9$A-Za-z_]+),([0-9$a-zA-Z_]+))\\]?\\s*\\([a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*\\)";

    public VMSFTPEntryParser() {
        super(REGEX);
    }

    protected boolean isVersioning() {
        return false;
    }

    public FTPFile parseFTPEntry(String string) {
        long l = 512L;
        if (this.matches(string)) {
            String string2;
            String string3;
            FTPFile fTPFile = new FTPFile();
            fTPFile.setRawListing(string);
            String string4 = this.group(1);
            String string5 = this.group(2);
            String string6 = this.group(3);
            String string7 = this.group(4);
            String string8 = this.group(5);
            String string9 = this.group(6);
            String string10 = this.group(7);
            String string11 = this.group(8);
            String string12 = this.group(9);
            StringTokenizer stringTokenizer = new StringTokenizer(string12, ",");
            switch (stringTokenizer.countTokens()) {
                case 1: {
                    string3 = null;
                    string2 = stringTokenizer.nextToken();
                    break;
                }
                case 2: {
                    string3 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    break;
                }
                default: {
                    string3 = null;
                    string2 = null;
                }
            }
            if (string4.lastIndexOf(".DIR") != -1) {
                fTPFile.setType(1);
            } else {
                fTPFile.setType(0);
            }
            if (this.isVersioning()) {
                fTPFile.setName(string4);
            } else {
                string4 = string4.substring(0, string4.lastIndexOf(";"));
                fTPFile.setName(string4);
            }
            long l2 = Long.parseLong(string5) * l;
            fTPFile.setSize(l2);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.set(5, new Integer(string6));
            calendar.set(2, MONTHS.indexOf(string7) / 4);
            calendar.set(1, new Integer(string8));
            calendar.set(11, new Integer(string9));
            calendar.set(12, new Integer(string10));
            calendar.set(13, new Integer(string11));
            calendar.set(14, 0);
            fTPFile.setTimestamp(calendar);
            fTPFile.setGroup(string3);
            fTPFile.setUser(string2);
            return fTPFile;
        }
        return null;
    }

    public FTPFile[] parseFileList(InputStream inputStream) throws IOException {
        FTPListParseEngine fTPListParseEngine = new FTPListParseEngine(this);
        fTPListParseEngine.readServerList(inputStream);
        return fTPListParseEngine.getFiles();
    }

    public String readNextEntry(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        StringBuffer stringBuffer = new StringBuffer();
        while (string != null) {
            if (string.startsWith("Directory") || string.startsWith("Total")) {
                string = bufferedReader.readLine();
                continue;
            }
            stringBuffer.append(string);
            if (string.trim().endsWith(")")) break;
            string = bufferedReader.readLine();
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }
}

