/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.nntp;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.net.nntp.Threadable;

public class Article
implements Threadable {
    private int articleNumber;
    private String subject;
    private String date;
    private String articleId;
    private String simplifiedSubject;
    private String from;
    private StringBuffer header = new StringBuffer();
    private StringBuffer references;
    private boolean isReply = false;
    public Article kid;
    public Article next;

    public void addHeaderField(String string, String string2) {
        this.header.append(string);
        this.header.append(": ");
        this.header.append(string2);
        this.header.append('\n');
    }

    public void addReference(String string) {
        if (this.references == null) {
            this.references = new StringBuffer();
            this.references.append("References: ");
        }
        this.references.append(string);
        this.references.append("\t");
    }

    private void flushSubjectCache() {
        this.simplifiedSubject = null;
    }

    public String getArticleId() {
        return this.articleId;
    }

    public int getArticleNumber() {
        return this.articleNumber;
    }

    public String getDate() {
        return this.date;
    }

    public String getFrom() {
        return this.from;
    }

    public String[] getReferences() {
        if (this.references == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.references.toString().indexOf(":");
        StringTokenizer stringTokenizer = new StringTokenizer(this.references.substring(n), "\t");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return (String[])arrayList.toArray();
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean isDummy() {
        return this.getSubject() == null;
    }

    public Threadable makeDummy() {
        return new Article();
    }

    public String messageThreadId() {
        return this.articleId;
    }

    public String[] messageThreadReferences() {
        return this.getReferences();
    }

    public static void printThread(Article article, int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("==>");
            ++n2;
        }
        System.out.println(String.valueOf(article.getSubject()) + "\t" + article.getFrom());
        if (article.kid != null) {
            Article.printThread(article.kid, n + 1);
        }
        if (article.next != null) {
            Article.printThread(article.next, n);
        }
    }

    public void setArticleId(String string) {
        this.articleId = string;
    }

    public void setArticleNumber(int n) {
        this.articleNumber = n;
    }

    public void setChild(Threadable threadable) {
        this.kid = (Article)threadable;
        this.flushSubjectCache();
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setNext(Threadable threadable) {
        this.next = (Article)threadable;
        this.flushSubjectCache();
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String simplifiedSubject() {
        if (this.simplifiedSubject == null) {
            this.simplifySubject();
        }
        return this.simplifiedSubject;
    }

    private void simplifySubject() {
        int n = 0;
        String string = this.getSubject();
        int n2 = string.length();
        boolean bl = false;
        while (!bl) {
            int n3;
            bl = true;
            while (n < n2 && string.charAt(n) == ' ') {
                ++n;
            }
            if (!(n >= n2 - 2 || string.charAt(n) != 'r' && string.charAt(n) != 'R' || string.charAt(n + 1) != 'e' && string.charAt(n + 1) != 'E')) {
                if (string.charAt(n + 2) == ':') {
                    n += 3;
                    this.isReply = true;
                    bl = false;
                } else if (n < n2 - 2 && (string.charAt(n + 2) == '[' || string.charAt(n + 2) == '(')) {
                    n3 = n + 3;
                    while (n3 < n2 && string.charAt(n3) >= '0' && string.charAt(n3) <= '9') {
                        ++n3;
                    }
                    if (n3 < n2 - 1 && (string.charAt(n3) == ']' || string.charAt(n3) == ')') && string.charAt(n3 + 1) == ':') {
                        n = n3 + 2;
                        this.isReply = true;
                        bl = false;
                    }
                }
            }
            if (this.simplifiedSubject == "(no subject)") {
                this.simplifiedSubject = "";
            }
            n3 = n2;
            while (n3 > n && string.charAt(n3 - 1) < ' ') {
                --n3;
            }
            this.simplifiedSubject = n == 0 && n3 == n2 ? string : string.substring(n, n3);
        }
    }

    public boolean subjectIsReply() {
        if (this.simplifiedSubject == null) {
            this.simplifySubject();
        }
        return this.isReply;
    }
}

