#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#include <errno.h>
#include <sys/types.h>
#include <io.h>
#include <sys/stat.h>
#include <limits.h>
#ifdef __GNUC__
#include <alloca.h>
#else
#include <malloc.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

static USHORT curCP;
static UCHAR curDBMap[256];

static
int
my_rebuild_cptbl()
{
  APIRET rc;
  ULONG ulcp;
  ULONG ul;

  rc = DosQueryCp(sizeof(ulcp), &ulcp, &ul);
  if (rc != NO_ERROR && !(rc == ERROR_CPLIST_TOO_SMALL && ul == sizeof(ulcp))){
    ulcp = 0;
  }
  if (curCP != ulcp) {
    COUNTRYCODE cntry;
    UCHAR dbcs[16];
    int i;

    cntry.country = 0;
    cntry.codepage = ulcp;
    rc = DosQueryDBCSEnv(sizeof(dbcs), &cntry, dbcs);
    if (rc != NO_ERROR) {
      dbcs[1] = dbcs[0] = 0;
    }
    for(i=1; i<sizeof(curDBMap)/sizeof(curDBMap[0]); ++i) {
      curDBMap[i] = 1;
    }
    curDBMap[0] = 0;
    for(i=0; i<sizeof(dbcs)/sizeof(dbcs[0]); i+=2) {
      unsigned f, t;
      f = dbcs[i]; t = dbcs[i+1];
      if (t == 0 || f > t) break;
      while(f <= t) curDBMap[f++] = 2;
    }
    curCP = ulcp;
  }
  return curCP;
}

static
int
my_mblen_loosy(const char *s, int maxlen)
{
  int i, n;
  if (s == NULL || maxlen <= 0) return 0;
  if (!curCP) my_rebuild_cptbl();

  n = curDBMap[(unsigned char)*s];
  if (n>1) { /* avoid overrun... */
    for(i=0; i<n; ++i) {
      if (s[i] == '\0' || i >= maxlen) {
        n = i;
        break;
      }
    }
  }
  return n;
}

static
char *
my_strrchr(const char *s, int c)
{
  char *rc_s;
  int n;
  rc_s = NULL;
  if (s) for(;;) {
    if (c == *s) rc_s = (char *)s;
    n = my_mblen_loosy(s, INT_MAX);
    if (n <= 0) break;
    s += n;
  }
  return rc_s;
}

static
const char *
my_charlast(const char *s)
{
  int n;
  if (s) for(;;) {
    n = my_mblen_loosy(s, INT_MAX);
    if (n <= 0) break;
    s += n;
  }
  return s;
}

static
char *
my_backslashify(char *s)
{
  if (s) {
    int i;
    for(i=0; s[i]; ++i) {
      if (s[i] == '/') s[i] = '\\';
    }
  }
  return s;
}
static
char *
my_slashify(char *s)
{
  if (s) {
    int i, n;
    for(i=0;s[i];) {
      if (s[i] == '\\') s[i] = '/';
      n = my_mblen_loosy(s, INT_MAX);
      if (n <= 0) break;
      i += n;
    }
  }
  return s;
}


static int is_file(const char *fn)
{
  struct stat st;
  return (stat(fn, &st) == 0 && S_ISREG(st.st_mode));
}
static int is_dir(const char *fn)
{
  struct stat st;
  return (stat(fn, &st) == 0 && S_ISDIR(st.st_mode));
}

static
char *
vlc_chkpath(char *buf, size_t buflen, const char *vlc_base, const char *modname, const char *pdirname)
{
  /*
    
    1. (vlc_base)/vlc.dll              (vlc_base)
    2. (vlc_base)/lib/vlc.dll          (vlc_base)/lib
    3. (vlc_base) ̖ /bin
      3.1 (vlc_base)/../lib/vlc.dll    (vlc_base)/../lib
  */

  APIRET rc;
  size_t n, n_mod, n_pdir;
  char *s, *s_base;

  if (!vlc_base || !modname || !pdirname) return NULL;
  n = strlen(vlc_base);
  n_mod = strlen(modname);
  n_pdir = strlen(pdirname);
  s = alloca(n + 1 + n_mod + 1 + n_pdir + 32);
  strcpy(s, vlc_base);
  my_slashify(s);
  if (n>0 && s[n-1] == '/') {
    --n;
    s[n] = '\0';
  }
  
  s_base = NULL;

  /* 1 */
  if (!s_base) {
    strcpy(s+n, "/"); strcat(s+n, modname);
    if (is_file(s)) {
      s[n] = '\0';
      s_base = s;
    }
  }
  /* 2 */
  if (!s_base) {
    strcpy(s+n, "/"); strcat(s+n, pdirname);
    strcat(s+n, "/"); strcat(s+n, modname);
    if (is_file(s)) {
      s[n+1+n_pdir] ='\0';
      s_base = s;
    }
  }
  /* 3 */
  if (!s_base && n >= 4) {
    s[n] = '\0';
    if (stricmp(s+n-4, "/bin")==0 || stricmp(s+n-4, "/lib")==0) {
      s[n-3] = '\0';
      strcat(s, pdirname); strcat(s, "/"); strcat(s, modname);
      if (is_file(s)) {
        strcpy(s+n-3, pdirname);
        s_base = s;
      }
    }
  }

  if (!s_base) return NULL;
  my_backslashify(s_base);
  rc = DosQueryPathInfo(s_base, FIL_QUERYFULLNAME, buf, buflen);
  return rc == NO_ERROR ? buf : NULL;
}

static
char *
vlc_libpath(char *buf, size_t buflen, const char *vlc_base)
{
  const char modname[] = "vlc.dll";
  const char pdirname[] = "lib";
  return vlc_chkpath(buf, buflen, vlc_base, modname, pdirname);
}
static
char *
vlc_binpath(char *buf, size_t buflen, const char *vlc_base)
{
  const char modname[] = "vlc.exe";
  const char pdirname[] = "bin";
  return vlc_chkpath(buf, buflen, vlc_base, modname, pdirname);
}


static
char *
qt_libpath(char *buf, size_t buflen, const char *qtpath)
{
  APIRET rc;
  char *s;
  size_t n;

  if (!qtpath) return NULL;
  n = strlen(qtpath);
  s = alloca(n + 16);
  strcpy(s, qtpath);
  my_slashify(s);
  if (n>0 && s[n-1] == '/') {
    --n;
    s[n] = '\0';
  }
  strcpy(s + n, "/QtCore4.dll");
  if (!is_file(s)) return NULL;
  s[n] = '\0';
  my_backslashify(s);
  rc = DosQueryPathInfo(s, FIL_QUERYFULLNAME, buf, buflen);
  return rc == NO_ERROR ? buf : NULL;
}

static
int
my_mkdir_p(const char *name, long mode)
{
  int rc = 0;
  char *s_base, *s;
  size_t n_name;

  if (!name) {
    errno = EINVAL;
    return -1;
  }
  n_name = strlen(name);
  s_base = alloca(n_name + 1);
  strcpy(s_base, name);
  my_slashify(s_base);
  
  s = s_base;
  if (s[0] && s[1] == ':') {
    s += 2;
    if (s[0] == '/') ++s;
  }
  if (s_base[0] == '/' && s_base[1] == '/') {
    /* skip UNC \\machine\base */
    s = strchr(s_base+2, '/');
    if (!s) {
      errno = EINVAL; /* bad name */
      return -1;
    }
    ++s;
  }

  while(*s) {
    struct stat st;
    char c, *s2;
    int rc;
    s2 = strchr(s, '/');
    if (s2) {
      c = *s2;
      *s2 = 0;
    }
    rc = stat(s_base, &st);
    if (!(rc == 0 && S_ISDIR(st.st_mode))) {
      rc = mkdir(s_base, mode);
      if (rc < 0) break;
    }
    if (s2) {
      *s2 = c;
      s = s2 + 1;
    } else {
      break;
    }
  }

  return rc;
}

static
char *
my_getenv(const char *env)
{
  return getenv(env);
}

static
int
my_putenv(const char *env)
{
  return putenv(env);
}

static
int
my_setenv(const char *name, const char *val, int ovw)
{
  char *e;
  size_t n_n, n_v;

  n_n = name ? strlen(name) : 0;
  n_v = val ? strlen(val) : 0;
  if (!n_n) {
    errno = EINVAL;
    return -1;
  }
  if (ovw || !(e = getenv(name))) {
    e = malloc(n_n + 1 + n_v + 1);
    if (!e) return -1;
    memcpy(e, name, n_n);
    e[n_n] = '=';
    if (n_v > 0) {
      memcpy(e + n_n + 1, val, n_v);
      e[n_n + 1 + n_v] = '\0';
    }
    return my_putenv(e);
  }
  return ovw == 0 ? 0 : -1;
}

static char *opt_vlcpath;
static char *opt_qtpath;
static char *opt_home;
static char *opt_lang;
static int opt_dive;
static int opt_snap;
static int opt_dart;
static int opt_strict;
static int opt_lower;
static int opt_higher;
static int opt_homeconfig;
static int opt_help;
static int opt_version;

enum { NO_MATCH = 0, MATCH_EXACTLY, MATCH_PARTLY };
static int cmp_arg_p(const char *arg, const char *opt, size_t *pos)
{
  int rc;
  size_t na, no;
  if (!arg || !*arg || !opt || !*opt) return NO_MATCH;
  
  na = strlen(arg); no = strlen(opt);
  if (na >= no && memcmp(arg, opt, no) == 0) {
    switch(arg[no]) {
      case '\0':
        rc = MATCH_EXACTLY; break;
      case '=':
      case ':':
      case ' ':
        rc = MATCH_PARTLY;
        if (pos) *pos = no + 1;
        break;
      default:
        rc = NO_MATCH;
    }
  } else {
    rc = NO_MATCH;
  }
  return rc;
}
#define cmp_arg(a,o) cmp_arg_p(a,o,NULL)

static
char **
append_arg(char **args, const char *s, int do_copy)
{
  if (s) {
    int i;
    for(i=0; args[i]; ++i) ;
    args = realloc(args, sizeof(char *) * (i+2));
    args[i] = do_copy ? strdup(s) : (char *)s;
    args[i+1] = NULL;
  }
  return args;
}

static
char **
my_getopt(int argc, char *argv[], int base_index_for_options)
{
  char **args2;
  int i_arg;

  args2 = malloc(sizeof(char *));
  args2[0] = NULL;
  for(i_arg = 0; i_arg<argc; ++i_arg) {
    char *s;
    size_t p;
    s = argv[i_arg];
    p = 0;
    if (i_arg >= base_index_for_options) {
      if (cmp_arg(s, "--help") == MATCH_EXACTLY) opt_help = 1;
      else if (cmp_arg(s, "-?") == MATCH_EXACTLY) opt_help = 1;
      else if (cmp_arg(s, "--version") == MATCH_EXACTLY) opt_version = 1;
      else if (cmp_arg(s, "--dive") == MATCH_EXACTLY) { opt_dive = 1; opt_snap = 0; }
      else if (cmp_arg(s, "--snap") == MATCH_EXACTLY) { opt_dive = 0; opt_snap = 1; }
      else if (cmp_arg(s, "--lower") == MATCH_EXACTLY) { opt_lower = 1; opt_higher = 0; }
      else if (cmp_arg(s, "--higher") == MATCH_EXACTLY) { opt_lower = 0; opt_higher = 1; }
      else if (cmp_arg(s, "--dart") == MATCH_EXACTLY) opt_dart = 1;
      else if (cmp_arg(s, "--homeconfig") == MATCH_EXACTLY) opt_homeconfig = 1;
      else if (cmp_arg(s, "--libpathstrict") == MATCH_EXACTLY) opt_strict = 1;
      else if (cmp_arg_p(s, "--vlc-path", &p) == MATCH_PARTLY) opt_vlcpath = s+p;
      else if (cmp_arg_p(s, "--qt-path", &p) == MATCH_PARTLY) opt_qtpath = s+p;
      else if (cmp_arg_p(s, "--home", &p) == MATCH_PARTLY) opt_home = s+p;
      else if (cmp_arg_p(s, "--lang", &p) == MATCH_PARTLY) opt_lang = s+p;
      else
        args2 = append_arg(args2, s, 0);
    } else {
      args2 = append_arg(args2, s, 0);
    }
  }
  return args2;
}

int
main(int argc, char *argv[])
{
  char libbase[512];
  char mypath[512];
  char qtpath[512];
  char binbase[512];
  char blibp[512];
  char blibp2[1024];
  char **args2;

  PPIB ppib;
  PTIB ptib;
  char *s;

  DosGetInfoBlocks(&ptib, &ppib);
  DosQueryModuleName((HMODULE)(ppib->pib_hmte), sizeof(mypath)-1, mypath);
  s = my_strrchr(mypath, '\\');
  if (s) *s = '\0';

  args2 = my_getopt(argc, argv, 1);

  if (!vlc_libpath(libbase, sizeof(libbase), opt_vlcpath ? opt_vlcpath : mypath)) {
   *libbase = '\0';
  }
  if (!vlc_binpath(binbase, sizeof(binbase), opt_vlcpath ? opt_vlcpath : mypath)) {
    *binbase = '\0';
  }
  if (!opt_qtpath || !*opt_qtpath || !qt_libpath(qtpath, sizeof(qtpath), opt_qtpath)) {
    *qtpath = '\0';
  }

  if (DosQueryExtLIBPATH(blibp, BEGIN_LIBPATH) != NO_ERROR) {
    *blibp = '\0';
  }

  *blibp2 = '\0';
  if (*libbase) {
    strcat(blibp2, libbase);
    strcat(blibp2, ";");
  }
  if (*qtpath) {
    strcat(blibp2, qtpath);
    strcat(blibp2, ";");
  }
  if (*blibp) {
    strcat(blibp2, blibp);
    strcat(blibp2, ";");
  }
  if (opt_strict || opt_qtpath) {
    my_putenv("LIBPATHSTRICT=T");
  }
  if (blibp2[0]) {
    DosSetExtLIBPATH(blibp2, BEGIN_LIBPATH);
  }
  if (opt_home) {
    my_setenv("HOME", opt_home, 1);
  }
  if (opt_homeconfig) {
    char *home;
    home = my_getenv("HOME");
    if (home) {
      const char rcpath[] = "/.config/vlc/";
      const char rc[] = "vlcrc";
      char *s;
      s = alloca(strlen(home) + strlen(rcpath) + strlen(rc) + 1);
      strcpy(s, home);
      strcat(s, rcpath);
      if (my_mkdir_p(s, 0666) == 0) {
        const char cfgopt[] = "--config=";
        char *sopt;
        strcat(s, rc);
        sopt = alloca(strlen(cfgopt) + strlen(s) + 1);
        strcpy(sopt, cfgopt);
        strcat(sopt, s);
        args2 = append_arg(args2, sopt, 1);
      }
    }
  }
  if (opt_lang) {
    my_setenv("LANGUAGE", opt_lang, 1);
  }
  if (!opt_dive && !opt_snap) {
    /* force "--dive" unless SNAP SDDGRADD is installed... */
    HMODULE hm;
    if (DosQueryModuleHandle("SDDGRADD", &hm) != NO_ERROR) {
      opt_dive = 1;
    }
  }
  if (opt_dive) {
    my_putenv("QT_PM_NO_DIVE=1");
    args2 = append_arg(args2, "--kva-video-mode=dive", 1);
  }
  if (opt_dart) args2 = append_arg(args2, "--kai-audio-device=dart", 1);
  
  if (*binbase && *my_charlast(binbase) != '\\') strcat(binbase, "\\");
  strcat(binbase, "vlc.exe");
  
  args2[0] = "VLC";

  if (opt_lower || opt_higher) {
    DosSetPriority(PRTYS_PROCESSTREE, opt_higher ? PRTYC_FOREGROUNDSERVER : PRTYC_REGULAR, (opt_lower || opt_higher) ? PRTYD_MINIMUM : 0, 0);
  }
  if (spawnv(P_PM | P_UNRELATED | P_FOREGROUND, binbase, args2) == -1) return -1;

  return 0;
}
