#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <float.h>
#define INCL_OS2MM
#define INCL_DOS
#include <os2.h>
#include <os2me.h>
#include "proto.h"
#include "getargs.h"
#include "hplay.h"
#include "limits.h"

/* new MCI commands? */
#define SEMWAIT_OPERATION                   9
#define SEMPOST_OPERATION                  10

/* PlayList Entry */

typedef struct _PLE {
    ULONG operation;
    ULONG operand1;
    ULONG operand2;
    ULONG operand3;
}PLE;

long samp_rate  = 8000;
long bits = 16;
int quiet = FALSE;
double ampfactor = 1.0f;
ULONG volume = 100;
ULONG deviceID = 0;

/* for multimedia playlist semaphores */
static unsigned long dataready = 0,
                     dataplayed = 0;

/* multimedia variables */
MCI_OPEN_PARMS mop;
MCI_PLAY_PARMS mpp;
MCI_WAVE_SET_PARMS wsp;
MCI_GENERIC_PARMS mgp;
MCI_STATUS_PARMS msp;
ULONG rc;
PLE playlist[4];
BOOL closing = FALSE, /* makes we don't start doing things with the device
                         just before closing it */
     ending = FALSE;  /* no stop_audio() while end_audio() or vice versa */

void mci_err(ULONG rc)
{
    const rsize = 128;
    char rbuff[rsize];

    ULONG rc2 = mciGetErrorString(rc,      // error code
                                  rbuff,   // return buffer
                                  rsize);  // rbuff size

    if (rc2 == MCIERR_SUCCESS)
        winprintf("MCI error: %s",rbuff);
    else
        winprintf("error # %d has occured!", rc);

    winprintf("  Switching to quiet mode.\n");
    quiet = TRUE;
    DosPostEventSem(dataplayed);
}

void set_volume(void)
{
  if (mop.usDeviceID && !closing)
  {
     if(volume > 100) volume = 100;
     wsp.ulLevel = volume;

     wsp.hwndCallback = 0;
     rc = mciSendCommand(mop.usDeviceID, MCI_SET,
                         MCI_WAIT | MCI_SET_AUDIO | MCI_SET_VOLUME,
                         &wsp, 0);
  }
}

void stop_audio(void)
{
  if (mop.usDeviceID && !closing && !ending)
  {
     ending = TRUE;

     mgp.hwndCallback = 0;
     rc = mciSendCommand(mop.usDeviceID, MCI_STOP, 0, &mgp, 0);
     if (rc != MCIERR_SUCCESS) mci_err(rc);

     DosPostEventSem(dataplayed);
     if(DosWaitEventSem(dataready, -1)) return;
     free((void*) playlist[1].operand1); playlist[1].operand1 = (long) NULL;

     quiet = TRUE;

     closing = TRUE;

     mgp.hwndCallback = 0;
     rc = mciSendCommand(mop.usDeviceID, MCI_CLOSE, MCI_WAIT, &mgp, 0);
     if (rc != MCIERR_SUCCESS) mci_err(rc);

     mop.usDeviceID = 0;
     closing = FALSE;

     ending = FALSE;
  }
}


int audio_init(int argc, char **argv)
{
 int rate = 8;

 argc = getargs("Audio Initialization", argc, argv,
                "r", "%d", &rate,   "Sample Rate in kHz - 8, 11, 22, or 44",
                "Q", NULL, &quiet,   "Quiet - No sound ouput",
                "b", "%d", &bits, "8 or 16 bit sample playback",
                "V", "%u", &volume, "Volume in %",
                "a", "%lg", &ampfactor, "Amplification factor",
                "D", "%u", &deviceID, "Sound Card Device ID (0 = default device)",
                NULL);
 if (help_only)
  return (argc);
 
 switch(rate)
    {
     case  8 : samp_rate =  8000;
               break;
     case 11 : samp_rate = 11025;
               break;
     case 22 : samp_rate = 22050;
               break;
     case 44 : samp_rate = 44100;
               break;
     default : samp_rate =  8000;
    }

  if (bits != 8)
     bits = 16;

  if(!dataready) DosCreateEventSem(NULL,&dataready,0,FALSE);
  if(!dataplayed) DosCreateEventSem(NULL,&dataplayed,0,FALSE);

  _control87(EM_INVALID | EM_DENORMAL | EM_ZERODIVIDE | EM_OVERFLOW | EM_UNDERFLOW | EM_INEXACT, MCW_EM);

  return (argc);

}


void start_audio(void)
{

  mop.usDeviceID     = 0; /* returned value */

  if(!quiet)
  {
     playlist[0].operation = SEMWAIT_OPERATION;
     playlist[0].operand1  = dataready;
     playlist[0].operand2  = -1;
     playlist[0].operand3  = FALSE;

     playlist[1].operation = DATA_OPERATION;
     playlist[1].operand1  = (long) NULL;
     playlist[1].operand2  = 0;
     playlist[1].operand3  = 0;

     playlist[2].operation = SEMPOST_OPERATION;
     playlist[2].operand1  = dataplayed;

     playlist[3].operation = BRANCH_OPERATION;
     playlist[3].operand2  = 0;  // goto playlist[0]

     mop.hwndCallback   = 0;
     mop.pszDeviceType  = (PSZ) MAKEULONG(MCI_DEVTYPE_WAVEFORM_AUDIO, deviceID);
     mop.pszElementName = (void *) playlist;

     rc = mciSendCommand(0,
                         MCI_OPEN,                        // open message
                         MCI_WAIT | MCI_OPEN_SHAREABLE |  // message flags
                         MCI_OPEN_PLAYLIST | MCI_OPEN_TYPE_ID,
                         &mop,                            // parameters
                         0);
     if (rc != MCIERR_SUCCESS)
     {
        mci_err(rc);

        closing = TRUE;

        mgp.hwndCallback = 0;
        rc = mciSendCommand(mop.usDeviceID, MCI_CLOSE, MCI_WAIT, &mgp, 0);
        if (rc != MCIERR_SUCCESS) mci_err(rc);

        mop.usDeviceID = 0;
        closing = FALSE;
     }
     else
     {
        // set device parameters

        wsp.ulSamplesPerSec = samp_rate;
        wsp.usBitsPerSample = bits;
        wsp.usChannels = 1;
        wsp.ulAudio = MCI_SET_AUDIO_ALL;

        wsp.hwndCallback = 0;
        rc = mciSendCommand(mop.usDeviceID,
                            MCI_SET,
                            MCI_WAIT |
                            MCI_WAVE_SET_SAMPLESPERSEC |
                            MCI_WAVE_SET_BITSPERSAMPLE |
                            MCI_WAVE_SET_CHANNELS,
                            &wsp,
                            0);
        if (rc != MCIERR_SUCCESS)
        {
           mci_err(rc);

           closing = TRUE;

           mgp.hwndCallback = 0;
           rc = mciSendCommand(mop.usDeviceID, MCI_CLOSE, MCI_WAIT, &mgp, 0);
           if (rc != MCIERR_SUCCESS) mci_err(rc);

           mop.usDeviceID = 0;
           closing = FALSE;
        }
        else
        {
           set_volume();

           mpp.hwndCallback = 0;
           rc = mciSendCommand(mop.usDeviceID, MCI_PLAY, 0, &mpp, 0);
           if (rc != MCIERR_SUCCESS) mci_err(rc);

           DosPostEventSem(dataplayed);
        }
     }
  }
 _control87(EM_INVALID | EM_DENORMAL | EM_ZERODIVIDE | EM_OVERFLOW | EM_UNDERFLOW | EM_INEXACT, MCW_EM);

}

void end_audio(void)
{
  if(mop.usDeviceID && !ending)
  {
     ULONG resetcount;

     quiet = TRUE;
     ending = TRUE;

     if(DosWaitEventSem(dataplayed, -1)) return;
     DosResetEventSem(dataplayed,&resetcount);

     playlist[1].operation = EXIT_OPERATION;
     free((void*) playlist[1].operand1); playlist[1].operand1 = (long) NULL;

     DosPostEventSem(dataready);

     msp.hwndCallback = 0;
     msp.ulItem = MCI_STATUS_MODE;

     do
     {
        rc = mciSendCommand(mop.usDeviceID,MCI_STATUS,
                            MCI_WAIT | MCI_STATUS_ITEM, &msp, 0);
        if (LOUSHORT(rc) != MCIERR_SUCCESS) mci_err(rc);

        DosSleep(500);
     }
     while(msp.ulReturn == MCI_MODE_PLAY);

     closing = TRUE;

     mgp.hwndCallback = 0;
     rc = mciSendCommand(mop.usDeviceID, MCI_CLOSE, MCI_WAIT, &mgp, 0);
     if (rc != MCIERR_SUCCESS) mci_err(rc);

     mop.usDeviceID = 0;
     closing = FALSE;
     ending = FALSE;
  }
}


void audio_term(void)
{
   DosCloseEventSem(dataready); dataready = 0;
   DosCloseEventSem(dataplayed); dataplayed = 0;
}


void audio_play(int n, short *data, char *sentence, char *phone)
{
 extern int verbose, text;
 char temp[256];
 ULONG resetcount;

 if (quiet)
 {
    if(text) winprintf("%s",sentence);
    if(verbose) winprintf("\n%s\n",phone);
    free(sentence);
    free(phone);
    return;
 }

 /* my cheezy amplifier - Samuel */

 if(ampfactor != 1.0f)
 {
    short *current = data,
          *end = data + n;

    while(current < end)
    {
       if (*current < 0)
       {
          if ((*current * ampfactor) > SHRT_MIN)
             *current = (short) (*current * ampfactor);
          else
             *current = SHRT_MIN;
       }
       else if (*current > 0)
       {
          if ((*current * ampfactor) < SHRT_MAX)
             *current = (short) (*current * ampfactor);
          else
             *current = SHRT_MAX;
       }
       current++;
    }

 }

 if(DosWaitEventSem(dataplayed, -1)) return;
 DosResetEventSem(dataplayed,&resetcount);

 if(text) winprintf("%s",sentence);
 if(verbose) winprintf("\n%s\n",phone);
 free(sentence);
 free(phone);

 if (bits == 8)
   {
     char *plabuf;

     plabuf = (char *) malloc(n * sizeof(char));
     if (plabuf)
       {
        char *p = plabuf;
        char *e = p + n;
        while (p < e)
           *p++ = (char) (*data++ / 256 + 128);

        free((void *) playlist[1].operand1);
        playlist[1].operand1  = (long) plabuf;
        playlist[1].operand2  = n;

        DosPostEventSem(dataready);
       }
     else
       {
         winprintf("Insufficient memory for Play Buffer\n\n");
         return;
       }
   }
 else /* if bits == 16 */
   {
    short *plabuf;

    plabuf = (short *) malloc(n * sizeof(short));
    if (plabuf)
       {
        short *p = plabuf;
        short *e = p + n;
        while (p < e)
           *p++ = *data++;

        free((void *)playlist[1].operand1);
        playlist[1].operand1  = (long) plabuf;
        playlist[1].operand2  = n*2; /* don't ask, don't know, but works */

        DosPostEventSem(dataready);
       }
     else
       {
         winprintf("Insufficient memory for Play Buffer\n\n");
         return;
       }
   }
}
