/***********************************************************************/
/* Copyright 2000 Lotus Development Corporation.  All rights reserved. */
/*                                                                     */
/* Sample REXX command file: Lotus SmartSuite for OS/2 Warp 4          */
/*                           Automated Installation                    */
/*                                                                     */
/* Lotus SmartSuite for OS/2 Warp 4 installation can be automated by   */
/* tailoring this file and SUITE.RSP.  This file includes commands     */
/* and descriptions of parameters necessary for CID installation.      */
/* SUITE.RSP includes selected user responses.  The .CMD and .RSP      */
/* files require editing to tailor them for your specific installation.*/
/*                                                                     */
/* Some error conditions do not create an entry in the CID logfiles.   */
/* You may use the SSI_DEBUG environment variable to specify an        */
/* additional file to capture debug information.                       */
/*                                                                     */
/* See READNET.TXT file for additional information on CID installs.    */
/*                                                                     */
/***********************************************************************/
/*
trace ?i
*/

/*------------------------*/
/*  Variables section     */
/*---------------------------------------------------*/
/*  Path locations on the Code server                */
/*---------------------------------------------------*/
rspdir   = 'c:\OS2SS173\english\suite.rsp'   /* Path to Response directory on the server */
logdir   = 'c:\OS2SS173\suite.log'          /* Path to the log directory on the server */
exepath  = 'c:\OS2SS173'                     /* Path to executable directory on server */
/*---------------------------------------------------*/
/* Product name to be installed                      */
/* The following are available: (English)            */
/*                                                   */
/* "Lotus SmartSuite W4 English Standard Version"    */
/* "Lotus SmartSuite W4 English Server Version"      */
/* "Lotus SmartSuite W4 English Distribution Version"*/
/* "Lotus SmartSuite W4 English Node Version"        */
/*---------------------------------------------------*/
stdname  = '"Lotus SmartSuite W4 English Standard Version"'
srvname  = '"Lotus SmartSuite W4 English Server Version"'
distname = '"Lotus SmartSuite W4 English Distribution Version"'
nodename = '"Lotus SmartSuite W4 English Node Version"'
name     = stdname

/**************************/
/*  Run the install       */
/**************************/
Select
   WHEN name <> nodename Then
    exepath ||'\english\ssfixpak.exe',         /* fully qualified install program path */
         ' /a:I',                             /* indicate to install */
         ' /l1:'logdir,                       /* error log - !! DIRECTORY MUST ALREADY EXIST !! */
         ' /p:'name,                          /* name of product */
         ' /s:'exepath'\ENGLISH',             /* source directory */
         ' /x',                               /* indicate unattended install */
         ' /r:'rspdir                         /* response file directory */

   otherwise
    exepath ||'\ssfixpak.exe',                 /* fully qualified install program path */
         ' /a:I',                             /* indicate to install */
         ' /l1:'logdir,                       /* error log - !! DIRECTORY MUST ALREADY EXIST !! */
         ' /p:'name,                          /* name of product */
         ' /s:'exepath,                       /* source directory */
         ' /x',                               /* indicate unattended install */
         ' /r:'rspdir                         /* response file directory */
   end

return

