#include "npunzip.h"

static NPPluginFuncs* g_pluginFuncs;
NPNetscapeFuncs* g_pNavigatorFuncs = 0;

HMODULE DLLInstance;

unsigned LibMain(unsigned hmod,unsigned termination)
{
  if (termination)
    ;
  else DLLInstance = (HMODULE)hmod;
  return 1;
}

void* NPN_MemAlloc(uint32 size)
{
    return g_pNavigatorFuncs->memalloc(size);
}

void NPN_ReloadPlugins(NPBool reloadPages)
{
    g_pNavigatorFuncs->reloadplugins(reloadPages);
}

void NPN_MemFree(void* ptr)
{
    g_pNavigatorFuncs->memfree(ptr);
}

// Find the PluginInstance associated with this hWnd and return it
PluginInstance *GetInstance(HWND hWnd)
{
    return (PluginInstance *)WinQueryWindowULong(hWnd, QWL_USER);
}
MRESULT APIENTRY SubClassFunc(  HWND hWnd,
                                ULONG Message,
                                MPARAM wParam,
                                MPARAM lParam)
{
    HPS            hps;
    PluginInstance  *This;
    This = GetInstance(hWnd);

    switch(Message) {
    case WM_REALIZEPALETTE:
        WinInvalidateRect(hWnd, 0, TRUE);
        WinUpdateWindow(hWnd);
        return 0;
        break;
    case WM_PAINT:
        hps   = WinBeginPaint(hWnd,NULLHANDLE,NULL);
        GpiErase(hps);
        WinEndPaint(hWnd);
        break;
    default:
        break;
    }

    return ((PFNWP)This->lpfnOldWndProc)(
                          hWnd,
                          Message,
                          wParam,
                          lParam);
}
void invalidate_container(HWND hwndCnr)
{
  USHORT cNumRecord;             /* Number of records to be removed     */
  USHORT fRemoveRecord;          /* Container message attributes        */

 /**********************************************************************/
 /*  Zero means remove all records.                                    */
 /**********************************************************************/
 cNumRecord = 0;

 /**********************************************************************/
 /*  Specify attributes to invalidate the container                    */
 /*  and free the memory.                                              */
 /**********************************************************************/
 fRemoveRecord = CMA_FREE | CMA_INVALIDATE;
 WinSendMsg(hwndCnr,
            CM_REMOVERECORD,

            NULL,
            MPFROM2SHORT(
                          cNumRecord,
                          fRemoveRecord));

}
int getdir(char *filename,cdir_file_hdr *p,int easize,int aclsize)
{
   USHORT           nRecords = 1;
   ULONG            cbRecordData;

   cbRecordData = (LONG) (sizeof(USERRECORD) - sizeof(RECORDCORE));
   pUserRecord = (PUSERRECORD) WinSendDlgItemMsg(hwnd_cont,ID_CONTAINER,
                                                 CM_ALLOCRECORD, MPFROMLONG(cbRecordData) ,
                                                 MPFROMSHORT(nRecords));
   pUserRecord->recordCore.cb = sizeof(RECORDCORE);              /*RBS*/
   pUserRecord->recordCore.pszText = filename;
   pUserRecord->recordCore.pszIcon = filename;
   pUserRecord->recordCore.pszName = filename;
   pUserRecord->recordCore.hptrIcon = 0;
   strcpy(pUserRecord->f1,filename);
   pUserRecord->filename = pUserRecord->f1;
   pUserRecord->file_size = p->ucsize;
   pUserRecord->ea_size   = easize;
   pUserRecord->acl_size  = aclsize;

   recordInsert.cb = sizeof(RECORDINSERT);                   /*RBS*/
   recordInsert.pRecordParent= NULL;
   recordInsert.pRecordOrder = (PRECORDCORE)CMA_END;
   recordInsert.zOrder = CMA_TOP;
   recordInsert.cRecordsInsert = 1;
   recordInsert.fInvalidateRecord = TRUE;

   WinSendDlgItemMsg(hwnd_cont,ID_CONTAINER, CM_INSERTRECORD,
                    (PRECORDCORE)pUserRecord, &recordInsert);
   return 0;
}
MRESULT EXPENTRY NPLoadProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   HPS    hps;
   RECTL  rcl;
   POINTL endpoint;
   POINTL pos;
   ULONG  total;
   ULONG  reste;
   CHAR   tmp[20];

   switch(msg)
    {
       case WM_USER:
            total    = (ULONG)mp1;
            reste    = (ULONG)mp2;

            WinQueryWindowRect(WinWindowFromID(hwnd,ID_PROGRESS),&rcl);
            hps = WinGetPS(WinWindowFromID(hwnd,ID_PROGRESS));
            if (total > 10000)
              {
                 total = total / 10000;
                 reste = reste / 10000;
              }

            pos.x = (rcl.xRight-5*10)/2;
            pos.y = 1;
            GpiMove(hps,&pos);
            endpoint.x = pos.x+5*10;
            endpoint.y = rcl.yTop-2;
            GpiSetColor(hps, CLR_PALEGRAY);
            GpiBox(hps, DRO_FILL, &endpoint, 0L, 0L);

            pos.x = 1;
            pos.y = 1;
            GpiMove(hps,&pos);
            endpoint.x = (((total-reste) * rcl.xRight) / total)-2;
            endpoint.y = rcl.yTop-2;
            GpiSetColor(hps, CLR_RED);
            GpiBox(hps, DRO_FILL, &endpoint, 0L, 0L);

            GpiSetColor(hps, CLR_BLACK);
            pos.x = (rcl.xRight-10*5)/2;
            pos.y = (rcl.yTop-10)/2;
            sprintf(tmp,"%3d %c",((total-reste)*100)/total,'%');
            GpiMove(hps,&pos);
            GpiCharString(hps,strlen(tmp),tmp);
            WinReleasePS(hps);
            break;
       case WM_ERASEBACKGROUND:
             return (MRESULT) TRUE;
            break;
      default:
              return WinDefDlgProc(hwnd, msg, mp1, mp2);
              break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}
PRECORDCORE QuerySelection(PRECORDCORE pStartRecord,HWND hwndCnr)
{
  if ( !pStartRecord )
    pStartRecord = (PRECORDCORE)CMA_FIRST;

  return (PRECORDCORE)WinSendMsg(hwndCnr, CM_QUERYRECORDEMPHASIS,
                                 MPFROMLONG(pStartRecord), MPFROMSHORT(CRA_SELECTED));
}
static void AssociateInstance(HWND hWnd, PluginInstance* pInstance)
{
    BOOL rc;

    pInstance->hWnd = hWnd;     // redundant, but usefull to get hwnd from
                                // pinstance later.
    rc = WinSetWindowULong(hWnd, QWL_USER, (ULONG)pInstance);
}

MRESULT EXPENTRY NPUnzipProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2)
{
   PRECORDCORE      pRecord;
   PFIELDINFO       pFieldInfo, firstFieldInfo;
   FIELDINFOINSERT  fieldInfoInsert;
   PFIELDINFOINSERT pFieldInfoInsert;
   CNRINFO          cnrinfo;
   PluginInstance   *This;
   UzpVer           *pVersion;
   char             version[40];
   char             *cpinclude[2];
   char             *cpexclude[2];
   char             include[20];
   char             exclude[20];
   int              rc;

   static           int argc;
   static           unsigned char *argv[7];
   USERRECORD       *pCnrData;
   char             unzpath[255];
   struct stat      stat_str;

   switch(msg)
    {
       case WM_INITDLG:
            hwnd_cont = hwnd;
            This = (PluginInstance *)mp2;
            pVersion = UzpVersion();
            sprintf(version,"Based on winzip ver %d.%d patch level : %d",
                             pVersion->os2dll.major,
                             pVersion->os2dll.minor,
                             pVersion->os2dll.patchlevel);
            WinSetDlgItemText(hwnd,ID_ZIPVER,version);
            WinSetDlgItemText(hwnd,ID_ZIPFILE,This->filename);
            WinSetDlgItemText(hwnd,ID_INCMASK,"*");
            pFieldInfo = (PFIELDINFO) WinSendDlgItemMsg(hwnd, ID_CONTAINER,
                                                        CM_ALLOCDETAILFIELDINFO,MPFROMLONG(4), NULL);

            firstFieldInfo = pFieldInfo;

            pFieldInfo->cb = sizeof(FIELDINFO);
            pFieldInfo->flData = CFA_STRING | CFA_HORZSEPARATOR;


            pFieldInfo->flTitle = 0;
            pFieldInfo->pTitleData = (PVOID) "Filename";
            pFieldInfo->offStruct = 56;
            pFieldInfo = pFieldInfo->pNextFieldInfo;

            pFieldInfo->cb = sizeof(FIELDINFO);
            pFieldInfo->flData = CFA_ULONG  | CFA_HORZSEPARATOR | CFA_RIGHT |
                                 CFA_SEPARATOR;
            pFieldInfo->flTitle = CFA_CENTER;
            pFieldInfo->pTitleData =  (PVOID) "File size";
            pFieldInfo->offStruct = 60;
            pFieldInfo = pFieldInfo->pNextFieldInfo;

            pFieldInfo->cb = sizeof(FIELDINFO);
            pFieldInfo->flData = CFA_ULONG  | CFA_HORZSEPARATOR | CFA_RIGHT |
                                 CFA_SEPARATOR;
            pFieldInfo->flTitle = CFA_CENTER;
            pFieldInfo->pTitleData = (PVOID) "EA Size";
            pFieldInfo->offStruct = 64;
            pFieldInfo = pFieldInfo->pNextFieldInfo;

            pFieldInfo->cb = sizeof(FIELDINFO);
            pFieldInfo->flData = CFA_ULONG  | CFA_HORZSEPARATOR | CFA_RIGHT |
                                 CFA_SEPARATOR;
            pFieldInfo->flTitle = CFA_CENTER;
            pFieldInfo->pTitleData = (PVOID) "ACL Size";
            pFieldInfo->offStruct = 68;


            fieldInfoInsert.cb = (ULONG)(sizeof(FIELDINFOINSERT));
            fieldInfoInsert.pFieldInfoOrder = (PFIELDINFO)CMA_FIRST;
            fieldInfoInsert.cFieldInfoInsert = 4;
            fieldInfoInsert.fInvalidateFieldInfo = TRUE;

            pFieldInfoInsert = &fieldInfoInsert;

            WinSendDlgItemMsg(hwnd,ID_CONTAINER, CM_INSERTDETAILFIELDINFO,
                              MPFROMP(firstFieldInfo),
                              MPFROMP(pFieldInfoInsert));
            cnrinfo.flWindowAttr  = CV_DETAIL|CA_DETAILSVIEWTITLES;
            WinSendDlgItemMsg(hwnd,ID_CONTAINER,CM_SETCNRINFO,MPFROMP(&cnrinfo),
                              MPFROMLONG(CMA_FLWINDOWATTR));
            cnrinfo.xVertSplitbar  = 400;
            cnrinfo.pFieldInfoLast = firstFieldInfo;
            WinSendDlgItemMsg(hwnd,ID_CONTAINER,CM_SETCNRINFO,MPFROMP(&cnrinfo),
                              MPFROMLONG(CMA_XVERTSPLITBAR|CMA_PFIELDINFOLAST));
            WinQueryDlgItemText(hwnd,ID_INCMASK,sizeof(include),include);
            WinQueryDlgItemText(hwnd,ID_EXMASK,sizeof(exclude),exclude);

            cpinclude[0] = include;
            cpinclude[1] = NULL;

            cpexclude[0] = exclude;
            cpexclude[1] = NULL;
            rc = UzpFileTree("\\tmp.zip",
                             getdir,
                             cpinclude,
                             cpexclude);
            break;
       case WM_COMMAND:
            switch(COMMANDMSG(&msg)->cmd)
             {
               case ID_CHGMASK:
                    invalidate_container( WinWindowFromID(hwnd,ID_CONTAINER) );
                    WinQueryDlgItemText(hwnd,ID_INCMASK,sizeof(include),include);
                    WinQueryDlgItemText(hwnd,ID_EXMASK,sizeof(exclude),exclude);

                    cpinclude[0] = include;
                    cpinclude[1] = NULL;

                    cpexclude[0] = exclude;
                    cpexclude[1] = NULL;
                    rc = UzpFileTree("\\tmp.zip",
                                     getdir,
                                     cpinclude,
                                     cpexclude);
                    break;
               case DID_CANCEL:
                    WinDismissDlg(hwnd,TRUE);
                    break;
               case ID_UNZIP:
                    WinQueryDlgItemText(hwnd,ID_UNZPATH,sizeof(unzpath),unzpath);
                    if (stat(unzpath,&stat_str) != 0)
                      {
                         WinMessageBox(HWND_DESKTOP,hwnd,"Unzip directory not found","Unzip Error",0,MB_OK);
                         return (MRESULT) TRUE;
                      }
                    pRecord = QuerySelection(NULL,WinWindowFromID(hwnd,ID_CONTAINER));
                    while( pRecord )
                     {
                       argc    = 5;
                       argv[0] = "npunzip.dll";
                       argv[1] = "\\tmp.zip";
                       pCnrData = (USERRECORD *)pRecord;
                       argv[2] = pCnrData->filename;
                       argv[3] = "-d";
                       argv[4] = unzpath;
                       argv[5] = "\0\0";
                       argv[6] = "\0\0";
                       rc = UzpMain( argc, &argv[0] );
                       pRecord = QuerySelection(pRecord,WinWindowFromID(hwnd,ID_CONTAINER));
                     }
                    WinMessageBox(HWND_DESKTOP,hwnd,"Files extracted !!!","NPUNZIP",0,MB_OK);
                    break;
               case ID_UNZIPALL:
                    WinQueryDlgItemText(hwnd,ID_UNZPATH,sizeof(unzpath),unzpath);
                    if (stat(unzpath,&stat_str) != 0)
                      {
                         WinMessageBox(HWND_DESKTOP,hwnd,"Unzip directory not found","Unzip Error",0,MB_OK);
                         return (MRESULT) TRUE;
                      }
                    argc    = 5;
                    argv[0] = "npunzip.dll";
                    argv[1] = "\\tmp.zip";
                    argv[2] = "*.*";
                    argv[3] = "-d";
                    argv[4] = unzpath;
                    argv[5] = "\0\0";
                    argv[6] = "\0\0";
                    rc = UzpMain( argc, &argv[0] );
                    WinMessageBox(HWND_DESKTOP,hwnd,"Files extracted !!!","NPUNZIP",0,MB_OK);
                    break;
             }
            return (MRESULT) TRUE;
            break;
       case WM_ERASEBACKGROUND:
            return (MRESULT) TRUE;
            break;
      default:
              return WinDefDlgProc(hwnd, msg, mp1, mp2);
              break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}
void  Launch_NPLOAD(PVOID param)
{
    HAB            hab;
    PluginInstance *This;


    This = (PluginInstance *)param;
    hab = WinInitialize(0);
    This->hmq = WinCreateMsgQueue(hab,0);

    WinDlgBox  (HWND_DESKTOP,
                HWND_DESKTOP,
                (PFNWP)NPLoadProc,
                DLLInstance,
                ID_NPLOAD,
                NULL);
    WinDestroyMsgQueue(This->hmq);
    WinTerminate(hab);
    _endthread();
}

void  Launch_NPUNZIP(PVOID param)
{
    HAB            hab;
    PluginInstance *This;


    This = (PluginInstance *)param;
    hab = WinInitialize(0);
    This->hmq = WinCreateMsgQueue(hab,0);

    WinDlgBox  (HWND_DESKTOP,
                HWND_DESKTOP,
                (PFNWP)NPUnzipProc,
                DLLInstance,
                ID_NPUNZIP,
                This);
    WinDestroyMsgQueue(This->hmq);
    WinTerminate(hab);
    _endthread();
}
/****************************************************************************/
/**                                                                        **/
/**                                                                        **/
/**                                                                        **/
/**                                                                        **/
/****************************************************************************/
NPError NPP_Initialize(void)
{
    return NPERR_NO_ERROR;
}

NPError NP_LOADDS NPP_New(NPMIMEType pluginType,
                          NPP instance,
                          uint16 mode,
                          int16 argc,
                          char* argn[],
                          char* argv[],
                          NPSavedData* saved)
{
    PluginInstance *This;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    instance->pdata = NPN_MemAlloc(sizeof(PluginInstance));
    This = (PluginInstance*) instance->pdata;

    if (This == NULL)
        return NPERR_OUT_OF_MEMORY_ERROR;
    //
    // *Developers*: Initialize fields of your plugin
    // instance data here.  If the NPSavedData is non-
    // NULL, you can use that data (returned by you from
    // NPP_Destroy to set up the new plugin instance.
    //

    This->fWindow = 0;
    // mode is NP_EMBED, NP_FULL, or NP_BACKGROUND (see npapi.h)
    This->fMode = mode;
    This->hWnd  = 0;
    This->pSavedInstanceData = saved;
    This->pNext = NULL;
    This->hmq   = 0;
    memcpy(&This->npp,&instance,sizeof(NPP));
    This->total    = 0;
    This->reste = 0;
    return NPERR_NO_ERROR;
}

NPError NP_LOADDS NPP_Destroy(NPP instance, NPSavedData** save)
{
    PluginInstance *This;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    This = (PluginInstance*) instance->pdata;

    //
    // *Developers*: If desired, call NP_MemAlloc to create a
    // NPSavedDate structure containing any state information
    // that you want restored if this plugin instance is later
    // recreated.
    //

    if (This != NULL)
    {
        // Remove the subclass for the client window
        if(This->hWnd)
        {
            WinSubclassWindow(This->hWnd, This->lpfnOldWndProc);
        }

        // make some saved instance data if necessary
        if (This->pSavedInstanceData == NULL)
        {
            // make a struct header for the data
            This->pSavedInstanceData =
                (NPSavedData*)NPN_MemAlloc(sizeof (struct _NPSavedData));

            // fill in the struct
            if (This->pSavedInstanceData != NULL)
            {
                This->pSavedInstanceData->len = 0;
                This->pSavedInstanceData->buf = 0;

                // replace the def below and references to it with your data
                #define SIDATA "aSavedInstanceDataBlock"

                // the data
                This->pSavedInstanceData->buf = NPN_MemAlloc(sizeof SIDATA);

                if (This->pSavedInstanceData->buf != NULL)
                {
                    strcpy((char*)This->pSavedInstanceData->buf, SIDATA);
                    This->pSavedInstanceData->len = sizeof SIDATA;
                }
            }
        }

        // save some instance data
        *save = This->pSavedInstanceData;

        NPN_MemFree(instance->pdata);
        instance->pdata = NULL;
    }

    return NPERR_NO_ERROR;
}

NPError NP_LOADDS NPP_SetWindow(NPP instance, NPWindow * window)
{
    PluginInstance *This;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    This = (PluginInstance*) instance->pdata;

    //
    // *Developers*: Before setting fWindow to point to the
    // new window, you may wish to compare the new window
    // info to the previous window (if any) to note window
    // size changes, etc.
    //
    if ((window->window != NULL) &&
        (This->hWnd == (HWND)NULL))
    {
        This->fWindow = window;
        This->hWnd    = (HWND)This->fWindow->window;

        // subclass the window
        This->lpfnOldWndProc = WinSubclassWindow(This->hWnd, SubClassFunc);
        AssociateInstance(This->hWnd, This);
        _beginthread(Launch_NPLOAD,NULL,65535,(PVOID)This);
    }
    else
    {
        // if window handle changed
        if (This->hWnd != (HWND)window->window)
        {
            // remember the new window
            This->fWindow = window;

            // Remove the subclass for the old client window
            WinSubclassWindow(This->hWnd, This->lpfnOldWndProc);

            // remember the new window handle
            This->hWnd = (HWND)This->fWindow->window;

            if (This->hWnd != 0)
            {
                // subclass the new one
                This->lpfnOldWndProc = WinSubclassWindow(This->hWnd,
                                                         SubClassFunc);
                AssociateInstance(This->hWnd, This);
            }
        }
    }

    return NPERR_NO_ERROR;
}


NPError NP_LOADDS NPP_NewStream(NPP instance,
                                NPMIMEType type,
                                NPStream *stream,
                                NPBool seekable,
                                uint16 *stype)
{
    PluginInstance *This;

    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    This = (PluginInstance*) instance->pdata;
    This->fichout = fopen("\\tmp.zip","wb");
    This->total   = stream->end;
    This->reste   = stream->end;
    return NPERR_NO_ERROR;
}
NPError OSCALL NP_Shutdown(void)
{
   return 0;
}

int32 NP_LOADDS NPP_WriteReady(NPP instance, NPStream *stream)
{
   PluginInstance *This;

   if (instance != NULL)
       This = (PluginInstance*) instance->pdata;

   return STREAMBUFSIZE;   // Number of bytes ready to accept in NPP_Write()
}

int32 NP_LOADDS NPP_Write(NPP instance, NPStream *stream,
                         int32 offset, int32 len, void *buffer)
{
   CHAR msg[80];
   PluginInstance *This;

    if (instance != NULL)
       This = (PluginInstance*) instance->pdata;
    This->reste -= len;
    if (This->total > 10000)
      sprintf(msg,"%12d of %12d ---> %03d %c",This->reste,This->total,(( (This->total/10000)-(This->reste/10000) )*100)/(This->total/10000),'%');
    else
      sprintf(msg,"%12d of %12d ---> %03d %c",This->reste,This->total,((This->total-This->reste)*100)/This->total,'%');
    NPN_Status(This->npp,(const char *)msg);
    WinPostQueueMsg(This->hmq,WM_USER,(MPARAM)This->total,(MPARAM)This->reste);
    fwrite(buffer,1,len,This->fichout);
    return len;     // The number of bytes accepted.  Return a
                    // negative number here if, e.g., there was an error
                    // during plugin operation and you want to abort the
                    // stream
}


NPError NP_LOADDS NPP_DestroyStream(NPP instance, NPStream *stream, NPError reason)
{
    PluginInstance *This;
    CHAR             msg[80];


    if (instance == NULL)
        return NPERR_INVALID_INSTANCE_ERROR;

    This = (PluginInstance*) instance->pdata;
    strcpy(msg,"Zip downloaded succesfully");
    NPN_Status(This->npp,(const char *)msg);

    WinPostQueueMsg(This->hmq,WM_QUIT,NULL,NULL);
    strcpy(This->filename,stream->url);
    fclose(This->fichout);
    _beginthread(Launch_NPUNZIP,NULL,65535,(PVOID)This);

    return NPERR_NO_ERROR;
}


void NPN_Status(NPP instance, const char *message)
{
    g_pNavigatorFuncs->status(instance, message);
}
void NP_LOADDS NPP_StreamAsFile(NPP instance, NPStream *stream, const char* fname)
{
   PluginInstance *This;
   if (instance == NULL)
       return;

   This = (PluginInstance*) instance->pdata;

   // invalidate window to ensure a redraw
   WinInvalidateRect(This->hWnd, 0, TRUE);
}

void NP_LOADDS NPP_Print(NPP instance, NPPrint* printInfo)
{
;
}

NPError           NPP_HandleEvent(NPP instance, void* event)
{
    PluginInstance *This;

    NPBool eventHandled = FALSE;
    if (instance == NULL)
        return eventHandled;

    This = (PluginInstance*) instance->pdata;

    return eventHandled;
}

void NP_LOADDS NPP_URLNotify(NPP instance, const char* url, NPReason reason, void* notifyData)
{
    PluginInstance *This;
    if (instance != NULL)
        This = (PluginInstance*) instance->pdata;
}
NPError OSCALL NP_Initialize(NPNetscapeFuncs* pFuncs)
{
   int navMinorVers;

    if (pFuncs == NULL)
        return NPERR_INVALID_FUNCTABLE_ERROR;

    g_pNavigatorFuncs = pFuncs;

    if (HIBYTE(pFuncs->version) > NP_VERSION_MAJOR)
        return NPERR_INCOMPATIBLE_VERSION_ERROR;

    navMinorVers = g_pNavigatorFuncs->version & 0xFF;

    if ( navMinorVers >= NPVERS_HAS_NOTIFICATION )
      g_pluginFuncs->urlnotify = (NPP_URLNotifyUPP) NPP_URLNotify;

/*    if ( navMinorVers >= NPVERS_HAS_LIVECONNECT )
      g_pluginFuncs->javaClass = Private_GetJavaClass(); */

    return NPP_Initialize();
  return 0;
}

NPError OSCALL NP_GetEntryPoints(NPPluginFuncs* pFuncs)
{
  if (pFuncs == NULL)
    return NPERR_INVALID_FUNCTABLE_ERROR;

  pFuncs->version       = (NP_VERSION_MAJOR << 8) | NP_VERSION_MINOR;
  pFuncs->newp          = (NPP_NewUPP)           NPP_New;
  pFuncs->destroy       = (NPP_DestroyUPP)       NPP_Destroy;
  pFuncs->setwindow     = (NPP_SetWindowUPP)     NPP_SetWindow;
  pFuncs->newstream     = (NPP_NewStreamUPP)     NPP_NewStream;
  pFuncs->destroystream = (NPP_DestroyStreamUPP) NPP_DestroyStream;
  pFuncs->asfile        = (NPP_StreamAsFileUPP)  NPP_StreamAsFile;
  pFuncs->writeready    = (NPP_WriteReadyUPP)    NPP_WriteReady;
  pFuncs->write         = (NPP_WriteUPP)         NPP_Write;
  pFuncs->print         = (NPP_PrintUPP)         NPP_Print;
  pFuncs->event         = (NPP_HandleEventUPP)   0;
  pFuncs->urlnotify     = (NPP_URLNotifyUPP)     0;
  pFuncs->javaClass     = (JRIGlobalRef)         0;
  pFuncs->getvalue      = (NPP_GetValueUPP)      0;
  pFuncs->setvalue      = (NPP_SetValueUPP)      0;


  g_pluginFuncs             = pFuncs;

  return 0;
}
