
const nsIFilePicker     = Components.interfaces.nsIFilePicker;
const FILEPICKER_CONTRACTID     = "@mozilla.org/filepicker;1";
var gPrefs;

function GetPrefsService()
{
  if (gPrefsService)
    return gPrefsService;

  try {
    gPrefsService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
  }
  catch(ex) {
    dump("failed to get prefs service!\n");
  }

  return gPrefsService;
}

function GetPrefs()
{
  if (gPrefsBranch)
    return gPrefsBranch;

  try {
    var prefService = GetPrefsService();
    if (prefService)
      gPrefsBranch = prefService.getBranch(null);

    if (gPrefsBranch)
      return gPrefsBranch;
    else
      dump("failed to get root prefs!\n");
  }
  catch(ex) {
    dump("failed to get root prefs!\n");
  }
  return null;
}

function Startup()
{
  gDialog.useSystemSettingsHelpers = document.getElementById("useSystemSettingsHelpers");
  gDialog.externalBrowser          = document.getElementById("externalBrowser");
  gDialog.browserChooseFile        = document.getElementById("browserChooseFile");
  gDialog.externalImageEditor      = document.getElementById("externalImageEditor");
  gDialog.imageEditorChooseFile    = document.getElementById("imageEditorChooseFile");

  try {
    gPrefs = GetPrefs();
  }
  catch (e) {
    dump("can't get pref service!");
  }

}


function showConnections()
{
  openDialog("chrome://editor/content/pref-connection.xul", "", "centerscreen,chrome,modal=yes,dialog=yes");
}

function selectFile(e)
{
  if (!e.hasAttribute("location"))
    return;

  var fp = Components.classes[FILEPICKER_CONTRACTID]
                     .createInstance(nsIFilePicker);

  var prefutilitiesBundle = document.getElementById("bundle_prefutilities");
  var title = prefutilitiesBundle.getString("choosefile");
  fp.init(window, title, nsIFilePicker.modeOpen);
  fp.appendFilters(nsIFilePicker.filterAll);

  var ret = fp.show();
  if (ret == nsIFilePicker.returnOK) {
    var folderField = document.getElementById(e.getAttribute("location"));
    var filePath = unescape(fp.fileURL.filePath);
    folderField.value = filePath;
  }
}
