ZUpload:
/* New: Lst das Float-Problem (<span statt <div) ++ 29.1.2010		++ */
/* New: Automatische Erstellung img.txt-Files				++ */
/* New: Verwendung des .png-Thumbnails					++ */
zzz_FS   = arg(1);  /* Diese Datei (inkl. Header) wird ...     */
FileSpec = arg(2);  /* ... unter diesem Std-Namen hochgeladen  */
TargPath = arg(3);  /* [ "" | '_content\<chapt>\<sect>\<subsct>\imagename.jpg' ]		*/
QDoZip   = ( arg(4)<>"NOZIP" );
Remote_SubDir = arg(5);	  /* [""| xxx ]		*/

TargPath = translate( TargPath, "/", "\" );	/* mach unix-gemen slash	*/

/* ------------------------------------------	*/
/* Ermitteln, was fr ein Datei-Typ vorliegt:	*/
/* ------------------------------------------	*/
posi = LastPos(".",zzz_FS);
FileExt = right(zzz_FS, length(zzz_FS) - posi);

ok = VRMethod("Application", "GetVar", "YGlob.YArtExt" ); /* "Art" */
ok = VRMethod("Application", "GetVar", "YGlob.YNwsExt" ); /* "Nws" */
ok = VRMethod("Application", "GetVar", "YGlob.YKysExt" ); /* "Kys" */
ok = VRMethod("Application", "GetVar", "YGlob.YFmtExt" ); /* "Fmt" */
ok = VRMethod("Application", "GetVar", "YGlob.YITxExt" ); /* "Image-Text" */
ok = VRMethod("Application", "GetVar", "YGlob.YProjDir"); /* "e:\data\html\spanien-tagebuch\" */

QArtikel = ( FileExt = YGlob.YArtExt ) | ( FileExt = YGlob.YNwsExt );
QLayout  = ( FileExt = YGlob.YKysExt );
QFormat  = ( FileExt = YGlob.YFmtExt );
QImgText = ( FileExt = YGlob.YITxExt );

/* ------------------------------------------	*/

BakDir = directory();

Call XSay "Generating upload-file.... "FileSpec;

Text_FNs.0 = 0;

if( \QDoZip ) then do
   LocalFile  = zzz_FS;		/* 27.11.2009	*/
   if FileSpec <> "" then	/* 27.11.2009	*/
      RemoteFile = FileSpec;	/* 27.11.2009	*/
   else;			/* 27.11.2009	*/
      RemoteFile = zzz_FS;	/* 27.11.2009	*/

   SIGNAL AROUND1;  /* skip gz-Verarbeitung 	*/
end;

nok = SysFileDelete(FileSpec);
if nok = 0 | nok = 2 then NOP;
else;do
   Err = "Unexpected error ('"nok"')";
   if nok =  5 then Err = "Access denied";
   if nok = 32 then Err = "Sharing violation";
   Call XSay "Error deleting upload-file '"FileSpec"': "Err"!";
   ok = directory(BakDir);
   RETURN 0;
end;

Rec = "";
if(QArtikel) then do 
   /* ----------------------				*/
   /* Special-Tags auflsen:				*/
   /* ----------------------				*/
   /* "<#- Type=SingImg " || LeftSide  Img_FN  Img_SubTit Img_Dims DsplWidth V#C#S#U -#>	*/
   pgui_ID1 = "<#- ";	/* Abstimmen mit phpGUI, PB_Img_Create, IPB_MoreLess			*/
   pgui_ID2 = " -#>";
   pgui_IDa1 = "<td><#- ";	/* alternativ in einer Tabellen-Column	*/
   pgui_IDa2 = " -#></td>";
   pgui_IDb1 = "<td> <#- ";	/* alternativ in einer Tabellen-Column	*/
   pgui_IDb2 = " -#></td>";

   QWas_Pretext = 0;
   do j=1 by 1 while lines(zzz_FS) > 0
      YSpecTag = 0;
      PrevRec = Rec;
      Rec = LineIn(zzz_FS);
      if left(Rec,length(pgui_ID1))  = pgui_ID1  then do;YSpecTag = 1; YInTD = 0; StartWord=2; end;
      if left(Rec,length(pgui_IDa1)) = pgui_IDa1 then do;YSpecTag = 1; YInTD = 1; StartWord=2; end;
      if left(Rec,length(pgui_IDb1)) = pgui_IDb1 then do;YSpecTag = 1; YInTD = 1; StartWord=3; end;
      if (YSpecTag) then do
         Call XSay "Found Special-Tag '" || word(Rec,2) || "'";

         Rec = Subword(Rec,StartWord, words(Rec)-2);	/* strip '<#- ... -#>'	*/
         Type = word(Rec,1);

         if(1) then say "Type="Type" (Rec="Rec")";

         if Type = "Type=More" ,
          | Type = "Type=Less" then
            Rec  = "<#- " || Rec || " -#>";		/* Wieder einklammern, weil auf dem Server verarbeitet!	*/


         if Type = "Type=Include" then do; Call Resolv_IncFile Rec, FileSpec, YInTD; 	ITERATE; end;
         if Type = "Type=SingImg" then do; Call Resolv_SingImg Rec, FileSpec, YInTD; 	ITERATE; end;
         if Type = "Type=ImgGal"  then do; Call Resolv_SingImg Rec, FileSpec, YInTD; 	ITERATE; end;
         if Type = "Type=ArtTops" then do;
	    /* Aufbauen "Tops.":					*/
	    Tops.0 = 1; 
	    Tops.1 = Rec;	/* hnlich wie bei SingImg		*/
	    do forever
		Rec = LineIn(zzz_FS);	/* einlesen Topic-Zeilen	*/
		if Rec = strip(pgui_ID2) then LEAVE;	/* '-#>'	*/
		a = Tops.0 +1;
		Tops.a = Rec;
		Tops.0 = a;
	    end;
            Call Resolv_ArtTops FileSpec, YInTD; 	/* Tops. is set */
  	    ITERATE;
         end;
         if Type = "Type=ArtSect" then do; 
            /*  <#- Type=ArtSect 1 Im Himmel ist Jahrmarkt -#>		*/
            SectType = word(Rec, 2);	/* z.Zt. unbenutzt		*/
            SectText = subword(Rec, 3, words(Rec)-2);
            HTML = "<p class=""ArtSect"">"SectText"</p class=""ArtSect""><p class=""artbody"" style=""margin-top:0px;"">\n";
            ok = LineOut(FileSpec, HTML);
 	    ITERATE;
         end;
         if Type = "Type=VertSpace" then do; 
            /*  <#- Type=VertSpace 69 -#>				*/
            Height = word(Rec, 2);
            if PrevRec <> "" then Aux = "</p>"; else; Aux = "";
            HTML = Aux||"<img src=""spacer.gif"" width=1 height="Height">\n";
            ok = LineOut(FileSpec, HTML);
 	    ITERATE;
         end;
         if Type = "Type=ImageBar" then do; 	/* Sept. 2011			*/
            /*  <#- Type=ImageBar [H|V][L|R] NumImgs=n TotalWidth=700 -#>	*/
            Orient  = left(word(Rec, 2),1);	/* H(orizontal) | V(ertical)	*/
            Side    = right(word(Rec, 2),1);	/* Left | Right Float		*/
            Rest    = Subword(Rec, 3);
	    parse value Rest with muell "=" NumImgs " " muell "=" TotalWidth " " Subtitle;


	    /* Stem 'ImgFiles.' aufbauen, aus dem stream auslesen:	*/
	    do a = 1 to NumImgs
	       Line = LineIn(zzz_FS);
	       parse value Line with muell "'" ImgFS "'" muell;  /* reinen Img-Subpath rausfiltern (_Content/tagebuch/2011/Sept/IMG_0751.JPG)    */
	       ImgFiles.a = ImgFS;
	    end;
	    ImgFiles.0 = NumImgs;

	    ok = ZVerteil_Images( TotalWidth, Orient, BorderWidth ); /* Flle ImgFiles. mit Werten (besorge Width / Height ) */

	    /* Nun den HTML-Code generieren:    */

	    FloatSide  = IfThenElse("Side='L'", "Left", "Right" );
	    marg_left  = IfThenElse("Side='L'", "-4", 10 );
	    marg_right = IfThenElse("Side='L'", "10", 0 );

	    BorderWidth = 1;
	    HTML = ZGen_FrameHdr( Side='L', "Picture", marg_left,marg_right,6,4,"",BorderWidth );


            if Orient = "H" then
	       HTML= HTML || "<tr>";

	    do a = 1 to ImgFiles.0
	       Thm_Width  = word(ImgFiles.a.Sizes,1);
	       Thm_Height = word(ImgFiles.a.Sizes,2);
	       Img_FS     = ImgFiles.a;

               if Orient = "V" then
	          HTML= HTML || "<tr>";

	       Img_Width  = 0; Img_Height = 0;
               ImgLink    = ,
		  "<a href=""Javascript:OpenWin('auxwin.php?V="V"&C="C"&S="S"&U="U"&What="Img_FS"',"Img_Width","Img_Height",'scroll');"">";

	       if a = ImgFiles.0 then Filler=0; else; do;  /* die letzte Kachel kriegt keine Auffllung mehr	*/
						   Filler = IfThenElse( "Orient = 'V'", 0, 6 );
						end;

	       Filler = IfThenElse( "Orient = 'V'", "style='padding-bottom:","style='padding-right:") || Filler || "px;'";

	       HTML= HTML   ,
	          || "<td width="Thm_Width Filler || ">"	,
		  || ImgLink "<img Name=""Picture"" src="Img_FS" width="Thm_Width" border=0></a></td>" || "0D"x;

               if Orient = "V" then
	          HTML= HTML || "</tr>";
	    end;
            if Orient = "H" then
	       HTML= HTML || "</tr>" || "0D"x;

	    if Subtitle <> "" then
	       HTML= HTML || "<tr><td colspan=" || IfThenElse("Orient='H'",NumImgs,1) || " align='center'>"Subtitle"</td></tr>" || "0D"x;


	    HTML= HTML ,
	          || "</table></span>" || "0D"x;

            ok = LineOut(FileSpec, HTML);
 	    ITERATE;
         end;
      end;

      /* ------------------------					*/
      /* Abhandeln Pretext-Thema:					*/
      /* ------------------------					*/
      /* Reihenfolge wichtig!						*/
      if Rec = "0D0A"x & (QWas_Pretext) then do
         /* Pretext-Absatz abschlieen:					*/
         Rec = "</p class='pretext'><p class=""artbody"">" || Rec;
         QWas_Pretext = 0;
      end;
      if j = 2 then do	/* ++ skip Header-Record (der mit den 	)	*/
         /* Erster Absatz: Pretext definieren:				*/
         if FileExt = YGlob.YArtExt then do	/* kein 'pretext' bei News!!	*/
            Rec = '<p class="pretext">' || Rec;
            QWas_Pretext = 1;
         end;
      end;

      ok = LineOut(FileSpec, Rec);	/* unverndert ausgeben		*/
   end;
end;

if (QLayout) | (QFormat) then 
   FileSpec = zzz_FS;


ok = stream(FileSpec, "c","close");
ok = stream(zzz_FS,   "c","close");

/* ---------------------------  */
/* Step-2: Packen (gz-Format):  */
/* ---------------------------  */

if \LoadDLL('RXGZLIB', 'rxgzLoadFuncs') then do  /* Lib zum Erzeugen eines gzip-Formates  */
   Call XSay "RXGZLIB not found - transferring data uncompressed";
   LocalFile  = FileSpec;
   FileType = ".uc";  /* (uncompressed)  */
end;
else;do
   Call XSay "Making gz-file....";

   FileType = ".gz";

   gzipFile = FileSpec||FileType;

   Option = "9";   /* Max. compression-rate                    */
   rc = rxgzDeflateFile(FileSpec, gzipFile, Option);    /* 0=ok */
   ok = SysSleep(1);
   if rc <> 0 then do
      Call Xsay "Sysfail - unable to create gz-file for upload '"gzipFile"' upload abandoned!";
      ok = directory(BakDir);
      RETURN -1;
   end;

   Call XSay "Making gz-file....done! ("rc")",,"REPL";

   Call XSay "Uploading "gzipFile"....";
   LocalFile  = gzipFile;
end;

/* ---------------------------  */
/* Step-3: Uploading xx_File:   */
/* ---------------------------  */

/* ZFTP_Logon() ist schon ausserhalb passiert			*/

RemoteFile = filespec("name",LocalFile);

/* ---------------------------  */
/* Nun Datei hochladen:         */
/* ---------------------------- */

AROUND1:

if (QImgText) then do
   /* .txt-Datei kennzeichnen als 'explizit erstellter Inmage-Text',  	*/
   /* der nicht durch die SingImg-Automatik berschrieben werden darf	*/

   nok = SysPutEA( zzz_FS, "TxtType", "explicite" );

   Call XSay "nok="nok" fr PutEA in Datei="zzz_FS"!";
   Mode = "ASCII";
end;
else;
   Mode = "Binary";

/* ------------------------------------------------             */
/* Zuerst Ziel-Pfad auf dem Remote Server bestimmen             */
/* ------------------------------------------------             */

if Remote_SubDir = "" then
   Remote_SubDir = VRGet("EF_Act_HTTPDir","Value") || VRGet("EF_Act_RPath","Value");

Remote_SubDir = strip(Remote_SubDir,"T","/") || "/";  /* immer mit / enden	*/
Remote_SubDir = "/" || strip(Remote_SubDir,"L","/");  /* immer mit / beginnen	*/

Call XSay "Einloggen in Remote_SubDir="Remote_SubDir", TargPath="TargPath"!";

ok = FtpChDir(Remote_SubDir);ok = ZFTPAfter("Initial ChDir",Remote_SubDir);

if( TargPath <> "" ) & ,
 ((\QArtikel) & (\QFormat)) then do		/* nur bei Images   */

   /* -----------------------------------                           */
   /* Remote-Dir: Bestandteile ermitteln:                           */
   /* -----------------------------------                           */
   Drop RemoteDirs.;
   RemoteDirs.0 = 0;
   Rest = TargPath;
   do i = 1 by 1 while Rest<>""
      parse value Rest with RemoteDirs.i "/" Rest;
   end;
   RemoteDirs.0 = i-1;

    do i = 1 to RemoteDirs.0

       ok = FtpChDir(RemoteDirs.i);ok=ZFTPAfter("ChDir",RemoteDirs.i);
       if ok<>0 then do
          /* ----------------------------------------------       */
          /* Fehler: Annahme: Path not found, also Anlegen:       */
          /* ----------------------------------------------       */
          Call XSay "Making remote directory="RemoteDirs.i"...";
          OK = FtpMkDir(RemoteDirs.i);ok=ZFTPAfter("MkDir",RemoteDirs.i);
          if ok = 0 then do
             /* wiederholen ChDir:                                */
             ok = FtpChDir(RemoteDirs.i);ok=ZFTPAfter("ChDir",RemoteDirs.i);
          end;
	  else;
	     Call XSay "Error making dir on remote server, code="ok"!";

       end;
    end;

end;

rc = FtpPwd("RemoteDir");ok=ZFTPAfter("Pwd",RemoteDir);
Call XSay "Uploading '"LocalFile"' to" RemoteDir;

ok = SysFileTree(LocalFile,"files.","F");
if files.0 <> 1 then do
   say "BakDir="BakDir"!";
   Call Xsay "Sysfail - '"LocalFile"' not found!";
   ok = directory(BakDir);
   RETURN -1;
end;

say "Before upload: Text_FNs.0="Text_FNs.0"!";

rc = FtpPut(LocalFile,RemoteFile,Mode);nok=ZFTPAfter("Put",RemoteFile);
if nok <> 0 then do
   Call Xsay "rc="rc", PUT fr Datei '"LocalFile"' nach '"RemoteFile"' nicht erfolgreich ("ZFTPErr(FTPERRNO)")";
   nok = 1;
end;
else;do
   if ( FileType = "PHP" ) then do 	/* kommt hier eigentlich nie (?) vor ... */
   
      QuoteString = "site chmod 777 "RemoteFile;
      Call XSay "Setting attribute to executable...("QuoteString")";
      rc = FtpQuote(QuoteString);nok=ZFTPAfter("quote site chmod",RemoteFile);
      if nok <> 0 then do
         Call Xsay "rc="rc", QUOTE(Chmod) failed for file "RemoteFile" ("ZFTPErr(FTPERRNO)")";
         nok = 1;
      end;
      else;do
        /* File erfolgreich uploaded:                              */
        Call Xsay "Upload '"LocalFile"' to '"RemoteFile"' successful";
      end;
   end;


   /* ---------------------------------------------	*/
   /* Automatisch erstellte .txt-Files hochzuladen?	*/
   /* ---------------------------------------------	*/

   if Text_FNs.0 > 0 then do
      do i = 1 to Text_FNs.0

	 /* lokalen vollstndigen Pfad der zuvor generierten .txt-Datei ermitteln:	*/
	 if(QArtikel) then   /* kommt nur bei Artikel vor (?)	*/
	   Path = filespec("drive",zzz_FS) || filespec("path",zzz_FS);

	 LocTxtFile  = Path || Text_FNs.i;

	 /* direkt ins Ziel-Verzeichnis (geht also auch OHNE dirweise einloggen):	*/
	 RemTxtFile = TargPath || Text_FNs.i;
	 call XSay "Upload automatically generated image-description-file '"LocTxtFile"':";

	 rc = FtpPut(LocTxtFile,RemTxtFile,"ASCII");nok=ZFTPAfter("Put",RemTxtFile);
	 if nok <> 0 then do
	    Call Xsay "rc="rc", PUT fr Datei '"LocalFile"' nach '"RemoteFile"' nicht erfolgreich ("ZFTPErr(FTPERRNO)")";
	    nok = 1;
	 end;
	 else;do
	    Call XSay "Image-Text-File successfully created and uploaded";
         end;
	 /* Nach dem Upload lschen der automatisch erstellten .txt:	*/
	 NOP; /* no more */
      end;
   end;

end;
/* ---------------------------  */

say "NOK="NOK"!";
return \NOK RemoteFile;		/* Zurck zum Caller: 1: OK	*/


/* ---------------------------	*/
/* Log. Subroutines:		*/
/* ---------------------------	*/


/* ---------------------------	*/
Resolv_IncFile:
Rec     = arg(1);
OutFile = arg(2);

MacroFile = word(Rec,2);	/* hinter 'Type=Include'	*/

do while lines(MacroFile) > 0
   ok = LineOut(OutFile, Linein(MacroFile));
end;
ok = stream(MacroFile,"c","close");

return 0;

/* ---------------------------	*/
Resolv_SingImg: Procedure Expose TargPath zzz_FS Text_FNs.;	/* Auch: Type=ImgGal ++ !!	*/
Rec     = arg(1);
OutFile = arg(2);
YInTD   = arg(3);

/* ggf. Restmll beseitigen:	*/

if translate( right(Rec,8) ) = "-#></TD>" then
   Rec = left( Rec, length(Rec)-8 );


/* Default-Werte:		*/

marg_left  = 10;
marg_right = 10;
marg_bot   = 10;
marg_top   = 4;


/*   <#- Type=SingImg 0[,NOFR] DonZippo.jpg 100#102 100[,6] T1#16## margs:L,R,B,T Lutz "Don Lucio" Wagner B -#>	*/
/* auch:	*/
/*   <#- Type=ImgGal  0[,NOFR] 1stImage.jpg 100#102 100[,6] T1#16## margs:L,R,B,T Bildergalerie starten B -#>	*/

     What        = word(Rec,1);	/* { Type=SingImg | Type=ImgGal }		*/
     parse value What with What "=" Type;
     QIs_ImgGal  = ( translate(Type) = "IMGGAL" );

     FrameDef    = word(Rec,2);	/* {1|0}	*/
     Img_FN      = word(Rec,3);
     Img_Dims    = word(Rec,4);
     DsplWidth   = word(Rec,5);	/* Thmbnail-Image-Width [, Text-Margin]		*/
     VCSU        = word(Rec,6);

     Img_FN      = translate( Img_FN, "/", "\" );	/* mach unix-gemen slash (nur bei Galery relevant (_Gal1/xxxx)	*/

     Img_FS = TargPath || Img_FN;	/* Append rel. Path auf dem Server	*/

     /* Schauen, ob Frame-Options vorhanden:					*/
     parse value FrameDef with 		,
			LeftSide "," 	,
			FrameOpt;

     /* ggf. neue Version, d.h. ab hier neuer Parameter 'margs:...' und somit Verschiebung um 1 word:		*/
     if pos("margs:", Rec) > 0 then do
        parse value word(Rec,7) with lit ":" marg_left "," marg_right "," marg_bot "," marg_top;
        Schieb = 1;
     end;
     else;
        Schieb = 0;

     Img_SubTit  = Subword(Rec, 7+Schieb);
     Img_TxtAlgn = Subword(Img_SubTit, words(Img_SubTit) );
     Img_SubTit  = Subword(Img_SubTit, 1, words(Img_SubTit)-1);	/* [ "B"ottom | "R"ight | "L"eft ]		*/

     parse value Img_Dims with Img_Width "#" Img_Height;
     parse value DsplWidth with DsplWidth "," TxtMarg;	/* Randbereich, in dem sich der Bildtext ausdehnen kann	*/
     parse value VCSU with V "#" C "#" S "#" U;

     /* ----------------------------     */
     /* X/Y-Dimens besorgen:             */ /* wenn nicht (alt!) diese schon mitgeliefert wurden		*/
     /* ----------------------------     */
     if VERIFY(Img_Width,'1234567890') > 0 then do
	ImgFSpec = filespec("drive",zzz_FS) || filespec("path",zzz_FS) || Img_FN;
        Data = X_GetImgSize( ImgFSpec );   
        Img_Width  = word(Data,1);  /* Pixels   */
        Img_Height = word(Data,2);  /* Pixels   */
	if left(Img_Width,6) = "Error!" then do
	   Call XSay "Cannot obtain image-dimensions - abort upload";
	   EXIT 0;
	end;
     end;

     /* Display-Width automatic?	*/
     if VERIFY(DsplWidth,'1234567890') > 0 then
        DsplWidth = Img_Width;		/* dann nimm die echte Bildbreite	*/

     Img_Width  = Img_Width  + 30;	/* plus etwas Rand	*/
     Img_Height = Img_Height + 50;	/* plus etwas Rand	*/

     Gal_Width  = 1000;			/* besser: sollte dynamisch abgefragt werden	*/
     Gal_Height = 700;			/* besser: sollte dynamisch abgefragt werden	*/

     if TxtMarg = "0" then
        ImgLink = "";
     else;do
        if( QIs_ImgGal ) then
           ImgLink = "<a href=""Javascript:OpenWin('galery.php?V="V"&C="C"&S="S"&U="U"&What=Thumbs&gal="filespec("path",Img_FS)"&CurPage=1',"Gal_Width","Gal_Height",'scroll');"">";
        else;
           ImgLink = "<a href=""Javascript:OpenWin('auxwin.php?V="V"&C="C"&S="S"&U="U"&What="Img_FS"',"Img_Width","Img_Height",'scroll');"">";

     end;

     if TxtMarg = "" then do	/* '0' bedeutet: kein Link, nur das reine Image		*/
        if Img_TxtAlgn = "B" then TxtMarg = 0;	/* unten braucht's kein Extra-Space	*/
        if Img_TxtAlgn = "L" ,
         | Img_TxtAlgn = "R" then TxtMarg = 30;	/* Default-Platz links od. rechts	*/
     end;

     CellPadd = 4;

     say "DsplWidth="DsplWidth",TxtMarg="TxtMarg",Img_TxtAlgn="Img_TxtAlgn"!";

     TotalWidth = DsplWidth + TxtMarg + 2*CellPadd;

     HTML = "";

     if translate(FrameOpt) = "NOFR" then do
        BordWidth = "0";
        BordColr = "white";
     end;
     else;do
        BordWidth = "1";
        BordColr = "#edE8FF";
     end;

     if (YInTD) then
        HTML = HTML || "<td>";

     if( QIs_ImgGal ) then DivName = "Galery";		/* DivName: Ist gar keine <div mehr, sondern <span			*/
                      else DivName = "Picture";

     HTML = HTML ,
 	 || ZGen_FrameHdr( (LeftSide), DivName, marg_left,marg_right,marg_bot,marg_top, FrameOpt, BordWidth, BordColr, TotalWidth ); /* <span float ...><table>	*/


     /* Bestimmen Thmb_FS (speziell auf Server generierte Version des Thumbnail, in .png): */
     Posi = Lastpos( ".", Img_FS );
     Thmb_FS = left( Img_FS, Posi-1 ) || ".png";

     if Img_TxtAlgn = "B" then do	/* Text nach Bottom	*/
        HTML = HTML || "<tr><td align=center style=""padding-bottom:0;"">";
        HTML = HTML || ImgLink;
        HTML = HTML || "<img Name=""Picture"" src='"Thmb_FS"' width=" || DsplWidth || " border="BordWidth"></a></td></tr>";
        HTML = HTML || "<tr><td Name=""PicTitle"" valign=top align=center style=""font-size:7pt; padding-top:0;""> "Img_SubTit" </td></tr>";
     end;
     if Img_TxtAlgn = "R" then do	/* Text nach Right	*/
        HTML = HTML || "<tr>";
        HTML = HTML || "<td>"ImgLink;
        HTML = HTML || "    <img Name=""Picture"" src='"Thmb_FS"' width=" || DsplWidth || " border="BordWidth || "></a></td>";
        HTML = HTML || "<td Name=""PicTitle"" valign=top align=left style=""font-size:7pt;""> "Img_SubTit" </td>";
        HTML = HTML || "</tr>";
     end;
     if Img_TxtAlgn = "L" then do	/* Text nach Left	*/
        HTML = HTML || "<tr>";
        HTML = HTML || "<td Name=""PicTitle"" valign=top align=right style=""font-size:7pt;""> "Img_SubTit" </td>";
        HTML = HTML || "<td>"ImgLink;
        HTML = HTML || "    <img Name=""Picture"" src='"Thmb_FS"' width=" || DsplWidth || " border="BordWidth || "></a></td>";
        HTML = HTML || "</tr>";
     end;

     if( QIs_ImgGal ) then do
        if Img_TxtAlgn = "B" then Colspan=1;	/* Text nach Bottom	*/
        if Img_TxtAlgn = "R" then Colspan=2;	/* Text nach Right	*/
        if Img_TxtAlgn = "L" then Colspan=2;	/* Text nach Left	*/

	FlashLink = "<a href=""Javascript:OpenWin('galery.php?V="V"&C="C"&S="S"&U="U"&What=smpvw&gal="filespec("path",Img_FS)"',"Gal_Width","Gal_Height",'scroll');"">";

        HTML = HTML || "<tr><td colspan="Colspan" align=center>"ImgLink"<img src=""_Content/zurgalery.jpg"" border=0></a></td><td>"FlashLink"<img src=""_Content/flash.jpg"" border=0></a></td></tr>";

     end;

     HTML = HTML || "</table>";
     HTML = HTML || "</span Name="DivName">";

     if (YInTD) then
        HTML = HTML || "</td>";
     else;do
        if (LeftSide) & (0) then
           HTML = HTML || "<p class=""artbody"">";	/* einleiten neuen (folgenden) Artikel-Absatz	*/
     end;

     ok = LineOut(OutFile, HTML);

     /* -------------------------------------------	*/
     /* Img_FN.txt erstellen falls nicht vorhanden:	*/
     /* -------------------------------------------	*/
     posi = lastpos(".",Img_FN);
     Netto_FN = left(Img_FN, posi);
     Text_FN = Netto_FN || "txt";	/* .txt		*/

     Text_FS = filespec("drive",zzz_FS) || filespec("path",zzz_FS) || Text_FN;
     Auto_Txt = 0;	/* dann hier nix weiter tun	*/

     Text_FS  = translate( Text_FS, "\", "/" );	/* mach OS/2-gemen slash (falls lokales Subdir)	*/

     nok = SysGetEA( Text_FS, "TxtType", "TxtType" );

     if ( (Img_SubTit <> "") & (TxtType != "explicite") ) then do
	Old_Content = CharIn(Text_FS,1,Chars(Text_FS)); 

        say "Old_Content="Old_Content",Img_SubTit="Img_SubTit"!";
	ok = stream(Text_FS,"c","close");
	if Img_SubTit <> Old_Content then do	/* hat sich der Begleittext gendert?	*/
	   ok = SysFileDelete( Text_FS );
	   ok = CharOut( Text_FS, Img_SubTit );
	   Auto_Txt = 1;
	   ok = stream(Text_FS,"c","close");
	end;
     end;

     /* speichern fr spteres hochladen:	*/
     if Auto_Txt = 1 then do
	a = Text_FNs.0 +1;
	Text_FNs.a = Text_FN;
	Text_FNs.0 = a;
     end;

return 0;

/* ---------------------------	*/
Resolv_ImgGal:
say "verlegt nach Resolv_SingImg()";
return 0;

/* ---------------------------	*/
Resolv_ArtTops: Procedure Expose TargPath zzz_FS Tops.;
OutFile = arg(1);
YInTD   = arg(2);

/*
   Tops.1 = 'Type=ArtTops 0 <ListType> width#MargL#MargR 
   Tops.2 = 'Topic-Text-1 ...... '
   Tops.3 = 'Topic-Text-2 ...... '
   Tops.n = 'Topic-Text-n ...... '
*/


Rec = Tops.1;

parse value Subword(Rec, 4) with Width "#" MargL "#" MargR;
ListType    =  word(Rec, 3);		/* ["ol"|"ul"]	*/
LeftSide    = (word(Rec, 2) = 0);

LabelName = "Topic";	/* ++ abstimmen mit VRX		*/

HTML = "<a Name="LabelName"0>\n";

if (LeftSide) then
    HTML = HTML || "<div Name=""Topics"" style=""float:left; margin-right:"MargR"px; margin-left:"MargL;
else;
    HTML = HTML || "<div Name=""Topics"" style=""float:right; margin-left:"MargL"px; margin-right:"MargR;


HTML = HTML || "px; padding:12px; border:1px solid blue; width:"Width";"">";

HTML = HTML || "<p style=""font-weight:600; background-color:blue; color:white;"">&nbsp;<i>Inhalt:</i></p>\n";

HTML = HTML || "<"ListType">\n";

do i = 2 to Tops.0
    Label = LabelName || i-1;
    HTML = HTML || "<li><a href=""#"Label""">"Tops.i"</a></li>\n";
end;

HTML = HTML || "</"ListType"></div Name=""Topics"">";

HTML = HTML || "<br style=""clear:both"" />\n";	  /* Umbruch vor den folgenden Section-Headers	*/

if (LeftSide) then
   HTML = HTML || "<p class=""artbody"">";	/* einleiten neuen (folgenden) Artikel-Absatz	*/

ok = LineOut(OutFile, HTML);

return 0;

/* --------------------------------------------------------------	*/
/* -------------- ZVerteil_Images: -----------------------------	*/
/* --------------------------------------------------------------	*/
ZVerteil_Images: Procedure Expose YGlob. ImgFiles.;

/* Create an Image-Bar      ++ z.Zt. nur horizontal ++

   Bilderleiste mit einer Anzahl von Images, deren Thumbnails so eingepasst
   werden, dass die Hhe gleich ist und die Breite so, dass die vorgegebene
   TotalWidth ausgefllt wird.

   Die Hhe der Bilderleiste ist variabel, d.h. sie ergibt sich erst aus dieser Routine.

*/

TotalWidth  = arg(1);
Orient      = arg(2);

/* --------------------------------------------------------------	*/
/* Runde-1: TotalRatio ermitteln (Summe aller Seitenverhltnisse)	*/
/* --------------------------------------------------------------	*/
TotalRatio = 0;
do i = 1 to ImgFiles.0
   Ratio = ZVerteil_Images_1( i );
   TotalRatio = TotalRatio + Ratio;
end;
say "TotalRatio="TotalRatio"!"

/* --------------------------------------------------------------	  */
/* Runde-2: Effektive (neue) Breite + Hhe ermitteln			  */
/* --------------------------------------------------------------	  */
say left("",60,"=");
do i = 1 to ImgFiles.0
   if Orient = "H" then do
      Width = ZVerteil_Images_2( i );
      Height = Width / word(ImgFiles.i.Sizes,3);  /* Y_Size * Ratio	*/
   end;
   else;do
      Height = ZVerteil_Images_2( i );
      Width = Height / word(ImgFiles.i.Sizes,3);  /* X_Size * Ratio	*/
   end;
   
   say (Orient = "H") "Width=" || ZRound(Width) || ",Height=" || ZRound(Height) || "!"
   ImgFiles.i.Sizes = ZRound(Width) ZRound(Height); /* Now: Thumb-Sizes! */
end;

RETURN 0; /* ImgFiles. is set                     */

/* =========================================================	*/
ZVerteil_Images_1: Procedure Expose YGlob. ImgFiles. Orient;
i = arg(1);

Image_FS = YGlob.YProjDir || ImgFiles.i;

Image_FS = translate(Image_FS,"\","/");

GBM_Path = SysSearchPath("PATH","gbmsize.exe");
if GBM_Path = "" then
   GBM_Path = SysSearchPath("GBM","gbmsize.exe");
if GBM_Path = "" then do
   ok = VRMessage( VRWindow(), "No path for GBM found - abort", "_ZUpload.cmd, ZVerteil_Images()", "E" );
   exit 0 "No path for GBM found - abort";
end;

ImgDim = X_GetImgSize( Image_FS, GBM_Path );	/* mu ins Config.sys: SET GBM=.;F:\GBM.163;	*/
X_Size = word(ImgDim,1);
Y_Size = word(ImgDim,2);

if Orient = "H" then
   Ratio = X_Size / Y_Size;
else
   Ratio = Y_Size / X_Size;

ImgFiles.i.Sizes  = X_Size Y_Size Ratio;	/* X_Size Y_Size not needed!	*/

return Ratio;

/* =========================================================	*/
ZVerteil_Images_2: Procedure Expose ImgFiles. TotalRatio TotalWidth Orient;
i = arg(1);

X_Size = word(ImgFiles.i.Sizes,1);	/* not needed here!	*/
Y_Size = word(ImgFiles.i.Sizes,2);	/* not needed here!	*/
Ratio  = word(ImgFiles.i.Sizes,3);

Frac = (Ratio / TotalRatio ) *100;

   if Orient = "H" then do
      Width = TotalWidth * ( Frac / 100 );
      return Width;
   end;
   else;do
      Height = TotalWidth * ( Frac / 100 );
      return Height;
   end;



/* ==============================================	  */
ZRound: Procedure;  /* aufrunden                    */
What = arg(1);
return (What+0.5)%1;
nop;nop;


/* ---------------------------	*/
XSay: Procedure;
What = strip(arg(1));
Text = strip(arg(2));
if What = "" ,
 | What = "TOF" ,
 | What = "BOF" then RETURN "";

say date()"-"substr(time(),1,8)"=>"Text What;
return Text What;

/* --------------------	*/
ZFTPAfter: procedure Expose FTPErrno;
What = arg(1);
Parm = arg(2);

/* -------------------------------------------------------------------  */
/* ZFTPAfter: Allgemeine ftp-errno-Auswertung:                          */
/* -------------------------------------------------------------------  */

if FTPErrno <> 0 then do
   Call Xsay "Error nach "What"/"Parm": "ZFTPErr(FTPErrno)"!";
end;
else;
   Call Xsay "Successful completion of "What"/"Parm"!";

return FTPErrno;

/* -------------------------            */
/* ZFTPErr:                             */
/* -------------------------            */
ZFTPErr: procedure
Errno = arg(1);

Select
  WHEN      Errno = "FTPSERVICE"   THEN do;Return "unknown service";end;
  WHEN      Errno = "FTPHOST"      THEN do;Return "unknown host";end;
  WHEN      Errno = "FTPSOCKET"    THEN do;Return "unable to obtain socket";end;
  WHEN      Errno = "FTPCONNECT"   THEN do;Return "unable to connect to server";end;
  WHEN      Errno = "FTPLOGIN"     THEN do;Return "login failed";end;
  WHEN      Errno = "FTPABORT"     THEN do;Return "transfer aborted";end;
  WHEN      Errno = "FTPLOCALFILE" THEN do;Return "problem openning local file";end;
  WHEN      Errno = "FTPDATACONN"  THEN do;Return "problem initializing data connection";end;
  WHEN      Errno = "FTPCOMMAND"   THEN do;Return "command failed (prpbly file not found)";end;
  WHEN      Errno = "FTPPROXYTHIRD"THEN do;Return "proxy server does not support third party transfers";end;
  WHEN      Errno = "FTPNOPRIMARY" THEN do;Return "no primary connection for proxy transfer";end;
  OTHERWISE
      do;Return "<unknown FTP-returncode> "Errno;end;

return 0;

IfThenElse:
_If   = arg(1);
_Then = arg(2);
_Else = arg(3);

_Z = "Cond = (" _If ");";   interpret _Z;

if (Cond) then return _Then;
          else return _Else;

nop;

/* ==============================================	*/
ZGen_FrameHdr: Procedure Expose YGlob.;
LeftSide   = arg(1);	/* [ 0 | 1 ]			*/
DivName    = arg(2);  /* [ "Picture" | "Galery" ]	*/
marg_left  = arg(3);
marg_right = arg(4);
marg_bot   = arg(5);
marg_top   = arg(6);
FrameOpt   = arg(7);	/* [ "" | "NOFR" ]	*/
BordWidth  = arg(8);
BordColr   = arg(9);
Width      = arg(10);

if BordWidth <= 0 then do; BordWidth=0;BordColr='white';end;

if Width > "" then Width = " width='"Width"'";

CellPadd = 1;	/* war mal 4			*/

HTML = "";

     if (LeftSide) then
        HTML = HTML || "<span Name="DivName" style=""float:left; margin-right:"marg_right"px; margin-left:"marg_left;
     else;
        HTML = HTML || "<span Name="DivName" id=""floatR"" style=""float:right; margin-left:"marg_left;


     HTML = HTML || "px;margin-top:"marg_top"px;margin-bottom:"marg_bot"px; padding:0px;"">";

     HTML = HTML || "<table border=0 cellspacing=0 cellpadding="CellPadd" style=""border:"BordWidth"px solid #223322; background-color:"BordColr";""" || Width">";

return HTML;
