extproc sh awf.cmd
# OS/2 version
shift			# extra argument added by CMD.EXE to extproc

# AWFLIB is where the pieces live
AWFLIB=c:/bin/awf

pass2=$TMP/awp$$	# tempfile for building pass 2
errs=$TMP/awe$$		# error messages (awk can't send to stderr)
input=$TMP/awi$$	# tempfile for input file(s)

case "$1" in
-ms)	mac=ms	;;
-man)	mac=man	;;
*)	echo "$0: must specify -ms or -man" >&2
	exit 2
	;;
esac

shift

dev="$AWFLIB/$TERM.dev"

if test ! -r $dev
then
	dev="$AWFLIB/dumb.dev"
fi

# build the full, macro-set-dependent, pass-2 awk program

sed -n '1,/^#include/p' $AWFLIB/pass2 >$pass2
cat $AWFLIB/${mac}.p2 >>$pass2
sed -n '/^#include/,$p' $AWFLIB/pass2 >>$pass2

# do it

echo ".^x $errs" >$input
echo ".^b" >>$input
echo ".^# 1 <prolog>" >>$input

cat $dev $AWFLIB/common $AWFLIB/${mac}.mac >>$input

if test " $*" = " "
then
	echo ".^# 1 <stdin>" >>$input
	cat - >>$input
else
	for f
	do
		echo ".^# 1 $f" >>$input
		cat $f >>$input
	done
fi

echo ".^e" >>$input

gawk -f $AWFLIB/pass1 $input | gawk -f $pass2 | gawk -f $AWFLIB/pass3

# error messages, if any
if test -s $errs
then
	cat $errs >&2
	rm -f $pass2 $errs $input >nul
	exit 1
else
	rm -f $pass2 $errs $input >nul
	exit 0
fi
