.******************************************************************************
.*  Maul Publisher Bitmap Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.* 2004-11-29 : ch : synchronized HP_SAVESTYLE with English version
.******************************************************************************
:userdoc.
:title. Maul-Hilfe zum Bitmap-Handler
:docprof toc=1234.
:h1 res=1 id=intro.ber den Maul-Bitmap-Handler
:i1 id=all.ber den Maul-Bitmap-Handler
:p.:artwork name='bmphand.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul-Standard-Bitmap-Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.bersicht des Maul-Bitmap-Handlers:ehp2.
:p.Benutzen Sie diesen Handler, um Bilder in Rahmen einzufgen.
:p.Der Maul-Bitmap-Handler verwendet den OS/2 V2.0 Bitmap-Standard zur Anzeige von Bildern.
:p.Es knnen smtliche nicht-komprimierten Bitmaps und eine Reihe weiterer Bitmap-Standards importiert werden.
Einmal importiert, knnen Bitmaps skaliert, gedreht und gespiegelt werden. Auerdem kann aus
der Anwendung heraus ein breites Spektrum von Farb- und Helligkeitsanpassungen vorgenommen
werden. Desweiteren lassen sich bei Bitmaps mit bis zu 8 Bit pro Pixel (bis zu 256 Farben)
Bitmap-Farbpaletten bearbeiten.
:p.:hp2.Rasteroperationen:ehp2.
:p.Dieser Handler verwendet fr die Darstellung die Funktion GpiWCBitBlt. Das heit, da die
Grafik- und Druckertreiber fr normale Anwendung die folgenden Rasteroperationen
untersttzen mssen&colon.
:ul.
:li.Bei maskierten Bitmaps verwendet der Handler ROP_SRCAND und ROP_SRCPAINT.
:li.Bei normalen Bitmaps verwendet der Handler ROP_MERGECOPY mit einer leeren Muster-Bitmap.
Damit wird der SVGA-Grafiktreiber dazu gezwungen, Pixel nicht zu interpolieren. Das Problem dabei
ist natrlich, da, whrend der Grafiktreiber Pixel fr schne, aufrechte Bitmaps glttet, der
Druckertreiber dies nicht tut. Zudem knnen gedrehte oder maskierte Bitmaps nicht vom Grafiktreiber
geglttet werden. Um potentielle Probleme abzufangen, noch bevor sie auftreten knnen, kann
dieser Handler zur nderung seiner Rasteroperationen veranlat werden, indem leere Dateien
im Unterverzeichnis .\etc des Maul-Installationsverzeichnisses angelegt werden. Beim Programmstart
wird nach diesen Dateien gesucht.
:ul.
:li.Erstellen Sie die Datei 'srccpy.rop', um einfache Bitmap-Kopien ausfhren zu lassen.
:li.Erstellen Sie die Datei 'srcpnt.rop', um Bitmap-Kopien ber bitweises 'ODER' ausfhren zu lassen.
:li.Der Standardwert kann durch Lschen der beiden Dateien wiederhergestellt werden.
:eul.
:li.Werden beim Druckvorgang keine Rasteroperationen untersttzt, was beispielsweise der Fall ist,
wenn der Postscript-Druckertreiber verwendet wird, schafft der Handler Abhilfe. Dabei wird eine
Bitmap vorbereitet, welche die Bilder smtlicher unterhalb liegender Objekte sowie die eigentliche
Bitmap enthlt, und dann als normal bergelagertes Bild gedruckt. Dieses Verfahren kann mitunter
zu einer starken Verlangsamung des Druckvorgangs fhren. Darber hinaus werden eingebettete
Bilder mit Masken stets als normale Bitmaps mit weiem Hintergrund gedruckt.
:eul.
:p.Normalerweise sollten bei Verwendung der Voreinstellungen keine Probleme auftreten.
:p.:hp2.ber Auslagerung:ehp2.
:p.Dieser Handler ist in der Lage, eine Technik namens Auslagerung zu verwenden, die beim
Bearbeiten Speicher spart. Dies wird dadurch erreicht, da groe Bitmaps in einem separaten
Ordner gespeichert werden. Dieser Ordner wird mit demselben Namen wie dem des aktuellen
Dokumentes (ohne die .mpb-Erweiterung) erstellt und an derselben Stelle gespeichert.
Whrend man Bilder in das Dokument ldt, entscheidet das System, ob die Bitmap
getrennt von dem Dokument abgespeichert werden sollte, und generiert ntigenfalls
eine kleine Platzhaltergrafik, damit man das Bild immer noch sehen kann. Indem man
nderungen vornimmt, erstellt der Auslagerungsmechanismus Sicherheitskopien und
modifiziert die eigentlichen Bitmaps in voller Gre auf der Festplatte. Wenn die Auslagerung
benutzt wird, kommt es zu erhhter Festplattenaktivitt.
:p.Zur Aktivierung der Auslagerung mu das Markierungsfeld 'Groe Bitmaps auslagern'
unter 'Globale Stileinstellungen' im Men 'Optionen' ausgewhlt werden. Der Auslagerungsmechanismus ist
automatisch, aber man kann die ausgelagerten Bilder manuell durch Klicken auf
':link reftype=hd res=55.Ausgelagerte Bitmaps erneut laden:elink.' im Men 'Options'
aktualisieren lassen.
:p.:hp2.ber Masken:ehp2.
:p.Masken werden zur Erzeugung transparenter Hintergrnde in Bitmaps verwendet. Dieser Effekt ist
z.B. oft bei Symbolen oder Mauszeigern zu sehen. Maskierte Bitmaps knnen als berdeckung
ber anderen Bildern oder Text verwendet werden.
:p.Masken knnen von der Textformatierung dazu benutzt werden, den Text um die Form des Maskenbildes
herumflieen zu lassen. Dazu mssen Sie den Maskenumrandungsmodus im Rahmen-Handler aktivieren.
Schalten Sie in den Rahmenbearbeitungsmodus um, und aktivieren Sie die Option 'Maskenumrandung
aktivieren' im Meneintrag 'Objektmodi' des Mens 'Bearbeiten'. Damit dies funktioniert, mu sich
die maskierte Bitmap in der obersten Ebene (Ebene 0) des Rahmens befinden, der aus dem Textrahmen
ausschlieen soll.
:p.:hp2.Bildformate:ehp2.
:p.Dieser Handler ist mit Mauls eingebautem allgemeinen Import/Export-System kompatibel. Wenn
die erforderlichen Import- oder Exportmodule installiert sind, knnen Sie jedes untersttzte
Bitmap-basierte Bild einlesen.
:p.Dieser Handler kann *.ico-Symbolressourcen von OS/2 und Windows, OS/2-Mehrfach-Bitmaps,
alte OS/2-Kurz-Bitmaps, unkomprimierte Windows-Bitmaps der Arten *.bmp und *.dib sowie das native
Format der *.mbm-Dateien importieren.
:p.:hp2.Das native *.mbm-Bildformat:ehp2.
:p.Dieser Handler benutzt zur Speicherung von Bitmaps sein eigenes *.mbm-Bildformat, um bei der Auslagerung
alle zur Verfgung stehenden Bildoptionen zu erhalten. Das Format wird im folgenden erlutert, wobei
optionale Eintrge in [eckigen Klammern] angegeben werden.
:xmp.
"mbm"           //4 Bytes
checksum        //4 Byte-Prfsumme aller ULONGs von file+8 bis eof
BMPDATA3        //ein 44 Byte groer Header
BITMAPINFO      //Bild-Bitmap
[BITMAPINFO]    //Bild-Maske
["filename"]    //ein mit Null abgeschlossener Dateiname
:exmp.
Das BMPDATA3-Format ist in der Entwicklersektion von http&colon.//www.manglais.com erhltlich.
.br
.br
:p.Um von hier aus weitere Hilfe zu erhalten, whlen Sie 'Optionen', dann 'Inhalt' aus dem Men
dieses Hilfefensters. Es wird dann eine Auswahl von weiterfhrenden Hilfeinhalten angezeigt. Alternativ
knnen Sie die untere Schaltflche 'Index' bettigen, um ein Register aufzurufen.
:p.
.br
.br
:p.Erstellt von Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1998, 2001 Peter Koller, Maison Anglais. Alle Rechte vorbehalten.
:p.Details der Lizenzbestimmungen entnehmen Sie bitte dem Urheberrechtshinweis im Haupthandbuch 
des Maul Publishers.
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=10 id=10 global.Das Men Bearbeiten des Bitmap-Handlers
:i1 id=edit.Das Men Bearbeiten des Bitmap-Handlers
:p.Das Men Bearbeiten des Bitmap-Handlers enthlt grundliegende Meneintrge, wie man sie 
bei jedem Editor zu finden erwarten wrde, sowie ein paar fr Bitmaps spezifische. 
:p.Diese umfassen&colon.
:ul.
:li.Wie man Bitmaps :link reftype=hd res=12.ausschneidet:elink..
:li.Wie man Bitmaps :link reftype=hd res=13.kopiert:elink..
:li.Wie man Bitmaps :link reftype=hd res=14.einfgt:elink..
:li.Wie man Bitmaps :link reftype=hd res=100.ldt:elink..
:li.Wie man Bitmaps :link reftype=hd res=15.lscht:elink..
:li.Wie man die :link reftype=hd res=19.Originalgre der Bitmap:elink. verwendet.
:li.Wie man das :link reftype=hd res=20.Grenverhltnis der Bitmap:elink. beibehlt.
:li.Wie man den :link reftype=hd res=21.Bitmap-Kachelungsmodus:elink. setzt.
:li.Wie man die :link reftype=hd res=22.Bitmap-Position:elink. verankert.
:li.Wie man Bitmaps :link reftype=hd res=18.skaliert:elink..
:li.Wie man Bitmaps :link reftype=hd res=17.dreht:elink..
:li.Wie man einen Rahmen auf die Bitmap-Gre :link reftype=hd res=23.zuschneidet:elink..
:li.Wie man einen :link reftype=hd res=54.Bitmap-Stil:elink. festlegt.
:li.Wie man einen :link reftype=hd res=54.Bitmap-Stil:elink. sichert.
:li.Wie man den Bitmap-Handler von einem Rahmen :link reftype=hd res=11.entfernt:elink..
:eul.
:lm margin=1.
.*******************************************************************************
:h2 res=12 id=12 global.Bitmap ausschneiden und in Zwischenablage stellen
:i2 refid=edit.Bitmap ausschneiden und in Zwischenablage stellen
:p.Whlen Sie diesen Meneintrag, um die Bitmap in die Zwischenablage zu kopieren. Anschlieend
wird die Bitmap entfernt.
:p.Der Befehl Ausschneiden kann ber die Tastenkombination Umschalt + Entfernen ausgefhrt werden.
.*******************************************************************************
:h2 res=13 id=13 global.Bitmap in Zwischenablage kopieren
:i2 refid=edit.Bitmap in Zwischenablage kopieren
:p.Whlen Sie diesen Meneintrag, um die Bitmap in die Zwischenablage zu kopieren. Die Bitmap
wird nicht gelscht.
:p.Der Befehl Kopieren kann ber die Tastenkombination Strg + Einfgen ausgefhrt werden.
.*******************************************************************************
:h2 res=14 id=14 global.Bitmap aus Zwischenablage einfgen
:i2 refid=edit.Bitmap aus Zwischenablage einfgen
:p.Whlen Sie diesen Meneintrag, um eine Bitmap aus der Zwischenablage in den Rahmen einzufgen.
Eine bereits vorhandene Bitmap wird gelscht.
:p.Der Befehl Einfgen kann ber die Tastenkombination Umschalt + Einfgen ausgefhrt werden.
.*******************************************************************************
:h2 res=15 id=15 global.Bitmap lschen
:i2 refid=edit.Bitmap lschen
:p.Whlen Sie diesen Meneintrag, um die Bitmap zu lschen.
:p.Die Bitmap wird nicht in die Zwischenablage kopiert.
:p.Der Befehl Lschen kann ber die Taste Entfernen ausgefhrt werden.
.*******************************************************************************
:h2 res=19 id=19 global.Originalgre der Bitmap verwenden
:i2 refid=edit.Originalgre der Bitmap verwenden
:p.Der Bitmap-Handler verwendet zwei Skalierungsmethoden. Bei der ersten wird die Bitmap auf das kleinste
Rechteck verkleinert, in das der Rahmen pat. Jede weitere anschlieend ber den Dialog
:link reftype=hd res=18.Bild skalieren:elink. durchgefhrte Skalierung geschieht
zustzlich zu dieser anfnglichen.
:p.Durch Auswahl des Meneintrages 'Originalgre der Bitmap verwenden' kann diese anfngliche
Skalierung unterbunden werden. Andere Skalierungen und Drehung bleiben davon unberhrt.
.*******************************************************************************
:h2 res=20 id=20 global.Grenverhltnisse der Bitmap beibehalten
:i2 refid=edit.Grenverhltnisse der Bitmap beibehalten
:p.Der Bitmap-Handler benutzt zwei Skalierungsmethoden. Bei der ersten wird die Bitmap auf 
das kleinste Rechteck verkleinert, in welches der Rahmen pat. 
:p.Durch Auswahl des Meneintrags 'Grenverhltnisse der Bitmap beibehalten' werden bei 
dieser anfnglichen Skalierung die ursprnglichen Grenverhltnisse beibehalten. 
:p.Jede weitere ber den Dialog :link reftype=hd res=18.Bild skalieren:elink. durchgefhrte 
Skalierung kann die Grenverhltnisse ndern.
.*******************************************************************************
:h2 res=21 id=21 global.Bildkachelungsmodus setzen
:i2 refid=edit.Bildkachelungsmodus setzen
:p.Der Kachelungsmodus eignet sich fr Bilder, die einen Hintergrund ergeben sollen. Dieser Modus
hnelt stark dem Kachelungsmodus fr Fensterhintergrnde bei OS/2 Warp, weshalb Sie die mit dem System
ausgelieferten Bitmaps fr diesen Modus ntzlich finden werden.
:p.Wichtig dabei ist, da die Bitmap immer auf die Druckerauflsung skaliert wird. Whrend
gekachelte Bitmaps also gut in einem Bildschirmschoner aussehen, kann dieselbe Bitmap in Maul so
winzig sein, da nur Mll dabei herauskommt. Nur wenn man auf eine etwa dem Drucker entsprechende
Auflsung vergrert, erhlt man eine Ahnung der Details des Ergebnisses.
:p.Siehe auch :link reftype=hd res=18.Bild skalieren:elink..
.*******************************************************************************
:h2 res=22 id=22 global.Bitmap-Position verankern
:i2 refid=edit.Bitmap-Position verankern
:p.Wenn Sie die Position der Bitmap verankern, knnen Sie den Rahmen anpassen, um das Bild zuzuschneiden. 
Vergewissern Sie sich, da sich das Bild an der richtigen Stelle befindet, denn wenn Sie die Verankerung im 
folgenden wieder entfernen, springt es zum Objektmittelpunkt. 
:p.Eine verankerte Bitmap kann nicht verschoben werden, aber skaliert und gedreht. Wenn Sie das Bild 
innerhalb eines Polygons verschieben knnen mchten, benutzen Sie nicht diesen Modus, sondern justieren Sie 
die Bildgre ber manuelle Grennderung. Dann besteht die Mglichkeit, das Bild durch nderung des 
Objektmittelpunkts zu verschieben. Der Objektmittelpunkt kann mit Hilfe des Rahmen-Handlers angepat werden. 
:p.Der Verankerungsmodus aktiviert die Meneintrge 'Originalgre der Bitmap verwenden' und 
'Grenverhltnisse der Bitmap beibehalten' und reskaliert die Bitmap so, da ihre eigentliche 
Gre sich nicht zu ndern scheint. Wenn Sie darangehen, die Skalierung der verankerten Bitmap zu ndern, 
wird Ihnen vielleicht auffallen, da sich die Skalierungsfaktoren vollkommen gendert haben. Wenn Sie die 
Verankerung der Bitmap wieder aufheben, versucht die Funktion, die ursprnglichen Skalierungsfaktoren 
wiederherzustellen.
.*******************************************************************************
:h2 res=18 id=18 global.Bild skalieren
:i2 refid=edit.Bild skalieren
:p.:hp2.Skalierung auf Druckerauflsung erzwingen:ehp2.
:p.Dieser Meneintrag wird benutzt, um schnell einen vernnftigen Skalierungsfaktor zu erhalten.
In diesem Fall bedeutet vernnftig, da die Bitmap abhngig von der Druckerauflsung so skaliert wird,
da sie eine feste Anzahl von Punkten pro Inch (dpi) ergibt.&colon.
:ul.
:li.75dpi fr Drucker mit weniger als 300dpi.
:li.100dpi fr Drucker mit weniger als 600dpi.
:li.150dpi fr Drucker mit 600dpi und mehr.
:eul.
:p.In jedem Fall stehen dem Drucker fr die korrekte Darstellung kleiner Details wenigstens drei
Punkte zur Verfgung.
:p.Um wirklich genau diese Skalierung zu erhalten, mu auerdem der Meneintrag
':link reftype=hd res=19.Originalgre der Bitmap verwenden:elink.' aktiviert sein.
:p.:hp2.Alle Skalierungen zurcksetzen:ehp2.
:p.Benutzen Sie diesen Meneintrag, um alle mit dem Skalierungsdialog oder dem Meneintrag 'Skalierung
auf Druckerauflsung erzwingen' vorgenommenen Skalierungen zurckzunehmen. Skalierungen, die durch
das Einpassen der Bitmap in einen Rahmen verursacht wurden, sind nicht betroffen.
:p.:hp2.Skalierungsdialog:ehp2.
:p.Benutzen Sie den Dialog 'Bild skalieren...', um die Skalierung der Bitmap-Datei anzupassen. Bei der Skalierung 
handelt es sich um eine Grafiktransformierung, die unabhngig von anderen Skalierungsfaktoren durchgefhrt wird. 
Mit Hilfe des Skalierungsdialogs knnen Bilder skaliert und gespiegelt werden. 
:p.Verwenden Sie die Eingabefelder, um Hhe und Breite der erforderlichen Skalierungsfaktoren in Prozent 
anzugeben. Zur bequemeren Handhabung knnen Sie mit den Schaltflchen einen Anteil von 50% hinzufgen und abziehen. 
Negative Skalierungsfaktoren invertieren oder spiegeln das Bild. 
:p.Der Dialog bietet auerdem zwei Schieberegler zur Anpassung der Skalierungsfaktoren ber einen Gesamtbereich 
von 100%. 
:p.nderungen werden im Beispielbild angezeigt. Dieses Beispiel kann nur bei Skalierungswerten ber 100% einen 
Hinweis auf die Grenverhltnisse bieten. Das Bild wird dabei immer soweit verkleinert, da es in das 
Beispielfenster pat. 
:p.Drcken Sie 'Anwenden', um die nderungen auf die Bitmap-Datei anzuwenden, und 'Beenden', um den Dialog nach 
Abschlu der Arbeiten zu verlassen.
.*******************************************************************************
:h2 res=17 id=17 global.Bild drehen
:i2 refid=edit.Bild drehen
:p.Die Bildausrichtung setzt sich aus der Summe der Rahmenausrichtung und der Ausrichtung der Bitmap 
zusammen. Standardmig betrgt die Ausrichtung der Bitmap 0. 
:p.Normalerweise ist die Bitmap auf 0 ausgerichtet, wenn der Rahmen auf Null ausgerichtet ist. Das 
Ergebnis ist eine normal ausgerichtete Bitmap. 
:p.Wenn der Rahmen gedreht wird, wird auch die Bitmap gedreht. Der eigentliche Winkel der Bitmap wird 
als Statuszeichenkette im Dialog Drehen angezeigt. Sie knnen den Drehregler benutzen oder den erforderlichen 
Winkel eingeben, um die :hp1.relative:ehp1. Ausrichtung zwischen Bitmap und Rahmen anzupassen. 
:p.Klicken Sie 'Anwenden', um den neuen Winkel auf die Bitmap anzuwenden, und 'Beenden', um den Dialog 
nach Abschlu der Arbeiten zu verlassen.
.*******************************************************************************
:h2 res=23 id=23 global.Rahmen zuschneiden 
:i2 refid=edit.Rahmen zuschneiden 
:p.Jeder Rahmen kann auf das derzeitige Bild zugeschnitten werden. Sobald der Rahmen zugeschnitten wurde, wird 
das Bild gegebenenfalls erneut skaliert, um es in das neue kleinste Rechteck einzupassen, welches den Rahmen 
aufnehmen kann. Dies hngt stark von der Komplexitt des zugeschnittenen Rahmens ab. Der Rahmen ndert seine 
grundliegende Form nicht, aber seine Gesamthhe und -breite werden neu berechnet, um die Bitmap einzupassen. 
:p.Durch Auswahl dieses Meneintrages berechnet der Bitmap-Handler die zum Einpassen des Bildes 
erforderliche Gre neu und ndert dann die Gre des Rahmens entsprechend der Gre des Bildes.
.*******************************************************************************
:h2 res=54 id=54 global.Bitmap-Stil sichern
:i2 refid=edit.Bitmap-Stil sichern
:p.:hp2.Einen Bitmap-Stil setzen:ehp2.
:p.Benutzen Sie das Men 'Bearbeiten'->'Bitmap-Stil setzen', um einen Bitmap-Stil anzuwenden.
Wenn Sie die Pfeil-Schaltflche rechts des Meneintrags auswhlen, werden die verfgbaren
Bitmap-Stile angezeigt. Whlen Sie einen der angezeigten Bitmap-Stile aus, so wird dieser
zum Standard fr den Meneintrag 'Bitmap-Stil setzen'.
:p.:hp2.Bitmap-Stil sichern:ehp2.
:p.Wenn Sie eine Bitmap mit einem bestimmten Stil vorliegen haben, knnen Sie diesen
Stil sichern.
:p.Bitmap-Stile umfassen alles auer dem Bitmap-Verankerungsversatz und der Bitmap selbst.
Wenn Sie einen Stil bentigen, der auch die Bitmap festlegt, verwenden Sie Rahmenstile im
Rahmen-Handler.
:p.Die Stile werden im Benutzerpfad als Stilvorlagen gesichert. Unter 'Globale Stileinstellungen'
im Men Optionen erfahren Sie, worauf der aktuelle Benutzerpfad zeigt.
:p.Stile werden als allgemeine Stilvorlagen gesichert. Weitere Informationen hierzu entnehmen Sie
bitte dem Abschnitt 'Allgemeine Stilvorlagen' des Maul-Publisher-Handbuchs.
.*******************************************************************************
:h2 res=11 id=11 global.Bitmap-Handler aus Rahmen entfernen 
:i2 refid=edit.Bitmap-Handler aus Rahmen entfernen 
:p.Whlen Sie diesen Meneintrag, um die Bitmap und dann den Bitmap-Handler aus dem Rahmen
zu entfernen. Sobald Sie dies durchgefhrt haben, kann dem Rahmen anstelle des
Standard-Bitmap-Handlers ein anderer Handler hinzugefgt werden.
.******************************************************************************
.*  Bitmap Menu
.******************************************************************************
:h1 res=2 id=2 global.Das Men Bitmap des Bitmap-Handlers
:i1 id=bitmap.Das Men Bitmap des Bitmap-Handlers
:p.Das Men Bitmap des Bitmap-Handlers enthlt die spezifischen, auf Bitmaps bezogenen
Meneintrge zum Bearbeiten.
:p.Diese umfassen&colon.
:ul.
:li.Wie man :link reftype=hd res=28.Informationen:elink. ber die ausgewhlte
Bitmap erhlt.
:li.Wie man eine Bitmap:link reftype=hd res=32.ein- oder auslagern:elink. kann.
:li.Wie man eine Bitmap :link reftype=hd res=29.zuschneidet:elink..
:li.Wie man :link reftype=hd res=16.Farbpaletten:elink. von Bitmaps bearbeitet.
:li.Wie man die Bitmap Datei :link reftype=hd res=30.transformieren:elink. kann.
:li.Wie man die Bitmap Datei zu den Rahmen:link reftype=hd res=31.skalieren:elink. kann.
:li.Wie man :link reftype=hd res=26.Masken:elink. einfgt oder lscht.
:li.Wie man :link reftype=hd res=27.Masken:elink. bearbeitet und eine Vorschau anzeigt.
:li.Wie man :link reftype=hd res=24.in 16-Farb-Bitmaps konvertiert:elink..
:eul.
.br
.br
.*******************************************************************************
:h2 res=28 id=28 global.Bitmap-Informationen
:i2 refid=bitmap.Bitmap-Informationen
:p.Benutzen Sie diesen Meneintrag, um Informationen ber die ausgewhlte Bitmap zu erhalten.
:p.Die Struktur des Bitmap-Handlers erlaubt die Speicherung von zwei Bildern. Eines ist das
normale Bild und das andere eine Maske. Die Maske wird verwendet, um Teile eines Bildes
herauszuschneiden; der resultierende Effekt kann oft bei Symbolen beobachtet werden.
Beachten Sie, da nicht alle Bilder eine Maske besitzen.
:p.Das Bitmap-Bild kann auch auerhalb der Dokumentdatei gesichert werden. In
diesem Fall wird zur Anzeige des Bildes auf dem Bildschirm eine Platzhalter-Bitmap benutzt.
Wenn das Dokument gedruckt wird, wird die 'ausgelagerte' Bitmap in voller Gre
wieder geladen, damit die Seite mit einem Maximum an Details gedruckt werden kann. Der
Informationsdialog zeigt die Gre der Platzhalter-Bitmap sowie die ihrer ausgelagerten
Verwandten an. Beachten Sie, da auch ein Dateiname angezeigt wird, bei dem es sich um
den Namen handelt, der zur Sicherung der Bitmap auf Festplatte zugewiesen wurde.
.br
.br
.*******************************************************************************
:h2 res=32 id=32 global.Bitmap auslagern
:i2 refid=bitmap.Bitmap auslagern
:p.:hp2.ber Auslagerung:ehp2.
:p.Dieser Handler ist in der Lage, eine Technik namens Auslagerung zu verwenden, die beim
Bearbeiten Speicher spart. Dies wird dadurch erreicht, da groe Bitmaps in einem separaten
Ordner gespeichert werden. Dieser Ordner wird mit demselben Namen wie dem des aktuellen
Dokumentes (ohne die .mpb-Erweiterung) erstellt und an derselben Stelle gespeichert.
Whrend man Bilder in das Dokument ldt, entscheidet das System, ob die Bitmap
getrennt von dem Dokument abgespeichert werden sollte, und generiert ntigenfalls
eine kleine Platzhaltergrafik, damit man das Bild immer noch sehen kann. Indem man
nderungen vornimmt, erstellt der Auslagerungsmechanismus Sicherheitskopien und
modifiziert die eigentlichen Bitmaps in voller Gre auf der Festplatte. Wenn die Auslagerung
benutzt wird, kommt es zu erhhter Festplattenaktivitt.
:p.Zur Aktivierung der Auslagerung mu das Markierungsfeld 'Groe Bitmaps auslagern'
unter 'Globale Stileinstellungen' im Men 'Optionen' ausgewhlt werden.
.*******************************************************************************
:h2 res=29 id=29 global.Bitmap zuschneiden
:i2 refid=bitmap.Bitmap zuschneiden
:p.Benutzen Sie diesen Dialog, um eine Bitmap zuzuschneiden. Sie knnen mit der Maus ein
Zuschnittsrechteck aufziehen, um die bentigte Gre festzulegen. Fr eine genauere Auswahl
verwenden Sie die Kontrollelemente der Zuschneidebox, um kleine Korrekturen durchzufhren.
:p.Sie haben vielleicht bemerkt, da sich dieser Dialog vergrern und maximieren lt.
Dies ist der Fall, damit das Zuschneiderechteck genauer festgelegt werden kann. Maximieren
Sie den Dialog gegebenenfalls einfach.
:p.Bei Drcken von 'Anwenden' wird die Bitmap auf die Auswahl zugeschnitten und der Dialog
Zuschneiden aktualisiert.
:p.Klicken Sie 'Beenden', wenn Sie die Arbeiten abgeschlossen haben.
.*******************************************************************************
:h2 res=16 id=16 global.Bitmap-Farbpalette bearbeiten
:i2 refid=bitmap.Bitmap-Farbpalette bearbeiten
:p.Benutzen Sie diesen Dialog, um die Farbpaletten von Bitmaps mit 256 oder weniger Farben
zu bearbeiten.
:p.Durch Klicken auf eine Farbe wird diese ausgewhlt und ein Farbbearbeitungsdialog
zur Anpassung der Farbe dieses bestimmten Eintrags aufgerufen.
:p.Wurde eine Farbe ausgewhlt, so kann man diese in der Farbpalette auf und ab auf eine
neue Position bewegen. Beachten Sie, da sich dadurch die gesamten Farben der Bitmap ndern.
Dies ist im allgemeinen nicht sonderlich ntzlich, man kann damit jedoch einige hbsche
Farbeffekte erzeugen.
.*******************************************************************************
:h2 res=30 id=30 global.Bitmap Datei transformation
:i2 refid=bitmap.Bitmap Datei transformation
:p.Eine :link reftype=hd res=18.sofortige Skalierung:elink. oder Drehung
lt sich zwar innerhalb der Anwendung durchfhren, aber mitunter ist es von nutzen,
Transformationen auf die eigentlichen Bitmap-Daten anwenden zu knnen, insbesondere dann,
wenn die Bitmap hinterher von Maul in eine andere Anwendung kopiert werden knnen soll.
:p.Es stehen folgende vier Transformationen zur Verfgung&colon.
:ul.
:li.Drehung nach links. Die Bitmap-Daten werden entgegen dem Uhrzeigersinn gedreht.
:li.Drehung nach rechts. Die Bitmap-Daten werden im Uhrzeigersinn gedreht.
:li.Bitmap-Daten vertikal spiegeln. Bei den Bitmap-Daten werden Ober- und Unterseite vertauscht.
:li.Bitmap-Daten horizontal spiegeln. Bei den Bitmap-Daten werden links und rechts vertauscht.
:eul.
.br
.br
.*******************************************************************************
:h2 res=31 id=31 global.Bitmap-Datei zum Rahmen skalieren
:i2 refid=bitmap.Bitmap-Datei zum Rahmen skalieren
:p.Eine :link reftype=hd res=18.sofortige Skalierung:elink. oder Drehung
lt sich zwar innerhalb der Anwendung durchfhren, aber mitunter ist es von nutzen,
Transformationen auf die eigentlichen Bitmap-Daten anwenden zu knnen, insbesondere dann,
wenn die Bitmap hinterher von Maul in eine andere Anwendung kopiert werden knnen soll.
:p.Ein weiterer Vorteil bei der Skalierung von Bitmap-Daten ist, da so eine Interpolation
vorgenommen werden kann, um ein schrferes Bild zu erhalten, als mit herkmmlichen Methoden
mglich wre.
:p.:hp2.Skalierungsmethode:ehp2.
:p.Im Dialog zur Skalierung von Bitmap-Daten stehen drei Stufen der Glttung zur Verfgung&colon.
:ul.
:li.:hp2.Rauh:ehp2. - Es findet keine Interpolation statt. Dies entspricht der bedarfsweisen
Skalierung, die vom Dialog :link reftype=hd res=18.Bild skalieren...:elink. geboten wird.
:li.:hp2.Scharf:ehp2. - Es wird eine nicht-lineare Interpolation vorgenommen. bergnge
werden nur ber die halbe Entfernung geglttet. Ein Pendant hierzu findet man bei den erweiterten
Modi der Hintergrundschattierung, bei denen 50% Ein- und Auslauf denselben Farbbergang ergeben.
Weitere Einzelheiten entnehmen Sie bitte dem Handbuch des Hintergrund-Handlers.
:li.:hp2.Glatt:ehp2. - Es wird eine lineare Interpolation vorgenommen. bergnge zwischen einem und
dem nchsten Bildpunkt werden vollstndig geglttet.
:eul.
:p.:hp2.Auflsung:ehp2.
:p.Die Gre der skalierten Bitmap ergibt sich durch eine einfache Berechnung. Es ist die Anzahl
Punkte pro Inch (dpi) multipliziert mit der Breite oder Hhe in Inch.
:p.Wenn mit anderen Worten der Rahmen 4 Inch breit und 3 Inch hoch ist und der dpi-Wert 75
betrgt, erhlt man eine Bitmap, die 300 Punkte breit und 255 Punkte hoch ist.
:p.Standardmig wird der dpi-Wert so berechnet, da damit ein optimimals Druckergebnis auf
dem jeweiligen Drucker erzielt wird. Es steht Ihnen jedoch frei, ihn nach Wunsch zu ndern.
:p.:hp2.Resultierende Bitmap:ehp2.
:p.Die resultierende Bitmap wird die angezeigte Gre und Form besitzen. Es wird kein
Beispielbild angezeigt, da dies irrefhrend wre&colon. Beispiele mssen skaliert werden, damit
sie in das Beispielfenster passen. Bilder auf dem Bildschirm werden stets von der Druckseite aus
skaliert und beim Hinein- und Herauszoomen kommt es ebenfalls zu Skalierungen.
:p.Die Methoden "glatt" und "scharf" erzielen gute Ergebnisse, wenn sie zum Drucken von
Bildschirmphotos oder anderen Bildern mit feinen Einzelheiten verwendet werden, insbesondere
wenn das neue Bild kleiner als das Original ist. Masken werden stets mit der Methode "rauh" skaliert.
Die Methode "rauh" bietet die schnellste Verarbeitungsgeschwindigkeit und wird bei der Erstellung von
Beispielbildern und Platzhalter-Bitmaps eingesetzt. Bei allen Skalierungsmethoden auer "rauh"
mu das Bild in eine Bitmap mit 24 Bit Farbtiefe konvertiert werden.
:p.Soll die ursprngliche Form der Bitmap beibehalten werden, mssen Sie sicherstellen, da
der Rahmen, der sie enthlt, die bentigte Form besitzt. Dazu achten Sie darauf, da der
Meneintrag "Bearbeiten->:link reftype=hd res=20.Bitmap-Form beibehalten:elink." 
markiert ist und whlen dann den Meneintrag "Bearbeiten->:link reftype=hd res=23.Rahmen
auf Bitmap zuschneiden:elink.' aus.
.*******************************************************************************
:h2 res=26 id=26 global.Masken einfgen oder lschen
:i2 refid=bitmap.Masken einfgen oder lschen
:p.:hp2.ber Masken:ehp2.
:p.Wenn ein Bitmap-Bild eine Maske besitzt, werden Teile des Bildes so maskiert, da
angezeigt wird, was sich darunter befindet. Dieser Effekt entspricht dem, was man bei
Symbolen oder Mauszeigern sehen kann.
:p.:hp2.Eine Maske einfgen:ehp2.
:p.Klicken Sie auf den Meneintrag 'Maske einfgen...', um den Dialog Maske einfgen
aufzurufen.
:p.Masken knnen aus einer Reihe von Quellen bezogen werden.
:p.Man kann entweder&colon.
:ul.
:li.Eine Maske aus einer vorhandenen Bitmap erstellen. Dies funktioniert am besten bei Bitmaps
mit groen Bereichen hnlicher Farben.
:li.Eine Maske aus der Zwischenablage laden. Dies kann benutzt werden, um Bitmaps aus anderen
Anwendungen zu bernehmen.
:li.Eine Maske aus einer Datei laden. Jede beliebige Bitmap-Datei kann dafr verwendet werden.
:eul.
:p.Die ideale Maske erzeugt man am besten aus zweifarbigen Bitmap-berlagerungen. Es steht eine
ganze Reihe von Anwendungen zu Verfgung, mit denen man sehr ausgefeilte Masken erstellen kann.
Klicken Sie auf die Schaltflche 'Maske erzeugen', um den eingebauten
:link reftype=hd res=27.Maskenerzeugungsdialog:elink. zu verwenden. Dieser Dialog
erlaubt es, den Masken-"Kandidaten" in einer Vorschau anzuzeigen und anzupassen.
:p.Bei diesen Dialogen gibt es gewisse Beschrnkungen, was Schwarz/Wei-Bilder (1 Bit pro Pixel)
angeht. Sie knnen die Maske im Maskenerzeugungsdialog ansehen, sie aber nicht modifizieren.
Die Maske kann nicht invertiert werden. Wenn Sie die Maske modifizieren mssen, plazieren Sie
sie in einem leeren Rahmen und konvertieren Sie sie vor der Verwendung in eine Farb-Bitmap.
Siehe ':link reftype=hd res=24.In 16-Farb-Bitmaps konvertieren:elink.'.
:p.:hp2.Lschen einer Maske:ehp2.
:p.Klicken Sie auf den Meneintrag 'Maske entfernen'. Die Maske wird dann gelscht und das Bild
wird ohne Maske neu gezeichnet.
:p.:hp2.Maske ausschneiden:ehp2.
:p.Klicken Sie auf den Meneintrag 'Maske ausschneiden'. Die Maske wird dann in die Zwischenablage
kopiert, bevor sie gelscht wird, und das Bild wird ohne Maske neu gezeichnet.
:p.:hp2.Maske kopieren:ehp2.
:p.Klicken Sie auf den Meneintrag 'Maske kopieren'. Die Maske wird dann in die Zwischenablage
kopiert.
.br
.br
.*******************************************************************************
:h2 res=27 id=27 global.Farbmaskenerstellung
:i2 refid=bitmap.Farbmaskenerstellung
:p.Auf diesen Dialog wird ber den Dialog :link reftype=hd res=26.Maske einfgen:elink.
zugegriffen.
:p.Die Farbmaskenerstellung erlaubt es, eine Maske anzusehen und anzupassen, bevor sie in das
Dokument eingefgt wird.
:p.Als ersten Schritt sucht man sich eine Farbe in der Beispiel-Bitmap. Sie knnen die
derzeitige Farbe unter dem Cursor dann im Informationsfeld angezeigt sehen. Wenn Sie auf das
Bild klicken, wird die derzeitige Farbe ausgewhlt.
:p.Um eine Vorschau der Bereiche anzuzeigen, die transparent werden, whlen Sie das Markierungsfeld
'Maske anzeigen' an. Das Bild zeigt die resultierende Maske in rot an.
:p.Benutzen Sie die Schaltflche 'Maske kopieren', um die Maske in die Zwischenablage zu kopieren.
Die Maske wird dann mit den aktuellen Einstellungen erstellt und in die Zwischenablage kopiert.
Dieser Vorgang kann bei sehr groen Bitmaps einige Zeit in Anspruch nehmen.
:p.Es ist oft erforderlich, eine Maske aus einem kleinen Bereich hnlicher Farben zu erstellen,
weshalb Sie bei der Maskenerstellung eine gewisse Toleranz bezglich der Farben, die als
Teil der Maske angesehen werden, erlauben knnen.
:p.Beim folgenden Bild ist die Maske auf den eigentlich erwnschten Bereich eingestellt.
Falls notwendig, kann die Maske ber den Dialog :link reftype=hd res=26.Maske einfgen:elink. invertiert werden.
:p.:artwork name='mkmask.bmp' align=left.
.br
:p.Wenn Sie einen Bitmap-Editor besitzen, knnen Sie die Maske auerhalb dieser Anwendung
erstellen und sie 'roh' importieren, um eine Maske zu erstellen. Sie knnen diesen Dialog dann
benutzen, um sich eine Vorschau der resultierenden Maske anzeigen zu lassen und an dieser
Feineinstellungen vorzunehmen.
:p.:hp2.Ausgelagerte Bilder:ehp2.
:p.Bei ausgelagerten Bildern benutzt der Maskenerstellungsdialog die Platzhalter-Bitmap, um
sein Farbauswahlfenster zu erzeugen. Aus diesem Grund passen die angezeigten Koordinaten
nicht zur tatschlichen Bitmap-Gre.
:p.Wenn die Maske erstellt wird, wird das ausgelagerte Bild in voller Gre verwendet. Bei
groen Bitmaps kann der Maskenerstellungsproze einige Zeit in Anspruch nehmen. Vor und nach
dem Erstellungsproze werden Sie Festplattenaktivitt bemerken. Bitte gedulden Sie sich etwas.
.br
.br
.*******************************************************************************
:h2 res=24 id=24 global.In 16-Farb-Bitmap konvertieren
:i2 refid=bitmap.In 16-Farb-Bitmap konvertieren
:p.Aufgrund der Art und Weise, auf die die OS/2-Version dieses Handlers gezwungen ist,
monochrome Bitmaps zu behandeln, ist es notwendig, sie in Bitmaps mit mindestens 16 Farben
umzuwandeln. Falls Sie dies nicht tun, bleibt das Bild auf schwarz und wei beschrnkt
(oder wei und schwarz). Auerdem neigen Grafik- und Druckertreiber dazu, mit diesen Bildern
anders umzugehen, wobei sich hbsche Anzeigen auf dem Bildschirm in furchtbare Ausdrucke
verwandeln.
:p.Sobald eine Bitmap aktualisiert wurde, knnen Sie die Farben nach Ihrem Belieben
bearbeiten.
.******************************************************************************
.*
.*
.*  statusbar information
.*
.*
.******************************************************************************
.******************************************************************************
.*  status bar
.******************************************************************************
:h1 res=60 id=60 global.Die Statuszeile
:i1 id=stats.Die Statuszeile
:p.Die Statuszeile zeigt Informationen ber das aktuelle Objekt an.
.******************************************************************************
:h2 res=61 id=61 global.Bitmap-Statusinformation
:i2 refid=stats.Bitmap-Statusinformation
:p.Die Bitmap-Statusinformation zeigt die Gre der Bitmap in der Form
<horizontal>
x <vertikal> an, sowie die Farbtiefe in Bits pro Bildpunkt.
:p.Ist keine Bitmap geladen, wird '0 x 0, 0bpp'
angezeigt.
.br
.br
.******************************************************************************
.*
.*
.*  Other information
.*
.*
.******************************************************************************
:h1 res=55 id=55 global.Ausgelagerte Bitmaps erneut laden
:i1 id=refresh.Ausgelagerte Bitmaps erneut laden
:p.:hp2.ber Auslagerung:ehp2.
:p.Wenn Sie die Auslagerung groer Bitmaps in den 'Globalen Stileinstellungen' aktiviert haben,
werden groe Bitmaps in ihrer eigenen Datei gespeichert, um die Dokumentendatei
handhabbar zu halten.
:p.Damit Sie sehen knnen, wie die ausgelagerten Bilder aussehen, wird im Dokument
eine kleine Platzhalter-Bitmap gespeichert, die fr Anzeigezwecke verwendet wird. Wenn das
Dokument ausgedruckt wird, wird die ausgelagerte Bitmap in ihrer vollen Gre fr
einen Moment geladen, so da die Seite mit den bestmglichen Details ausgedruckt werden kann.
:p.:hp2.Ausgelagerte Bitmaps erneut laden:ehp2.
:p.Um Ihr Vertrauen in die ausgelagerten Bilder zu strken, knnen Sie sie erneut laden und
alle Platzhalter-Bitmaps im gesamten Dokument neu erstellen lassen.
:p.Solange alles funktioniert, sollten Sie nach Durchfhrung dieses Vorgangs keine
Unterschiede im Dokument feststellen. Falls eine ausgelagerte Datei fehlt oder das
falsche Bild enthlt, wird entweder eine Fehlernachricht angezeigt oder Sie sehen, da das
Platzhalterbild nicht stimmt.
:p.Dieser Befehl ist am ntzlichsten dafr festzustellen, ob alle mit dem Dokument
verbundenen Dateien vorhanden und in Ordnung sind. Dies ist besonders wichtig, wenn die Dateien
von einem anderen Computer geladen oder bernommen wurden.
.br
.br
.******************************************************************************
.*  Import Bitmaps
.******************************************************************************
:h1 res=100 id=100 global.Bilder importieren
:i1 id=import.Bilder importieren
:p.Benutzen Sie den Dialog Importieren, um Bilder in den Standard-Bitmap-Handler zu importieren.
:p.Der Dialog Importieren zeigt die ausgewhlte Bitmap an, wenn sie importiert werden kann.
:p.Der Bitmap-Handler ist vollstndig in den Importmechanismus des Maul Publishers integriert,
was ihn in die Lage versetzt, beliebige Bilddatenformate ber externe Bitmap-Bildimport-Handler
einzulesen. Der Mechanismus kann sowohl mit Daten aus der Zwischenablage als auch aus Dateien
umgehen.
:p.Dieser Handler importiert direkt *.ico-Symbolressourcen von OS/2 und Windows, OS/2-Mehrfach-Bitmaps,
alte OS/2-Kurz-Bitmaps, unkomprimierte Windows-Bitmaps der Typen *.bmp und *.dib sowie das native Dateiformat *.mbm. Exporte sind auf Dateien der Formate *.mbm und *.bmp beschrnkt.
:p.Wenn Sie einen neuen Bitmap-Rahmen erstellen, erhalten Sie die Gelegenheit, eine Bitmap zu importieren.
Wenn Sie whrend der Arbeit mit dem Dialog Importieren die Schaltflche 'Abbruch' bettigen,
bleibt der Bitmap-Rahmen leer.
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=40 id=40 global.Hilfe zu Tasten 
:i1 id=keys.Hilfe zu Tasten 
:p.Fr diesen Handler stehen die folgenden Tastenkrzel zur Verfgung. Es werden die gebruchlichsten Tastenkrzel aufgefhrt, jedoch 
keine Tastenkrzel, die fr andere Handler spezifisch sind. Whlen Sie einen Rahmen und Handler aus, fr die Sie Informationen 
bentigen und rufen Sie die Hilfe nochmals auf. 
:p.Ist kein Rahmen ausgewhlt, so wird die Tastenhilfe fr das Hauptprogramm des Maul Publisher angezeigt. 
:p.Bitte beachten Sie, da Sie diese Tastenkrzel ndern knnen, und da hier nur die Standardeinstellungen gezeigt werden. 
:p.:hp2.Allgemeine Tastenbelegung:ehp2. 
:ol. 
:li.:hp2.Menauswahl:ehp2. 
:dl compact tsize=16. 
:dt.Alt+B:dd.Men Bearbeiten 
:dt.Alt+D:dd.Men Datei 
:dt.Alt+H:dd.Men Hilfe 
:dt.Alt+O:dd.Men Optionen 
:dt.Alt+S:dd.Men Seite 
:dt.Alt+W:dd.Men Widerrufen 
:dt.Alt+A:dd.Men Anzeige 
:dt.Alt+U:dd.Umschalten zu (Umschaltliste) 
:edl. 
:li.:hp2.Men Datei:ehp2. 
:dl compact tsize=16. 
:dt.Strg+N:dd.Neue Datei 
:dt.Strg+:dd.Datei ffnen... 
:dt.Strg+I:dd.Importieren... 
:dt.Strg+X:dd.Exportieren... 
:dt.Strg+S:dd.Datei sichern 
:dt.Strg+A:dd.Datei sichern unter... 
:dt.Strg+R:dd.Datei drucken... 
:edl. 
:li.:hp2.Men Seite:ehp2. 
:dl compact tsize=16. 
:dt.Strg+P:dd.Seitendruckeinstellungen... 
:dt.Strg+M:dd.Rnder und Gitter... 
:dt.Strg+Umschalt+M:dd.Seitenvorlage verwenden... 
:dt.Strg+T:dd.Seitenvorlage sichern/lschen 
:dt.Alt+Umschalt+Entf:dd.Eine Seite kopieren 
:dt.Alt+Umschalt+Einfg:dd.Eine Seite einfgen 
:dt.Strg+Umschalt+I:dd.Eine neue Seite einfgen 
:dt.Strg+Umschalt+J:dd.Eine neue erste Seite einfgen 
:dt.Strg+Umschalt+D:dd.Eine Seite lschen 
:dt.Alt+G:dd.Gehe zu Seite 
:dt.Strg+Umschalt+N:dd.Nchste Seite 
:dt.Strg+Umschalt+P:dd.Vorige Seite 
:edl. 
:li.:hp2.Men Anzeige:ehp2. 
:dl compact tsize=16. 
:dt.Strg+1:dd.Seitenanzeige Drucker 
:dt.Strg+2:dd.Seitenanzeige 
:dt.Strg+3:dd.Auf Breite anpassen 
:dt.Strg+4:dd.Wirkliche Gre 
:dt.Strg+Plus:dd.Vergrern 
:dt.Strg+Minus:dd.Verkleinern 
:dt.Strg+F:dd.Rahmenbearbeitungsmodus 
:dt.Strg+C:dd.Inhaltsbearbeitungsmodus 
:dt.Strg+G:dd.Hintergrundbearbeitungsmodus 
:dt.Strg+B:dd.Grenzbearbeitungsmodus 
:edl. 
:li.:hp2.Men Widerrufen:ehp2. 
:dl compact tsize=16. 
:dt.Alt+Backspace:dd.Letzte nderung widerrufen 
:dt.Strg+Backspace:dd.Letzte nderung wiederholen 
:dt.Strg+U:dd.Widerrufsliste... 
:edl. 
:li.:hp2.Men Optionen:ehp2. 
:dl compact tsize=16. 
:dt.Strg+Umschalt+R:dd.Druckereinstellungen... 
:dt.Strg+E:dd.Raster aktivieren 
:dt.Strg+Umschalt+S:dd.Rastereinstellungen... 
:edl. 
:li.:hp2.Men Hilfe:ehp2. 
:dl compact tsize=16. 
:dt.Strg+H:dd.Inhaltsverzeichnis 
:dt.Strg+Umschalt+H:dd.Hilfeindex 
:dt.Strg+K:dd.Hilfe fr Tasten 
:dt.Strg+L:dd.Alle Handler anzeigen 
:dt.Strg+Z:dd.Produktinformation... 
:edl. 
:eol.
:p.:hp2.Tastenbelegung Bitmap-Handler:ehp2.
:ol.
:li.:hp2.Men Bearbeiten:ehp2.
:dl compact tsize=16.
:dt.Umsch+Entf:dd.Bitmap ausschneiden
:dt.Strg+Einf:dd.Bitmap kopieren
:dt.Umsch+Einf:dd.Bitmap einfgen
:dt.Entfernen:dd.Bitmap lschen
:dt.Alt+Entf:dd.Bitmap-Handler entfernen
:edl.
:li.:hp2.Men Bitmap:ehp2.
:dl compact tsize=16.
:dt.U:dd.Originalgre der Bitmap verwenden
:dt.M:dd.Grenverhltnisse der Bitmap beibehalten
:dt.T:dd.Bitmap kacheln
:dt.P:dd.Bitmap-Position sperren
:dt.S:dd.Bitmap skalieren...
:dt.O:dd.Bitmap drehen...
:dt.Strg+Umsch+C:dd.Bitmap-Farben schwarz/wei
:edl.
:eol.
:euserdoc.
