.******************************************************************************
.*  Maul Publisher Tables Handler Help File
.*   Peter Koller 2003, All Rights Reserved
.******************************************************************************
:userdoc.
:title.Maul-Hilfe zum Tabellen-Handler
:docprof toc=1234.
:h1 res=1 id=1 global.ber den Maul Tabellen-Handler
:i1 id=top.ber den Maul Tabellen-Handler
:p.:artwork name='main.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Tabellen-Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.bersicht zum Maul Tabellen-Handler:ehp2.
:p.Der Tabellen-Handler dient der Erzeugung von Tabellen wie der obigen. Er arrangiert
beliebige Kombinationen von Text und Bildern in einer Zellenmatrix. Indem erlaubt wird,
da ein Textblock oder ein Bild mehr als eine Zelle abdeckt, knnen einfach komplexe
Effekte erzeugt werden.
:p.Textblcke werden im Tabellen-Handler stets als Rechteck formatiert.
Der Nachteil hierbei ist, da der Text nicht um Rahmen herumfliet, die man
im Vordergrund plaziert, aber zu den Vorteilen gehrt die Mglichkeit, Text sowohl
vertikal als auch horizontal zu zentrieren.
:p.:hp2.Tabellenauswahl:ehp2.
:p.Tabellenzellen knnen durch Mausklick ausgewhlt werden. Die Zelle wird dann mit einer
schwarzen Umrandung umgeben. Ein Zellenbereich kann durch Ziehen mit der Maus ber den
gewnschten Bereich ausgewhlt werden. Entlang des oberen und linken Randes der Tabelle
werden Auswahlleisten gezeichnet, mit deren Hilfe eine Zeile, eine Spalte oder die gesamte
Tabelle ausgewhlt werden kann. Zur nderung der Gre der aktuellen Auswahl kann bei
gedrckter Umschalttaste auf eine Zelle geklickt werden.
:p.:hp2.Tabellenorganisation:ehp2.
:p.Jedes Tabellenelement befindet sich in einem Behlter. Jeder Behlter kann einen
Hintergrund oder eine Umrandung, eine Bitmap oder Metadatei, oder Text beinhalten.
Durch Manipulation der Behlter kann der Aufbau der Tabelle auf der Seite beeinflut werden.
Wann immer ein Behlter einen Behlter vom gleichen Typ vollstndig berdeckt, wird der
untere Behlter automatisch gelscht. Die Gre vorhandener Behlter lt sich jederzeit
mit Hilfe des Dialogs 'Behlterbereich anzeigen/bearbeiten' anpassen.
:p.Behlter werden sofort bei nderung eines Zustands erzeugt. Beispielsweise wird automatisch
ein neuer Hintergrundbehlter erzeugt, wenn die Farbe einer Auswahl gendert wird.
Wenn die Einstellung einer Umrandung gendert wird, wird ein neuer Umrandungsbehlter
erzeugt. Durch Abschalten des Einfgemodus knnen vorhandene Behlter bearbeitet werden.
.br
Sie knnen eine Reihe von Zellen erzeugen, indem Sie etwas eingeben. Jedesmal, wenn Sie die
Eingabetaste bettigen, wird die nchste Zelle ausgewhlt. Ein Textblock, der sich
ber mehrere Zellen erstreckt, kann durch Auswahl eines Zellenbereiches und Drcken der
Schaltflche Textbearbeitungsmodus erzeugt werden.
:p.Der vom Tabellen-Handler genutzte Texteditor entspricht fast vollstndig dem des Text-Handlers,
weswegen die meisten Funktionen des letzteren, wie etwa Bilder im Text, Serienbriefe usw. auch
hier funktionieren.
:p.Eine Funktion, die der Text-Handler nicht bietet, ist die Mglichkeit, Text vertikal zu zentrieren.
Wenn Sie diese Funktion bentigen, lt sie sich mit einer Tabelle erreichen.
:p.
.br
.br
:p.Erstellt von Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. Copyright 2003 Peter Koller, Maison Anglais. Alle Rechte vorbehalten.
:p.Details der Lizenzbestimmungen entnehmen Sie bitte dem Urheberrechtshinweis im Haupthandbuch
des Maul Publishers.
.br
.******************************************************************************
:h1 res=2 id=2 global.Tabellenzellen auswhlen
:i1 id=select.Tabellenzellen auswhlen
:p.Zur Vereinfachung von Auswahl- und Grennderungsvorgngen werden Tabellen als Netz
gestrichelter Linien dargestellt.
:p.:hp2.Grennderung bei Zellen:ehp2.
:p.Bewegt man den Mauszeiger auf eine gestrichelte Grennderungslinie, ndert
er sich in einen vertikalen oder horizontalen Grennderungszeiger.
:p.Zur nderung der Breite einer Zeile oder Spalte klicken Sie mit der linken Maustaste auf
eine gestrichelte Grennderungslinie, halten Sie die Maustaste gedrckt und ziehen Sie die Maus
in die gewnschte Richtung. Schrumpft die Breite einer Zeile oder Spalte auf Null, so
wird sie automatisch gelscht. Zeilen und Spalten, die ber den Rahmen hinaus verschoben
werden, werden ebenfalls gelscht.
:p.Wird beim Ziehen einer gestrichelten Grenzlinie die Umschalttaste gedrckt gehalten, so
werden auch die Grenzen rechts und unterhalb verschoben.
:p.Neue Zeilen und Spalten knnen vom rechten und unteren Rand in die Tabelle gezogen werden.
:p.Hhe und Breite von Zeilen und Spalten werden als relative Werte gespeichert, weswegen sich
bei einer Anpassung der Gre des Rahmens auch die Breiten aller Zeilen und Spalten ndern.
Der Tabellen-Handler erlaubt den Tabellen nicht, kleiner oder grer als die Breite und Hhe
des sie beinhaltenden Rahmens zu werden. ber die Meneintrge 'Bearbeiten->Tabellengre'
knnen Breite und Hhe des ausgewhlten Bereichs zurckgesetzt sowie Zeilen und Spalten
hinzugefgt werden.
:p.:artwork name='select.bmp' align=left.
:p.:hp2.Zellenauswahl:ehp2.
:p.Die Zellenauswahl besteht stets aus einer Zellenauswahl und einer Bereichsauswahl.
Zellen- und Bereichsauswahl knnen bereinstimmen. Wenn anfangs nichts ausgewhlt ist,
sind die meisten Meneintrge und Schaltflchen deaktiviert.
:p.Eine Zelle wird mit einem Mausklick darauf ausgewhlt. Bereiche werden ausgewhlt, indem
mit der linken Maustaste auf eine Zelle geklickt und die Maus dann bei gedrckter Taste
ber den gewnschten Bereich gezogen wird. Durch Klicken auf eine Auswahlleiste
kann eine Zeile oder Spalte ausgewhlt werden; wird dabei die Umschalttaste gedrckt
gehalten, knnen nacheinander mehrere Zeilen oder Spalten ausgewhlt werden.
Die Auswahl der gesamten Tabelle erfolgt durch Mausklick auf den Tabellenauswhler,
ein kleines schwarzes Rechteck in der linken oberen Ecke.
:p.Innerhalb einer Bereichsauswahl kann eine Zellenauswahl mit Hilfe der Pfeiltasten
bewegt werden. Die Zellenauswahl wird zudem durch die Eingabe- und Tabulatortasten
bewegt, wobei die vorherige Bewegungsrichtung beibehalten wird. Dieses Verhalten
sollte Nutzern von Tabellenkalkulationen bekannt sein.
:p.:hp2.Auswahlverhalten:ehp2.
:p.Der Tabellen-Handler befindet sich anfangs stets im Einfgemodus, so da beliebige nderungen
an Umrandungen, Hintergrnden, eingefgten Bildern usw. stets zur Erzeugung eines neuen
Behlters von der Gre eines Bereichs fhren. Eine Ausnahme stellt nur Text dar.
Beim Eingeben von Text wird nur ein Behlter in der aktuellen Zelle erzeugt. Um hier
einen Behlter von der Gre des ausgewhlten Bereichs zu erzeugen, mu der Bereich
explizit durch Bettigen der Textschaltflche oder des Meneintrags 'Bearbeiten->Text bearbeiten'
erzeugt werden.
.br
.******************************************************************************
:h1 res=3 id=3 global.Behlter erklrt
:i1 id=container.Behlter erklrt
:p.:hp2.Eine Tabelle:ehp2. enthlt ein Blatt, das aus einer Matrix von Zeilen und Spalten
besteht. Zeilen und Spalten schlieen Regionen ein, die Zellen genannt werden. Ein Bereich
ist einfach eine rechteckige Auswahl einer oder mehrerer Zellen.
:p.Wenn man einen Bereich auswhlt und seine Farbe ndert, wird tatschlich ein Behlter
erstellt, der die Informationen ber die Farbfllung enthlt. Ein Behlter kann so gro
wie eine einzelne Zelle oder ein rechteckiger Bereich von Zellen sein. Auf diese Weise
kann ein Textblock einen Zellenbereich berdecken.
:p.Es stehen viele verschiedene Behltertypen zur Verfgung.
:ul.
:li.Umrandungsbehlter
:li.Fllungsbehlter
:li.Bitmapbehlter
:li.Metadateibehlter
:li.Textbehlter
:li.Rahmensatzbehlter (...ein aus dem Rahmen-Handler kopierter Rahmensatz)
:eul.
:p.Wenn ein Behlter einen darunter befindlichen, bereinstimmenden Behlter
vollstndig berlappt, wird der untere Behlter automatisch gelscht. Dies geschieht
nicht, wenn ein Textbehlter ber einem Fllungsbehlter plaziert wird, denn
die beiden Typen mssen bereinstimmen.
:p.Mitunter mchte man einen im Hintergrund vorhandenen Behlter ndern. Whlte
man den Bereich des vorhandenen Behlters aus, so wrden alle darber befindlichen
Behlter nicht mehr bercksichtigt, d.h. die Z-Reihenfolge der Behlter wrde
gendert. Schaltet man jedoch den :link reftype=hd
res=73.Zellenbearbeitungsmodus:elink. von 'Einfgen' nach 'Aktualisieren'
um, braucht man nur eine Zelle des zu ndernden Behlters auszuwhlen und jede weitere
nderung betrifft nur den bereinstimmenden Behlter. Die Z-Reihenfolge wird nicht gendert
und es werden keine anderen Behlter gelscht.
:p.Whlt man einen Zellenbereich aus und beginnt, etwas einzugeben, dann verhlt sich
der Tabellen-Handler wie eine Tabellenkalkulation. Der Text fliet in die ausgewhlte
Zelle, und jedesmal, wenn man die Eingabe- oder Tabulatortaste bettigt, bewegt man
sich zur nchsten Zelle. Dabei wird fr jede Zelle ein neuer Behlter angelegt.
:p.Schaltet man in den :link reftype=hd res=72.Textbearbeitungsmodus:elink.,
whrend ein Zellenbereich ausgewhlt ist, wird ein neuer Behlter von der Gre
des gewhlten Bereichs angelegt. Auf diese Weise lt sich ein Textblock erstellen,
der grer als eine einzelne Zelle ist. Sollen die Einstellungen eines vorhandenen
Textblocks gendert werden, mu entweder in den Textbearbeitungsmodus umgeschaltet
und der zu ndernde Text markiert werden, oder man schaltet den
:link reftype=hd res=73.Zellenbearbeitungsmodus:elink. von 'Einfgen' nach
'Aktualisieren' um.
:p.Die Gre eines Behlter lt sich ber den Dialog :link reftype=hd
res=36.Behlterbereiche anzeigen/bearbeiten:elink. anpassen. Dieser Dialog
zeigt nur die Bereiche in der aktuellen Auswahl ein. Zur Bearbeitung aller Behlter
mu die gesamte Tabelle ausgewhlt werden, aber denken Sie daran, da eine groe Tabelle
eine enorme Anzahl von Behltern enthalten kann.
:p.:artwork name='tbldesc.bmp' align=left.
.br
.br
.******************************************************************************
:h1 res=400 id=400 global.Die Werkzeugleiste
:i1 id=butbar.Die Werkzeugleiste
:p.Die Werkzeugleiste bietet schnellen Zugriff auf viele Funktionen des Tabellen-Handlers.
:p.:artwork name='insbut.bmp' runin.
 Schaltflche Einfgemodus, siehe die Hilfeseite des Meneintrags
:link reftype=hd res=73.Einfgemodus:elink..
:p.:artwork name='txtbut.bmp' runin. Schaltflche Textmodus, entspricht dem Meneintrag
:link reftype=hd res=72.Text bearbeiten:elink..
:p.:artwork name='fcolbut.bmp' runin. ndern der Fll- (Hintergrund-) farbe des
ausgewhlten Bereichs. Bevor die Fllung sichtbar wird, mu mindestens eine Fllfarbe
ausgewhlt werden.
:p.:artwork name='fpatbut.bmp' runin. ndern des Fllmusters des ausgewhlten
Bereichs.
:p.:artwork name='fstybut.bmp' runin. ndern des Fllstils des ausgewhlten
Bereichs.
:p.:artwork name='bcolbut.bmp' runin. ndern der Umrandungsfarbe des ausgewhlten Bereichs.
Eine Umrandung bentigt eine Farbe, eine Breite und einen Stil. Damit eine Umrandung sichtbar
wird, mu mindestens ein passender Stil ausgewhlt werden!
:p.:artwork name='bwidbut.bmp' runin. ndern der Umrandungsbreite des ausgewhlten Bereichs.
:p.:artwork name='bstybut.bmp' runin. ndern des Umrandungsstils des ausgewhlten Bereichs.
:p.:artwork name='justbut.bmp' runin. ndern der Textjustierung der ausgewhlten Zelle.
:p.:artwork name='valignbut.bmp' runin. ndern der vertikalen Textjustierung der ausgewhlten Zelle.
:p.:artwork name='tcolbut.bmp' runin. ndern der Textfarbe der ausgewhlten Zelle.
:p.:artwork name='outlbut.bmp' runin. Umrimodus.
:p.:artwork name='ulinbut.bmp' runin. Unterstreichungsmodus.
:p.:artwork name='strkbut.bmp' runin. Durchstreichungsmodus.
:p.:artwork name='subsbut.bmp' runin. Text tiefstellen.
:p.:artwork name='suprbut.bmp' runin. Text hochstellen.
:p.:artwork name='dropsbut.bmp' runin. Schattenwurfmodus.
:p.:artwork name='fontsz.bmp' runin. Schriftgradauswahl. Ungewhnliche Schriftgrade
knnen durch Eingabe in das Kombinationsfeld und Drcken der Eingabetaste festgelegt werden.
:p.:artwork name='fontsty.bmp' runin. Festlegen eines fr die derzeitige Schriftart zur Verfgung stehenden Stils.
:p.:artwork name='fontsel.bmp' runin. Schriftauswahl.
:p.:artwork name='formatbut.bmp' runin. Den gesamten Text in der Tabelle neu formatieren. Hierdurch
werden smtliche Textpositionen in der Tabelle neu berechnet.
.br
.******************************************************************************
:h1 res=4 id=4 global.Das Men Bearbeiten
:i1 id=editmnu.Das Men Bearbeiten
:p.Dieses Men bietet alle grundlegen Funktionen wie Ausschneiden, Kopieren und Einfgen sowie
Meneintrge fr tabellenspezifische Aufgaben.
:p.Meneintrge fr die Zwischenablage und verwandte Themen
:ul.
:li.:link reftype=hd res=16.Beschrnken:elink. von Vorgngen ber die
Zwischenablage auf Untermengen der aktuellen Auswahl.
:li.:link reftype=hd res=12.Ausschneiden:elink. nach aktuellen Auswahlkriterien.
:li.:link reftype=hd res=13.Kopieren:elink. nach aktuellen Auswahlkriterien.
:li.:link reftype=hd res=14.Einfgen:elink. der Daten aus der Zwischenablage
:li.:link reftype=hd res=15.Lschen:elink. nach aktuellen Auswahlkriterien.
:li.:link reftype=hd res=74.Laden:elink. eines Rahmensatzes aus einem Katalog.
:li.:link reftype=hd res=17.Laden:elink. von Daten.
:li.:link reftype=hd res=18.Auswhlen:elink. der gesamten Tabelle (oder des gesamten Texts).
:eul.
:p.Behlterbereiche
:ul.
:li.:link reftype=hd res=36.Behlterbereiche anzeigen/bearbeiten:elink..
:eul.
:p.Tabellengre
:ul.
:li.:link reftype=hd res=35.Tabellengre:elink. festlegen.
:li.:link reftype=hd res=37.Einfgen oder Lschen:elink. einer Zeile oder Spalte.
:li.:link reftype=hd res=38.Angleichen:elink. des Zeilen- oder Spaltenabstands.
:eul.
:p.Einfgemodus
:ul.
:li.:link reftype=hd res=73.Einfgemodus:elink. aktivieren.
:eul.
:p.Neue Textbehlter einfgen
:ul.
:li.:link reftype=hd res=72.Text bearbeiten:elink.
:lp.Texteditorfunktionen
:ul.
:li.:link reftype=hd res=57.Zeichen:elink. einfgen.
:li.:link reftype=hd res=64.Restrechtsbndigkeit:elink. einfgen.
:li.:link reftype=hd res=53.Objekte/Einstellungen:elink. einfgen.
:li.:link reftype=hd res=63.Funote/Einstellungen:elink. einfgen.
:li.:link reftype=hd res=75.Formel/Einstellungen:elink. einfgen.
:li.:link reftype=hd res=46.Steuerzeichen:elink. einfgen.
:li.:link reftype=hd res=41.Einzuarbeitende Zeile:elink. auswhlen.
:li.Text :link reftype=hd res=54.suchen:elink..
:li.:link reftype=hd res=65.Wortanzahl:elink..
:li.:link reftype=hd res=66.Rechtschreibprfung:elink. durchfhren.
:li.:link reftype=hd res=69.Artikelinformationen:elink. anzeigen.
:eul.
:eul.
:p.Entfernen
:ul.
:li.Handler :link reftype=hd res=11.entfernen:elink..
:eul.
.br
.*-----------------------------------------------------------------------------
:h2 res=16 id=16 global.Beschrnken der Zwischenablagedaten
:i2 refid=editmnu.Beschrnken der Zwischenablagedaten
:p.Tabellen haben die besondere Eigenschaft, eine groe Bandbreite verschiedener Datentypen
enthalten zu knnen. Daher ist die Mglichkeit recht praktisch, die in die Zwischenablage
zu kopierenden Daten auf einen bestimmten Typ zu beschrnken. Beispielsweise mchte man
Text aus einer Tabellenzelle in eine andere kopieren knnen, ohne die Einstellungen fr
Hintergrundfarbe und Umrandung mit zu bernehmen.
:p.Folgende Vorgnge knnen beschrnkt werden&colon.
:ul.
:li.Daten ausschneiden und in der Zwischenablage ablegen
:li.Daten in die Zwischenablage kopieren
:li.Daten lschen
:li.Stil mit Stilvorlage setzen
:eul.
:p.Diese Vorgnge lassen sich beschrnken auf&colon.
:ul.
:li.Umrandungsbehlter
:li.Fllungsbehlter
:li.Bitmapbehlter
:li.Metadateibehlter
:li.Textbehlter
:li.Rahmensatzbehlter (...ein aus dem Rahmen-Handler kopierter Rahmensatz)
:li.Alle Behlter
:eul.
:p.Die tatschlich kopierten Behlter hngen zudem davon ab, welcher Bereich beim Kopieren
ausgewhlt ist. Damit auch Informationen wie Zeilen- und Spaltenbreiten kopiert werden,
mu die gesamte Tabelle ausgewhlt sein.
:p.Beim Einfgen sollte vorher der Bereich ausgewhlt werden, in den eingefgt werden soll.
Wenn die gesamte Tabelle ersetzt werden soll, mu die gesamte Tabelle ausgewhlt werden.
:p.Beim Setzen eines Stils hngen die verfgbaren Stilvorlagen von der Einschrnkung ab.
:p.:hp2.Beispiele:ehp2.
:p.Fr den Fall, da die obigen Erluterungen nicht ausreichend sind, betrachten wir einige Beispiele&colon.-
:ul.:li.Kopieren aus dem Rahmen-Handler:eul.
:p.Beim Kopieren von Rahmen im Rahmen-Handler, werden die Daten in verschiedenen Formaten in der
Zwischenablage gespeichert. Diese Formate umfassen den Rahmensatz, eine Bitmap und eine Metadatei.
Es sei angenommen, da die Rahmen aus der Zwischenablage kopiert werden sollen.
:p.Sind keine Beschrnkungen festgelegt, wird das erste verfgbare Format zum Erstellen des neuen Behlters
verwendet - in diesem Falle wre dies der Rahmensatz.
:p.Beschrnkt man den Kopiervorgang jedoch auf Bitmaps, erhlt man statt dessen einen neuen Bitmap-Behlter, und es
wird die Bitmap aus der Zwischenablage kopiert.
:ul.:li.Kopieren von Daten in die Tabelle:eul.
:p.Markiert man einen Bereich und kopiert ihn in die Zwischenablage, befindet sich dort anschlieend eine Reihe
verschiedener Datenformate. Angenommen, es wrde eine Tabelle mit smtlichen Behltertypen darin kopiert, so
knnte man mit dem Objekt 'Zwischenablage anzeigen' folgende Formate sehen&colon.
.*********  Please do not translate the clipboard strings, just add an explanation in (brackets) ***********
:xmp.
CONTENTS, Tables (Inhalt, Tabellen)
CONTENTS, Plain background (Inhalt, einfacher Hintergrund)
CONTENTS, bitmap handler (Inhalt, Bitmap-Handler)
BITMAP (Bitmap)
CONTENTS, Metafile (Inhalt, Metadatei)
Metafile (Metadatei)
FRAME, inbuilt (Rahmen, eingebaut)
CONTENTS, Plain text (Inhalt, einfacher Text)
Text (Text)
:exmp.
:p.Beschrnkte man den Kopiervorgang auf Bitmaps, so erhielte mant&colon.-
:xmp.
CONTENTS, Tables (Inhalt, Tabellen)
CONTENTS, bitmap handler (Inhalt, Bitmap-Handler)
BITMAP (Bitmap)
:exmp.
:p.Fgte man nun die Zwischenablage ohne Beschrnkung in eine neue Tabelle ein, she die neue Tabelle aus wie die
alte; die Anzahl Zellen, die Gre der Behlter und smtliche Bitmap-Behlter wrden in die neue Tabelle an die
gleichen Stellen kopiert. Es wrde der Eintrag 'Inhalt, Tabellen' aus der Zwischenablage eingefgt.
:p.Fgte man die Zwischenablage mit einer Beschrnkung auf Bitmaps in die neue Tabelle ein, bliebe die neue
Tabelle unverndert und es wrde ein neuer Bitmap-Behlter von der Gre des ausgewhlten Bereichs erstellt.
Es wrde der Eintrag 'Inhalt, Bitmap-Handler' aus der Zwischenablage eingefgt.
:ul.:li.Beschrnkungen bei Stilvorlagen:eul.
:p.Die fr das Festlegen eines Stils verfgbaren Stilvorlagen werden direkt durch Beschrnkungen beeinflut.
:p.Sind keine Beschrnkungen festgelegt, werden nur Stilvorlagen fr Tabellen angezeigt. Wre eine Beschrnkung
auf etwa Bitmaps gesetzt, wrden alle verfgbaren Stilvorlagen fr Bitmaps angezeigt. Mit anderen Worten
veranlat eine Beschrnkung auf Bitmaps den Tabellen-Handler, sich wie ein Bitmap-Handler zu verhalten und
alle verfgbaren Bitmap-Stile anzuzeigen.
:p.Wie bereits gesagt werden nur Stilvorlagen fr Tabellen angezeigt, wenn keine Beschrnkung festgelegt ist.
Enthielte die Tabellenstilvorlage eine Kindstilvorlage fr Bitmaps, wrden der Tabellenstil und, falls mglich,
auch der Kindstil fr Bitmaps gesetzt.
:p.Obiges ist zwar schwer zu erklren, aber einfach in der Anwendung. Die Komplexitt liegt in der Anwendung,
und nach kurzer Zeit wird die Nutzung von Beschrnkungen selbsterklrend.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=12 id=12 global.Daten ausschneiden und in Zwischenablage ablegen
:i2 refid=editmnu.Daten ausschneiden und in Zwischenablage ablegen
:p.Whlen Sie diesen Meneintrag, um die :link reftype=hd
res=2.ausgewhlten:elink. Tabellendaten in die Zwischenablage zu kopieren.
Die ausgewhlten Tabellendaten werden anschlieend gelscht, wo es angebracht ist.
:p.Dieser Befehl unterliegt sowohl :link reftype=hd
res=16.Beschrnkungen:elink. als auch der :link reftype=hd
res=2.Auswahl:elink..
:p.:hp2.Textbearbeitungsmodus:ehp2.
:p.Der Tabellen-Handler verhlt sich wie der Text-Handler. Der ausgewhlte Text wird
in die Zwischenablage kopiert und dann gelscht.
:p.Der Befehl Ausschneiden kann ber die Tastenkombination Umschalt + Entfernen ausgefhrt werden.
.*-----------------------------------------------------------------------------
:h2 res=13 id=13 global.Daten in Zwischenablage kopieren
:i2 refid=editmnu.Daten in Zwischenablage kopieren
:p.Whlen Sie diesem Meneintrag, um die :link reftype=hd
res=2.ausgewhlten:elink. Tabellendaten in die Zwischenablage zu kopieren.
Die ausgewhlten Tabellendaten werden nicht gelscht.
:p.Dieser Befehl unterliegt sowohl :link reftype=hd
res=16.Beschrnkungen:elink. als auch der :link reftype=hd
res=2.Auswahl:elink..
:p.:hp2.Textbearbeitungsmodus:ehp2.
:p.Der Tabellen-Handler verhlt sich wie der Text-Handler. Der ausgewhlte Text wird
in die Zwischenablage kopiert.
:p.Der Befehl Kopieren kann ber die Tastenkombination Strg + Einfgen ausgefhrt werden.
.*-----------------------------------------------------------------------------
:h2 res=14 id=14 global.Daten aus Zwischenablage einfgen
:i2 refid=editmnu.Daten aus Zwischenablage einfgen
:p.Whlen Sie diesen Meneintrag, um Daten aus der Zwischenablage in die :link reftype=hd
res=2.aktuelle Auswahl:elink. einzufgen. Wo erforderlich werden Behlter berschrieben.
:p.Dieser Befehl unterliegt sowohl :link reftype=hd
res=16.Beschrnkungen:elink. als auch der :link reftype=hd
res=2.Auswahl:elink..
:p.:hp2.Textbearbeitungsmodus:ehp2.
:p.Der Tabellen-Handler verhlt sich wie der Text-Handler. Markierter Text wird gelscht,
anschlieend wird der Text aus der Zwischenablage an der aktuellen Cursor-Position eingefgt.
:p.Der Befehl Einfgen kann ber die Tastenkombination Umschalt + Einfgen ausgefhrt werden.
.*-----------------------------------------------------------------------------
:h2 res=74 id=74 global.Rahmensatz aus Katalog laden
:i2 refid=editmnu.Rahmensatz aus Katalog laden
:p.Verwenden Sie diesen Befehl als Abkrzung zum Importieren von Rahmen aus einem
Clipart-Katalog.
:p.Rahmen werden als Clipart-Bild importiert und knnen nicht bearbeitet werden.
Eine Skalierung ist mglich, mu aber unter Beibehaltung der Grenverhltnisse
- also bei gleichem horizontaler und vertikaler Skalierungsfaktor - stattfinden.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=17 id=17 global.Daten aus Datei laden
:i2 refid=editmnu.Daten aus Datei laden
:p.Whlen Sie diesen Meneintrag als Abkrzung zum Importieren von Daten. Abhngig vom zu importierenden
Datentyp und der aktuellen :link reftype=hd res=2.Auswahl:elink. wird der ausgewhlte Bereich mit neuen Tabellendaten aktualisiert.
:p.Mit Hilfe dieses Dialogs knnen Daten in jedem Format geladen werden, welches der Tabellen-Handler
verarbeiten kann. Dazu gehren Bitmaps, Metadateien, Komma-getrennte Listen usw. Der Datentyp wird anhand
der Dateiendung erkannt. Anfnglich werden smtliche bekannten Datentypen aufgefhrt.
:p.:hp2.Textbearbeitungsmodus:ehp2.
:p.Der Tabellen-Handler verhlt sich wie der Text-Handler. Markierter Text wird gelscht,
anschlieend wird der Text aus der Datei an der aktuellen Cursor-Position eingefgt.
In der Liste der Datentypen werden nur mit Text kompatible Formate angezeigt.
.*-----------------------------------------------------------------------------
:h2 res=15 id=15 global.Daten lschen
:i2 refid=editmnu.Daten lschen
:p.Whlen Sie diesen Meneintrag, um die :link reftype=hd
res=2.ausgewhlten:elink. Tabellendaten zu lschen.
:p.Die Daten werden nicht in die Zwischenablage kopiert.
:p.Dieser Befehl unterliegt sowohl :link reftype=hd
res=16.Beschrnkungen:elink. als auch der :link reftype=hd
res=2.Auswahl:elink..
:p.Der Befehl Lschen kann ber die Taste Entfernen ausgefhrt werden.
.*-----------------------------------------------------------------------------
:h2 res=18 id=18 global.Gesamte Tabelle auswhlen
:i2 refid=editmnu.Gesamte Tabelle auswhlen
:p.Mit Hilfe dieses Meneintrags lt sich die gesamte Tabelle auswhlen. Dies ist ebenfalls
durch Klicken auf den entsprechenden Angriffspunkt der Auswahl in der Tabelle selbst
mglich.
:p.Die Auswahl der gesamten Tabelle ber den Meneintrag ist mitunter einfacher, besonders
wenn nicht die gesamte Tabelle sichtbar ist.
.*-----------------------------------------------------------------------------
:h2 res=36 id=36 global.Behlterbereiche anzeigen/bearbeiten
:i2 refid=editmnu.Behlterbereiche anzeigen/bearbeiten
:p.Mit Hilfe dieses Dialogs lassen sich die Behlter innerhalb des aktuellen Auswahlbereichs
anzeigen. Der Dialog bietet auerdem eine praktische Methode zum ndern der Gre und Verschieben
von Behltern. Die Reihenfolge, in der die Behlter angezeigt werden, kann nicht gendert werden.
:p.Whlen Sie im Listenfeld die zu bearbeitenden Behlter aus. Mit den vier Eingabefeldern
lassen sich die einschlieenden Start- und Endpunkte des BehlterBereichs anpassen.
:p.Denken Sie daran, da groe Tabellen eine groe Anzahl von Behltern enthalten knnen, was
solches Bearbeiten von Hand recht schwierig macht.
.*-----------------------------------------------------------------------------
:h2 res=35 id=35 global.Tabellengre festlegen
:i2 refid=editmnu.Tabellengre festlegen
:p.Benutzen Sie den Dialog 'Tabellengre' zur Festlegung der Gre einer Tabelle.
:p.Es wird versucht, das Breitenverhltnis unter bereits vorhandenen Zellen beizubehalten.
Wird eine neue Spalte hinzugefgt, werden alle bereits vorhandenen Zellen
so weit gestaucht, da die neue Spalte hineinpat, aber ohne alle Zellen gleich
breit zu machen. Wird eine Spalte entfernt, werden die verbleibenden Zellen
so verbreitert, da sie die Tabelle ausfllen, aber ohne alle Zellen gleich
breit zu machen.
:p.Steigt die Anzahl Zellen in der Tabelle, bleibt die Gre aller Behlter in
Zellen konstant. Wird die Anzahl Zellen in der Tabelle verringert, werden sich ber
die tatschlich verfgbare Anzahl Zellen hinaus erstreckende Behlter abgeschnitten.
:p.Die ausgewhlte Tabellengre kann gesichert werden, so da alle neuen Tabellen mit dieser
Gre erstellt werden.
.*-----------------------------------------------------------------------------
:h3 res=37 id=37 global.Zeile oder Spalte einfgen/lschen
:i2 refid=editmnu.Zeile oder Spalte einfgen/lschen
:p.Wenn eine Zeile oder Spalte eingefgt wird, geschieht dies nach der aktuellen Auswahl.
:p.Der Vorgang des Einfgens einer Zeile oder Spalte kann dazu fhren, da Behlter zur
Bercksichtigung der neuen Zeile oder Spalte in der Gre gendert werden.
.*-----------------------------------------------------------------------------
:h3 res=38 id=38 global.Breite von Zeilen oder Spalten angleichen
:i2 refid=editmnu.Breite von Zeilen oder Spalten angleichen
:p.Gleicht die Breite der ausgewhlten Zeilen oder Spalten an. Indem nur ein Teil der
Tabelle ausgewhlt wird, kann verhindert werden, da auch Zellen auerhalb der Auswahl
in der Gre gendert werden. Um alle Zellen gleich gro zu machen, mu die gesamte
Tabelle ausgewhlt werden.
.*-----------------------------------------------------------------------------
:h2 res=101 id=101 global.Zellenstil auswhlen
:i2 refid=editmnu.Zellenstil auswhlen
:p.Benutzen Sie dieses Men, um einen Zellenstil anzuwenden. Bei Auswahl der kleinen
Schaltflche zur rechten des Meneintrages werden die verfgbaren Zellenstile aufgefhrt.
Whlt man einen der aufgefhrten Stil aus, wird die aktuelle Auswahl mit den Behltern
aus dem Stil aktualisiert.
:p.Dieser Befehl unterliegt sowohl :link reftype=hd
res=16.Beschrnkungen:elink. als auch der :link reftype=hd
res=2.Auswahl:elink..
:p.Siehe :link reftype=hd res=100.Zellenstil sichern:elink.. fr
weitere Informationen ber Stile.
.*-----------------------------------------------------------------------------
:h2 res=73 id=73 global.Behlterbearbeitungsmodi
:i2 refid=editmnu.Behlterbearbeitungsmodi
:p.Fr die Bearbeitung vorhandener Behlter sind zwei Bearbeitungsmodi erforderlich.
:p.Zuallererst schaltet der Handler standardmig in den Einfgemodus, in dem nderungen
zur Erzeugung eines neuen Behlters fhren, der alle vorhandenen Behlter vom gleichen Typ berschreibt,
die sich unter der aktuellen Bereichsauswahl befinden.
:p.Im Modus Ersetzen wird der Behlter unterhalb der aktuellen Zellenauswahl modifiziert,
so da andere Behlter nicht beeinflut werden.
:p.Bei Text wird das Verhalten auerdem durch die Schaltflche :link reftype=hd
res=72.Textbearbeitungsmodus:elink. beeinflut. Ist der Textbearbeitungsmodus aktiviert,
so bersteuert er die Behlterbearbeitungsmodi, so da Text normal bearbeitet werden kann.
.*-----------------------------------------------------------------------------
:h2 res=72 id=72 global.Textbearbeitungsmodus
:i2 refid=editmnu.Textbearbeitungsmodus
:p.Beim Umschalten in den Textbearbeitungsmodus hebt der Tabellen-Handler jedwede
Zellenauswahl auf und aktiviert das normale Bearbeiten des aktuellen Textbehlters.
:p.Es ist mglich, Text in eine Zelle einzugeben, ohne den Textbearbeitungsmodus zu benutzen.
Wenn jedoch ein Textblock von mehr als einer einzigen Zelle oder ein Textblock mit
Tabulatoren oder mehr als einem Absatz gewnscht sind, mu in den Textbearbeitungsmodus
umgeschaltet werden.
:p.Befindet sich unter der derzeit ausgewhlten Zelle kein Textbehlter, so wird
ein neuer erzeugt. Der neue Textbehlter erhlt die Gre des derzeit ausgewhlten
Bereichs.
:p.Mit dem Tabellen-Handler knnen nicht ohne weiteres berlappende Textobjekte erstellt werden.
Man kann zwar fr aneinandergrenzende Textbehlter mit Hilfe des Dialogs
:link reftype=hd res=36.Behlterbereiche anzeigen/bearbeiten:elink. eine
berlappung erzwingen, aber dies hat wenig Sinn.
:p.:hp2.Verhalten in den unterschiedlichen Bearbeitungsmodi:ehp2.
:dl compact tsize=32.
:dt.Behltereinfgemodus:dd.Textbearbeitungssteuerelemente ndern die Werkzeugleiste, haben
aber keinen Einflu auf die Behlter.
:dt.Behlterersatzmodus:dd.Textbearbeitungssteuerelemente ndern smtliche ausgewhlten Behlter.
:dt.Textbearbeitungsmodus:dd.Textbearbeitungssteuerelemente ndern den hervorgehobenen Text, die
Beschreibungen der einzelnen Steuerelemente setzen diesen Modus voraus.
:edl.
.*-----------------------------------------------------------------------------
:h2 res=10 id=10 global.Texteditorfunktionen
:i2 refid=editmnu.Texteditorfunktionen
:p.Der Tabellen-Handler bietet eine Reihe von Funktionen, die sich auch im Men Bearbeiten des Texteditors
finden.
:p.Dazu gehren&colon.
:ul.
:li.:link reftype=hd res=57.Zeichen einfgen:elink.
:li.(*):link reftype=hd res=64.Restrechtsbndigkeit einfgen:elink.
:li.:link reftype=hd res=53.Objekt einfgen/Einstellungen:elink.
:li.:link reftype=hd res=63.Funote/Einstellungen einfgen:elink.
:li.:link reftype=hd res=75.Formel/Einstellungen einfgen:elink.
:li.:link reftype=hd res=46.Steuerzeichen einfgen:elink.
:li.(*):link reftype=hd res=41.Einzuarbeitende Zeile auswhlen:elink.
:li.:link reftype=hd res=54.Text suchen:elink.
:li.:link reftype=hd res=65.Wortanzahl:elink.
:li.(*):link reftype=hd res=66.Rechtschreibprfung:elink.
:li.:link reftype=hd res=69.Artikelinformationen:elink.
:eul.
:p.Die obigen, mit (*) markierten Funktionen funktionieren nur im :link reftype=hd
res=72.Textbearbeitungsmodus:elink..
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=57 id=57 global.Zeichen einfgen
:i2 refid=editmnu.Zeichen einfgen
:p.Mit Hilfe dieses Dialogs knnen Zeichen aus einem Listenfeld ausgewhlt
werden. Dies ist sehr praktisch in Fllen, wo Zeichen nicht einfach ber die
Tastatur zur Verfgung stehen oder zur Auswahl von Symbolen aus einer
Symbolschriftart, bei der die Tastenbelegung nicht klar ist.
:p.Bei zu kleinen Zeichen gibt es zwei Mglichkeiten&colon.
:ul.
:li.Whlen Sie im Listenfenster 'Schriftgre' eine hhere Schriftgre.
:li.Zoomen Sie mit Hilfe der Zoom-Schaltflchen im Hauptfenster in das Dokument hinein.
:eul.
:p.In jedem Fall knnen in diesem Dialog Schriftart, -schnitt und -gre sowie 
das gewisse Zeichen ausgewhlt werden. Hat man das Zeichen ausgewhlt, kann 
dieses durch Drcken der Schaltflche 'Einfgen' an der derzeitigen 
Cursor-Position eingefgt werden. Zum Verlassen des Dialogs ist die 
Schaltflche 'Beenden' zu bettigen. 
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=64 id=64 global.Restrechtsbndigkeit einfgen
:i2 refid=editmnu.Restrechtsbndigkeit einfgen
:p.Funktioniert nur im :link reftype=hd res=72.Textbearbeitungsmodus:elink..
:p.Die Restrechtsbndigkeit hnelt etwas einem Tabulator, sorgt jedoch dafr, da der restliche
Text in einer Zeile an der rechten Seite ausgerichtet wird.
:p.Die Restrechtsbndigkeit unterliegt einer Reihe von Einschrnkungen&colon.
:ul.
:li.Sie mu hinter allen normalen Tabulatoren einer Zeile auftauchen.
:li.Sie kann nur einmal pro Zeile verwendet werden.
:li.Die Zeile mu linksbndig oder im Blocksatz ausgerichtet sein.
:eul.
:p.Sind nicht smtliche obigen Bedingungen erfllt, wird die Restrechtsbndigkeit ignoriert.
:p.:hp2.Anwendungszwecke:ehp2.
:p.Mit Hilfe der Restrechtsbndigkeit knnen am Ende eines Artikels oder Absatzes End-Bullets plaziert
oder Bilder im Text an den rechten Rand gezwungen werden.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=53 id=53 global.Objekte einfgen/Einstellungen
:i2 refid=editmnu.Objekte einfgen/Einstellungen
:p.Bilder im Text sind besonders in Situationen ntzlich, wenn ein Bild ein bestimmtes Verhltnis
zum Text behalten mu. Wird der Text gendert, wird das Bild im Text im Zuge des normalen
Neuformatierungsvorgangs neu positioniert.
:p.Bezglich der Gre werden Bilder im Text wie besondere Schriftzeichen behandelt. Die vertikale
Ausdehnung wird in Punkten angegeben und die horizontale daraus ermittelt.
:p.Zum Einfgen und Bearbeiten von Bildern im Text wird derselbe Dialog verwendet.
:p.:hp2.Laden von Bildern:ehp2.
:p.Es ist nicht mglich, ber ein vorhandenes Bild ein anderes zu laden. Das vorhandene Bild
mu zuerst gelscht und dann das neue eingefgt werden. Dies rhrt daher, da sich die Bilder
wie Zeichen verhalten.
:p.Whlen Sie den erforderlichen Bildtyp aus und klicken Sie auf 'Laden >>' (oder 'Einfgen',
wenn Sie aus der Zwischenablage kopieren). Legen Sie den bentigten Versatz, die Gre und
die Rnder fest und klicken Sie dann auf 'OK', um das Bild in den Text einzufgen.
:p.:hp2.Bearbeiten von Bildern:ehp2.
:p.Um das Bild im Text zu bearbeiten, plazieren Sie den Zeiger am Anfang des Bildes und
rufen den Dialog 'Bild im Text bearbeiten' auf. Fhren Sie dann alle gewnschten nderungen
durch und drcken Sie 'Anwenden'. Sie knnen so lange mit der Anwendung von nderungen
fortfahren, bis das Bild perfekt positioniert ist. Nach Abschlu der Arbeiten drcken
Sie 'Beenden'.
:p.Die Grundlinie von Bildern im Text kann so versetzt werden, da sie ordnungsgem
mit dem Text ausgerichtet sind. Auerdem ist es mglich, Rnder um das Bild zu bestimmen
und damit eine Feinabstimmung der Positionierung des umgebenden Textes vorzunehmen.
Die Randrichtungen richten sich nach der derzeitigen Ausrichtung des Texts, nicht des Bildes.
Bilder werden, soweit mglich, entsprechend der Zeichenausrichtung gedreht.
:p.:hp2.Zustzliche Modi fr Bilder in Textblcken:ehp2.
:p.Der voreingestellte Texteinpassungsmodus kann deaktiviert und ein berlappen hinderlichen
Texts durch das Bild erlaubt werden. Es besteht dann immer noch die Mglichkeit, den Text mit
Hilfe der Dialoge fr Absatz- und Zeileneinstellungen zu positionieren.
:p.Ansonsten verhalten sich Bilder im Text genau wie Zeichen, sie werden mit dem Text skaliert
und gedreht und "tanzen nicht aus der Reihe".
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=63 id=63 global.Funoten einfgen und bearbeiten
:i2 refid=edit.Funoten einfgen und bearbeiten
:p.:hp2.bersicht:ehp2.
:p.Mit Hilfe von Funoten lt sich Text mit Anmerkungen versehen. Funoten werden im Textkrper als
hochgestellte Zeichenkette dargestellt. Diese hochgestellte Zeichenkette wird als Funotenzeichen bezeichnet.
:p.Funoten bestehen aus drei Teilen, dem Funotenzeichen, dem Funotentitel und dem Funotentext selbst.
:p.Der Stil fr das Funotenzeichen mu im gesamten Artikel gleich sein.
:p.Funoten sind halbautomatisch und dadurch etwas komplizierter in der Bedienung, besitzen damit aber auch
eine Reihe leistungsfhiger Merkmale.
:p.:hp2.Das Funotenzeichen:ehp2.
:p.Das Funotenzeichen lt sich nur bei der ersten Funote eines Artikels anpassen. Bei den folgenden
Funoten sind die Steuerelemente fr Funotenzeichen deaktiviert.
:p.Das einfachste Funotenzeichen ist ein Zhler. Durch Auswahl des Markierungsfeldes 'Sperren' und Eintragen
einer Zahl in das nebenstehende Eingabefeld kann ein Startwert fr den Zhler festgelegt werden. Dieses Verfahren
erlaubt es, Funoten ber mehrere Artikel hinweg fortlaufend zu numerieren. Mit Hilfe des manuell festgelegten
Startwerts knnen Sie entscheiden, in welcher Reihenfolge Artikel aufgefhrt werden.
:p.Bei Funoten, die allen Textartikeln gemeinsam sind, ist es wahrscheinlich am besten, den Funotentitel als
Funotenzeichen zu verwenden.
:p.:hp2.Der Funotentitel:ehp2.
:p.Der Funotentitel wird als berschrift fr die Funote verwendet. Darber hinaus ist der Funotentitel im
Hilfefeld der Statuszeile sichtbar, wenn sich der Cursor auf einer Funote befindet.
:p.:hp2.Der Funotentext:ehp2.
:p.Der Funotentext kann aus beliebigem Text bis zu einer Gre von etwa 32 K bestehen. Das sollte fr die
meisten Funoten ausreichen.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=75 id=75 global.Formeln einfgen oder bearbeiten
:i2 refid=editmnu.Formeln einfgen oder bearbeiten
:p.Dieser Handler untersttzt eine Reihe einfacher Tabellenkalkulationsfunktionen.
:p.Diese knnen direkt in den Formeldialog eingegeben werden. Bei Bedarf erfolgt eine
Neuberechnung.
:p.Der diesem Vorgang zugrundeliegende Mechanismus besitzt eine sehr einfache und natrliche
Benutzerschnittstelle.
:p.Wie bei allen Skriptsprachen besteht auch hier das Risiko eines Absturzes, wenn ein wirklich
sinnloses Skript eingegeben wird.
:p.Ein gebruchliches Beispiel fr eine Aufsummierung eines Zellenbereichs&colon.
:xmp.
fix(6, sum(e1..e12))
:exmp.
:p.Der Teil fix(6,...) des Skripts legt die Anzahl der Dezimalstellen auf sechs fest und sollte
in jedem Skript, welches die Anzahl der Dezimalstellen auf einen anderen Wert als 2 einstellt,
stets an erster Stelle stehen. Die Funktion sum(e1..e12) fhrt die Addition der Werte im
Bereich 'e1' bis 'e12' auf.
:p.Weitere Informationen siehe&colon.
:ul.
:li.:link reftype=hd res=78.Formelsyntax:elink.
:li.:link reftype=hd res=76.Funktionen in Formeln:elink.
:li.:link reftype=hd res=77.Variablen und Konstanten in Formeln:elink.
:li.:link reftype=hd res=79.Fehlerrckgabewerte fr Skripte:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=78 id=78 global.Formelsyntax
:i2 refid=editmnu.Formelsyntax
:p.:hp2.Formeln unterliegen einigen sehr einfachen Syntaxregeln:ehp2.
:ul.
:li.Jeglicher von runden Klammern gefolgter Text wird als Funktion angesehen,
z.B. :hp2.sum():ehp2..
:li.Jeglicher von eckigen Klammern gefolgter Text wird als Element eines Arrays angesehen.
In dieser Implementierung stehen jedoch keine Arrays zur Verfgung!
:li.Jeglicher von einer Nummer gefolgter Text, z.B. :hp2.aa34:ehp2. oder :hp2.a&colon.e3:ehp2.,
wird als Verweis auf eine Zelle angesehen.
:li.Jeder Ausdruck mit zwei durch zwei Punkte getrennten Zellenverweisen, z.B. :hp2.a3..c12:ehp2.,
wird als Verweis auf einem Zellenbereich angesehen.
:li.Jeder Eintrag, der mathematische Operatoren wie +,-,* usw. enthlt, wird als Berechnung
behandelt.
:li.Kommentare im C- und C++-Stil sollten funktionieren, aber nicht mitten in einer
Funktion oder Berechnung verwendet werden. Plazieren Sie sie am Ende.
:hp2./* So sehen C-Kommentare aus. */:ehp2.
:li.Zeichenketten werden in Anfhrungszeichen gestellt. Bei Eingabe von "Hallo da" gibt die
Formel "Hallo da" zurck. Dies ist wahrscheinlich nicht sehr ntzlich. Man knnte es zur
Ausgabe von Erinnerungen wie "Nicht vergessen, dies zu bearbeiten!" benutzen.
:eul.
:p.:hp2.Berechnungsreihenfolge:ehp2.
:p.Berechnungen werden von links nach rechts durchgefhrt, wobei keine Prioritten gelten.
Soll etwas in einer bestimmten Reihenfolge berechnet werden, mssen Klammern eingesetzt werden.
:xmp.
fix(2, (a3 + b5) / 2))
:exmp.
:p.Wird keine Funktion verwendet, sollte die Berechnung in Klammern gesetzt werden. Andernfalls
kann es zu einer Fehlermeldung kommen.
:xmp.
(27.0345) /* gibt diese Zahl zurck */
:exmp.
:p.:hp2.Mathematische Ausdrcke:ehp2.
:p.Ausdrcke sollten stets in Klammern eingeschlossen werden oder Teil einer Funktion sein.
:p.unre Logik mit ganzen Zahlen
:parml tsize=16 break=fit.
:pt.!:pd.logisches NICHT.
:eparml.
:p.:hp9.unre Berechnungen mit ganzen Zahlen:ehp9.
:parml tsize=16 break=fit.
:pt.~:pd.mathematische Inversion
:pt.#:pd.abs. Tatschliche Werte mssen in Klammern angegeben werden, z.B. #(-5).
:eparml.
:p.:hp9.binre Logik mit ganzen Zahlen:ehp9.
:parml tsize=16 break=fit.
:pt.&amp.&amp.:pd.logisches UND.
:pt. oder ||:pd.logisches ODER.
:pt.==:pd.logisches GLEICH.
:pt.!=:pd.logisches UNGLEICH.
:pt.>=:pd.logisches GRSSER ODER GLEICH.
:pt.<=:pd.logisches KLEINER ODER GLEICH.
:pt.>:pd.logisches GRSSER ALS.
:pt.<:pd.logisches KLEINER ALS.
:eparml.
:p.:hp9.binre Berechnungen:ehp9.
:parml tsize=16 break=fit.
:pt.+:pd.mathematische ADDITION.
:pt.-:pd.mathematische SUBTRAKTION.
:pt.*:pd.mathematische MULTIPLIKATION.
:pt./:pd.mathematische DIVISION.
:pt.%:pd.mathematischer MODULO.
:eparml.
:p.:hp9.binre Berechnungen mit ganzen Zahlen:ehp9.
:parml tsize=16 break=fit.
:pt.&amp.:pd.mathematisches UND.
:pt. oder |:pd.mathematisches ODER.
:eparml.
:p.Logische Ausdrcke ergeben stets 0 oder 1. Das Ergebnis mathematischer Ausdrcke wird stets
mit doppelter Genauigkeit zurckgegeben, ausgenommen Ganzzahlberechnungen, bei denen 32-Bit-Zahlen
verwendet werden.
:p.Beim Versuch einer Division durch Null wird das Skript mit einer Fehlermeldung abgebrochen.
:p.Weitere Informationen siehe&colon.
:ul.
:li.:link reftype=hd res=76.Funktionen in Formeln:elink.
:li.:link reftype=hd res=77.Variablen und Konstanten in Formeln:elink.
:li.:link reftype=hd res=79.Fehlerrckgabewerte fr Skripte:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=76 id=76 global.Funktionen in Formeln
:i2 refid=editmnu.Funktionen in Formeln
:p.:hp2.Funktionen:ehp2.
:p.Folgende Funktionen werden erkannt&colon.
:parml tsize=10 break=all.
:pt.:hp2.nop(<modus>,<wert>):ehp2.:pd.Unterdrckt die Ausgabe des Ergebnisses. Diese Funktion funktioniert nur, wenn sie
im Skript an erster Stelle steht. Es ist sowohl mglich, nop() vor fix() zu benutzen, als auch fix() vor nop(). Ist <modus>
gleich Null, wird die Ausgabe unterdrckt, es sei denn, das Ergebnis ist ungleich Null. Ist <modus> ungleich Null,
so ist das Ergebnis der Gleichung unsichtbar und wird niemals ausgegeben.
:pt.:hp2.fix(<anzahl>,<wert>):ehp2.:pd.Legt die Anzahl Stellen nach dem Dezimalpunkt fest. Diese
Funktion funktioniert nur, wenn sie im Skript an erster Stelle steht. 
Man kann sowohl nop() vor fix() verwenden als auch fix() vor nop().
Sie liee sich fr die
Berechnung von Geldbetrgen so verwenden&colon. 'fix(2, sum(a0..a3, a7, e0..g11))'. Voreingestellt
sind 2 Dezimalstellen, aber die Berechnungen werden auf 12 oder mehr Dezimalstellen genau
durchgefhrt.
:pt.:hp2.ofs(<xoffs>, <yoff>, <cx>, <cy>):ehp2.:pd.Ermglicht die Angabe eines Bereichs oder Wertes als
Versatz von der linken oberen Ecke des derzeitigen Bereichs aus. Dies kommt grtenteils in Fllen zum Einsatz,
bei denen die gleiche Formel zur Durchfhrung einer Reihe gleicher Berechnungen verwendet wird, wie etwa
der Multiplikation eines Wertes mit einer Zahl, die sich in der linken Nachbarzelle befindet&colon.
(ofs(0, -2) * ofs(0, -1)) wrde die Zelle links von dieser mit ihrem linken Nachbarn multiplizieren und
das Ergebnis in dieser Zelle ausgeben. Darber hinaus kann ein Versatzbereich angegeben werden.
ofs(-10, -10, 3, 4) gbe einen Bereich zurck, den man als Eingabe fr Funktionen weiterverwenden kann,
die Bereiche akzeptieren, wie beispielsweise sum&colon. sum(ofs(-10, -10, 3, 4))
:pt.:hp2.sum(<bereiche>):ehp2.:pd.Die Summe aller angegebener Werte. Es knnen, durch Komma getrennt,
bis zu sieben Bereiche oder Zellen in folgender Form angegeben werden&colon.
'sum(a0..a3, a7, e0..g11)'. Dieses Beispiel zeigt die Verwendung von drei Bereichen oder Zellen.
:pt.:hp2.diff(<bereiche>):ehp2.:pd.Die maximale Abweichung aller angegebener Werte.
Es knnen, durch Komma getrennt,
bis zu sieben Bereiche oder Zellen in folgender Form angegeben werden&colon.
'diff(a0..a3, a7, e0..g11)'. Dieses Beispiel zeigt die Verwendung von drei Bereichen oder Zellen.
:pt.:hp2.mean(<bereiche>):ehp2.:pd.Der Durchschnitt aller angegebener Werte. Er wird als
arithmetisches Mittel des kleinsten und grten Wertes ermittelt.
Es knnen, durch Komma getrennt,
bis zu sieben Bereiche oder Zellen in folgender Form angegeben werden&colon.
'mean(a0..a3, a7, e0..g11)'. Dieses Beispiel zeigt die Verwendung von drei Bereichen oder Zellen.
:pt.:hp2.avg(<bereiche>):ehp2.:pd.Das arithmetische Mittel aller angegebenen Werte. Es berechnet sich
als Summe aller Werte geteilt durch deren Anzahl.
:pt.:hp2.min(<bereiche>), max(<bereiche>):ehp2.:pd.Gibt Maximum und Minimum zurck, wie sie von mean()
verwendet werden.
:pt.:hp2.sqrt(<x>):ehp2.:pd.berechnet den nicht-negativen Wert der Quadratwurzel von x.
:pt.:hp2.exp(<x>):ehp2.:pd. berechnet die Exponentialfunktion einer Fliekommazahl x 
(e hoch x, wobei e gleich 2.17128128... ist).
:pt.:hp2.abs(<n>):ehp2.:pd.gibt den Betrag einer ganzen Zahl n zurck. 
:pt.:hp2.floor(<x>):ehp2.:pd.berechnet die grte ganze Zahl, die kleiner oder gleich x ist.
:pt.:hp2.ceil(<x>):ehp2.:pd.berechnet die kleinste ganze Zahl, die grer oder gleich x ist.
:pt.:hp2.gamma(<x>):ehp2.:pd.berechnet ln( |G(x)| ), wobei x eine positive reelle Zahl sein mu.
:pt.:hp2.hypot(<seite1>, <seite2>):ehp2.:pd.berechnet die Lnge der Hypotenuse eines rechtwinkligen
Dreiecks basierend auf der Lnge der beiden Seiten seite1 und seite2. Hypot entspricht&colon.
sqrt(seite1 * seite1 + seite2 * seite2);
:pt.:hp2.pow(<x>, <y>):ehp2.:pd.berechnet den Wert x hoch y. 
:pt.:hp2.logn(<x>):ehp2.:pd.berechnet den natrlichen Logarithmus (zur Basis e) von x. 
:pt.:hp2.log(<x>):ehp2.:pd.berechnet den dekadischen Logarithmus von x. 
:pt.:hp2.acos(<x>):ehp2.:pd.berechnet den Arcussinus von x im Bogenma im Bereich 0 bis Pi. 
:pt.:hp2.asin(<x>):ehp2.:pd.berechnet den Arcussinus von x im Bogenma im Bereich -pi/2 bis pi/2.
:pt.:hp2.atan(<x>):ehp2.:pd.berechnet den Arcustangens von x.
:pt.:hp2.cos(<x>):ehp2.:pd.berechnet den Cosinus von x, wobei x im Bogenma anzugeben ist.
Bei zu groen x kann es zu Ungenauigkeiten kommen.
:pt.:hp2.cosh(<x>):ehp2.:pd.berechnet den Cosinus hyperbolicus von x, wobei x im Bogenma anzugeben
ist.
:pt.:hp2.sin(<x>):ehp2.:pd.berechnet den Sinus von x, wobei x im Bogenma anzugeben ist.
Bei zu groen x kann es zu Ungenauigkeiten kommen.
:pt.:hp2.sinh(<x>):ehp2.:pd.berechnet den Sinus hyperbolicus von x, wobei x im Bogenma anzugeben
ist.
:pt.:hp2.tanh(<x>):ehp2.:pd.berechnet den Tangens hyperbolicus von x, wobei x im Bogenma anzugeben
ist.
:pt.:hp2.tan(<x>):ehp2.:pd.berechnet den Tangens von x, wobei x im Bogenma anzugeben ist.
:eparml.
:p.Weitere Informationen siehe&colon.
:ul.
:li.:link reftype=hd res=78.Formelsyntax:elink.
:li.:link reftype=hd res=77.Variablen und Konstanten in Formeln:elink.
:li.:link reftype=hd res=79.Fehlerrckgabewerte fr Skripte:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=77 id=77 global.Variablen und Konstanten in Formeln
:i2 refid=editmnu.Variablen und Konstanten in Formeln
:p.:hp2.Konstanten:ehp2.
:p.Dieser Handler erkennt folgende Konstanten&colon.
:parml tsize=30 break=fit.
:pt.:hp2.true:ehp2.:pd.= 1
:pt.:hp2.false:ehp2.:pd.= 0
:pt.:hp2.pi:ehp2.:pd.= 3.14159265358979323846
:pt.:hp2.e:ehp2.:pd.= 2.718281828459045
:eparml.
:p.:hp2.Variablen:ehp2.
:p.Variablen bestehen aus Tabellenzellen oder Bereichen und knnen folgende Form besitzen&colon.
:parml tsize=30 break=fit.
:pt.:hp2.a1:ehp2.:pd.Die Zelle a1
:pt.:hp2.a&colon.a1:ehp2.:pd.Die Zelle a1
:pt.:hp2.a1..e27:ehp2.:pd.Der Bereich a1 bis e27
:pt.:hp2.a&colon.a1..e27:ehp2.:pd.Der Bereich a1 bis e27. Das Arbeitsblatt ist stets a&colon., da
derzeit keine weiteren zur Verfgung stehen.
:pt.:hp2.a1..a&colon.e27:ehp2.:pd.Der Bereich a1 bis e27. Das Arbeitsblatt ist stets a&colon., da
derzeit keine weiteren zur Verfgung stehen.
:pt.:hp2.a&colon.a1..a&colon.e27:ehp2.:pd.Der Bereich a1 bis e27. Das Arbeitsblatt ist stets a&colon., da
derzeit keine weiteren zur Verfgung stehen.
:eparml.
:p.Variablenbereiche werden anders behandelt als Zellen. Bei unpassenden Bereichen wird die
Ausfhrung des Skripts unterbrochen.
:p.Weitere Informationen siehe&colon.
:ul.
:li.:link reftype=hd res=78.Formelsyntax:elink.
:li.:link reftype=hd res=76.Funtionen in Formeln:elink.
:li.:link reftype=hd res=79.Fehlerrckgabewerte fr Skripte:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=79 id=79 global.Fehlerrckgabewerte fr Skripte
:i2 refid=editmnu.Fehlerrckgabewerte fr Skripte
:p.Es folgt eine vollstndige Aufstellung smtlicher Fehlerwerte, die vom Skriptmechanismus
zurckgegeben werden knnen. Es ist durchaus mglich, da manche dieser Fehler nicht
ausgelst werden knnen, was bedeutet, da Sie sie nie sehen werden, da sie vom Tabellen-Handler
nicht verwendet werden.
:p.Obwohl eine Vielzahl verschiedener Programmieranstze getestet wurde, knnen Fliekommafehler
in der C-Standardbibliothek einen Absturz der Anwendung zufolge haben. In den Skripten wird
versucht, die meisten potentiell problematischen Zahlen bei der bergabe an die mathematischen
Funktionen der C-Bibliothek abzufangen, bevor es dazu kommen kann. Es verbleibt jedoch ein
Restrisiko.
:p.Wird ein Skript whrend der Aktualisierung der Bildschirmdarstellung ausgefhrt, so werden
Fehler nicht in einem Fehlerdialog angezeigt. Statt dessen wird der Fehlerwert als Zeichenkette
zurckgegeben.
:p.ffnet man den Skriptdialog, wird der Fehlerwert in die zugehrige Fehlermeldung umgewandelt,
die dann im Ergebnisfeld angezeigt wird. Das Skript wird vor dem Einfgen in den Textbehlter
ausgefhrt. Auf diese Weise sollten die meisten Fehler aufgedeckt werden, ausgenommen
Rekursions- und andere Stackfehler.
.**** A note to translators - The error codes, such as 'ERR00001', should not be altered. ****
:p.:hp2.Fehler - Beschreibung:ehp2.
:p.:hp2.ERR00000 - kein Fehler:ehp2.
:p.Kein Fehler, sondern nur ein Platzhalter.
:p.:hp2.ERR00001 - zu wenige Parameter:ehp2.
:p.Eine Funktion erwartet mehr als die angegebene Anzahl Parameter.
:p.:hp2.ERR00002 - fehlende Zuweisung:ehp2.
:p.Eine mathematische Operation erwartet ein weiteres Argument.
:p.:hp2.ERR00003 - Ausdruck am Dateiende:ehp2.
:p.Das Skript wurde beendet, bevor der Ausdruck aufgelst werden konnte.
:p.:hp2.ERR00004 - Parameter am Dateiende:ehp2.
:p.Das Skript wurde beendet, bevor der Parameter aufgelst werden konnte.
:p.:hp2.ERR00005 - Zeichenkette am Dateiende:ehp2.
:p.Das Skript wurde beendet, bevor die Zeichenkette aufgelst werden konnte.
:p.:hp2.ERR00006 - zu wenig Speicher:ehp2.
:p.Dem Skript steht zu wenig Arbeitsspeicher zur Verfgung.
:p.:hp2.ERR00007 - Befehlsbegrenzer fehlt:ehp2.
:p.Ein Befehlsbegrenzer fehlt.
:p.:hp2.ERR00008 - Kommentar am Dateiende:ehp2.
:p.Das Skript wurde beendet, bevor der Kommentar beendet wurde.
:p.:hp2.ERR00009 - Anfhrungszeichen am Dateiende:ehp2.
:p.Das Skript wurde beendet, bevor eine Zeichenkette aufgelst werden konnte.
:p.:hp2.ERR00010 - Skript durch Anwender abgebrochen:ehp2.
:p.Sie haben die Taste <esc> gedrckt, um das Skript zu beenden.
:p.:hp2.ERR00011 - Fehler in Befehlssyntax:ehp2.
:p.Eine Funktion wurde nicht ordnungsgem eingegeben.
:p.:hp2.ERR00012 - mathematischer Ausdruck am Dateiende:ehp2.
:p.Das Skript wurde beendet, bevor der Ausdruck aufgelst werden konnte.
:p.:hp2.ERR00013 - unerwarteter Wert oder unrer Ausdruck:ehp2.
:p.Ein mathematischer Ausdruck erwartet eine einzelne Zahl.
:p.:hp2.ERR00014 - zweiteiliger Ausdruck erwartet:ehp2.
:p.Ein mathematischer Ausdruck erwartet zwei Zahlen.
:p.:hp2.ERR00015 - fehlender Ausdruck:ehp2.
:p.Es fehlt ein mathematischer Ausdruck.
:p.:hp2.ERR00016 - Wert nach unrem Ausdruck erwartet:ehp2.
:p.Ein mathematischer Ausdruck erwartet eine einzelne Zahl. Dies wre z.B. bei '(!)' statt '(!etwas)' der Fall.
:p.:hp2.ERR00017 - Fehler in Ausdruckssyntax:ehp2.
:p.Ein mathematischer Ausdruck wurde nicht erkannt.
:p.:hp2.ERR00018 - Division durch Null:ehp2.
:p.Es wurde versucht, durch Null zu teilen, wie etwa bei '(100 / 0)'.
:p.:hp2.ERR00019 - Zuweisung nicht erlaubt, versuchen Sie es mit '==':ehp2.
:p.Es ist nicht mglich, Variablen Werte zuzuweisen. Variablen knnen nur miteinander verglichen
werden.
:p.:hp2.ERR00020 - keine Parameter gefunden:ehp2.
:p.Eine Funktion erwartet die Angabe eines oder mehrerer Parameter.
:p.:hp2.ERR00021 - Parameter darf keine Zeichenkette sein:ehp2.
:p.Eine Funktion erwartet einen Parameter, der keine Zeichenkette ist.
:p.:hp2.ERR00022 - Parameter darf kein Bereich sein:ehp2.
:p.Eine Funktion erwartet einen Parameter, der kein Tabellenbereich ist.
:p.:hp2.ERR00023 - Befehl unbekannt:ehp2.
:p.Der Name dieser Funktion ist unbekannt.
:p.:hp2.ERR00024 - Maximale Rekursionstiefe berschritten:ehp2.
:p.Das Skript hat sich fter selbst aufgerufen, als erlaubt. Dies kann geschehen, wenn ein
Tabellenbereich aufsummiert werden soll, der die Zelle enthlt, in der das Ergebnis eingetragen
werden soll.
:p.:hp2.MLIB0001 - MATHLIB&colon.Parameter auerhalb gltigen Bereichs:ehp2.
:p.Das Ergebnis einer Funktion der C-Standardbibliothek befindet sich auerhalb des gltigen
Bereichs.
:p.:hp2.MLIB0002 - MATHLIB&colon.berschreitung des gltigen Bereichs:ehp2.
:p.Das Ergebnis einer Funktion der C-Standardbibliothek berschreitet den gltigen
Bereich.
:p.:hp2.MLIB0003 - MATHLIB&colon.Unterschreitung des gltigen Bereichs:ehp2.
:p.Das Ergebnis einer Funktion der C-Standardbibliothek unterschreitet den gltigen
Bereich.
:p.:hp2.MLIB0004 - MATHLIB&colon.Vollstndiger Signifikanzverlust:ehp2.
:p.Das Ergebnis einer Funktion der C-Standardbibliothek ist vollkommen sinnlos.
:p.:hp2.MLIB0005 - MATHLIB&colon.Teilweiser Signifikanzverlust:ehp2.
:p.Das Ergebnis einer Funktion der C-Standardbibliothek ist ungenau.
:p.:hp2.MLIB006 - MATHLIB&colon.Ungeeigneter Parameter:ehp2.
:p.Einer Funktion der C-Standardbibliothek wurde ein unerwarteter Parameter bergeben.
:p.Smtliche MATHLIB-Fehlermeldungen werden von der C-Standardbibliothek ausgelst.
:p.Weitere Informationen siehe&colon.-
:ul.
:li.:link reftype=hd res=78.Formelsyntax:elink.
:li.:link reftype=hd res=76.Funtionen in Formeln:elink.
:li.:link reftype=hd res=77.Variablen und Konstanten in Formeln:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=46 id=46 global.Steuerzeichen einfgen
:i2 refid=editmnu.Steuerzeichen einfgen
:p.Mit Hilfe des Dialogs 'Steuerzeichen einfgen' lassen sich Steuerzeichen in den Textrahmen einfgen.
Steuerzeichen sind Text, der automatisch aus internen Informationen generiert wird. Zu solchen
internen Informationen gehren das aktuelle Datum und die Zeit, der Dateiname und Pfad des aktuellen
Dokuments, die derzeitige Seitennummer und die Anzahl der Seiten im Dokument sowie benutzerdefinierte
Textmischdaten.
:p.:hp2.Seitennummern:ehp2.
:p.Die Seitennummer wird durch die Position der Steuerzeichen auf der Druckseite bestimmt. Befinden
sich die Steuerzeichen nicht wirklich innerhalb einer Seite oder genau zwischen zwei Seiten, kann der
korrekte Wert evtl. nicht ermittelt werden. In diesem Fall wird ein '?' ausgegeben.
:p.Die Gesamtanzahl der Seiten ist beim Erstellen von Text wie 'Seite x von y' hilfreich, wobei 'y' fr die
Anzahl Seiten im gesamten Dokument steht.
:p.:hp2.Zhler:ehp2.
:p.Zhler sind eine Mglichkeit, numerierte Listen zu erstellen. Es stehen mehrere Numerierungsarten zur Verfgung,
wie etwa alphabetisch oder mit rmischen Zahlen.
:p.Da Zhler auerdem verschachtelt werden knnen, knnen Numerierungen wie folgende erstellt werden&colon.
:fig.
1 Autos.
2 Boote,
    a mit Paddeln.
    b mit Segeln.
    c mit Pedalen.
3 Fahrrder.
4 Flugzeuge.
:efig.
:p.:hp2.Mischdaten:ehp2.
:p.Das Laden und Verwenden einer Mischdatenbank stellt einen Weg dar,
Informationen in einen Text einzufgen. Die gebruchlichste Nutzung dieser
Funktion ist die Erstellung von Serienbriefen. Bevor Sie Mischdaten einfgen,
sollten Sie eine Mischdatenbank in das Dokument laden und die erste Zeile der
Daten auswhlen, die beim Einfgen verwendet werden soll. Das Einfgen
geschieht automatisch, dynamisch und wird aktualisiert, wenn an der
Mischdatenbank nderungen vorgenommen werden. Die zu verwendende Zeile der
Mischdatenbank kann durch Auswahl der korrekten Zeile aus dem Listenfeld
festgelegt werden. Weitere Informationen ber Mischdatenbanken entnehmen Sie bitte
dem Handbuch des Text-Handlers.
:p.Zu einem spteren Zeitpunkt lt sich eine andere Zeile festlegen, indem der entsprechende Text markiert
und im Dialog :link reftype=hd res=41.Mischzeile auswhlen:elink. die korrekte Zeile ausgewhlt wird.
:p.:hp2.Datum und Zeit:ehp2.
:p.Die Informationen zu Datum und Zeit werden mittels einer Datei namens
DATECONV.LCI aus einem numerischen in ein Textformat konvertiert.
:p.Datum und Zeit knnen als normaler Text eingefgt werden. In diesem Fall werden die Steuerzeichen
vor dem Einfgen in normalen Text konvertiert. Wie bei normalem Text blich werden die Werte fr Datum
und Zeit nicht jedesmal aktualisiert, wenn der Text neu gezeichnet oder ausgedruckt wird. Da das Einfgen
fixer Werte fr Datum und Zeit am gebruchlichsten ist, ist dieser Modus voreingestellt.
:p.:hp2.Dateiinformation:ehp2.
:p.Zur Auswahl stehen der Name des Dokuments und der vollstndige Dateipfad. Ist die Datei noch unbenannt,
wird ein leerer String zurckgegeben. Nach Sichern der Datei erscheint der String mit der korrekten
Dateiinformation.
:p.:hp2.Datenformat DATECONV.LCI:ehp2.
:p.Eine Beschreibung dieses Formats finden Sie im Handbuch des Text-Handlers.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=41 id=41 global.Einzuarbeitende Zeile auswhlen
:i2 refid=editmnu.Einzuarbeitende Zeile auswhlen
:p.Funktioniert nur im :link reftype=hd res=72.Textbearbeitungsmodus:elink..
:p.Dieser Dialog ist verfgbar, wenn :link reftype=hd res=46.Steuerzeichen:elink.
markiert wurden, die Daten aus einer Mischdatenbank enthalten.
:p.Hier kann die zum Einlesen des Texts verwendete Zeile der Mischdatenbank relativ gendert werden.
Wird fr die Zeilen eine automatische Erhhung zwischen mehreren Drucklufen festgelegt, so wird
die Zeile entsprechend hochgezhlt.
:p.Die Basiszeile wird im Dialog 'Datenbank einarbeiten' festgelegt.
Die erste im Listenfeld dieses Dialogs angezeigte Zeile entspricht der im Dialog 'Einzuarbeitende Zeile auswhlen'
ausgewhlten ersten Zeile. Im Listenfeld wird die dem kleinsten Versatz der Steuerzeichen entsprechende Zeile
ausgewhlt. Dadurch wird sichergestellt, da die auswhlbare Zeile immer
grer als die Basiszeile ist.
:p.Werden mehrere Drucklufe mit einer automatisch hochgezhlten Basiszeile durchgefhrt, werden alle anderen
Zeilen entsprechend versetzt. Werden mehr Zeilen angesprochen als in der einzuarbeitenden Datenbank
vorhanden sind, wird als Text ein Platzhalter verwendet (wie z.B. '$$(123)').
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=54 id=54 global.Text suchen
:i2 refid=editmnu.Text suchen
:p.Whlen Sie 'Suchen' aus dem Men 'Bearbeiten'. Diese Funktion sucht nach dem im Eingabefeld 'Suchbegriff'
angegebenen Text.
:p.Geben Sie den Suchbegriff in das entsprechende Eingabefeld ein. Es erlaubt die Eingabe von Zeichenketten
mit einer Lnge von bis zu 254 Zeichen.
:p.Soll der gefundene Text gendert werden, geben Sie im Eingabefeld 'Ersetzen durch' den neuen Text ein.
:p.Whlen Sie, ob die Suche Gro-/Kleinschreibung bercksichtigen und ob rckwrts im Text gesucht werden soll.
:p.Alle weiteren Optionen bleiben deaktiviert, bis die Suche erfolgreich war. Dann wird der Treffer markiert.
:p.:hp2.Dann kann:ehp2.
:ol.
:li.der Text durch den im Eingabefeld 'Ersetzen durch' ersetzt werden,
:li.der Text wie oben gendert und nach dem nchsten Auftreten gesucht werden,
:li.jede normale Editierfunktion wie Ausschneiden, Kopieren, Einfgen, Eingeben usw. benutzt werden.
Schieben Sie den Suchdialog einfach aus dem Weg (oder minimieren Sie ihn) und klicken Sie auf den Text,
um einen Cursor anzeigen zu lassen. Der Dialog wird solange wie gewnscht angezeigt.
:li.jedes Auftreten des Texts ersetzt werden.
:eol.
:p.Es wird nicht nur der ausgewhlte Behlter, sondern alle Behlter nach dem Suchbegriff durchsucht.
:note text='Hinweis:'.Das Suchen findet in einem eigenen Thread statt. Nehmen Sie mglichst keine nderungen
an der Datei vor, whrend der eigentliche Suchvorgang luft.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=65 id=65 global.Wortanzahl
:i2 refid=editmnu.Wortanzahl
:p.Whlen Sie den Meneintrag 'Wortanzahl', um die Wortanzahl sowohl der gesamten
Tabelle als auch der aktuellen Auswahl ausgeben zu lassen.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h2 res=66 id=66 global.Rechtschreibprfung
:i2 refid=editmnu.Rechtschreibprfung
:p.Funktioniert nur im :link reftype=hd res=72.Textbearbeitungsmodus:elink..
:p.Damit eine Rechtschreibprfung vorgenommen werden kann, mu ein Rechtschreib- und
Silbentrennungs-Handler installiert sein.
:p.Weitere Informationen zum Rechtschreibprfungs-Handler&colon.
:ul.
:li.Benutzen Sie den Meneintrag 'Handler-Liste...' des Hilfedialogs und dann nach Auswahl
des Rechtschreibprfungs-Handlers die Schaltflche 'Hilfe zum ausgewhlten Handler',
um die Hilfe aufzurufen.
:li.ffnen Sie das Men 'Bearbeiten' des Text-Handlers und whlen Sie den Meneintrag
'Rechtschreibprfung...'. Der Rechtschreibprfungs-Handler sollte dann einen Dialog
mit einer 'Hilfe'-Schaltflche anzeigen.
:eul.
:p.Sollte der Meneintrag 'Rechtschreibprfung...' deaktiviert sein, steht der
Rechtschreibprfungs-Handler nicht zur Verfgung. In diesem Fall mu er evtl.
erneut installiert werden.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=69 id=69 global.Artikelinformationen
:i2 refid=edit.Artikelinformationen
:p.Mit Artikelinformationen lassen sich Textartikel voneinander unterscheiden. Jedes Dokument kann Textartikel von
verschiedenen Autoren enthalten sowie Artikel, die fr dieses bestimmte Dokument verfat wurden, oder solche, die
aus anderen Dokumenten bernommen wurden. Einmal festgelegt, bleiben die Artikelinformationen im Artikel eingebettet
und knnen mit Hilfe des Dialogs 'Artikelinformationen' angezeigt werden.
:p.Die verschiedenen Artikelinformationen spiegeln den Zustand eines gegebenen Artikels wieder. Zu einem sptereren
Zeitpunkt lt sich ein bestimmter Artikel mit Hilfe dieser Informationen suchen oder aus einer Liste auswhlen.
:p.Falls keine Artikelinformationen eingegeben werden, benutzt die Anwendung, wo ntig, die ersten Worte des Textartikels,
um diesen in einer Liste zu kennzeichnen.
:p.Folgende Informationsfelder stehen zur Verfgung&colon.-
:p.:hp2.Artikelname:ehp2.
:p.Dieses Feld gibt den Namen des Textes an. Manche Dialoge, wie etwa die zum
Suchen von Textartikeln, fhren die Artikel nach Namen auf. Hat der Artikel
keinen Namen, werden statt dessen die ersten Wrter im Text verwendert.
Entscheidet man sich aber, Artikelinformationen einzugeben, ist die Angabe
eines Namens obligatorisch.
:p.Mit Hilfe der Suche im Men 'Werkzeuge' kann nach dem Namen eines Artikels gesucht werden.
:p.:hp2.Autor:ehp2.
:p.Diese wahlfreie Feld gibt den Autor des Textes an. Hier kann beliebiger Text eingegeben oder das Feld leer
gelassen werden.
:p.Mit Hilfe der Suche im Men 'Werkzeuge' kann nach dem Autor eines Artikels gesucht werden.
:p.:hp2.Datum:ehp2.
:p.Dieses wahlfreie Feld gibt das Datum an, an dem der Artikel erstellt wurde. Ist kein Datum vorhanden, wird
das heutige Datum eingetragen. Das Feld ist nicht auf ein Datum beschrnkt; es knnen beliebige Informationen
eingegeben oder das Feld leer gelassen werden .
:p.:hp2.Ziel:ehp2.
:p.Dieses wahlfreie Feld gibt an, wo der Artikel verffentlicht werden sollte. Ist kein Ziel vorhanden, wird
der aktuelle Dateiname eingetragen. Das Feld kann im gegenwrtigen Zustand belassen, mit beliebigem Text gefllt
oder leer gelassen werden.
:p.:hp2.Anmerkungen:ehp2.
:p.Dieses wahlfreie Feld bietet Raum fr Anmerkungen. Wenn fr den Artikel urheberrechtliche Beschrnkungen
bestehen, wre hier ein guter Platz, darauf hinzuweisen. Andere ntzliche Dinge wren Hinweise auf Korrekturen
bersetzungen, Ergnzungen usw.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=11 id=11 global.Handler entfernen
:i2 refid=editmnu.Handler entfernen
:p.Whlen Sie diesen Meneintrag, um die gesamte Tabelle zu lschen und den Handler
aus dem Rahmen zu entfernen. Anschlieend kann dem Rahmen anstelle des derzeitigen
Handlers ein anderer Handler hinzugefgt werden.
.******************************************************************************
:h1 res=80 id=80 global.Das Men Zellenstile
:i1 id=cellsmnu.Das Men Zellenstile
:p.Mit Hilfe des Mens Zellenstile knnen Stile fr einen Zellenbereich festgelegt werden.
Dazu gehren der Hintergrund, die Umrandung und zum Zelleninhalt wie Bildern und Text
gehrende Stile.
:p.Umrandungsstile
:ul.
:li.Dialog :link reftype=hd res=28.Umrandungslinienstile:elink.
:li.Dialog :link reftype=hd res=27.Umrandungsbreite:elink.
:li.Dialog :link reftype=hd res=30.Umrandungsfarbe:elink.
:eul.
:p.Fll- (Hintergrund-) Stile
:ul.
:li.Dialog :link reftype=hd res=30.Fllfarbe:elink.
:li.Dialog :link reftype=hd res=34.Erweiterte Schattierungsmodi:elink.
:li.Dialog :link reftype=hd res=31.Fllmuster:elink.
:li.Dialog :link reftype=hd res=33.Fllausrichtung:elink.
:eul.
:p.Stile fr Bitmap-Bilder
:ul.
:li.:link reftype=hd res=90.Bitmap-Bild skalieren:elink.
:li.:link reftype=hd res=91.Grenverhltnisse der Bitmap beibehalten:elink.
:eul.
:p.Metafile-Stile
:ul.
:li.:link reftype=hd res=90.Metadateibild skalieren:elink.
:li.:link reftype=hd res=91.Grenverhltnisse der Metadatei beibehalten:elink.
:eul.
:p.Rahmensatzstile
:ul.
:li.:link reftype=hd res=90.Bild skalieren:elink.
:eul.
:p.Textstile
:ul.
:li.:link reftype=hd res=56.Textsprache und Zeichensatz:elink.
:li.:link reftype=hd res=58.Silbentrennung aktivieren:elink.
:li.:link reftype=hd res=59.Intelligente Anfhrungsstriche:elink.
:li.:link reftype=hd res=68.Vertikale Textjustierung:elink.
:li.:link reftype=hd res=55.Zeichenrichtung:elink.
:li.:link reftype=hd res=44.Absatzeinstellungen:elink.
:li.:link reftype=hd res=60.Aufzhlungszeichen und Listen:elink.
:li.:link reftype=hd res=45.Zeileneinstellungen:elink.
:li.:link reftype=hd res=47.Zeilentabulatoren:elink.
:li.:link reftype=hd res=43.Schriftart:elink.
:li.:link reftype=hd res=30.Zeichenfarbe:elink.
:li.:link reftype=hd res=51.Unterschneiden:elink.
:li.:link reftype=hd res=52.Wurfschatten:elink.
:li.:link reftype=hd res=50.Hochstellung:elink. auswhlen
:li.:link reftype=hd res=50.Tiefstellung:elink. auswhlen
:li.Als :link reftype=hd res=48.Titeltext:elink. markieren
:eul.
:p.Stilvorlagen fr Tabellen
:ul.
:li.:link reftype=hd res=100.Als Zellenstil sichern:elink.
:eul.
.*-----------------------------------------------------------------------------
:h2 res=30 id=30 global.Farbauswahl
:i2 refid=cellsmnu.Farbauswahl
:p.Der Standardfarbdialog wird zum Festlegen einfacher Farben fr Hintergrnde, Umrandungen
und Text verwendet. Dieser Dialog ist Teil des derzeitigen Farb-Handlers. Weitere Informationen
zu seiner Bedienung entnehmen Sie bitte der Hilfe des Farb-Handlers.
:p.Der Hintergrund ist in der Lage, Farbverlufe zu nutzen, weswegen statt des Dialogs
'Farbauswahl' ggf. der Dialog 'Farbverlauf' verwendet wird.
:p.:hp2.Fllungen (Hintergrnde):ehp2.
:p.Der Farbauswahldialog wird angezeigt, wenn ein einfacher Fllstil erstellt wird.
Erzeugt man einen Fllstil mit Farbverlauf, erscheint stattdessen der :link reftype=hd
res=32.Dialog Farbverlauf:elink..
:p.Verwenden Sie diesen Dialog zur Auswahl einer Hintergrundfarbe. Es werden sowohl die
Vordergrund- als auch die Hintergrundfarbe benutzt. Die eigentliche Farbe wird eine Mischung sein,
die durch die Mustereinstellungen bestimmt wird. Wenn der derzeitige Farb-Handler es untersttzt,
kann die Hintergrundfarbe transparent gewhlt werden. Siehe die :link reftype=hd res=31.Muster:elink.
fr weitere Informationen zum Farbmischen.
:p.:hp2.Umrandungen:ehp2.
:p.Verwenden Sie diesen Dialog zur Auswahl einer Umrandungsfarbe. Es werden sowohl die
Vordergrund- als auch die Hintergrundfarbe benutzt. Wenn eine gestrichelte oder hohle
Vordergrundlinie gezeichnet wird, scheint die Hintergrundfarbe darunter durch. Es kann eine
transparente Hintergrundfarbe ausgewhlt werden, wodurch dann die Hintergrundlinie nicht
gezeichnet wird.
:p.:hp2.Text:ehp2.
:p.Benutzen Sie diesen Dialog zur Auswahl einer Textfarbe. Die Vordergrundfarbe wird fr den Text verwendet,
mit der Hintergrundfarbe wird der Bereich hinter dem Text eingefrbt. Es ist auch mglich, eine
transparente Hintergrundfarbe zu whlen.
:p.In beiden Fllen handelt es sich hier um den Dialog des aktuellen Farb-Handlers. Weitere Informationen
zur Bedienung dieses Dialogs finden sich in der Hilfe des Farb-Handlers.
.******************************************************************************
.*  Shading colours
.******************************************************************************
:h3 res=32 id=32 global.Dialog Farbverlauf
:i2 refid=cellsmnu.Dialog Farbverlauf
:p.Erzeugen einer Auswahl von Farben fr Fllungen mit Farbverlauf.
:p.:artwork name='shadedlg.bmp' align=left.
:p.Beim erstmaligen ffnen des Dialogs sind zwei Farben vordefiniert. Sofern Sie die Farbe der Fllung noch nicht
gendert haben, sind beide Farben normalerweise wei.
:p.Durch Auswahl einer der Farben aus dem Listenfeld erhalten Sie die Mglichkeit, die Farbe zu bearbeiten,
die Farbe in der Liste nach oben oder unten zu verschieben oder sie - bei mehr als zwei Farben - zu lschen.
Bei den Verlaufsfarben mssen mindestens zwei Farben definiert sein, auch wenn beide gleich sein knnen.
Durch Drcken der Schaltflche Hinzufgen wird ein neuer Farbeintrag hinzugefgt. Als Farbe des neuen
Farbeintrags wird die derzeit ausgewhlte Farbe bernommen.
:p.Ein Klick mit der linken Maustaste auf den Farbkreis oder das Farbband pat die Vordergrundfarbe an.
Alle im Standardfarbdialog mglichen Verfahrensweisen knnen auch hier angewendet werden, einschlielich
Anklickens des Farbstreifens unten rechts zum Aufrufen genauerer Farbeinstellmglichkeiten. Desweiteren
knnen Farben auch aus der Farbpalette geladen werden, falls eine geladen ist.
:p.Die Hintergrundfarbe der Fllung kann jederzeit durch Bearbeiten der Hintergrundfarbe gendert
werden. Klicken Sie mit der rechten Maustaste auf den Farbkreis oder das Farbband, um die
Farbe zu ndern. Die Hintergrundfarbe hngt nicht von den Farbeintrgen ab.
:p.Siehe :link reftype=hd res=34.Erweiterte Farbeinstellungen:elink. fr
weitere Informationen zu normalisierter Farbmischung.
:p.Drcken Sie 'Anwenden', um die neue Farbauswahlliste anzuwenden, und 'Beenden', um den Dialog zu beenden, wenn
Sie fertig sind.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=28 id=28 global.Umrandungslinienstile
:i2 refid=cellsmnu.Umrandungslinienstile
:p.Um eine Umrandung zu erhalten, mu ein passender Umrandungslinienstil ausgewhlt werden.
Die Voreinstellung ist kein Linienstil. Da Behlter auch fr Umrandungen benutzt werden,
wird der Umrandungsstil auf die aktuelle Auswahl angewendet. Dadurch wird es mglich, in derselben
Tabelle mehrere Umrandungstile zu verwenden.
:p.Folgende Stile stehen zur Verfgung&colon.
:ul.
:li.Keine Umrandung.
:li.:artwork name='bstyhorz2.bmp' runin. Nur untere horizontale Linien.
:li.:artwork name='bstyvert2.bmp' runin. Vertikale Linien nur ganz rechts.
:li.:artwork name='bstyinter.bmp' runin. Nur untere horizontale Linien und
vertikale Linien ganz rechts.
:li.:artwork name='bstynone.bmp' runin. Nur Umri der Auswahl.
:li.:artwork name='bstyhorz.bmp' runin. Alle horizontalen Linien.
:li.:artwork name='bstyvert.bmp' runin. Alle vertikalen Linien.
:li.:artwork name='bstyall.bmp' runin. Alle Linien.
:eul.
:p.Die in :hp9.rosa:ehp9. dargestellten horizontalen und vertikalen Linien
werden mit dem entsprechenden Markierungsfeld aktiviert. Durch die Mglichkeit,
diese Linien zu deaktivieren, lassen sich aneinandergrenzende Umrandungsstile
besser kombinieren.
:p.Normalerweise werden Teile von Umrandungen, die unterhalb anderer Umrandung
liegen, nicht dargestellt. Wenn Sie Umrandungsstile berlappen lassen mchten, um diese
zu kombinieren, ist dies mglich, indem die Auslassung berlappender Umrandungen im
untenliegenden Umrandungsstil deaktiviert wird.
:p.Theoretisch ist das Setzen von Umrandungsstil, Umrandungsbreite und Umrandungsfarbe notwendig,
bevor man eine Umrandung sehen kann. Um den Umgang mit Umrandungen zu erleichtern, braucht man jedoch
nur einen Umrandungslinienstil zu setzen; eine Breite von Null wird als feine Linie interpretiert
und bei nicht festgelegter Farbe gilt die Voreinstellung schwarz.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=27 id=27 global.Umrandungsbreite
:i2 refid=cellsmnu.Umrandungsbreite
:p.Benutzen Sie diesen Dialog zur Festlegung der Umrandungsbreite. Wird die Umrandungsbreite auf
Null gesetzt, wird diese als 1 gelesen. Es mu ein passender
:link reftype=hd res=28.Umrandungslinienstil:elink. ausgewhlt werden, bevor etwas sichtbar wird.
:p.Geben Sie einen Wert gefolgt von einer Maeinheit ein, beispielsweise 0.5in.
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt).
Ein Inch entspricht 25,4 mm und 72,2818 Punkten. Es handelt sich also um ein britisches Inch.
Wird die Gre ohne Einheit angegeben, so wird der Wert als Drucker-Pixel interpretiert. Der tatschliche Wert
wird in Drucker-Pixeln gespeichert, eine Breite von 1 ergibt somit die schmalstmgliche Umrandung.
.*-----------------------------------------------------------------------------
:h2 res=34 id=34 global.Erweiterte Farboptionen
:i2 refid=cellsmnu.Erweiterte Farboptionen
:artwork name='advanced.bmp' align=left.
.br
:p.:hp2.Modi fr Fllen mit Farbverlauf:ehp2.
:p.Modi fr das Fllen mit Farbverlauf besitzen eine Reihe von Parametern, die von den Standardwerten
abweichend eingestellt werden knnen. Verwenden Sie diesen Dialog, um nderungen an der Art und
Weise des Farbverlaufs vorzunehmen und anzuwenden.
:p.Derzeit untersttzt dieser Handler nur Farbverlufe durch berblendung. Bei der berblendung wird
eine Farbe nach wei hin ausgeblendet, whrend die nchste Farbe von wei aus eingeblendet wird.
:p.Die berblendung und ihre Parameter knnen am einfachsten durch ein Diagramm erlutert werden&colon.
:artwork name='addiag.bmp' align=left.
.br
:p.:hp2.Einlauf und Auslauf:ehp2.
:p.Die Schieberegler 'Einlauf' und 'Auslauf' passen die Gre der im Diagramm gezeigten Einlauf-
und Auslaufteile an. Sollten die Schieberegler nicht genau genug arbeiten, knnen Sie die
erforderlichen Prozentwerte direkt in die Eingabefelder eintragen.
:p.Mit Erhhung des Einlaufs neigt die berblendung mehr zur Schwrze. Mit der Erhhung des
Auslaufs neigt die berblendung mehr zur Weie. Wenn sowohl Einlauf als auch Auslauf erhht werden,
findet die berblendung selbst innerhalb eines kleineren Bereiches statt. Bei jeweils 100% Einlauf
und Auslauf verbleibt fr die berblendung kein Raum mehr, es wird direkt zwischen den Farben
umgeschaltet.
:p.:hp2.Normalisierte Helligkeit:ehp2.
:p.Werden zwei Farben gemischt, so kann sich die daraus resultierende Helligkeit, oder Luminiszenz
dramatisch ndern. Durch Auswahl des Markierungsfelds 'Normalisierte Helligkeit' wird diese
Abweichung der Helligkeit bei der berblendung korrigiert und ausgeglichen. Bei manchen Farben ist
dieser Effekt nicht ersichtlich, whrend er bei anderen das Aussehen der berblendung
vollkommen verndert. Der Effekt ist besonders bei der Mischung von Primrfarben, wie etwa
rot und grn, zu beobachten.
.*-----------------------------------------------------------------------------
:h2 res=31 id=31 global.Hintergrundmuster festlegen
:i2 refid=cellsmnu.Hintergrundmuster festlegen
:p.Die Werkzeugleiste bietet ein Drop-Down-Men, andernfalls wird ein Dialog angezeigt. Beide arbeiten auf die gleiche Art und Weise.
:p.Benutzen Sie diesen Dialog, um das Hintergrundmischmuster auszuwhlen. Wenn das
Mischmuster auf den Standardwert durchgehend eingestellt ist, werden nur die Vordergrundfarben
verwendet. Whlen Sie ein anderes der Mischmuster aus, so wird erst die Hintergrundfarbe
gezeichnet, gefolgt von einem Muster der Vordergrundfarben.
:p.Wenn als Hintergrundfarbe transparent gewhlt wurde, wird nur das Vordergrundmuster gezeichnet.
Dies ist eine Mglichkeit, ein darunterliegendes Bild oder einen Textrahmen einzufrben.
.*-----------------------------------------------------------------------------
:h2 res=33 id=33 global.Ausrichtung der Hintergrundfllung
:i2 refid=cellsmnu.Ausrichtung der Hintergrundfllung
:p.Die Ausrichtung der Hintergrundfllung setzt sich aus der Rahmenausrichtung und Fllungsausrichtung zusammen.
Standardmig liegt die Fllungsausrichtung bei +0.
:p.Normalerweise, wenn der Rahmen auf Null ausgerichtet ist, ist auch die Fllung auf 0 ausgerichtet, was
zu einer vertikalen Fllung fhrt.
:p.Indem man den Rahmen dreht, wird auch die Fllung gedreht. Der eigentliche Fllungswinkel wird im Dialog Drehen
als Statuszeichenkette angezeigt. Um die :hp1.relative:ehp1. Ausrichtung zwischen Fllung und Rahmen anzupassen,
knnen Sie den Drehregler benutzen oder den erforderlichen Winkel eingeben.
:p.Drcken Sie 'Anwenden', um den neuen Fllungswinkel anzuwenden, und 'Beenden', um den Dialog zu beenden, wenn
Sie die Arbeiten abgeschlossen haben.
.*-----------------------------------------------------------------------------
:h2 res=20 id=20 global.Fllmodi des Hintergrund-Handlers
:i2 refid=cellsmnu.Fllmodi des Hintergrund-Handlers
:p.Der Tabellen-Handler untersttzt eine Reihe von Fllmodi zur Erzielung
von Farbverlaufseffekten sowie einfachem Farbfllen.
:p.Die Fllmodi umfassen&colon.
:ul.
:li.:link reftype=hd res=21.Einfacher:elink. Fllmodus.
:li.:link reftype=hd res=22.Flacher:elink. Fllmodus.
:li.:link reftype=hd res=23.Bogen:elink.-Fllmodus.
:li.:link reftype=hd res=24.Kreis:elink.-Fllmodus.
:li.:link reftype=hd res=25.Rechteck:elink.-Fllmodus.
:li.:link reftype=hd res=26.Schachbrett:elink.-Fllmodus.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=21 id=21 global.Einfacher Fllmodus
:p.:artwork name='backplain.bmp' runin.In diesem Modus wird der Rahmen mit einer einzigen Farbe gefllt.
:p.Alle Fllmodi untersttzen :link reftype=hd res=31.Muster:elink. mit einer Musterhintergrundfarbe.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=22 id=22 global.Flacher Fllmodus
:p.:artwork name='backcol2.bmp' runin.In diesem Modus wird der Rahmen mit einem Verlauf zweier oder
mehrerer Farben gefllt. Die Farben werden als flache Streifen ber den Rahmen gezeichnet.
Die :link reftype=hd res=33.Ausrichtung:elink. kann nach Bedarf angepat werden.
:p.Alle Fllmodi untersttzen :link reftype=hd res=31.Muster:elink. mit einer Musterhintergrundfarbe.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=23 id=23 global.Bogen-Fllmodus
:p.:artwork name='backcol.bmp' runin.In diesem Modus wird der Rahmen mit einem Verlauf zweier oder
mehrerer Farben gefllt. Die Farben werden als Bgen mit wachsendem Durchmesser ber dem Rahmen gezeichnet.
Die :link reftype=hd res=33.Ausrichtung:elink. kann nach Bedarf angepat werden.
:p.Alle Fllmodi untersttzen :link reftype=hd res=31.Muster:elink. mit einer Musterhintergrundfarbe.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=24 id=24 global.Kreis-Fllmodus
:p.:artwork name='backcol1.bmp' runin.In diesem Modus wird der Rahmen mit einem Verlauf zweier oder
mehrerer Farben gefllt. Die Farben werden angefangen beim Mittelpunkt des Rahmens als grer werdende Kreise gezeichnet.
:p.Alle Fllmodi untersttzen :link reftype=hd res=31.Muster:elink. mit einer Musterhintergrundfarbe.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=25 id=25 global.Rechteck-Fllmodus
:p.:artwork name='backcol3.bmp' runin.In diesem Modus wird der Rahmen mit einem Verlauf zweier oder
mehrerer Farben gefllt. Die Farben werden angefangen beim Mittelpunkt des Rahmens als grer werdende Rechtecke gezeichnet.
:p.Alle Fllmodi untersttzen :link reftype=hd res=31.Muster:elink. mit einer Musterhintergrundfarbe.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=26 id=26 global.Schachbrett-Fllmodus
:p.:artwork name='backcol4.bmp' runin.In diesem Modus wird der Rahmen
mit einem Schachbrettmuster aus zwei oder mehr Farben gefllt.
:p.Die Farben werden in regelmigen Abstnden wiederholt und fllen den Behlter basierend auf
der Anzahl verfgbarer Farben gleichmig auf. Stehen weniger als vier Farben zur Verfgung, werden
mindestens vier Quadrate gefllt. Stehen nur zwei Farben zur Verfgung, werden diese in einem
einfachen Schachbrettmuster dargestellt.
:p.Dieser Modus ignoriert erweiterte Verlaufsmodi.
:p.Alle Fllmodi untersttzen :link reftype=hd res=31.Muster:elink. mit einer Musterhintergrundfarbe.
.*-----------------------------------------------------------------------------
:h2 res=91 id=91 global.Grenverhltnisse der Bitmap beibehalten
:i2 refid=cellsmnu.Grenverhltnisse der Bitmap beibehalten
:p.Diese Menauswahl stellt sicher, da Bilder nicht durch ungleiche Skalierung verzerrt werden.
:p.Da diese Option vor benutzerdefinierter Skalierung angewendet wird, kann der :link
reftype=hd res=90.Dialog Skalierung:elink. immer noch zu einer Verzerrung des
Bildes fhren.
.*-----------------------------------------------------------------------------
:h2 res=90 id=90 global.Bild skalieren
:i2 refid=cellsmnu.Bild skalieren
:p.Benutzen Sie den Dialog 'Bild skalieren...', um die Skalierung der Bitmap-Datei anzupassen. Bei der Skalierung
handelt es sich um eine Grafiktransformierung, die unabhngig von anderen Skalierungsfaktoren durchgefhrt wird.
Mit Hilfe des Skalierungsdialogs knnen Bilder skaliert und gespiegelt werden.
:p.Verwenden Sie die Eingabefelder, um Hhe und Breite der erforderlichen Skalierungsfaktoren in Prozent
anzugeben. Zur bequemeren Handhabung knnen Sie mit den Schaltflchen einen Anteil von 50% hinzufgen und abziehen.
Negative Skalierungsfaktoren invertieren oder spiegeln das Bild.
:p.Der Dialog bietet auerdem zwei Schieberegler zur Anpassung der Skalierungsfaktoren ber einen Gesamtbereich
von 100%.
:p.nderungen werden im Beispielbild angezeigt. Dieses Beispiel kann nur bei Skalierungswerten ber 100% einen
Hinweis auf die Grenverhltnisse bieten. Das Bild wird dabei immer soweit verkleinert, da es in das
Beispielfenster pat.
:p.Drcken Sie 'Anwenden', um die nderungen auf die Bitmap-Datei anzuwenden, und 'Beenden', um den Dialog nach
Abschlu der Arbeiten zu verlassen.
.*-----------------------------------------------------------------------------
:h2 res=56 id=56 global.Festlegen der Textsprache und des Text-Zeichensatzes
:i2 refid=cellsmnu.Festlegen der Textsprache und des Text-Zeichensatzes
:p.Mit der Sprachauswahl wird eine Reihe wichtiger Einstellungen festgelegt. Dazu gehren&colon.-
:ul.
:li.Die bei der Silbentrennung zur Bestimmungen der Trennpositionen verwendete Sprache.
:li.Die bei der Rechtschreibprfung verwendete Sprache.
:li.Die bei der Anzeige von Datum und Zeit verwendete Sprache.
:eul.
:p.Fr jeden Eintrag der Sprachauswahl werden drei verschiedene Parameter angezeigt. Der erste ist
die Sprachkennung, der zweite der Sprachstring. Der dritte Parameter wird nur angezeigt, wenn fr die
Sprache die passenden Wrterbcher installiert wurden.
:p.Zum Hinzufgen einer neuen Sprache sind zwei Dateien zu bearbeiten, die sich beide im Maul-Verzeichnis .\etc
befinden. Die erste Datei ist DATECONV.LCI, die zweite MYSPELL.DLS. Hinweise zum Bearbeiten
von MYSPELL.DLS finden Sie im Abschnitt 'Verwaltung von Wrterbchern und Zeichenstzen' des Handbuchs des
Rechtschreib-Handlers.
Beim Bearbeiten von DATECONV.LCI beachten Sie bitte den Abschnitt 'Datenformat DATECONV.LCI' im
Handbuch des Text-Handlers.
:p.Bei Auswahl einer Sprache, fr die keine Wrterbcher zu Verfgung stehen, knnen Silbentrennung und
Rechtschreibprfung nicht ordnungsgem funktionieren!
:p.Zeichenstze werden von OS/2 intensiv bei der Anzeige von Text in bestimmten Sprachen oder
bestimmter Betriebssysteme verwendet. Text wird als eine Folge von Zahlen gespeichert. Der
Zeichensatz bestimmt, welches Zeichen einer bestimmten Zahl entspricht. Importiert man einfachen
Text mit einem abweichenden Zeichensatz, werden Zeichen falsch angezeigt. Durch Wechseln zum
korrekten Zeichensatz wird der Text ordnungsgem angezeigt.
:p.Der ausgewhlte Zeichensatz wird zwar zur Anzeige von Text verwendet, aber weder beeinflut er
die Tastenbelegung noch wird er zur tatschlichen Konvertierung von einem Zeichensatz in einen anderen benutzt.
Diese Anwendung bersetzt einige Zeichenstze, siehe 'Informationen zur Internationalisierung'
im Handbuch des Text-Handlers.
:p.Gebruchlich sind beispielsweise folgende Zeichenstze&colon.
:ul.
:li.819  Dieser Zeichensatz wird von ISO8859-1 Linux-Systemen verwendet; die Rechtschreibprfung
MySpell benutzt diesen Zeichensatz ebenfalls.
:li.850  Dieser Zeichensatz wird von Latin-1 OS/2-Systemen verwendet und enthlt Akzentzeichen, wie sie im Franzsischen verwendet werden.
:li.852  Dieser Zeichensatz wird von Latin-1 OS/2-Systemen verwendet und enthlt Akzentzeichen, wie sie im Tschechischen verwendet werden.
:li.1004 Mit diesem Zeichensatz knnen OS/2-Systeme im allgemeinen unter Windows erstellten Text ordnungsgem anzeigen.
:li.1252 Dieser Zeichensatz wird von Latin-1 Windows-Systemen verwendet.
:li.1250 Dieser Zeichensatz wird von Latin-2 Windows-Systemen verwendet.
:eul.
:p.Der fr diesen Artikel gewnschte Zeichensatz kann hier ausgewhlt werden. Drcken Sie 'Anwenden' zum Festlegen
des Zeichensatzes und 'Beenden' zum Verlassen des Dialogs. Bei Auswahl eines anderen Textrahmens wird der Dialog
automatisch aktualisiert. Fr die verschiedenen Textartikel knnen unterschiedliche Sprachen und Zeichenstze
verwendet werden.
:p.Es besteht jedoch ein Problem, dessen Sie sich bewut sein sollten.
:p.Der ausgewhlte Zeichensatz wird zurck auf den/die auf dem System installierten Zeichensatz/Zeichenstze bersetzt.
Je komplexer dieser bersetzungsvorgang wird, desto langsamer wird die Verarbeitung des Texts. Bei Auswahl eines
Rahmens mit einem anderen Zeichensatz kann es ntig werden, da der Handler die Schriftentabelle neu laden mu,
was mitunter zu einer kurzen Unterbrechung fhrt.
:p.Die auswhlbaren Zeichenstze definieren sich aus der Schnittmenge der im Betriebssystem zur Verfgung stehenden
Zeichenstze und einer Datei namens CODEPAGE.LCI. Diese Datei fhrt
alle whlbaren Zeichenstze auf. Zeichenstze
knnen von der Benutzung ausgeschlossen werden, indem man sie aus dieser Datei entfernt. In der Datei knnen auch
Zeichenstze vorkommen, die Sie nicht auswhlen knnen, weil sie auf Ihrem System nicht vorhanden sind. Die Datei
befindet sich im Verzeichnis .\etc. (Wie auch die meisten Stilvorlagen und Seitenvorlagen!)
:p.:hp2.CODEPAGE.LCI Datenformat:ehp2.
:p.Die Beschreibung dieses Formates entnehmen Sie bitte der Hilfe des Text-Handlers.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=58 id=58 global.Silbentrennung aktivieren
:i2 refid=cellsmnu.Silbentrennung aktivieren
:p.Die Silbentrennung ist von Sprache und Zeichensatz abhngig. Whlen Sie bitte die korrekte
Sprache und den Zeichensatz fr Textartikel aus, bevor Sie die Silbentrennung aktivieren.
:p.Die korrekte Sprache fr einen Textartikel lt sich mit Hilfe des Dialogs
:link reftype=hd res=56.Textsprache und Zeichensatz:elink. festlegen.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=59 id=59 
global.Intelligente Anfhrungsstriche
:i2 refid=cellsmnu.Intelligente Anfhrungsstriche
:p.Maul ist in der Lage, Anfhrungszeichen entsprechend der jeweiligen Sprache zu 
behandeln. Ist der 
Meneintrag "Intelligente Anfhrungszeichen" aktiviert, so werden normale 
Anfhrungsstriche durch eine LOL struktur ersetzt, durch das automatisch
die zur im Artikel verwendeten Sprache gehrenden Anfhrungszeichen verwendet werden.
:p.Der Meneintrag "Intelligente Anfhrungszeichen" bestimmt damit, ob es sich beim 
eingefgten Text um ein 
intelligentes Anfhrungszeichen oder das Standardzeichen handelt.
:p.Darber hinaus lassen sich auch intelligente einfache Anfhrungszeichen 
verwenden. Um 
Verwechselungen mit dem echten Apostroph zu vermeiden, das beispielsweise im 
franzsischen 
:hp2.l'eau:ehp2. oder im englischen :hp2.it's:ehp2. verwendet wird, mu bei der Eingabe 
jedoch Alt+<'> 
gedrckt werden. Andernfalls gbe es keine Mglichkeit, zwischen beiden 
Anwendungen zu unterscheiden.
:p.Weitere Arten von Anfhrungszeichen, wie z.B. Guillemets ( und ), werden nicht von 
der Funktion 
Intelligente Anfhrungszeichen untersttzt.
:note text='Hinweis:'.Die Funktion steht nicht zur Verfgung, wenn der verwendete 
Zeichensatz nicht die 
erforderlichen Zeichen enthlt. Aus diesem Grunde wird bei neuen Textobjekten auch 
1208 Unicode als 
Standardzeichensatz verwendet.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=68 id=68 global.Textjustierung
:i2 refid=cellsmnu.Textjustierung
:p.Im Gegensatz zum Text-Handler kann der Tabellen-Handler Text sowohl vertikal wie horizontal
ausrichten. Dies ist mglich, weil ein Textbehlter immer rechteckig ist und nicht von
berlappenden Rahmen ausgeschnitten wird.
:p.Im Modus Ersetzen ndert der Handler die Justierung eines jeden Textbehlters innerhalb
der aktuellen Auswahl. Auf diese Weise kann beispielsweise eine Spalte mit Zahlen sehr effektiv
rechtsbndig ausgerichtet werden.
.*-----------------------------------------------------------------------------
:h2 res=55 id=55 global.Festlegen der Zeichenrichtung
:i2 refid=cellsmnu.Festlegen der Zeichenrichtung
:p.Die Zeichenrichtung legt die Ausrichtung der einzelnen Zeichen fest, die zusammen eine Zeile ergeben.
:p.Dieser Dialog pat die Textausrichtung und die Reihenfolge der Textzeilen automatisch der
ausgewhlten Zeichenrichtung an.
:p.Angenommen, die Textausrichtung verliefe von links nach rechts, dann knnte die Reihenfolge der
Textzeilen von oben nach unten oder von unten nach oben verlaufen. Letzteres ist mit einer
umgekehrten Textzeilenreihenfolge zu erreichen.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
.*-----------------------------------------------------------------------------
:h2 res=44 id=44 global.Absatzeinstellungen festlegen
:i2 refid=cellsmnu.Absatzeinstellungen festlegen
:p.Absatzeinstellungen betreffen die Positionierung eines vollstndigen Absatzes.
:p.Wenn mehrere Abstze markiert wurden, werden die markierten Abstze angepat, andernfalls nur
die Einstellungen des aktuellen Absatzes.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Einzugsinformationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesen Einzgen erstellt werden.
:p.:hp2.Absatzeinzge:ehp2.
:p.Mit Hilfe der Absatzeinstellungen knnen Abstnde und Einzge fr Abstze festgelegt
werden. Ein Absatz ist in diesem Fall ein formatierter Textblock, der sich ber
eine oder mehrere Zeilen erstreckt. Der Einzug der ersten Zeile des Absatzes kann unabhngig
vom Rest festgelegt werden, womit sich ein ansprechendes Textlayout realisieren lt.
Es werden sowohl linke wie rechte Einzge untersttzt.
:p.Geben Sie fr jeden zu ndernden Wert eine Zahl gefolgt von einer Maeinheit ein, z.B. 0.5in.
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt).
Ein Inch entspricht 25.4 mm und 72.2818 Punkten. In diesem Fall handelt es sich um ein
britisches Inch. Bei Angabe der Gre ohne Maeinheit wird der Wert als Drucker-Pixel
interpretiert. Der eigentliche Wert wird in Punkten gespeichert und zwar auf ein 65536-stel eines
Punktes genau.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=60 id=60 global.Aufzhlungszeichen fr Absatz festlegen
:i2 refid=cellsmnu.Aufzhlungszeichen fr Absatz festlegen
:p.Mit Aufzhlungszeichen lassen sich einfache Numerierungen und Aufzhlungen erstellen. Fr den Einsatz
von Aufzhlungszeichen ist die Nutzung von Unicode- oder DBCS-Zeichenstzen erforderlich, welche die
notwendigen Zeichen enthalten.
:p.Durch Bettigen einer der Schaltflchen fr Listen wird die voreingestellte Aufzhlung oder Numerierung 
erzeugt. Der Dialog 'Aufzhlungszeichen und Listen' kann ber das Men oder durch Klick mit der rechten 
Maustaste auf eine der Schaltflchen fr Listen aufgerufen werden.
:p.Die voreingestellten Aufzhlungspunkte entsprechen den bei Web-Browsern gebruchlichen. Diese Option
lt sich jedoch deaktivierieren, so da eigene Zeichen ausgewhlt werden knnen.
:p.Numierierungszeichen knnen als Buchstaben, rmische sowie normale Zahlen angezeigt werden. Darber hinaus
knnen sie mit einer Vielzahl Klammern oder Satzzeichen versehen werden. Durch  Auswahl von Zhlerebenen
lassen sich, wie unten dargestellt, verschachtelte Aufzhlungen erstellen.
:fig.
1 Autos.
2 Boote.
    a mit Paddeln.
    b mit Segeln.
    c mit Pedalen.
3 Fahrrder.
4 Flugzeuge.
:efig.
:p.Die Einstellungen fr Listen werden im Absatz gespeichert.
:p.Es gibt noch weitere Mglichkeiten zur Erstellung von Listen: mit Hilfe von
:link reftype=hd res=46.Steuerzeichen:elink. oder durch manuelles Erstellen, indem der entsprechende
Einzug fr den :link reftype=hd res=44.Absatz:elink. eingestellt und das gewnschte Zeichen oder
Bild im Text als Aufzhlungszeichen eingefgt wird.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=45 id=45 global.Zeileneinstellungen festlegen
:i2 refid=cellsmnu.Zeileneinstellungen festlegen
:p.Zeileneinstellungen wirken sich auf die Positionierung einer einzelnen Zeile aus. Sie sind ein wenig
'flchtig'. Wenn die Breite eines Rahmens gendert wird, kann es sein, da der Absatz danach weniger Zeilen
enthlt. In diesem Fall werden die berflssigen Zeilenparameter zusammen mit Ihren sorgfltig vorgenommenen
Einstellungen gelscht. Wenn der Rahmen dann schmaler gemacht wird, werden zustzliche Zeilen hinzugefgt.
Diese neuen Zeilen bernehmen die Einstellungen der vormals letzten Zeile.
:p.Der Table-Handler wendet die Zeilenparamter auf den gesamten Textbehlter an. Im Modus
Ersetzen knnen die Einstellungen eines ganzen Behlterbereichs angepat werden.
:p.Mit Hilfe der Radioknpfe kann sowohl die vertikale als auch die horizontale Justierung
festgelegt werden.
:p.Die Zeilenhhe wird in Prozenten der derzeit maximalen Zeichenhhe angegeben.
:p.Erlaubte Maeinheiten sind mm, cm, m, in, din (1/10 inch), pt und dpt (1/10 pt).
Ein Inch entspricht 25.4 mm und 72.2818 Punkten. In diesem Fall handelt es sich um ein
britisches Inch. Bei Angabe der Gre ohne Maeinheit wird der Wert als Drucker-Pixel
interpretiert. Der eigentliche Wert wird in Punkten gespeichert und zwar auf ein 65536-stel eines
Punktes genau.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
.*-----------------------------------------------------------------------------
:h2 res=47 id=47 global.Zeilentabulatoren
:i2 refid=cellsmnu.Zeilentabulatoren
:p.Bei der Erstellung einer Tabulatortabelle wird diese in die Textdatei eingefgt und bleibt
gltig, bis eine andere Tabulatortabelle eingerichtet wird. Mit Hilfe von Tabulatortabellen
knnen fr einen gegebenen Textblock abweichende Tabulatoreinstellungen eingerichtet werden.
:p.Im Tabulatordialog wird ein Lineal mit den derzeit fr das Hauptfenster gltigen Tabulatoreinstellungen
angezeigt. Durch Klicken mit der Maus auf den Linealmarkierungen knnen Tabulatoren gesetzt und
entfernt werden.
:p.Die Anzahl der Tabulatoren ist auf 60 begrenzt.
:p.Die Tabulatorwerte werden als Punkte gespeichert und sind auf 1/65536 Punkt genau. (Ein Inch hat 72.2818 Punkte.)
.*-----------------------------------------------------------------------------
:h2 res=43 id=43 global.Schriftauswahl
:i2 refid=cellsmnu.Schriftauswahl
:p.Benutzen Sie den Schriftartendialog zur Auswahl einer Schriftart. Mit Hilfe dieses Dialogs lt sich zudem
eine Reihe von Einstellungen anpassen, die das Erscheinungsbild einer Schrift beeinflussen.
:p.Zoomen Sie mit Hilfe der Zoom-Schaltflchen in der Menleiste des Hauptfensters hinein, falls das Schriftbeispiel
zu klein sein sollte. Wurde Text markiert, wird er als Beispielzeichenkette verwendet.
:p.:hp2.Schriftart:ehp2.
:p.Zur Auswahl einer Schriftart werden zwei Listenfenster verwendet. Das erste zeigt
die verfgbaren Schriftfamilien an, das zweite die fr die jeweilige Schriftart verfgbaren
Stile.
:p.Whlen Sie im Listenfenster 'Schriftgre' eine vorgegebene Schriftgre aus oder geben Sie selbst
eine ein.
:p.:hp2.Schriftschnitt:ehp2.
:p.Mit Hilfe des Schriftschnitts knnen normale Schriftarten auch fett oder kursiv dargestellt werden.
Bei den damit erzeugten Schriften handelt es sich evtl. nicht um echte Schriftarten, sondern um
synthetisierte Schriften. Seien Sie sich im klaren darber, da synthetisierte Schriftschnitte
zu unerwarteten Ergebnissen beim Ausdruck eines Dokumentes in einer Druckerei fhren knnen.
Beim Ausdruck ber den eigenen PC ist ein kurzer Testausdruck ratsam, um das Ergebnis berprfen
zu knnen.
:p.:hp2.Zeichendehnung:ehp2.
:p.Nutzen Sie die Zeichenabstands-Steuerelemente, um den Abstand zwischen Zeichen anzupassen, und die
Zeichendehnungs-Steuerelemente, um die durchschnittliche Breite eines Zeichens zu beeinflussen.
Dazu knnen die Schieberegler benutzt oder Werte in die entsprechenden Felder eingegeben werden.
:p.Sowohl Abstand als auch Dehnung werden in Prozent der durchschnittlichen Textweite angegeben.
:p.:hp2.Zeichenscherung:ehp2.
:p.Die Zeichenscherung legt fest, wie Zeichen gekippt werden. Dies ist eine Mglichkeit, kursiven Text zu erzeugen.
:p.Benutzen Sie den Drehregler oder das Eingabefeld zur Eingabe eines Winkels in Grad. Die Statusanzeige gibt den
Vertikalwinkel - also den Winkel der vertikal verlaufenden Teile der Zeichen - an und bercksichtigt die
aktuellen Drehungsfaktoren.
:p.:hp2.Rcksetzen:ehp2.
:p.Drcken Sie 'Rcksetzen', um die Steuerelemente auf die derzeitigen Einstellungen zurckzusetzen.
:p.:hp2.Als Standard sichern:ehp2.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textrahmen
mit diesem Stil erstellt werden.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Ist Text markiert, wird dieser angepat. Andernfalls werden nur die derzeitigen Texteinstellungen
gendert. Diese wirken sich erst aus, wenn neuer Text eingefgt wird.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=51 id=51 global.Unterschneiden
:i2 refid=cellsmnu.Unterschneiden
:p.:hp2.ber Unterschneiden:ehp2.
:p.Das Unterschneiden ist ein Verfahren zur Anpassung des Abstandes zwischen bestimmten Zeichenpaaren,
um ein ausgewogeneres Aussehen der Wrter zu erreichen. Zu den klassischen Anwendungsbeispielen
des Unterschneidens gehrt das Zusammenziehen der Buchstaben Y und o. Andernfalls schiene es, als ob
sich zwischen den Buchstaben ein Leerzeichen befnde.
:p.Das Unterscheiden erfordert in die aktuelle Schriftart eingebaute Unterschneidungstabellen. Die Unterschneidungstabellen
knnen sich dabei sehr wohl von Schriftart zu Schriftart voneinander unterscheiden. Wird keine
Unterschneidungstabelle gefunden, findet kein Unterschneiden statt.
:p.:hp2.Dialog Unterschneiden:ehp2.
:p.Benutzen Sie den Dialog 'Unterschneiden' um festzulegen, unter welchen Umstnden unterschnitten wird.
Ist Text markiert, wird dieser angepat. Andernfalls werden nur die derzeitigen Texteinstellungen
gendert. Diese wirken sich erst aus, wenn neuer Text eingefgt wird.
:p.Verwenden Sie das ausklappbare Listenfeld oder das Eingabefeld des Kombinationsfeldes zur Eingabe eines
Mindestschriftgrads fr das Unterschneiden.
:p.Mit Hilfe des Markierungsfeldes lt sich das Unterschneiden fr den markierten Text aktivieren und deaktivieren.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textbehlter
mit diesem Stil erstellt werden.
.*-----------------------------------------------------------------------------
:h2 res=52 id=52 global.Schattenwurf einstellen
:i2 refid=cellsmnu.Schattenwurf einstellen
:p.Mit Hilfe des Schattenwurfs kann ein Textstck oder ein Titel hervorgehoben werden. Zum Zeichnen
des Wurfschattens unterhalb des Textstcks wird eine Schattenwurffarbe verwendet. Der Standardwurfschatten
benutzt eine mittelgraue Farbe und ist um 7% nach rechts unten versetzt.
:p.Wenn Ihnen die Standardwerte zusagen, reicht ein Klick auf die Schaltflche 'Schattenwurf' zur Aktivierung
des Schattenwurfs auf. Es gibt jedoch ein paar Stolpersteine.
:p.Zum einen ist der Wurfschatten unsichtbar, wenn die Schattenwurffarbe deaktiviert ist. Gleichermaen wird
der Wurfschatten versteckt, wenn der Versatz Null betrgt.
:p.Der Dialog 'Schattenwurf einstellen...' gibt Ihnen wesentlich weitergehende Kontrollmglichkeiten ber den Schattenwurf.
Mit seiner Hilfe knnen die Farbe, der Versatz in Prozent und die Versatzrichtung des Wurfschattens festgelegt werden.
Der prozentuale Versatz basiert auf der Hhe der maximalen Oberlnge - gewhnlich die Hhe des groen 'H'.
:p.Ist Text markiert, wird dieser angepat. Andernfalls werden nur die derzeitigen Texteinstellungen
gendert. Diese wirken sich erst aus, wenn neuer Text eingefgt wird.
:p.Drcken Sie 'Anwenden' zum bernehmen der neuen Einstellungen. Drcken Sie 'Beenden', wenn
Sie mit dem Ergebnis zufrieden sind.
:p.Bei Auswahl des Markierungsfeldes 'Als Standard sichern' werden die Informationen in das
Initialisierungsprofil des Maul Publishers geschrieben, wodurch alle neuen Textbehlter
mit diesem Stil erstellt werden.
.*-----------------------------------------------------------------------------
:h2 res=50 id=50 global.Hochstellung oder Tiefstellung auswhlen
:i2 refid=cellsmnu.Hochstellung oder Tiefstellung auswhlen
:p.Mit Hilfe der Schaltflchen Hochstellung und Tiefstellung lassen sich hochgestellte und
tiefgestellte Texteintrge erzeugen. Diese Hervorhebung sollte nicht auf ganze Artikel
angewendet werden, da dies einen schlechten Einflu auf die Textformatierung hat.
.*-----------------------------------------------------------------------------
:h2 res=48 id=48 global.Zeichenkette fr Titelextraktion markieren
:i2 refid=cellsmnu.Zeichenkette fr Titelextraktion markieren
:p.Benutzen Sie den Dialog 'Titelextraktion' zur Markierung einer Zeichenkette als Titel, um daraus
spter ein Inhaltsverzeichnis des Dokuments zu erzeugen.
:p.Whlen Sie eine Titelebene. 0 schaltet die Titelmarkierung ab. 1 ist die hchste Ebene, 8 die niedrigste.
Die aktuelle Titelebene wird durch Klick auf 'OK' festgelegt.
:p.Ist Text markiert, wird dieser angepat. Andernfalls werden nur die derzeitigen Texteinstellungen
gendert. Diese wirken sich erst aus, wenn neuer Text eingefgt wird.
:p.Ein markierter Titel unterscheidet sich in seinem Aussehen nicht von einem nicht markierten; er ist also nicht
auf Anhieb im Text zu erkennen. ber die aktuelle Ebene gibt jedoch das Feld fr den Cursor-Status und dessen
Position in der Statuszeile Auskunft.
:p.Achten Sie darauf, nicht versehentlich den gesamten Artikel als Titel zu markieren. Wrde dann eine bestimmte
Titelebene festgelegt, so wrde diese auch jedem weiter hinzugefgten Text zugewiesen. Eine folgende Extraktion
des Inhaltes lieferte dann einiges mehr als beabsichtigt!
.*-----------------------------------------------------------------------------
:h2 res=100 id=100 global.Stilvorlagen bearbeiten
:i2 refid=cellsmnu.Stilvorlagen bearbeiten
:p.Verwenden Sie den Dialog 'Zu Stilliste hinzufgen', um einen Tabellenstil
hinzuzufgen oder zu lschen. Tatschlich wird der Stil der derzeit ausgewhlten
Behlter gesichert. Mit Hilfe der im Men 'Bearbeiten' verfgbaren Beschrnkungen
lassen sich die in der Stilvorlage
gesicherten Behltertypen :link reftype=hd res=16.einschrnken:elink..
:p.Der Tabellen-Handler sichert alle verfgbaren Behlterstile als Kindstile, so da
diese auch von allen anderen Handler verwendet werden knnen, die diese Stile erkennen knnen.
D.h. der Text-Handler ist in der Lage, vom Tabellen-Handler gesetzte Textkindstile zu lesen und
zu verwenden. Die tatschlich gesicherten Kindstile sind von den ausgewhlten Behltern und
den aktiven Beschrnkungen abhngig.
:p.Ist 'Als Standard sichern' markiert, werden die Informationen im Initialisierungsprofil des
Maul Publisher gesichert, und alle neuen Tabellenrahmen werden mit diesem Stil erstellt.
.br
.br
.******************************************************************************
:h1 res=500 id=500 global.Die Statuszeile
:i1 id=statbar.Die Statuszeile
:p.Der Tabellen-Handler fgt der Statuszeile einen aus vier Teilen bestehenden Bereich hinzu.
:p.Der erste Statuseintrag identifiziert wie blich den Tabellen-Handler.
:p.:hp2.Ausgewhlter Tabellenbereich:ehp2.
:p.Der zweite Statuseintrag zeigt den derzeit ausgewhlten Bereich an. Dieser besteht
aus einer Blattkennung, gefolgt von einer Zelle oder einer Bereichsauswahl. Zur Zeit
untersttzt dieser Handler keine mehrfachen Bltter, so da die Blattkennung immer
:hp2.A&colon.:ehp2. ist. Wurde nichts ausgewhlt, ist die Auswahl leer
:hp2.A&colon.<--->:ehp2.. Wurde nur eine Zelle ausgewhlt, wird die Zelle angezeigt
:hp2.A&colon.A0:ehp2., andernfalls wird der Bereich angezeigt :hp2.A&colon.A0..B1:ehp2..
:p.:hp2.Position des Text-Cursors:ehp2.
:p.Der dritte Eintrag ist die Position des Textcursors. Die Statusinformation des Text-Cursors
enthlt eine Reihe ntzlicher Anzeiger mit folgendem Format&colon.
:p.:hp2.L<zeilennummer><lolkennung><textposition>,<titelmarkierung><tabulatorliste>:ehp2.
:p.Zeilennummer und Textposition drften selbsterklrend sein. Diese beiden Zahlen zeigen Zeile und Spalte
der derzeitigen Cursor-Position an.
:p.:hp1.Die LOL-Kennung:ehp1.
:p.Die LOL-Kennung ist weniger offensichtlich. Ein LOL ist ein unsichtbarer Datenblock, der eine nderung
des Textstils zwischen dem vorangehenden und dem folgenden Zeichen bewirkt. Wird der Cursor auf der Grenze
zwischen zwei Textstilen plaziert, kann Text entweder im vorigen (Standard) oder im folgenden Stil
eingegeben werden. Soll der vorige Stil verwendet werden, mu sich die Position vor dem LOL befinden,
ist dagegen der folgende Stil gewnscht, mu sich die Position nach dem LOL befinden.
:p.Um ein LOL zu berspringen (LOL bedeutet 'leap over lol' oder 'ein LOL berspringen'), halten Sie die Alt-Taste
gedrckt und drcken Sie die rechte Cursor-Taste auf der Tastatur. Der Beginn eines LOLs wird mit der linken
Cursor-Taste der Tastatur angesteuert.
:p.Befindet man sich am Beginn eines LOLs (der Standard), entspricht die LOL-Kennung einem Doppelpunkt "&colon.";
am Ende eines LOLs ndert sich die LOL-Kennung auf ein '*'.
:p.:hp1.Die Titelmarkierung:ehp1.
:p.Befindet sich der Cursor innerhalb eines markierten Titels, entspricht die Titelmarkierung einer Zahl von 0 bis 8.
Andernfalls zeigt ein '.' keine Titelmarkierung an. Eine Titelmarkierung der Ebene 0 wird nicht extrahiert. Alle Titel
sollten durch ein Textstck der Ebene 0 getrennt sein.
:p.:hp2.Die Tabulatorliste:ehp2.
:p.Befindet sich vor der derzeitigen Cursor-Position ein gltiges Tabulator-LOL, wird dies durch ein 't' angezeigt.
Andernfalls zeigt ein '.' an, da sich an diesem Punkt des Rahmens keine gltige Tabulatorliste befindet.
:p.:hp2.Statusinformation zu Schriften:ehp2.
:p.Der letzte Teil der Statuszeile zeigt den genauen Namen der aktuellen Schriftart an, wogegen der Schriftname im
Listenfeld der Werkzeugleiste den Namen der Schriftfamilie angibt.
:p.Daher knnte das Listenfeld in der Werkzeugleiste 'Swiss' fr die Schriftfamilie Swiss anzeigen
und die Statuszeile 'Helv Bold' fr die tatschliche Schriftart innerhalb der Schriftfamilie Swiss.
:p.Ein anderer Unterschied besteht darin, da dieser Schriftname aus den Dateidaten gelesen
wird, und falls eine Schriftart auf dem System fehlt, zeigt diese Anzeige den Namen
der gesuchten Schriftart an. In solchen Fllen wird vor dem Namen der Schriftart ein
(?) eingefgt. Wenn dies geschieht, gibt es keinen Bezug zwischen der in der Werkzeugleiste
aufgefhrten und der in der Statuszeile angezeigten Schrift.
:p.In der Werkzeugleiste kann es also 'Times New Roman' heien, aber die Statuszeile knnte
'(?)Helv bold' anzeigen. Damit wird angezeigt, da die Schriftart 'Helv bold' bentigt wird, auf
dem System aber nicht verfgbar ist.
.br
.******************************************************************************
:h1 res=700 id=700 global.Der Tabellen-Import-Handler
:i1 id=import.Der Tabellen-Import-Handler
:p.Der Tabellen-Import-Handler ist insofern ungewhnlich, als da er den Import jedes
Formates erlaubt, das Maul Publisher zur Verfgung steht. Dies ist erforderlich, weil
eine Tabelle eine ganze Reihe verschiedener Datentypen enthalten kann.
:p.Die Daten werden immer in die aktuelle Auswahl importiert. Lassen Sie jedoch Vorsicht
walten, da keine Auswahl so interpretiert wird, als ob die gesamte Tabelle ausgewhlt wre.
:p.Ist die gesamte Tabelle ausgewhlt, so wird die Tabelle vollstndig ersetzt, wenn dies vom
Format der importierten Daten untersttzt wird.
:p.Wenn dies nicht mglich ist, versucht der Tabellen-Import-Handler, die Daten soweit wie
mglich in den ausgewhlten Bereich einzupassen. Ist der zu importierende grer als der
ausgewhlte Bereich, gehen manche die zu importierenden Daten verloren. Wurde die gesamte
Tabelle ausgewhlt, wird dieses Verhalten so abgendert, da die Anzahl der Zeilen und
Spalten dergestalt angepat wird, da die neuen Daten perfekt eingepat werden knnen. Mit
anderen Worten wird die Tabelle ersetzt.
:p.Mauls Importmethode wird verwendet, um fr alle verschiedenen Datenformate eine Konvertierung
zu bieten, so da diese bei Verfgbarwerden neuer Import-Handler von den Tabellen untersttzt
werden.
.br
.******************************************************************************
:h1 res=600 id=600 global.Hilfe zu Tasten
:i1 id=keys.Hilfe zu Tasten
:p.Fr diesen Handler stehen die folgenden Tastenkrzel zur Verfgung. Es werden die gebruchlichsten Tastenkrzel aufgefhrt, jedoch
keine Tastenkrzel, die fr andere Handler spezifisch sind. Whlen Sie einen Rahmen und Handler aus, fr die Sie Informationen
bentigen und rufen Sie die Hilfe nochmals auf.
:p.Ist kein Rahmen ausgewhlt, so wird die Tastenhilfe fr das Hauptprogramm des Maul Publisher angezeigt.
:p.Bitte beachten Sie, da Sie diese Tasten ndern knnen und da hier nur die Standardeinstellungen angezeigt werden.
:p.:hp2.Allgemeine Tastenbelegung:ehp2.
:ol.
:li.:hp2.Menauswahl:ehp2.
:dl compact tsize=16.
:dt.Alt+B:dd.Men Bearbeiten
:dt.Alt+D:dd.Men Datei
:dt.Alt+H:dd.Men Hilfe
:dt.Alt+O:dd.Men Optionen
:dt.Alt+S:dd.Men Seite
:dt.Alt+W:dd.Men Widerrufen
:dt.Alt+A:dd.Men Anzeige
:dt.Alt+U:dd.Umschalten zu (Umschaltliste)
:edl.
:li.:hp2.Men Datei:ehp2.
:dl compact tsize=16.
:dt.Strg+N:dd.Neue Datei
:dt.Strg+:dd.Datei ffnen...
:dt.Strg+I:dd.Importieren...
:dt.Strg+X:dd.Exportieren...
:dt.Strg+S:dd.Datei sichern
:dt.Strg+A:dd.Datei sichern unter...
:dt.Strg+R:dd.Datei drucken...
:edl.
:li.:hp2.Men Seite:ehp2.
:dl compact tsize=16.
:dt.Strg+P:dd.Seitendruckeinstellungen...
:dt.Strg+M:dd.Rnder und Gitter...
:dt.Strg+Umschalt+M:dd.Seitenvorlage verwenden...
:dt.Strg+T:dd.Seitenvorlage sichern/lschen
:dt.Alt+Umschalt+Entf:dd.Eine Seite kopieren
:dt.Alt+Umschalt+Einfg:dd.Eine Seite aus der Zwischenablage einfgen
:dt.Strg+Umschalt+I:dd.Eine neue Seite einfgen
:dt.Strg+Umschalt+J:dd.Eine neue erste Seite einfgen
:dt.Strg+Umschalt+D:dd.Eine Seite lschen
:dt.Alt+G:dd.Gehe zu Seite
:dt.Strg+Umschalt+N:dd.Nchste Seite
:dt.Strg+Umschalt+P:dd.Vorige Seite
:edl.
:li.:hp2.Men Anzeige:ehp2.
:dl compact tsize=16.
:dt.Strg+1:dd.Seitenanzeige Drucker
:dt.Strg+2:dd.Seitenanzeige
:dt.Strg+3:dd.Auf Breite anpassen
:dt.Strg+4:dd.Wirkliche Gre
:dt.Strg+Plus:dd.Vergrern
:dt.Strg+Minus:dd.Verkleinern
:dt.Strg+F:dd.Rahmenbearbeitungsmodus
:dt.Strg+C:dd.Inhaltsbearbeitungsmodus
:dt.Strg+G:dd.Hintergrundbearbeitungsmodus
:dt.Strg+B:dd.Umrandungsbearbeitungsmodus
:edl.
:li.:hp2.Men Widerrufen:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Letzte nderung widerrufen
:dt.Strg+Backspace:dd.Letzte nderung wiederholen
:dt.Strg+U:dd.Widerrufsliste...
:edl.
:li.:hp2.Men Optionen:ehp2.
:dl compact tsize=16.
:dt.Strg+Umschalt+R:dd.Druckereinstellungen...
:dt.Strg+E:dd.Raster aktivieren
:dt.Strg+Umschalt+S:dd.Rastereinstellungen...
:edl.
:li.:hp2.Men Hilfe:ehp2.
:dl compact tsize=16.
:dt.Strg+H:dd.Inhaltsverzeichnis
:dt.Strg+Umschalt+H:dd.Hilfeindex
:dt.Strg+K:dd.Hilfe fr Tasten
:dt.Strg+L:dd.Alle Handler anzeigen
:dt.Strg+Z:dd.Produktinformation...
:edl.
:eol.
:p.:hp2.Tastenbelegung Tabellen-Handler:ehp2.
:ol.
:li.:hp2.Men Bearbeiten:ehp2.
:dl compact tsize=16.
:dt.Strg+Alt+0:dd.Eintrge auf Behlter beschrnken
:dt.Strg+Alt+1:dd.Eintrge auf Umrandungsbehlter beschrnken
:dt.Strg+Alt+2:dd.Eintrge auf Fllbehlter beschrnken
:dt.Strg+Alt+3:dd.Eintrge auf Bitmapbehlter beschrnken
:dt.Strg+Alt+4:dd.Eintrge auf Metadateibehlter beschrnken
:dt.Strg+Alt+5:dd.Eintrge auf Rahmensatzbehlter beschrnken
:dt.Strg+Alt+6:dd.Eintrge auf Textbehlter beschrnken
:dt.Umschalt+Delete:dd.Eintrge ausschneiden
:dt.Strg+Insert:dd.Eintrge kopieren
:dt.Umschalt+Insert:dd.Eintrge einfgen
:dt.Strg+D:dd.Eintrge laden
:dt.Delete:dd.Eintrge lschen
:dt.:dd.
:dt.Strg+Umschalt+/:dd.Gesamte Tabelle auswhlen
:dt.Strg+Alt+C:dd.Behlterbereiche anzeigen/bearbeiten...
:dt.:dd.
:dt.F5:dd.Tabellengre festlegen...
:dt.<keine>:dd.Zeile einfgen
:dt.<keine>:dd.Zeile lschen
:dt.<keine>:dd.Spalte einfgen
:dt.<keine>:dd.Spalte lschen
:dt.<keine>:dd.Zeilenhhe angleichen
:dt.<keine>:dd.Spaltenbreite angleichen
:dt.Strg+Alt+Q:dd.Beide angleichen
:dt.F3:dd.Behltereinfgemodus
:dt.F4:dd.Text bearbeiten
:dt.:dd.
:dt.<keine>:dd.Zeichen einfgen...
:dt.Strg+Umschalt+Space:dd.Restrechtsbndigkeit einfgen
:dt.Strg+Alt+E:dd.Objekt/Einstellungen einfgen...
:dt.Strg+Umschalt+Q:dd.Steuerzeichen einfgen...
:dt.<keine>:dd.Einzuarbeitende Zeile auswhlen...
:dt.Strg+Alt+F:dd.Text suchen...
:dt.Strg+Alt+O:dd.Wrter zhlen...
:dt.F2:dd.Rechtschreibprfung...
:dt.Alt+Del:dd.Handler entfernen
:edl.
:li.:hp2.Men Tabellenstil:ehp2.
:dl compact tsize=16.
:dt.Strg+Alt+U:dd.Umrandungslinienstile...
:dt.Strg+Umschalt+W:dd.Umrandungsbreite...
:dt.Strg+Umschalt+K:dd.Umrandungsfarbe...
:dt.:dd.
:dt.Strg+Umschalt+L:dd.Fllfarbe...
:dt.Strg+Alt+V:dd.Erweiterte Fllmodi...
:dt.Strg+Alt+P:dd.Fllmuster...
:dt.Alt+R:dd.Fllungsausrichtung...
:dt.:dd.
:dt.Strg+Umschalt+Y:dd.Grenverhltnis der Bitmap beibehalten
:dt.<keine>:dd.Bitmap skalieren...
:dt.:dd.
:dt.Strg+Umschalt+Z:dd.Grenverhltnis der Metadatei beibehalten
:dt.<keine>:dd.Metadatei skalieren...
:dt.:dd.
:dt.:dd.Textzeichensatz...
:dt.Alt+T:dd.Vertikale Textjustierung oben
:dt.Alt+M:dd.Vertikale Textjustierung mitte
:dt.Alt+B:dd.Vertikale Textjustierung unten
:dt.Strg+Umschalt+O:dd.Zeichenrichtung...
:dt.Strg+Umschalt+G:dd.Absatzeinstellungen...
:dt.Strg+Alt+L:dd.Zeileneinstellungen...
:dt.Strg+Alt+T:dd.Zeilentabulatoren...
:dt.Strg+Umschalt+F:dd.Schriftauswahl...
:dt.Strg+Umschalt+C:dd.Zeichenfarbe...
:dt.Strg+Alt+K:dd.Unterschneiden...
:dt.Strg+Alt+D:dd.Zeichenwurfschatten...
:dt.Strg+Umschalt+U:dd.Hochstellung auswhlen
:dt.Strg+Umschalt+B:dd.Tiefstellung auswhlen
:dt.Strg+Umschalt+X:dd.Als Titel markieren...
:dt.:dd.
:dt.Strg+Alt+S:dd.Vordefinierte Tabellenstile
:dt.Strg+Alt+A:dd.Tabellenstil sichern...
:edl.
:eol.
:p.:hp2.Intelligente Anfhrungszeichen&colon.-:ehp2.
:dl compact tsize=16.
:dt."'":dd.Fgt ein normales Apostroph ein. Es werden keine intelligenten 
Anfhrungszeichen benutzt.
:dt.Alt+"'":dd.Fgt ein intelligentes einfaches Anfhrungszeichen ein. Das Aussehen des 
Anfhrungszeichens 
wird durch die ausgewhlte Sprache und die Position im Text bestimmt.
:edl.
:p.:hp2.Geschtzte Satzzeichen&colon.-:ehp2.
:p.Jedes Zeichen das als Satzzeichen erkannt wird, oder das Leerzeichen, kann als geschtzt markiert werden.
Geschtzte Zeichen werden nicht als Satzzeichen erkannt, und werden ohne Zeilenumbruch als Normalzeichen formatiert. 
Zum Beispiel&colon.-
:dl compact tsize=16. 
:dt." ":dd.Leerzeichen einfgen.
:dt.Strg+Alt+" ":dd.Geschtztes Leerzeichen einfgen.
:edl.
:p.:hp2.Tabulatoren&colon.:ehp2.
:dl compact tsize=16.
:dt.Tab:dd.Fgt einen Tab ein, Tab bewegt das folgende Wort an den Beginn des Tabs.
:dt.Umschalt+Tab:dd.Fgt einen rechtsjustierten oder numerischen Tab ein. Falls das
folgende einen Dezimal-Punkt oder ein Komma enthlt (und auch eine Zahle ist) wird
sich der Text daran fgen. Ansonsten fgt sich der Text an das Ende des nchsten Wortes.
:edl.
.br
.br
:euserdoc.

