.******************************************************************************
.*  Maul Publisher Border Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Border Handler Help
:docprof toc=1234.
:h1 res=1 id=intro.About Maul Border Handler
:i1 id=all.About Maul Border Handler
:p.:artwork name='bordhand.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Default Border Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Border Handler V1.20:ehp2.
:p.Use this handler to add basic outlines to frames.
:p.Apart from the obvious colour and width settings, you can use Warp's inbuilt patterns
to mix a foreground and background frame colour. Also, you can alter the way that corners
and line ends are dealt with.
:p.This handler has the necessary logic to deal with curved borders. In addition, this
handler provides the means to create a border that changes colour from one end to the other,
and supports a number different line styles and line endings.
:p.:hp2.Updates from V1.10:ehp2.
:p.Modified to cope with new frame shapes, this handler should behave just like the previous
version. 
:p.
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1998, 2001 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=8 id=8 global.The Border handler edit menu
:i1 id=edit.The Border handler edit menu
:p.The border handler edit menu contains the basic edit menu items one would expect to find in any editor,
plus a few specific ones for Maul.
:p.These include&colon.-
:ul.
:li.How to :link reftype=hd res=10.cut:elink. the border.
:li.How to :link reftype=hd res=11.copy:elink. the border.
:li.How to :link reftype=hd res=12.paste:elink. in a border.
:li.How to :link reftype=hd res=13.clear:elink. the border and remove the handler.
:li.How to set a border using :link reftype=hd res=54.stylesheets:elink..
:li.How to set the border :link reftype=hd res=20.colour:elink..
:li.How to set the :link reftype=hd res=24.advanced:elink. colour options.
:li.How to set the border :link reftype=hd res=21.pattern:elink. mix.
:li.How to set the border :link reftype=hd res=22.width:elink..
:li.How to set the border :link reftype=hd res=27.width in extrude mode:elink..
:li.How to :link reftype=hd res=26.offset:elink. the border.
:li.How to use :link reftype=hd res=23.shading:elink. borders.
:li.How to set the border shading :link reftype=hd res=36.startpoint:elink..
:li.How to set :link reftype=hd res=35.custom line styles:elink..
:eul.
:lm margin=1.
.*******************************************************************************
:h2 res=10 id=10 global.Cut border to clipboard
:i2 refid=edit.Cut border to clipboard
:p.Select this menu item to copy the border to the clipboard. The border is then destroyed.
:p.The cut command can be executed by using the Shift + Delete keys.
.*******************************************************************************
:h2 res=11 id=11 global.Copy border to clipboard
:i2 refid=edit.Copy border to clipboard
:p.Select this menu item to copy the border to the clipboard. The border is not destroyed.
:p.The copy command can be executed by using the Control + Insert keys.
.*******************************************************************************
:h2 res=12 id=12 global.Paste border from clipboard
:i2 refid=edit.Paste border from clipboard
:p.Select this menu item to paste a border from the clipboard into the frame.
Any existing border is deleted.
:p.The paste command can be executed by using the Shift + Insert keys.
.*******************************************************************************
:h2 res=13 id=13 global.Clear border
:i2 refid=edit.Clear border
:p.Select this menu item to delete the border and remove the border handler
from the frame. Once you have done this you can add a different handler to the frame in place
of the border handler.
:p.The clear command can be executed by using the Delete key.
.*******************************************************************************
:h2 res=54 id=54 global.Set a border style
:i2 refid=edit.Set a border style
:p.Once you have saved a border style, you can use it again and again to recreate a
particular colour or shade throughout your publication.
:p.Use the 'Edit border style...' menu item to access the common stylesheet dialog. This
dialog provides the tools necessary to set and delete styles, and to set a default border style
that is used for every new border that you create.
:p.If you select the small button to the right of the 'Set border style' menu item, the available border
styles are listed. If you select one of the listed styles, that style
becomes the default for the 'Set border style' menu item.
.br
.br
.*******************************************************************************
:h2 res=20 id=20 global.Set border colour
:i2 refid=edit.Set border colour
:p.You will get the colour setting dialog if you create normal lines. If you create a shaded line, you will
get the :link reftype=hd res=34.Shading colours dialog:elink. instead.
:p.Use this dialog to select a border colour. Both the foreground  and background colours are used.
The actual colour will be a mixture determined by the pattern settings. If the current colour
handler supports it, you can set the background colour to transparent. See the
:link reftype=hd res=21.pattern:elink. settings for more information on mixing colours.
:p.This is a dialog within the current colour handler. See the help information
provided with the colour handler to obtain information on how to use this dialog.
.*******************************************************************************
:h2 res=24 id=24 global.Advanced colour options
:i2 refid=edit.Advanced colour options
:artwork name='advanced.bmp' align=left.
.br
:p.:hp2.Shading fill modes:ehp2.
:p.Shading fill modes have a number of parameters that can be modified from the default.
Use this dialog to edit and apply changes to the manner in which shading is performed.
:p.This handler currently only supports shading by crossfading. Crossfading involves fading
one colour out to white, and the next colour in from white.
:p.The crossfade and its parameters are most readily explained with a diagram&colon.-
:artwork name='addiag.bmp' align=left.
.br
:p.:hp2.Run in and run out:ehp2.
:p.The 'run-in' and 'run-out' sliders adjust the size of the run in and run out parts shown
on the diagram. If the sliders aren't accurate enough, you can directly enter the required
percentage values into the edit fields.
:p.As you increase the run in, so the crossfade tends towards blackness. As you increase the
run out, the crossfade tends towards whiteness. If you increase both run in and run out, the
crossface itself occurs over a shorter area. At 100% run in and 100% run out, there remains
no room for the crossfade, and the colours switch directly from one to the next.
:p.:hp2.Normalised brightness:ehp2.
:p.When two colours are mixed, the resultant brightness, or luminance, can change
dramatically. By selecting the 'Normalised brightness' checkbox, the crossfade will correct
and average out this change in brightness. For some colours, the effect is not apparent, for
some, it totally changes the look of the crossfade. The effect is particularly noticable when
mixing between primary colours, such as red and green.
.*******************************************************************************
:h2 res=21 id=21 global.Set border pattern
:i2 refid=edit.Set border pattern
:p.Use this dialog to select a border mix pattern. If the mix pattern is set to solid, the default,
only the current foreground colour is used. If you select one of the other mix patterns, the background
colour is painted first, followed by a pattern in the foreground colour.
:p.If the background colour is set to transparent, only the foreground pattern is painted. This is one way
in which you can tint the edges of an underlying picture or text frame.
:p.The currently selected pattern button is painted red. When you select any pattern button, including the
red one, the dialog is dismissed and the selected pattern is used.
.*******************************************************************************
:h2 res=22 id=22 global.Set border width
:i2 refid=edit.Set border width
:p.Use this dialog to select a border width. If the border width is set to zero, no border is drawn.
:p.The maximum border width is embedded in the frame information and is used to allow text to flow around the outside
or inside of the border. The actual space taken up by the frame gets slightly larger as the border is expanded.
:p.For any border object layer apart from layer 0, you can choose to use the default frame width. Check the 'use default'
checkbox for this to happen. The border will then always be as wide as the widest border for that frame. This is useful for
putting a coloured border behind text for example.
:p.Enter a number followed by the measurement type. i.e. 0.5in.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the size without
a measurement type, the value is considered to be
in printer pels. The actual value is stored as printer pels, so a width of 1 gives the narrowest
possible border.
.*******************************************************************************
:h2 res=27 id=27 global.Set border width in extrude mode
:i2 refid=edit.Set border width in extrude mode
:p.Use this dialog to select a border width. If the border width is set to zero, no border is drawn.
:p.The maximum border width embedded in the frame information in this mode equals zero. This is because the
stroke does not affect the size and shape of the interior of the frame. The extrude border can overpaint text
because it is not possible at the moment to calculate the edge of the extruded area.
:p.:hp2.Offset angle:ehp2.
:p.The extrude mode effectively produces a 3d effect. This involves painting a border that appears to give
the object a thickness such as is perceived with a 3 dimensional object. The offset angle determines the
direction from which this 3d object is viewed.
:p.:hp2.Light shading:ehp2.
:p.The light shading mode changes the brightness of a single colour to give the effect of a secondary light
source illuminating the object. This is the default. You can reverse the shading effect to produce a slightly
different result.
:p.:hp2.Reverse stroke:ehp2.
For the 3d effect to work properly, it is sometimes necessary to reverse the direction in which the path is
calculated. It is immediately apparent if the 3d efect is not working, and reversing the stroke path fixes it.
.*******************************************************************************
:h2 res=26 id=26 global.Offset the border
:i2 refid=edit.Offset the border
:p.Offsetting the border is another way to generate a shadow for a frame. The
technique is very commonly used to make particular objects on the page stand out. In this
instance, the effect is slightly different to offsetting a background.
:p.:hp2.Offset distance:ehp2.
:p.Enter the distance the border should be offset by.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the size without
a measurement type, the value is considered to be
in printer pels.
:p.:hp2.Offset angle:ehp2.
:p.The actual border offset angle is made up of the sum of frame orientation and the
offset angle specified in this dialog. As you rotate the frame, so the offset rotates with it.
This ensures that the overall look of the object is maintained.
:p.You may either use the rotary control, or directly enter the required angle in the offset
angle entry field.
:p.To help you visualise the result, the actual combined angle is also shown.
:p.:hp2.Tip:ehp2.
:p.In the image below, a red border was placed in layer 0, and a black border was placed in
layer 1. The black border was offset by 10mm. Then, a yellow background was added. Notice
that due to the painting order, the offset border is painted over the background.
:p.:artwork name='offset.bmp' align=left.
.br
.br
.*******************************************************************************
:h2 res=23 id=23 global.Set border shading mode
:i2 refid=edit.Set border shading mode
:p.:artwork name='shading.bmp' align=left runin.
:p.This handler provides several modes of colour shading. Colour shading allows you to start a line with one colour
and finish with another. The colours in between are automatically calculated from a given list of colours.
:p.All modes of colour shading start with the default foreground colour. 
:p.If you use the rewinding mode, the colour cycles through all available colours, and then rewinds the colours
back to the default foreground colour at end of the line. The image above is made with two overlapping rectangles
with rewinding shading.
:p.In order for corners to join properly, the shading is sloped into a diagonal across the corners. If you create a
dashed line, you may wish to modify this tapering effect to make the dashes rectangular. The corners are still tapered
together. Select the 'Tapered stroking mode' menu item to see the effect this has.
:p.When shading closed figures like rectangles, you can change the startpoint by using the
:link reftype=hd res=36.set border shading startpoint:elink. dialog.
:p.See also :link reftype=hd res=34.Shading colours dialog:elink..
:p.:hp2.Extrude mode:ehp2.
:p.:artwork name='extrude.bmp' align=left runin.
:p.This mode provides 3d effect borders. By default, the extrude shading mode uses a single colour that is tinted to
provide a lighting effect around the border as shown in the image above. The alternative is a non-rewinding colour
shading mode. If just a single colour is used on a 3d border, the 3d effect is lost.
.br
.br
.******************************************************************************
.*
.*
.*  statusbar information
.*
.*
.******************************************************************************
.******************************************************************************
.*  status bar
.******************************************************************************
:h1 res=60 id=60 global.Status Bar information
:i1 id=stats.Status Bar information
:p.The status bar provides information about the current object.
.******************************************************************************
:h2 res=61 id=61 global.Border width status line
:i2 refid=stats.Border width status line
:p.The Border width status line shows the current width of the border.
.br
.br
.******************************************************************************
.*  Frame cornert
.******************************************************************************
:h1 res=30 id=30 global.Setting Corners on polygon borders
:i1 id=corners.Setting Corners on polygon borders
:p.When you have a normal border on a polygon or rectangle, you can change the way that corners are
handled. Corners may be squared or pointed :artwork name='lmitre.bmp' runin.
, they may be chamfered:artwork name='lbevel.bmp' runin. or rounded.:artwork name='ljcurve.bmp' runin.
This is an inbuilt OS/2 GPI function and exhibits some strange behavior on some systems. The corners do not change for
shaded borders.
.******************************************************************************
.*  Line and endings
.******************************************************************************
:h1 res=31 id=31 global.Setting Line Endings
:i1 id=lineends.Setting Line Endings
:p.Line ending may be altered to suit. Click on one of the line endings buttons, and select a different line ending style.
The default is to stop with a squared:artwork name='lsquare.bmp' runin.
end, but you can set either end to be&colon.-
:dl compact tsize=30.
:dt.Rounded:dd.:artwork name='lround.bmp' runin.
:dt.Small arrow:dd.:artwork name='larrsm.bmp' runin.
:dt.Arrow:dd.:artwork name='larrow.bmp' runin.
:dt.Large arrow:dd.:artwork name='larrlg.bmp' runin.
:dt.Ball junction:dd.:artwork name='lball.bmp' runin.
:dt.Ball:dd.:artwork name='lballct.bmp' runin.
:dt.Ring:dd.:artwork name='lringct.bmp' runin.
:dt.T-bar:dd.:artwork name='ltbar.bmp' runin.
:dt.Diamond junction:dd.:artwork name='ldiam.bmp' runin.
:dt.Diamond:dd.:artwork name='ldiamct.bmp' runin.
:edl.
:p.The junction types overrun the end of the line in order to allow the drawing of
junctions in circuit diagrams for example.
:p.The Line endings are scaled according to the width of the line, and are appropriately coloured.
:p.See also :link reftype=hd res=33.Setting Line styles:elink..
.******************************************************************************
.*  Line Styles
.******************************************************************************
:h1 res=33 id=33 global.Setting Line styles
:i1 id=linestyle.Setting Line styles
:p.As long as you are using a colour shading border, you can set the line style to a variety of types, including a
custom line style. Line styles are based on the idea that forground drawing can be switched on and off on a dot by
dot basis. The length of line represented by a dot equals the width of the line. As a line is made wider, so the
scale of the line style is increased. The handler provides seven predefined line styles, and one custom line style.
:p.To select a line style, first ensure that you have selected one of the :link reftype=hd res=23.shading:elink.
modes. Click on the line style button, and choose a line style. If you choose the custom line style, you can edit it
with the :link reftype=hd res=35.custom line styles:elink.. dialog. Click on 'Custom Linestyle...' in the edit menu
to obtain the dialog.
:p.The following line styles are available&colon.-
:dl compact tsize=30.
:dt.Solid:dd.:artwork name='ltsolid.bmp' runin.
:dt.Long dash:dd.:artwork name='ltdash.bmp' runin.
:dt.Dash dot dot:dd.:artwork name='ltdashdd.bmp' runin.
:dt.Dots:dd.:artwork name='ltdot.bmp' runin.
:dt.Double Dots:dd.:artwork name='ltdotdot.bmp' runin.
:dt.Dash dot:dd.:artwork name='ltdshdot.bmp' runin.
:dt.Short dash:dd.:artwork name='ltshdash.bmp' runin.
:dt.Beads:dd.:artwork name='ltblob.bmp' runin.
:dt.None (empty):dd.:artwork name='ltnone.bmp' runin.
:dt.Custom:dd.:artwork name='ltcustom.bmp' runin.
:edl.
.******************************************************************************
.*  Shading colours
.******************************************************************************
:h1 res=34 id=34 global.Shading Colours Dialog
:i1 id=shadingdlg.Shading Colours Dialog
:p.Create a list of shading colours for shaded lines.
:artwork name='shadedlg.bmp' align=left.
:p.When you first open the dialog, you will find two colours defined. Unless you have already altered the colour of the 
line, both colours will normally be black.
:p.Select one of the colours in the listbox, and you can edit the colour, move the colour up or down the list, or delete
the colour if you have more than two. Shading colour styles need at least two colours defined, although both colours can
be the same. Pressing the add button will add another colour item. The colour of the new colour item is taken from the
currently selected colour.
:p.Use a left mouse click on the colour wheel or colour list to alter the foreground colour. All the methods used by the
default colour dialog can be used here, this includes clicking on the lower right hand swatch control to get a more precise
colour control. You can also select a colour from the colour table, if loaded.
:p.You can change the background colour of your line at any time by editing the background colour. Use a right mouse
click on the colour wheel or colour list to alter the colour. The background colour is independant of the colour items.
:p.See the :link reftype=hd res=24.advanced:elink. settings for more information on normalised colour mixing.
:p.Press 'Apply' to apply the new list of colours, and 'Exit' to exit the dialog when you are finished.
.br
.br
.******************************************************************************
.*  Border start segment
.******************************************************************************
:h1 res=36 id=36 global.Border shading startpoint Dialog
:i1 id=bordstart.Border shading startpoint Dialog
:p.All the shapes available within Maul are made up of one or more segments. If a frame is a closed shape, and is made
up of several segments, you can choose the starting segment to paint the border from.
:p.This is a convenient way of altering the position of the first colour in a shading border.
:p.Furthermore, you can make a fine adjustment by turning the knob provided.
.******************************************************************************
.*  Custom Line Style
.******************************************************************************
:h1 res=35 id=35 global.Custom Line Style Dialog
:i1 id=lsdlg.Custom Line Style Dialog
:p.The custom line style dialog enables you to create some interesting line patterns.
:p.To create a custom line style, first ensure that you have selected one of the
:link reftype=hd res=23.shading:elink. modes. Click on the line style button, and choose the custom line style.
:p.Line styles are based on the idea that forground drawing can be switched on and off on a dot by
dot basis. The length of line represented by a dot equals the width of the line. As a line is made wider, so the
scale of the line style is increased.
:p.The line is drawn where there is a '1' and not drawn where there is a '0'. As the line is drawn, so the line
painting routine cycles through the list of '1's and '0's, repeating the pattern as often as is necessary to draw the
whole line.
:p.So, for example, '1' is a solid line, '10' is a series of dots, and '111110' is a series of long dashes. All that is
necessary is to imagine the numbers repeated. i.e. '111110' becomes 
.br
'&sqbul.&sqbul.&sqbul.&sqbul.&sqbul. &sqbul.&sqbul.&sqbul.&sqbul.&sqbul. &sqbul.&sqbul.&sqbul.&sqbul.&sqbul. &sqbul.&sqbul.&sqbul.&sqbul.&sqbul. '
.br
when repeated four times.
:p.Press 'Apply' to apply the new line style, and 'Exit' to exit the dialog when you are finished.
.br
.br
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=40 id=40 global.Help with keyboard keys
:i1 id=keys.Help with keyboard keys
:p.The following keys are available with this handler. The most common keys are listed, but keys specific to other
handlers are not listed. Select a frame and handler you require information on, and then try keys help again.
:p.If no frame is selected, the main keys help for Maul Publisher is shown.
:p.:hp2.General key usage:ehp2.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+J:dd.Insert new first page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
:p.:hp2.Border handler key usage:ehp2.
:ol compact.
:li.:hp2.Edit menu:ehp2.
:dl compact tsize=16.
:dt.Shift+Delete:dd.Cut border
:dt.Ctrl+Insert:dd.Copy border
:dt.Shift+Insert:dd.Paste border
:dt.R:dd.Border rewinding shading mode toggle.
:dt.S:dd.Border shading mode toggle.
:dt.Delete:dd.Clear border / Remove handler
:dt.Ctrl+Shift+C:dd.Border colour
:dt.Ctrl+Shift+T:dd.Border pattern
:dt.Ctrl+Shift+W:dd.Border width
:dt.S:dd.Shaded border
:dt.R:dd.Shaded border with rewind
:dt.Ctrl+Shift+U:dd.Custom linestyle dialog
:edl.
:eol.:euserdoc.
