.******************************************************************************
.*  Maul Publisher Frame Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Frame Handler Help
:docprof toc=1234.
:h1 res=1 id=intro.About Maul Frame Handler
:i1 id=all.About Maul Frame Handler
:p.:artwork name='bizarre.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Default Frame Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Frame Handler:ehp2.
:p.The frame handler allows you to create frames. When you attach a handler to a frame, the
frame becomes a visible object in your publication.
:p.If you attach a border handler to a line, for example, the line becomes visible in the
printed document, and changes colour and width in accordance with the functions provided by
the border handler.
:p.Using this frame handler you can create rectangles, figures, and arcs. Each frame type provides two or
more variants, so rectangles can also be rounded rectangles, figures provide the means to create multiple
element editable figure types, whereas arcs also allow the creation of pie charts and circles.
:p.You can group frames together, and use them as grouped frames. The handler also allow you to save the
frames thus created as a form of clipart.
:p.A number of tools are provided to adjust the shape and size of frames. These include
tools for scaling, rotation, and positioning. Some frame types also allow the adding and removing of
elements, or the opening and closing of the frame to convert from (say) an arc to a pie segment, or vice
versa. All these tools work in the printer coordinate space, and so are as precise as your printer.
:p.Once you are happy with your frame shape, you can attach handlers to the frame. You can
either use the manual approach provided by Maul Publisher, or use style sheets as provided by
this frame handler.
:p.
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. 1998, 2001 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
:h1 res=7 id=7 global.Using the mouse to best effect
:i1 id=mouseops.Using the mouse to best effect
:p.You can drag out a selection frame with the mouse left button. The frame is a dashed line. Any frames completely
enclosed by the selection frame will be selected when you release the mouse button. If a frame is particularly difficult
to select, this mechanism is a quick way to select that frame, even if you cannot hit the frame itself exactly. Frames
that can be selected in this manner include frames covered by several others, or frames that consist of just a single
point.
:p.All frames in Maul Publisher can be altered using the mouse. There are a number of different frame types, and they
all have slightly different options available.
:p.Most mouse operations are modified by the use of the shift key. Some operations also use the Ctrl, and the Alt keys.
In most instances, the operation is fairly obvious.
:p.:hp2.Common Operations:ehp2.
:p.Whenever you right click on a frame, the edit menu is shown. This menu will be different for each handler.
:p.All frames can be moved by holding down the left mouse button within the frame and dragging. In the case of lines
or splines, this means positioning the mouse on the line.
:p.With all frames, holding down the left mouse button on a handle, or object centre, will switch the mouse operation
to a frame specific type. Frame handles take several different forms. A square handle marks the end of a line or curve,
and is called an end point. A round (or diamond shaped) handle marks a point that controls the curve of a line. Such
handles are known as control points. Arc centres are marked with a cross (X), and cannot themselves be dragged, use the
control handles instead.
:p.Object centres are marked with a cross within a circle. By dragging the object centre, you alter the point around
which the frame is rotated, as well as the centering of bitmaps and backgrounds, depending upon whether the object
handler responsible makes use of the object centre.
:p.:hp2.Rectangles:ehp2.
:p.Rectangles use handles in the corners, and centre line handles. You can make a rectangle larger or smaller in one
direction only, by dragging on a centre line handle.
:p.If you hold down the Shift key whilst dragging a corner, the rectangle will become a square.
:p.See Also :link reftype=hd res=40.Creating rectangles:elink..
:p.:hp2.Rounded rectangles:ehp2.
:p.Rounded rectangles behave just like rectangles. In order to change the rounding, you must edit the frame shape using
the edit dialog.
:p.:hp2.Figures:ehp2.
:p.Figures are made up of line, spline, or three point arc segments. The operation of the Shift and Ctrl keys is
dependent on whether the figure is closed or open, and whether adjacent segments are lines, splines, or arcs.
:p.In all cases, holding Ctrl+Alt during dragging reverts the whole figure to a default orthogonal shape.
:p.&sqbul.Line segments
:p.Lines have just a start and end point. Hold down the shift key to snap the line to either vertical, horizontal or
45 diagonal angles.
:p.&sqbul.Spline segments
:p.Splines are a series of joined curved lines with a handle at each end and two control handles. The control handles
are a different shape to the normal handles, and are used to adjust the curve of the spline.
:p.During normal dragging on one end of a spline, the adjacent control handles are dragged along. Hold down the shift
key to snap the spline to either vertical, horizontal or 45 diagonal angles. Try it to see the effect that this has.
:p.During normal dragging of a control handle, the control handle of an adjacent spline is equally scaled and rotated
about the centre formed by a spline end.
:p.:artwork name='splex2.bmp' align=left.
:p.Holding down the shift key during dragging allows individual handles to be moved.
:p.:artwork name='splex3.bmp' align=left.
:p.&sqbul.Three point arc segments
:p.Three point arcs behave like lines, with the exception that you also have a central control point. Drag this control
point to 'bend' the line.
:p.:hp2.Arcs:ehp2.
:p.Holding down the shift key while dragging on a control point makes the arc circular.
:p.Partial arcs or pie segments have a start and end point. drag on the start point to rotate the pie segment about the
arc, and drag the end point to make the pie segment bigger or smaller. The size of the pie segment is shown in percent.
:p.:hp2.Groups:ehp2.
:p.:link reftype=hd res=6.Groups:elink. behave like rectangles. Hold down the shift key to make the group
border square, rather than rectangular.
.br
.br
.******************************************************************************
:h1 res=6 id=6 global.About groups
:i1 id=groups.About groups
:p.:artwork name='house.bmp' align=left.
:p.Groups are a set of frames contained within a rectangle. Using groups, you can create objects made of more than one
frame.
:p.Moving or sizing a group changes all the frames it contains in a common manner so that the overall image remains
the same.
:p.Groups can be edited, copied, pasted, cut, and deleted just like ordinary frames. The main restrictions are that groups
cannot be rotated, and that linkage of text frames is not preserved. If you copy and paste a group of linked text frames,
you will have to manually re-link them.
:p.Grouping does not hinder the normal frame selection mechanism. The selected frame within a group will have a different
colour to the other frames within a group. If you surround a series of frames with a grouping rectangle, it could be
that no frame is selected. Grouping only works within the frame handler. If you switch to another handler, only the
selected frame will be highlighted.
:p.You can group together a number of existing groups and frames. When you ungroup such a group, the original
constitent groups are restored. This hierarchical nesting of groups within groups can occur as many times as required.
:p.Groups can be aligned, sized, and centred to each other in the same way as frames.
.br
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=8 id=8 global.The Frame handler edit menu
:i1 id=edit.The Frame handler edit menu
:p.This menu adds the following frame editing functions to Maul.
:ul compact.
:li.:link reftype=hd res=22.Edit:elink. a frame or :link reftype=hd res=6.group:elink.
using a dialog for greater precision.
:li.:link reftype=hd res=10.Cut:elink. frame or group to clipboard.
:li.:link reftype=hd res=11.Copy:elink. frame or group to clipboard.
:li.:link reftype=hd res=12.Paste:elink. frame or group from clipboard.
:li.:link reftype=hd res=13.Clear:elink. frame or group.
:li.:link reftype=hd res=14.Lock:elink. frame or group.
:li.:link reftype=hd res=15.Reset:elink. object centre.
:li.:link reftype=hd res=16.Move:elink. frame in front or behind another frame.
:li.:link reftype=hd res=18.Group:elink. frames or groups.
:li.:link reftype=hd res=19.Align:elink. frames to each other.
:li.:link reftype=hd res=20.Centre:elink. frames in the page.
:li.:link reftype=hd res=21.Equalise:elink. frame or group sizes to each other.
:li.:link reftype=hd res=27.Rotate:elink. or mirror a frame or group.
:li.:link reftype=hd res=28.Create a new object:elink.
:li.Set the :link reftype=hd res=17.mode:elink. of an object.
:li.Set the object :link reftype=hd res=56.layer:elink. order.
:li.Set the :link reftype=hd res=26.style:elink. of a frame.
:eul.
.*******************************************************************************
:h2 res=22 id=22 global.Edit a frame or group using a dialog
:i2 refid=edit.Edit a frame or group using a dialog
:p.You can edit a frame or :link reftype=hd res=6.group:elink. by changing its height, width, and
position on the page. The dialog treats all frames as rectangular, with only a vertical component, and a horizontal
component. If the frame is irregular, an imaginary rectangle is calculated that can just hold the selected shape(s).
If you alter the size and position of this imaginary rectangle, the frame or group is suitably scaled and shifted
to fit perfectly inside the altered rectangle.
:p.Enter in each field you wish to change a number followed by the measurement type. i.e. 0.5in.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the size without a
measurement type, the value is considered to be
in printer pels. The actual value is stored as printer pels.
.*******************************************************************************
:h3 res=23 id=23 global.Rotate a frame using a dialog
:i2 refid=edit.Rotate a frame using a dialog
:artwork name='rotdlg.bmp' align=left.
:p.This dialog provides some interesting possibilities. You can rotate certain frames, but you can also change
the object orientation of certain frames.
:p.The object orientation does not affect the figure shape in any way, its purpose is to rotate the viewing data
of any object handlers attached to the frame. This is a way of simultaneously rotating text and/or pictures attached
to the frame.
.*******************************************************************************
:h3 res=24 id=24 global.Alter rectangle rounding using a dialog
:i2 refid=edit.Alter rectangle rounding using a dialog
:p.Enter a number followed by the measurement type into the entryfield. i.e. 0.5in. The value represents
the radius of the rounded corners. If you set the value to zero, the corners will be square. If you set the
radius too large to be contained by the rectangle, you get a strange but quite pleasing effect.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and dpt (1/10 pt).
There are 25.4 mm to the inch, and 72.2818 points to the inch. If you give the size without a
measurement type, the value is considered to be
in printer pels. The actual value is stored as printer pels.
.*******************************************************************************
:h3 res=25 id=25 global.Pie segment or partial arc size and orientation dialog
:i2 refid=edit.Pie segment or partial arc size and orientation dialog
:artwork name='arcdlg.bmp' align=left.
:p.Use this dialog to alter partial arcs or pie segments. It is important to realise that the start angle is relative
to the current object rotation, and that the current object rotation is determined by the arc control handles.
:p.In order to make it easier to create business pie charts, the pie segment or partial arc sweep is specified as a
percentage of a full circle, rather than degrees, ie 50% equals 180.
.*******************************************************************************
:h2 res=10 id=10 global.Cut frame or group to clipboard
:i2 refid=edit.Cut frame or group to clipboard
:p.Select this menu item to copy the current frame or group and all its contents to
the clipboard. The frame or group and its contents are then destroyed.
:p.Any linkage to the clipboard copy of the frame or group is destroyed by this action,
so if you paste the frame or group back again, linkage is not preserved.
:p.If the command is used with a series of grouped frames, the entire group of frames is treated as one.
:p.The cut command can be executed by using the Shift + Delete keys.
.*******************************************************************************
:h2 res=11 id=11 global.Copy frame or group to clipboard
:i2 refid=edit.Copy frame or group to clipboard
:p.Select this menu item to copy the current frame or group and all its contents to
the clipboard.
:p.Any linkage to the clipboard copy of the frame or group is destroyed by this action,
so if you paste the frame or group back again, linkage is not preserved.
:p.The frame or group is also copied to the clipboard as a metafile, so you can paste copied
frames directly into any other application that recognizes metafiles.
:p.If the command is used with a series of grouped frames, the entire group of frames is treated as one.
:p.The copy command can be executed by using the Control + Insert keys.
.*******************************************************************************
:h2 res=12 id=12 global.Paste frame or group from clipboard
:i2 refid=edit.Paste frame or group from clipboard
:p.Select this menu item to paste a frame or group from the clipboard into the current
page. The shape and size of the frame or group is adjusted to match the current dots per
inch settings of you publication, and the new frame or group is centred on the screen.
:p.The currently selected frame or group is not deleted.
:p.If the command is used with a series of grouped frames, the entire group of frames is treated as one.
:p.Select the 'Multiple frame/group paste' menuitem to paste the the frame or group into the page as
many times as it will fit. The page is filled from left to right, and from top to bottom, with each paste
being as close to it's neighbor as it can get without overlapping.
:p.The paste command can be executed by using the Shift + Insert keys.
.*******************************************************************************
:h2 res=13 id=13 global.Clear frame or group
:i2 refid=edit.Clear frame or group
:p.Select this menu item to delete a frame or group and its contents.
:p.If an individual frame was in a linked text chain, the previous text object in the
chain will be linked to the next text object in the chain.
:p.If the command is used with a series of grouped frames, the entire group of frames is treated as one.
:p.The clear command can be executed by using the Delete key.
.*******************************************************************************
:h2 res=14 id=14 global.Lock frame or group
:i2 refid=edit.Lock frame or group
:p.The frame or :link reftype=hd res=6.group:elink. is locked. You cannot drag, or resize a frame or
group in any way once it is locked. This is useful for frames that should not be accidentally altered.
:p.If one frame in a group is locked, the entire group is also treated as locked.
:p.If the frame or group is copied and pasted, the new pasted frame or group is automatically unlocked.
.*******************************************************************************
:h2 res=15 id=15 global.Reset object centre
:i2 refid=edit.Reset object centre
:p.This command first finds the smallest rectangle that can contain the object. It then places the object centre at the
centre point of the rectangle. The object centre is used by some handlers in order to position their display data within
the object, as well as for the centre of object or frame rotation.
:p.Note that some operations on certain frame types cause the object centre to be reset anyway.
.*******************************************************************************
:h2 res=16 id=16 global.Frame ordering
:i2 refid=edit.Frame ordering
:p.:hp2.Move frame to back or front:ehp2.
:p.Use these controls to move a frame to the front or to the back. This is very useful
if you have objects covered by other objects.
:p.If you have a text object frame and you move a picture object frame in front of it, Maul is
capable of flowing the text around the picture. This is true even if either or both of the
frames involved (picture or text) are not rectangular.
.*******************************************************************************
:h2 res=18 id=18 global.Group frames or groups
:i2 refid=edit.Group frames or groups
:p.There are times when you may wish to link frames together in order to form groups. A group may contain
a number of frames that you wish to copy, save, scale, or move, as an entity. Once a set of frames are grouped
together, moving one frame moves all frames equally, copying a group copies all frames within it, and so on.
:p.Most group operations are possible simply by dragging a dashed outline around the frames or groups that interest.
Any frame or group not totally included in this outline will be ignored.
:p.In order to copy and paste, or load and save groups, you need to group the frames together. Once you have
done so, selecting a frame within the group selects that frame to allow some single frame operations such as
adding object handlers to take place. The selected frame will have a different colour to the others. However,
the frame handler selects and treats the whole group of frames as a single entity, allowing you to size and move
all the frames together.
:p.If you need to modify a single frame within the group, you can unlink the group. You can also add frames to a
group, by selecting both, and then grouping them together. You can group several groups and frames to make a
bigger group.
.*******************************************************************************
:h2 res=19 id=19 global.Align frames
:i2 refid=edit.Align frames
:p.Use this function to align frames on top of each other. The operation depends upon what you have selected.
:p.:hp2.The selected frames are a single group:ehp2.
:p.All other frames within the group are aligned with the currently selected frame.
:p.:hp2.The selected frames are a number of frames or groups:ehp2.
:p.All the frames or groups are aligned with the centre of the selection rectangle. The relationship of frames within
groups are maintained.
:p.For all these operations you can choose to manipulate your frames in either the vertical sense, the horizontal
sense, or both.
.*******************************************************************************
:h2 res=20 id=20 global.Move frames to centre
:i2 refid=edit.Move frames to centre
:p.Use this function to move frames to the centre of the currently selected page. You can choose to move all the
frames to the centre of the page, or you can move all the selected frames to the centre whilst keeping their relative
placements the same. This function can also centre a single frame.
:p.For all these operations you can choose to manipulate your frames in either the vertical sense, the horizontal
sense, or both.
.*******************************************************************************
:h2 res=21 id=21 global.Equalise frame sizes
:i2 refid=edit.Equalise frame sizes
:p.Use this function to make frames or groups the same size. The operation depends upon what you have selected.
:p.:hp2.The selected frames are a single group:ehp2.
:p.All other frames within the group are resized to the currently selected frame.
:p.:hp2.The selected frames are a number of frames or groups:ehp2.
:p.All the frames or groups are scaled to match the largest group.
:p.:hp2.The selected frames are a number of frames only :ehp2.
:p.All the frames are scaled to match the largest frame.
:p.For all these operations you can choose to manipulate your frames in either the vertical sense, the horizontal
sense, or both.
.*******************************************************************************
:h2 res=27 id=27 global.Rotate or mirror a frame or group
:i2 refid=edit.Rotate or mirror a frame or group
:p.You can rotate any frame or group in increments of 90 degrees. Further, you can mirror a
frame or a group by flipping it horizontally or vertically.
:p.:hp2.Rotate:ehp2.
:p.When frames are rotated, the internal frame orientation is altered to reflect the change.
:p.The frame orientation is used by object handlers, and the object handler will repaint the
screen to show the change.
:p.Note that the object handler itself may maintain separate
orientation or direction values, and that the final text or image orientation could be a
combination of several different settings.
:p.:hp2.Mirror:ehp2.
:p.When frames are mirrored, the internal frame orientation is altered to reflect the change.
:p.The mirroring function divides the current frame orientation into vertical and horizontal
components, and then reverses the appropriate component before recalculating the vector.
:p.The frame orientation is used by object handlers, and the object handler will repaint the
screen to show the change.
:p.Note that the object handler itself may maintain separate orientation or direction values,
and that the final text or image orientation could be a combination of several different
settings.
:p.Take the example of a shaded background with a horizontal 90 degrees object data angle,
and a frame angle of 0 degrees. When you mirror the frame, the background shading does not
change as you might expect. A vertical flip changes the horizontal shading direction, and a
horizontal flip is ignored.
.br
.br
.*******************************************************************************
:h2 res=28 id=28 global.Create a new object wizard
:i2 refid=edit.Create a new object wizard
:p.The new object wizard is designed to help new users of Maul Publisher to create text or
pictures. The wizard uses either three or four dialog panels to walk you through the process.
:p.Once you know how to do this manually, you can disable the wizard.
:p.:hp2.The wizard dialog panels:ehp2.
:ul.
:li.:link reftype=hd res=29.Choose contents or border layers:elink.
:li.:link reftype=hd res=30.Choose a layer:elink.
:li.:link reftype=hd res=31.Choose an object handler:elink.
:li.:link reftype=hd res=32.Choose a data source:elink.
:eul.
.br
.br
.*******************************************************************************
:h3 res=29 id=29 global.Choose contents or border layers
:p.If you have created a frame with an inside, such as a rectangle, you can add a contents
layer. If you have created an open frame, such as a line, you can only add a border layer.
:p.This panel performs the task of selecting one of the object layer buttons, these are the
buttons with a question mark on them.
:p.Uncheck the 'Always use object wizard' checkbox in order to prevent the wizard being
called automatically. You will still be able to use the wizard from the frame handler edit
menu.
.br
.br
.*******************************************************************************
:h3 res=30 id=30 global.Choose a layer
:p.You have four layers available to you. Layering several objects into a frame has the
advantage that objects such as text and pictures belong to the same frame, and can be moved
as a single entity. The top two layers can also be made to interact with each other in order
to put text inside pictures, for example. See the
:link reftype=hd res=17.object mode settings:elink..
:p.If you want to swap the layers later on, you can do so using the
:link reftype=hd res=56.layer order:elink. dialog.
:p.This panel performs the task of selecting the dropdown button on one of the object layer
buttons, and selecting a specific layer. When you use the object layer buttons, you can avoid
this step.
.br
.br
.*******************************************************************************
:h3 res=31 id=31 global.Choose an object handler
:p.Text or pictures are painted using object handlers. The dialog shows the object handlers
available for this layer.
:p.To find out what an object handler does, select it, and then click again on the
'More info' button. This will show the 'About' help panel associated with the handler.
:p.Click on 'Next' or 'Finish' in order to create the new object layer.
.br
.br
.*******************************************************************************
:h3 res=32 id=32 global.Choose a data source
:p.Once you have chosen an object handler, you can tell it to load some data from the clipboard,
or to scan in an image, for example.
:p.This dialog only appears when you have a choice of data sources. The options you select
here are sent to the object handlers as requests, and different handlers will respond to these
requests in their own way.
:ul.
:li.Paste from clipboard. This option is available when the wizard has detected that
data compatible with the selected handler is available on the clipboard.
:li.Load from file if possible. This is the default option. The wizard will request that the
object handler loads some data from a suitable file. The object handler may choose to
ignore this request or to do something else. In that case, you will either have to type in
some text or option, or use one of the import options in the file menu instead.
:li.Scan using a scanner. This option is currently only available for bitmaps. You can use
any twain compatible data source such as a scanner or digital camera.
:li.Leave object empty. This option will add an object to the frame, but will do nothing
else. The object handler will initialise itself to some default option. For some handlers
this option is the same as the 'Load from file' option.
:eul.

.*******************************************************************************
:h2 res=17 id=17 global.Setting the mode of an object
:i2 refid=edit.Setting the mode of an object
:p.A number of modes are available to objects. Essentially, these modes tell object and frame handlers
what to do with frames.
:p.:hp2.Transparent object:ehp2.
:p.When enabled, the frame does not affect the frame beneath it. When a frame lies over another frame,
an object in the frame beneath may alter to flow around the frame above. Setting the frame mode
transparent turns off this reflow.
:artwork name='transpar.bmp' align=left.
.br
:p.:hp2.Self clipping object (contents or borders):ehp2.
:p.This mode is used for handlers that create artefacts. An artefact is a drawn figure such as
text, lines, or any given shape of a single colour. Note that bitmaps, for example, are not artefacts.
:p.The only artefacts currently available are text (and text symbols). OS/2 can use artefacts such as text
to set up a clipping path, and to then clip subsequent drawing to the clipping path.
:p.Create a frame, and then add a text object to layer 0, and a bitmap or coloured background object to
layer 1. You can even place text inside text, although it won't be formatted to fit the text above. This
works for frame borders as well as frame contents.
:p.Set the self clipping mode for borders or contents, and the frame handler will reverse the painting order
so that the background (layer 1) appears inside the foreground (layer 0).
:p.The result should be something like this...
:p.:artwork name='wow.bmp' align=left.
.br
:p.:hp2.Enable maskmap boundary:ehp2.
:p.It is possible to format text around bitmaps with maskmaps. This mode enables this
functionality. There are a few points to note though.
:ul.
:li.The bitmap must have a mask map and must be in contents layer zero.
:li.The mask map is used to determine boundaries :hp1.instead:ehp1. of the frame.
:li.The mask map must fit entirely into the minimum rectangle that can be fitted around the
frame, or clipping will occur.
:li.If the bitmap image is offlined, only the placeholder maskmap is used. This is because no
additional memory is available to reload offlined files during boundary determination, and
because there is little or no point in determining boundaries any more accurately.
:eul.
:p.:artwork name='maskmap.bmp' align=left.
.br
:p.:hp2.Auto scaling group:ehp2.
:p.This mode only applies to groups because of the way groups are sized. When this mode is selected,
the associated object handlers are notified whenever a group is resized. This ensures that object data
is scaled to match the size of the group. The scaling effect is usually orthogonal, so if you change only the
height of an object, it will not distort the object data in such a way that it scales perfectly.
.br
.br
.*******************************************************************************
:h2 res=56 id=56 global.Object layer ordering dialog.
:i2 refid=edit.Object layer ordering dialog.
:p.Use the 'Object layer ordering...' menuitem in the 'Edit' menu to show the object layer ordering dialog.
:p.:hp2.Description:ehp2.
:p.The visible part of a frame is produced by objects. These objects are modified using object handlers.
:p.The frame handler is responsible for the order in which objects are painted. Each frame can support four layers of
content and four layers of borders. As each layer is painted, it overpaints the previous layer to build the final
image on the page.
:p.The layer ordering dialog allows you to swap objects around so that they are painted in a different order. Because
some layers may be empty, you can also move the empty layers around. Layers at the top of the listbox are painted last,
and so paint over the layers beneath.
:p.:hp2.Usage:ehp2.
:p.Select the layer you wish to move. Click the associated up or down buttons until the layer is moved to where you
want it. When you are ready, click on the 'Apply' button to make the changes. You can now change the layers again, or
you can click on a different frame in order to edit it's layers, or you can click on the 'Exit button to close the
dialog.
:p.Like all dialogs in Maul that have 'Apply' and 'Exit' buttons, the object layer ordering dialog is a threaded
dialog, and can be left on screen even if you decide to alter the frames beneath it. It will close automatically
when you exit, or when the frame handler is deselected.
:p.:hp2.Understanding the painting order:ehp2.
:ol.
:li. set paintmode to "DROPSHADOWS" - (3)
:li. border, layer3
:li. border, layer2
:li. border, layer1
:li. border, layer0
:li.Reset
:li. set paintmode to "CONTENTPAINT"
:li. contents, layer3
:li. contents, layer2
:li. contents, layer1 - (1)
:li. contents, layer0 - (1)
:li.Reset, also resets clipping path - (1)
:li. set paintmode to "BORDERPAINT"
:li. border, layer3
:li. border, layer2
:li. border, layer1 - (2)
:li. border, layer0 - (2)
:li.Reset, also resets clipping path - (2)
:eol.
:note text='note(1):'.The contents layers 0 and 1 are swapped for contents self clipping.
:note text='note(2):'.The border layers 0 and 1 are swapped for border self clipping.
:note text='note(3):'.Special effect borders are painted before any other layers.
.*******************************************************************************
:h2 res=26 id=26 global.Setting the style of a frame
:i2 refid=edit.Setting the style of a frame
:p.By selecting the 'Set frame style' menu item, you attach a set of object handlers to the frame.
:p.This is often quicker than clicking on each handler button in turn and manually selecting
an object handler.
:p.By clicking on the small button on the right of the menu item, you can choose from the
list of available frame styles.
:p.See also :link reftype=hd res=54.Editing frame styles:elink..
.br
.br
.******************************************************************************
.*  Object Menu
.******************************************************************************
:h1 res=9 id=9 global.The Frame handler frames menu
:i1 id=object.The Frame handler frames menu
:p.This menu adds frame creation and manipulation commands to Maul.
.*******************************************************************************
:h2 res=42 id=42 global.Legacy frame types
:i2 refid=object.Legacy frame types
:p.This frame handler has substantially changed from previous versions. In particular, polygon based frames have been
replaced by figure based frames. Figures are capable of much more than polygons, and replace the following frame
types.
:ul.
:li.Lines (TRACKING_LINE).
:li.Splines (TRACKING_MULTISPLINE).
:li.Polygons (TRACKING_POLYGON).
:eul.
:p.In order to provide some backward compatibility, these types can still be edited using this handler. You cannot
create new frames using this type. You can convert splines and polygons as well as rectangles to figures.
:p.If you create new frame types with this handler, you will not be able to edit the new file with a version of
Maul Publisher older than V1.20.
:p.Further changes to this handler include support for grouped figures and metafile clipart.
.*******************************************************************************
:h2 res=40 id=40 global.Creating rectangles.
:i2 refid=object.Creating rectangles.
:p.Press the :artwork name='rectbut.bmp' runin. button to create a simple rectangle. Alternatively,
press the :artwork name='rrectbut.bmp' runin. button to create a rounded rectangle. Rectangle rounding
is determined automatically from the page size, but can be altered by using the
:link reftype=hd res=22.edit frame/group:elink. dialog.
:p.The cursor will change to a cross. Hold down the left mouse button and drag out the
required rectangle. You can use the various handles to adjust the shape of the rectangle.
:p.:artwork name='rectex.bmp' align=left runin.
:p.If you hold down the shift key whilst dragging, the rectangle created will be orthogonal
(ie square).
:p.Holding down the left mouse button inside the frame allows you to drag the whole frame
to the desired position.
:p.Pressing the right mouse button on the created frame will bring up the edit
menu.
:p.Whenever you edit a frame, the frame handler writes a status message to the right-hand
side of the button bar.
.*******************************************************************************
:h2 res=41 id=41 global.Creating figures
:i2 refid=object.Creating figures
:p.Figures are structured frames made up of a number of figure segments. A figure is capable of being either
closed, as in a polygon for example, or open, as in a line or curve. You cannot put text or images inside an
open frame, because an open frame does not have an 'inside'.
:p.Figures can be :link reftype=hd res=44.edited:elink. in a number of ways not previously
possible with this handler. It is possible to modify any of the default figure shapes by adding and removing figure
segments. See ':link reftype=hd res=44.Editing:elink. figures'.
:p.A number of shapes can be created directly by using the various buttons shown below.
:p.:hp2.Open figures:ehp2.
:p.:artwork name='linebut.bmp' align=left runin.:hp2.Lines:ehp2.
:p.A single line is the simplest figure shape. Click on the button, and drag out the length and size of line required.
:p.:artwork name='3plnbut.bmp' align=left runin.:hp2.3 point arcs:ehp2.
:p.3 point arcs act like lines, once you have dragged the line to the correct length, you can bend the line by dragging
on the centrally located control point. Click on the button, and you will be asked how many arcs you wish to create.
Note that you can always add or remove segments later on.
:p.:artwork name='splinebut.bmp' align=left runin.:hp2.Splines:ehp2.
:p.Splines are created in exacly the same way as lines or arcs. Click on the button, and you will be asked how many
splines you wish to create. Then drag out an appropriate line. The line created can be bent or curved into a number of
interesting shapes using the control handles provided.
:p.:hp2.Closed figures:ehp2.
:p.:artwork name='polybut.bmp' align=left runin.:hp2.Polygons:ehp2.
:p.Polygons are closed figures made up of line segments. The smallest number of line segments is three, this creates
a triangle. Click on the button, and you will be asked how many corners you polygon should have. Note that you can
always add or remove segments later on, as long as you don't end up with less than three lines.
:p.:artwork name='3polybut.bmp' align=left runin.:hp2.3 point arc polygons:ehp2.
:p.3 point arc polygons are made in exactly the same way as ordinary polygons, the minimum number of arcs being two.
The arcs are initially joined end to end in order to produce a circle.
:p.:artwork name='spolybut.bmp' align=left runin.:hp2.Spline polygons:ehp2.
:p.Spline polygons are created by joining one or more splines end to end. The smallest number of splines in a spline
polygon is one. In this case, the ends of the spline are joined together, and you get a teardrop shaped figure.
:p.:hp2.See also:ehp2.
:p.:link reftype=hd res=44.Editing:elink. figures.
:p.Using the :link reftype=hd res=7.mouse:elink. to best effect.
.*******************************************************************************
:h3 res=44 id=44 global.Editing figures
:i2 refid=object.Editing figures
:p.All figures are made up of three types of figure segment. A figure can contain literally hundreds of these segments,
right up to the point where you run out of processing power&colon.-
:p.:hp2.A line:ehp2.
.br
:artwork name='linex.bmp' runin.
:p.:hp2.A 3 point arc:ehp2.
.br
:artwork name='3plnex.bmp' runin.
:p.:hp2.A spline:ehp2.
.br
:artwork name='splex.bmp' runin.
:p.Apart from the basic moving, rotating and bending these figure segments provide, you can also add and remove
segments from a figure.
:p.:hp2.Adding figure segments:ehp2.
:p.Press the :artwork name='addbut.bmp' runin. button and you will get a little dropdown menu offering you a choice
of the three segment types you can add. Select one, and then press on an endpoint on the existing figure and drag out
a new segment. You can add any segment type to a figure at any point.
:p.:hp2.Removing figure segments:ehp2.
:p.Press the :artwork name='rembut.bmp' runin. button, and then click on the figure segment you wish to remove. You can
continue to remove figure segments by clicking on them. The remove mode is ended by clicking on the above button to
deselect it, or deselecting the frame by clicking on a blank part of the publication.
:p.:hp2.Opening figures:ehp2.
:p.Press the :artwork name='openbut.bmp' runin. button, and drag any endpoint on the frame away from its neighbor.
:p.:hp2.Closing figures:ehp2.
:p.If the figure is capable of being closed, pressing the :artwork name='clsbut.bmp' runin. button causes the
ends of the figure to connect. If the endpoints are seperated by some distance, they will be moved together. No extra
segments are added to close the figure.
:p.:hp2.Notes:ehp2.
:p.In general, all the above operations affect segments in a clockwise direction from the endpoint you are editing.
:p.Arcs and pie segments are not compatible with figures. However, you can open pie segments to produce arcs and
close arcs to produce pie segments.
.*******************************************************************************
:h2 res=45 id=45 global.Creating arcs and pie segments
:i2 refid=object.Creating arcs and pie segments
:p.Arcs and pie segments are included to allow you to easily create pie charts. These shapes are not compatible
with figures, so you cannot perform the same editing functions as for figures.
:p.All arcs and pie segments use four control points to control arc parameters. The arc parameters determine the
shape of the arc, as well as its orientation. These are the only controls available for full arcs, and enable
you to turn a circle into an ellipse, for example.
:p.Partial arcs and pie segments have two end points. Going clockwise, the first of these handles increases the size
of the arc. This size is measured in percent in order to make it easier to create business charts. The second handle
moves the partial arc or pie segment around the curve determined by the arc parameters.
:p.Partial arcs can be converted to pie segments by pressing the :artwork name='clsbut.bmp' runin. button.
:p.Pie segments can be converted to partial arcs by pressing the :artwork name='openbut.bmp' runin. button.
.*******************************************************************************
:h2 res=46 id=46 global.Loading and saving predefined frames or groups
:i2 refid=object.Loading and saving predefined frames or groups
:p.:hp2.Frames as Clipart:ehp2.
:p.The frame handler has a method of storing and using predefined frames or groups. Two dialogs are provided
to simplify the import and export of frame objects.
:p.You could always use the import and export feature to save frames&colon.-
.br
Create catalogs of frames or groups by adding
folders to Maul's etc path. These folders should be called 'something.cat', the folder 'example.cat' has been
included as an example. Then export the frames to the new catalogue folders. Note that when importing or
exporting a frame, the frame need not reside in a catalog.
:p.Use the dialogs decribed below as a much more effective way to build a set of clipart catalogues.
:p.:hp2.Load frame or group:ehp2.
:p.You can use the 'Load frame/group...' dialog to look at and load a frame or group from the catalogs.
:p.Select a catalogue from the dropdown menu, or '<>' to go back to the top, and then a frame from the listbox. The
dialog will show a preview line sketch of the frame or group you are about to load. Press 'Ok' to load the frame or group.
:p.:hp2.Save frame or group:ehp2.
:p.You can use the 'Save frame/group...' dialog to save a frame or group to a catalog.
:p.You can either select an existing catalogue, or you can type in a new name for a catalogue. The file
extension is not required. If the catalogue does not exist, you will be asked to if you want to create it.
:p.You can either select an existing file, or you can type in a new name for the file. If the file
exists, you can delete it. If you attempt to overwrite an existing file, you will be warned.
:p.You can also delete a catalogue, providing that it is empty and contains no files.
.*******************************************************************************
:h2 res=47 id=47 global.Scaling polygons and splines.
:i2 refid=object.Scaling polygons and splines.
:p.Press the :artwork name='scalebut.bmp' runin. button.
:p.Select a point and drag the frame to scale it.
:p.If you hold the shift key whilst scaling the frame, the scaling effect will
be as nearly equal as possible in the vertical and horizontal direction. The
scaling factors shown may not be precisely the same because you may have a different
printer resolution in one direction compared with the other.
:p.Scaling will snap the frame to an imaginary rectangle drawn around the frame.
.*******************************************************************************
:h2 res=48 id=48 global.Rotating polygons and splines.
:i2 refid=object.Rotating polygons and splines.
:p.Press the :artwork name='rotbut.bmp' runin. button.
:p.Select a point and drag the frame to rotate it.
:p.The rotation will default to 1&deg. increments. If this is not suitable, pressing
the shift key will allow freeform rotation. The resolution of this very much depends
on the accuracy of the mouse cursor and screen resolution. Because of this, zooming
in to the frame will give greater accuracy.
.*******************************************************************************
:h2 res=49 id=49 global.Shearing polygons and splines.
:i2 refid=object.Shearing polygons and splines.
:p.Press the :artwork name='shearbut.bmp' runin. button.
:p.Select a point and drag the frame to shear it.
:p.Shearing is a process whereby a frame is distorted in a controlled manner. A sheared character,
for example, will look italic. If you shear a frame in both the vertical and the horizontal sense,
your frame will tend to look as if it had been rotated in 3 dimensions. Shearing a frame does not
however alter the orientation of its contents.
.*******************************************************************************
:h2 res=55 id=55 global.Converting rectangles or legacy types to figures.
:i2 refid=object.Converting rectangles or legacy types to figures.
:p.Use the 'Rect or poly  Figure' menuitem in the 'Frames' menu.
:p.You may have noticed that you cannot shear, scale, or rotate a rectangle. Once you have converted
a rectangle to a figure, you can alter every corner individually, and apply any transforms available.
:p.Publications using earlier versions of Maul may have :link reftype=hd res=42.legacy:elink.
polygons or lines in them. In order to obtain the functionality available with figures, you will have to convert
these types. This has no visible effect on the publication, but the publication will in future only be editable
by this version of the frame handler, or a later one.
.*******************************************************************************
:h2 res=54 id=54 global.Editing frame styles
:i2 refid=object.Editing frame styles
:p.The frame handler uses Common Stylesheets. You can find out more about these in
Maul Publishers main manual.
:p.:hp2.How styles are stored:ehp2.
:p.The frame handler stores a stylesheet for itself, and then stores a series of secondary,
or child stylesheets for each associated handler. The frame handler is not itself
responsible for what these secondary stylesheets contain, but instead sends a request to the
responsible object handlers to get and set these subsidiary styles. In other words, the
stylesheet ends up with a tree structure that matches the frame and the objects that it contains.
:p.:hp2.Using a default style:ehp2.
:p.If you use the default checkbox to set a default style in the Common Stylesheets dialog, then
all new frames will automatically be created with the selected style. Default styles are particularly
useful if you are using Maul to draw graphic objects and you want all new objects to contain the same
border or background, or whatever.
:p.:hp2.How styles are set:ehp2.
:p.When a style is set, the frame handler feeds the child styles to the appropriate object handlers,
and if the child style includes an actual picture or whatever, that object will immediately become visible.
:p.Even better, there is some intelligence in how child styles are applied. If you save a stylesheet
with a background and border in a lower set of object layers, you will not only be able to set that
stylesheet, but you can also set a different stylesheet over the top.
:p.The rules by which child stylesheets are overlaid are as follows&colon.-
:ul.
:li.Unoccupied object layers are filled with new data by the child stylesheet.
:li.Occupied object layers are changed if the type of the object matches the child stylesheet.
:li.Where there is no match the existing object is left alone.
:eul.
.br
.br
.******************************************************************************
.*
.*
.*  statusbar information
.*
.*
.******************************************************************************
.******************************************************************************
.*  status bar
.******************************************************************************
:h1 res=80 id=80 global.Status Bar information
:i1 id=stats.Status Bar information
:p.The status bar provides information about the current frame or group.
.br
.br
.******************************************************************************
:h2 res=81 id=81 global.Cursor position
:i2 refid=stats.Cursor position
:p.This Status Bar item provides the current mouse cursor position as it would appear on the printed page.
:p.The measurements used to provide this information depend on the current ruler measurement settings.
.br
.br
.******************************************************************************
:h2 res=82 id=82 global.Frame tracking information
:i2 refid=stats.Frame tracking information
:p.This status bar item provides tracking information for the currently selected frame.
:p.The information given depends very much on the frame type, and the handle currently being manipulated. Different
information is provided for scaling, rotation, dragging of individual handles, or dragging of the object centre.
:p.In addition, the status bar item behaves differently according to whether you are creating or updating a line,
a rectangle, a figure, an arc, a piesegment, or a circle. The following modes are used as appropriate&colon.-
:ul.
:li.:hp2.POINT:ehp2. Point (x,y).
:li.:hp2.LINE:ehp2. Origin (x,y), distance, and angle.
:li.:hp2.RECTANGLE:ehp2. Origin (x,y), width, height.
:li.:hp2.CENTRE:ehp2. Point (x,y).
:li.:hp2.MOVE:ehp2. Distance (x,y).
:li.:hp2.ARCPARMS:ehp2. Radius 'A', radius 'B', and angle (the two radiuses form an ellipse).
:li.:hp2.ARCSTART:ehp2. Angle in degrees.
:li.:hp2.ARCSWEEP:ehp2. Sweep in percent (for pie segments).
:li.:hp2.DIAMETER:ehp2. The diameter.
:li.:hp2.ANGLE:ehp2. Angle in degrees.
:li.:hp2.FRAMES:ehp2. Centre (x,y), and radius if known.
:eul.
:p.The measurements used to provide this information depend on the current ruler measurement settings.
.br
.br
.******************************************************************************
.*
.*
.*  other information
.*
.*
.******************************************************************************
.******************************************************************************
:h1 res=60 id=60 global.Importing and exporting frames
:i1.Importing and exporting frames
:p.The frame handler can import and export frames, or groups of frames, in a standard format. Additional export formats
are supported depending on available export handlers. Current formats supported include bitmaps and metafiles.
:p.The bitmap formats are scaled to 75dpi in order to prevent the creation of giant bitmaps that nobody can use. This
format is able to create images for use in screen based applications such as web browsers.
:p.The frame handler makes use of exported data to provide predefined frames or groups. See
':link reftype=hd res=46.Loading predefined frames or groups:elink.' to find out about directly accessing
frames from the 'Frames' menu.
:p.:hp2.Importing:ehp2.
:p.You can import any frame data previously exported by this handler. By default, the filename extension should
be '*.fob' (for FrameOBject...). Use this dialog for importing frames that cannot be directly accessed from the 'Frames'
menu.
:p.The dialog will show a preview line sketch of the frame you are about to import.
:p.:hp2.Exporting:ehp2.
:p.You can export frame data from this publisher for two different porposes. One is a general purpose frame save. The
other is slightly more interesting. If you create catalogue folders in the %installpath%\etc folder, you can create a
library of frames or groups directly accessible via the 'Frames' menu. The only prerequisite is that the catalog folders
have the extension '.cat', ie 'house.cat' or 'stars.cat', and are - as stated above - in Maul's '\etc' subdirectory.
This also means that you should not put catalogues inside each other.
.******************************************************************************
:h1 res=65 id=65 global.Drag and drop for frames or groups
:i1.Drag and drop for frames or groups
:p.This handler allows you to directly create metafiles from the currently selected frames or groups. You can simply drag a
box around the frames to select, or just select one frame if that's what is needed. Once selected, you can drag a metafile
copy to anywhere else on your desktop using the right mouse button.
:p.Where several frames are selected, don't press the right mouse button over a frame, because you will alter the
selection! Anywhere on the screen will do nicely.
:p.Metafiles are in a different format to frames, so in this instance, the drap and drop feature is a one way street. Don't
expect to be able to drag metafiles in as frames. You can, however, use the metafile handler to re-import the metafile in
it's new format.
:p.:hp2.Technical overview:ehp2.
:p.The data is first copied to a temporary file, whch can then be moved or copied to the drag and drop target. The
temporary file will be named after the publication, and will be placed in your temporary directory (in config.sys, you
will usually find an entry such as set tmp=...., or set temp=..., or both).
:p.Suppose you open the publication 'publication.mpb', and your temporary directory is set to 'c&colon.\tmp'. The resultant
file will be 'c&colon.\tmp\publication.met'. If you do this with a new publication, the file will be called something
like 'c&colon.\tmp\tmp.met'. Either way, when you let go of the mouse button, the file is moved to the place that you
dropped the object.
:p.Because temporary files are temporary, the handler will delete '*.met' files out of the temporary directory if they are
inconvenient.
:p.Drag and drop uses metafiles which can subsequently be used by any application which can display them.
.******************************************************************************
.*
.*
.*
.*  Dialog Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  dialogs
.******************************************************************************
:h1 res=61 id=61 global.Selecting polygon points
:i1.Selecting polygon points
:p.You can create polygons of between 3 and 180 corners, after this you have to add lines manually.
Polygons are made up of a series of points, where each point is the end of a straight line.
:p.Use the spin box provided to determine the number of points in the polygon.
:p.Three points produces a triangle, and fifty points almost produce a circle.
:p.:artwork name='polyex.bmp' align=left.
.******************************************************************************
:h1 res=62 id=62 global.Selecting splines
:i1.Selecting splines
:p.You can create splines curves with up to 60 splines, after this you have to add splines manually.
Each spline of the spline curve is controlled by a pair of handles, and two endpoints.
:p.:hp2.A spline curve:ehp2.
:p.:artwork name='splex.bmp' align=left runin.
.******************************************************************************
:h1 res=63 id=63 global.Selecting 3 point arcs
:i1.Selecting 3 point arcs
:p.You can create shapes with up to 90 arcs, after this you have to add arcs manually.
Each arc has a centrally positioned control point to allow you to alter the curve of the arc.
:p.The minimum number of arcs in a closed figure is two.
:p.:hp2.A 3 point arc:ehp2.
:p.:artwork name='3plnex.bmp' align=left runin.
.******************************************************************************
.*  Keys help
.******************************************************************************
:h1 res=64 id=64 global.Help with keyboard keys
:i1 id=keys.Help with keyboard keys
:p.The following keys are available with this handler. The most common keys are listed, but keys specific to other
handlers are not listed. Select a frame and handler you require information on, and then try keys help again.
:p.If no frame is selected, the main keys help for Maul Publisher is shown.
:p.:hp2.General key usage:ehp2.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+J:dd.Insert new first page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
:p.:hp2.Frame handler key usage:ehp2.
:ol.
:li.:hp2.Edit menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+E:dd.Edit frame/group...
:dt.Shift+Delete:dd.Cut frame/group
:dt.Ctrl+Insert:dd.Copy frame/group
:dt.Shift+Insert:dd.Paste frame/group
.br
:dt.Ctrl+Shift+L:dd.Lock frame/group
:dt.Ctrl+Shift+O:dd.Reset object centre
.br
:dt.Ctrl+Shift+F:dd.Move frame to front
:dt.Ctrl+Shift+B:dd.Move frame to back
.br
:dt.Ctrl+Alt+T:dd.Transparent object
:dt.Ctrl+Alt+I:dd.Self clipping object
.br
:dt.Ctrl+Shift+G:dd.Group frames
:dt.Ctrl+Shift+U:dd.Ungroup frames
.br
:dt.Ctrl+Alt+V:dd.Horizontal align frames
:dt.Ctrl+Alt+H:dd.Vertical align frames
.br
:dt.Ctrl+Alt+X:dd.Horizontal centre frame(s)
:dt.Ctrl+Alt+Y:dd.Vertical centre frame(s)
:dt.Ctrl+Shift+X:dd.Horizontal centre group
:dt.Ctrl+Shift+Y:dd.Vertical centre group
.br
:dt.Alt+X:dd.Horizontal equalise frames
:dt.Alt+Y:dd.Vertical equalise frames
.br
:dt.Ctrl+Alt+S:dd.Set frame style...
:dt.Delete:dd.Clear frame/group
:edl.
:li.:hp2.Frames menu:ehp2.
:dl compact tsize=16.
:dt.R:dd.Create rectangle
:dt.U:dd.Create rounded rectangle
:dt.L:dd.Create line
:dt.I:dd.Create spline curves
:dt.N:dd.Create 3 point arc curves
:dt.P:dd.Create poly figure
:dt.S:dd.Create spline figure
:dt.O:dd.Create 3 point arc figure
.br
:dt.Shift+C:dd.Scale frame
:dt.Shift+O:dd.Rotate frame
:dt.Shift+H:dd.Shear frame
:dt.Shift+E:dd.Repeat shape to close
:dt.Shift+J:dd.Join ends to close
:dt.Shift+B:dd.Open (break) figure
.br
:dt.Shift+L:dd.Add line
:dt.Shift+I:dd.Add spline curve
:dt.Shift+N:dd.Add 3 point arc
:dt.D:dd.Remove figure elements
.br
:dt.F:dd.Convert rectangle or polygon to a figure
:dt.W:dd.Swap contents and background
.br
:dt.Y:dd.Save frame style
:edl.
:eol.
.******************************************************************************
.*  Options help
.******************************************************************************
:h1 res=70 id=70 global.Paint enabling options
:i1 id=paintena.Paint enabling options
:p.The frame handler provides the option to enable or disable the painting of certain
elements of your publication.
:p.:hp2.Display preview mode:ehp2.
:p.Diplay preview mode disables the painting of screen artefacts such as the marking grid and
the frame outlines. The view thus obtained is very close to the way the page will look when
printed.
:p.:hp2.Paint enables dialog:ehp2.
:p.The Paint enables dialog is used to temporarily turn off object handlers by usage or
by type.
:p. The dialog shows two separate lists. One lists all the possible usages for a frame. The
other lists the names of all the object handlers (handlers that paint things).
:p.Any item that is highlighted, is enabled. If you disable all borders, every handler attached
to a border will be disabled. If you disable just one handler, then all painting operations
by that handler are disabled. Note that some handlers can act either as borders or as backgrounds.
:p.The two lists act independently, and there is no interrelation between them.
:p.The enables only affect the screen view, they do not affect the printout.
:euserdoc.
