.******************************************************************************
.*  Maul Publisher Main Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Publisher Help
:docprof toc=1234.
:h1 res=1 id=intro.About Maul Publisher
:i1 id=intro.About Maul Publisher
:artwork name='maul.bmp' align=center.
:p.:hp2.Welcome to Maul Publisher.:ehp2. The worlds only high precision, professional desktop publisher
for **OS/2 Warp.
:p.Maul Publisher is quite simply one of the most powerful DTP applications
available today. Combine text, images, and vector graphics to quickly create
pleasing and sophisticated documents. Ease the workflow by using master pages
and style sheets for consistent quality. Directly create colour separations to
ensure perfect results.
:p.:artwork name='picset.bmp' align=center.
:p.Features overview&colon.-
:ul.
:li.Page management providing automated page numbering, even for folded sheet
booklets, managed double sided printing on single sided printers, imposition,
gutter and gutter centre management, page to printsheet recentering, user
defined page forms to create publications at any scale, automatic reversing
grids and margins between pages, grids defined on a per page basis if
required, user defined alignment markers, snap to selected markers and grids,
automated page folding margin compensation. Multiple master pages, and
automatic frame chaining between master pages.
:li.Viewport management provides views of facing pages, of print pages, of
pages within print  pages, of pages scaled to fill the screen, of printer
scale. Zoom from 16x to 0.13x in 15   steps.
:li.Colour management with direct colour separation from rgb images and
metafiles, loadable and saveable plain text colour tables, named colours, spot
colours, colour shading with brightness compensation and colour transition
management, and overall tonal compensation.
:li.Powerful frame creation facilitites include grouping mechanisms and
metafile export to create company logos and clipart. Complex objects can be
autoscaled, rotated, and mirrored, making the product suitable for drawing
diagrams.
:li.The full powered freeform text formatter enables text to be placed in any
shape of frame, at any angle, and can flow around any shape of overlapping
frame too! Text can be placed along any shape of line, curve, or border, and
will directly cut and paste from the inside of frames to a frame border, without
loosing any of the text styles and sizes. You can place drop capitals at the
start of any paragraph, and this still works even if the frame is not
rectangular. Add inlined images to text, and as the text is altered the inline
image remains in the right place. Images and metafiles are subject to the same
freeform rules and can be placed in any shape of frame at any angle.
:li.Use mail merge facilities to personalise complex publications.
:li.Commercial quality hyphenation and spellchecking tools combine with
features such as user dictionaries and speculative hyphenation to create
perfectly formed text areas.
:li.Full undo and redo for every alteration made. Paint enables allow parts of
the publication to be temporarily turned off to ease the redraw overhead in
complex publications. Keyboard shortcuts are editable for maximum user
comfort. Global style settings allow customisation of button styles, startup
views, and tracking handle sizes. Integrated stylesheet management allows
stylesheets to be created for text, text titles, backgrounds, bitmaps,
borders, metafiles, and frames.
:li.Computer assisted contents and index extraction provide a fast way to
complete one of the most time consuming aspects of desktop publishing.
:li.Maul is completely modular, with a publicly available user interface. This
enables anyone to add functionality to Maul Publisher if they desire.
:eul.
:p.:artwork name='picset2.bmp' align=center.
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
:artwork name='nmehouse.bmp' align=left.
:p.:hp2.About La Maison des Anglais:ehp2.
:p.The drawing above is of a 17th century cottage beside a mediaeval road which was originally
built as a shop to sell linen, and perhaps other goods. This style of cottage is called a
'maison anglaise'.
:p.Built by the Bretons in what was then thought to be an English style, only a very small
handful of these houses have survived to the present day. Many are now in a state of extreme
neglect.
:p.The cottage is home to 'Maison Anglais', and the products originating from this company
have all been created by Peter Koller, a dedicated Hardware and Software engineer of more
than 25 years experience in the design of computers, their software, and their interface to
the real world.
:p.The company, Maison Anglais, is an enterprise registered in the UK in August 2001. The
company was set up to promote Maul Publisher, which was first created in 1998. The name Maison
Anglais was used in various spellings to promote software products since 1995.
.br
.br
:p.:link reftype=hd res=2.Copyright and Licence Agreement:elink..
.br
.br
.******************************************************************************
.*  Getting started
.******************************************************************************
:h1 res=17 id=quickinfo.Getting Started
:i1 id=quickinfo.Getting Started
:p.:hp2.Maul is a frame based publisher:ehp2.
:p.Maul is a frame based publisher and before you can put anything onto a page you must have a frame to put
it in. You will notice that as you move your cursor over the tool bar, the status display at the bottom left
tells you what the button does. You may need to click on the 'Select frame mode' button to continue (Maul will
always start with this button selected).
:p.This short guide is intended to help you get started. Once you are familiar with the basics, you should take the
time to learn the more complex things this product can do for you.
:p.:hp2.Publication hierarchy:ehp2.
:p.Printer pages contain pages and frames, frames contain objects, and objects paint the pictures and text...
:artwork name='hierarch.bmp' align=left.
:p.Printer pages are selected by the next and previous page buttons. All publications have at least one printer page
and open with the first printer page. Printer pages contain pages with margins and grids.
:p.Frames are managed by the frame handler. Frames are selected by clicking on them with the left mouse button. Frames
can contain up to 8 layers of objects. There are four layers for contents and four layers for border available to each
frame. Some frames, such as a line, have no contents layers available.
:p.Objects are managed by object handlers. Objects are text, or images, etc. Objects are selected by choosing an object
button, or by selecting the correct object layer in the 'View' menu. Only objects are visible on the final printout.
:p.:hp2.Help:ehp2.
:p.You will notice that there is a small message box in the lower left corner of the application window. This is the help
message box, and it is used instead of popup tooltips in order to keep the page uncluttered. Whenever you move the mouse
over a button or control in the main window, you will find a corresponding help message here.
:p.:hp2.Create a frame:ehp2.
:p.Find a button that allows you to create a frame. Try the 'Create new rectangle' button to start with. You will
notice that the cursor changes shape to a cross hair. Position your cursor at the start of your new rectangle and
holding down the left button, drag out a suitably sized rectangle.
:artwork name='crefram.bmp' align=left.
:p.:hp2.Add a text handler:ehp2.
:p.Having a frame, you can now add object handlers to that frame. Click on the 'Add frame contents layer 0' button to add
a foreground to the frame. If you click the button again, it will say 'Add frame contents layer 1'. You can add up to four
contents layers to a frame. Click on the button until you get back to layer 0. Alternatively, you can click on the little
dropdown button beside it, and choose the layer directly from the dropdown menu.
:p.Once you are back on layer 0, click on the 'Add Plain text' button, and watch how the text object handler takes over
the tool bar. At this point you are ready to type in some text, but first we are going to add a border to the frame.
:artwork name='seltxt.bmp' align=left.
:p.:hp2.Add a border:ehp2.
:p.Next to the contents layer buttons, you will find the border layer buttons. These work in exactly the same way, so
click on the 'Add frame border layer 0' button, and then click on the 'Add Plain border' button. Just like the text
handler before, the border object handler now takes over the tool bar.
:p.When you first add a plain border to a frame, you are presented with a border width dialog. If you want to see a
border, you need to set this to a value other than zero. In the border width dialog, you can enter values in mm,
inches, points, or pixels.
:p.Place the value 20 in the select border window after deleting the mm text at the end.
This will create a border of 20 pixels in width.
:artwork name='sbordwid.bmp' align=left.
:p.:hp2.Selecting handlers:ehp2.
:p.Once you have added an object to a frame, the help message will reflect the name of that object. If you have deselected
all frames by clicking on the blank page, the help string suggests you 'Click on a Frame!'. Once you have selected a frame,
the buttons will show a layer and the name of that object, i.e. 'Layer 0&colon.- Plain text'.
:artwork name='newtext.bmp' align=left.
:p.
:p.If you click back on the 'Edit frame contents' button, the text object handler reappears. Remember that if you have
deselected the frame by clicking on the blank page, no handler appears, but the help string now suggests you
'Click on a Frame!'. You will notice that each handler paints it's own picture on the correct selection button. Select the
text handler to start typing.
:p.:hp2.Getting help on a handler:ehp2.
:p.By clicking on  the 'List handlers...' option in the help menu, a list of currently installed handlers is displayed.
Select the handler you want help on and click on the help button. The main help page for that handler is displayed.
You can see the contents of the help pages by clicking on the 'Options' menu item in the HELP window and then
clicking on 'Contents'.
:artwork name='handlist.bmp' align=left.
:p.:hp2.Further reading:ehp2.
:p.You will find more helpful information in the following sections&colon.-
:ul.
:li.:link reftype=hd res=72.Adding an object to a frame:elink., for a more detailed description of how
to add text or images to frames.
:li.:link reftype=hd res=18.Hints and Tips:elink., for some interesting ideas about extracting the most
from this program, and how to prepare your publication for final output.
:li.:link reftype=hd res=16.Known problems and bugs:elink., for detailed information about the kinds of
problems that can occur, and what to do about them.
:li.Look in the :link reftype=hd res=113.'Help -> How Do I':elink. submenu for further help topics.
:li.For any particular handler, look in the individual handler manual for further information about using that handler.
:li.Some online information is also available. Go to
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/maults.html'.http&colon.//www.manglais.com/subs/maults.html:elink.., and have
a look at the FAQ page, this page will also list any new bugs found by customers during the life of this program.
:eul.
.br
.br
.******************************************************************************
.*  Copyright
.******************************************************************************
:h1 res=2 id=cright.Copyright and Licence Agreement
:i1 id=cright.Copyright and Licence Agreement
:p.:hp2.This product is the copyright of:ehp2.
:sl compact.
:li.Peter Koller,
:li.Maison Anglais,
:li.Trebuon,
:li.29530, Plonevez du Faou,
:li.FRANCE.
:esl.
:p.:hp2. 1998 to 2006 Peter Koller, Maison Anglais. All Rights Reserved.:ehp2.
:note.This copyright includes the whole product, including any file format(s), any installation utility, and all
documentation provided with this product. Where third party copyrights apply, these are specifically noted in the relevant
manuals. In this case the third party copyrights may take precedence over parts of this product.
.br
.br
:p.:hp2.Licence Agreement:ehp2.
:p.The Author, Peter Koller, Maison Anglais, retains the ownership of this product. You are
however licenced to use it if you accept the following Licence Agreement.
:ol.
:li.This licence covers the whole product, including any applications, modules, data,
file format(s), any installation utility, and all documentation provided with this product.
:li.You may evaluate a single unregistered copy of this product for a period not exceeding
thirty days. The unregistered product will time out and cease to function after this period.
:li.This product :hp2.requires registration:ehp2.. You Must be registered if you continue to
use this product after you have evaluated it.
:li.If you have a Customer Registration Code (CRN), you must not disclose it to anyone. The
registration code contains your personal details and you are responsible for keeping it
private.
:li.You may use this product only on a single machine at any one time. If you have
purchased a multiple copy, you may use an according number of copies simultaneously.
:li.You may copy this product into machine readable or printed form for backup or data
compression purposes only.
:li.You may not reverse engineer or disassemble any part of this product.
:li.You may give an unregistered copy of this product to others. You may also charge the end
user reasonable costs incurred by your distribution of this product. You may not charge for
the product itself without a separate and explicit agreement.
.br
:note.Please ensure you distribute the :hp2.entire:ehp2. package as provided
(this is usually a zip file with a name and a version number). The package may
also be available in a split archive to cover additional languages, or
to ease download restrictions.
:li.You may create and separately publish modules, applications, and data for this product,
providing that you do not infringe other parts of this licence, or any associated
copyright(s). This licence only affects the :hp2.creation:ehp2. of applications and data, but
such modules, applications, and data, are not themselves covered by this licence and no
liability will be accepted for their correct function or content.
:li.If you install additional modules created by the author, this licence will also apply to
these modules.
:eol.
:p.:hp2.Extent of Liability:ehp2.
:ul.
:li.The Author accepts no liability for fitness of purpose, or damages caused whether
incidental, or consequential, by the use of this product, howsoever caused. This
product is licenced on a "try before you buy" basis only. In those countries where this
statement conflicts with your statutory rights your statutory rights shall remain unaffected.
:li.The Author accepts no responsibility or liability for documents or information created
using this product.
:li.The Author accepts no responsibility or liability for modules, applications, or data
created for use by this product, other than modules, applications, or data that
are provided by the author himself.
:eul.
:p.:hp2.Support:ehp2.
:ul.
:li.The Author currently offers ad-hoc technical support via the internet. At the time
of writing this support is via
http&colon.//tech.groups.yahoo.com/group/maulpub/
:li.The author reserves the right to refuse technical support at any time and without giving a reason.
:eul.
:p.---- End of Licence Agreement ----
.br
.br
.******************************************************************************
.*  Developer Information
.******************************************************************************
:h1 res=19 id=19 global.Developer information
:i1 id=develop.Developer information
:p.:hp2.Maul Publisher:ehp2. was designed from the ground up to be a modular, open standard.
:p.What this means for developers is that if you wish to :hp2.create and sell:ehp2. handlers for Maul, you are more than
welcome to do so.
:p.As the program grows in stature, so the need for others to develop for it increases, as do the profits obtained.
:p.OS/2 Warp needs the tools necessary to create printed information. By creating a handler for Maul, you gain an
advantage because your output can be integrated with all the other forms of output, combining text with graphics in a
single common user interface, and on a single printed page.
:p.Maul's own API takes a lot of the sting out of developing a new application. If you take the example of a vector
graphics program, you are more than halfway there. The API provides all the necessary tools for style sheets, clipart,
text creation, page scaling, bitmaps, and printing. If you already have a separate program, you can add substantial
value to your product by giving the user the necessary tools to incorporate your program's output into Maul. Be it
a spreadsheet or database, graphics program or word processor, all can benefit greatly from cooperation with Maul
Publisher. Maul Publisher currently represents the ultimate page layout tool available for OS/2 Warp, and in due course
will become available for use with other operating platforms.
:p.To obtain all the necessary information to develop your own handler, point your web browser at
.br
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/signup.html'.
http&colon.//www.manglais.com/subs/signup.html:elink..
.br
Developers need to leave their name and email address in order to be kept up to date. This information is kept
confidential, and will not be divulged to a third party.
.br
.br
.******************************************************************************
.*  Command line options
.******************************************************************************
:h1 res=4 id=4 global.Command Line Options
:i1 id=cmmd.Command Line Options
:p.The following options are available on the command line, or in the 'Optional Parameters'
 of the 'Maul Publisher' object properties.
:dl tsize=30.
:dt./d:dd.Start the publisher in a default sized window. The default is to maximize the window.
:dt./h<path>:dd.Defines the path used for loading a handler control list. This option is reserved
and should not be used.
:dt./ignas:dd.Used to disable the separate processing of Alt+Shift shortcut key combinations. This option is reserved
and should not be used.
:dt./nopdc:dd.Prevents the program from opening a printer device context on startup. This option may be required on
some systems. See 'Network printing' in :link reftype=hd res=16.Known problems and bugs:elink.
:edl.
:p.There are currently no other command line options available, apart from the filename
of the file you wish to edit.
.br
.br
.******************************************************************************
.*  Known problems and bugs
.******************************************************************************
:h1 res=16 id=16 global.Known problems and bugs
:i1 id=problem.Known problems and bugs
:p.:hp2.Speed and the recommended setup:ehp2.
:p.Maul makes heavy use of floating point maths. For this reason, the minimum recommended spec for an easy
life is a Pentium type processor or better. Don't however rely on this alone. Maul needs a good quality
Graphics card and printer. For graphics I can strongly recommend the Matrox cards. Maul was developed using
a MilleniumII. For printing, a modern inkjet seems to produce reasonable results, but for really professional results
you should try and use a print shop. You can use a postscript printer driver to print to a file, a way
in which a postscript output can be obtained. There is an ideal opportunity here for someone to have a go at creating
an eps import/export handler!
:p.As for memory, Maul seems to run fine with 32Mb, I have not tried it with less. If you like your eyes, get the
biggest and best monitor you can afford. Maul should be used with at least 1024 x 768 resolution, if you use it with
a lower resolution, you may loose sight of some status information.
:p.:hp2.Multimedia:ehp2.
:p.The PhotoCd import handler uses multimedia codecs to import the PhotoCd bitmap format. This program will not run
unless multimedia is installed. You can install multimedia even if you have no sound card, and no other use for it.
:p.If you insist on running without multimedia, you can get the program to start by removing the PhotoCd import
handler. To do this go to the directory where the program was installed and run 'REM_PCD.cmd'.
:p.You can do this manually by going to the \bin directory, where the program was installed. Then open
'MAUL_DLL.LST' using the system editor E, and delete the line containing the entry pcdhand.dll. After this, the program
will run, but you will not be able to see or use PhotoCd images.
:p.:hp2.Fonts:ehp2.
:p.Maul performs a lot of font manipulation. This can cause problems with certain font drivers. You may find the
latest version of the freetype (http&colon.//www.freetype.org) font driver worth looking at. If you get any font
problems, please do not hesitate to report them (see end of this section).
:p.Another problem appears to be the fonts themselves. Not all fonts are equally good at handling manipulations such
as stretching or shearing. In particular, the Windows 3.1 'Wingdings' font may not print correctly when upside down.
:p.The fonts that appear to work best are the Adobe Type 1 fonts. At the time of writing, a number of these fonts
are available on the Hobbes OS/2 CD. :hp4.ftp&colon.//ftp.cdrom.com/os2/fonts/:ehp4.
:p.:hp2.Justification:ehp2.
:p.Are you using a Times Roman font (especially 8pt or smaller)? If you find that the screen is correctly
justified, but printouts are not, try changing to another font. It appears there is a bug in the font selection
mechanism. In spite of providing full and detailed font metrics to the font selection mechanism, the mechanism
can be fooled by having a screen font and printer font which are different, but have the same name. This has
caused problems with the Times Roman MT30 font provided with Java and Netscape. The outline font found for
printing was not always the same as the outline font found for the screen.
:p.:hp2.Network printing:ehp2.
:p.This is not really a bug in Maul, but it's so nasty, that it's worth noting. If you install an updated printer
driver on your client (in my case the OMNI driver), but not on your server, the system appears to work, but Maul fails
to start. In fact anything that messes up the list of print queues can cause this. Many other programs will also have
printing problems in these circumstances.
:p.The only way I know to fix this is to switch all the printer icons to IBMNULL on both clients and server and then
reboot the whole network, and delete the printer drivers involved. Reboot. Reinstall the :hp2.same:ehp2. drivers on all
machines. Reboot. Then re-install the print server icon into the Printers folder by dragging a shadow from the network
resource browser. It appears that you have to reboot the whole network 3 times in all, and I found it a very frustrating
process. If you know a quicker way of solving this problem, please report it.
:p.If you are not on a network, please follow the same procedure, but ignore the parts that talk about the server.
:p.The reason Maul fails? Because Maul opens a print context, and after having done so, it can no longer find it's
runtime library (failure in LoadHandlerList)...
:p.:hp2.Positioning:ehp2.
:p.If you create a layout for one kind of printer, and then print on another, you will probably get some
variation in positioning. Maul will rescale pages to a certain extent, but will not alter the aspect ratio of the
printed area.
:p.:hp2.Error Log:ehp2.
:p.Maul maintains an error log in the path where Maul is installed. Unless you chose a different path during
install, this would be 'c&colon.\maul\error.log'
:p.:hp2.File Integrity Checker:ehp2.
:p.Maul Publisher will perform a regular test of file integrity during use. If an error is reported, you may have
the chance to save the file to a new name. If the new file reloads without reporting errors, you have managed to
recover your work. Another trick is to try an undo. This could well result in the file integrity being restored.
:p.:hp2.Crash Dumping:ehp2.
:p.If you perform an operation and Maul crashes due to a memory access violation, Maul will perform a file integrity
check.
:p.If no file errors were found during this check, a file called 'dump.mpb' is created, in the path where Maul is
installed. Unless you chose a different path during install, this would be 'c&colon.\maul\dump.mpb'. This file
should contain a fixed copy of your publication as it was during the crash, unless page, frame, or object
errors are reported in 'error.log', because these indicate that the file was corrupted beyond repair. When you want to
reload the file using the 'Open' dialog, set the file type to '<All Files>' otherwise the file will not be visible.
:p.After the file integrity check has completed, Maul will attempt to crash gracefully. After all the dll's are unhitched,
and memory is released, the exception is passed on to the default exception handler. This OS/2 system handler will give
the usual sys3175 message, and perform a machine state dump to a file in the boot drive root directory called
'popuplog.os2'. The information in this file, as well as 'error.log', will be required if you ask for technical support.
:p.The machine state dump information is extremely important, as it can be compared to a linkage map, showing the
approximate area where the error occurred.
:p.:hp2.Reporting bugs:ehp2.
:p.A list of known bugs, and their possible workarounds, are currently available at
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/maults.html'.
http&colon.//www.manglais.com/subs/maults.html:elink.. If your bug is not on the list (or even if it is!), please
send an email to :link reftype='launch' object='netscape.exe' data='mailto:Maul Support <maulpub@gmail.com>'.Maul Support <maulpub@gmail.com>:elink.. In particular, your
report should contain the following information, where applicable, and if possible.
:dl tsize=30.
:dt.All errors
:dd.
:ul compact.
:li.The exact version of Maul that you are having problems with.
:li.The version of the OS/2 system you are using.
:li.You screen resolution, ie 800x600 for example, and what graphics card you are using.
:li.The printer and driver that you are using. For the driver version number, go to the printer object and open the
properties page; go to the printer driver tab and open the properties of the relevant printer driver icon. The same
information is available whenever you change printer settings, the version number is often incorporated in the
settings title bar.
:eul.
:dt.File corruption
:dd.
:ul compact.
:li.All of the above.
:li.If the error was reported during file integrity checking, the relevant entry in 'error.log'.
Unless you chose a different path during install, this would in be 'c&colon.\maul\error.log'.
:eul.
:dt.Crashes
:dd.
:ul compact.
:li.All of the above.
:li.The relevant machine state dump entry in 'popuplog.os2'. Unless your boot drive is not 'C&colon.', this would in
be 'c&colon.\popuplog.os2'
:eul.
:edl.
.br
.br
.******************************************************************************
.*  Hints and Tips
.******************************************************************************
:h1 res=18 id=18 global.Hints and Tips
:i1 id=hats.Hints and Tips
:p.:hp2.Running several Maul sessions:ehp2.
:p.You can run several Maul sessions. To open a publication in a new session, use the open dialog and check the
'Open new session' checkbutton. You can switch between sessions using the :link reftype=hd res=100.switch list:elink..
:p.:hp2.Permanently changing measurements:ehp2.
:p.You can change the default measurements for a particular publication by changing the measurement type in the
'Margins and Grids...' dialog, found in the 'Page' menu. The change is saved when you save the publication.
:p.To change the default for all new publications, save the current printer setup' by using the 'Save printer setup'
option in the 'Options' menu. The command saves everything it knows about your printer and page settings, including
the printer's current job properties.
:p.:hp2.Right click:ehp2.
:p.Right click on a frame to get the current edit menu. This is also another way of adding an object handler to a frame.
:p.Select one of the edit mode buttons, and right click on the empty frame.
:artwork name='rclick.bmp' align=left.
:p.:hp2.Images or colours inside text:ehp2.
:p.First create a frame with text in the foreground. Select the Text handler as a foreground handler, and type in your
text. When you are happy with the text, add an image or colour to the frame background. Then switch back
to the frame handler. Select the 'Self Clipping object' mode in the 'Edit' menu.
:artwork name='wow.bmp' align=left.
:p.:hp2.Dragging out frame shapes:ehp2.
:p.Most frame creation operations are affected by holding down the shift key on the keyboard. Usually, the effect is to
make the frame orthogonal in some way. Read more about this in the frame handler manual.
:p.:hp2.Editing backgrounds:ehp2.
:p.Ok, lets put it this way! In the above example, the image in the background fills the text in the foreground.
:p.If the image is deleted, the text disappears. It's still there, but you cannot see it!
:p.But, if you select the text handler and place the cursor on the text, it re-appears. The system has temporarily
turned off self clipping.
:p.So, if you edit text with an image inside it, the image disappears, and the text is shown as black. This is done
simply to help you edit quickly, and to avoid the impossible task of editing invisible text. Printing is not affected by
this.
:p.:hp2.Layout grids:ehp2.
:p.Make use of page layout grids. They are the best way of positioning objects accurately. Try to determine what kind of
layout you require, and whether you wish to have gutters (an empty gap) between columns. It is usually a good idea to
select a layout grid with at least twice as many columns as you require. You can alter the layout grid on a page by page
basis. You do not need to have the same grid on every page. The default settings allow you to snap to any part of the
layout grid...
:artwork name='layout.bmp' align=left.
:p.:hp2.Creating an index:ehp2.
:p.You can create an index for your publication by importing an index creation file into an empty text frame. To find
out more about index creation files, see the 'Index Creation' manual.
:p.:hp2.Text frames with borders:ehp2.
:p.First create your frame. Then type in, or paste in, the required text.
:p.If you now add a border to the text, you will generally notice that the text and border are touching each other. This
is because the left and right text margins are probably set to zero.
:p.Switch to the text handler, select all the text from the 'Edit' menu, and change the left and right margins to a
pleasing distance, such as 2mm, using the 'paragraph' dialog. You do not need to dismiss this dialog until you are
satisfied with the results. Almost all of these dialogs are now threaded, and you will be able to make changes to the
text with dialogs present.
:p.If other frames intrude into the text frame, the text will flow around the intruding frame. To space the text away
from such intruding frames, set the boundary whitespace for the text to the same value as the margins, i.e. 2mm.
:p.Notice that although these settings appear to have a similar effect, they are in fact unrelated, and use a different
mechanism. Margins move the text along a known path, and boundary whitespaces affect the path itself. Margins are
calculated by the text handler, and boundaries are calculated by the main program.
:p.You can save all of these settings, both as a system wide default, or as a style sheet.
:p.:hp2.Clipart and automatic scaling of text:ehp2.
:p.Maul's new frame handler can produce frames that act as a sort of clipart, and although this is not intended to be
the last word on clipart, it does provide a complementary service. If this frame based clipart contains text or borders,
you may wish to scale them automatically whenever you scale the clipart. The frame handler achieves this by sending a
scaling message to all the other handlers involved.
:p.First of all, this only works for groups of frames, and a group must have at least two frames, even if one of the
frames is invisible. The first step then, is to create a group.
:p.Once a group has been created, you can change the mode of that group to 'Auto scaling group' in the frame handler
'Edit' menu. Now, whenever you scale the group, any text or borders are also scaled by the required amount.
:p.Having created you clipart, you should export it to a catalog. These catalogs are held in the .\etc path where Maul
was installed. To create a new catalog, create a new folder, and call it something.cat. As long as the folder has a
'.cat' at the end of it's name, it will be treated as a clipart catalog. Use the 'export->frame objects' menu item in
the 'File' menu to export your new clipart to it's new catalog. An example catalog of frame clipart is provided.
:p.:hp2.Network printing:ehp2.
:p.Maul has been tested using a Warp 5 Server and Warp 4 Client. You must ensure that the same fonts are installed in
both the server and the client, or the printout may be incorrect.
:p.In this version of Maul, you can choose to send a raw print file across the network. In this case, no particular
fonts need to be installed on the print server. Note, however, that this slows down printing considerably.
:p.:hp2.Final Output:ehp2.
:p.If you need to take your publication to a print shop, you will need to create a series of postscript 'rips'. A good
way of doing this is to have a postscript printer installed, and setting the printer driver to print to a file.
:p.The generated file should be readable by the bureau, though you may need to print each page into a separate file.
:p.Similarly, you can create 4 separate colour 'rips' by the same method.
:p.You will need to check a few items to avoid any expensive mistakes. The list below should help to suggest things
to look for.
:ul.
:li.Make sure there are no thin lines and small fonts (<10pt) in CMYK process colours. As these colours are screened
in order to produce the tints, you may end up with an unreadable mess.
:li.If you are creating folded and stapled spreads, make sure that the pages are in the correct order. If you use Maul's
folding booklet mode, this is (semi) automatic. Be aware that the pages may be correctly numbered, but you may have put
the wrong text or pictures on them!
:li.Make sure that your print shop can support the requested fonts, and beware of font distortions, as these may not
appear as you expected.
:li.Make sure that bitmaps have sufficient resolution to print clearly. Note that fine lines or artefacts in bitmaps
will also suffer distortions due to colour screening.
:li.Run a test print on your own printer, and get someone else to look at it, fresh eyes can often spot mistakes you
have missed.
:li.If you have automatic date fields in your text, they will force a re-format of the text. If your publication was
created in July, and you print it in September, all the text will move to accomodate the longer date string.
:li.It pays to develop a good relationship with a print shop, their knowledge can help you avoid an expensive mistake.
:li.This list is not exhaustive, so if you have experience using Maul in this capacity, please share your experiences
with others by writing to :link reftype='launch' object='netscape.exe' data='mailto:Maul Support <maulpub@gmail.com>'.Maul Support <maulpub@gmail.com>:elink.. You will help others avoid pitfalls.
:eul.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Window Layout Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Tool bar buttons
.******************************************************************************
:h1 res=800 id=800 global.The tool bar
:i1 id=buttonbar.The tool bar
:p.The button bar is the first place to look for a given function. You can temporarily close the button bar by
clicking on the :artwork name='toolsup.bmp' runin. button in the top right hand corner of the menubar.
:p.Apart from selecting the current :link reftype=hd res=801.ruler scales:elink., the button bar provides
buttons to repeat operations in the :link reftype=hd res=40.Page Menu:elink., and buttons to select the
current edit mode. It will also contain buttons and other items belonging to the selected handler.
:p.The edit mode is controlled by three buttons&colon.-
:ul.
:li.:artwork name='frame.bmp' runin. to select :link reftype=hd res=804.frame:elink. edit mode.
:li.:artwork name='cont.bmp' runin. to select :link reftype=hd res=805.contents:elink. edit modes.
The small button provides a dropdown layer selection menu.
:li.:artwork name='bord.bmp' runin. to select :link reftype=hd res=807.border:elink. edit modes.
The small button provides a dropdown layer selection menu.
:eul.
:p.In effect, each frame can have an object handler attached to a contents layer, or a border layer.
There are four contents layers, and four border layers available. Some frames, such as a line, cannot use contents
layers.
:p.See also :link reftype=hd res=72.Adding an object to a frame:elink.
.******************************************************************************
:h2 res=801 id=801 global.Selecting ruler scales
:i2 refid=buttonbar.Selecting ruler scales
:p.Click on the rule mode button :artwork name='ruler.bmp' runin. to change the scale used
both for rulers, and for some dialogs.
:p.The three modes available include metric 'm, cm, mm', British inches 'in', and points 'pt'. These
basic units of measurement are then scaled to a multiplication factor suitable for the current page scale.
:p.Associated with the ruler bars is a small text frame that tells you what scaling factor is in effect. Thus
if the ruler bars are set to inches, you might see 'in' on the ruler bars, and 'x0.1' in the text frame. This
means that each major divison is 1/10th of an inch.
:artwork name='ruler2.bmp' align=left.
.******************************************************************************
:h2 res=50 id=50 global.Forcing a manual repaint
:i2 refid=buttonbar.Forcing a manual repaint
:p.Sometimes, you may find that the screen requires repainting in order to clean up the display.
:p.You can repaint the publication on the screen at any time by invalidating the whole screen.
The :artwork name='paint.bmp' runin. button will repaint the screen.
:p.Repainting will not rejustify text, nor alter the publication file data in any way.
.******************************************************************************
:h2 res=804 id=804 global.Switch to frame edit mode
:i2 refid=buttonbar.Switch to frame edit mode
:p.Click on the frame edit mode button :artwork name='frame.bmp' runin. to select frame edit mode.
This mode is the default when Maul is started.
.******************************************************************************
:h2 res=805 id=805 global.Editing frame contents
:i2 refid=buttonbar.Editing frame contents
:font facename='System Monospaced' size=20x9.
:p.:hp2.Each closed frame is capable of painting four contents layers of objects. Use the contents selection
buttons to add or edit contents objects.:ehp2.
:font facename=Helv size=0x0.
:p.:hp2.Definitions:ehp2.
:p.A closed frame. This is a frame with an inside, such as a rectangle. Compare this to an open frame
such as a line. Frames are managed by the frame handler.
:p.An object. This is something that gets printed. It can be text, or an image, or a plain colour, for
example. Objects are managed by object handlers.
:p.Contents. Any object that gets painted inside a frame. Use the 'List handlers...' item in the 'Help'
menu to see all the available contents object handlers.
:p.Layers. Objects can be placed in any one of four layers. Each layer is painted in turn, with layer
0 on top, and layer 3 on the bottom. The frame handler is responsible for controlling the order in which
layers are painted.
:p.:hp2.The contents selection buttons:ehp2.
:p.The control of contents is managed by these :artwork name='cont.bmp' runin. two buttons on the toolbar. The
larger of the two buttons is used to quickly select the contents layers. The smaller is used to provide
a drop down button menu to quickly select a different layer.
:p.Each time you click on the large button, you go to the next layer. This is one way of stepping to the
required layer. The buttons on the dropdown menu provide another way of switching to the required object or layer.
:p. The image on the buttons changes to reflect the currently attached object handlers. The help status message
changes to reflect what the buttons currently represent.
:p.If no frame is selected, the buttons will all show a default icon with a '?' symbol. Once a frame is selected,
clicking on a button with the '?' symbol will give a series of object types that can be added to that layer.
:p.Layers are moved by the frame handler, and removed by the requisite object handler.
:p.The moment an object is added or selected, the whole application will switch to shown the menus and buttons
available for that object.
:p.:hp2.See also:ehp2.
:p.:link reftype=hd res=17.Getting Started:elink..
:p.:link reftype=hd res=72.Adding an object to a frame:elink..
.******************************************************************************
:h2 res=807 id=807 global.Editing frame borders
:i2 refid=buttonbar.Editing frame borders
:font facename='System Monospaced' size=20x9.
:p.:hp2.Each frame is capable of painting four border layers of objects. Use the border selection
buttons to add or edit border objects.:ehp2.
:font facename=Helv size=0x0.
:p.:hp2.Definitions:ehp2.
:p.A frame. All frames have the capability of supporting border objects. Some frame types, such as a line,
only support border objects. Frames are managed by the frame handler.
:p.An object. This is something that gets printed. It can be text, or an image, or a plain colour, for
example. Objects are managed by object handlers.
:p.Borders. Any object that gets painted along the edge of a frame. Use the 'List handlers...' item in the 'Help'
menu to see all the available border object handlers.
:p.Layers. Objects can be placed in any one of four layers. Each layer is painted in turn, with layer
0 on top, and layer 3 on the bottom. The frame handler is responsible for controlling the order in which
layers are painted.
:p.:hp2.The border selection buttons:ehp2.
:p.The control of borders is managed by these :artwork name='bord.bmp' runin. two buttons on the toolbar. The
larger of the two buttons is used to quickly select the border layers. The smaller is used to provide
a drop down button menu to quickly select a different layer.
:p.Each time you click on the large button, you go to the next layer. This is one way of stepping to the
required layer. The buttons on the dropdown menu provide another way of switching to the required object or layer.
:p. The image on the buttons changes to reflect the currently attached object handlers. The help status message
changes to reflect what the buttons currently represent.
:p.If no frame is selected, the buttons will all show a default icon with a '?' symbol. Once a frame is selected,
clicking on a button with the '?' symbol will give a series of object types that can be added to that layer.
:p.Layers are moved by the frame handler, and removed by the requisite object handler.
:p.The moment an object is added or selected, the whole application will switch to shown the menus and buttons
available for that object.
:p.:hp2.See also:ehp2.
:p.:link reftype=hd res=17.Getting Started:elink..
:p.:link reftype=hd res=72.Adding an object to a frame:elink..
.******************************************************************************
:h1 res=803 id=803 global.The ruler bars
:i1 id=rule.The ruler bars
:p.The ruler bars allow you to instantly see the exact position of the cursor within the page.
:p.If you switch to a view other than the printer page view, the rulers will be zeroed on the currently
selected page frame. Otherwise, the rulers are zeroed on the top and left hand edge of the printer page.
:p.As you zoom in and out of the page, so the rulers will change scale to match.
:p.Associated with the ruler bars is a small text frame that tells you what scaling factor is in effect. Thus
if the ruler bars are set to inches, you might see 'in' on the ruler bars, and 'x0.1' in the text frame. This
means that each major divison is 1/10th of an inch.
:p.Ruler bars are also capable of being offset or scaled. Please see the
:link reftype=hd res=51.units of measurement dialog:elink. for further details.
:p.:hp2.Custom snap markers:ehp2.
:p.Ruler bars support custom snap markers. When you position the mouse cursor on a ruler bar,
the cursor changes to a special marker cursor. You can mark a snap line by clicking on any of
the visible ruler divisions. Similarly, if you click on a marked position, the mark is removed.
As you zoom in to the publication, so the ruler divisions get finer, and you will be able to
place snap markers more accurately. Note however, that a snap marker that is placed on a ruler
division at one scale, will remain accurately placed on that division at any scale.
:p.By right clicking on the ruler bar you get a snap marker dialog that enables you to directly
enter the snap guides you require. The measurement types allowed in this dialog are mm, cm, m,
in, din (1/10 inch), pt, and dpt (1/10 pt). There are 25.4 mm to the inch, and 72.2818 points
to the inch. The inch in this case is the British inch. If you give the size without a
measurement type, the value is considered to be in printer pels.
:p.Use custom snap markers to align frames on a page. Each custom snap marker will cause a
guide line to be drawn on the page.
:p.See also&colon.-
:p.:link reftype=hd res=92.Snap to...:elink.
.br
.br
.******************************************************************************
:h1 res=802 id=802 global.The status bar
:i1 id=statbar.The status bar
:p.The status bar runs along the bottom of the window, and is used by a variety of handlers to present
status information.
:p.The first, leftmost, item on the status bar is always the help window. This window always shows
help information for the image underneath the cursor. As you move the cursor over a button, the
help window changes to indicate what the button does. The same thing works if you move the cursor over a
ruler, or over a status window.
:p.The next item is the current page number and the number of pages per print sheet. (A print sheet is one
side of a sheet of paper). Thus P1 (1/s) means Page1 and there are 1 pages per side of a sheet of paper (per
print sheet).
:p.The third item shows the number of the current print sheet, and the total number of print sheets.
:p.Items beyond the third are reserved for the currently selected handler. By convention, the handler
identifies itself with it's first status item.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Menu Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  File Menu
.******************************************************************************
:h1 res=20 id=20 global.File Menu
:i1 id=file.File Menu
:p.This menu is used to.-
:sl.
:li.Start a :link reftype=hd res=21.new:elink. publication.
:li.:link reftype=hd res=22.Open:elink. an existing publication.
:li.:link reftype=hd res=23.Open:elink. a currently listed publication.
:li.Manage :link reftype=hd res=31.Projects:elink..
:li.:link reftype=hd res=24.Import:elink. information into the publication.
:li.:link reftype=hd res=25.Export:elink. information out of the publication.
:li.Use ':link reftype=hd res=32.Acquire image:elink.' with a TWAIN device such as a scanner.
:li.:link reftype=hd res=26.Save:elink. a publication.
:li.Save a publication under a new name (:link reftype=hd res=27.SaveAs:elink.).
:li.Enable :link reftype=hd res=30.Autosave:elink..
:li.:link reftype=hd res=28.Print a publication:elink..
:esl.
.******************************************************************************
:h2 res=21 id=21 global.Create a new publication
:i2 refid=file.Create a new publication
:p.If you have not saved the current publication, you will be asked if you want to save it.
You can press 'Cancel' to abandon the new file at this point, but note that if you press 'No',
you can no longer change your mind.
:p.If you choose 'Yes', you will be presented with the file save dialog. Note that if you cancel
the file save dialog at this point, you will still loose the file.
:p.:hp2.New Publication Dialog:ehp2.
:p.Maul Publisher provides a new publication dialog. This dialog allow you to choose the size and style of your new
publication. You can choose the number of printer pages to create, as well as the page number for the first page.
:p.The printer page may contain more than one page, but you cannot create, or print, less than one printer page.
:p.:hp2.Choosing the first page orientation:ehp2.
:p.If you have a closed book in front of you, the front cover forms the first page, and it is to the right of the
spine of the book. If your publication starts with this page, or a page to the right of the spine, choose the
default 'Right/Outside'.
:p.Sometimes, publications start on the inside page, i.e. to use the book metaphor, if the book is open, and the
first page of your publication is to the left of the spine, choose the 'Left/Inside' setting.
:p.:hp2.Master pages:ehp2.
:p.If you have created master pages at some time, you can use them to determine the size, shape, and initial contents
of your publication. To find out how to create master pages, have look at the
:link reftype=hd res=43.Master pages:elink. section.
:p.You can use alternate master pages, so that a different master page is used for facing printer pages. Make sure,
however, that the master pages match, or you will be warned that the master pages do not match. You may then choose
to continue to use the unmatched master pages anyway.
:p.If you choose not to use a master page, the default page information is used to create a series of blank pages.
.******************************************************************************
:h2 res=22 id=22 global.Open a publication
:i2 refid=file.Open a publication
:p.If you have not saved the current publication, you will be prompted to save it in a file.
Select a save file or Cancel. Only then will the Open dialog appear.
:p.Double clicking on a directory or drive will select that directory or drive.
:p.Single clicking on a file will select that file, while double clicking will
load the file and exit the Open dialog. Maul keeps a list of the last four files that you have opened.
:p.If you check the 'Open new session' checkbox fefore opening the file, you will not load the file into this program,
but instead will start another copy of this program with the file loaded. See the
:link reftype=hd res=100.switch list:elink. help.
:p.You can access this item from the button bar. Simply click on the :artwork name='open.bmp' runin. button.
.******************************************************************************
:h2 res=23 id=23 global.File quick open
:i2 refid=file.File quick open
:p.Maul keeps a list of the last four files that you have opened. Clicking on the name of the required
file bypasses the open dialog and is thus much faster.
.******************************************************************************
:h2 res=31 id=31 global.Managing projects
:i2 refid=file.Managing projects
:p.Project files are designed to help you manage a number of files as a project.
:p.Projects are very useful if you are creating large publications made up of many files. A project
consists of a project file, usually "something.mpj", and an associated folder "something". The project file
contains nothing more than a list of files in the project. This file can also contain documents in paths outside
the project folder. Because it is extremely unwise to automatically delete the documents listed in a project file,
no means is provided to delete project files from within Maul Publisher. Nevertheless, you can safely delete the
project file manually without destroying the documents in the project folder.
:p.The project file system provides the following features&colon.-
:ul.
:li.Stylesheets and master pages can be read and written to the project folder by default. This option is set in the
:link reftype=hd res=94.Global style settings:elink..
:li.The previous and next page buttons will automatically jump to the start or end of the previous or next document when
a project file is loaded.
:li.Closing a project file also closes the current document, if it is part of the project.
:li.A submenu lists all the documents in a project. You can jump to a document by clicking on its filename.
:li.A project file editor is provided to edit the order in which documents appear. This dialog also provides options
to insert or remove documents, or to open them in the main window.
:li.When you save a document to a new name, it is automatically added to the current project
:li.You can print a project providing the pages used by the files in the project match.
:eul.
:p.Things projects :hp2.cannot do:ehp2., and why.
:ul.
:li.There may be several reasons why you cannot print an entire project in one go. You must ensure that the
documents in a project will print to the same page format, and to the same printer. If you don't, you will get
an error message. If you are manually collating a double sided print, you will be prompted to reverse the pages for
each file in turn. Please check the starting page and page number of each file in the project, or you will end up
with empty pages or incorrect page numbers. Note that there is a small risk that the print spooler hard disk could
be overloaded with a series of large spool files, causing a system crash, so please make sure that plenty of disk
space is available.
:li.You cannot open more than one document in Maul at any one time. It would defeat the whole point of projects anyway,
that is to avoid having documents loaded that are too large to fit into the available memory.
:eul.
:p.:hp2.New Project Dialog:ehp2.
:p.Please select an existing folder and type in the name of the new project. If you use the name of an existing
project file, the operation will be refused.
:p.:hp2.Open Project Dialog:ehp2.
:p.Please select a project file to open. The project will be opened, and the first file in the list of projects will be
loaded. If you have an unsaved file loaded, you will be prompted to save it first.
:p.:hp2.Edit Project Dialog:ehp2.
:p.All modifications to the project file you perform here will be saved when you click the save button.
:p.The exception to this is the Insert button, which will immediately save the altered project file.
:p.:hp2.Print Project:ehp2.
:p.The print system verifies that the current file is saved, and that all the files in the project match. Once this
test is passed, the normal :link reftype=hd res=28.print dialog:elink. is shown.
:p.:hp2.Close Project:ehp2.
:p.The project is closed, and any file that is part of the project is also closed.
:p.:hp2.Add file to project:ehp2.
:p.You can add a file to a project once you have opened or created it. You cannot add the same file to a project twice,
if the file is already part of the project this menu item will be disabled.
.br
.br
.******************************************************************************
:h2 res=24 id=24 global.Import
:i2 refid=file.Import
:p.Some handlers allow you to import or export information. The default text handler for example will import
or export plain ASCII text. The import menu items are determined by the currently active handler, and available
import handlers.
:p.Some import handlers can deal with a page, or even with the whole file. These commands will always
appear in the import menu, as they are always valid. If no valid import handlers are found, the menu will be disabled.
.******************************************************************************
:h2 res=25 id=25 global.Export
:i2 refid=file.Export
:p.Some handlers allow you to import or export information. The default text handler for example will import
or export plain ASCII text. The export menu items are determined by the currently active handler, and available
export handlers.
:p.Some export handlers can deal with a page, or even with the whole file. These commands will always
appear in the export menu, as they are always valid. If no valid export handlers are found, the menu will be disabled.
.******************************************************************************
:h2 res=32 id=32 global.Acquire image from a TWAIN device such as a scanner.
:i2 refid=file.Acquire image from a TWAIN device such as a scanner.
:p.If you have a TWAIN compatible scanner installed, Maul will be able to communicate wth it. Two menu items are
associated with TWAIN, the first is 'Select image source...' in case you have more than one scanner installed, and the
second is 'Acquire image...', used to start the TWAIN scanner dialog.
:p.If no TWAIN source is available on your computer, these menu items will be disabled.
:p.In order for TWAIN to be operational, you must first select a frame and an empty object layer, as this will allow
a new bitmap object to be created. As scanned images are usually bitmap objects, the scanner menu items will also be 
enabled if the bitmap handler is active.
.br
.br
.******************************************************************************
:h2 res=26 id=26 global.Save a publication
:i2 refid=file.Save a publication
:p.Select File, then Save.
:p.If your publication has no name, you will be prompted for one.
:p.You can access this item from the button bar. Simply click on the :artwork name='save.bmp' runin. button.
.******************************************************************************
:h2 res=27 id=27 global.Save a publication with a new name
:i2 refid=file.Save a publication with a new name
:p.Select File, then SaveAs.
:p.You will be prompted to give a file name. You may also select a new path at this
point.
:p.Double clicking on a directory or drive will select that directory or drive.
:p.Single clicking on a file will select that file, while double clicking will
select the file and exit the Save As dialog.
:p.If you are overwriting an existing publication, you will be required to confirm an
appropriate action, where Yes means overwrite the file, No means ask for a new file name,
and Cancel aborts the SaveAs dialog.
.******************************************************************************
:h2 res=30 id=30 global.Auto Save
:i2 refid=file.Auto Save
:p.If autosave is enabled, Maul will automatically save your file in regular increments.
:p.Autosave is attempted whenever the undo list is updated. This means that autosave is
caused by an edit operation, and not by a simple timeout. Whether the autosave actually
occurs depends on a number of criteria&colon.-
:ul.
:li.Autosave must be enabled.
:li.The file must be modified.
:li.60 seconds must have elapsed since the last save.
:li.No undo chain can be open. (Undo chains imply a series of indivisible edit operations.
The :link reftype=hd res=83.undo list dialog:elink. shows these bracketed by
"{..." and "...}")
:eul.
.br
.br
.******************************************************************************
:h2 res=28 id=28 global.Print a publication
:i2 refid=file.Print a publication
:p.Select File, then Print..., alternatively you can click on the :artwork name='print.bmp' runin. button.
:p.If you are not a registered user, all your printouts will be marked as 'Unregistered' after the first page.
:p.You will see the print dialog. This dialog allows you to select a range of pages to print, as well as
enabling you to select a different printer.
:p.:hp2.Warning:ehp2.
:p.Maul is designed to work with printer page coordinates. Therefore any changes you make here to the printer
or form selected for the document can have some potentially nasty side effects&colon.-
:ul.
:li.If the printer page and the file page forms do not match, the publication will be rescaled to fit the form. As
such scaling is orthogonal, some misalignment may occur.
:li.Maul may attempt to apply some inappropiate dynamic job properties, occasionally this can result in the wrong
page orientation.
:li.If the x and y resolutions of your printer are not the same, the dynamic job properties are unable to
correctly set the page layout. You will then have to manually set the print job properties. Please pay particular
attention to page orientation.
:eul.
:p.The option of changing printers and forms in this dialog is really only designed for you to be able to print rough
trial copies on a local printer before producing a final printout on a more expensive or remote printer. This means
that you should choose the right form and printer for your publication in the
:link reftype=hd res=41.Page setup:elink. dialog to match
the machine (printer) that will produce the final printout.
 :p.:hp2.Dynamic job properties:ehp2.
:p.The program will first attempt to select the printer form automatically. If you have the correct printer selected
and your printer driver supports dynamic job properties, you ought to see the correct printer form and orientation
selected. Note that you will probably need Warp 4 or later for this to work. As this feature is undocumented by IBM,
please report any problems to
:link reftype='launch' object='netscape.exe' data='mailto:Maul Support <maulpub@gmail.com>'.Maul Support <maulpub@gmail.com>:elink..
:p.If you have more than one printer installed, and the forms refuse to match, you can try another printer. This will
force the dialog to retest for the correct form.
:p.You can tell if the dynamic job properties are successful because the dialog title will say 'Print&colon.- matched from
file (auto)'.
:p.:hp2.Manual printer form selection:ehp2.
:p.Try and pick a printer page form that matches the file page form as closely as possible. The dialog
will initially show the 'best fit' printer form. Changing the selected printer form will either disable dynamic job
properties, or where available, will be used to attempt to set the correct page orientation anyway.
:p.If you are using a different paper size or form type in your printer, you may have to set the printer
form in the 'Job properties' dialog. You can also use this dialog to set print quality, for example. If you change
parameters such as orientation, which are affected by dynamic job properties, they may well be reverted back to what the
program thinks is required.
:p.:hp2.Network printing and Metafile print jobs:ehp2.
:p.For the fastest printing, you can select the 'Metafile print job' checkbox. Metafiles give considerable improvements
in print spooling speeds. You can use this option on stand-alone machines, but many printer drivers cause serious
problems with two colour bitmaps, often printing a large coloured rectangle instead.
:p.In most circumstances, especially when using network printers, you must leave this option unchecked.
:p.:hp2.Aborting a print run:ehp2.
:p.The print status message has an abort button, which will cause the print run to end after the current page has been
spooled. If you wish to kill the print run even before the current page has printed, hold down the <Esc> key. <Esc> is
used throughout the application to kill things that are stuck in a loop.
:p.Holding down the <Esc> key will directly kill the paint loop. This is much faster
than the abort button, but you can expect to get a messed up page.
:p.:hp2.Postscript and Unicode:ehp2.
:p.By default, Maul will create new Text objects with a unicode codepage.
On OS/2, when the selected printer uses postscript technology, a Windows codepage will be used instead.
This is because postscript printing on OS/2 does not currently support unicode.
This behaviour can be changed by adding a new setting to maul.ini.
:p.The setting is called "Maul Publisher"->"PSUnicode", and it's value should be set to (ULONG)1. This will cause Maul
to use unicode at all times.
:p.:hp2.See Also&colon.-:ehp2.
:p.:link reftype=hd res=29.Other printing options:elink..
.br
.br
.******************************************************************************
:h3 res=29 id=29 global.Other printing options
:i2 refid=file.Other printing options
:p.Other printing options allow you to manage the printing of double sided prints on a single sided printer. When you
print a publication normally, the pages are printed in order.
:p.Unfortunately, this makes it difficult to create double sided publications with a single sided printer. In order to
print double sided, it is necessary to print all the odd numbered pages on one side, and all the even numbered pages
on the other side.
:p.Maul does this if you select 'Manual double sided printing', on the 'More print options' dialog. You
get to open this dialog when you press the 'More...' button in the 'Print' dialog.
:p.Maul presumes that the first double sided page that you print is on the right. Therefore, if your publication starts
with the first page on the left, this page is treated as a single sided page, and is printed separately. Similarly,
if you only print a range of pages, the first or last page may be single sided.
:p.In order to deal with this correctly, Maul will perform several print runs, outputting the various elements into
separate spool files. At each stage, Maul will pause to allow you to turn over or remove pages. You must wait for the
printer to finish each time before pressing 'Ok' to continue with the next print run.
:p.The order in which the facing pages need to be printed depends on the way the printer stacks the output pages. For
the HP Deskjet printers, for example, you should print in reverse order. You may well need to perform some experiments
to find out what is required.
:p.Once the print run is complete, you will probably need to reshuffle the stack of pages into the correct order.
.******************************************************************************
.*  Page Menu
.******************************************************************************
:h1 res=40 id=40 global.Page Menu
:i1 id=page.Page Menu
:p.This menu is used to.-
:sl.
:li.Setup a :link reftype=hd res=41.page:elink. format and type.
:li.Setup page :link reftype=hd res=42.margins:elink..
:li.Setup :link reftype=hd res=51.units of measurement:elink..
:li.Manage :link reftype=hd res=43.master:elink. pages
:li.:link reftype=hd res=48.Copy:elink. a page.
:li.:link reftype=hd res=49.Paste:elink. a page.
:li.:link reftype=hd res=44.Insert:elink. a page.
:li.:link reftype=hd res=45.Delete:elink. a page.
:li.:link reftype=hd res=53.Goto:elink. a page and frame.
:li.Go to the :link reftype=hd res=46.previous:elink. page.
:li.Go to the :link reftype=hd res=47.next:elink. page.
:esl.
.******************************************************************************
:h2 res=41 id=41 global.Page setup
:i2 refid=page.Page setup
:p.:hp2.Select printer:ehp2.
:p.Select a printer for your publication.
:p.Maul publisher works in close cooperation with a printer. You must have at least one
printer object installed with your system for Maul to work. You don't need to have an actual
printer attached, you only need the printer driver installed. If you wish you can set your
printer driver to print to a file.
:p.If you can access it, try also using one of the Apple Colour LaserWriter printer drivers
to create postscript files.
:p.:hp2.Select printer page format:ehp2.
:p.All possible printer forms are listed. You can create your own printer forms by clicking on the
'New form' button. You can create any form even if your printer is not actually capable of printing it.
If dynamic printer job properties are available for the current printer form, you can change the
orientation of the page by clicking on the graphic image of the page near the centre of the dialog.
:p.:hp2.Using printer setup:ehp2.
:p.Maul generally does not try and interfere with a printer's own page forms. Instead, it
relies on the printer manufacturers own printer setup dialog to alter page settings.
Generally, you will find a considerable number of interesting options available, over and
above the obvious ones such as changing print quality or orientation. If the printer form was
created by you, the form you get to see is the same one that you created using the 'New form'
dialog.
:p.When you come to print your document, you must choose a real form. Once again, the print
dialog offers the possibility to change the printer setup, this time for the actual pages that
you are printing.

:p.:hp2.Printer page subdivision:ehp2.
:p.You can subdivide a printer page into a number of pages. If you choose to make the page as large as
possible within the printer page, click on the 'Full printer page' button. You can tell Maul at this time
whether your pages are bound together at the top or bottom instead of the left or right. The bound edge is
where all the pages are glued together. The pages of a wall calendar are often top bound, for example.
:p.If you choose to subdivide your pages into several smaller ones (useful for printing lots of business cards),
select the 'Subdivision of printer page' button. You can choose to split the printer page into chunks, one beside
the other (vertical split), or one above the other (horizontal split), or both. In this way you can split your
printer page into as many as 25 separate pages.
:p.The 'Folding Booklet' format is most commonly found in magazines and newspapers. In this format, the last and
first page of a newspaper are on the same printer page. The printer page is always twice the size of the folded
newspaper or magazine. Magazines normally use a vertical fold and are printed onto a number of printsheet faces
that are then stapled together.
:p.Expensive professionally bound hardbacks also use the folding booklet format. Four or eight pages are folded
and sewn into the spine. The whole book will consist of a number of sewn-in bundles. You must indicate how many
printer sheet faces (2 per page) there are in a bundle. Maul will correctly number and margin pages across many
bundles.
:p.:hp2.Page numbering:ehp2.
:p.Maul will correctly number pages whether your publication starts with the first page on the right, or with the
first page on the left. You can also start numbering from a page other than the first (up to page 32768). Pages
prior to the first page will be marked as negative numbers. (a sequence might go '-2, -1, 1, 2, 3, etc..')
:p.See also&colon.-
:p.:link reftype=hd res=42.Page margin setup:elink.
:p.:link reftype=hd res=95.Save printer setup:elink..
.br
.br
.******************************************************************************
:h3 res=52 id=52 global.Printer margin overrides
:i2 refid=page.Printer margin overrides
:p.Printer margin overrides are an OS/2 specific fix to the way printer margins are specified.
:p.:hp2.Some history:ehp2.
:p.The system call DevQueryHardcopyCaps() is used in OS/2 applications to read information about the currently
selected printer form. Unfortunately, this system call returns printer page margin information specified only
to the nearest mm. This is not sufficiently precise to accurately position objects on a page.
:p.Most modern printers are capable of repetitively aligning pages to better than 0.5mm, and sometimes much better
than that. When you want to print a double sided page, and have front and back faces aligned with each other, you need
to be able to precisely align the pages. Reversing ruler bars and centred printable page areas help to make this
possible, but only if the unprintable page margins are specified accurately.
:p.:hp2.The fix:ehp2.
:p.You can create a file to override the margins returned by the printer. When you select a printer page, the
application looks for a file with the same name as the printer, with a ".txt" extension. If such a file exists, the
unprintable page margins are read from this file, and not from the printer.
:p.In the 'Local System->Printers' folder my printer is called a 'HP Deskjet 895C'. In order to create a margins
override for this printer, I create a file called 'HP Deskjet 895C.txt' in the .\etc path where Maul is installed.
:p.In this file I specify the margins for all the forms I am likely to use. I can use a # symbol at the start of a
line to add some comments.
:xmp.
##################################################
#
# Hp Deskjet Printer margins override
# These are tweaked margins for the
# HP DeskJet 895C
# (portrait)form=left,right,bottom,top in 1000th mm
# not case sensitive, no spaces allowed
#
##################################################
a4=3400,3400,11760,1020
letter=6400,6400,12280,1020
legal=6400,6400,12080,1020
executive=6775,6775,11980,1020
dl envelope=3185,3185,22130,1020
:exmp.
:p.In order for these overrides to operate quickly, the file parser needs to be extremely basic. So please note a
couple of things about this file&colon.-
:ul.
:li.The margins are always specified for a page in protrait mode, tall rather than wide.
:li.The margins are always specified left, right, bottom, top in 1000th mm.
:li.One line for each printer form.
:li.Spaces are not allowed unless they are part of the form name.
:li.You only need to specify those forms you actually need to override, the rest will simply be accurate to
the nearest mm.
:eul.
:p.:hp2.Where to find the information required:ehp2.
:p.The last question is where you might be able to find the correct margin values for your printer. This is a knotty
issue, but some experimentation can help.
:p.First of all, you can open the page setup dialog, choose the correct printer and form, and then click on the
'New form' button. The 'new printer form' dialog has a margin calculator built in that works out exactly what the
right and bottom margins should be, based on the top and left margins. For my printer, I worked out values designed to
keep the left and right margins the same, and the top margin always at 1.020mm. This actually corresponds nicely with
the margins returned by Microsoft Windows for the same printer.
:p.Secondly, you can draw a black rectangle on a full printer page. Make sure all centering is turned off, and draw a
rectangle with a 1pel wide black border. Size the rectangle to snap to the boundaries of the printable page. Print the
page and measure the margins with a ruler. Once the margins are set, test them by enabling page centering first, and
then drawing a new rectangle as explained above. Print the same rectangle on both sides of a printer page, and hold the
sheet up to the light. You will then see how accurately your rectangles are aligned.
.br
.br
.******************************************************************************
:h2 res=42 id=42 global.Page margin setup
:i2 refid=page.Page margin setup
:p.:hp2.Note:ehp2. Some settings, such as fold gutters and reversing layout grids, require you to click on the
'Set All' button before they are updated. This is because these settings affect all pages. All other settings
can be set on a per-page basis.
:p.:hp2.Printer page margins:ehp2.
:p.This part of the dialog is for your information only. The actual paper size is shown, as well as the printer
page margins. These margin values will change if the printable area is centred on the printer page. See the
:link reftype=hd res=41.page setup:elink. for further details.
:p.:hp2.Page margins:ehp2.
:p.You can setup margins around each page. These margins are used to give a whitespace around each page on a printer
page. They are separate from, and in addition to, the margins required by the printer.The printer's own margins are
not very precisely defined, and the printer is not capable of printing on them. This program will happily print beyond
the  margins you set here, if you are required to do so. These margins are only used as place markers for frames to snap
to. Remember you can also use custom snap markers to create lines to snap to. See
:link reftype=hd res=803.the ruler bars:elink. for further details.
:p.:hp2.Mirror layout grid:ehp2.
:p.In full page and folding booklet modes, you can have Maul reverse the margins and the associated layout grid
for facing pages.
:p.:hp2.Mirror ruler bars:ehp2.
:p.If you mirror the layout grid, you can have the start of the ruler bar offset so that you can measure from opposite
sides of the page. The effect is disabled if you select
:link reftype=hd res=62.printer page:elink. or
:link reftype=hd res=61.facing page:elink. views of your document.
:p.:hp2.Layout grid:ehp2.
:p.Set up a number of rows and columns. These allow you to create consistent frames of text and pictures. The gutter
is simply a gap between rows and a matching gap between columns. By selecting 'Show centre gutters' the centreline
of each gutter is also shown.
:p.Use the 'Grid from papersize' mode to align the layout grid to the actual size of the piece of paper you are
printing on. If you then fold the piece of paper along a grid line, the edges of the page will line up. As this
mode is only really sensible for full page layouts, it is disabled for other page layouts.
:p.:hp2.Fold gutters:ehp2.
:p.In folding booklet mode, when a number of printer pages are stapled together, the page on the outside has to
stretch around all the other pages. Maul can compensate for this stretching to align text and pictures from page
to page. As you get closer and closer to the centre page, so this gap ought to shrink. This shrinking effect is
automated if you select 'Autoshrink' mode. The actual fold gutter maximum size will vary between different types
of paper and will have to be determined by micrometer and/or experiment. (Try measuring the thickness of
the bundle of printer pages before folding, then multiply by 3.14).
:p.See also&colon.-
:p.:link reftype=hd res=41.Page setup:elink.
:p.:link reftype=hd res=95.Save printer setup:elink..
.br
.br
.******************************************************************************
:h2 res=51 id=51 global.Units of measurement setup
:i2 refid=page.Units of measurement setup
:p.:hp2.Measurements:ehp2.
:p.Use this dialog to setup a measurement type. Maul will use the units of measurement you choose here throughout
the application.
:p.The units of measurement setting is saved within your publication. Although you can always change it, this allows
you to have the publication always open with the same measurement mode.
:p.:hp2.Scaling and Offset:ehp2.
:p.Scaling and offset allows you to choose arbitrary dimensions for measurement. This is particularly important
when you want to draw archtectural drawings using Maul. Offset is a method of shifting the ruler origin along by a
certain distance. None of these settings affect the actual size of the page you are drawing on. All that happens is
that the scaling and offset are added to the dimension values shown in the dialogs and ruler bars.
:p.The scaling factor is used to scale the ruler. If you set this value to 50, then 2cm is shown as 1m. If you set this
value to 0.05, then 2cm is shown as 1mm.
:p.The offsets are added to the ruler bar and take acount of the scaling. In other words if the scaling factor is 50,
then to offset the ruler origin across by 2cm on the page, you specify 1m. This makes it simple to set offset, but
remember that if you reset the scaling, the ruler origin will still be offset 1m beyond the edge of the page!
:p.See also :link reftype=hd res=95.Save printer setup:elink..
.br
.br
.******************************************************************************
:h2 res=43 id=43 global.Master pages
:i2 refid=page.Master pages
:p.:hp2.Insert master page menu:ehp2.
:p.This menu item is a conditional dropdown list, that is, by pressing the little button to the right of the menu
item, you are shown a list of master pages. If you have never saved a master page, the menu item will be disabled.
:p.Whichever master page you have selected then becomes the default master page. You can load the default master
page by simply clicking on the 'Insert Master Page' menu item. Master pages add printer pages to the file, after the
current page, and copy the contents of the master page to the new page. This allows the quick generation of a
publication using master pages. If you end up with a blank first page, you can subsequently delete it. Alternatively,
you can copy an existing page, and :link reftype=hd res=49.paste:elink.. it into the blank frame.
:p.The page shape and size are checked for compatibility with the current page, and if they do not match, you will
be warned about it.
:p.Master pages are always scaled according to the difference in dots per inch of the master page versus the current
page. You can have as many master pages as you please.
:p.:hp2.Save/delete master page dialog:ehp2.
:p.Use this dialog to manage your master pages. If you choose to save the current page as a master page, everything
on the printer page is saved into the master page. If you use control text for page numbers, they will be correct
because page numbers are always dynamically updated.
:p.If you no longer require a particular master page, select it and delete it. Note that you cannot easily undo the
deletion of a master page as these are real files on the disk. Master pages and style sheets are kept in the .\etc
directory (where the dot is the directory where Maul is installed).
:p.:hp2.Creating master pages:ehp2.
:p.A master page is nothing more than a single page publication. To create a master page just add any frames you
want in order to create a page that has all the common frames and objects you need to create your publication. Such
common frames might consist of empty text frames, company logos and page numbers.
:p.Where you need to have page numbers, you can use control text to ensure that the page numbers are always
correct. You can find out more about control text in the text handler manual.
:p.:hp2.Advanced master pages&colon.- Automated object linkage across pages:ehp2.
:p.From V1.22 Maul supports the concept of 'torn links' on master pages. The purpose of a torn link is to provide the
means to automate the linkage of frames such as text frames across pages. A new publication created with correctly set
up torn links on the master pages results in a publication with all the required frames linked together, across all the
pages.
:p.To create a master page with torn links, you need to start with at least three pages. A first page, a last page, and
the master page in the middle.
:p.On the new master page, create the set of text frames you want to link, as well as any other frames that you want to
have on every page of your publication. You will also have to create text frames on the first and last pages for the
master page text frames to link to. You then create a text frame on the first page, and link all the required frames
together, across all three pages. You now have a three page mini-publication.
:p.Save the middle page as a master page. The program will mark all links across the page boundaries as torn links, and
will identify them with an automatically generated id. Whenever you create a new multi page publication using master
pages containing torn links, all the torn links will be re-connected to each other. Note that this process only works
when creating new documents, it doesn't work when manually copying or pasting pages. The text handler provides the
means to manually edit linkage.
:p.If you select two different master pages in the 'New file' dialog, the pages will still be linked as long as the
number and identities of the links match. You can thus easily create large documents with many linked objects.
:p.:artwork name='torn.bmp' align=left.
.br
.br
.******************************************************************************
:h2 res=48 id=48 global.Copy a page
:i2 refid=page.Copy a page
:p.Use the 'Copy a page' menu item to copy the current printer page to the
clipboard. The current printer page remains the same.
:p.This feature will not cope with pages containing offlined bitmap images,
and frames linked outside this page will be unlinked.
:p.You can copy frames to transfer offlined images.
.******************************************************************************
:h2 res=49 id=49 global.Paste a page
:i2 refid=page.Paste a page
:p.Use the 'Paste page' menu item to paste a printer page from the clipboard over the current printer page. The
current printer page is not saved.
:p.'Paste page' does not add printer pages to the file, but rather overwrites the current page with the contents
of the clipboard. The page shape and size are checked for compatibility with the current page, and if they do not
match, you will be warned about it. This gives you the opportunity to abandon the paste.
.******************************************************************************
:h2 res=44 id=44 global.Insert a page
:i2 refid=page.Insert a page
:p.Use the 'Insert a page' menu item or click on the :artwork name='addpg.bmp' runin. button to add a printer page
after the current printer page.
:p.You will sometimes need to add a printer page :hp2.before:ehp2. the current printer page. You can achieve this by
using the page menu. Click on the small button to the right of the 'Insert a page' menu item, and select the
'Insert page before current' item from the dropdown list.
.******************************************************************************
:h2 res=45 id=45 global.Delete a page
:i2 refid=page.Delete a page
:p.Use the 'Delete a page' menu item or click on the :artwork name='delpg.bmp' runin. button to delete the current
printer page.
.******************************************************************************
:h2 res=53 id=53 global.Goto a page and frame
:i2 refid=page.Goto a page and frame
:p.Use this dialog to quickly jump to a particular page and frame.
:p.Each time to jump to a page, all frames are deselected, and the list of frames is refreshed. Once you have jumped to
the required page, you can jump to the required frame by selecting it from the dropdown list of available frames.
:p.The ability to go to a particular frame is of most use when browsing the results of a
:link reftype=hd res=86.prepress report:elink..
.br
.br
.******************************************************************************
:h2 res=46 id=46 global.Goto previous page
:i2 refid=page.Goto previous page
:p.Use the 'Goto previous page' menu item or click on the :artwork name='prevpg.bmp' runin. button to go to the
previous printer page.
.******************************************************************************
:h2 res=47 id=47 global.Goto next page
:i2 refid=page.Goto next page
:p.Use the 'Goto next page' menu item or click on the :artwork name='nextpg.bmp' runin. button to go to the
next printer page.
.br
.br
.******************************************************************************
.*  View Menu
.******************************************************************************
:h1 res=60 id=60 global.View Menu
:i1 id=view.View Menu
:p.This menu is used to.-
:sl.
:li.View :link reftype=hd res=61.facing:elink. printer pages.
:li.View a :link reftype=hd res=62.printer:elink. page.
:li.View the :link reftype=hd res=63.current:elink. page.
:li.:link reftype=hd res=64.Fit:elink. the current page to the window.
:li.View a :link reftype=hd res=65.page:elink. closeup.
:li.:link reftype=hd res=66.Zoom in:elink. to a page.
:li.:link reftype=hd res=67.Zoom out:elink. of a page.
:Esl.
.******************************************************************************
:h2 res=61 id=61 global.View facing printer pages
:i2 refid=view.View facing printer pages
:p.Use the 'Printer facing pages' menu item, or simply use the :artwork name='vpface.bmp' runin. button on the
button bar.
:p.This fits a pair of printer pages into the screen. The two pages are zoomed so that they
are shown correctly aligned in relation to each other. This relationship is affected by which side
the first page is on, as well as whether the pages are bound at the top or at the side.
:p.:hp2.Be careful:ehp2., in this mode, it is possible to place frames aligned to the inactive page.
When you print such a document, the frames that are off the active page will not be printed. You
can tell which is the active page, because active pages have a blue border, rather than cyan.
:p.Note that in this mode, the rules are aligned to the total printable page area, and not the
current page.
.******************************************************************************
:h2 res=62 id=62 global.View printer page
:i2 refid=view.View printer page
:p.Use the 'Printer page' menu item, or simply use the :artwork name='vppage.bmp' runin. button on the button bar.
:p.This fits the current printer page into the window. The page is zoomed so that the largest dimension fits the
window. The page is also recentred within the window. Note that in this mode, the rules are aligned to the printer
page, and not the current page.
.******************************************************************************
:h2 res=63 id=63 global.View single page
:i2 refid=view.View single page
:p.Use the 'Full page' menu item, or simply use the :artwork name='vpage.bmp' runin. button on the button bar.
:p.This fits the current page into the window. The page is zoomed so that the largest dimension fits the
window. The page is also recentred within the window. Note that in this mode, the rules are aligned to the current
page, and not the printer page.
.******************************************************************************
:h2 res=64 id=64 global.View page zoomed to window
:i2 refid=view.View page zoomed to window
:p.Use the 'Fit Width' menu item, or simply use the :artwork name='fitw.bmp' runin. button on the button bar.
:p.This fits the current page into the window. The page is zoomed so that the smallest dimension fits the
window. The page is also recentred within the window. Note that in this mode, the rules are aligned to the current
page, and not the printer page.
.******************************************************************************
:h2 res=65 id=65 global.View page actual size
:i2 refid=view.View page actual size
:p.Use the 'Actual size' menu item, or simply use the :artwork name='actual.bmp' runin. button on the button bar.
:p.This gives you a view of the currently selected frame, or the current page. The size is not really actual
size, but rather a size designed to be comfortable for editing text. Note that in this mode, the rules are aligned to the current
page, and not the printer page.
.******************************************************************************
:h2 res=66 id=66 global.Zoom in
:i2 refid=view.Zoom in
:p.Use the 'Zoom in' menu item, or simply use the :artwork name='zoom.bmp' runin. buttons on the button bar.
Use the + button to zoom in, and the - button to zoom out.
:p.The number to the right of the two buttons gives the current zoom factor. The zoom factor changes in powers of
root 2.
:dl compact tsize=20.
:dt.&sqbul. 0.13:dd.(1 &colon.&colon. 8)
:dt.&sqbul. 0.18:dd.
:dt.&sqbul. 0.25:dd.(1 &colon.&colon. 4)
:dt.&sqbul. 0.35:dd.
:dt.&sqbul. 0.5:dd.(1 &colon.&colon. 2)
:dt.&sqbul. 0.71:dd.
:dt.&sqbul. 1:dd.(1 &colon.&colon. 1)
:dt.&sqbul. 1.41:dd.
:dt.&sqbul. 2:dd.(2 &colon.&colon. 1)
:dt.&sqbul. 2.83:dd.
:dt.&sqbul. 4:dd.(4 &colon.&colon. 1)
:dt.&sqbul. 5.66:dd.
:dt.&sqbul. 8:dd.(8 &colon.&colon. 1)
:dt.&sqbul. 11.31:dd.
:dt.&sqbul. 16:dd.(16 &colon.&colon. 1)
:edl.
:lm margin=1.
.br
.br
.******************************************************************************
:h2 res=67 id=67 global.Zoom out
:i2 refid=view.Zoom out
:p.Use the 'Zoom out' menu item, or simply use the :artwork name='zoom.bmp' runin. buttons on the button bar.
Use the + button to zoom in, and the - button to zoom out.
:p.The number to the right of the two buttons gives the current zoom factor. The zoom factor changes in powers of
root 2.
:dl compact tsize=20.
:dt.&sqbul. 0.13:dd.(1 &colon.&colon. 8)
:dt.&sqbul. 0.18:dd.
:dt.&sqbul. 0.25:dd.(1 &colon.&colon. 4)
:dt.&sqbul. 0.35:dd.
:dt.&sqbul. 0.5:dd.(1 &colon.&colon. 2)
:dt.&sqbul. 0.71:dd.
:dt.&sqbul. 1:dd.(1 &colon.&colon. 1)
:dt.&sqbul. 1.41:dd.
:dt.&sqbul. 2:dd.(2 &colon.&colon. 1)
:dt.&sqbul. 2.83:dd.
:dt.&sqbul. 4:dd.(4 &colon.&colon. 1)
:dt.&sqbul. 5.66:dd.
:dt.&sqbul. 8:dd.(8 &colon.&colon. 1)
:dt.&sqbul. 11.31:dd.
:dt.&sqbul. 16:dd.(16 &colon.&colon. 1)
:edl.
:lm margin=1.
.br
.br
.******************************************************************************
.*  Edit Menu
.******************************************************************************
:h1 res=70 id=70 global.Edit Menu
:i1 id=edit.Edit Menu
:p.The edit menu is reserved for the currently selected handler. As you switch handlers, so
the menu changes. If no menu appears, you may have to select, or reselect a handler.
:p.To connect a handler to an empty frame, see :link reftype=hd res=72.Adding an object to a frame:elink.
:p.To paste from the clipboard to an empty frame, see :link reftype=hd res=71.Pasting into an empty frame:elink.
.br
.br
:h2 res=71 id=71 global.Pasting into an empty frame
:i2 refid=edit.Pasting into an empty frame
:p.When you select an object layer button (a button with a question mark on it), the <null> handler becomes active. As long
as you have a frame selected, you can use the <null> handler to add objects to the frame.
:p.The <null> handler allows you to directly paste recognized data types into an empty frame. In this case, the required
object handler is automatically attached to the frame before the data is imported from the clipboard.
:p.The data in the clipboard will determine the object created. Where there is a choice of clipboard data, you can use the
little arrow to the right of the menu item in order to choose a particular object.
:p.For other methods of adding data to a frame, see :link reftype=hd res=72.Adding an object to a frame:elink.
.******************************************************************************
:h2 res=72 id=72 global.Adding an object to a frame
:i2 refid=edit.Adding an object to a frame
:p.There are several ways to add an object to a frame. In every case, the frame must exist, it must be selected, and
you must choose to which part of the frame you wish to add the object.
:p.:hp2.Objects and object layers overview:ehp2.
:p.Objects are arranged in layers, and come in two
types. One type is for frame contents, and the other is for frame borders. Objects are painted and edited by object
handlers. Here is an example of the names of two types of object handlers, one for contents, the other for a border&colon.-
:sl.
:li.CONTENTS, Plain text
:li.BORDER, Plain border
:esl.
:p.If the text handler is attached to frame contents layer 0, the associated button would show an I beam cursor image, and
the help message for that button would show 'Layer 0&colon.- Plain text'.
:p.Layers are given names in the 'View' menu in order to better indicate what they might be used for.
:sl.
:li.Layer 0. Contents or border layers. The top layer.
:li.Layer 1. Background or border background layers. The background layer is used to add a
background to a frame, it is also the layer that can be inserted inside text characters.
:li.Layer 2. Base or border base layers. This is another background layer, useful for when
the above layer is set to be inserted inside text characters.
:li.Layer 3. Shadow or border shadow layers. This layer is useful for adding drop shadows to
an otherwise fully populated frame.
:esl.
:p.What you use the layers for is in fact mostly arbitrary, it makes no difference whether you place a background
on layer 1, 2, or 3. But, if you use self clipping modes to paint a background inside text the background must be
on layer 1. Only layer 1 can be drawn inside text on layer 0. For more information on self clipping, read the
frame handler documentation.
:p.:hp2.Adding an object to a frame, step 1&colon. Choose a layer.:ehp2.
:ul.
:li.Using the 'View' menu&colon.
:ol.
:li.Select the frame by clicking on it.
:li.Open the 'View' menu.
:li.Click on 'Contents edit mode', or click on the little arrow to the right of the menu item in order to
choose a particular layer. If you want a border layer, use the 'Border edit mode' submenu instead.
Make sure that you choose a layer that does not already have an object attached.
:eol.
:li.Using the toolbar buttons&colon.
:ol.
:li.Select the frame by clicking on it.
:ul.
:li.You can either...
:artwork name='addob1.bmp'.
:li....or...
:artwork name='addob2.bmp'. and :artwork name='addob3.bmp'.
:eul.
:eol.
:eul.
:p.:hp2.Adding an object to a frame, step 2&colon. Add the object:ehp2.
:ul.
:li.Ways to create an empty object&colon.
:ol.
:li.Open the 'Edit' menu. Because you have chosen a layer with no object, the <null> handler will be active.
This handler provides the menu item, 'Add handler to frame...'. Click on it. In the small dialog that opens,
you can select the object (i.e. an object handler) to add.
:li.You can click on one of the object buttons that will appear.
:artwork name='seltxt.bmp'.
In the above image I am about to choose the text object.
:eol.
:li.Ways to insert an object&colon.
:ol.
:li.Open the 'Edit' menu. Because you have chosen a layer with no object, the <null> handler will be active.
This handler provides the menu item, :link reftype=hd res=71.'Paste object':elink.. The data
in the clipboard will determine the object created. Where there is a choice of clipboard data, you can use
the little arrow to the right of the menu item in order to choose a particular object.
:li.You can use the 'File->Import' menu to choose a file type to import.
:li.You can drag a file from the desktop onto the frame. Only recognised file types will be
accepted.
:eol.
:eul.
:p.Notice that layers that have objects attached get the button image associated with the object handler. Click on the
required button to edit the object. Objects are removed by selecting the correct object layer and clicking on
'Remove handler' in the 'Edit' menu.
:artwork name='addob5.bmp'.
:p.:hp1.The above image is a collage showing both layer dropdown menus, and the object images that are painted
on the buttons. You can just make out the result of all these layers beneath the menus.:ehp1.
.br
.br
.******************************************************************************
.*  Undo Menu
.******************************************************************************
:h1 res=80 id=80 global.Undo Menu
:i1 id=undo.Undo Menu
:p.This menu is used to.-
:sl.
:li.:link reftype=hd res=81.Undo:elink. and then
:link reftype=hd res=82.Redo:elink. the last action.
:li.Access the :link reftype=hd res=83.Undo List:elink..
:esl.
.br
.br
.******************************************************************************
:h2 res=81 id=81 global.Undoing Changes
:i2 refid=undo.Undoing Changes
:p.Select Undo from the Undo menu or type alt+backspace to undo the last action.
:p.Certain undo's will consist of several parts, eg a paste may consist of an insert text
followed by a clear. The menu item will show the next available undo and redo options.
:p.As undo is virtually unlimited, occasional file saves are recommended. This clears
the undo buffer and frees memory. Once saved there is nothing to undo.
:p.After an action has been undone, it may be redone.
Select :link reftype=hd res=82.Redo:elink. from the Undo menu
or type ctrl+backspace.

.******************************************************************************
:h2 res=82 id=82 global.Redo after Undo
:i2 refid=undo.Redo after Undo
:p.Press Ctrl+Backspace to Redo after an Undo.
:p.If you have just used Undo, you can Redo the Undo. A Redo after an edit (eg typing)
may not be possible. When a Redo is not possible, the menu option will be disabled.

.******************************************************************************
:h2 res=83 id=83 global.The Undo List
:i2 refid=undo.The Undo List
:p.You can undo or redo actions from the Undo List.
:p.The Undo List is a separate thread showing the contents of the undo buffer. The list
will update dynamically as you edit, but this does slow down everything while the
listbox is updated.
:p.:hp2.How to undo or redo from the Listbox:ehp2.
:p.The current undo position is always shown hilighted. You can select an undo or redo
action by clicking on the relevant listbox item. By doing this you can then perform a
multiple undo or redo by clicking on the relevant button.
:p.Maul ignores requests that are not sensible. If you click on a undo item, and
then press the redo button, a single redo is performed.
:p.Simply clicking the undo or redo button will perform a single action when the
highlighted selection (grey) is on top of the current undo position (red). Performing a
multiple undo makes the highlighted selection and the undo position the same.
.br
.br
.******************************************************************************
.*  Tools Menu
.******************************************************************************
:h1 res=84 id=84 global.Tools Menu
:i1 id=tools.Tools Menu
:p.This menu is used to.-
:sl.
:li.:link reftype=hd res=85.Search:elink. for a text article.
:li.Produce a :link reftype=hd res=86.prepress:elink. report.
:li.Access :link reftype=hd res=204.the Colour palette:elink..
:li.Adjust :link reftype=hd res=88.object colours:elink..
:li.:link reftype=hd res=87.Embed fonts into a document:elink..
:esl.
:lm margin=1.
:p.Other tools may be added by various handlers. These are not described here. For further information
see the help provided by the relevant handler.
.br
.br
.******************************************************************************
:h2 res=85 id=85 global.Search for text
:i2 refid=tools.Search for text
:p.As your publication can contain many text articles, this facility is provided to search those articles according to
a number of optional criteria.
:p.If you do not restrict the search in any way, the search will list every article in the file. You can restrict the
search to a given name, author, or search string. You can use any, all, or none of these restrictions as you require.
:p.:hp2.Article name:ehp2.
:p.Enter an article name to restrict the search to articles with that name, or at least starting with that name.
:p.The article name is either made up of the first few words of the text article, or the text article
information if this is available. The comparison is not case sensitive. If you enter the word "this", the search can
return both&colon.-
:p."This tiny article"
.br
and
.br
"THIS is another article"
:p.:hp2.Article author:ehp2.
:p.Enter an article author to restrict the search to articles by that author.
:p.The article author must be defined in the text article information, otherwise nothing will be found.The comparison
is not case sensitive. If you enter the word "George", the search can
return both&colon.-
:p."George Orwell"
.br
and
.br
"George Melley"
:p.:hp2.Text to find:ehp2.
:p.Enter some text to find. The search will only return only those articles that contain the given text. You can ask for
a case sensitive comparison if you wish. Only the first occurrence of the text within the article is listed.
:p.:hp2.Selecting a found article:ehp2.
:p.To select a found article, simply double click on the listbox item, or single click an item and then press the
'Select' button. The text article will be selected, and the application will switch to the correct object handler.
:p.If you have specified some text to find, the first occurrence of that text will be highlighted. You can use the
'Find' menuitem in the edit menu of the selected handler to continue the search for further occurrences of the text.
.br
.br
.******************************************************************************
:h2 res=86 id=86 global.Prepress report
:i2 refid=tools.Prepress report
:p.Use the prepress report to help you find potential problems with your documents. These are not errors, but
items that may produce unexpected results when printing your publication. Most problems are caused by the effect
of colour separation, where coloured text is too small, or images are not scaled accurately. The report produced
will not be definitive, and most warnings can be ignored. The purpose of this feature is to make you aware of where
problems might lie, and to help you resolve them by providing some explanatory text.
:p.You can save the resultant report as a text file that you can browse at your leisure.
:p.Use the :link reftype=hd res=53.'goto page...':elink. dialog to find the page and frame where a
problem was noted.
.br
.br
.******************************************************************************
:h2 res=204 id=204 global.The Colour Palette
:i2 refid=tools.The Colour Palette
:p.The colour palette is used to store colours common to your publication. Colours are
stored in the file, and can be loaded at startup.
See :link reftype=hd res=94.Global style settings:elink. for more information.
:p.The colour palette is fully drag and drop enabled so you can drag colours both in and
out of the document. In other words you can drop a colour on to a desktop window, just
like when using a system colour palette.
:p.:artwork name='palette.bmp' align=left.
:p.Use the colour palette dialog to manage your colours. Double click on a colour to edit
its name and style. Double click on a blank part of the colour palette to add a new colour.
See the :link reftype=hd res=200.Edit Colour:elink. dialog for more information.
:p.The colour palette dialog provides a set of buttons to load and save the colours in a
colour table file. These operations can also be performed directly from the
:link reftype=hd res=90.Options Menu:elink..
:p.:hp2.Load:ehp2.
:p.You can load a color table, but be aware that this will delete any existing named colour
information in the publication. Select the table to load and click the 'Load' button.
:p.:hp2.Merge:ehp2.
:p.You can merge a colour table with the existing colours in the publication. Where named
colours already exist in the publication, the publication colours take precedence.
:p.:hp2.Save:ehp2.
:p.By saving named colours in a colour table, you can ensure matching colours between
different publications.
:p.:hp2.Deleting colour tables:ehp2.
:p.The load/save dialog provides the means to delete a colour table file. Right click on the
file to delete in the filename list, and select the delete option from the popup menu.
:p.:hp2.Editing colour tables:ehp2.
:p.Colour tables are saved as human readable plain text files. This gives the rather neat
possibility of creating colour tables using an ordinary text editor such as 'E', to quickly
create a colour table (but carefully, because the syntax must be correct).
:p.All comments in the file start with a '<' symbol.
:p.All colour entries start with a '>' symbol.
:p.The colour entries are added line by line, with each entry having the following form&colon.-
:xmp.
>My_colour_name, cyan (0 to 255), magenta (0 to 255), yellow (0 to 255), screen_angle
:exmp.
:p.The screen angle is always a value between 0 and 4, where&colon.-
:ul.
:li.0 = Process
:li.1 = Black
:li.2 = Cyan
:li.3 = Magenta
:li.4 = Yellow
:eul.
:p.Here is a simple colour table&colon.-
:xmp.
<This is an auto generated file, edit at your peril
<Name, cyan (0..255), magenta (0..255), yellow (0..255), screen (0 = Process, 1 = Black, 2 = Cyan, 3 = Magenta, 4 = Yellow)
<...This is your very most basic colour table...
<
>Process_white, 0, 0, 0, 0
>Process_yellow, 0, 0, 255, 0
>Process_magenta, 0, 255, 0, 0
>Process_red, 0, 255, 255, 0
>Process_cyan, 255, 0, 0, 0
>Process_green, 255, 0, 255, 0
>Process_blue, 255, 255, 0, 0
>Process_gray, 51, 51, 51, 0
>Process_dkgray, 127, 127, 127, 0
>Process_dkyellow, 127, 127, 255, 0
>Process_dkmagenta, 127, 255, 127, 0
>Process_dkred, 127, 255, 255, 0
>Process_dkcyan, 255, 127, 127, 0
>Process_dkgreen, 255, 127, 255, 0
>Process_dkblue, 255, 255, 127, 0
>Process_black, 255, 255, 255, 0
:exmp.
:p.The above table is supplied in the file 'common.clr', and is installed in the english.nls\docs path for you.
:p.:hp2.Warning&colon.-:ehp2. The colours are specified as CMY secondary colours, not RGB. Therefore, the bigger
the numbers, the darker the colour! To get to CMY from RGB, do the following calculation&colon.-
:ul.
:li.Cyan = 255 - Red
:li.Magenta =  255 - Green
:li.Yellow = 255 - Blue
:eul.
.br
.br
.******************************************************************************
:h2 res=88 id=88 global.Adjust object colours
:i2 refid=bitmap.Adjust object colours
:p.In previous versions of Maul Publisher, this dialog was part of the bitmap handler,
and could only adjust btmap colours.
:p.Use this dialog to adjust an objects colour range and brighness. You can also use the
settings in this dialog to create some interesting special effects. This dialog enables you
to alter the colours of the currently selected object. If several frames are selected, every
object in every selected frame will be adjusted together.
:p.The dialog may not be able to affect every object type. Black and white (1bit per pixel)
bitmap images, for example, cannot be affected until they have been converted to at least a
16 colour bitmap.
:p.The dialog is made up of two separate windows that can be moved independantly. This enables
you to move the sample image out of the way so that you can see the original image underneath.
The sample window is automatically closed when you close the window containing the controls.
:p.Although the sample window updates automatically, a button is provided to refresh the
sample image. This is not normally necessary as it happens automatically.
:p.:hp2.Contrast, brightness, and colour cast:ehp2.
:p.Most of these controls are fairly obvious. You may find that the colour brightness controls
are more useful than the colour cast controls when the black and white colour balance is ok.
:p.:hp2.Colour vectors:ehp2.
:p.Colour vector controls work using the CMYK (:hp2.C:ehp2.yan, :hp2.M:ehp2.agenta,
:hp2.Y:ehp2.ellow, blac:hp2.K:ehp2.) colour spectrum. This has some important side
effects&colon.-
:ul.
:li.The black and white (K) channel is not affected.
:li.In CMYK every colour is represented as a K channel and only two out of three colour
channels. This means that the colours can be treated as x and y vectors.
:eul.
:p.:hp1.Rotating colour vectors:ehp1.
:p.You can rotate the individual colour vectors. A red vector can be rotated towards magenta,
or towards yellow. The diagram below shows an example red colour vector.
:p.:artwork name='colvect.bmp' align=left.
.br
You can&colon.-
:ul.
:li.Rotate :hp2.Red:ehp2. between magenta and yellow
:li.Rotate :hp2.Green:ehp2. between yellow and cyan
:li.Rotate :hp2.Blue:ehp2. between cyan and magenta
:eul.
:hp1.Scaling colour vectors:ehp1.
:p.You can scale the individual colour vectors. A vector can be made larger or smaller. The
image below shows the effect of the red colour brightness control.
:p.:artwork name='redeff.bmp' align=left.
.br
:p.Note that the vectors can overlap to some extent, especially after rotating them. The
controls will tend to affect each other as well as some colours you would not expect. So the
red controls can affect some shades of green, for example.
:p.:hp2.Application order:ehp2.
All the controls are applied to each bitmap pixel in a specific order. This order may help to
explain some of the ways the controls might interreact.
:ol.
:li.Contrast
:li.Brightness
:li.Gamma
:li.Colour contrast (pure colours can be adjusted to an equivalent gray shade)
:li.Red vectors
:ul.
:li.Red colour vector
:li.Red colour gain (colour brightness control)
:eul.
:li.Green vectors
:ul.
:li.Green colour vector
:li.Green colour gain (colour brightness control)
:eul.
:li.Blue vectors
:ul.
:li.Blue colour vector
:li.Blue colour gain (colour brightness control)
:eul.
:li.Red colour cast
:li.Green colour cast
:li.Blue colour cast
:eol.
:p.Click on 'Apply' to apply the new bitmap colours, and 'Exit' to exit the dialog when you
are finished.
.br
.br
.******************************************************************************
:h2 res=87 id=87 global.Embed fonts into a document
:i2 refid=tools.Embed fonts into a document
:p.Use the embed fonts dialog to embed fonts into a document.
:p.:hp2.About embedded fonts:ehp2.
:p.You can choose to embed fonts in order to make it possible to view or print a document on a different computer
that may not have the required fonts installed.
:p.Fonts are usually subject to a copyright. This copyright may specifically prevent you from distributing the font
with your document. If the font itself is marked as licensed, it will not be shown in the list of fonts to embed.
:p.Even if a font is not marked as licensed, it may still be a breach of copyright to embed it into a file. Please
make the effort to check first!
:p.:hp2.The embed fonts dialog:ehp2.
:p.The embed fonts dialog consists of two lists. The one on the left is the list of all available fonts. Fonts that are
used by the document are coloured red. Only fonts not embedded in the file are shown here.
:p.The righthand list shows those font that are to be embedded in the file.
:p.You can use the arrow buttons to copy selected files from one list to the other. The red arrow button is used to copy
all fonts marked in red (used by the document) into the list of files to embed.
:p.Use the install button to permanently install selected embedded fonts on your computer. This takes place the 
instant that you click the button.
:p.When you click on the 'Ok' button, both lists are processed in order to embed or remove fonts from the file. If you
are about to delete an embedded font that is not available on your system you will get a warning message. If you ignore
this warning, the required font to view or print the present document will no longer be available, and you may well see
an additional warning message when the screen is refreshed.
.br
.br
.******************************************************************************
.*  Options Menu
.******************************************************************************
:h1 res=90 id=90 global.Options Menu
:i1 id=options.Options Menu
:p.This menu is used to.-
:sl.
:li.:link reftype=hd res=93.Register Maul:elink..
:li.:link reftype=hd res=95.Save printer setup:elink..
:li.:link reftype=hd res=204.The Colour Palette:elink..
:li.:link reftype=hd res=94.Global style settings:elink..
:li.:link reftype=hd res=96.Keyboard Accelerator Keys:elink..
:li.:link reftype=hd res=91.Enable snap:elink..
:li.Set :link reftype=hd res=92.Snap Settings:elink..
:esl.
:lm margin=1.
:p.Other options may be added by various handlers. These are not described here. For further information
see the help provided by the relevant handler.
.br
.br
.******************************************************************************
:h2 res=93 id=93 global.Registering Maul Publisher
:i2 refid=options.Registering Maul Publisher
:p.If you are not a registered user, all your printouts will be marked as 'Unregistered' after
the first page.
:p.If you wish to use Maul Publisher after your trial period has ended, you must
purchase a licence for Maul Publisher in order obtain a registration code.
:p.Please make the effort to register as it is the only way that we afford to support and
further develop this product. Registrations are usually valid until the product undergoes
major changes, or until a reworking of the security system is required due to piracy.
:note.:hp2.The registration code is for you only and must not be divulged to a third party.:ehp2.
:p.:hp2.Via Internet:ehp2.
:p.Maul Publisher for Windows is directly available from Maison Anglais. The fastest way to
place an order is to navigate to
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/php/product.php?MAULE200'.
http&colon.//www.manglais.com/subs/php/product.php?MAULE200:elink., and
click on the 'Buy Now' button. We accept
US$ payments for Visa, Mastercard, and JCB cards. Payments are accepted via an SSL secured
payment system for maximum safety.
:p.:artwork name='cards.bmp' align=left.
.br
:p.For other distributors, please see the RESELLERS.DOC file installed with the application.
.br
.br
.******************************************************************************
:h2 res=95 id=95 global.Save printer setup
:i2 refid=options.Save printer setup
:p.Selecting this menu item saves the current page setup as Maul's default. Every time the program is
started, it will start with this default.
:p.:hp2.Printer name:ehp2.
:p.The name of the printer to use is saved. This will then be the default printer that the application
starts with. You can of course use any installed printer, but the application will start with the saved printer.
:p.The actual printer name is not normally saved with the publication.
:p.:hp2.Printer job properties:ehp2.
:p.Printer job properties include the page form, the print quality, the colour settings, and in fact
everything that you can set in the job properties dialog. Only the actual page information is normally saved
with the publication. It thus pays you to set all the job properties you normally require before saving the
printer setup.
:p.:hp2.Other settings:ehp2.
:p.In addition to the specific items mentioned above, information from the following dialogs is also saved&colon.-
:p.:link reftype=hd res=41.Page setup:elink.
:p.:link reftype=hd res=42.Page margin setup:elink.
:p.:link reftype=hd res=51.Units of measurement:elink..
.br
.br
.******************************************************************************
:h2 res=94 id=94 global.Global style settings
:i2 refid=options.Global style settings
:p.Use this dialog to adjust the way Maul publisher works. All the options
apart from the Startup options are immediately changed when you click on 'Ok'
to exit the dialog. Startup options will require a restart.
:p.:hp2.Notes:ehp2.
:p.Some of these options can be set separately for individual files. These local style settings
override the global ones. Local settings include&colon.-
:ul.
:li.Data path settings
:li.Offline settings
:li.Boundary settings
:eul.
:p.:hp2.Startup:ehp2.
:p.Depending on which languages you have installed, you can select the
language Maul uses. Changing the language will cause the application to try
and shutdown.
:p.By default, Maul starts maximised. You can alter this behavior by unchecking the
'start maximised' button.
:p.Enable 'split screen mode' if you are using Maul with a dual monitor setup.
The option will reduce the default width to match just the first monitor.
:p.:hp2.Data path:ehp2.
:p.As installed, common user files are kept in the '.\etc' directory where the program was
installed. You can change this user path as you require. This means that you can keep
style sheets, master pages, frame clipart, user dictionaries, etc. separate for each
publication, or in a common place when working with a network. The default user path is
initially stored in the current folder as 'DTP_data'. You can change this path to be anywhere
you like.
:p.By checking 'Use current project folder if available', common user files are stored with
a project. See :link reftype=hd res=31.Managing projects:elink. for further details.
:p.:hp2.Offline:ehp2.
:p.You can enable bitmaps to be stored in a separate folder with the same name as the
current publication. This system style does not affect existing publications, i.e. all the
existing bitmaps will be either online or offline, and altering this mode will not change
them. Only new bitmaps will be dealt with according to this mode.
.br
You should therefore enable this mode when you start a new publication, and not halfway through.
:p.:hp2.Palette:ehp2.
:p.The colour palette is used to store colours common to your publication. Colours are
stored in the file, and can be loaded at startup.
See :link reftype=hd res=204.The Colour Palette:elink. for more information.
:p.Browse for a colour palette file by using the 'Browse' button. The selected palette will
be loaded automatically for all new files as long as the checkbox is enabled. Existing files
are not affected by this option.
:p.:hp2.Tracking handles:ehp2.
:p.You can alter the size of the tracking handles. The size of the tracking handles also
affects the accuracy with which you have to click on frames.
.br
Tracking handles are used for editing and selecting frames.
:p.:hp2.Fonts:ehp2.
:p.Two dialog font sizes are available. The larger font is
the '10.System Proportional' font used in OS/2 Warp 3 and 4 and is
ISO9241 or DIN66234 compatible according to the IBM documentation.
:p.More recently, it has become popular to use the '8.Helv' font in
dialogs. Select the 'small font' button to use that size for all dialogs.
:p.:hp2.Buttons:ehp2.
:p.As the toolbar buttons have to support features not found in the
default button controls, Maul implements toolbar buttons as a custom control.
:p.Four toolbar button styles are available&colon.-
:ul.
:li.Flat buttons have no border until the mouse hovers over them.
:li.Light buttons are the default super flat buttons used in earlier
versions of Maul Publisher.
:li.Retro buttons look similar to the eComStation default buttons with a
dished appearance.
:li.Pluto buttons are domed buttons with a rounded edge.
:eul.
:p.:hp2.Tool tips:ehp2.
:p.Enable popup tool tips to get a little help text popup whenever the mouse cursor rests
over a button or other item.
:p.:hp2.Boundary:ehp2.
:p.By default, excluded boundaries are determined for every second pel down the height of a
string.  Enabling 'faster boundary maths' reduces this to just three determinations, the top,
the middle, and the bottom of the string. It is slightly less precise (text can run over
corners of excluded objects), but it is much faster. If your publication uses rectangles or
gentle curves only, you can safely use this option, otherwise you must check that text does
not run over excluded objects.
:p.:hp2.Printjobs:ehp2.
:p.Please do not disable either of these options unless you have a printing problem.
:p.The print progress popup is a simple threaded window that allows you to abandon a print job.
If it is disabled you can still abandon a print job by holding down the escape key for a moment.
:p.Dynamic printjobs are used to select the correct printer job properties for the
current document. Disabling this means that you have to set the correct 'Job properties'
in the 'Print...' dialog each time you print a document. If you have a document produced with
an older version of Maul Publisher, you should reset the page settings and save the document
before printing.
.br
.br
.******************************************************************************
:h2 res=96 id=96 global.Keyboard Accelerator Keys
:i2 refid=options.Keyboard Accelerator Keys
:p.:hp2.Altering Keyboard shortcuts:ehp2.
:p.Select 'Edit keyboard shortcuts...' to alter the keyboard shortcuts available.
:p.Choose a handler or the main program by selecting the appropriate notebook tab,
then choose a menu item in the left listbox. You will notice that as you select a menu item,
the corresponding keyboard shortcut is shown in the right hand listbox and the associated
checkboxes.
:p.Next, select the appropriate control, alt, or shift checkboxes. These determine which additional
key you need to press with the actual shortcut character.
:p.Finally, select the keyboard shortcut required.
:p.As you alter the settings, the program checks that the selection is not already in use.
This can prevent you from changing the checkboxes unless you initially select
<none>.
:p.Beware that once you have chosen a key combination for a shortcut in a text handler, that
particular key combination is no longer available for typing text.
:p.Maul contains a huge number of menu items, and you ought to plan your changes carefully.
The new keyboard settings are kept in the common user path. The file is called 'maulkeys.act',
and it will pay you to back it up if you make large numbers of changes.
:p.You will find that certain keys are locked. Obvious ones include Ctrl+Alt+Del, and such
like. Others have a lock, but allow you to append a different shortcut. These are the
copy, cut, paste, and delete keys.
:p.If you hit the 'Reset all' button, the program will reload it's inbuilt shortcuts, and
save them in the 'maulkeys.act' file. Because this will cause all altered settings to be reset,
you will get a confirmation message.
.******************************************************************************
:h2 res=91 id=91 global.Enable snap
:i2 refid=options.Enable snap
:p.Select the 'Enable snap' menu item to make Maul snap the outline of frames to your page boundaries,
marking grid, measurements, etc. Snap is enabled by default.
:p.If snap is disabled, you can create freeform shapes, but they may not have the required precision.
:p.You can momentarily turn off the snap by holding down the spacebar.
.br
.br
.******************************************************************************
:h2 res=92 id=92 global.Snap Settings
:i2 refid=options.Snap Settings
:p.Use the snap settings dialog to adjust how the mouse cursor snaps to the various
subdivisions available.
:p.The settings you make this dialog are saved to the file when you
click on 'Ok'. This allows you to have different settings for different publications.
:p.If you want to have these settings applied to all new publications, click on the
'Save' button. This writes the settings to the initialisation profile or registry, and ensures
that all new publications default to these settings.
:p.:hp2.Snap to...:ehp2.
:p.You can snap to your marking grid and boundaries, to the current units of measurement on
the :link reftype=hd res=803.rules:elink., or to user defined markers, or all three.
:p.:hp2.Units of measurement...:ehp2.
:p.When you enable snap to units of measurement, you are given a choice based on the current
rule mode.
:p.:hp2.Snap distance:ehp2.
:p.Set the distance in printer pels before the cursor is 'snapped' to a fixed position. The
effects of snap distance, printer pels per inch, and snap type, tend to be interactive so some
experimentation may be required.
:p.:hp2.User defined markers:ehp2.
:p.You can add horizontal or vertical user defined markers by clicking on the ruler bars.
These allow you to line up a series of shapes, for example. See
also&colon.-
:p.:link reftype=hd res=803.The ruler bars:elink.
.******************************************************************************
.*  Help Menu
.******************************************************************************
:h1 res=110 id=110 global.Help Menu
:i1 id=help.Help Menu
:p.:hp2.Adaptive help system:ehp2.
:p.Maul publisher uses an adaptive help system to provide help not only for the main publisher program, but
also for any handlers that are currently installed. The help contents and help index pages for example will
always show these pages for the currently selected handler. To deselect all handlers, click on an empty part
of the main window. This deselects all frames. If you now choose the help contents menu item, you will get the
contents page for the main publisher program. The help menu always shows the name of the handler for which help
is currently enabled.
:artwork name='adaphlp.bmp' align=left.
:p.:hp2.Tricks&colon.- Getting more help:ehp2.
:p.Position the cursor over a ruler bar, button bar, button, or whatever you like, and then press F1. You will get
information about the object beneath the cursor.
:p.To get help on a particular toolbar pushbutton, move the cursor over the button. The status bar help window will
show a short help for that button. Press F1 to get more help for the button.
:p.:hp2.Tricks&colon.- Help on menu items:ehp2.
:p.To get help on a menu item, the menu item needs to be highlighted. You may not want to click on the menu item until
you have read the help page.
:p.Click on any submenu to switch focus to the menu. Try the 'View' submenu. Use the keyboard cursor keys to move
the highlighting to a menu item. You can navigate to, and highlight, any menu item or submenu by using the cursor keys.
Press F1 to get help on the menu item.
:p.By not using the mouse, you have avoided selecting the menu item before obtaining help. This trick should work for
most OS/2 programs.
.br
.br
.******************************************************************************
:h2 res=113 id=113 global.Help for 'How Do I' help items
:i2 refid=help.Help for 'How Do I' help items
:p.The 'How Do I' help submenu is a simple help tagging system capable of regrouping the most
useful help items out of the many manuals for Maul Publisher.
:p.You can add your own help entries. You do so either by editing the text file
'favorite.txt' in the .\etc path where maul is installed, or you can get the
'Add How Do I item' dialog to help you.
:p.:hp2.Add How Do I item using a text editor:ehp2.
:p.The file 'favorite.txt' is a simple text file containing one line for each entry of the
'How Do I' menu. The only way to rearrange or delete entries in the 'How Do I' menu is
to exit maul and manually edit this file.
:ul.
:li.Lines starting with < are comments.
:li.Lines starting with > are menu entries and consist of five entries separated by commas.
:li.Entries containing commas can be added using "quotes".
:eul.
:p.Here is a line showing the five entries...
.br
>name, type, helpid, titleid, libraryid
:p.The entries are used as follows&colon.-
:ol.
:li.:hp2.name:ehp2.. This is the string that appears as the menu item.
:li.:hp2.type:ehp2.. This can be the name of a handler, such as "CONTENTS, Plain text".
Note the use of quotes, the string contains a comma! If it is left empty, the helpfile is
presumed to be the main manual 'Using Maul Publisher'. Last, you can also specify any helpfile
by preceeding the name with an !, such as '!maul.hlp'.
:li.:hp2.helpid:ehp2.. This is the numeric resource identifier of the help panel required.
:li.:hp2.titleid:ehp2.. This is the numeric resource identifier of a title string. All handlers
require a unique value here.
:li.:hp2.libraryid:ehp2.. This is the numeric resource identifier of a help library. All
handlers require a unique value here.
:eol.
:p.The original 'favorite.txt' file contains comments showing the correct resource
identifiers for all handlers, as well as the main program. Where you specify an actual help
file, the titleid, and libraryid values should be set to -1.
:p.:hp2.Add How Do I item using the dialog:ehp2.
:p.At the time of writing this the dialog only works with IBM's original VIEW application. If you
use NEWVIEW as supplied with eCS1.2, this option is no longer functional. It is to be hoped that
a workaround will become available in due course.
:p.The dialog is the simplest way of adding new entries to the 'How Do I' menu. The menu will be
disabled until you have opened the actual help page you wish to add. You cannot add a contents or
index page to the 'How Do I' menu.
:p.When the dialog is opened, all the correct entries are filled in for you. Generally, it is
better to change the description to something more useful.
:p.Click on 'Ok' to add the help entry onto the end of the 'How Do I' menu.
:p.In order to delete items, or rearrange items, you should exit maul and edit the 'favorite.txt'
file manually.
.br
.br
.******************************************************************************
:h2 res=111 id=111 global.Help for keyboard shortcuts
:i2 refid=help.Help for keyboard shortcuts
:p.The following keys are available within Maul. The most common keys are listed, but keys specific to
handlers are not listed. Select a frame and handler you require information on, and then try keys help again. The help
menu will indicate which handler help is currently selected.
:p.If no frame is selected, this main keys help for Maul Publisher is shown.
:p.:hp2.General key usage:ehp2.
:p.Please note that Maul distinguishes between Alt, and Shift+Alt, as well as Alt, and AltGr. If your keyboard does not
have the AltGr key, you will have to select a different keyboard map in order to access extended character codes. For the
US keyboard (103) - us, you can switch to the US international keyboard (103i) - usinter (OS/2 - ux). For further
information see the 'Keyboards and Code Pages' book for Warp4 (order no 29H3183, S29H-3183-00).
:p.If you do have an AltGr key, you can access extended characters either directly or by holding down the AltGr key and
typing the decimal number of the character required on the numeric keypad. So for example AltGr+98 equals 'b'. This
should work regardless of the NumLock state of the keyboard.
:p.If you really cannot alter you keyboard settings, you can use the text handler 'Insert character...'
dialog to insert any character available in the font.
:p.These are the default settings, and they may be altered by the
:link reftype=hd res=96.Keyboard Accelerator Keys:elink. dialog.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
.******************************************************************************
:h2 res=112 id=112 global.Help for handlers
:i2 refid=help.Help for handlers
:p.Use the 'List handlers' menu item to list the installed handlers. Select a handler from the dialog,
and press help to get help about that handler.
:p.Maul is made from a suite of handlers, each one dedicated to a particular task. All but the null handler
and page handler are in separate modules that can be added and removed at will. The set of default handlers
supplied with Maul are sufficient for basic desktop publishing. Of course, other handlers can be added to
Maul as and when they become available. If you are a programmer, you can even create your own.
:p.To obtain the necessary information to develop your own handler, point your browser at
.br
:link reftype='launch' object='netscape.exe' data='http://www.manglais.com/subs/signup.html'.
http&colon.//www.manglais.com/subs/signup.html:elink..
.br
Developers are required to leave their name and email address in order to be kept up to date.
.br
.br
.******************************************************************************
:h2 res=115 id=115 global.Program statistics
:i2 refid=help.Program statistics
:p.Click on the 'Help->Statistics...' menu item to get information about the internal state of Maul Publishers memory.
:p.The message title is the current file name.
:p.Information is provided about:
:ul.
:li.The name of the required printer
:li.The name and details of the required printer form.
:li.The number of pages, frames, and objects, in the document
:li.The orientation and quality settings of the required printer form.
:li.Information about any problems the application may have with this printer.
:li.The amount of total memory available for each memory buffer. Maul uses two large memory buffers,
one to contain file data and the undo buffer, the other to hold transient information for import, export, printing,
painting, and so on. Additional small memory blocks may be allocated from time to time (...using malloc and free).
:li.The file buffer size. The file buffer size should be the file size added to the undo size.
:li.The workbuffer size (normally zero as this is used for transient data only).
:li.The size of the undo buffer.
:li.The size of the file. 
:eul.
.br
.br
.******************************************************************************
.*  Switch List
.******************************************************************************
:h1 res=100 id=100 global.The switch list
:i1 id=switchlist.The switch list
:p.Maul allows you to switch between different programs. Rather than using a Multiple Document Interface (MDI), Maul
takes advantage of OS/2 Warp's multitasking environment. You can run as many copies of Maul (or any program for that
matter), and switch between them using the switch list. Clicking on a menu item in the switchlist immediately transfers
control to another program. The currently selected session entry is disabled because you cannot switch control from a
session to itself.
:p.If the other application does not have a switch list, you can usually get one by simultaneously clicking the left and
right mouse buttons on an empty area of the desktop, or by pressing Ctrl+Esc. But then, you probably know that already.
:p.:hp2.Relax, this won't hurt!:ehp2.
:artwork name='syringe.bmp' align=left.
:p.At first, you may have the impression that having multiple copies of a program running at the same time takes
excessive memory resources. In fact, nothing could be further from the truth.
:p.When Warp starts a second copy of a program, only a new data area is initialised. The same executable code is re-used
for as many copies of the program as required. This works because all modern compilers create what is called 're-entrant'
code. The same is true for resources such as dialogs etc., only one copy needs to be loaded in memory. The application
does not need to keep track of which data area it is currently working with, and is therefore much simpler, faster, and
smaller.
:p.As multiple copies of a program are run, so only the data and stack pointers are switched. Technically, this is far
more effective than a multiple document interface. OS/2 Warp is far better at handling multiple documents than any
MDI could ever be. Furthermore, all copies of a program are still running, ie while you edit in the foreground, another
program could be printing in the background. If any one program should crash for any reason, the rest will usually
remain unaffected.
.br
.br
.******************************************************************************
.*
.*
.*
.*  Dialog Item Help
.*
.*
.*
.******************************************************************************
.******************************************************************************
.*  Color dialog
.******************************************************************************
:h1 res=200 id=200 global.Setting a color (default handler)
:i1.Setting a color (default handler)
:artwork name='edswatch.bmp' align=left.
:p.You get to this dialog from the :link reftype=hd res=201.Select colour:elink. dialog. You may
also be able to click on a blank portion of the :link reftype=hd res=204.Colour Palette:elink..
:p.This dialog is used to directly alter a color. You can select any mixture of red, green,
and blue to set the colour you desire. A coloured box to the left of the dialog extends right out to the edge and
can be used for comparison purposes.
:p.Use a combination of the luminance, saturation, and hue, sliders to change the colour, and the red, green,
and blue colour spin controls to make fine adjustments.
:p.:hp2.Colour capture:ehp2.
:p.Click on the :artwork name='syringebut.bmp' runin. button, and the mouse cursor will change to a crosshair.
You can grab a colour from anywhere on the screen by clicking on it.
:p.Often, colours are made up of a mixture of disparate colours, so just grabbing one pixel off the screen will be
completely inappropriate. Instead, drag out a lasso rectangle with the left mouse button. When you let go, the colour
returned will be the average colour of the selected rectangle. This is particularly useful when grabbing colours from
pictures.
:p.:hp2.Naming colours:ehp2.
:p.You can use the combination dropdown listbox to save a colour by name. Just overtype the automatically generated name
with your own, and click the add button. If a named colour has been previously saved, you can select it, and then remove it.
:p.:hp2.Spot colours:ehp2.
:p.You can mark a named colour as being a spot colour. If the colour handler supports it, you can create individual colour
separations for spot colours. Named colours are output as process (mixed) colours until you choose a substitute colour in
the 'Screen as' list. When producing colour separations, the spot colour is output in it's own layer, using the substitute
colour.
:p.Named colours used to populate the colour palette in the tools menu.
:p.Maul does not support shading with spot colours at this time. You should reserve spot colours for solid colour
overprinting.
:p.Named colours, including spot colours, are saved in the publication to ensure that the document remains portable. You
can save the :link reftype=hd res=204.colour palette:elink. information out to a separate colour table file.
:p.:hp2.Printing:ehp2.
:p.Please note that your printer will probably not be capable of printing every possible colour
available in an RGB spectrum, as printers usually use the CMYK spectrum, which provides slightly
fewer colours. Unless you have a colour handler installed, you will not be able to produce colour separations. Spot colours
are only treated as such when producing colour separations, otherwise they are treated just like ordinary colours.
.******************************************************************************
.*  Color list dialog
.******************************************************************************
:h1 res=201 id=201 global.Selecting a color (default handler)
:i1.Selecting a color (default handler)
:artwork name='selcol.bmp' align=left.
:p.This dialog uses a slightly odd method of selecting colours. Essentially, the left button selects
foreground colours, and the right button selects background colours. That is, unless you have changed
the mouse mappings!
:p.If you wish to select a totally different colour, you can select the colour on the colour wheel.
Depending upon which mouse button you pressed, the colour selection will be updated.
:p.If you just wish to darken or lighten the shade of a given colour, you can do so by selecting the
desired colour from the colour listbox on the right.
:p.By clicking on the colour listbox with the left mouse button, you select a foreground colour. By clicking
on the colour listbox with the right mouse button, you select a background colour.
:p.The last item in the colour listbox is always a transparent colour. This colour may not be used by all
handlers.
:p.At the top of the dialog is a list box showing the named colours found in the currently loaded
:link reftype=hd res=204.colour table:elink. (if any).
:p.The coloured squares on the bottom right of the dialog indicate the selected foreground and background
colours. By clicking on the required square with the left mouse button, you can
:link reftype=hd res=200.directly edit:elink. the RGB components
of the colour of the square, as well as load and save named colours.
:p.Note that you cannot edit a transparent colour (indicated by a shading pattern).
Click on the twoheaded arrow button to swap foreground and background colours.
:p.:hp2.See Also:ehp2.
:p.:link reftype=hd res=200.Setting a color:elink.
:p.:link reftype=hd res=204.Load or save Colour Tables:elink..
.br
.br
.******************************************************************************
.*  Common Stylesheets dialog
.******************************************************************************
:h1 res=205 id=205 global.Common Stylesheets
:i1.Common Stylesheets
:p.Maul uses a common stylesheet format to store styles. Common stylesheets have a hierarchical
storage structure&colon.-
:ul.
:li.Stylesheets are stored in style files with a '.ssh' extension.
:li.Each style file can contain several stylesheets.
:li.Each stylesheet can contain a mixture of styles and stylesheets.
:eul.
:p.What this means in practice is that a single stylesheet can contain both background and text styles.
When you apply a style, the correct stylesheet is read out of the file.
:p.A stylesheet may contain child stylesheets. So a frame stylesheet, for example, may contain stylesheets for
objects such as text, backgrounds, borders, etc.. When you have the border handler selected, you can set the border
style based on the border child stylesheet of the frame style. This function is virtually invisible to the user.
:p.When you save a new stylesheet for the border into the same file that contains the above frame stylesheet,
the new border stylesheet will be read by the border handler, and the old border child stylesheet will be read by the
frame handler.
:p.In other words, you cannot delete or modify a child stylesheet, but you can override it for the matching
object handler.
:p.In the common stylesheet dialog, child stylesheets are shown indented from their containing parent stylesheets.
Several stylesheets may be shown with the same name, and each will have a matching icon to show which handler
they belong to. New stylesheets are always added to the front of the style files, so newer styles will override older
ones.
:p.Some handlers allow default styles to be set. If such a default is set, the style will be applied the moment the
handler creates its object. Instead of asking for a border width, the border handler will immediately apply the
selected default style.
.br
.br
.******************************************************************************
.*  Print form dialog
.******************************************************************************
:h1 res=202 id=202 global.Editing a printer form
:i1.Editing a printer form
:p.Printer forms are a way of telling Maul what kind of printer form you would like to have, even if your
printer does not support such a form. The information on a new printer form is filled in from the current
printer form. All publications keep a record of their own printer form in order to know what size the
page has and when to perform any required scaling.
:p.Printer forms are :hp2.not used when printing your final document:ehp2.. They are used as a way of creating a form for
a printer you don't actually have. When you print your document, you must choose a real form known to the printer
driver. Printer forms can be used to fool the scaling mechanism into rescaling the document when printing, but this
is not advisable unless you know what you are doing.
:p.Take the following example&colon.-
:fig.
My landscape A4 printer page is 2400 x 3357 pels, and 300 dpi.
Its size is 210mm x 297mm.
The left and top margins are 11.76mm and 3.4mmm respectively.
:efig.
:p.If I set the size to 21.0mm x 29.7mm, the left and top margins to 1.176mm and 0.34mm, and the x and y dpi to 3000,
then I will have created a page approximately the size of a postage stamp.
:p.If I then print this on an A4 sheet, the system will scale the whole thing down to the requested size. Please remember
that this is :hp1.cheating:ehp1..
:p.:hp2.Forms:ehp2.
:p.Printer forms are real files in memory, and can be saved and deleted as you wish. Printer forms are kept in
the common user path. Initially, the printer form is given a default form name. You should to give a new
name to your form, although you can overwrite an existing form if you wish.
:p.Once you have created a printer form, the printer setup dialog will show this form in it's listbox. If you
use a printer form to determine the shape of your publication, the printer form dialog is also used for the
printer setup dialog.
:p.:hp2.Measurements:ehp2.
:p.The size of the printer page and it's unprintable margins correspond to the actual size of the piece of
paper you are printing on. Many printers cannot print right to the edge of the printer page, so these
measurements enable the application to centre the printable area on the page.
:p.:hp2.Pixels:ehp2.
:p.The printable area for a particular printer is usually specified as a number of pels or dots. If you are
creating a publication for a specific photo engraving machine, for example, you can probably
fill in the information exactly. In this instance you would specify the exact number of dots across and
along the printable area for that machine, as well as the exact number of dots per inch.
:p.If you don't know exactly the size of your printer form in pels, you can specify it as mm, inches or
points. The 'Recalc' button will work out what this does to the margins.
:p.:hp2.Orientation:ehp2.
:p.If you wish to swap the orientation of your printer form, just click on the 'Swap' button, and the
x and y parameters will be swapped for you.
.br
.br
.******************************************************************************
:h1 res=114 id=114.Drag and drop in Maul Publisher
:i1 id=drag.Drag and drop in Maul Publisher
:p.From V2.22, Maul supports drag and drop.
:p.:hp2.Drop publications:ehp2.
:p.if you drag and drop Maul publications onto the application window, you will start a new
instance of maul, with the new publication open within it.
:p.:hp2.Via the <NULL> handler:ehp2.
:p.The <NULL> handler is used whenever another handler is unavailable. It is generally the
responsibility of the <NULL> handler to associate object handlers with frames. It is the
<NULL> handler that paints the little '?' icons on all the unused object layer buttons.
:p.If you create a frame, and then switch to one of the  unused object layer buttons, you can
drag recognised file types from the desktop into the selected frame. If no frame is selected,
drag and drop is restricted to drag and drop for the main application.
:p.:hp2.To an existing object handler:ehp2.
:p.You can copy file types recognised by the active object handler from the desktop into the
selected frame. If the file type matches the currently active object handler, the data in the
frame is replaced by the data in the file.
.******************************************************************************
:h1 res=203 id=203 global.Page Mismatch. What to do?
:i1.Page Mismatch. What to do?
:p.:hp2.Page Mismatch:ehp2.
:p.If you are trying to load a page into your publication, and that page was taken from a publication with a different
page shape or size, you will be asked what to do about it.
:p.Normally, if the page is approximately the same shape, Maul will successfully rescale the page. If the page is not at
all the same shape, expect to have to do a lot of tidying up. Alternatively, you can abandon the page loading altogether.
:euserdoc.
