.******************************************************************************
.*  Maul Publisher Tables Handler Help File
.*   Peter Koller 2003, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul Tables Handler Help
:docprof toc=1234.
:h1 res=1 id=1 global.About Maul Tables Handler
:i1 id=top.About Maul Tables Handler
:p.:artwork name='main.bmp' align=left runin.:font facename='Tms Rmn' size=24x24.
:hp2.Maul Tables Handler:ehp2.
:font facename=default.
:p.
.br
.br
:p.:hp2.Overview of the Maul Tables Handler:ehp2.
:p.The tables handler is used to create tables such as the one above. It
arranges any combination of text and images into an array of cells. By
allowing a block of text or an image to cover more than one cell, complex
effects can easily be generated.
:p.Text blocks in the tables handler are always formatted into rectangles. The
disadvantage is that text is not able to flow around frames placed on top, but
the advantages include the ability to centre text both vertically and
horizontally.
:p.:hp2.Table selection:ehp2.
:p.You can select a table cell by clicking on it. The cell will be surrounded
by a black border. You can select a range of cell by dragging the mouse cursor
over the range you require. Selection bars are drawn along the top and left of
the table to allow you to select a row, a column, or the entire table. You can
hold down the shift key while clicking on a cell in order to change the size
of the current selection.
:p.:hp2.Table organisation:ehp2.
:p.Each element of a table is held in a container. Each container may hold a
background or border, a bitmap or metafile, or some text. By manipulating
containers, you are able to arrange how the table is built up on the page.
Whenever a container completely covers a matching container, the container
beneath is automatically deleted. You can change the size of an existing
container at any time by using the 'Edit Container range' dialog.
:p.Containers are created the instant you change something. For example, a new
background container will be created automatically when you change the colour
of a selection. A new border container is created when you change a border
setting. You can edit an existing container by turning off insert mode.
.br
You can create a series of text cells by typing something. Each time you click
enter, the selection moves to the next cell. You can create a text block
covering several cells by selecting a range of cells and pressing the text
edit mode button.
:p.The text editor employed by the tables handler is virtually identical to
the one used by the text handler, so most of the features found there, such as
inline images, mail merge etc, also work here.
:p.A feature not found in the text handler is the ability to vertically centre
text, so if you need this feature, a table will do the trick.
:p.
.br
.br
:p.Created by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
.br
.br
:p. Copyright 2003 Peter Koller, Maison Anglais. All Rights Reserved.
:p.For details of the Licence Agreement, please see the copyright notice provided in
Maul Publishers main manual.
.br
.******************************************************************************
:h1 res=2 id=2 global.Selecting table cells
:i1 id=select.Selecting table cells
:p.The table is made up of a series of dashed lines to allow selection and
resizing operations.
:p.:hp2.Cell sizing:ehp2.
:p.When you move the mouse cursor over a dashed sizing line, the cursor will
change to either a vertical or a horizontal sizing cursor.
:p.To change the width of a row or column, hold down the left mouse button on
a dashed sizing line and drag it in the direction you want to go. When the
width of a row or column is equal to zero, it is automatically deleted. Rows
or columns that move outside the frame are also deleted.
:p.If you hold down the shift key while dragging a dashed border, borders to
the right or beneath are also moved.
:p.You can drag new rows or columns into the table from the right or bottom
edge of the table.
:p.Heights and widths of rows and columns are stored as relative values, so
that if you change the size of the frame containing the table, the widths of
all the rows and columns will also change. The table handler dows not allow
tables to be smaller or larger than the width or height of the containing
frame. You can reset selected range widths or heights, or add rows and
columns, using the 'Edit->Table size' menu items.
:p.:artwork name='select.bmp' align=left.
:p.:hp2.Cell selection:ehp2.
:p.The cell selection always consists of a cell selection and a range
selection. The cell and range selections can match. Initially, when nothing is
selected, almost all the menu items and buttons are disabled.
:p.You can select a cell by clicking on it. You can select a range by holding
down the left mouse button on a cell and dragging out the range of cells you
require. You can click on a range selector to select a row or a column,
holding down the shift key when clicking on a range selector enables you to
select several rows or columns at once. Click on the table selector, the
little black square on the top left, in order to select the whole table.
:p.Use the keyboard arrow keys to move a cell selection within a range
selection. Pressing <enter> or <tab> will also move the cell
selection, moving in whatever direction the selection moved last time. This
behavior should be familiar to anyone who has used a spreadsheet application.
:p.:hp2.Selection behaviour:ehp2.
:p.The table handler always starts in insert mode, so making any changes to
borders,  backgrounds, inserting images, etc, will always create a new
container the size of a range. The exception to this is text. Typing text will
create a container in the currently selected cell only. To create a container
the size of a selected range, you must explicitly create the range by clicking
on the text button, or by using the  'Edit->Edit text' menu item.
.br
.******************************************************************************
:h1 res=3 id=3 global.Containers explained
:i1 id=container.Containers explained
:p.:hp2.A table:ehp2. contains a sheet that is made up of a series of rows and
columns. The rows and columns enclose areas called cells. A range is simply a
rectangular selection of one or more cells.
:p.If you select a range and change it's colour, what you are actually doing
is to create a container to hold the colour fill information. A container can
be the size of a single cell, or a rectangular range of cells. This enables
you to have a text block covering a range of cells.
:p.There are many different types of containers available.
:ul.
:li.border containers
:li.fill containers
:li.bitmap containers
:li.metafile containers
:li.text containers
:li.frame clipart containers (..a set of frames copied from the frame handler)
:eul.
:p.When a new container completely overlaps a matching container beneath, the
container beneath is automatically deleted. This does not happen when you place
a text container over a fill container, the two types must match.
:p.Sometimes, you want to change an existing container in the background. If
you were to select the range of the existing container, you would wipe out any
containers lying on top. Another way of stating this is that you are changing
the z order of the containers. However, if you switch the cell :link reftype=hd
res=73.edit mode:elink. from 'Insert' to 'Update', you only need to
select a cell within the container you want to alter, and any changes you make
only affect the matching container. The z order is not altered, and no other
containers are deleted.
:p.When you select a range of cells and start typing, the handler behaves like
a spreadsheet. The text goes in the selected cell, and each time you press enter
or tab, you move to the next cell. A new container is created for each cell.
:p.If you select :link reftype=hd res=72.text edit mode:elink. while a
range is selected, a new container is created the size of the selected range.
This enables you to create a text block larger than a single cell. If you want
to change the settings for an existing text block, you must either switch to
text edit mode and select the text to change, or you must switch the cell
:link reftype=hd res=73.edit mode:elink. from 'Insert' to 'Update'.
:p.You can change the size of a container in the :link reftype=hd
res=36. Show/edit container ranges:elink. dialog. This dialog
shows only those ranges within the current selection. You must select the
whole table in order to edit all the containers, but be warned that a large
table can have an enormous number of containers.
:p.:artwork name='tbldesc.bmp' align=left.
.br
.br
.******************************************************************************
:h1 res=400 id=400 global.The button bar
:i1 id=butbar.The button bar
:p.The button bar provides rapid access to many of the tables handler features.
:p.:artwork name='insbut.bmp' runin.
 Insert mode button, see the
:link reftype=hd res=73.Insert mode:elink. menuitem help panel.
:p.:artwork name='txtbut.bmp' runin. Text mode button, equivalent to the
:link reftype=hd res=72.Edit text:elink. menuitem.
:p.:artwork name='fcolbut.bmp' runin. Change the fill (background) colour of
the selected range. You need to set at least a fill colour before the fill
becomes visible.
:p.:artwork name='fpatbut.bmp' runin. Change the fill pattern of the selected
range.
:p.:artwork name='fstybut.bmp' runin. Change the fill style of the selected
range.
:p.:artwork name='bcolbut.bmp' runin. Change the border colour of the selected
range. To get a border, it needs a colour, a width, and a style. You need
to set at least a suitable style before you see a border!
:p.:artwork name='bwidbut.bmp' runin. Change the border width of the selected range.
:p.:artwork name='bstybut.bmp' runin. Change the border style of the selected range.
:p.:artwork name='justbut.bmp' runin. Change the text justification of the selected cell.
:p.:artwork name='valignbut.bmp' runin. Change the vertical text alignment of
the selected cell.
:p.:artwork name='tcolbut.bmp' runin. Change the text colour of the selected cell.
:p.:artwork name='outlbut.bmp' runin. Text ouline mode.
:p.:artwork name='ulinbut.bmp' runin. Text underline mode.
:p.:artwork name='strkbut.bmp' runin. Text strikeout mode.
:p.:artwork name='subsbut.bmp' runin. Set text to substring.
:p.:artwork name='suprbut.bmp' runin. Set text to superstring.
:p.:artwork name='dropsbut.bmp' runin. Text dropshadow mode.
:p.:artwork name='fontsz.bmp' runin. Text fontsize selector. You can type an
unusual size into this combobox and press enter to set the font size.
:p.:artwork name='fontsty.bmp' runin. Set an available font style for the current font.
:p.:artwork name='fontsel.bmp' runin. Select a font.
:p.:artwork name='formatbut.bmp' runin. Reformat all text in the table. This
will recalculate the text positions in the entire table.
.br
.******************************************************************************
:h1 res=4 id=4 global.The Edit menu
:i1 id=editmnu.The Edit menu
:p.This menu provides all the basic functions of cut, copy, and paste, as well
as providing menu items for tasks specifically related to tables.
:p.Clipboard and related menu items
:ul.
:li.:link reftype=hd res=16.Restrict:elink. clipboard operations to a subset of the current selection
:li.:link reftype=hd res=12.Cut:elink. current selection criteria.
:li.:link reftype=hd res=13.Copy:elink. current selection criteria.
:li.:link reftype=hd res=14.Paste:elink. clipboard data
:li.:link reftype=hd res=15.Clear:elink. current selection criteria.
:li.:link reftype=hd res=74.Load:elink. frame clipart from a catalogue.
:li.:link reftype=hd res=17.Load:elink. data.
:li.:link reftype=hd res=18.Select:elink. whole table (or Select all text).
:eul.
:p.Container ranges
:ul.
:li.Show/edit :link reftype=hd res=36.container ranges:elink..
:eul.
:p.Table size
:ul.
:li.Set the :link reftype=hd res=35.table size:elink..
:li.:link reftype=hd res=37.Insert or delete:elink. a row or column.
:li.:link reftype=hd res=38.Equalise:elink. row or column spacing.
:eul.
:p.Insert mode
:ul.
:li.Set:link reftype=hd res=73.Insert mode:elink..
:eul.
:p.Inserting new text containers
:ul.
:li.:link reftype=hd res=72.Edit text:elink.
:lp.Text editor Features
:ul.
:li.Insert :link reftype=hd res=57.character:elink..
:li.Insert :link reftype=hd res=64.line flush break:elink..
:li.Insert :link reftype=hd res=53.object/settings:elink..
:li.Insert :link reftype=hd res=63.footnote/settings:elink..
:li.Insert :link reftype=hd res=75.equation/settings:elink..
:li.Insert :link reftype=hd res=46.control text:elink.
:li.Select :link reftype=hd res=41.merge row:elink.
:li.:link reftype=hd res=54.Find:elink. text.
:li.:link reftype=hd res=65.Count:elink. words.
:li.:link reftype=hd res=66.Check spelling:elink..
:li.Provide :link reftype=hd res=69.article information:elink.
:eul.
:eul.
:p.Removing
:ul.
:li.:link reftype=hd res=11.Remove:elink. handler.
:eul.
.br
.*-----------------------------------------------------------------------------
:h2 res=16 id=16 global.Restricting the clipboard data
:i2 refid=editmnu.Restricting the clipboard data
:p.Tables have the peculiar property of containing a wide variety of different
types of data. This makes it quite useful to be able to restrict the data
copied to the clipboard to a particular type. You might want to copy the text
from one table cell to another, for example, without copying across the
background colour and border settings.
:p.You can restrict the following operations&colon.-
:ul.
:li.cut data to clipboard
:li.copy data to clipboard
:li.paste data from clipboard
:li.clear data
:li.set style from a stylesheet
:eul.
:p.You can restrict these operations to&colon.-
:ul.
:li.border containers
:li.fill containers
:li.bitmap containers
:li.metafile containers
:li.text containers
:li.frame clipart containers (..a set of frames copied from the frame handler)
:li.any containers
:eul.
:p.The containers that are actually copied also depend on the selected range
when copied. In order to copy such information as row and column widths, the
entire table must be selected.
:p. When pasting, you should select the range you wish to paste to. If you
want to replace the entire table, you must first select it in it's entirety.
:p.When setting a style, the stylesheets listed as available depend on the restriction.
:p.:hp2.Examples:ehp2.
:p.Because the above explanation may not be sufficient, lets take some examples&colon.-
:ul.:li.Copying from the frame handler:eul.
:p.When you copy frames in the frame handler, the data is saved to the clipboard in several formats.
These formats include the frame clipart, a bitmap, and a metafile. Supposing you want to copy the frames
from the clipboard.
:p.If you have no restrictions set, the first format type available is used to create a new container - in
this case the frame clipart is used.
:p.However, if you restrict the copy operation to bitmaps, you will get a new bitmap container, and the bitmap
will be copied from the clipboard instead.
:ul.:li.Copying data in the table:eul.
:p.If you have highlighted a range, and you copy it to the clipboard, you will get a number of different data
formats on the clipboard. I have copied a table with every kind of container in it. Using the clipboard viewer,
I can see the following formats&colon.-
.*********  Please do not translate the clipboard strings, just add an explanation in (brackets) ***********
:xmp.
CONTENTS, Tables
CONTENTS, Plain background
CONTENTS, bitmap handler
BITMAP
CONTENTS, Metafile
Metafile
FRAME, inbuilt
CONTENTS, Plain text
Text
:exmp.
:p.If you restrict the copy operation to bitmaps, you get&colon.-
:xmp.
CONTENTS, Tables
CONTENTS, bitmap handler
BITMAP
:exmp.
:p.If I paste the clipboard into a new table without restriction, then the new table will look like the old one,
the number of cells, the size of the containers and all the bitmap containers will be copied into the new table
in the same places. The clipboard entry 'CONTENTS, Tables' is pasted from the clipboard.
:p.If I paste the clipboard into a new table with a bitmap restriction, then the new table will be unchanged, and
a single bitmap container the size of the selected range will be created. The clipboard entry 'CONTENTS, bitmap handler'
is pasted from the clipboard.
:ul.:li.Restrictions in stylesheets:eul.
:p.The stylesheets available for setting a style are directly influenced by restrictions.
:p.When no restriction is set, only table stylesheets are shown, when restriction is set to
(say) bitmaps, all available bitmap stylesheets are shown. In other words, the restriction to bitmaps makes the
table handler pretend to be a bitmap handler and all available bitmap styles are shown.
:p.As stated above, when no restriction is set, only table stylesheets are shown, and if the table stylesheet contains
a bitmap child stylesheet, the table style, and if possible, the bitmap child style is also set.
:p.All of the above is complicated to explain, but is actually quite easy to use. The complexity lies within the
application, and after only a short time, using restrictions becomes selfexplanatory.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=12 id=12 global.Cut data to clipboard
:i2 refid=editmnu.Cut data to clipboard
:p.Select this menu item to copy the :link reftype=hd
res=2.selected:elink. table data to the clipboard. The selected
table data is then destroyed where appropriate.
:p.This command is subject to both :link reftype=hd
res=16.restriction:elink. and :link reftype=hd
res=2.selection:elink..
:p.:hp2.Text editing mode:ehp2.
:p.The table handler behaves like the text handler, the selected text is copied to
the clipboard, and is then deleted.
:p.The cut command can be executed by using the Shift + Delete keys.
.*-----------------------------------------------------------------------------
:h2 res=13 id=13 global.Copy data to clipboard
:i2 refid=editmnu.Copy data to clipboard
:p.Select this menu item to copy the :link reftype=hd
res=2.selected:elink. table data to the clipboard. The selected
table data is not destroyed.
:p.This command is subject to both :link reftype=hd
res=16.restriction:elink. and :link reftype=hd
res=2.selection:elink..
:p.:hp2.Text editing mode:ehp2.
:p.The table handler behaves like the text handler, the selected text is copied to
the clipboard.
:p.The copy command can be executed by using the Control + Insert keys.
.*-----------------------------------------------------------------------------
:h2 res=14 id=14 global.Paste data from clipboard
:i2 refid=editmnu.Paste data from clipboard
:p.Select this menu item to paste data from the clipboard into the :link reftype=hd
res=2.current selection:elink.. Containers are overwritten where required.
:p.This command is subject to both :link reftype=hd
res=16.restriction:elink. and :link reftype=hd
res=2.selection:elink..
:p.:hp2.Text editing mode:ehp2.
:p.The table handler behaves like the text handler, highlighted text is deleted,
then text is pasted from the clipboard into the current cursor position.
:p.The paste command can be executed by using the Shift + Insert keys.
.*-----------------------------------------------------------------------------
:h2 res=74 id=74 global.Load frame clipart from a catalogue
:i2 refid=editmnu.Load frame clipart from a catalogue
:p.Use this command as a shortcut to importing frames from a clipart catalogue.
:p.Frames are imported as a clipart image and cannot be edited. They can be scaled,
but any scaling must be orthogonal, in other words, the horizontal and vertical
scale must be the same.
.*-----------------------------------------------------------------------------
:h2 res=17 id=17 global.Load data from file
:i2 refid=editmnu.Load data from file
:p.Use this command as a shortcut to importing data. Depending on the data
type you import, and the current :link reftype=hd
res=2.selection:elink., the selected area is updated with
the new table data.
:p.This dialog allows you to load any data format useable by the tables handler.
This includes bitmaps, metafiles, comma separated lists, and more. The data type is recognised
by its file extension. Initially, all known data types are listed.
:p.:hp2.Text editing mode:ehp2.
:p.The table handler behaves like the text handler, highlighted text is deleted,
then text is loaded from the file into the current cursor position. Only text compatible
formats are displayed in the filetypes list.
.*-----------------------------------------------------------------------------
:h2 res=15 id=15 global.Clear data
:i2 refid=editmnu.Clear data
:p.Select this menu item to delete the :link reftype=hd
res=2.selected:elink. table data.
:p.The data is not copied to the clipboard.
:p.This command is subject to both :link reftype=hd
res=16.restriction:elink. and :link reftype=hd
res=2.selection:elink..
:p.The clear command can be executed by using the Delete key.
.*-----------------------------------------------------------------------------
:h2 res=18 id=18 global.Select whole table
:i2 refid=editmnu.Select whole table
:p.This menu item permits you to select the whole table. You can also select
the whole table by clicking on the appropriate selection handle of the table
itself.
:p.Using the menu item to select the whole table is sometimes easier,
particularly when the whole table is not visible.
.*-----------------------------------------------------------------------------
:h2 res=36 id=36 global.Show/edit container ranges
:i2 refid=editmnu.Show/edit container ranges
:p.Use this dialog to show the containers within the current range selection.
The dialog also provides a handy method for sizing and moving containers. You
cannot alter the order in which the containers are displayed.
:p.Select the container you want to edit in the listbox. Four entryfields
provide you with the means to alter the inclusive start and end of the
containers range.
:p.Beware that a large table can use a large number of containers, making such
manual editing rather difficult.
.*-----------------------------------------------------------------------------
:h2 res=35 id=35 global.Set table size
:i2 refid=editmnu.Set table size
:p.Use the table size dialog to set the size of the table.
:p.The dialog attempts to keep the relative width of existing cells the same.
If a new column is added, the existing cell widths are squeezed together
enough to fit in the new column, without making all the cells the same width.
If a column is removed, the remaining cell widths are stretched apart enough
to fill the table, without making all the cells the same width.
:p.If the number of cells in the table are made greater, the size in cells of
any container remains the same. If the number of cells in the table are made
fewer, any containers extending beyond the number of cells actually available,
are clipped.
:p.You can save the selected table size so that all new tables are created
with this size.
.*-----------------------------------------------------------------------------
:h3 res=37 id=37 global.Insert/delete row or column
:i2 refid=editmnu.Insert/delete row or column
:p.When you insert a row or column, it is inserted after the current selection.
:p.The act of inserting a row or column can result in containers being resized to
take into account the new row or column.
.*-----------------------------------------------------------------------------
:h3 res=38 id=38 global.Make rows or columns the same width
:i2 refid=editmnu.Make rows or columns the same width
:p.Makes the selected rows or columns the same width. By only selecting part
of the table, you can prevent cells from outside of the selection being
resized. You must select the whole table to make all the cells the same size.
.*-----------------------------------------------------------------------------
:h2 res=101 id=101 global.Selecting cell styles
:i2 refid=editmnu.Selecting cell styles
:p.Use this menu to apply a table style. If you select the small button to the
right of the menu item, the available table styles are listed. If you select
one of the listed styles, the containers in the style will update the current
selection.
:p.This command is subject to both :link reftype=hd
res=16.restriction:elink. and :link reftype=hd
res=2.selection:elink..
:p.See the :link reftype=hd res=100.Adding cell styles:elink.. help
panel for more information on styles.
.*-----------------------------------------------------------------------------
:h2 res=73 id=73 global.Container editing modes
:i2 refid=editmnu.Container editing modes
:p.In order to be able to edit existing containers, two edit modes are
required.
:p.To begin with, the handler defaults to insert mode, where changes create a
new container that overwrites any existing containers that lie underneath the
current range selection.
:p.In replace mode, the container underneath the current cell selection is
modified, so that other containers remain unaffected.
:p.For text, the behaviour is further modified by the :link reftype=hd
res=72.text edit:elink. mode button. If text edit mode is enabled, the
container editing modes are overridden, so that text can be edited as normal.
.*-----------------------------------------------------------------------------
:h2 res=72 id=72 global.Text editing mode
:i2 refid=editmnu.Text editing mode
:p.When you switch to text editing mode, the tables handler disables cell
selection, and enables the normal editing of the current text container.
:p.You can type text into a cell of a table without using text editing mode.
If you want a text area larger than a single cell, or you want to have a text
area containing tabs, or more than one paragraph, you need to switch to text
editing mode.
:p.If no text container exists under the currently selected cell, a new text
container is created. The new text container will be the size of the currently
selected range.
:p.The table handler does not readily allow overlapping text objects. Although
this is possible by forcing adjacent text containers to overlap using the
:link reftype=hd res=36.Show/edit container ranges:elink. dialog,
there seems to be little point in it.
:p.:hp2.Behaviour with different edit modes:ehp2.
:dl compact tsize=32.
:dt.Container insert mode:dd.Text editing controls change the toolbar, but do not
alter any containers.
:dt.Container replace mode:dd.Text editing controls change all selected
containers.
:dt.Text edit mode:dd.Text editing controls change the highlighted text, the
descriptions for the individual controls presume this mode.
:edl.
.*-----------------------------------------------------------------------------
:h2 res=10 id=10 global.Text editor features
:i2 refid=editmnu.Text editor features
:p.The table handler provides a number of features also found in the text
editors edit menu.
:p.These include&colon.-
:ul.
:li.:link reftype=hd res=57.Insert character:elink.
:li.(*):link reftype=hd res=64.Insert line flush break:elink.
:li.:link reftype=hd res=53.Insert object/settings:elink.
:li.:link reftype=hd res=63.Insert footnote/settings:elink.
:li.:link reftype=hd res=75.Insert equation/settings:elink.
:li.:link reftype=hd res=46.Insert control text:elink.
:li.(*):link reftype=hd res=41.Select merge row:elink.
:li.:link reftype=hd res=54.Find text:elink.
:li.:link reftype=hd res=65.Count words:elink.
:li.(*):link reftype=hd res=66.Check text spelling:elink.
:li.:link reftype=hd res=69.Article information:elink.
:eul.
:p.The marked (*) features above only work in :link reftype=hd
res=72.Text editing mode:elink.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=57 id=57 global.Insert character
:i2 refid=editmnu.Insert character
:p.Use this dialog to select characters from a listbox. This can be extremely useful for
characters that you cannot access easily from the keyboard, or to select symbols from a symbol
font that are not readily discernible from the keyboard.
:p.If the characters are too small to see, you can do one of two things&colon.-
:ul.
:li.Choose a larger font from the fontsize combobox.
:li.Zoom in using the zoom buttons on the main window toolbar.
:eul.
:p.Either way, this dialog enables you to choose a font, style and size, as well as your
special character. Once you have selected the character, click on the 'Insert' button to insert
the character at the current cursor position. You must click on the 'Exit' button to end
this dialog.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=64 id=64 global.Insert line flush break
:i2 refid=editmnu.Insert line flush break
:p.Works in :link reftype=hd res=72.Text editing mode:elink. only.
:p.A line flush break is a bit like a tab, but it pushes all remaining text in
a line to the right hand side.
:p.Line flush breaks have a number of restrictions&colon.-
:ul.
:li.They must appear after any normal tabs in the line.
:li.Only one can occur on each line.
:li.The line must be left, or fully, justified.
:eul.
:p.If any of the above conditions are not met, the flush character is ignored.
:p.:hp2.Uses:ehp2.
:p.Line flush breaks can be used to place a terminating bullet on the end of an article or
paragraph, or to force inline images to the right.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=53 id=53 global.Insert object/settings
:i2 refid=editmnu.Insert object/settings
:p.Inline images are extremely useful for those circumstances where the image
must stay in relationship with the text. If the text is altered, the inline
image will be repositioned as part of the normal reformat process.
:p.Inline images are sized as though they are special font characters. The
vertical size is specified in points, and the horizontal size is calculated
from it.
:p.The same dialog is used both to insert and alter inline images.
:p.:hp2.Loading Images:ehp2.
:p.You cannot load a different image on top of an existing one. You must first
delete the existing image, and then insert a new one. This is because they
behave like characters.
:p.Select the required image type, and click 'Load >>' (or 'Paste', if copying
from the clipboard). Set the required offset, size, and margins, then click
'Ok' to insert the image into the text.
:p.:hp2.Editing Images:ehp2.
:p.To edit the inline image, position the cursor at the start of the image and select the
'Edit inline image' dialog, make any changes required, and then click 'Apply'.
You can continue applying changes until the image is perfectly placed. Click 'Exit' when done.
:p.You can offset the baseline of inline images so that they align properly with the text.
You can also specify margins around the images to provide finer control over the positioning
of surrounding text. The margin directions are based on the current text orientation, and not
the image orientation. Where possible, images are rotated according to the character direction.
:p.:hp2.Additional modes for images in a block of text:ehp2.
:p.You can disable the default text fitting mode, and allow the image to overpaint text that
is in the way. You can then still position text by using the paragraph and line setting
dialogs.
:p.Otherwise, inline images behave just like characters, they scale and rotate with the text,
and generally stay... inline.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=63 id=63 global.Insert, or edit, footnotes
:i2 refid=editmnu.Insert, or edit, footnotes
:p.:hp2.Overview:ehp2.
:p.You can annotate your text using footnotes. The footnote will be shown as a superscript string in the body of
the text. This superscript string is called a footnote indicator.
:p.A footnote consists of three parts. The footnote indicator, the footnote title, and the footnote text itself.
:p.The style of a footnote indicator must be the same for the entire article.
:p.Footnotes are semi-manual, this makes them slightly more complex to use, but it gives a very powerful series of
options.
:p.:hp2.The footnote indicator:ehp2.
:p.You can only alter the footnote indicator for the first footnote in the text article. For subsequent footnotes,
the footnote indicator controls are disabled.
:p.The most basic kind of footnote indicator is a counter. You can set the start value of a counter by enabling the
'lock' checkbox, and entering a number into the adjacent entryfield. This method enables you to use footnotes that
are numbered consecutively across several articles. The manual start value setting has been provided because it
allows you to decide in which order the articles are supposed to be listed.
:p.For footnotes global to all text articles, it is probably best to use the footnote title text as a footnote indicator.
:p.:hp2.The footnote title:ehp2.
:p.The footnote title is used as a header to the footnote. Also, when the cursor is positioned on a footnote
you can see the footnote title in the help field of the status bar.
:p.:hp2.The footnote text:ehp2.
:p.The footnote text can be any text up to around 32k in size. This should be adequate for most footnotes.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=75 id=75 global.Insert, or edit, equations
:i2 refid=editmnu.Insert, or edit, equations
:p.This handler provides some simple spreadsheet functions.
:p.These can be entered directly into the equation dialog and will be recalculated as required.
:p.The engine used for this process provides a very simple and natural user interface.
:p.As is always the case with any scripted programming language, if you create a really
silly script, there is a risk that the application may crash.
:p.Here is a common example script to sum a range of cells.
:xmp.
fix(6, sum(e1..e12))
:exmp.
:p.The fix(6,...) part of the script restricts the number of decimal places to six, and should always come first in
any script that limits decimal places to anything other than 2. The sum(e1..e12) function does the work of adding up
all the values in the range 'e1' to 'e12'.
:p.For further information please see&colon.-
:ul.
:li.:link reftype=hd res=78.Equation syntax:elink.
:li.:link reftype=hd res=76.Equation functions:elink.
:li.:link reftype=hd res=77.Equation variables and constants:elink.
:li.:link reftype=hd res=79.Scripting error codes:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=78 id=78 global.Equation syntax
:i2 refid=editmnu.Equation syntax
:p.:hp2.Equations use some very simple syntax rules:ehp2.
:ul.
:li.Anything with text followed by (brackets) is considered a function, for example :hp2.sum():ehp2..
:li.Anything with text followed by [square brackets] is considered the element of an array.
There are no arrays in this implementation though!
:li.Anything with text followed by a number, for example :hp2.aa34:ehp2. or :hp2.a&colon.e3:ehp2., is 
considered as a cell reference.
:li.Anything with two cell references separated by .., for example :hp2.a3..c12:ehp2., is considered 
as a reference to a range of cells.
:li.Anything containing mathematical operators, such as +, -, *, etc, are treated as a calculation.
:li.The C and C++ comments should work, but are not recommended within the middle of a function or calculation.
Put them at the end. :hp2./* C comments look like this */:ehp2.
:li.Strings are set in quotes, if you enter "Hello there", the equation returns "Hello there". This is probably not
of much use. You could perhaps use it to post reminders like "Don't forget to edit this!"
:eul.
:p.:hp2.Calculation order:ehp2.
:p.Calculations are performed from left to right, with no prioritisation. If you need to calculate things in a particular
order, use brackets.
:xmp.
fix(2, (a3 + b5) / 2))
:exmp.
:p.If you are not using a function, use brackets to enclose the equation. Otherwise you may get an error message.
:xmp.
(27.0345) /* returns this number */
:exmp.
:p.:hp2.Mathematical expressions:ehp2.
:p.Expressions should always be surrounded by brackets, or be within a function.
:p.:hp9.unary integer logic:ehp9.
:parml tsize=16 break=fit.
:pt.!:pd.logical not.
:eparml.
:p.:hp9.unary integer maths:ehp9.
:parml tsize=16 break=fit.
:pt.~:pd.mathematical inversion
:pt.#:pd.abs. Actual numbers must use brackets eg. #(-5)
:eparml.
:p.:hp9.binary integer logic:ehp9.
:parml tsize=16 break=fit.
:pt.&amp.&amp.:pd.logical and.
:pt. or ||:pd.logical or.
:pt.==:pd.logical equality.
:pt.!=:pd.logical inequality.
:pt.>=:pd.logical greater than or equal to.
:pt.<=:pd.logical less than or equal to.
:pt.>:pd.logical greater than.
:pt.<:pd.logical less than.
:eparml.
:p.:hp9.binary maths:ehp9.
:parml tsize=16 break=fit.
:pt.+:pd.mathematical add.
:pt.-:pd.mathematical subtract.
:pt.*:pd.mathematical multiply.
:pt./:pd.mathematical divide.
:pt.%:pd.mathematical remainder of division.
:eparml.
:p.:hp9.binary integer maths:ehp9.
:parml tsize=16 break=fit.
:pt.&amp.:pd.mathematical and.
:pt. or |:pd.mathematical or.
:eparml.
:p.Logical expressions always resolve to 0 or 1. Mathematical expressions generally resolve to double, except
integer maths which resolve to 32bit numbers.
:p.If you attempt a divide by zero, the script will halt with an error message.
:p.For further information please see&colon.-
:ul.
:li.:link reftype=hd res=76.Equation functions:elink.
:li.:link reftype=hd res=77.Equation variables and constants:elink.
:li.:link reftype=hd res=79.Scripting error codes:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=76 id=76 global.Equation functions
:i2 refid=editmnu.Equation functions
:p.:hp2.Functions:ehp2.
:p.The following functions are recognised&colon.-
:parml tsize=10 break=all.
:pt.:hp2.nop(<mode>,<value>):ehp2.:pd.Will suppress the painting of the result. This function only works if it is the first item in the
script. You can use nop() before fix(), and fix() before nop(). If <mode> is equal to zero, then the output is suppressed
unless the result is not equal to zero. If <mode> is not equal to zero, then the equation result is invisible, that is
the result is never painted.
:pt.:hp2.fix(<by>,<value>):ehp2.:pd.Fixes the the number of digits after the decimal point. This function only works if it is the first item in the
script. You can use nop() before fix(), and fix() before nop(). 
You might use it like this for calculating money 'fix(2, sum(a0..a3, a7, e0..g11))'. The default fix is 2 decimal
places, but calculations are accurate to 12 or more decimal places.
:pt.:hp2.ofs(<xoffs>, <yoff>, <cx>, <cy>):ehp2.:pd.Allows you to specify a range or value as an offset to the top left
corner of the current range. This is mostly used where the same equation is used to perform a series
of equivalent operations such as multiplying a value by a number found one cell to the left of the current
cell&colon. (ofs(0, -2) * ofs(0, -1)) will multiply the cell to the left of this cell with its neighbour to the left,
and will return the result in this cell.
You can also specify an offset range, ofs(-10, -10, 3, 4), this returns a range that can be used as an input to
functions that accept ranges, such as sum&colon. sum(ofs(-10, -10, 3, 4))
:pt.:hp2.sum(<ranges>):ehp2.:pd.The sum of all the values given. Up to seven sets of ranges or cells may be given, separated by comma,
in the form 'sum(a0..a3, a7, e0..g11)'. The example shown uses just three sets of ranges or cells.
:pt.:hp2.diff(<ranges>):ehp2.:pd.The maximum difference between of all the values given. Up to seven sets of ranges or cells may be given, separated by comma,
in the form 'diff(a0..a3, a7, e0..g11)'. The example shown uses just three sets of ranges or cells.
:pt.:hp2.mean(<ranges>):ehp2.:pd.The mean of all the values given. Mean is calculated as the midpoint between the maximum and
minimum values. Up to seven sets of ranges or cells may be given, separated by comma,
in the form 'mean(a0..a3, a7, e0..g11)'. The example shown uses just three sets of ranges or cells.
:pt.:hp2.min(<ranges>), max(<ranges>):ehp2.:pd.Return the maximum and minimum values as used by mean().
:pt.:hp2.avg(<ranges>):ehp2.:pd.The mean of all the values given. Avg is calculated as the sum of all the values divided by the
number of values added together.
:pt.:hp2.sqrt(<x>):ehp2.:pd.calculates the nonnegative value of the square root of x.
:pt.:hp2.exp(<x>):ehp2.:pd. calculates the exponential function of a floating-point argument x 
(e to the exponent x, where e equals 2.17128128...).
:pt.:hp2.abs(<n>):ehp2.:pd.returns the absolute value of an integer argument n. 
:pt.:hp2.floor(<x>):ehp2.:pd.calculates the largest integer that is less than or equal to x. 
:pt.:hp2.ceil(<x>):ehp2.:pd.computes the smallest integer that is greater than or equal to x.
:pt.:hp2.gamma(<x>):ehp2.:pd.computes ln( |G(x)| ), where x must be a positive real value.
:pt.:hp2.hypot(<side1>, <side2>):ehp2.:pd.calculates the length of the hypotenuse of a right-angled triangle
based on the lengths of two sides side1 and side2.  A call to hypot is equivalent to: 
sqrt(side1 * side1 + side2 * side2);
:pt.:hp2.pow(<x>, <y>):ehp2.:pd.calculates the value of x to the power of y. 
:pt.:hp2.logn(<x>):ehp2.:pd.calculates the natural logarithm (base e) of x. 
:pt.:hp2.log(<x>):ehp2.:pd.calculates the base 10 logarithm of x. 
:pt.:hp2.acos(<x>):ehp2.:pd.calculates the arccosine of x, expressed in radians, in the range 0 to pi. 
:pt.:hp2.asin(<x>):ehp2.:pd.calculates the arcsine of x, in the range -pi/2 to pi/2 radians. 
:pt.:hp2.atan(<x>):ehp2.:pd.calculate the arctangent of x.
:pt.:hp2.cos(<x>):ehp2.:pd.calculates the cosine of x. The value x is expressed in radians.
If x is too large, a partial loss of significance in the result may occur. 
:pt.:hp2.cosh(<x>):ehp2.:pd.calculates the hyperbolic cosine of x. The value x is expressed in radians. 
:pt.:hp2.sin(<x>):ehp2.:pd.calculates the sine of x, with x expressed in radians.
If x is too large, a partial loss of significance in the result may occur. 
:pt.:hp2.sinh(<x>):ehp2.:pd.calculates the hyperbolic sine of x, with x expressed in radians. 
:pt.:hp2.tanh(<x>):ehp2.:pd.calculates the hyperbolic tangent of x, where x is expressed in radians.
:pt.:hp2.tan(<x>):ehp2.:pd.calculates the tangent of x, where x is expressed in radians.
:eparml.
:p.For further information please see&colon.-
:ul.
:li.:link reftype=hd res=78.Equation syntax:elink.
:li.:link reftype=hd res=77.Equation variables and constants:elink.
:li.:link reftype=hd res=79.Scripting error codes:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=77 id=77 global.Equation variables and constants
:i2 refid=editmnu.Equation variables and constants
:p.:hp2.Constants:ehp2.
:p.This handler recognises the following constants&colon.-
:parml tsize=30 break=fit.
:pt.:hp2.true:ehp2.:pd.= 1
:pt.:hp2.false:ehp2.:pd.= 0
:pt.:hp2.pi:ehp2.:pd.= 3.14159265358979323846
:pt.:hp2.e:ehp2.:pd.= 2.718281828459045
:eparml.
:p.:hp2.Variables:ehp2.
:p.Variables consist of a table cell or range, and can be in the forms&colon.-
:parml tsize=30 break=fit.
:pt.:hp2.a1:ehp2.:pd.The cell a1
:pt.:hp2.a&colon.a1:ehp2.:pd.The cell a1
:pt.:hp2.a1..e27:ehp2.:pd.The range a1 to e27
:pt.:hp2.a&colon.a1..e27:ehp2.:pd.The range a1 to e27. The sheet is always a&colon. as you can't have more than one sheet at present.
:pt.:hp2.a1..a&colon.e27:ehp2.:pd.The range a1 to e27. The sheet is always a&colon. as you can't have more than one sheet at present.
:pt.:hp2.a&colon.a1..a&colon.e27:ehp2.:pd.The range a1 to e27. The sheet is always a&colon. as you can't have more than one sheet at present.
:eparml.
:p.Variable ranges are treated differently to cells and where a range is inappropriate, the script will halt.
:p.For further information please see&colon.-
:ul.
:li.:link reftype=hd res=78.Equation syntax:elink.
:li.:link reftype=hd res=76.Equation functions:elink.
:li.:link reftype=hd res=79.Scripting error codes:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=79 id=79 global.Scripting error codes
:i2 refid=editmnu.Scripting error codes
:p.Here is the complete list of possible error codes returned by the scripting engine. It is perfectly
possible that some of these errors are out of reach, that is to say you will never see them because they are
not used withing the tables handler.
:p.Despite trying a variety of different programming options, floating point errors in the C standard library
cause an application crash. The script attempts to catch most of the possible bad numbers put into C library maths 
functions before this can happen, but the risk of a crash remains.
:p.When the script is running during a paint operation, the error will not be shown in a message box. Instead,
the error code will be returned as a text string.
:p.When you open the script dialog, this error code is converted into the error string, and is shown in the
result field. The script is run before it is inserted into the text container. This will find most errors
except recursion or other stack errors.
.**** A note to translators - The error codes, such as 'ERR00001', should not be altered. ****
:p.:hp2.Error - Description:ehp2.
:p.:hp2.ERR00000 - no error:ehp2.
:p.Not an error. This is just a placeholder.
:p.:hp2.ERR00001 - insufficient number of arguments:ehp2.
:p.A function is expecting more arguments than you have given.
:p.:hp2.ERR00002 - missing assignment:ehp2.
:p.A mathematical operation is expecting another argument.
:p.:hp2.ERR00003 - expression at eof:ehp2.
:p.The script has run out before the expression could be resolved.
:p.:hp2.ERR00004 - argument at eof:ehp2.
:p.The script has run out before the argument could be resolved.
:p.:hp2.ERR00005 - text string at eof:ehp2.
:p.The script has run out before the text string could be resolved.
:p.:hp2.ERR00006 - out of memory:ehp2.
:p.The script has run out of memory space.
:p.:hp2.ERR00007 - command terminator missing:ehp2.
:p.A command terminator is missing
:p.:hp2.ERR00008 - comment at eof:ehp2.
:p.The script has run out before the comment has ended.
:p.:hp2.ERR00009 - quotes at eof:ehp2.
:p.The script has run out before a text string could be resolved.
:p.:hp2.ERR00010 - script interrupted by user:ehp2.
:p.You pressed the <esc> key to kill the script.
:p.:hp2.ERR00011 - command syntax error:ehp2.
:p.There is something wrong with the way you have entered a function
:p.:hp2.ERR00012 - mathematical expression at eof:ehp2.
:p.The script has run out before the expression could be resolved.
:p.:hp2.ERR00013 - expected value or unary expression:ehp2.
:p.A mathematical expression is expecting a single number.
:p.:hp2.ERR00014 - expected two part expression:ehp2.
:p.A mathematical expression is expecting two numbers.
:p.:hp2.ERR00015 - missing expression:ehp2.
:p.A mathematical expression is missing.
:p.:hp2.ERR00016 - expected a value to follow unary:ehp2.
:p.A mathematical expression is expecting a single number. This is like having '(!)' instead of '(!something)'
:p.:hp2.ERR00017 - expression syntax error:ehp2.
:p.A mathematical expression is not recognised.
:p.:hp2.ERR00018 - divide by zero:ehp2.
:p.An attempt hav been made to divide by zero. Like '(100 / 0)', for example.
:p.:hp2.ERR00019 - assignment not allowed, try '==':ehp2.
:p.You cannot assign a value to a variable, you can only compare values.
:p.:hp2.ERR00020 - cannot find any parameters:ehp2.
:p.A function is expecting some parameters.
:p.:hp2.ERR00021 - argument cannot be a string:ehp2.
:p.A function is expecting a parameter that is not a string.
:p.:hp2.ERR00022 - argument cannot be a range:ehp2.
:p.A function is expecting a parameter that is not a table range.
:p.:hp2.ERR00023 - command not found:ehp2.
:p.The name of a function remains unrecognised.
:p.:hp2.ERR00024 - recursion limit reached:ehp2.
:p.The script has called itself more times than is allowed. This can happen when you try and sum a range of cells
including the cell where the result is meant to go. 
:p.:hp2.MLIB0001 - MATHLIB&colon.Argument domain error:ehp2.
:p.The result of a C standard library function is out of range.
:p.:hp2.MLIB0002 - MATHLIB&colon.Overflow range error:ehp2.
:p.The result of a C standard library function is an overflow.
:p.:hp2.MLIB0003 - MATHLIB&colon.Underflow range error:ehp2.
:p.The result of a C standard library function is an undeflow.
:p.:hp2.MLIB0004 - MATHLIB&colon.Total loss of significance:ehp2.
:p.The result of a C standard library function has lost all sense.
:p.:hp2.MLIB0005 - MATHLIB&colon.Partial loss of significance:ehp2.
:p.The result of a C standard library function has lost some accuracy.
:p.:hp2.MLIB0006 - MATHLIB&colon.Argument singularity:ehp2.
:p.A C standard library function got an unexpected argument.
:p.All the MATHLIB errors are produced by the C standard library.
:p.For further information please see&colon.-
:ul.
:li.:link reftype=hd res=78.Equation syntax:elink.
:li.:link reftype=hd res=76.Equation functions:elink.
:li.:link reftype=hd res=77.Equation variables and constants:elink.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=46 id=46 global.Insert control text
:i2 refid=editmnu.Insert control text
:p.Use the 'Insert control text' dialog to add control text to the text frame. Control text is text that
is automatically generated from internal information. Such internal information includes the current
date and time, the current publication filename and path, the current page number and the number
of pages in the publication, as well as user defined text merge data.
:p.:hp2.Page numbers:ehp2.
:p.The page number is determined by the position of the control text on the printer page. If the control text
is not actually within a page, or exactly centred across two pages, the correct page number may not be found.
In this case you will get a '?'
:p.The total number of pages is useful for creating text of the form 'Page x of y', where 'y' is the total number of
pages in the entire publication.
:p.:hp2.Counters:ehp2.
:p.Counters provide a way of producing numbered lists. A number of ways of counting are provided, such as counting
alphabetically, or using roman numerals.
:p.Because counters can be nested, you can create numbered lists something like shown below.
:fig.
1 cars.
2 boats,
    a rowing.
    b sailing.
    c pedal.
3 bikes.
4 airplanes.
:efig.
:p.:hp2.Merge data:ehp2.
:p.You can load and use a merge database as a way of merging information into the text. The most common usage
for this is to create personalised letters from a list of names and addresses. Before you insert merge data,
you should load a merge database into the publication, and select the starting row of the data to be used for
the merge. Merging is performed automatically, dynamically, and changes as you alter the information in the
merge database. You can select which row in the merge database you want to use by selecting the correct row
from the dropdown list. For more information about the merge database please see the text handler help manual.
:p.Later, you can select a different row by selecting the appropriate text and selecting a new merge row in the
:link reftype=hd res=41.Select merge row:elink. dialog.
:p.:hp2.Date and time:ehp2.
:p.The date and time information is converted from a numeric format to a text format using a file called
DATECONV.LCI.
:p.You can set the date and time as normal text, in which case the control text is converted to normal text before
insertion in the document. As normal text, the date and time values will not be updated each time you repaint or print
the text. Because inserting a fixed date and time is the most common requirement, the mode is enabled by default.
:p.:hp2.File information:ehp2.
:p.You can select from the name of the publication, or you can choose to have the full file path inserted. If
the file has no name, you will get a blank string. When the file is saved, the string will appear with the
correct file information.
:p.:hp2.DATECONV.LCI data format:ehp2.
:p.For a description of this format, please see the text handler help manual.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h4 res=41 id=41 global.Select merge row
:i2 refid=editmnu.Select merge row
:p.Works in :link reftype=hd res=72.Text editing mode:elink. only.
:p.This dialog is available if you have highlighted a piece of :link
reftype=hd res=46.control text:elink. containing data from a
merge database.
:p.You can change the relative merge database row used for obtaining the text.
If the rows are set to auto-increment during multiple print runs, the row will
auto-increment in a corresponding manner.
:p.The base row is selected in the merge database dialog. The first row shown
in this dialogs listbox will correspond to the selected first row in the merge
database dialog. The minimum offset from this base row found in the selected
control text will be selected in the listbox. This ensures that the row that
you can select is always greater than the base row.
:p.When you produce multiple print runs with an auto-incrementing base row,
all the other rows will be offset accordingly. Rows greater than the rows
available in the merge database will cause the text to become a placeholder
(such as '$$(123)' for example).
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=54 id=54 global.Find text
:i2 refid=editmnu.Find text
:p.Select Find from the Edit menu. Find searches for text in the find entryfield.
:p.Enter the text you wish to find into the find entryfield. The entryfields
allow strings of up to 254 characters.
:p.If you wish to alter the found text, enter the new text in the change
entryfield.
:p.Select whether you want the test to be case sensitive, or you wish to
search backwards.
:p.Until Find has found something, all other options are disabled. Once text
is found, it is highlighted.
:p.:hp2.You may then:ehp2.
:ol.
:li.Change the text for that in the change entryfield.
:li.Change the text as above, and then find the next occurrence.
:li.Use any normal editing function, such as cut, copy, paste, typing, etc.
Just move the find dialog out of the way (or minimize) and click on the text
to get a cursor. The dialog will remain there until wanted.
:li.Change all occurrences of the text.
:eol.
:p.Find will not only search the selected container, but will search all containers
for the required text.
:note.Find is a separate thread. Try not to edit the file whilst find is actually
searching.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=65 id=65 global.Count words
:i2 refid=editmnu.Count words
:p.Select the 'Count words' menu item to give you a count of words in the
table, as well as in the current selection.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=66 id=66 global.Check text spelling
:i2 refid=editmnu.Check text spelling
:p.Works in :link reftype=hd res=72.Text editing mode:elink. only.
:p.In order to check spelling, you need to have a spellcheck and hyphenation handler
installed. If you have this handler installed, you can use it to check the spelling of your
documents.
:p.To get more information about the spell check handler, you can either&colon.-
:ul.
:li.Use the 'List handlers...' menuitem in the help dialog, and use the 'Help for selected
handler' button after finding and selecting the spellcheck handler to obtain help.
:li.Open the text handler's 'Edit' menu and click on the 'Check text spelling...' menuitem.
The spellcheck handler should present you with a dialog containing a 'Help' button.
:eul.
:p.If the 'Check text spelling...' menuitem is disabled, the spellcheck handler is not
available. In this case, you may have to re-install it.
.*-----------------------------------------------------------------------------
:h3 res=69 id=69 global.Text article information
:i2 refid=editmnu.Text article information
:p.Text article information is used to distinguish text articles from one another. Any given publication can contain text
articles from several authors, articles that might be destined for that publication, or articles that have been
obtained from an entirely different publication. Once set, text article information remains embedded within the text article, and
can be viewed from the article information dialog.
:p.The various article information fields are provided to reflect the status of a given article. Later, this information
can be used to search for a particular article, or to select an article from a list.
:p.If no article information is provided, the application will, where necessary, use the first few words of the text
article to describe the article in a list.
:p.The following information fields are available&colon.-
:p.:hp2.Article name:ehp2.
:p.This field describes the name of the document. Some dialogs, such as those used to find text articles,
list the articles by name. If the article has no name, the first few words of the text are used instead, but
if you decide to set the text article information, you must enter a name.
:p.You can search for the name of the article using the search tool in the 'Tools' menu.
:p.:hp2.Author:ehp2.
:p.This optional field describes the author of the document. You can put any text in here, or leave it empty.
:p.You can search for the author of the article using the search tool in the 'Tools' menu.
:p.:hp2.Date:ehp2.
:p.This optional field describes the date when the article was created. If no date exists, todays date is filled
in for you. You are not restricted to dates, you can put any kind of text in here, or leave it empty.
:p.:hp2.Destination:ehp2.
:p.This optional field describes where the article was intended to be published. If no destination exists, the
current filename is filled in for you. You can leave the field unchanged, put any text in here, or leave it empty.
:p.:hp2.Comments:ehp2.
:p.This optional field provides you with space to add comments. If the article has a copyright, this might be a good
place to make a note of it. Other useful things you can put in here is notes about corrections, translations, additions,
and so on.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=11 id=11 global.Remove handler
:i2 refid=editmnu.Remove handler
:p.Select this menu item to destroy the entire table, and remove the handler
from the frame. Once you have done this you can add a different handler to the
frame in place of the current handler.
.******************************************************************************
:h1 res=80 id=80 global.The Cell styles menu
:i1 id=cellsmnu.The Cell styles menu
:p.The cell styles menu provides the means to set the style of a range of
cells. This includes the background, the border, and styles associated with
the cell contents, such as images or text.
:p.Border styles
:ul.
:li.:link reftype=hd res=28.Border linestyles:elink. dialog
:li.:link reftype=hd res=27.Border width:elink. dialog
:li.:link reftype=hd res=30.Border colour:elink. dialog
:eul.
:p.Fill (background) styles
:ul.
:li.:link reftype=hd res=30.Fill colour:elink. dialog
:li.:link reftype=hd res=34.Advanced shading modes:elink. dialog
:li.:link reftype=hd res=31.Fill patterns:elink. dialog
:li.:link reftype=hd res=33.Fill orientation:elink. dialog
:eul.
:p.Bitmap image styles
:ul.
:li.:link reftype=hd res=90.Scale bitmap:elink.
:li.:link reftype=hd res=91.Maintain bitmap shape:elink.
:eul.
:p.Metafile styles
:ul.
:li.:link reftype=hd res=90.Scale metafile:elink.
:li.:link reftype=hd res=91.Maintain metafile shape:elink.
:eul.
:p.Frameset styles
:ul.
:li.:link reftype=hd res=90.Scale image:elink.
:eul.
:p.Text styles
:ul.
:li.:link reftype=hd res=56.Text language and codepage:elink.
:li.:link reftype=hd res=58.Enable text hyphenation:elink.
:li.:link reftype=hd res=59.Intelligent text quotes:elink..
:li.:link reftype=hd res=68.Vertical text alignment:elink.
:li.:link reftype=hd res=55.Character direction:elink.
:li.:link reftype=hd res=44.Paragraph settings:elink.
:li.:link reftype=hd res=60.Bullets and Lists:elink.
:li.:link reftype=hd res=45.Line settings:elink.
:li.:link reftype=hd res=47.Line tabs:elink.
:li.Character :link reftype=hd res=43.font:elink.
:li.Character :link reftype=hd res=30.colour:elink.
:li.Character :link reftype=hd res=51.kerning:elink.
:li.Character :link reftype=hd res=52.dropshadow:elink.
:li.Select :link reftype=hd res=50.superscript:elink.
:li.Select :link reftype=hd res=50.subscript:elink.
:li.Set to :link reftype=hd res=48.title text:elink.
:eul.
:p.Cell style sheets
:ul.
:li.:link reftype=hd res=100.Add to style list:elink.
:eul.
.*-----------------------------------------------------------------------------
:h2 res=30 id=30 global.Colour selection
:i2 refid=cellsmnu.Colour selection
:p.The default colour dialog is used for setting plain colours for
backgrounds, borders, and text. This dialog is within the current colour
handler. See the help information provided with the colour handler to obtain
information on how to use this dialog.
:p.The background is capable of using shading, so where appropriate, the
shading dialog is used instead.
:p.:hp2.Fills (backgrounds):ehp2.
:p.You will get the colour setting dialog if you create a plain fill style. If
you create a shaded fill style, you will get the :link reftype=hd
res=32.Shading colours dialog:elink. instead.
:p.Use this dialog to select a background colour. Both the foreground and
background colours are used. The actual colour will be a mixture determined by
the pattern settings. If the current colour handler supports it, you can set
the background colour to transparent. See the :link reftype=hd
res=31.pattern:elink. settings for more information on mixing
colours.
:p.:hp2.Borders:ehp2.
:p.Use this dialog to select a border colour. Both the foreground  and
background colours are used. When a dashed or hollow foreground line is drawn,
the background line colour will show through beneath. You can select a
transparent background colour, in which case the background line is not drawn.
:p.:hp2.Text:ehp2.
:p.Use this dialog to select a text colour. The foreground colour is used for
the text, and the background colour is used to place a colour behind the
selected text. You can also set the background colour to transparent.
:p.Either way, this is a dialog within the current colour handler. See the
help information provided with the colour handler to obtain information on how
to use this dialog.
.******************************************************************************
.*  Shading colours
.******************************************************************************
:h3 res=32 id=32 global.Shading Colours Dialog
:i2 refid=cellsmnu.Shading Colours Dialog
:p.Create a list of shading colours for shaded fills.
:artwork name='shadedlg.bmp' align=left.
:p.When you first open the dialog, you will find two colours defined. Unless
you have already altered the colour of the fill, both colours will normally be
white.
:p.Select one of the colours in the listbox, and you can edit the colour, move
the colour up or down the list, or delete the colour if you have more than
two. Shading colour styles need at least two colours defined, although both
colours can be the same. Pressing the add button will add another colour item.
The colour of the new colour item is taken from the currently selected colour.
:p.Use a left mouse click on the colour wheel or colour list to alter the
foreground colour. All the methods used by the default colour dialog can be
used here, this includes clicking on the lower right hand swatch control to
get a more precise colour control. You can also select a colour from the
colour table, if loaded.
:p.You can change the background colour of your fill at any time by editing
the background colour. Use a right mouse click on the colour wheel or colour
list to alter the colour. The background colour is independant of the colour
items.
:p.See the :link reftype=hd res=34.advanced:elink. settings for
more information on normalised colour mixing.
:p.Press 'Apply' to apply the new list of colours, and 'Exit' to exit the
dialog when you are finished.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=28 id=28 global.Border linestyles
:i2 refid=cellsmnu.Border linestyles
:p.In order to get a border, you need to select an appropriate border
linestyle. The default border linestyle is set to none. As containers are used
for borders as well, the border style will be applied to the current
selection. This enables you to use several different border styles in the same
table.
:p.The following styles are available&colon.-
:ul.
:li.No Borders.
:li.:artwork name='bstyhorz2.bmp' runin. Lower horizontal lines only.
:li.:artwork name='bstyvert2.bmp' runin. Rightmost vertical lines only.
:li.:artwork name='bstyinter.bmp' runin. Lower horizontal lines and rightmost
vertical lines only.
:li.:artwork name='bstynone.bmp' runin. Outline of selection only.
:li.:artwork name='bstyhorz.bmp' runin. All horizontal lines.
:li.:artwork name='bstyvert.bmp' runin. All vertical lines.
:li.:artwork name='bstyall.bmp' runin. All lines.
:eul.
:p.The horizontal or vertical lines shown in :hp9.pink:ehp9. will be enabled 
by the appropriate checkbox. The ability to disable these lines allows you to 
better combine adjacent border styles. 
:p.Normally, those parts of borders lying underneath other borders will not be painted.
If you wish to overlap border styles in order to combine them, you can do so by disabling
the exclusion of overlapping borders on the underlying border style.
:p.In theory, you need a border style, a border width, and a border colour
before you see a border. In order to make borders more convenient, you only
need to set a border linestyle, a zero line width will be treated as a fine
line, and the colour will default to black if not set.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=27 id=27 global.Border width
:i2 refid=cellsmnu.Border width
:p.Use this dialog to select a border width. A border width of zero is treated
as a 1. You must set a suitable :link reftype=hd res=28.Border
linestyle:elink. before you see anything.
:p.Enter a number followed by the measurement type. i.e. 0.5in.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and
dpt (1/10 pt). There are 25.4 mm to the inch, and 72.2818 points to the inch.
If you give the size without a
measurement type, the value is considered to be in printer pels. The actual
value is stored as printer pels, so a width of 1 gives the narrowest possible
border.
.*-----------------------------------------------------------------------------
:h2 res=34 id=34 global.Advanced shading modes
:i2 refid=cellsmnu.Advanced shading modes
:artwork name='advanced.bmp' align=left.
.br
:p.:hp2.Shading fill modes:ehp2.
:p.Shading fill modes have a number of parameters that can be modified from
the default. Use this dialog to edit and apply changes to the manner in which
shading is performed.
:p.This handler currently only supports shading by crossfading. Crossfading
involves fading one colour out to white, and the next colour in from white.
:p.The crossfade and its parameters are most readily explained with a
diagram&colon.-
:artwork name='addiag.bmp' align=left.
.br
:p.:hp2.Run in and run out:ehp2.
:p.The 'run-in' and 'run-out' sliders adjust the size of the run in and run
out parts shown on the diagram. If the sliders aren't accurate enough, you can
directly enter the required percentage values into the edit fields.
:p.As you increase the run in, so the crossfade tends towards blackness. As
you increase the run out, the crossfade tends towards whiteness. If you
increase both run in and run out, the crossface itself occurs over a shorter
area. At 100% run in and 100% run out, there remains no room for the
crossfade, and the colours switch directly from one to the next.
:p.:hp2.Normalised brightness:ehp2.
:p.When two colours are mixed, the resultant brightness, or luminance, can
change dramatically. By selecting the 'Normalised brightness' checkbox, the
crossfade will correct and average out this change in brightness. For some
colours, the effect is not apparent, for some, it totally changes the look of
the crossfade. The effect is particularly noticable when mixing between
primary colours, such as red and green.
.*-----------------------------------------------------------------------------
:h2 res=31 id=31 global.Fill pattern
:i2 refid=cellsmnu.Fill pattern
:p.The button bar uses a dropdown menu of items, otherwise you will get a
dialog. Both work in the same way.
:p.Use the dialog to select a background mix pattern. If the mix pattern is
set to solid, the default, only the foreground colours are used. If you select
one of the other mix patterns, the background colour is painted first,
followed by a pattern in the foreground colours.
:p.If the background colour is set to transparent, only the foreground pattern
is painted. This is one way in which you can tint an underlying object.
.*-----------------------------------------------------------------------------
:h2 res=33 id=33 global.Fill orientation
:i2 refid=cellsmnu.Fill orientation
:p.Background fill orientation is made up of the sum of frame orientation and
fill orientation. By default the fill orientation is +0.
:p.Normally, if the frame is orientated to zero, the fill is orientated to 0,
which results in a vertical fill.
:p.If you rotate the frame, the fill will also rotate. The actual fill angle
is shown as a status string within the rotate dialog. You can use the spin
button or enter the required angle to change the :hp1.relative:ehp1.
orientation between fill and frame.
:p.Click on 'Apply' to apply the new fill angle, and 'Exit' to exit the dialog
when you are finished.
.*-----------------------------------------------------------------------------
:h2 res=20 id=20 global.Fill modes
:i2 refid=cellsmnu.Fill modes
:p.The tables handler supports a number of fill modes to provide shading
effects as well as a simple colour fill.
:p.The fill modes include&colon.-
:ul.
:li.:link reftype=hd res=21.Plain:elink. fill mode.
:li.:link reftype=hd res=22.Flat:elink. fill mode.
:li.:link reftype=hd res=23.Arc:elink. fill mode.
:li.:link reftype=hd res=24.Circle:elink. fill mode.
:li.:link reftype=hd res=25.Rectangle:elink. fill mode.
:li.:link reftype=hd res=26.Chequer:elink. fill mode.
:eul.
.br
.br
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=21 id=21 global.Plain fill mode
:p.:artwork name='backplain.bmp' runin.This mode fills the frame
with a single colour.
:p.All fill modes support :link reftype=hd res=31.patterns:elink.
with a pattern background colour.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=22 id=22 global.Flat shading fill mode
:p.:artwork name='backcol2.bmp' runin.This mode fills the frame
with a shade between two or more colours. The colours are drawn as flat
stripes across the frame. The :link reftype=hd
res=33.orientation:elink. can be changed as required.
:p.All fill modes support :link reftype=hd res=31.patterns:elink.
with a pattern background colour.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=23 id=23 global.Arc shading fill mode
:p.:artwork name='backcol.bmp' runin.This mode fills the frame with
a shade between two or more colours. The colours are drawn as arcs of
increasing diameter across the frame. The :link reftype=hd
res=33.orientation:elink. can be changed as required.
:p.All fill modes support :link reftype=hd res=31.patterns:elink.
with a pattern background colour.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=24 id=24 global.Circular shading fill mode
:p.:artwork name='backcol1.bmp' runin.This mode fills the frame
with a shade between two or more colours. The colours are drawn as increasing
circles starting from the centre of the frame.
:p.All fill modes support :link reftype=hd res=31.patterns:elink.
with a pattern background colour.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=25 id=25 global.Rectangular shading fill mode
:p.:artwork name='backcol3.bmp' runin.This mode fills the frame
with a shade between two or more colours. The colours are drawn as increasing
rectangles starting from the centre of the frame.
:p.All fill modes support :link reftype=hd res=31.patterns:elink.
with a pattern background colour.
.*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
:h3 res=26 id=26 global.Chequer fill mode
:p.:artwork name='backcol4.bmp' runin.This mode fills the frame
with a chequer pattern between two or more colours.
:p.The colours are repeated at regular intervals, filling the container equally
based upon the number of colours available. If fewer than four colours are available,
at least four squares will be filled. If only two colours are available, the colours
will be painted in a simple chequer pattern.
:p.Advanced shading modes are ignored by this fill mode.
:p.All fill modes support :link reftype=hd res=31.patterns:elink.
with a pattern background colour.
.*-----------------------------------------------------------------------------
:h2 res=91 id=91 global.Maintain image shape
:i2 refid=cellsmnu.Maintain image shape
:p.This menu selection ensures that images are not distorted by unequal
scaling.
:p.As this option is applied before any user defined scaling, the :link
reftype=hd res=90.Scaling dialog:elink. can still distort the
picture.
.*-----------------------------------------------------------------------------
:h2 res=90 id=90 global.Scale image
:i2 refid=cellsmnu.Scale image
:p.Use the 'Scale Picture...' dialog to alter the scaling of an image. Scaling
is a graphics transform that is performed independently from other scaling
factors. The scaling dialog allows you to scale and mirror pictures.
:p.Use the entryfields to type in the height and width of the required scale
factors in percent. For convenience, use the buttons provided to add and
subtract a factor of 50%. Negative scaling factors invert or mirror the image.
:p.The dialog also provides two sliders to alter the scaling factors over a
total range of 100%.
:p.Any changes are shown in the sample image. This sample can only give a
guide to aspect ratios when scaling is greater than 100%. The image is always
shrunk to remain within the sample window.
:p.Press 'Apply' to apply the changes to the bitmap, and 'Exit' to exit the
dialog when you are finished.
.*-----------------------------------------------------------------------------
:h2 res=56 id=56 global.Set the text language and codepage
:i2 refid=cellsmnu.Set the text language and codepage
:p.The language selection is used to determine a number of important settings, these include&colon.-
:ul.
:li.The language used for calculating hyphenation wordbreaks.
:li.The language used for spell checking.
:li.The language used for displaying the date and time.
:eul.
:p.Each item in the language selection list displays 3 different parameters. The first is the language id,
and the second is the language string. The third parameter is only shown if the correct dictionaries for
your language are installed.
:p.To install a new language, you need to edit two files, both are found in Maul's .\etc path. The first file
is called DATECONV.LCI, and the second is called MYSPELL.DLS. To edit MYSPELL.DLS, see the section
'Managing dictionaries and codepages' in the spellcheck handler help manual. To edit DATECONV.LCI, see the
section 'DATECONV.LCI data format' in the text handler help manual.
:p.If you choose a language that has no dictionaries, hyphenation and spellchecking will not work correctly!
:p.Codepages are extensively used by OS/2 to display text for a given language or operating system.
Text is stored in memory as a series of numbers. The codepage determines to which character a number
belongs. If you import plain text with a different codepage, the characters will be wrong. Change
to the right codepage and the text will display correctly.
:p.Although the selected codepage is used to display text, it is not used to change the keyboard,
nor is it  used to actually convert text from one codepage to another.The application will translate
some codepages for you, see 'Internationalisation Information' in the text handler help manual.
:p.Common codepages include&colon.-
:ul.
:li.819  This codepage is used by ISO8859-1 Linux systems, the MySpell spellchecker uses this codepage.
:li.850  This codepage is used by latin 1 OS/2 systems, and incorporates accents such as those used in French.
:li.852  This codepage is used by latin 2 OS/2 systems, and incorporates accents such as those used in Czech.
:li.1004 This codepage enables OS/2 systems to generally correctly display text created by Windows.
:li.1252 This codepage is used by latin 1 Windows systems.
:li.1250 This codepage is used by latin 2 Windows systems.
:eul.
:p.You can select the codepage you want to use for this text article. Click on
'Apply' to set the codepage, and 'Exit' to leave the dialog. If you select a
different text frame, the dialog will automatically update.
:p.There is a problem to be aware of though.
:p.The selected codepage is translated back to the installed codepage(s) on
your system. The more complex this translation, the slower text processing
becomes. When selecting a frame with a different codepage, the handler may
need to reload it's table of fonts, and this gives the effect of momentary
seizures from time to time.
:p.The codepages you can select are defined by the intersecting of codepages
available on the operating system and a file called CODEPAGE.LCI. This file
lists and names all the codepages you are able to select. You can disable the
use of a codepage by deleting it from this file. You may also find codepages
in the file that you cannot select, these are simply not found on your system.
The file is found in the ..\etc directory. (Most stylesheets and master pages
are found here too!)
:p.:hp2.CODEPAGE.LCI data format:ehp2.
:p.For a description of this format, please see the text handler help manual.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=58 id=58 global.Enable text hyphenation
:i2 refid=cellsmnu.Enable text hyphenation
:p.Hyphenation is language and codepage dependant. Before you enable text hyphenation,
please select the correct language and codepage for your text article.
:p.To set the correct language for your text article, please use the
:link reftype=hd res=56.the text language and codepage:elink. dialog.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=59 id=59 global.Intelligent text quotes
:i2 refid=cellsmnu.Intelligent text quotes
:p.Maul provides a means of managing quotes according to language. If the 
'Intelligent text quotes' menu item is enabled, the simple "quote marks" 
will be replaced by an escape sequence that automatically chooses the
appropriate quotemarks according to the selected language of the text article.
:p.The 'Intelligent text quotes' menu item determines if the inserted text is an
intelligent quote, or the default character.
:p.You can also insert intelligent 'single quotes', but to do this you must press
Alt+<'>. This is to avoid confusion with the apostrophe seen in the word l'eau (French),
or the word it's (English). There is otherwise no way of distinguishing between the two
usages.
:p.Other quote types, such as guillemets, are not part of the intelligent quotes feature.
:Note.This feature is disabled if the codepage does not support the required characters.
It is the reason why 1208 unicode is used as the default codepage for new text objects.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=68 id=68 global.Text justification
:i2 refid=cellsmnu.Text justification
:p.Unlike the text handler, the tables handler can justify text both
vertically and horizontally. It can do this because a text container is always
rectangular, and does not exclude overlapping frames.
:p.In replace mode, the handler will alter the justification of every text
container within the current selection. This is a very effective way of
justifying a numeric column of numbers to the right, for example.
.*-----------------------------------------------------------------------------
:h2 res=55 id=55 global.Character direction
:i2 refid=cellsmnu.Character direction
:p.Character direction determines the orientation of the individual characters
that make up a line.
:p.This dialog will automatically adjust the text orientation and stroke
direction to match the character direction you choose.
:p.If you imagine that the text orientation is from left to right, then the
strokes can be stacked from the top down, or the bottom up. You can achieve
the latter effect by using a reverse stroke direction.
:p.If you check the 'Save as default' button the information is written to
Maul Publisher's initialisation profile, and all new text containers will be
created with this style.
.*-----------------------------------------------------------------------------
:h2 res=44 id=44 global.Paragraph settings
:i2 refid=cellsmnu.Paragraph settings
:p.Paragraph settings affect the positioning of an entire paragraph.
:p.If you have highlighted several paragraphs, the highlighted paragraphs will be
altered, otherwise only the current paragraph settings are altered.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are
satisfied with the results.
:p.If you check the 'Save as default button' the indenting information is
written to Maul Publisher's initialisation profile, and all new text
containers will be created with the same indent setting.
:p.:hp2.Paragraph indents:ehp2.
:p.Paragraph settings allow you to set the indenting and leading of a
paragraph. A paragraph in this instance is a formatted block of text covering
one or more lines. You can independently alter the indentation of the first
line of the paragraph to allow you to create a neat text layout. Both left and
right indentation are supported.
:p.Enter in each field you wish to change a number followed by the measurement
type. i.e. 0.5in.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and
dpt (1/10 pt). There are 25.4 mm to the inch, and 72.2818 points to the inch.
If you give the size without a
measurement type, the value is considered to be in printer pels. The actual
values are stored as points, and are accurate to 1/65536 of a point.
.*-----------------------------------------------------------------------------
:h2 res=60 id=60 global.Set paragraph bullets
:i2 refid=cellsmnu.Set paragraph bullets
:p.Use bullets to create simple numbered or bulleted lists. Bullets require the use of unicode or DBCS codepages
that contain the necessary characters.
:p.Clicking on one of the bullet list buttons will create a default bulleted or numbered list. By using the
menu, or by right clicking on one of the bullet list buttons, you will get the 'Bullets and lists' dialog.
:p.The default bullet points are the same as those commonly used by web browsers, but you can
deselect this option and choose your own character.
:p.Numeric bullet points can be displayed as letters or roman numerals, as well as numbers. They can also be
decorated using a variety of brackets or punctuation. By selecting a counter level, you can create
multi-level numeric lists as shown below.
:fig.
1 cars.
2 boats,
    a rowing.
    b sailing.
    c pedal.
3 bikes.
4 airplanes.
:efig.
:p.The bullet settings are stored with the paragraph.
:p.This is not the only way to create lists.
You can also use :link reftype=hd res=46.control text:elink., or you can manually create bulleted
lists by setting the appropriate :link reftype=hd res=44.paragraph:elink. indenting, and by inserting
your own character or inline image as a bullet.
.*-----------------------------------------------------------------------------
:h2 res=45 id=45 global.Line Settings
:i2 refid=cellsmnu.Line Settings
:p.Line parameters affect the positioning of an individual line. Line
parameters are somewhat volatile. If you change the width of a frame, a
paragraph may contain fewer lines. In such a case, the excess line parameters
are deleted, along with your carefully chosen settings. If you then make the
frame narrower, extra lines will be added, and these new lines will copy their
settings from the last of the previous lines.
:p.The tables handler will apply line parameters to the entire text container,
and in replace mode can alter the settings for an entire selection of
containers.
:p.You can set both vertical and horizontal text justification using the radio
buttons provided.
:p.Line leading is measured in a percentage of the current maximum character
height.
:p.The measurement types allowed are mm, cm, m, in, din (1/10 inch), pt, and
dpt (1/10 pt). There are 25.4 mm to the inch, and 72.2818 points to the inch.
If you give the size without a
measurement type, the value is considered to be in printer pels. The actual
value is stored as points, and is accurate to 1/65536 of a point.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are
satisfied with the results.
:p.If you check the 'Save as default button' the information is written to
Maul Publisher's initialisation profile, and all new text containers will be
created with this style.
.*-----------------------------------------------------------------------------
:h2 res=47 id=47 global.Line tabs
:i2 refid=cellsmnu.Line tabs
:p.When you create a tab table, that table is inserted into the text file and
is valid until you add a different tab table. Tab tables allow you to setup
odd tab settings for a given block of text.
:p.When the tabs dialog is created, a ruler is drawn using the current rule
settings for the main window. You can set or clear a tab on any one of the
ruler tickmarks by clicking on it with the mouse.
:p.The number of tabs you can have is limited to about 60 tabs.
:p.The tab values are stored as points, and are accurate to 1/65536 of a
point. (There are 72.2818 points to the inch.)
.*-----------------------------------------------------------------------------
:h2 res=43 id=43 global.Character font
:i2 refid=cellsmnu.Character font
:p.Use the font dialog to choose a font. This dialog also allows you to alter
a number of settings that affect what the font looks like.
:p.Zoom in using the zoom buttons on the main window toolbar if the font
example is too small. If you have highlighted some text, this will be used as
a sample string.
:p.:hp2.Font:ehp2.
:p.First choose a font, the select one of the available styles.
:p.Use the font size combobox either to select a given font size, or to type
in your own.
:p.:hp2.Attributes:ehp2.
:p.The font attributes can also be used to make normal fonts bold or italic.
The fonts thus created may not be actual fonts, but synthesised fonts. You
should be aware that synthesised font attributes may cause unexpected results
if your publication is to be printed by a print shop. If you are printing from
your own PC, you can perform a short test print to see what you get.
:p.:hp2.Stretch:ehp2.
:p.Use the character spacing controls to alter the gap between characters, and
the character stretch controls to alter the average width of a character. You
can use the sliders or you can enter a number into the appropriate entryfield.
:p.Both spacing and stretch are specified as a percentage of the average text
width.
:p.:hp2.Shear:ehp2.
:p.Character shear affects the tilt of the characters. It is one way to create
italic text for example. :p.Use the rotary control or the entryfield to enter
an angle in degrees. The status display shows the vertice angle, that is the
angle of the vertical portion of the text, and takes into account the current
rotation factors.
:p.:hp2.Reset:ehp2.
:p.Press the reset button to reset all the the controls back to the current
settings.
:p.:hp2.Save as default:ehp2.
:p.If you check the 'Save as default button' the information is written to
Maul Publisher's initialisation profile, and all new text frames will be
created with this style.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are
satisfied with the results.
:p.If you have highlighted text, the highlighted text will be altered,
otherwise only the current text settings are altered. These text setting do
not come into effect unless you insert new text.
.br
.br
.*-----------------------------------------------------------------------------
:h2 res=51 id=51 global.Character Kerning
:i2 refid=cellsmnu.Character Kerning
:p.:hp2.About kerning:ehp2.
:p.Kerning is used to adjust the gap between certain character pairs in order
to make words look more balanced. Classic examples of kerning include moving
the letters Y and o closer together. Otherwise, it looks as if there is a
space between them.
:p.Kerning relies on kerning tables built into the current font. The kerning
table for one font may well be different to the kerning table for another. If
no kerning table is found, no kerning takes place.
:p.:hp2.Kerning dialog:ehp2.
:p.Use the character kerning dialog to determine when kerning takes place. If
you have highlighted text, the highlighted text will be altered, otherwise only the
current text settings are altered. These text setting do not come into effect
unless you insert new text.
:p.You can use the dropdown list or the entryfield of the combobox to enter a
minimum point size for kerning.
:p.Click the checkbox to enable or disable kerning for the selected text.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are
satisfied with the results.
:p.If you check the 'Save as default button' the information is written to
Maul Publisher's initialisation profile, and all new text containers will be
created with this style.
.*-----------------------------------------------------------------------------
:h2 res=52 id=52 global.Character Dropshadow
:i2 refid=cellsmnu.Character Dropshadow
:p.You can use text dropshadows to highlight a text string, or title. Dropshadows
use a dropshadow colour to draw a dropshadow string beneath the text string.
The default dropshadow uses a mid gray colour, and is offset by 7% to the
bottom right of the text.
:p.If you are happy with the default settings, just clicking on the dropshadow
button is sufficient to enable drop shadows. There are, however, a couple of
gotcha's.
:p.First, if the dropshadow colour is disabled, the drop shadow will be
invisible. Similarly, if the dropshadow offset is set to zero, the dropshadow
will be hidden from view.
:p.By using the 'Character Dropshadow...' dialog, you get considerably greater
control over the dropshadow. Use this dialog to set the colour, the offset
percentage, and the offset direction of the dropshadow. The offset percentage
is based on the height of the maximum ascender, usually the height of a
capital 'H'.
:p.If you have highlighted text, the highlighted text will be altered, otherwise only
the current text settings are altered. These text setting do not come into
effect unless you insert new text.
:p.Click on 'Apply' to apply the new settings. Click on 'Exit' when you are
satisfied with the results.
:p.If you check the 'Save as default button' the information is written to
Maul Publisher's initialisation profile, and all new text containers will be
created with this style.
.*-----------------------------------------------------------------------------
:h2 res=50 id=50 global.Select superscript or subscript
:i2 refid=cellsmnu.Select superscript or subscript
:p.Use superscript or subscript buttons or menu items to create superscript or
subscript text items. You should not attempt to set the emphasis of an entire
article as this can badly affect the text formatting.
.*-----------------------------------------------------------------------------
:h2 res=48 id=48 global.Mark a string for title extraction
:i2 refid=cellsmnu.Mark a string for title extraction
:p.Use the 'Title extraction' dialog to mark a string as a title for creating
a contents list of your publication later on.
:p.Select a titling level. 0 turns off the title marking. 1 is the top or
highest title level, and 8 is the lowest. Click on 'Ok' to set the current
titling level.
:p.If you have highlighted text, the highlighted text will be altered, otherwise only
the current text settings are altered. These text setting do not come into
effect unless you insert new text.
:p.A marked title looks no different to an unmarked title, so you won't see
any difference in the text. You will however see the current level shown in
the cursor status and position field of the status bar.
:p.Be careful not to inadvertently mark the whole article as a title. If the
title is set to a certain level, any text that you add will be set to the
current level. When you subsequently extract the contents, you get rather more
than you bargained for!
.*-----------------------------------------------------------------------------
:h2 res=100 id=100 global.Editing stylesheets
:i2 refid=cellsmnu.Editing stylesheets
:p.Use the 'Add to style list' dialog to save or delete a table style. The
actual table style saved is the currently selected containers. You can :link
reftype=hd res=16.restrict:elink. the container types saved in
the stylesheet using the restrictions set in the edit menu.
:p.The tables handler will save all available container styles as child styles,
so that they can also be used by other handlers that recognise those styles.
This means that the text handler can read and use a text child style set by the tables handler.
The actual child styles saved depends on the selected containers, and the restrictions in place.
:p.If you check the 'Save as default' button the information is written to Maul Publisher's initialisation
profile, and all new table frames will be created with this style.
.******************************************************************************
:h1 res=500 id=500 global.The status bar
:i1 id=statbar.The status bar
:p.The status bar section added by the tables handler consist of four items.
:p.The first status item, as usual, indentifies the tables handler.
:p.:hp2.Selected table range:ehp2.
:p.The second status item shows the currently selected range. This consists of
a sheet identifier, followed by a cell or range selection. This handler does
not support multiple sheets at this time, so the sheet ident will always be
:hp2.A&colon.:ehp2.. If nothing is selected, the selection is empty
:hp2.A&colon.<--->:ehp2.. If only one cell is selected, the cell is shown
:hp2.A&colon.A0:ehp2., otherwise, the range is shown :hp2.A&colon.A0..B1:ehp2..
:p.:hp2.Text cursor position:ehp2.
:p.The third item is the text cursor position. The text cursor status
information contains a number of useful indicators. The format is as follows&colon.-
:p.:hp2.L<line number><lolflag><textposition>,<titlemark><tablist>:ehp2.
:p.The line number is fairly self explanatory, as is the text position. These
two numbers indicate the row and column of the current cursor position.
:p.:hp1.The lolflag:ehp1.
:p.Not so obvious is the lolflag. A lol is an invisible data block that causes
a change in the text style between the previous character, and the next. When
you position the cursor at the junction between two text styles, you can
either add text in the previous style (the default), or the next style. If you
wish to edit in the previous style you must be positioned before the lol, if
you wish to edit in the next style you must be positioned after the lol.
:p.To leap over a lol (lol means 'leap over lol') hold down the alt key and
press the right cursor button on the keyboard. To go to the start of the lol,
press the left cursor button on the keyboard.
:p.If you are at the start of a lol (the default), the lolflag will be a colon
"&colon."; if you are at the end of a lol, the lolflag will change to a "*".
:p.:hp1.The titlemark:ehp1.
:p.If the cursor is positioned within a marked title, the titlemark will be a
number from 0 to 8. Otherwise it will be a "." to indicate no title mark. A
titlemark of level 0 is not extracted. All titles should be separated by a
level 0 portion of text.
:p.:hp1.The tablist:ehp1.
:p.If there is a valid tablist lol before the current cursor position, the
fact will be indicated with a "t". Otherwise a "." will be shown to indicate
that there is no valid tablist at this point in the frame.
:p.:hp2.Font status information:ehp2.
:p.The last status bar item indicates the exact name of the current font,
whereas the font name given in the buttonbar listbox is the family name of a
family of fonts.
:p.Thus the buttonbar listbox may say 'Arial' to indicate the Arial font
family, and the status bar may say 'Arial Bold' to indicate the actual current
font from within the Arial font family.
:p.The other difference is that this fontname is read from the file data, and
if a font is missing from your system, the display shows the name of the
expected font. In this case the status display adds a (?) to the start of the
font name. When this happens, there is no longer a relationship between the
font listed on the button bar, and the font shown in the status display.
:p.So the button bar may say 'Times New Roman', but the status display could
say '(?)Helv bold'. This shows that the 'Helv bold' font is needed, but is not
available on your system.
.br
.******************************************************************************
:h1 res=700 id=700 global.The Tables Import handler
:i1 id=import.The Tables Import handler
:p.The table import handler is unusual in that it enables the import of every
object data format available to Maul Publisher. This is necessary because a
table can contain a variety of different data types.
:p.The data is always imported into the current selection, but be careful
because no selection is treated as if the entire table is selected.
:p.If the entire table is selected, and the imported data format supports it,
the entire table will be replaced.
:p.Where this is not possible, the table import handler will do it's best to
fit the data into the selected range. If the range to be imported is greater
than the selected range, some data to be imported will be lost. If the entire
table is selected, this behaviour is modified to change the number of rows and
columns in the table so that the new data fits perfectly, in other words, the
existing table is replaced.
:p.Maul's import mechanism is used to provide conversion of all the different
data formats, so that if new import handlers become available, so the table
will support them.
.br
.******************************************************************************
:h1 res=600 id=600 global.The Tables handler keyboard shortcuts
:i1 id=keys.The Tables handler keyboard shortcuts
:p.The following keys are available with this handler. The most common keys are listed, but keys specific to other
handlers are not listed. Select a frame and handler you require information on, and then try keys help again.
:p.If no frame is selected, the main keys help for Maul Publisher is shown.
:p.Please note that keyboard shortcuts are editable, and thus may not correspond to the settings listed here.
The keys shown here are the default settings.
:p.:hp2.General key usage:ehp2.
:ol.
:li.:hp2.Menu selection:ehp2.
:dl compact tsize=16.
:dt.Alt+E:dd.Edit menu
:dt.Alt+F:dd.File menu
:dt.Alt+H:dd.Help menu
:dt.Alt+O:dd.Options menu
:dt.Alt+P:dd.Page menu
:dt.Alt+U:dd.Undo menu
:dt.Alt+V:dd.View menu
:dt.Alt+W:dd.Switch to (switch list)
:edl.
:li.:hp2.File menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+N:dd.New file
:dt.Ctrl+O:dd.Open file...
:dt.Ctrl+I:dd.Import...
:dt.Ctrl+X:dd.Export...
:dt.Ctrl+S:dd.Save file
:dt.Ctrl+A:dd.Save file as...
:dt.Ctrl+R:dd.Print file...
:edl.
:li.:hp2.Page menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+P:dd.Print page setup...
:dt.Ctrl+M:dd.Margins and grids...
:dt.Ctrl+Shift+M:dd.Use master page..
:dt.Ctrl+T:dd.Save/delete master page
:dt.Alt+Shift+Del:dd.Copy a page
:dt.Alt+Shift+Ins:dd.Paste a page
:dt.Ctrl+Shift+I:dd.Insert a page
:dt.Ctrl+Shift+J:dd.Insert new first page
:dt.Ctrl+Shift+D:dd.Delete a page
:dt.Alt+G:dd.Goto page
:dt.Ctrl+Shift+N:dd.Next page
:dt.Ctrl+Shift+P:dd.Previous page
:edl.
:li.:hp2.View menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+1:dd.Printer Page view
:dt.Ctrl+2:dd.Page view
:dt.Ctrl+3:dd.Fit width
:dt.Ctrl+4:dd.Actual size
:dt.Ctrl+Plus:dd.Zoom in
:dt.Ctrl+Minus:dd.Zoom out
:dt.Ctrl+F:dd.Frame edit mode
:dt.Ctrl+C:dd.Contents edit mode
:dt.Ctrl+G:dd.Background edit mode
:dt.Ctrl+B:dd.Border edit mode
:edl.
:li.:hp2.Undo menu:ehp2.
:dl compact tsize=16.
:dt.Alt+Backspace:dd.Undo last action
:dt.Ctrl+Backspace:dd.Redo last action
:dt.Ctrl+U:dd.Undo list...
:edl.
:li.:hp2.Options menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Shift+R:dd.Printer setup...
:dt.Ctrl+E:dd.Snap enable
:dt.Ctrl+Shift+S:dd.Snap settings...
:edl.
:li.:hp2.Help menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+H:dd.Help contents
:dt.Ctrl+Shift+H:dd.Help index
:dt.Ctrl+K:dd.Keys help
:dt.Ctrl+L:dd.List all handlers
:dt.Ctrl+Z:dd.About...
:edl.
:eol.
:p.:hp2.Tables handler key usage:ehp2.
:ol.
:li.:hp2.Edit menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Alt+0:dd.Restrict items to any containers
:dt.Ctrl+Alt+1:dd.Restrict items to border containers
:dt.Ctrl+Alt+2:dd.Restrict items to fill containers
:dt.Ctrl+Alt+3:dd.Restrict items to bitmap containers
:dt.Ctrl+Alt+4:dd.Restrict items to metafile containers
:dt.Ctrl+Alt+5:dd.Restrict items to frame clipart containers
:dt.Ctrl+Alt+6:dd.Restrict items to text containers
:dt.Shift+Delete:dd.Cut items
:dt.Ctrl+Insert:dd.Copy items
:dt.Shift+Insert:dd.Paste items
:dt.Ctrl+D:dd.Load items
:dt.Delete:dd.Clear items
:dt.:dd.
:dt.Ctrl+Shift+/:dd.Select whole table
:dt.Ctrl+Alt+C:dd.Show/edit container ranges...
:dt.:dd.
:dt.F5:dd.Set table size...
:dt.<none>:dd.Insert Row
:dt.<none>:dd.Delete Row
:dt.<none>:dd.Insert Column
:dt.<none>:dd.Delete Column
:dt.<none>:dd.Equalise row spacing
:dt.<none>:dd.Equalise column spacing
:dt.Ctrl+Alt+Q:dd.Equalise both
:dt.F3:dd.Insert container mode
:dt.F4:dd.Edit text
:dt.:dd.
:dt.<none>:dd.Insert character...
:dt.Ctrl+Shift+Space:dd.Insert line flush break
:dt.Ctrl+Alt+E:dd.Insert object/settings...
:dt.Ctrl+Shift+Q:dd.Insert control text...
:dt.<none>:dd.Select merge row...
:dt.Ctrl+Alt+F:dd.Find text...
:dt.Ctrl+Alt+O:dd.Count words...
:dt.F2:dd.Check text spelling...
:dt.Alt+Del:dd.Remove handler
:edl.
:li.:hp2.Cell styles menu:ehp2.
:dl compact tsize=16.
:dt.Ctrl+Alt+U:dd.Border linestyles...
:dt.Ctrl+Shift+W:dd.Border width...
:dt.Ctrl+Shift+K:dd.Border colour...
:dt.:dd.
:dt.Ctrl+Shift+L:dd.Fill colour...
:dt.Ctrl+Alt+V:dd.Advanced shading modes...
:dt.Ctrl+Alt+P:dd.Fill pattern...
:dt.Alt+R:dd.Fill orientation...
:dt.:dd.
:dt.Ctrl+Shift+Y:dd.Maintain bitmap shape
:dt.<none>:dd.Scale bitmap...
:dt.:dd.
:dt.Ctrl+Shift+Z:dd.Maintain metafile shape
:dt.<none>:dd.Scale metafile...
:dt.:dd.
:dt.:dd.Text codepage...
:dt.Alt+T:dd.Vertical text alignment top
:dt.Alt+M:dd.Vertical text alignment middle
:dt.Alt+B:dd.Vertical text alignment bottom
:dt.Ctrl+Shift+O:dd.Character direction...
:dt.Ctrl+Shift+G:dd.Paragraph settings...
:dt.Ctrl+Alt+L:dd.Line Settings...
:dt.Ctrl+Alt+T:dd.Line tabs...
:dt.Ctrl+Shift+F:dd.Character font...
:dt.Ctrl+Shift+C:dd.Character colour...
:dt.Ctrl+Alt+K:dd.Character Kerning...
:dt.Ctrl+Alt+D:dd.Character Dropshadow...
:dt.Ctrl+Shift+U:dd.Select superscript
:dt.Ctrl+Shift+B:dd.Select subscript
:dt.Ctrl+Shift+X:dd.Set to title text...
:dt.:dd.
:dt.Ctrl+Alt+S:dd.Predefined cell styles
:dt.Ctrl+Alt+A:dd.Add to cell styles...
:edl.
:eol.
:p.:hp2.Text hyphenation&colon.-:ehp2.
:dl compact tsize=16.
:dt."-":dd.The minus character (not on the numeric keypad!) is the default hyphen character.
:dt.Alt+"-":dd.The minus character (not on the numeric keypad!) with the Alt key forms a
speculative hyphen character. The character only appears if the word happens to be hyphenated
at that point. Speculative hyphens override automatically generated ones.
.br
To remove a speculative hyphen, position the cursor to the left of the hyphen, press Alt+Right, then press backspace.
:edl.
:p.:hp2.Intelligent text quotes&colon.-:ehp2.
:dl compact tsize=16.
:dt."'":dd.Inserts a single apostrophe. Intelligent text quotes are not used.
:dt.Alt+"'":dd.Inserts a single intelligent text quote. The shape of the quote is determined by the selected 
language and its position within the text.
:edl.
:p.:hp2.Non breaking punctuation&colon.-:ehp2.
:p.Any character recognized as punctuation, or the space character, can be marked as non-breaking.
The formatter will not use the character to indicate a possible linebreak, and will treat all such
characters as normal text instead. For example&colon.-
:dl compact tsize=16. 
:dt." ":dd.Inserts a space character.
:dt.Ctrl+Alt+" ":dd.Inserts non breaking space character.
:edl.
:p.:hp2.Tabs&colon.-:ehp2.
:dl compact tsize=16.
:dt.Tab:dd.Inserts a tab, the tab will move the next word to the start of the tab.
:dt.Shift+Tab:dd.Inserts a right justified or numeric tab.
If the next word contains a decimal point or comma (and is a number), the text will align to it.
Otherwise, the text will align to the end of the next word.
:edl.
.br
.br
:euserdoc.
