/******************************************************************************
    Frame handler resources
    (c)Peter Koller 1998
******************************************************************************/
#ifndef BORDERHAND_RESOURCES
#define BORDERHAND_RESOURCES

#define     PROF_STYLESHEET     ",ssh"
#define     PROF_LOADIMG        ",loadstyle"
#define     DEF_STYLESHEET      "*"
#define     EXT_STYLESHEET		".ssh"

/*******************************************************************************
    RCDATA descriptions
*******************************************************************************/
#define IDACC_DEFLTKEYS         40

/*******************************************************************************
    Help
*******************************************************************************/

/*******************************************************************************
    String resources
*******************************************************************************/
#define IDS_HELPWINTITLE    16  //"Maul plain borders Help"
#define IDS_HELPLIBRARY     17  //"bordhand.hlp"
#define UNDO_INIT_ID        18  //"new border"
#define UNDO_WIDTH_ID       19  //"set border width"
#define UNDO_COLOR_ID       20  //"set border colour"
#define UNDO_PATTERN_ID     21  //"set border pattern"
#define UNDO_PASTE_ID       22  //"paste border"
#define UNDO_CUT_ID         23  //"cut border"
#define UNDO_CLEAR_ID       24  //"remove border handler"
#define UNDO_SETTS_ID       25  //"border settings"

#define UNDO_SHADE_ID       26  //"change border shading mode"

#define UNDO_REFORMAT_ID    30  //"update border to V1.10"
#define UNDO_ADDCOLOR_ID    31  //"edit border shading colour list"
#define UNDO_LINEST_ID      32  //"change border line style"
#define UNDO_SEGMENT_ID     33  //"change border start segment"
#define IDS_UPDATEBORDERR   34  //"Error updating border to V1.10, delete border and start again"
#define IDS_CLIPBD_ERR      35  //"Error - failed to save clipboard data"
#define UNDO_TAPER_ID       36  //"change border tapering"
#define UNDO_ADVANCED_ID    37  //"change border advanced"
#define UNDO_OFFSET_ID      38  /* "change border offset" */
#define UNDO_OBJSCALE_ID    39  /* "change border scale" */

#define IDFH_EDITTASK       40  //"Select border editing tasks"
#define IDFH_HANDIDENT      41  //"Colour outline handler is active"
#define IDFH_LINEWIDTH      42  //"Set the border line width"
#define IDFH_COLOURS        43  //"Set the border colours"
#define IDFH_LINEMODE       44  //"Select line shading mode"

#define IDFH_PATTERN        46  //"Set the border fill pattern"
#define IDFH_BEVELLED       47  //"Use bevelled corners"
#define IDFH_ROUNDED        48  //"Use rounded corners"
#define IDFH_MITRED         49  //"Use mitred corners"
#define IDFH_LINEEND        50  //"Choose line end"
#define IDFH_LINESTYLE      51  //"Choose line style"
#define IDFH_LINESTART      52  //"Choose line start"
#define IDFH_FILLOFFSET     53  //"Offset the border"
#define IDS_HANDLERTYPE     54  //"Border"
#define IDS_HANDLERNAME     55  //"Border handler"
#define IDS_IMPORTNTYPE     56  //"Border"
#define IDS_IMPORTNNAME     57  //"Import border from clipboard"
#define IDFH_WIDTHSTAT      58  //"Border width"

#define IDS_SETSTYLE		80  //"add handler style data"
#define IDS_STYLE_DELETE	81  //"Delete this style sheet"
#define IDS_STYLE_EXISTS	82  //"Style sheet exists, overwrite"
#define IDS_NOSTYLESHEET	83  //"No stylesheet is selected"
#define IDS_AUTOBORDER		84  //"<auto>"
#define IDS_USEDEFAULT		85  //"use default"

//***** copied from language\src\maul\resource.h
#define IDFH_COLORSWATCH    1113  //"Click here for more..."

/*******************************************************************************
    bitmaps
*******************************************************************************/
#define IDBMP_BORDER        1000

/**** Toolbar buttons ****/
#define IDBMP_COLOFILL      1001
#define IDBMP_PATTERNF      1002
#define IDBMP_LINEWDTH      1003
#define IDBMP_PLAINCOL      1004
#define IDBMP_MULTICOL      1005
#define IDBMP_MULTIREV      1006
#define IDBMP_EXTRUDE       1007
#define IDBMP_OFFSET	    1008

/**** Line Joins ****/
#define IDBMP_LJBEVEL       1010
#define IDBMP_LJROUND       1011
#define IDBMP_LJMITRE       1012

/**** Line Ends ****/
#define IDBMP_LBORDFLAT     1015
#define IDBMP_LBORDROUND    1016
#define IDBMP_LBORDARRSM    1017
#define IDBMP_LBORDARROW    1018
#define IDBMP_LBORDARRLG    1019
#define IDBMP_LBORDBALL     1020
#define IDBMP_LBORDBALLCT   1021
#define IDBMP_LBORDRINGCT   1022
#define IDBMP_LBORDTBAR     1023
#define IDBMP_LBORDDIAM     1024
#define IDBMP_LBORDDIAMCT   1025

#define IDBMP_RBORDFLAT     1030
#define IDBMP_RBORDROUND    1031
#define IDBMP_RBORDARRSM    1032
#define IDBMP_RBORDARROW    1033
#define IDBMP_RBORDARRLG    1034
#define IDBMP_RBORDBALL     1035
#define IDBMP_RBORDBALLCT   1036
#define IDBMP_RBORDRINGCT   1037
#define IDBMP_RBORDTBAR     1038
#define IDBMP_RBORDDIAM     1039
#define IDBMP_RBORDDIAMCT   1040

/**** Line Styles ****/
#define IDBMP_LSPLAIN       1045
#define IDBMP_LSDASH        1046
#define IDBMP_LSDASHDD      1047
#define IDBMP_LSDOT         1048
#define IDBMP_LSDOTDOT      1049
#define IDBMP_LSDSHDOT      1050
#define IDBMP_LSSHDASH      1051
#define IDBMP_LSBLOB        1052
#define IDBMP_LSCUSTOM      1053
#define IDBMP_LSNONE        1054

/*******************************************************************************
    dialogs
*******************************************************************************/
#define HELP_BUTTON             100
#define PATTERN_SELECT_DLG		110
#define PATTERN_SELECT_NONE		111
#define PATTERN_SELECT_1		112
#define PATTERN_SELECT_2		113
#define PATTERN_SELECT_3		114
#define PATTERN_SELECT_4		115
#define PATTERN_SELECT_5		116
#define PATTERN_SELECT_6		117
#define PATTERN_SELECT_7		118
#define PATTERN_SELECT_8		119
#define PATTERN_SELECT_9		120
#define PATTERN_SELECT_10		121
#define PATTERN_SELECT_11		122
#define PATTERN_SELECT_12		123
#define PATTERN_SELECT_13		124
#define PATTERN_SELECT_14		125
#define PATTERN_SELECT_15		126
#define PATTERN_SELECT_16		127

#define WIDTH_DLG				130
#define WIDTH_ENTRY				131
#define WIDTH_STAT				133
#define WIDTH_DLG2				134
#define WIDTH_USELOCAL			135

#define SHADING_DLG             140
#define SHADING_ADD             141
#define SHADING_DEL             142
#define SHADING_UP              143
#define SHADING_DOWN            144
#define SHADING_LIST            145
#define SHADING_COLOR          	146
#define SHADING_WHEEL          	147
#define SHADING_COLIST         	148
#define SHADING_SPOTS          	149

#define LINESTYLEDLG			150
#define LINES_ENTRY				151

#define ORIGIN_DLG				155
#define IDD_ORIGIN_ENTRY		156
#define IDD_ORIGIN_CTRL			157
#define IDD_ORIGIN_SHIFT		158
#define IDD_ORIGIN_STATS		159

#define	IDD_ADVSHADEDLG			160
#define	IDD_ADVSHADEXFADE		161
#define	IDD_ADVSHADENORM		162
#define	IDD_ADVSHADECIRCLE		163
#define	IDD_ADVSHADECLOCK		164
#define	IDD_ADVSHADERUNIN		165
#define	IDD_ADVSHADERUNOUT		166
#define	IDD_ADVSHADERINSTAT		167
#define	IDD_ADVSHADEROUTSTAT	168

#define	IDD_OFFSETDLG			170
#define	IDD_OFFSETENTRY			171
#define IDD_ROTATEACTUAL        172
#define IDD_ROTATEENTRY         173
#define IDD_ROTATECONTROL       174

#define IDD_STYLE_DLG			180
#define IDD_STYLE_ENTRY			181
#define IDD_STYLE_DELETE		182
#define IDD_STYLE_GROUPBOX		183

#define	IDD_EXTRUDEDLG			190
#define	IDD_EXTRUDERSTRK		191
#define	IDD_EXTRUDELIGHT		192
#define	IDD_EXTRUDERLIGHT		193

/*******************************************************************************
    Menus
*******************************************************************************/
#define BORD_CUT                (FIRST_MENU_ID + 1)
#define BORD_COPY               (FIRST_MENU_ID + 2)
#define BORD_PASTE              (FIRST_MENU_ID + 3)
#define BORD_CLEAR              (FIRST_MENU_ID + 4)

#define BORD_COLOR              (FIRST_MENU_ID + 5)
#define BORD_ADVANCEDCLR        (FIRST_MENU_ID + 6)
#define BORD_LJOIN              (FIRST_MENU_ID + 7)
#define BORD_LPATT              (FIRST_MENU_ID + 8)
#define BORD_LEND               (FIRST_MENU_ID + 9)
#define BORD_LWIDTH             (FIRST_MENU_ID + 10)
#define BORD_LSHADE             (FIRST_MENU_ID + 11)
#define BORD_LSHADER            (FIRST_MENU_ID + 12)
#define BORD_EXTRUDE            (FIRST_MENU_ID + 13)
#define BORD_LINESTYLE          (FIRST_MENU_ID + 14)
#define BORD_STARTSEGMENT       (FIRST_MENU_ID + 15)
#define BORD_TAPERSTROKE        (FIRST_MENU_ID + 16)
#define BORD_SAVESTYLE			(FIRST_MENU_ID + 17)
#define BORD_OFFSET     		(FIRST_MENU_ID + 18)


#define BORD_ENDS_MENU          (FIRST_MENU_ID + 20)
#define BORD_END_FLAT           (BORD_ENDS_MENU + 1)
#define BORD_END_ROUND          (BORD_ENDS_MENU + 2)
#define BORD_END_ARRSM          (BORD_ENDS_MENU + 3)
#define BORD_END_ARROW          (BORD_ENDS_MENU + 4)
#define BORD_END_ARRLG          (BORD_ENDS_MENU + 5)
#define BORD_END_BALL           (BORD_ENDS_MENU + 6)
#define BORD_END_BALLCT         (BORD_ENDS_MENU + 7)
#define BORD_END_RINGCT         (BORD_ENDS_MENU + 8)
#define BORD_END_TBAR           (BORD_ENDS_MENU + 9)
#define BORD_END_DIAM           (BORD_ENDS_MENU + 10)
#define BORD_END_DIAMCT         (BORD_ENDS_MENU + 11)

#define BORD_LS_MENU            (FIRST_MENU_ID + 40)
#define BORD_LSPLAIN            (BORD_LS_MENU + 1)
#define BORD_LSDASH             (BORD_LS_MENU + 2)
#define BORD_LSDASHDD           (BORD_LS_MENU + 3)
#define BORD_LSDOT              (BORD_LS_MENU + 4)
#define BORD_LSDOTDOT           (BORD_LS_MENU + 5)
#define BORD_LSDSHDOT           (BORD_LS_MENU + 6)
#define BORD_LSSHDASH           (BORD_LS_MENU + 7)
#define BORD_LSBLOB             (BORD_LS_MENU + 8)
#define BORD_LSCUSTOM           (BORD_LS_MENU + 9)
#define BORD_LSNONE             (BORD_LS_MENU + 10)

#define PATTERN_MENU_ID			(FIRST_MENU_ID + 60)
#define PATMENU_SELECT_NONE		(PATTERN_MENU_ID + 1)
#define PATMENU_SELECT_1		(PATTERN_MENU_ID + 2)
#define PATMENU_SELECT_2		(PATTERN_MENU_ID + 3)
#define PATMENU_SELECT_3		(PATTERN_MENU_ID + 4)
#define PATMENU_SELECT_4		(PATTERN_MENU_ID + 5)
#define PATMENU_SELECT_5		(PATTERN_MENU_ID + 6)
#define PATMENU_SELECT_6		(PATTERN_MENU_ID + 7)
#define PATMENU_SELECT_7		(PATTERN_MENU_ID + 8)
#define PATMENU_SELECT_8		(PATTERN_MENU_ID + 9)
#define PATMENU_SELECT_9		(PATTERN_MENU_ID + 10)
#define PATMENU_SELECT_10		(PATTERN_MENU_ID + 11)
#define PATMENU_SELECT_11		(PATTERN_MENU_ID + 12)
#define PATMENU_SELECT_12		(PATTERN_MENU_ID + 13)
#define PATMENU_SELECT_13		(PATTERN_MENU_ID + 14)
#define PATMENU_SELECT_14		(PATTERN_MENU_ID + 15)
#define PATMENU_SELECT_15		(PATTERN_MENU_ID + 16)
#define PATMENU_SELECT_16		(PATTERN_MENU_ID + 17)

#define BORD_LMODE_MENU         (FIRST_MENU_ID + 80)
#define BORD_LMPLAIN			(BORD_LMODE_MENU + 1)
#define BORD_LMMULTI			(BORD_LMODE_MENU + 2)
#define BORD_LMMULTIR			(BORD_LMODE_MENU + 3)
#define BORD_LMEXTRUDE			(BORD_LMODE_MENU + 4)

#define	BORD_LOADSTYLE          (FIRST_MENU_ID + 90)

/*******************************************************************************
    buttons
*******************************************************************************/
#define     IDB_LINEWIDTH       FIRST_BBAR_ID
#define     IDB_COLORFILL       (FIRST_BBAR_ID + 1)
#define     IDB_PATTERNFILL     (FIRST_BBAR_ID + 2)
#define     IDB_LEFTBORDEND     (FIRST_BBAR_ID + 3)
#define     IDB_RIGHTBORDEND    (FIRST_BBAR_ID + 4)
#define     IDB_LJOINBEVEL      (FIRST_BBAR_ID + 5)
#define     IDB_LJOINROUND      (FIRST_BBAR_ID + 6)
#define     IDB_LJOINMITRE      (FIRST_BBAR_ID + 7)
#define     IDB_LINEMODE        (FIRST_BBAR_ID + 8)

#define     IDB_LINESTYLE       (FIRST_BBAR_ID + 10)
#define     IDB_BORDOFFSET  	(FIRST_BBAR_ID + 11)

#endif
