/*
For general Scribus (>=1.3.2) copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Scribus 1.3.2
for which a new license (GPL+exception) is in place.
*/
/***************************************************************************
*   Copyright (C) 2007 by Franz Schmid                                     *
*   franz.schmid@altmuehlnet.de                                            *
*                                                                          *
*   This program is free software; you can redistribute it and/or modify   *
*   it under the terms of the GNU General Public License as published by   *
*   the Free Software Foundation; either version 2 of the License, or      *
*   (at your option) any later version.                                    *
*                                                                          *
*   This program is distributed in the hope that it will be useful,        *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
*   GNU General Public License for more details.                           *
*                                                                          *
*   You should have received a copy of the GNU General Public License      *
*   along with this program; if not, write to the                          *
*   Free Software Foundation, Inc.,                                        *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              *
****************************************************************************/

#ifndef PATHFINDER_H
#define PATHFINDER_H

#include <QColor>
#include "pluginapi.h"
#include "scplugin.h"
#include "selection.h"

/** \brief This is a simple "Path Finder" plugin for Scribus 1.3 and later.
\author Franz Schmid
\date October 2007
*/
class PLUGIN_API PathFinderPlugin : public ScActionPlugin
{
	Q_OBJECT

	public:
		// Standard plugin implementation
		PathFinderPlugin();
		virtual ~PathFinderPlugin();
		virtual bool run(ScribusDoc* doc, QString target = QString::null);
		virtual const QString fullTrName() const;
		virtual const AboutData* getAboutData() const;
		virtual void deleteAboutData(const AboutData* about) const;
		virtual void languageChange();
		virtual void addToMainWindowMenu(ScribusMainWindow *) {};

		// Special features (none)
};

#ifndef __OS2__
extern "C" PLUGIN_API int pathfinder_getPluginAPIVersion();
extern "C" PLUGIN_API ScPlugin* pathfinder_getPlugin();
extern "C" PLUGIN_API void pathfinder_freePlugin(ScPlugin* plugin);
#else
extern "C" PLUGIN_API int pathfind_getPluginAPIVersion();
extern "C" PLUGIN_API ScPlugin* pathfind_getPlugin();
extern "C" PLUGIN_API void pathfind_freePlugin(ScPlugin* plugin);
#endif

#endif
